/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.BOSRuntime;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.UserEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeQuickAddNewEvent;
import kd.bos.form.field.events.BeforeQuickAddNewListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.inte.api.EnabledLang;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.RouteMode;
import kd.bos.schedule.api.ShardingParam;
import kd.bos.schedule.api.TaskType;
import kd.bos.schedule.formplugin.ParamTypeEnum;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class JobPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener,
BeforeQuickAddNewListener {
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String ENTRYENTITY = "entryentity";
    private static final String MSG_NOTIFY_ENTITY = "msgnotifyentity";
    private static final String TASKCLASSNAME = "taskclassname";
    private static final String SKDJ = "_SKDJ";
    private static final String CLASSNAME = "classname";
    private static final String PARAMVALUE = "paramvalue";
    private static final String RUNBY_USER = "runbyuser";
    private static final String RUNBY_ORG = "runbyorg";
    private static final String PARAM_NAME = "paramname";
    private static final String PARAM_DESC = "paramdesc";
    private static final String MUST = "must";
    private static final String RUNMODE = "runmode";
    private static final String CANSTOP = "canstop";
    private static final String PARAMTYPE = "paramtype";
    private static final String BASEDATAINFO = "basedatainfo";
    private static final String VISIBLE = "visible";
    private static final String BASEDATAVALUE = "basedatavalue";
    private static final String BOS_SCHEDULE_FORMPLUGIN = "bos-schedule-formplugin";
    private static Log log = LogFactory.getLog((String)"kd.bos.schedule.formplugin.JobPlugin");
    private static final String NUM_ZERO = "0";
    private static final String NUM_ONE = "1";
    private static final String NUM_TWO = "2";
    private static final String RUNORDER = "runorder";
    private static final String RUNCONCURRENT = "runconcurrent";
    private static final String STRATEGY = "strategy";
    private static final String TIMEOUT = "timeout";
    private static final String RetryTime = "retrytime";
    private static final String SH_ENTRYENTITY = "sh_entryentity";
    private static final String SHAREPARAMS = "SHAREPARAMS";
    private static final String SHARENAME = "sharename";
    private static final String SHARECONDITION = "sharecondition";
    private static final String PARAMDEFCALLBACK = "paramdefCallBack";
    private static final String APPID = "appid";
    private static final String PARAMENTRY = "paramentry";
    private static final String PARAMVALUE_ORIGINSIGN = "paramvalue_originsign";
    private static Set bampMoveAppList = new HashSet(10);

    public void initialize() {
        OrgEdit orgEdit;
        super.initialize();
        UserEdit userEdit = (UserEdit)this.getView().getControl(RUNBY_USER);
        if (userEdit != null) {
            userEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((orgEdit = (OrgEdit)this.getView().getControl(RUNBY_ORG)) != null) {
            orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit control = (BasedataEdit)this.getView().getControl(TASKCLASSNAME);
        control.addBeforeQuickAddNewListener((BeforeQuickAddNewListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{PARAMVALUE});
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        HashMap<String, String> returnData = new HashMap<String, String>();
        returnData.put("isNeedRefresh", "false");
        e.setCheckDataChange(false);
        e.setSkipNoField(true);
        this.getView().returnDataToParent(returnData);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("DynamicCreateCardEntry", exp.getMessage()), new Object[0]);
        }
        e.setNewEntityType(newMainType);
        for (Map.Entry entityType : newMainType.getAllEntities().entrySet()) {
            if (!ENTRYENTITY.equals(entityType.getKey()) || ((EntityType)entityType.getValue()).getProperty(PARAMVALUE_ORIGINSIGN) != null) continue;
            ComboProp cbProp = new ComboProp();
            cbProp.setName(PARAMVALUE_ORIGINSIGN);
            cbProp.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u53c2\u6570\u503c\u6539\u53d8\u6807\u8bc6", (String)"JobPlugin_26", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])));
            cbProp.setDbIgnore(true);
            cbProp.setDefValue((Object)false);
            cbProp.setAlias("");
            ((EntityType)entityType.getValue()).registerSimpleProperty((DynamicSimpleProperty)cbProp);
        }
    }

    private boolean isFirstBindData() {
        String v = this.getView().getPageCache().get("isFirstBindData");
        return v == null ? true : Boolean.parseBoolean(v);
    }

    public void afterBindData(EventObject e) {
        String appid;
        DynamicObject taskClassName;
        RequestContext rs;
        super.afterBindData(e);
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl("runbylang");
        comboEdit.setComboItems(this.getAllLang());
        Boolean runconcurrent = (Boolean)this.getView().getModel().getValue(RUNCONCURRENT);
        String strategy = (String)this.getModel().getValue(STRATEGY);
        this.bindMsgnotify();
        if (runconcurrent.booleanValue()) {
            this.getModel().setValue(RUNORDER, (Object)NUM_ONE);
        } else {
            this.getModel().setValue(RUNORDER, (Object)NUM_ZERO);
            if (StringUtils.equals((CharSequence)NUM_ZERO, (CharSequence)strategy)) {
                this.getModel().setValue(STRATEGY, (Object)NUM_ONE);
            }
        }
        this.initParamEntry();
        if (this.isFirstBindData()) {
            this.getView().getPageCache().put("isFirstBindData", "false");
            if (StringUtils.isBlank((CharSequence)((String)this.getModel().getValue(RUNMODE)))) {
                this.getModel().setValue(RUNMODE, (Object)NUM_ZERO);
            }
            if (NUM_ZERO.equals((String)this.getModel().getValue(RUNORDER)) && StringUtils.isBlank((CharSequence)((String)this.getModel().getValue(STRATEGY)))) {
                this.getModel().setValue(STRATEGY, (Object)NUM_ONE);
            }
        }
        if (!this.hasPerm((rs = RequestContext.get()).getUserId())) {
            if (OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
                if (this.getModel().getValue(RUNBY_USER) == null) {
                    this.getModel().setValue(RUNBY_USER, (Object)Long.parseLong(rs.getUserId()));
                }
                if (this.getModel().getValue(RUNBY_ORG) == null) {
                    this.getModel().setValue(RUNBY_ORG, (Object)rs.getOrgId());
                }
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{RUNBY_USER, RUNBY_ORG});
        }
        if ((taskClassName = (DynamicObject)this.getModel().getValue(TASKCLASSNAME)) != null && StringUtils.isNotBlank((CharSequence)(appid = (String)taskClassName.get(APPID)))) {
            this.getModel().setValue(APPID, (Object)appid);
        }
    }

    private void bindMsgnotify() {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(MSG_NOTIFY_ENTITY);
        if (dynamicObjects != null && dynamicObjects.size() <= 0) {
            StringBuilder type = new StringBuilder();
            Boolean sfailnotify = (Boolean)this.getModel().getValue("failnotify");
            Boolean ssuccessnotify = (Boolean)this.getModel().getValue("successnotify");
            Boolean stimeout = (Boolean)this.getModel().getValue("overtime");
            Boolean saborted = (Boolean)this.getModel().getValue("aborted");
            if (sfailnotify.booleanValue()) {
                type.append("FAILED").append(",");
            }
            if (ssuccessnotify.booleanValue()) {
                type.append("COMPLETED").append(",");
            }
            if (stimeout.booleanValue()) {
                type.append("TIMEOUT").append(",");
            }
            if (saborted.booleanValue()) {
                type.append("ABORTED").append(",");
            }
            String snotifytype = (String)this.getModel().getValue("notifytype");
            String smsgcontent = (String)this.getModel().getValue("msgcontent");
            DynamicObject msgreceiver = (DynamicObject)this.getModel().getValue("jobmsgreceiver");
            if (StringUtils.isEmpty((CharSequence)type.toString()) && (StringUtils.isEmpty((CharSequence)snotifytype) || ",,".equals(snotifytype)) && StringUtils.isEmpty((CharSequence)smsgcontent) && msgreceiver == null) {
                return;
            }
            EntryProp entryProp = (EntryProp)this.getModel().getDataEntityType().getProperties().get((Object)MSG_NOTIFY_ENTITY);
            EntryType entryType = (EntryType)entryProp.getItemType();
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)entryType);
            if (msgreceiver != null) {
                MainEntityType mainType = this.getModel().getDataEntityType();
                MulBasedataProp mulBasedataProp = (MulBasedataProp)mainType.findProperty("fmulmsgreceiver");
                DynamicObjectType subEntityType = mulBasedataProp.getDynamicCollectionItemPropertyType();
                BasedataProp basedataProp = (BasedataProp)subEntityType.getProperties().get((Object)"fbasedataid");
                DynamicObject realDobj = BusinessDataServiceHelper.loadSingle((Object)msgreceiver.getPkValue(), (DynamicObjectType)basedataProp.getDynamicComplexPropertyType());
                DynamicObjectCollection rows = dynamicObject.getDynamicObjectCollection("fmulmsgreceiver");
                DynamicObject newRow = new DynamicObject(subEntityType);
                rows.add((Object)newRow);
                basedataProp.setValue((Object)newRow, (Object)realDobj);
            }
            dynamicObject.set("fmsgtype", (Object)type);
            dynamicObject.set("fsnotifytype", (Object)snotifytype);
            dynamicObject.set("fsmsgcontent", (Object)smsgcontent);
            dynamicObject.set("seq", (Object)(dynamicObjects.size() + 1));
            dynamicObjects.add((Object)dynamicObject);
            this.getView().updateView(MSG_NOTIFY_ENTITY);
        }
    }

    private void initParamEntry() {
        List<Map<String, Object>> jobParams = this.getJobParams();
        Object paramStr = this.getModel().getValue("params");
        if (StringUtils.isBlank((Object)paramStr) && CollectionUtils.isEmpty(jobParams)) {
            return;
        }
        HashMap<String, Object> paramMap = new HashMap();
        try {
            if (StringUtils.isNotBlank((Object)paramStr)) {
                paramMap = (Map)SerializationUtils.fromJsonString((String)paramStr.toString(), Map.class);
            }
        }
        catch (Exception e) {
            log.error("\u8c03\u5ea6\u4f5c\u4e1a\u53c2\u6570\u5f02\u5e38\uff0c params: {}", paramStr, (Object)e);
            this.getView().showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u8c03\u5ea6\u4f5c\u4e1a\u53c2\u6570\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\u53c2\u6570\uff0c\u5f53\u524d\u53c2\u6570\u503c\uff1a{0}", (String)"JobPlugin_24", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), paramStr));
            return;
        }
        if (!CollectionUtils.isEmpty(paramMap)) {
            paramMap.remove(SHAREPARAMS);
        }
        if (CollectionUtils.isEmpty(paramMap) && CollectionUtils.isEmpty(jobParams)) {
            return;
        }
        if (CollectionUtils.isEmpty(paramMap) && !CollectionUtils.isEmpty(jobParams)) {
            this.paramNotExistEntryExist(jobParams);
            return;
        }
        if (CollectionUtils.isEmpty(jobParams) && !CollectionUtils.isEmpty(paramMap)) {
            this.paramExistEntryNotExist(paramMap);
            return;
        }
        this.paramExistEntryExist(paramMap, jobParams);
    }

    private List<Map<String, Object>> getJobEntryParams() {
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        String sql = "SELECT FPARAMNAME,FPARAMVALUE,FMUST,FPARAMTYPE,FBASEDATAINFO FROM T_SCH_JOBPARAMS WHERE FID = ?";
        Object[] sqlParameters = new SqlParameter[]{new SqlParameter(":FID", 12, pkValue)};
        return (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])sqlParameters, rs -> {
            ArrayList jobParams1 = new ArrayList(8);
            while (rs.next()) {
                HashMap<String, String> jobParam = new HashMap<String, String>(8);
                jobParam.put(PARAM_NAME, rs.getString("fparamname"));
                jobParam.put(PARAMVALUE, rs.getString("FPARAMVALUE"));
                jobParam.put(MUST, rs.getString("FMUST"));
                jobParam.put(PARAMTYPE, rs.getString("FPARAMTYPE"));
                jobParam.put(BASEDATAINFO, rs.getString("FBASEDATAINFO"));
                jobParams1.add(jobParam);
            }
            return jobParams1;
        });
    }

    private List<Map<String, Object>> getJobParams() {
        List<Object> jobParams = new ArrayList();
        Object taskClassObj = this.getModel().getValue(TASKCLASSNAME);
        if (taskClassObj != null) {
            DynamicObject taskClass = (DynamicObject)taskClassObj;
            DynamicObjectCollection taskClassEntryParams = taskClass.getDynamicObjectCollection(PARAMENTRY);
            if (CollectionUtils.isEmpty((Collection)taskClassEntryParams)) {
                jobParams = this.getJobEntryParams();
            } else {
                List<Map<String, Object>> jobEntryParams = this.getJobEntryParams();
                for (DynamicObject taskClassEntryParam : taskClassEntryParams) {
                    HashMap<String, Object> jobParam = new HashMap<String, Object>();
                    jobParam.put(PARAM_NAME, taskClassEntryParam.get(PARAM_NAME));
                    jobParam.put(PARAM_DESC, taskClassEntryParam.get(PARAM_DESC));
                    jobParam.put(PARAMVALUE, taskClassEntryParam.get(PARAMVALUE));
                    jobParam.put(MUST, taskClassEntryParam.get(MUST));
                    Object paramType = taskClassEntryParam.get(PARAMTYPE);
                    if (StringUtils.isBlank((Object)paramType)) {
                        Map<String, Object> thisJobEntryParam = null;
                        for (Map<String, Object> jobEntryParam : jobEntryParams) {
                            String taskParamName;
                            String jobParamName = (String)jobEntryParam.get(PARAM_NAME);
                            if (!StringUtils.equals((CharSequence)jobParamName, (CharSequence)(taskParamName = (String)taskClassEntryParam.get(PARAM_NAME)))) continue;
                            thisJobEntryParam = jobEntryParam;
                            break;
                        }
                        if (thisJobEntryParam != null) {
                            jobParam.put(PARAMTYPE, thisJobEntryParam.get(PARAMTYPE));
                        } else {
                            jobParam.put(PARAMTYPE, "");
                        }
                    } else {
                        jobParam.put(PARAMTYPE, taskClassEntryParam.get(PARAMTYPE));
                    }
                    jobParam.put(BASEDATAINFO, taskClassEntryParam.get(BASEDATAINFO));
                    jobParams.add(jobParam);
                }
            }
        } else {
            jobParams = this.getJobEntryParams();
        }
        return jobParams;
    }

    private List<Map<String, Object>> getTaskParams() {
        DynamicObject taskClass;
        DynamicObjectCollection taskClassEntryParams;
        ArrayList<Map<String, Object>> jobParams = new ArrayList<Map<String, Object>>();
        Object taskClassObj = this.getModel().getValue(TASKCLASSNAME);
        if (taskClassObj != null && !CollectionUtils.isEmpty((Collection)(taskClassEntryParams = (taskClass = (DynamicObject)taskClassObj).getDynamicObjectCollection(PARAMENTRY)))) {
            for (DynamicObject taskClassEntryParam : taskClassEntryParams) {
                HashMap<String, Object> jobParam = new HashMap<String, Object>();
                jobParam.put(PARAM_NAME, taskClassEntryParam.get(PARAM_NAME));
                jobParam.put(PARAM_DESC, taskClassEntryParam.get(PARAM_DESC));
                jobParam.put(PARAMVALUE, taskClassEntryParam.get(PARAMVALUE));
                jobParam.put(MUST, taskClassEntryParam.get(MUST));
                jobParam.put(PARAMTYPE, taskClassEntryParam.get(PARAMTYPE));
                jobParam.put(BASEDATAINFO, taskClassEntryParam.get(BASEDATAINFO));
                jobParams.add(jobParam);
            }
        }
        return jobParams;
    }

    private void paramNotExistEntryExist(List<Map<String, Object>> jobParams) {
        this.getModel().batchCreateNewEntryRow(ENTRYENTITY, jobParams.size());
        int i = 0;
        this.getModel().beginInit();
        for (Map<String, Object> jobParam : jobParams) {
            this.getModel().setValue(PARAM_NAME, jobParam.get(PARAM_NAME), i);
            this.getModel().setValue(PARAM_DESC, jobParam.get(PARAM_DESC), i);
            this.getModel().setValue(PARAMVALUE, jobParam.get(PARAMVALUE), i);
            this.getModel().setValue(MUST, jobParam.get(MUST), i);
            this.getModel().setValue(PARAMTYPE, jobParam.get(PARAMTYPE), i);
            this.getModel().setValue(BASEDATAINFO, jobParam.get(BASEDATAINFO), i);
            this.getModel().setValue(PARAMVALUE_ORIGINSIGN, (Object)false, i);
            ++i;
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRYENTITY);
    }

    private void paramExistEntryNotExist(Map<String, Object> paramMap) {
        this.getModel().batchCreateNewEntryRow(ENTRYENTITY, paramMap.size());
        int i = 0;
        this.getModel().beginInit();
        for (Map.Entry<String, Object> it : paramMap.entrySet()) {
            this.getModel().setValue(PARAM_NAME, (Object)it.getKey(), i);
            if (it.getValue() instanceof String) {
                this.getModel().setValue(PARAMVALUE, it.getValue(), i);
            } else {
                this.getModel().setValue(PARAMVALUE, (Object)(it.getValue() == null ? null : SerializationUtils.toJsonString((Object)it.getValue())), i);
            }
            this.getModel().setValue(PARAMVALUE_ORIGINSIGN, (Object)true, i);
            ++i;
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRYENTITY);
    }

    private void paramExistEntryExist(Map<String, Object> paramMap, List<Map<String, Object>> jobParams) {
        this.getModel().batchCreateNewEntryRow(ENTRYENTITY, jobParams.size());
        int i = 0;
        this.getModel().beginInit();
        for (Map<String, Object> jobParam : jobParams) {
            String type;
            block10: {
                ParamTypeEnum paramType;
                String paramValueStr = null;
                Object paramValueObj = paramMap.get(jobParam.get(PARAM_NAME));
                if (paramValueObj != null) {
                    paramValueStr = paramValueObj instanceof String ? (String)paramValueObj : SerializationUtils.toJsonString((Object)paramValueObj);
                }
                if ((paramType = ParamTypeEnum.getParamType((String)(type = (String)jobParam.get(PARAMTYPE)))) == ParamTypeEnum.BASEDATA) {
                    try {
                        String baseDataInfoDef = (String)jobParam.get(BASEDATAINFO);
                        if (StringUtils.isNotBlank((CharSequence)paramValueStr)) {
                            Map baseDataValueMap = (Map)SerializationUtils.fromJsonString((String)paramValueStr, Map.class);
                            if (baseDataValueMap == null) continue;
                            Object number = baseDataValueMap.get(NUMBER);
                            Object id = baseDataValueMap.get("id");
                            Map baseDataInfoDefMap = (Map)SerializationUtils.fromJsonString((String)baseDataInfoDef, Map.class);
                            baseDataInfoDefMap.put(BASEDATAVALUE, baseDataValueMap);
                            this.getModel().setValue(BASEDATAINFO, (Object)SerializationUtils.toJsonString((Object)baseDataInfoDefMap), i);
                            if (id != null) {
                                DynamicObject baseDataValueDy = BusinessDataServiceHelper.loadSingle(id, (String)((String)number));
                                ILocaleString name = baseDataValueDy.getLocaleString(NAME);
                                this.getModel().setValue(PARAMVALUE, (Object)name.getLocaleValue(), i);
                            }
                            break block10;
                        }
                        this.getModel().setValue(PARAMVALUE, jobParam.get(PARAMVALUE), i);
                        this.getModel().setValue(BASEDATAINFO, (Object)baseDataInfoDef, i);
                    }
                    catch (Exception e) {
                        log.error("Schedule***\u89e3\u6790\u53c2\u6570\u9519\u8bef\uff0c{}", (Object)paramValueStr, (Object)e);
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u89e3\u6790\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u53c2\u6570\u9519\u8bef\uff1a%s", (String)"JobPlugin_34", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), paramValueStr));
                    }
                } else if (paramValueStr != null) {
                    this.getModel().setValue(PARAMVALUE, (Object)paramValueStr, i);
                    this.getModel().setValue(PARAMVALUE_ORIGINSIGN, (Object)true, i);
                } else {
                    this.getModel().setValue(PARAMVALUE, jobParam.get(PARAMVALUE), i);
                }
            }
            this.getModel().setValue(PARAM_NAME, jobParam.get(PARAM_NAME), i);
            this.getModel().setValue(PARAM_DESC, jobParam.get(PARAM_DESC), i);
            this.getModel().setValue(MUST, jobParam.get(MUST), i);
            this.getModel().setValue(PARAMTYPE, (Object)(StringUtils.isEmpty((CharSequence)type) ? NUM_ZERO : type), i);
            ++i;
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRYENTITY);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String params = (String)this.getModel().getValue("params");
        String runmode = (String)this.getModel().getValue(RUNMODE);
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(TASKCLASSNAME);
        if (dynamicObject != null) {
            TaskType taskType = this.getTaskType(dynamicObject);
            List<ComboItem> items = this.getRunMode(taskType, dynamicObject.getString(CLASSNAME));
            ComboEdit runMode = (ComboEdit)this.getView().getControl(RUNMODE);
            runMode.setComboItems(items);
        }
        if (StringUtils.equals((CharSequence)NUM_TWO, (CharSequence)runmode)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"shardingparam"});
            this.setShareParam(params);
        }
    }

    private void setShareParam(String params) {
        Map paramMap;
        String shareParam;
        if (StringUtils.isNotBlank((CharSequence)params) && StringUtils.isNotBlank((CharSequence)(shareParam = (String)(paramMap = (Map)JSON.parseObject((String)params, Map.class)).get(SHAREPARAMS)))) {
            List<ShardingParam> shareParamList = new ArrayList();
            try {
                shareParamList = JSON.parseArray((String)shareParam, ShardingParam.class);
            }
            catch (Exception e) {
                HashMap shareParamMap = (HashMap)JSON.parseObject((String)shareParam, HashMap.class);
                for (Map.Entry entry : shareParamMap.entrySet()) {
                    shareParamList.add(new ShardingParam((String)entry.getKey(), (String)entry.getValue()));
                }
            }
            DynamicObjectCollection sh_entryentity = this.getModel().getEntryEntity(SH_ENTRYENTITY);
            int index = 0;
            for (ShardingParam shardingParam : shareParamList) {
                DynamicObject row = sh_entryentity.addNew();
                row.set("seq", (Object)(index + 1));
                row.set(SHARENAME, (Object)shardingParam.getName());
                row.set(SHARECONDITION, (Object)shardingParam.getValue());
                ++index;
            }
        }
    }

    private List<ComboItem> getAllLang() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(6);
        for (EnabledLang lang : InteServiceHelper.getEnabledLang()) {
            ComboItem item = new ComboItem();
            item.setValue(lang.getNumber());
            item.setCaption(new LocaleString(lang.getName()));
            comboItems.add(item);
        }
        return comboItems;
    }

    private List<ComboItem> getStrategy(String type) {
        ArrayList<ComboItem> strategys = new ArrayList<ComboItem>();
        switch (type) {
            case "1": {
                this.getView().setVisible(Boolean.FALSE, new String[]{STRATEGY});
                this.getModel().setValue(RUNCONCURRENT, (Object)NUM_ONE);
                break;
            }
            case "0": {
                TaskType taskType = this.getTaskType();
                if (taskType == null || taskType.isCanStop()) {
                    strategys.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u8986\u76d6\u524d\u4e00\u4efb\u52a1", (String)"JobPlugin_11", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])), NUM_TWO));
                }
                strategys.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7b49\u5f85\u524d\u4e00\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5", (String)"JobPlugin_10", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])), NUM_ONE));
                this.getView().setVisible(Boolean.TRUE, new String[]{STRATEGY});
                this.getModel().setValue(RUNCONCURRENT, (Object)NUM_ZERO);
                break;
            }
            default: {
                strategys.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5e76\u53d1\u6267\u884c", (String)"JobPlugin_9", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])), NUM_ZERO));
                this.getModel().setValue(RUNCONCURRENT, (Object)NUM_ONE);
            }
        }
        return strategys;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate oper;
        if (args.getSource() instanceof AbstractOperate && (oper = (AbstractOperate)args.getSource()).getOperateKey().equals("save")) {
            if (!this.saveValid()) {
                args.cancel = true;
                return;
            }
            String paramStr = this.validParam();
            if (StringUtils.isBlank((CharSequence)paramStr)) {
                args.cancel = true;
                return;
            }
            IDataModel dataModel = this.getModel();
            if (dataModel.getValue(TIMEOUT) == null) {
                dataModel.setValue(TIMEOUT, (Object)0);
            }
            if (dataModel.getValue(RetryTime) == null) {
                dataModel.setValue(RetryTime, (Object)0);
            }
            dataModel.setValue("params", (Object)paramStr);
            this.setShareParam(paramStr);
            DynamicObjectCollection msgNotifyCollectin = dataModel.getEntryEntity(MSG_NOTIFY_ENTITY);
            if (CollectionUtils.isEmpty((Collection)msgNotifyCollectin)) {
                this.getModel().setValue("failnotify", (Object)false);
                this.getModel().setValue("successnotify", (Object)false);
                this.getModel().setValue("overtime", (Object)false);
                this.getModel().setValue("aborted", (Object)false);
                this.getModel().setValue("notifytype", (Object)"");
                this.getModel().setValue("msgcontent", (Object)"");
                this.getModel().setValue("jobmsgreceiver", null);
            }
            dataModel.updateCache();
        }
    }

    private String validParam() {
        String paramStr = "";
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection col = dataModel.getEntryEntity(ENTRYENTITY);
        DynamicObjectCollection dycollections = dataModel.getEntryEntity(SH_ENTRYENTITY);
        HashMap<String, String> params = new HashMap<String, String>(16);
        Object oldParamStr = dataModel.getValue("params");
        Map oldParams = new HashMap();
        if (StringUtils.isNotBlank((Object)oldParamStr)) {
            try {
                oldParams = (Map)SerializationUtils.fromJsonString((String)oldParamStr.toString(), Map.class);
            }
            catch (Exception e) {
                log.error("\u8c03\u5ea6\u4f5c\u4e1a\u53c2\u6570\u5f02\u5e38, params : {}", oldParamStr, (Object)e);
            }
        }
        if (col != null && !col.isEmpty()) {
            for (DynamicObject paramObj : col) {
                boolean paramNameNotNull;
                boolean bl = paramNameNotNull = paramObj.getString(PARAM_NAME) != null && paramObj.getString(PARAM_NAME).trim().length() > 0;
                if (!paramNameNotNull) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u53c2\u6570\u540d\u79f0\u201d\u3002", (String)"JobPlugin_22", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    return paramStr;
                }
                if (paramObj.getBoolean(MUST) && !"8".equals(paramObj.get(PARAMTYPE)) && StringUtils.isBlank((CharSequence)paramObj.getString(PARAMVALUE))) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u53c2\u6570%s\u201d\u7684\u9ed8\u8ba4\u503c\u3002", (String)"JobPlugin_23", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), paramObj.getString(PARAM_NAME)));
                    return paramStr;
                }
                if ("8".equals(paramObj.get(PARAMTYPE))) {
                    Map basedataDefMap;
                    if (StringUtils.isBlank((CharSequence)paramObj.getString(BASEDATAINFO))) {
                        if (paramObj.getBoolean(MUST)) {
                            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u53c2\u6570%s\u201d\u7684\u9ed8\u8ba4\u503c\u3002", (String)"JobPlugin_23", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), paramObj.getString(PARAM_NAME)));
                            return paramStr;
                        }
                        params.put(paramObj.getString(PARAM_NAME), "");
                        continue;
                    }
                    Map basedataInfoMap = (Map)SerializationUtils.fromJsonString((String)paramObj.getString(BASEDATAINFO), Map.class);
                    if (paramObj.getBoolean(MUST) && (basedataDefMap = (Map)basedataInfoMap.get(BASEDATAVALUE)) != null && basedataDefMap.get("id") == null) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u53c2\u6570%s\u201d\u7684\u9ed8\u8ba4\u503c\u3002", (String)"JobPlugin_23", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), paramObj.getString(PARAM_NAME)));
                        return paramStr;
                    }
                    Map basedatavalue = (Map)basedataInfoMap.get(BASEDATAVALUE);
                    params.put(paramObj.getString(PARAM_NAME), JSONObject.toJSONString((Object)basedatavalue));
                    continue;
                }
                String value = paramObj.getString(PARAMVALUE);
                boolean unchanged = paramObj.getBoolean(PARAMVALUE_ORIGINSIGN);
                if (unchanged) {
                    params.put(paramObj.getString(PARAM_NAME), (String)oldParams.get(paramObj.getString(PARAM_NAME)));
                    continue;
                }
                params.put(paramObj.getString(PARAM_NAME), value);
            }
        }
        if (StringUtils.equals((CharSequence)NUM_TWO, (CharSequence)((String)this.getModel().getValue(RUNMODE))) && dycollections != null && dycollections.size() > 0) {
            ArrayList<ShardingParam> shareParamList = new ArrayList<ShardingParam>(10);
            if (dycollections.size() > 5) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u7247\u53c2\u6570\u6700\u591a\u53ea\u80fd\u8bbe\u7f6e5\u4e2a\u3002", (String)"JobPlugin_25", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                return paramStr;
            }
            for (DynamicObject dyo : dycollections) {
                ShardingParam shardingParam = new ShardingParam();
                String sharename = dyo.getString(SHARENAME);
                String sharecondition = dyo.getString(SHARECONDITION);
                shardingParam.setName(sharename);
                if (StringUtils.isBlank((CharSequence)sharecondition)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5206\u7247\u6761\u4ef6\u201d\u3002", (String)"JobPlugin_18", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    return paramStr;
                }
                shardingParam.setValue(sharecondition);
                shareParamList.add(shardingParam);
            }
            params.put(SHAREPARAMS, JSON.toJSONString(shareParamList));
        } else if (StringUtils.equals((CharSequence)NUM_TWO, (CharSequence)((String)this.getModel().getValue(RUNMODE)))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5206\u7247\u6a21\u5f0f\u4e0b\u5206\u7247\u53c2\u6570\u5fc5\u586b\u9879\u3002", (String)"JobPlugin_17", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            return paramStr;
        }
        paramStr = JSON.toJSONString(params);
        if (paramStr.length() > 3000) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u53c2\u6570\u5185\u5bb9\u5927\u4e8e3000\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u3002", (String)"JobPlugin_4", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            return "";
        }
        return paramStr;
    }

    private boolean saveValid() {
        String errMsg;
        StringBuilder errMessage;
        boolean valid = true;
        String blankField = this.checkBlank();
        if (StringUtils.isNotEmpty((CharSequence)blankField)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c%s\u201d\u3002", (String)"JobPlugin_3", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), blankField));
            valid = false;
        }
        if (!this.checkTask(errMessage = new StringBuilder())) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u7c7b\u7684\u6240\u5c5e\u5e94\u7528\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u6240\u5c5e\u5e94\u7528\u518d\u4fdd\u5b58\u3002", (String)"JobPlugin_8", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), errMessage.toString()));
            valid = false;
        }
        if (StringUtils.isNotBlank((CharSequence)(errMsg = this.generateNumber()))) {
            this.getView().showErrorNotification(errMsg);
            valid = false;
        }
        Object id = this.getModel().getValue("id");
        QFilter idFilter = null;
        if (StringUtils.isNotBlank((Object)id)) {
            idFilter = new QFilter("id", "!=", id);
        }
        Object number = this.getModel().getValue(NUMBER);
        QFilter q1 = new QFilter(NUMBER, "=", number);
        QFilter[] filters = idFilter != null ? new QFilter[]{idFilter, q1} : new QFilter[]{q1};
        boolean exists = QueryServiceHelper.exists((String)"sch_job", (QFilter[])filters);
        if (exists) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\u3002", (String)"JobPlugin_7", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            valid = false;
        }
        if (StringUtils.isNotBlank((Object)this.getModel().getValue(TIMEOUT)) && (Integer)this.getModel().getValue(TIMEOUT) < 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8d85\u65f6\u65f6\u95f4\u8bf7\u8f93\u5165\u5927\u4e8e0\u7684\u6b63\u6574\u6570\u3002", (String)"JobPlugin_28", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), errMessage.toString()));
            valid = false;
        }
        if (StringUtils.isNotBlank((Object)this.getModel().getValue(RetryTime)) && ((Integer)this.getModel().getValue(RetryTime) < 0 || (Integer)this.getModel().getValue(RetryTime) > 10)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5931\u8d25\u91cd\u8bd5\u8bf7\u8f93\u5165\u5927\u4e8e0\u4e14\u5c0f\u4e8e\u7b49\u4e8e10\u7684\u6b63\u6574\u6570\u3002", (String)"JobPlugin_29", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), errMessage.toString()));
            valid = false;
        }
        if (this.getModel().getValue(TASKCLASSNAME) != null && !this.checkRunMode()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6267\u884c\u7a0b\u5e8f\u548c\u6267\u884c\u6a21\u5f0f\u4e0d\u5339\u914d\u3002", (String)"JobPlugin_19", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
            valid = false;
        }
        return valid;
    }

    private boolean checkTask(StringBuilder errMsg) {
        DynamicObject obj = this.getView().getModel().getDataEntity();
        if (obj.getDynamicObject(TASKCLASSNAME) == null) {
            return true;
        }
        Object pkId = obj.getDynamicObject(TASKCLASSNAME).getPkValue();
        DynamicObject dob = BusinessDataServiceHelper.loadSingle((Object)String.valueOf(pkId), (String)"sch_taskdefine");
        String appid = dob.getString(APPID);
        String classname = dob.getString(CLASSNAME);
        if (StringUtils.isBlank((CharSequence)appid)) {
            errMsg.append(classname);
            return false;
        }
        return true;
    }

    private String addNumberSuffix(String number, boolean isKingdee) {
        if (isKingdee) {
            if (!number.endsWith("_SKDJ_S")) {
                number = number.endsWith(SKDJ) ? number + "_S" : number + "_SKDJ_S";
            }
        } else if (number.endsWith(SKDJ)) {
            number = number + SKDJ;
        }
        return number;
    }

    private String generateNumber() {
        String errMsg = "";
        try {
            boolean isKingdee = AppMetaServiceHelper.getDeveloperInfo() != null && AppMetaServiceHelper.getDeveloperInfo().equals("kingdee");
            DynamicObject obj = this.getView().getModel().getDataEntity();
            String number = obj.getString(NUMBER);
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(TASKCLASSNAME);
            String appId = null;
            if (dynamicObject != null) {
                appId = dynamicObject.getString(APPID);
            }
            if (StringUtils.isNotBlank(appId) && !number.startsWith(appId + "_")) {
                number = appId + "_" + number;
            }
            IDataEntityProperty dataEntityProperty = (IDataEntityProperty)obj.getDataEntityType().getProperties().get((Object)NUMBER);
            TextProp numberProp = (TextProp)dataEntityProperty;
            int length = 40;
            if (numberProp != null) {
                length = numberProp.getMaxLenth();
            }
            if ((number = this.addNumberSuffix(number, isKingdee)).length() > length) {
                errMsg = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u957f\u5ea6\u8d85\u8fc7\u9650\u5236,\u8bf7\u51cf\u5c11%s\u5b57\u7b26\u3002", (String)"JobPlugin_30", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), number.length() - length);
                return errMsg;
            }
            obj.set(NUMBER, (Object)number);
            this.getView().updateView(NUMBER);
        }
        catch (Exception e) {
            log.error("schedulejob_generatenumber_error:{}", (Object)e.getMessage());
        }
        return errMsg;
    }

    private String checkBlank() {
        DynamicObject obj = this.getView().getModel().getDataEntity();
        BasedataEntityType entityType = (BasedataEntityType)obj.getDataEntityType();
        if (StringUtils.isBlank((CharSequence)obj.getString(NUMBER))) {
            return this.appendBlankField(entityType, NUMBER);
        }
        if (StringUtils.isBlank((CharSequence)obj.getString(NAME))) {
            return this.appendBlankField(entityType, NAME);
        }
        if (StringUtils.isBlank((CharSequence)obj.getString(RUNBY_USER))) {
            return this.appendBlankField(entityType, RUNBY_USER);
        }
        if (StringUtils.isBlank((CharSequence)obj.getString(TASKCLASSNAME)) && StringUtils.isBlank((CharSequence)obj.getString(CLASSNAME))) {
            return this.appendBlankField(entityType, TASKCLASSNAME);
        }
        if (this.getView().getControl(STRATEGY) != null && StringUtils.isBlank((CharSequence)obj.getString(STRATEGY))) {
            return this.appendBlankField(entityType, STRATEGY);
        }
        return "";
    }

    private String appendBlankField(BasedataEntityType entityType, String fieldKey) {
        IDataEntityProperty property = entityType.findProperty(fieldKey);
        if (property != null) {
            return property.getDisplayName() != null ? property.getDisplayName().getLocaleValue() : fieldKey;
        }
        return fieldKey;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObjectCollection entryEntitys;
        DynamicObject dynamicObject;
        ChangeData changeData;
        TaskType taskType;
        String proName = e.getProperty().getName();
        IDataModel model = this.getModel();
        if (TASKCLASSNAME.equals(proName)) {
            ComboEdit strategys;
            DynamicObject taskclassname = (DynamicObject)model.getDataEntity().get(TASKCLASSNAME);
            if (taskclassname != null) {
                String appid = (String)taskclassname.get(APPID);
                if (StringUtils.isNotBlank((CharSequence)appid)) {
                    this.getModel().setValue(APPID, (Object)appid);
                } else {
                    this.getModel().setValue(APPID, (Object)"");
                }
            } else {
                this.getModel().setValue(APPID, (Object)"");
            }
            if (taskclassname == null) {
                this.getModel().setValue(CLASSNAME, (Object)" ");
                return;
            }
            taskType = this.getTaskType(taskclassname);
            ComboEdit runMode = (ComboEdit)this.getView().getControl(RUNMODE);
            List<ComboItem> items = this.getRunMode(taskType, taskclassname.getString(CLASSNAME));
            runMode.setComboItems(items);
            if (items.size() > 0) {
                runMode.selectedStore(items.get(0));
                this.getModel().setValue(RUNMODE, (Object)NUM_ZERO);
            }
            if (StringUtils.equals((CharSequence)NUM_ZERO, (CharSequence)((String)this.getModel().getValue(RUNORDER))) && (strategys = (ComboEdit)this.getView().getControl(STRATEGY)) != null) {
                List<ComboItem> comboItems = this.getStrategy(NUM_ZERO);
                strategys.setComboItems(comboItems);
                strategys.selectedStore(comboItems.size() > 0 ? comboItems.get(0) : null);
            }
            this.getModel().setValue(CLASSNAME, taskclassname.get(CLASSNAME));
            this.setEntryParam();
            this.getModel().setValue(CANSTOP, (Object)false);
        }
        if (RUNORDER.equals(proName)) {
            String rc = String.valueOf(model.getValue(RUNORDER));
            ComboEdit strategys = (ComboEdit)this.getView().getControl(STRATEGY);
            if (strategys != null) {
                strategys.setComboItems(this.getStrategy(rc));
            }
            if (StringUtils.equals((CharSequence)NUM_ONE, (CharSequence)rc)) {
                this.getModel().setValue(RUNCONCURRENT, (Object)NUM_ONE);
            } else {
                this.getModel().setValue(RUNCONCURRENT, (Object)NUM_ZERO);
            }
        }
        if (TIMEOUT.equals(proName) && StringUtils.isNotBlank((Object)model.getValue(TIMEOUT)) && (Integer)model.getValue(TIMEOUT) < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d85\u65f6\u65f6\u95f4\u8bf7\u8f93\u5165\u5927\u4e8e0\u7684\u6b63\u6574\u6570\u3002", (String)"JobPlugin_28", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
        }
        if (RetryTime.equals(proName) && StringUtils.isNotBlank((Object)model.getValue(RetryTime)) && ((Integer)model.getValue(RetryTime) < 0 || (Integer)model.getValue(RetryTime) > 10)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5931\u8d25\u91cd\u8bd5\u8bf7\u8f93\u5165\u5927\u4e8e0\u4e14\u5c0f\u4e8e\u7b49\u4e8e10\u7684\u6b63\u6574\u6570\u3002", (String)"JobPlugin_29", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
        }
        if (RUNMODE.equals(proName)) {
            if (StringUtils.equals((CharSequence)NUM_TWO, (CharSequence)((String)model.getValue(RUNMODE)))) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"shardingparam"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"shardingparam"});
                Tab tab = (Tab)this.getControl("tabap");
                tab.activeTab("tabpageap2");
            }
        }
        if (CANSTOP.equals(proName) && ((Boolean)model.getValue(CANSTOP)).booleanValue()) {
            DynamicObject dynamicObject2 = (DynamicObject)this.getModel().getValue(TASKCLASSNAME);
            if (dynamicObject2 == null) {
                this.getModel().setValue(CANSTOP, (Object)false);
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6267\u884c\u7a0b\u5e8f\u540e\u518d\u64cd\u4f5c\u3002", (String)"JobPlugin_21", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), new Object[0]));
                return;
            }
            taskType = this.getTaskType(dynamicObject2);
            if (!taskType.isCanStop()) {
                this.getModel().setValue(CANSTOP, (Object)false);
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u672a\u5b9e\u73b0StopTask\u63a5\u53e3\u3002", (String)"JobPlugin_20", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), dynamicObject2.getString(CLASSNAME)));
            }
        }
        if (PARAMTYPE.equals(proName)) {
            this.getModel().setValue(PARAMVALUE, (Object)"");
            if (!"8".equals(this.getModel().getValue(PARAMTYPE)) && StringUtils.isNotBlank((Object)this.getModel().getValue(BASEDATAINFO))) {
                this.getModel().setValue(BASEDATAINFO, (Object)" ");
                this.getModel().setValue(PARAMVALUE, (Object)" ");
            }
        }
        if (PARAMVALUE.equals(proName) && StringUtils.isNotBlank((Object)(changeData = e.getChangeSet()[0]).getOldValue()) && StringUtils.isBlank((Object)changeData.getNewValue()) && "8".equals((dynamicObject = (DynamicObject)(entryEntitys = this.getModel().getEntryEntity(ENTRYENTITY)).get(changeData.getRowIndex())).getString(PARAMTYPE))) {
            if (StringUtils.isBlank((CharSequence)dynamicObject.getString(BASEDATAINFO))) {
                dynamicObject.set(BASEDATAINFO, (Object)"");
                return;
            }
            Map basedataInfo = (Map)SerializationUtils.fromJsonString((String)dynamicObject.getString(BASEDATAINFO), Map.class);
            Map basedatadefvalue = (Map)basedataInfo.get(BASEDATAVALUE);
            basedatadefvalue.remove("id");
            dynamicObject.set(BASEDATAINFO, (Object)JSONObject.toJSONString((Object)basedataInfo));
        }
        if (PARAMVALUE.equals(proName) || PARAM_NAME.equals(proName)) {
            for (ChangeData changedData : e.getChangeSet()) {
                this.getModel().setValue(PARAMVALUE_ORIGINSIGN, (Object)false, changedData.getRowIndex());
            }
        }
    }

    private void setEntryParam() {
        List<Map<String, Object>> jobParams = this.getTaskParams();
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData(ENTRYENTITY);
        int i = 0;
        if (!CollectionUtils.isEmpty(jobParams)) {
            model.batchCreateNewEntryRow(ENTRYENTITY, jobParams.size());
            for (Map<String, Object> jobParam : jobParams) {
                model.setValue(PARAM_NAME, jobParam.get(PARAM_NAME), i);
                model.setValue(PARAM_DESC, jobParam.get(PARAM_DESC), i);
                model.setValue(PARAMVALUE, jobParam.get(PARAMVALUE), i);
                model.setValue(MUST, jobParam.get(MUST), i);
                model.setValue(PARAMTYPE, jobParam.get(PARAMTYPE), i);
                model.setValue(BASEDATAINFO, jobParam.get(BASEDATAINFO), i);
                model.setValue(PARAMVALUE_ORIGINSIGN, (Object)false, i);
                ++i;
            }
        }
        model.endInit();
        this.getView().updateView(ENTRYENTITY);
    }

    private TaskType getTaskType() {
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(TASKCLASSNAME);
        if (dynamicObject == null) {
            return null;
        }
        return this.getTaskType(dynamicObject);
    }

    private TaskType getTaskType(DynamicObject taskclassname) {
        String scriptType = (String)taskclassname.get("plugintype");
        if (String.valueOf(4).equals(scriptType)) {
            TaskType taskType = new TaskType();
            taskType.getRouteModes().add(RouteMode.RAMDOM);
            return taskType;
        }
        String appId = taskclassname.getString("appId");
        String className = taskclassname.getString(CLASSNAME);
        if (StringUtils.isBlank((CharSequence)appId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5e94\u7528id\u4e3a\u7a7a", (String)"JobPlugin_32", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"bos", (CharSequence)appId) || this.isBOSApp(appId)) {
            appId = "bos";
        }
        TaskType taskType = null;
        try {
            taskType = (TaskType)DispatchServiceHelper.invokeBOSService((String)appId, (String)"SchTaskFormService", (String)"getTaskType", (Object[])new Object[]{className});
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
            log.error("Schedule***job plugin find service error", (Throwable)e);
            taskType = new TaskType();
        }
        return taskType;
    }

    private boolean hasPerm(String userId) {
        return PermissionServiceHelper.isAdminUser((long)Long.parseLong(userId)) || PermissionServiceHelper.isSuperUser((long)Long.parseLong(userId));
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        RequestContext rs = RequestContext.get();
        FormShowParameter fsp = e.getFormShowParameter();
        if (fsp instanceof ListShowParameter) {
            ListShowParameter lsp = (ListShowParameter)fsp;
            ArrayList<QFilter> qList = new ArrayList<QFilter>();
            if (e.getSource() instanceof UserEdit && !this.hasPerm(rs.getUserId())) {
                qList.add(new QFilter("id", "=", (Object)Long.parseLong(rs.getUserId())));
            }
            lsp.getListFilterParameter().setQFilters(qList);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        OperationResult operationResult;
        AbstractOperate oper;
        super.afterDoOperation(eventArgs);
        if (eventArgs.getSource() instanceof AbstractOperate && (oper = (AbstractOperate)eventArgs.getSource()).getOperateKey().equals("save") && (operationResult = eventArgs.getOperationResult()).isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeQuickAddNew(BeforeQuickAddNewEvent beforeQuickAddNewEvent) {
        beforeQuickAddNewEvent.getShowParameter().getOpenStyle().setShowType(ShowType.Modal);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        if (PARAMVALUE.equals(key)) {
            FormShowParameter parameter = new FormShowParameter();
            String paramTypeStr = (String)this.getModel().getValue(PARAMTYPE);
            ParamTypeEnum paramType = ParamTypeEnum.getParamType((String)paramTypeStr);
            if (paramType == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u53c2\u6570\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u524d\u5f80\u5f00\u53d1\u5e73\u53f0\u7684\u6267\u884c\u7a0b\u5e8f\uff08sch_taskdefine\uff09\u4e2d\u7ef4\u62a4\u76f8\u5e94\u7c7b\u578b\u3002", (String)"JobPlugin_35", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            parameter.setCustomParam(PARAMTYPE, (Object)PARAMVALUE);
            if (paramType == ParamTypeEnum.BOOLEAN) {
                parameter.setCustomParam("value", (Object)(StringUtils.equals((CharSequence)"true", (CharSequence)((String)this.getModel().getValue(PARAMVALUE))) ? NUM_ONE : NUM_ZERO));
            } else {
                parameter.setCustomParam("value", this.getModel().getValue(PARAMVALUE));
            }
            switch (paramType) {
                case TEXT: {
                    parameter.setCustomParam(VISIBLE, (Object)SerializationUtils.toJsonString(Collections.singletonList("texttype")));
                    break;
                }
                case INTEGER: {
                    parameter.setCustomParam(VISIBLE, (Object)SerializationUtils.toJsonString(Collections.singletonList("integertype")));
                    break;
                }
                case LONG: {
                    parameter.setCustomParam(VISIBLE, (Object)SerializationUtils.toJsonString(Collections.singletonList("biginttype")));
                    break;
                }
                case DECIMAL: {
                    parameter.setCustomParam(VISIBLE, (Object)SerializationUtils.toJsonString(Collections.singletonList("decimaltype")));
                    break;
                }
                case DATE: {
                    parameter.setCustomParam(VISIBLE, (Object)SerializationUtils.toJsonString(Collections.singletonList("datetype")));
                    break;
                }
                case DATETIME: {
                    parameter.setCustomParam(VISIBLE, (Object)SerializationUtils.toJsonString(Collections.singletonList("datetimetype")));
                    break;
                }
                case TIME: {
                    parameter.setCustomParam(VISIBLE, (Object)SerializationUtils.toJsonString(Collections.singletonList("timetype")));
                    break;
                }
                case BOOLEAN: {
                    parameter.setCustomParam(VISIBLE, (Object)SerializationUtils.toJsonString(Collections.singletonList("booleantype")));
                    break;
                }
                case BASEDATA: {
                    parameter.setCustomParam(VISIBLE, (Object)SerializationUtils.toJsonString(Arrays.asList("basedatatype", BASEDATAVALUE)));
                    String basedatainfo = (String)this.getModel().getValue(BASEDATAINFO);
                    parameter.setCustomParam(BASEDATAINFO, (Object)basedatainfo);
                    break;
                }
                default: {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53c2\u6570\u7c7b\u578b\u3002", (String)"JobPlugin_33", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
            }
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("sch_job_param");
            parameter.setCustomParam("isSetRunParam", (Object)"true");
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PARAMDEFCALLBACK));
            this.getView().showForm(parameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map dataMap;
        Object returnDataMap;
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (PARAMDEFCALLBACK.equals(actionId) && returnData != null && (returnDataMap = (dataMap = (Map)returnData).get("returnData")) instanceof Map) {
            Map param = (Map)returnDataMap;
            String type = (String)param.get("type");
            String paramValue = (String)param.get(PARAMVALUE);
            if ("basedata".equals(type)) {
                param.remove(PARAMVALUE);
                param.remove("type");
                this.getModel().setValue(BASEDATAINFO, (Object)JSONObject.toJSONString((Object)param));
                this.getModel().setValue(PARAMVALUE, (Object)paramValue);
            } else {
                this.getModel().setValue(PARAMVALUE, (Object)paramValue);
                if (StringUtils.isBlank((Object)this.getModel().getValue(PARAMVALUE))) {
                    this.getModel().setValue(PARAMVALUE, (Object)paramValue);
                }
                return;
            }
        }
    }

    private List<ComboItem> getRunMode(TaskType taskType, String taskclassname) {
        ArrayList<ComboItem> runModes = new ArrayList<ComboItem>();
        ComboItem comboItem0 = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5355\u673a\u6267\u884c", (String)"JobPlugin_12", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])), NUM_ZERO);
        comboItem0.setId(NUM_ZERO);
        comboItem0.setImageKey(NUM_ZERO);
        ComboItem comboItem1 = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5e7f\u64ad\u5206\u7247", (String)"JobPlugin_13", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])), NUM_ONE);
        comboItem1.setId(NUM_ONE);
        ComboItem comboItem2 = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4efb\u52a1\u5206\u7247", (String)"JobPlugin_14", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])), NUM_TWO);
        comboItem2.setId(NUM_TWO);
        if (taskType.getRouteModes().size() == 0) {
            if (StringUtils.equals((CharSequence)"NOTASK", (CharSequence)taskType.getErrorMsg())) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u975e\u4efb\u52a1\u7c7b,%s\u672a\u7ee7\u627f\u81eaAbstractTask\u3002", (String)"JobPlugin_15", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), taskclassname));
            } else if (StringUtils.equals((CharSequence)"CLASSNOTFOUND", (CharSequence)taskType.getErrorMsg())) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u4efb\u52a1\u7c7b: %s\u3002", (String)"JobPlugin_16", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), taskclassname));
            }
        }
        for (RouteMode routeMode : taskType.getRouteModes()) {
            if (RouteMode.RAMDOM == routeMode) {
                runModes.add(comboItem0);
            }
            if (RouteMode.SHARDINGBROADCAST == routeMode) {
                runModes.add(comboItem1);
            }
            if (RouteMode.SHARDINGTASK != routeMode) continue;
            runModes.add(comboItem2);
        }
        return runModes;
    }

    private boolean checkRunMode() {
        RouteMode currentRouteMode = null;
        String runMode = (String)this.getModel().getValue(RUNMODE);
        if (StringUtils.equals((CharSequence)NUM_ZERO, (CharSequence)runMode)) {
            currentRouteMode = RouteMode.RAMDOM;
        } else if (StringUtils.equals((CharSequence)NUM_ONE, (CharSequence)runMode)) {
            currentRouteMode = RouteMode.SHARDINGBROADCAST;
        } else if (StringUtils.equals((CharSequence)NUM_TWO, (CharSequence)runMode)) {
            currentRouteMode = RouteMode.SHARDINGTASK;
        }
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(TASKCLASSNAME);
        TaskType taskType = this.getTaskType(dynamicObject);
        return currentRouteMode != null && taskType.getRouteModes().contains(currentRouteMode);
    }

    private boolean isBOSApp(String appId) {
        try {
            return this.isBAMPMoveApp(appId) || BOSRuntime.isBOSApp((String)appId);
        }
        catch (Exception e) {
            log.warn("appId:{}", (Object)(appId + e.getMessage()));
            return false;
        }
    }

    private boolean isBAMPMoveApp(String bizappId) {
        return bampMoveAppList.contains(bizappId);
    }

    static {
        bampMoveAppList.add("cts");
        bampMoveAppList.add("secm");
        bampMoveAppList.add("customize");
        bampMoveAppList.add("open");
        bampMoveAppList.add("sbd");
        bampMoveAppList.add("mpdm");
        bampMoveAppList.add("gmc");
    }
}

