/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.formplugin;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Html;
import kd.bos.form.control.Image;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeUploadEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetaLogType;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.dataentity.AbstractDeployEntity;
import kd.bos.schedule.dataentity.DeployScheduleEntity;
import kd.bos.schedule.dataentity.DeployScriptEntity;
import kd.bos.schedule.dataentity.JobMainEntity;
import kd.bos.schedule.dataentity.TaskDefineMainEntity;
import kd.bos.schedule.dataentity.dao.ScheduleEntityReader;
import kd.bos.schedule.deploy.IScheduleDeployService;
import kd.bos.schedule.formplugin.ScheduleExportUtil;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataLogService;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class ScheduleDeployPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final Log logger = LogFactory.getLog(ScheduleDeployPlugin.class);
    private static String KEY_SCHCOUNT = "schcount";
    private static String KEY_JOBCOUNT = "jobcount";
    private static String KEY_TASKCOUNT = "taskcount";
    private static String KEY_OPTIME = "optime";
    private static String KEY_SCHDESC = "schdesc";
    private static String KEY_JOBDESC = "jobdesc";
    private static String KEY_TASKDESC = "taskdesc";
    private static String KEY_IMAGE = "iamge";
    private static String KEY_INITLOGFLEX = "initlogflex";
    private static String KEY_LOGFLEX = "logflex";
    private static String KEY_HTMLAP = "htmlap";
    private static String OPKEY_EXPORT = "export";
    private static final String BOS_SCHEDULE_FORMPLUGIN = "bos-schedule-formplugin";
    private static String sixEmptyText = "      ";
    private static String fourEmptyText = "    ";
    private static final String TASK_DEFINE_MAIN_ENTITYL_REPEAT_INDEX_MSG = "taskDefineMainEntityLRepeatIndexMsg";
    private static final String JOB_MAIN_ENTITYL_REPEAT_INDEX_MSG = "jobMainEntityLRepeatIndexMsg";
    private static final String SCHEDULE_MAIN_ENTITYL_REPEAT_INDEX_MSG = "scheduleMainEntityLRepeatIndexMsg";
    private static final String T_SCH_TASKDEFINE_L = "T_SCH_TASKDEFINE_L";
    private static final String T_SCH_JOB_L = "T_SCH_JOB_L";
    private static final String T_SCH_SCHEDULE_L = "T_SCH_SCHEDULE_L";
    private static final String PHOTOURL_DEFAULT = "/images/pc/emotion/default_person_82_82.png";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getControl("toolbarap");
        toolbar.addUploadListener((UploadListener)this);
        toolbar.addItemClickListener((ItemClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        RequestContext rs = RequestContext.get();
        long userId = rs.getCurrUserId();
        this.getModel().setValue("username", (Object)userId);
        this.getModel().setValue("usernumber", (Object)userId);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"useravatarfield"});
        if (this.getModel().getValue("username") instanceof DynamicObject) {
            Image userImage = (Image)this.getControl(KEY_IMAGE);
            Map userAvatarPathMap = UserServiceHelper.getUserAvatarPath(Collections.singletonList(userId), (boolean)true);
            String userAvatarPath = (String)userAvatarPathMap.get(userId);
            if (StringUtils.isNotBlank((CharSequence)userAvatarPath)) {
                userImage.setUrl(userAvatarPath);
            } else {
                userImage.setUrl(PHOTOURL_DEFAULT);
            }
        }
        this.getModel().setValue("userorg", (Object)rs.getOrgId());
        this.initLogDetailData();
        RequestContext rc = RequestContext.get();
        if (!PermissionServiceHelper.isAdminUser((long)rc.getCurrUserId()) && !PermissionServiceHelper.isSuperUser((long)rc.getCurrUserId())) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"toolbarap", "export", "import", "refresh"});
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662f\u7ba1\u7406\u5458\u6216\u5168\u529f\u80fd\u7528\u6237\uff0c\u4e0d\u80fd\u4f7f\u7528\u8be5\u529f\u80fd\u3002", (String)"ScheduleDeployPlugin_15", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    private void initLogDetailData() {
        this.getModel().setValue(KEY_SCHCOUNT, (Object)0);
        this.getModel().setValue(KEY_JOBCOUNT, (Object)0);
        this.getModel().setValue(KEY_TASKCOUNT, (Object)0);
        this.getModel().setValue(KEY_SCHDESC, (Object)ResManager.loadKDString((String)"\u6682\u65e0\u8c03\u5ea6\u8ba1\u5212\u6570\u636e", (String)"ScheduleDeployPlugin_1", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
        this.getModel().setValue(KEY_JOBDESC, (Object)ResManager.loadKDString((String)"\u6682\u65e0\u8c03\u5ea6\u4f5c\u4e1a\u6570\u636e", (String)"ScheduleDeployPlugin_2", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
        this.getModel().setValue(KEY_TASKDESC, (Object)ResManager.loadKDString((String)"\u6682\u65e0\u6267\u884c\u7a0b\u5e8f\u6570\u636e", (String)"ScheduleDeployPlugin_3", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
        this.getModel().setValue(KEY_OPTIME, (Object)"");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_OPTIME, KEY_LOGFLEX});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_INITLOGFLEX});
    }

    public void beforeUpload(BeforeUploadEvent evt) {
        List infos = evt.getAttachInfos();
        if (infos == null || infos.isEmpty()) {
            return;
        }
        this.getPageCache().put("filename", String.valueOf(((Map)infos.get(0)).get("name")));
    }

    public void afterUpload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls == null || urls.length == 0) {
            return;
        }
        String url = (String)urls[0];
        ArrayList<AbstractDeployEntity> schedules = new ArrayList<AbstractDeployEntity>(10);
        Html html = (Html)this.getControl(KEY_HTMLAP);
        try {
            Map<String, Object> importaDatas = ScheduleExportUtil.getImportData(url);
            schedules.addAll((Collection)importaDatas.get("deployDatas"));
            List deployScriptEntities = (List)importaDatas.get("deployScriptDatas");
            if (deployScriptEntities != null) {
                schedules.addAll(deployScriptEntities);
            }
            IScheduleDeployService service = (IScheduleDeployService)ServiceFactory.getService((String)"IScheduleDeployService");
            Map result = service.deploy(schedules);
            List taskDefineMainEntityLRepeatIndexMsg = (List)result.get(TASK_DEFINE_MAIN_ENTITYL_REPEAT_INDEX_MSG);
            List jobMainEntityRepeatIndexMsg = (List)result.get(JOB_MAIN_ENTITYL_REPEAT_INDEX_MSG);
            List scheduleMainEntityRepeatIndexMsg = (List)result.get(SCHEDULE_MAIN_ENTITYL_REPEAT_INDEX_MSG);
            if (Boolean.parseBoolean(String.valueOf(result.get("success")))) {
                this.outputImportResult(schedules, (List)importaDatas.get("errFiles"), taskDefineMainEntityLRepeatIndexMsg, jobMainEntityRepeatIndexMsg, scheduleMainEntityRepeatIndexMsg);
            } else {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff1a %s", (String)"ScheduleDeployPlugin_14", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), result.get("msg")));
            }
            try {
                MetadataLogService metadataLogService = (MetadataLogService)ServiceFactory.getService(MetadataLogService.class);
                this.addScheduleDeployMetaLog(T_SCH_TASKDEFINE_L, "sch_taskdefine", taskDefineMainEntityLRepeatIndexMsg, metadataLogService);
                this.addScheduleDeployMetaLog(T_SCH_JOB_L, "sch_job", jobMainEntityRepeatIndexMsg, metadataLogService);
                this.addScheduleDeployMetaLog(T_SCH_SCHEDULE_L, "sch_schedule", scheduleMainEntityRepeatIndexMsg, metadataLogService);
            }
            catch (Exception e) {
                logger.error("\u8bb0\u5f55\u591a\u8bed\u8a00\u552f\u4e00\u7d22\u5f15\u64cd\u4f5c\u65e5\u5fd7\u5f02\u5e38");
            }
        }
        catch (Exception e) {
            html.setConent(e.getMessage());
        }
    }

    private void addScheduleDeployMetaLog(String localeTableName, String formNum, List<String> logList, MetadataLogService metadataLogService) {
        if (!logList.isEmpty()) {
            String logMsg = this.getLogMsg(localeTableName, logList, "\n\t");
            long logId = DB.genGlobalLongId();
            String formId = MetadataDao.getIdByNumber((String)formNum, (MetaCategory)MetaCategory.Entity);
            String bizAppId = BizAppServiceHelp.getAppIdByFormNum((String)formNum);
            metadataLogService.addScheduleDeployMetaLog(formId, formNum, logMsg, (int)MetaLogType.Deploy.getValue(), logId, bizAppId, ResManager.loadKDString((String)"\u591a\u8bed\u8a00\u8868\u5b58\u5728\u552f\u4e00\u7d22\u5f15\u91cd\u590d\u6570\u636e", (String)"ScheduleDeployPlugin_25", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    private String getLogMsg(String tableName, List<String> logList, String wrapFlag) {
        StringBuilder logMsg = new StringBuilder(String.format(ResManager.loadKDString((String)"\u591a\u8bed\u8a00\u8868[%s]\u5b58\u5728\u552f\u4e00\u7d22\u5f15\u91cd\u590d\u6570\u636e\u5982\u4e0b\uff1a", (String)"ScheduleDeployPlugin_24", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), tableName));
        logMsg.append(wrapFlag);
        int index = 1;
        for (String msg : logList) {
            logMsg.append(sixEmptyText).append(index).append(". ").append(msg).append(wrapFlag);
            ++index;
        }
        return logMsg.toString();
    }

    public void itemClick(ItemClickEvent evt) {
        if (StringUtils.equals((CharSequence)OPKEY_EXPORT, (CharSequence)evt.getItemKey())) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("sch_exportfile");
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack cb = new CloseCallBack((IFormPlugin)this, OPKEY_EXPORT);
            fsp.setCloseCallBack(cb);
            this.getView().showForm(fsp);
        } else if (StringUtils.equals((CharSequence)"refresh", (CharSequence)evt.getItemKey())) {
            Html html = (Html)this.getControl(KEY_HTMLAP);
            html.setConent("");
            this.initLogDetailData();
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object data;
        if (StringUtils.equals((CharSequence)OPKEY_EXPORT, (CharSequence)evt.getActionId()) && (data = evt.getReturnData()) instanceof Map) {
            Map returnData = (Map)data;
            Set scheduleIds = (Set)returnData.get("scheduleIds");
            try {
                ScheduleDeployPlugin.buildExportLog();
                ArrayList ids = new ArrayList(scheduleIds.size());
                ids.addAll(scheduleIds);
                HashMap params = new HashMap(3);
                params.put("override", returnData.get("override"));
                List deployDatas = ScheduleEntityReader.getDeployDatasByScheduleId(ids, params);
                this.getView().download(ScheduleExportUtil.getDeployFileDownloadUrl(deployDatas));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"ScheduleDeployPlugin_16", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
                this.outputExportResult(deployDatas);
            }
            catch (Exception e) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff1a%s", (String)"ScheduleDeployPlugin_17", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), e.getMessage()));
                Html html = (Html)this.getControl(KEY_HTMLAP);
                html.setConent(e.getMessage());
            }
        }
    }

    private void outputExportResult(List<DeployScheduleEntity> scheduleEntities) {
        Html html = (Html)this.getControl(KEY_HTMLAP);
        StringBuilder builder = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        builder.append("<br>");
        ArrayList<JobMainEntity> jobs = new ArrayList<JobMainEntity>(scheduleEntities.size());
        ArrayList<TaskDefineMainEntity> tasks = new ArrayList<TaskDefineMainEntity>(scheduleEntities.size());
        StringBuilder scheduleDetail = new StringBuilder();
        StringBuilder jobDetail = new StringBuilder();
        StringBuilder taskDetail = new StringBuilder();
        int scheduleIndex = 1;
        int jobIndex = 1;
        int taskIndex = 1;
        for (DeployScheduleEntity it : scheduleEntities) {
            scheduleDetail.append(sixEmptyText).append(scheduleIndex++).append(". ").append(this.getDisplayValue(it.getScheduleMainEntity().getName())).append("\uff08").append(this.getDisplayValue(it.getScheduleMainEntity().getNumber())).append("\uff09").append("<br>");
            for (JobMainEntity job : it.getJobMainEntityList()) {
                jobs.add(job);
                jobDetail.append(sixEmptyText).append(jobIndex++).append(". ").append(this.getDisplayValue(job.getName())).append("\uff08").append(this.getDisplayValue(job.getNumber())).append("\uff09").append("<br>");
            }
            for (TaskDefineMainEntity taskEntity : it.getJobTaskMainEntityList()) {
                tasks.add(taskEntity);
                taskDetail.append(sixEmptyText).append(taskIndex++).append(". ").append(this.getDisplayValue(taskEntity.getName())).append("\uff08").append(this.getDisplayValue(taskEntity.getNumber())).append("\uff09").append("<br>");
            }
        }
        builder.append(fourEmptyText).append(ResManager.loadKDString((String)"\u5bfc\u51fa\u8be6\u60c5\uff1a", (String)"ScheduleDeployPlugin_4", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])).append("<br>");
        builder.append(fourEmptyText).append(ResManager.loadKDString((String)"\u8c03\u5ea6\u8ba1\u5212\uff1a", (String)"ScheduleDeployPlugin_5", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])).append("<br>");
        builder.append((CharSequence)scheduleDetail);
        builder.append("<br>");
        builder.append(fourEmptyText).append(ResManager.loadKDString((String)"\u8c03\u5ea6\u4f5c\u4e1a\uff1a", (String)"ScheduleDeployPlugin_6", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])).append("<br>");
        builder.append((CharSequence)jobDetail);
        builder.append("<br>");
        builder.append(fourEmptyText).append(ResManager.loadKDString((String)"\u6267\u884c\u7a0b\u5e8f\uff1a", (String)"ScheduleDeployPlugin_7", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])).append("<br>");
        builder.append((CharSequence)taskDetail);
        builder.append("</pre>").append("</p>");
        html.setConent(builder.toString());
        this.getModel().setValue(KEY_SCHCOUNT, (Object)scheduleEntities.size());
        this.getModel().setValue(KEY_JOBCOUNT, (Object)jobs.size());
        this.getModel().setValue(KEY_TASKCOUNT, (Object)tasks.size());
        this.getModel().setValue(KEY_SCHDESC, (Object)ResManager.loadKDString((String)"\u672c\u6b21\u6210\u529f\u5bfc\u51fa\u8c03\u5ea6\u8ba1\u5212", (String)"ScheduleDeployPlugin_8", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
        this.getModel().setValue(KEY_JOBDESC, (Object)ResManager.loadKDString((String)"\u8c03\u5ea6\u4f5c\u4e1a", (String)"ScheduleDeployPlugin_9", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
        this.getModel().setValue(KEY_TASKDESC, (Object)ResManager.loadKDString((String)"\u6267\u884c\u7a0b\u5e8f", (String)"ScheduleDeployPlugin_10", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
        this.getModel().setValue(KEY_OPTIME, (Object)String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u65f6\u95f4\uff1a%s", (String)"ScheduleDeployPlugin_11", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), sdf.format(new Date())));
        this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_OPTIME, KEY_LOGFLEX});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_INITLOGFLEX});
    }

    private void outputImportResult(List<AbstractDeployEntity> deployEntities, List<String> errFileNames, List<String> taskDefineMainEntityLRepeatIndexMsg, List<String> jobMainEntityRepeatIndexMsg, List<String> scheduleMainEntityRepeatIndexMsg) {
        ArrayList<DeployScheduleEntity> scheduleEntities = new ArrayList<DeployScheduleEntity>(deployEntities.size());
        ArrayList<DeployScriptEntity> deployScriptEntities = new ArrayList<DeployScriptEntity>(8);
        for (AbstractDeployEntity deployEntity : deployEntities) {
            if (deployEntity instanceof DeployScheduleEntity) {
                scheduleEntities.add((DeployScheduleEntity)deployEntity);
                continue;
            }
            if (deployEntity instanceof DeployScriptEntity) {
                deployScriptEntities.add((DeployScriptEntity)deployEntity);
                continue;
            }
            throw new KDBizException("analyse result error");
        }
        Html html = (Html)this.getControl(KEY_HTMLAP);
        StringBuilder builder = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList<JobMainEntity> jobs = new ArrayList<JobMainEntity>(scheduleEntities.size());
        ArrayList<TaskDefineMainEntity> tasks = new ArrayList<TaskDefineMainEntity>(scheduleEntities.size());
        StringBuilder scheduleDetail = new StringBuilder();
        StringBuilder jobDetail = new StringBuilder();
        StringBuilder taskDetail = new StringBuilder();
        StringBuilder scriptDetail = new StringBuilder();
        StringBuilder errSchDetail = new StringBuilder();
        int scheduleIndex = 1;
        int jobIndex = 1;
        int taskIndex = 1;
        int scriptIndex = 1;
        HashMap<String, String> schGlName = new HashMap<String, String>(15);
        for (DeployScheduleEntity it : scheduleEntities) {
            schGlName.put(it.getScheduleMainEntity().getId(), it.getScheduleMainEntity().getName());
        }
        QFilter[] schFilters = new QFilter[2];
        Set scheduleIds = schGlName.keySet();
        schFilters[0] = new QFilter("id", "in", (Object)scheduleIds.toArray(new String[scheduleIds.size()]));
        schFilters[1] = new QFilter("job.number", "is null", (Object)"");
        schFilters[1].or(new QFilter("entryentity.jobnumber.number", "is null", (Object)"").and(new QFilter("entryentity.id", "is not null", (Object)"")));
        DynamicObjectCollection errSchs = QueryServiceHelper.query((String)"sch_schedule", (String)"id,number,name", (QFilter[])schFilters);
        HashSet<Object> errSchIds = new HashSet<Object>(errSchs.size());
        if (!errSchs.isEmpty()) {
            errSchDetail.append("<br>");
            errSchDetail.append(fourEmptyText).append(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5173\u8054\u5f02\u5e38\u7684\u8c03\u5ea6\u8ba1\u5212%s\u4e2a", (String)"ScheduleDeployPlugin_21", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), errSchs.size())).append("<br>");
            errSchDetail.append(fourEmptyText).append(ResManager.loadKDString((String)"\u5173\u8054\u5f02\u5e38\u8be6\u60c5\uff1a", (String)"ScheduleDeployPlugin_23", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])).append("<br>");
            int n = 1;
            for (DynamicObject errSch : errSchs) {
                String erSchId = errSch.getString("id");
                errSchIds.add(erSchId);
                String errSchName = errSch.getString("name");
                if (StringUtils.isBlank((CharSequence)errSchName)) {
                    errSchName = (String)schGlName.get(erSchId);
                }
                errSchDetail.append(n).append(".").append(this.getDisplayValue(errSchName)).append("\uff08").append(this.getDisplayValue(errSch.getString("number"))).append("\uff09").append("<br>");
                ++n;
            }
            errSchDetail.append("<br>");
        }
        boolean hasRepeatIndexError = false;
        if (!scheduleMainEntityRepeatIndexMsg.isEmpty()) {
            scheduleDetail.append(this.getLogMsg(T_SCH_SCHEDULE_L, scheduleMainEntityRepeatIndexMsg, "</br>"));
            scheduleDetail.append("</br>");
            hasRepeatIndexError = true;
        }
        if (!jobMainEntityRepeatIndexMsg.isEmpty()) {
            jobDetail.append(this.getLogMsg(T_SCH_JOB_L, jobMainEntityRepeatIndexMsg, "</br>"));
            jobDetail.append("</br>");
            hasRepeatIndexError = true;
        }
        if (!taskDefineMainEntityLRepeatIndexMsg.isEmpty()) {
            taskDetail.append(this.getLogMsg(T_SCH_TASKDEFINE_L, taskDefineMainEntityLRepeatIndexMsg, "</br>"));
            taskDetail.append("</br>");
            hasRepeatIndexError = true;
        }
        for (DeployScheduleEntity it : scheduleEntities) {
            if (!errSchIds.contains(it.getScheduleMainEntity().getId())) {
                scheduleDetail.append(sixEmptyText).append(scheduleIndex++).append(". ").append(this.getDisplayValue(it.getScheduleMainEntity().getName())).append("\uff08").append(this.getDisplayValue(it.getScheduleMainEntity().getNumber())).append("\uff09").append("<br>");
            }
            for (JobMainEntity job : it.getJobMainEntityList()) {
                jobs.add(job);
                jobDetail.append(sixEmptyText).append(jobIndex++).append(". ").append(this.getDisplayValue(job.getName())).append("\uff08").append(this.getDisplayValue(job.getNumber())).append("\uff09").append("<br>");
            }
            for (TaskDefineMainEntity taskEntity : it.getJobTaskMainEntityList()) {
                tasks.add(taskEntity);
                taskDetail.append(sixEmptyText).append(taskIndex++).append(". ").append(this.getDisplayValue(taskEntity.getName())).append("\uff08").append(this.getDisplayValue(taskEntity.getNumber())).append("\uff09").append("<br>");
            }
        }
        for (DeployScriptEntity deployScriptEntity : deployScriptEntities) {
            scriptDetail.append(sixEmptyText).append(scriptIndex++).append(". ").append(deployScriptEntity.getFileName()).append("<br>");
        }
        if (errFileNames.size() > 0) {
            builder.append("<br>");
            builder.append(fourEmptyText).append(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5bfc\u5165\u5931\u8d25\u7684\u8c03\u5ea6\u6587\u4ef6%s\u4e2a", (String)"ScheduleDeployPlugin_19", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), errFileNames.size())).append("<br>");
            builder.append(fourEmptyText).append(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u8be6\u60c5\uff1a", (String)"ScheduleDeployPlugin_20", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])).append("<br>");
            int n = 1;
            for (String errFileName : errFileNames) {
                builder.append(n).append(".").append(this.getDisplayValue(errFileName)).append("<br>");
                ++n;
            }
            builder.append("<br>");
        }
        if (errSchDetail.length() > 0) {
            builder.append((CharSequence)errSchDetail);
        }
        builder.append("<br>");
        builder.append(fourEmptyText).append(ResManager.loadKDString((String)"\u5173\u8054\u6210\u529f\u8be6\u60c5\uff1a", (String)"ScheduleDeployPlugin_22", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])).append("<br>");
        builder.append(fourEmptyText).append(ResManager.loadKDString((String)"\u8c03\u5ea6\u8ba1\u5212\uff1a", (String)"ScheduleDeployPlugin_5", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])).append("<br>");
        builder.append((CharSequence)scheduleDetail);
        builder.append("<br>");
        builder.append(fourEmptyText).append(ResManager.loadKDString((String)"\u8c03\u5ea6\u4f5c\u4e1a\uff1a", (String)"ScheduleDeployPlugin_6", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])).append("<br>");
        builder.append((CharSequence)jobDetail);
        builder.append("<br>");
        builder.append(fourEmptyText).append(ResManager.loadKDString((String)"\u6267\u884c\u7a0b\u5e8f\uff1a", (String)"ScheduleDeployPlugin_7", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])).append("<br>");
        builder.append((CharSequence)taskDetail);
        builder.append("<br>");
        builder.append(fourEmptyText).append(ResManager.loadKDString((String)"\u8c03\u5ea6\u811a\u672c\u63d2\u4ef6\uff1a", (String)"ScheduleDeployPlugin_27", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0])).append("<br>");
        builder.append((CharSequence)scriptDetail);
        builder.append("</pre>").append("</p>");
        html.setConent(builder.toString());
        this.getModel().setValue(KEY_SCHCOUNT, (Object)scheduleEntities.size());
        this.getModel().setValue(KEY_JOBCOUNT, (Object)jobs.size());
        this.getModel().setValue(KEY_TASKCOUNT, (Object)tasks.size());
        this.getModel().setValue(KEY_SCHDESC, (Object)ResManager.loadKDString((String)"\u672c\u6b21\u6210\u529f\u5bfc\u5165\u8c03\u5ea6\u8ba1\u5212", (String)"ScheduleDeployPlugin_12", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
        this.getModel().setValue(KEY_JOBDESC, (Object)ResManager.loadKDString((String)"\u8c03\u5ea6\u4f5c\u4e1a", (String)"ScheduleDeployPlugin_9", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
        this.getModel().setValue(KEY_TASKDESC, (Object)ResManager.loadKDString((String)"\u6267\u884c\u7a0b\u5e8f", (String)"ScheduleDeployPlugin_10", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
        this.getModel().setValue(KEY_OPTIME, (Object)String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u65f6\u95f4\uff1a%s", (String)"ScheduleDeployPlugin_11", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]), sdf.format(new Date())));
        this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_OPTIME, KEY_LOGFLEX});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_INITLOGFLEX});
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"ScheduleDeployPlugin_13", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
        if (hasRepeatIndexError) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u76f8\u5173\u591a\u8bed\u8a00\u8868\u5b58\u5728\u552f\u4e00\u7d22\u5f15\u91cd\u590d\u6570\u636e\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u4e0b\u65b9\u65e5\u5fd7\u3002", (String)"ScheduleDeployPlugin_26", (String)BOS_SCHEDULE_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    private String getDisplayValue(String value) {
        String v = StringUtils.isBlank((CharSequence)value) ? "-" : this.cleanXSSParam(value);
        return v;
    }

    private String cleanXSSParam(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return value;
        }
        String cleanValue = value;
        cleanValue = cleanValue.replaceAll("\"", "&quot;");
        cleanValue = cleanValue.replaceAll("'", "&#39;");
        cleanValue = cleanValue.replaceAll("<", "&lt;");
        cleanValue = cleanValue.replaceAll(">", "&gt;");
        return cleanValue;
    }

    private static void buildExportLog() {
        ILogService logService = (ILogService)ServiceFactory.getService((String)"ILogService");
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u8c03\u5ea6\u6570\u636e\u5bfc\u51fa", "ScheduleDeployPlugin_18", BOS_SCHEDULE_FORMPLUGIN);
        AppLogInfo logInfo = ScheduleDeployPlugin.doBuildLogInfo("sch_schedule", "sch_export", opNameBridge);
        logService.addLog(logInfo);
    }

    private static AppLogInfo doBuildLogInfo(String formId, String opNumber, MultiLangEnumBridge opNameBridge) {
        OpLogAppInfo logInfo = new OpLogAppInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getUserId()));
        logInfo.setBizAppID(BizAppServiceHelp.getAppIdByAppNumber((String)"sys"));
        logInfo.setBizObjID(formId);
        logInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        logInfo.setOpTime(new Date());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        logInfo.setOpName(opNumber, opNameBridge);
        logInfo.setOpDesc(opNameBridge, new String[0]);
        return logInfo;
    }
}

