/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.upgrade;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.message.AbstractService;
import kd.bos.schedule.upgrade.SchClearNoTimeoutKeyUpgradeServiceImpl;
import kd.bos.schedule.zk.ZkConfig;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import org.apache.commons.lang3.time.DateUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class SchClearNoTimeoutKeyUpgradeServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(SchClearNoTimeoutKeyUpgradeServiceImpl.class);
    private static final int clearDay = 180;
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"BOSSchedule- SchClearNoTimeoutKey", (int)1);
    private static int splitSize = 300;

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        threadPool.execute(this::execute);
        result.setLog("SchClearNoTimeoutKeyUpgradeServiceImpl.execute");
        return result;
    }

    private void execute() {
        try {
            ClearSchTaskJobTypeNum clearSchTaskJobTypeNum = new ClearSchTaskJobTypeNum(this);
            ClearSchTaskJobTypeNum.access$000((ClearSchTaskJobTypeNum)clearSchTaskJobTypeNum);
        }
        catch (Exception e) {
            logger.error("Schedule***error ClearSchTaskJobTypeNum", (Throwable)e);
        }
        try {
            ClearTop5ScheduleTaskNum clearTop5ScheduleTaskNum = new ClearTop5ScheduleTaskNum();
            ClearTop5ScheduleTaskNum.access$100(clearTop5ScheduleTaskNum);
        }
        catch (Exception e) {
            logger.error("Schedule***error ClearTop5ScheduleTaskNum", (Throwable)e);
        }
        try {
            ClearSchTaskStatusNum clearSchTaskStatusNum = new ClearSchTaskStatusNum();
            ClearSchTaskStatusNum.access$200(clearSchTaskStatusNum);
        }
        catch (Exception e) {
            logger.error("Schedule***error ClearSchTaskStatusNum", (Throwable)e);
        }
    }

    private Date getToDayStartTime(Date date) {
        return DateUtils.truncate((Date)date, (int)5);
    }

    protected String getCacheKeyVersion() {
        return "2.0";
    }

    class ClearSchTaskStatusNum {
        private static final String CACHE_KEY = "observable-SchTaskStatusStatsFilter";
        private final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("observable-SchTaskStatusStatsFilter", new DistributeCacheHAPolicy(true, true));

        ClearSchTaskStatusNum() {
        }

        private void clearSchTaskStatusNum() {
            LocalDate localDate = LocalDate.now();
            for (int i = 0; i < 180; ++i) {
                try {
                    Date date = Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
                    Date dayStartTime = SchClearNoTimeoutKeyUpgradeServiceImpl.this.getToDayStartTime(date);
                    this.clearCache(dayStartTime);
                    localDate = localDate.minusDays(1L);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
            }
        }

        private void clearCache(Date date) {
            RequestContext rc = RequestContext.get();
            ArrayList<String> cacheKeys = new ArrayList<String>(8);
            for (String stutus : this.getTaskEndStatus()) {
                String cacheKey = this.getCacheKeyAccount(rc.getTenantId(), rc.getAccountId(), date, stutus);
                cacheKeys.add(cacheKey);
            }
            if (!cacheKeys.isEmpty()) {
                this.cache.remove(cacheKeys.toArray(new String[0]));
            }
        }

        private String[] getTaskEndStatus() {
            return new String[]{"COMPLETED", "ABORTED", "FAILED", "TIMEOUT", "SKIP"};
        }

        private String getCacheKeyAccount(String tenantId, String accountId, Date date, String status) {
            String str = "observable-SchTaskStatusStatsFilter&&" + tenantId + "&&" + accountId + "&&" + date.getTime() + "&&" + status;
            if (AbstractService.RunMode.Dev == ZkConfig.getRunMode()) {
                str = str + ZkConfig.getHostIpAddress();
            }
            return str + SchClearNoTimeoutKeyUpgradeServiceImpl.this.getCacheKeyVersion();
        }

        static /* synthetic */ void access$200(ClearSchTaskStatusNum x0) {
            x0.clearSchTaskStatusNum();
        }
    }

    class ClearTop5ScheduleTaskNum {
        private static final String CACHE_KEY = "observable-Top5ScheduleTaskNumFilter";
        private final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("observable-Top5ScheduleTaskNumFilter", new DistributeCacheHAPolicy(true, true));
        private List<String> scheduleIds = new ArrayList<String>(8);

        ClearTop5ScheduleTaskNum() {
        }

        private void clearTop5ScheduleTaskNum() {
            this.initScheduleIdsMap();
            LocalDate localDate = LocalDate.now();
            for (int i = 0; i < 180; ++i) {
                try {
                    Date date = Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
                    Date dayStartTime = SchClearNoTimeoutKeyUpgradeServiceImpl.this.getToDayStartTime(date);
                    this.clearCache(dayStartTime);
                    localDate = localDate.minusDays(1L);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
            }
        }

        private void initScheduleIdsMap() {
            String querySql = "select fid from t_sch_schedule where fstatus = '1'";
            this.scheduleIds = (List)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)querySql, rs -> {
                ArrayList<String> list = new ArrayList<String>(8);
                while (rs.next()) {
                    String scheduleId = rs.getString("fid");
                    list.add(scheduleId);
                }
                return list;
            });
        }

        private void clearCache(Date date) {
            ArrayList<String> cacheKeys = new ArrayList<String>(8);
            RequestContext rc = RequestContext.get();
            String cacheKey_allSchedule = this.getCacheKey_AllSchedule(rc.getTenantId(), rc.getAccountId(), date);
            cacheKeys.add(cacheKey_allSchedule);
            Map map = this.cache.hgetAll(cacheKey_allSchedule);
            if (map == null || map.isEmpty()) {
                for (String scheduleId : this.scheduleIds) {
                    String string = this.getCacheKeyAccount(rc.getTenantId(), rc.getAccountId(), date, scheduleId);
                    cacheKeys.add(string);
                }
            } else {
                for (byte[] bytes : map.keySet()) {
                    String string = new String(bytes);
                    String cacheKey = this.getCacheKeyAccount(rc.getTenantId(), rc.getAccountId(), date, string);
                    cacheKeys.add(cacheKey);
                }
            }
            if (!cacheKeys.isEmpty()) {
                ArrayList result = new ArrayList();
                for (int i = 0; i < cacheKeys.size(); i += splitSize) {
                    int n = Math.min(i + splitSize, cacheKeys.size());
                    result.add(cacheKeys.subList(i, n));
                }
                for (List list : result) {
                    this.cache.remove(list.toArray(new String[0]));
                }
            }
        }

        private String getCacheKeyAccount(String tenantId, String accountId, Date date, String scheduleId) {
            String str = "observable-Top5ScheduleTaskNumFilter&&" + tenantId + "&&" + accountId + "&&" + date.getTime() + "&&" + scheduleId;
            if (AbstractService.RunMode.Dev == ZkConfig.getRunMode()) {
                str = str + ZkConfig.getHostIpAddress();
            }
            return str + SchClearNoTimeoutKeyUpgradeServiceImpl.this.getCacheKeyVersion();
        }

        private String getCacheKey_AllSchedule(String tenantId, String accountId, Date date) {
            String str = "observable-Top5ScheduleTaskNumFilter&&" + tenantId + "&&" + accountId + "&&" + date;
            if (AbstractService.RunMode.Dev == ZkConfig.getRunMode()) {
                str = str + ZkConfig.getHostIpAddress();
            }
            return str + SchClearNoTimeoutKeyUpgradeServiceImpl.this.getCacheKeyVersion();
        }

        static /* synthetic */ void access$100(ClearTop5ScheduleTaskNum x0) {
            x0.clearTop5ScheduleTaskNum();
        }
    }
}

