/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.executor;

import java.util.TreeMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.schedule.api.BroadcastTask;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.ShardingUtil;
import kd.bos.schedule.api.Task;
import kd.bos.schedule.executor.JavaTaskHandler;
import kd.bos.schedule.zk.ActiveKeyValueStore;
import kd.bos.schedule.zk.ZkConfig;

public class BroadJavaTaskHandler
extends JavaTaskHandler {
    @Override
    protected void exeTask(RequestContext rc, JobInfo job, Task task) {
        this.setBroadcastParam(job);
        if (!(task instanceof BroadcastTask)) {
            throw new KDException(BosErrorCode.cannotLoadBeanClass, new Object[]{ResManager.loadKDString((String)"\u4efb\u52a1\u7c7b\u6ca1\u6709\u5b9e\u73b0BroadcastTask\u63a5\u53e3", (String)"BroadJavaTaskHandler_0", (String)"bos-schedule-executor", (Object[])new Object[0])});
        }
        ((BroadcastTask)task).execute(rc, job.getParams(), ShardingUtil.getBroadcastVO());
    }

    private void setBroadcastParam(JobInfo job) {
        String appId = job.getAppId();
        ActiveKeyValueStore activeKeyValueStore = ActiveKeyValueStore.create();
        activeKeyValueStore.initAppIdExeServerMap(appId);
        TreeMap exeServerMap = activeKeyValueStore.getExeServerMap();
        String executorServerName = ZkConfig.getExecutorServerName();
        Integer index = (Integer)exeServerMap.get(executorServerName);
        if (exeServerMap.size() == 0) {
            ShardingUtil.setBroadcastVO((ShardingUtil.BroadcastVO)new ShardingUtil.BroadcastVO(0, 0));
            return;
        }
        if (index == null) {
            ShardingUtil.setBroadcastVO((ShardingUtil.BroadcastVO)new ShardingUtil.BroadcastVO(0, exeServerMap.size()));
        } else {
            ShardingUtil.setBroadcastVO((ShardingUtil.BroadcastVO)new ShardingUtil.BroadcastVO(index.intValue(), exeServerMap.size()));
        }
    }
}

