/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.executor;

import kd.bos.context.RequestContext;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.schedule.api.AbstractJobHandler;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.api.Task;
import kd.bos.schedule.api.TaskHandler;
import kd.bos.script.ProjectInitializerManager;
import kd.sdk.kingscript.host.ScriptProxyFactory;
import kd.sdk.kingscript.lib.ScriptPathFormat;

public class KSTaskHandler
implements TaskHandler {
    public Task execute(RequestContext rc, MessageInfo message, JobInfo job, AbstractJobHandler jobHandler) {
        String className = job.getTaskClassname();
        if (className == null) {
            ErrorCode ec = new ErrorCode("TASK_NAME_EMPTY", job.getlName() == null ? "" : job.getlName().toString());
            throw new KDException(ec, new Object[0]);
        }
        Task task = null;
        try {
            String pluginScriptPath = ScriptPathFormat.format((String)className);
            task = (Task)ScriptProxyFactory.createPluginProxy((String)pluginScriptPath, scriptPath -> ProjectInitializerManager.getEngineAutoDebug((String)scriptPath));
            task.setTaskId(message.getTaskId());
            task.setMessageHandle((MessageHandler)jobHandler);
        }
        catch (Exception e) {
            ErrorCode ec = new ErrorCode("TASK_CLASS_INIT_FAILED", e.getMessage());
            throw new KDException(ec, e.getMessage(), (Throwable)e);
        }
        task.execute(rc, job.getParams());
        return task;
    }
}

