/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.dao.dbImpl;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import java.security.SecureRandom;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.ErrorJobInfo;
import kd.bos.schedule.api.JobDao;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.PluginType;
import kd.bos.schedule.api.RouteMode;
import kd.bos.schedule.api.SchEntityType;
import kd.bos.schedule.dao.dbImpl.DbJobOperation;
import kd.bos.schedule.utils.ScheduleDataEntityUtils;

public class DbJobDao
implements JobDao {
    private static final DBRoute Sch_Route = DBRoute.basedata;
    private static final DBRoute META_ROUTE = DBRoute.meta;
    private static final Log log = LogFactory.getLog(DbJobDao.class);
    private static final String FFAIL_NOTIFY = "ffailnotify";
    private static final String FSUCCESS_NOTIFY = "fsuccessnotify";
    private static final String FOVERTIME = "fovertime";
    public static final String FABORTED = "faborted";
    public static final String FTASKTRACE = "ftasktrace";

    public boolean isExist(String jobId) {
        if (jobId == null || jobId.trim().length() == 0) {
            return false;
        }
        String strSQL = "SELECT FID FROM T_SCH_JOB WHERE FID= ? ";
        Object[] params = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)jobId)};
        return (Boolean)DB.query((DBRoute)Sch_Route, (String)strSQL, (Object[])params, rs -> rs.next());
    }

    public boolean delete(String jobId) {
        if (jobId == null || jobId.trim().length() == 0) {
            return false;
        }
        String deleteLocaleSql = "delete from T_SCH_JOB_L where FID = ?";
        String strSQL = "DELETE FROM T_SCH_JOB WHERE FID= ? ";
        Object[] params = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)jobId)};
        Throwable throwable = null;
        try (TXHandle handle = TX.requiresNew();){
            DB.execute((DBRoute)Sch_Route, (String)deleteLocaleSql, (Object[])params);
            boolean result = DB.execute((DBRoute)Sch_Route, (String)strSQL, (Object[])params);
            if (result) {
                this.updateDataEntityCache(new Object[]{jobId});
            }
            boolean bl = result;
            return bl;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            handle.markRollback();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        return false;
    }

    public boolean save(JobInfo jobInfo) {
        return this.save(new JobInfo[]{jobInfo});
    }

    public JobInfo get(String jobId) {
        StringBuilder strSQLBuilder = new StringBuilder();
        strSQLBuilder.append("SELECT T1.FID,T1.FNUMBER,T1.FJOBTYPE,T1.FTASKCLASSNAME,T2.FCLASSNAME,T1.FRUNBYUSERID,T1.FPARAMS,T2.FAPPID,T2.FPLUGINTYPE,T2.FKSSCRIPTID,T1.FSTATUS,T1.FTIMEOUT,T1.FRETRYTIME,T1.FRUNBYORGID,T1.FRUNBYLANG,T1.FTASKDEFINEID,T1.FCONCURRENT,T1.FRUNMODE, T1.FSTRATEGY,T1.FCANSTOP,T1.FTASKTRACE,").append("T3.FFAILNOTIFY,T3.FSUCCESSNOTIFY,T3.FABORTED,T3.FMSGCONTENT,T3.FJOBPRINCIPAL,T3.FNOTIFYTYPE,T3.FCAPTION,T3.FOVERTIME,T3.FJOBMSGRECEIVER ").append("FROM T_SCH_JOB T1 LEFT\u3000JOIN T_SCH_TASKDEFINE T2 ON T2.FID = T1.FTASKDEFINEID LEFT JOIN T_SCH_JOB_N T3 ON T1.FID=T3.FID ").append("WHERE T1.FID = ?");
        Object[] params = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)jobId)};
        JobInfo jobInfo = (JobInfo)DB.query((DBRoute)Sch_Route, (String)strSQLBuilder.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<JobInfo>(){

            public JobInfo handle(ResultSet rs) throws Exception {
                JobInfo jobInfo = new JobInfo();
                if (rs.next()) {
                    String status;
                    jobInfo.setId(rs.getString("FID"));
                    jobInfo.setJobType(JobType.valueOf((String)rs.getString("FJOBTYPE")));
                    jobInfo.setNumber(rs.getString("FNUMBER"));
                    String className = rs.getString("FCLASSNAME");
                    if (StringUtils.isBlank((CharSequence)className)) {
                        className = rs.getString("FTASKCLASSNAME");
                    }
                    jobInfo.setTaskClassname(className);
                    jobInfo.setRunByUserId(rs.getLong("FRUNBYUSERID"));
                    if (StringUtils.isNotBlank((CharSequence)rs.getString("fappid"))) {
                        jobInfo.setAppId(rs.getString("fappid"));
                    }
                    jobInfo.setTimeout(rs.getInt("FTIMEOUT"));
                    jobInfo.setRetryTime(rs.getInt("FRETRYTIME"));
                    if (StringUtils.isNotBlank((CharSequence)rs.getString("FPARAMS"))) {
                        Map parammap = (Map)SerializationUtils.fromJsonString((String)rs.getString("FPARAMS"), Map.class);
                        jobInfo.setParams(parammap);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(status = rs.getString("FSTATUS"))) && status.equals("1")) {
                        jobInfo.setEnable(true);
                    } else {
                        jobInfo.setEnable(false);
                    }
                    jobInfo.setRunByOrgId(rs.getLong("FRUNBYORGID"));
                    String runByLang = rs.getString("FRUNBYLANG");
                    if (StringUtils.isNotEmpty((CharSequence)runByLang)) {
                        jobInfo.setRunByLang(Lang.from((String)runByLang));
                    }
                    jobInfo.setTaskDefineId(rs.getString("FTASKDEFINEID"));
                    String concurrent = rs.getString("FCONCURRENT");
                    if ("0".equals(concurrent)) {
                        jobInfo.setRunConcurrently(false);
                    } else {
                        jobInfo.setRunConcurrently(true);
                    }
                    if (Objects.isNull(rs.getBoolean(DbJobDao.FFAIL_NOTIFY))) {
                        jobInfo.setFailNotify(false);
                    } else {
                        jobInfo.setFailNotify(rs.getBoolean(DbJobDao.FFAIL_NOTIFY));
                    }
                    if (Objects.isNull(rs.getBoolean(DbJobDao.FSUCCESS_NOTIFY))) {
                        jobInfo.setSuccessNotify(false);
                    } else {
                        jobInfo.setSuccessNotify(rs.getBoolean(DbJobDao.FSUCCESS_NOTIFY));
                    }
                    if (Objects.isNull(rs.getBoolean(DbJobDao.FOVERTIME))) {
                        jobInfo.setOverTime(false);
                    } else {
                        jobInfo.setOverTime(rs.getBoolean(DbJobDao.FOVERTIME));
                    }
                    if (Objects.isNull(rs.getBoolean(DbJobDao.FABORTED))) {
                        jobInfo.setAborted(false);
                    } else {
                        jobInfo.setAborted(rs.getBoolean(DbJobDao.FABORTED));
                    }
                    if (Objects.isNull(rs.getBoolean(DbJobDao.FTASKTRACE))) {
                        jobInfo.setTaskTrace(false);
                    } else {
                        jobInfo.setTaskTrace(rs.getBoolean(DbJobDao.FTASKTRACE));
                    }
                    jobInfo.setNotifyType(rs.getString("fnotifytype"));
                    jobInfo.setJobPrincipal(rs.getLong("fjobprincipal"));
                    jobInfo.setCaption(rs.getString("fcaption"));
                    jobInfo.setMsgContent(rs.getString("fmsgcontent"));
                    jobInfo.setStrategy(rs.getString("fstrategy"));
                    jobInfo.setJobMsgReceiver(rs.getLong("fjobmsgreceiver"));
                    String frunmode = rs.getString("frunmode");
                    DbJobDao.this.setRouteMode(jobInfo, frunmode);
                    jobInfo.setCanStop(Boolean.valueOf(rs.getBoolean("fcanstop")));
                    if (StringUtils.isNotBlank((CharSequence)rs.getString("fplugintype"))) {
                        jobInfo.setPluginType(PluginType.getPluginType((String)rs.getString("fplugintype")));
                    }
                    jobInfo.setKsScriptId(rs.getString("fksscriptid"));
                }
                return jobInfo;
            }
        });
        String strSQL = "SELECT FID,FPKID,FLOCALEID,FNAME FROM T_SCH_JOB_L  WHERE FID = ?";
        params = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)jobId)};
        LocaleString name = (LocaleString)DB.query((DBRoute)Sch_Route, (String)strSQL, (Object[])params, rs -> {
            LocaleString lName = new LocaleString();
            while (rs.next()) {
                lName.setItem(rs.getString("FLOCALEID"), (Object)rs.getString("FNAME"));
            }
            if (lName.isEmpty()) {
                lName = null;
            }
            return lName;
        });
        jobInfo.setlName(name);
        return jobInfo;
    }

    private String getLocale() {
        Locale locale = RequestContext.get().getLang().getLocale();
        return locale.toString();
    }

    public void writeErrorJobInfo(ErrorJobInfo errorJobInfo) {
        String insertSQL = "INSERT INTO t_sch_errorjob (FTASKID, FJOBID, FEXECUTETIME, FRUNAT, FERRORREASON)  VALUES (?, ?, ?, ?, ?)";
        Object[] params = new SqlParameter[]{new SqlParameter(":FTASKID", 12, (Object)errorJobInfo.getTaskId()), new SqlParameter(":FJOBID", 12, (Object)errorJobInfo.getJobId()), new SqlParameter(":FEXECUTETIME", 91, (Object)errorJobInfo.getExecuteTime()), new SqlParameter(":FRUNAT", 12, (Object)errorJobInfo.getRunat()), new SqlParameter(":FERRORREASON", 2011, (Object)errorJobInfo.getErrorReason())};
        try (TXHandle handle = TX.notSupported();){
            try {
                DB.update((DBRoute)Sch_Route, (String)insertSQL, (Object[])params);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                handle.markRollback();
                throw new KDException(BosErrorCode.sQL, new Object[]{e});
            }
        }
        try {
            if (errorJobInfo.getJobInfo().getRetryTime() > 0 && !errorJobInfo.getErrorReason().contains("TimeoutException") && errorJobInfo.getJobInfo().getRetryRecord() != -1) {
                DbJobOperation.RetrySaveFailureJobInfo((JobInfo)errorJobInfo.getJobInfo());
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    public boolean disableJob(String jobId) {
        if (StringUtils.isBlank((CharSequence)jobId) || jobId.trim().length() == 0) {
            return false;
        }
        String strSQL = "UPDATE T_SCH_JOB SET FSTATUS = '0',FMODIFIERID = ?, FMODIFYTIME = ? WHERE FID= ? ";
        RequestContext rc = RequestContext.get();
        Timestamp now = new Timestamp(System.currentTimeMillis());
        Object[] params = new SqlParameter[]{new SqlParameter(":FMODIFIERID", -5, (Object)rc.getCurrUserId()), new SqlParameter(":FMODIFYTIME", 93, (Object)now), new SqlParameter(":FID", 12, (Object)jobId)};
        Throwable throwable = null;
        try (TXHandle handle = TX.requiresNew();){
            boolean result = DB.execute((DBRoute)Sch_Route, (String)strSQL, (Object[])params);
            if (result) {
                this.updateDataEntityCache(new Object[]{jobId});
            }
            boolean bl = result;
            return bl;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            handle.markRollback();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        return false;
    }

    public boolean enableJob(String jobId) {
        if (StringUtils.isBlank((CharSequence)jobId) || jobId.trim().length() == 0) {
            return false;
        }
        String strSQL = "UPDATE T_SCH_JOB SET FSTATUS = '1',FMODIFIERID = ?, FMODIFYTIME = ? WHERE FID= ? ";
        RequestContext rc = RequestContext.get();
        Timestamp now = new Timestamp(System.currentTimeMillis());
        Object[] params = new SqlParameter[]{new SqlParameter(":FMODIFIERID", -5, (Object)rc.getCurrUserId()), new SqlParameter(":FMODIFYTIME", 93, (Object)now), new SqlParameter(":FID", 12, (Object)jobId)};
        Throwable throwable = null;
        try (TXHandle handle = TX.requiresNew();){
            boolean result = DB.execute((DBRoute)Sch_Route, (String)strSQL, (Object[])params);
            if (result) {
                this.updateDataEntityCache(new Object[]{jobId});
            }
            boolean bl = result;
            return bl;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            handle.markRollback();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        return false;
    }

    private void updateDataEntityCache(Object[] ids) {
        ScheduleDataEntityUtils.getInvoker().updateDataEntityCache(SchEntityType.Job, ids);
    }

    public boolean isBOSApp(String appId) {
        String strSQL = "SELECT FAPPID FROM T_META_APPRUNTIME WHERE FCLOUDID IN ('83bfebc8000008ac','83bfebc800000bac','18Y30L1D2HS4') AND FAPPID = ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":FAPPID", 12, (Object)appId)};
        return (Boolean)DB.query((DBRoute)META_ROUTE, (String)strSQL, (Object[])params, rs -> rs.next());
    }

    private boolean isJSONValid(String msgContent) {
        try {
            JSONObject.parseObject((String)msgContent);
        }
        catch (JSONException ex) {
            try {
                JSONObject.parseArray((String)msgContent);
            }
            catch (JSONException ex1) {
                return false;
            }
        }
        return true;
    }

    private void setRouteMode(JobInfo jobInfo, String routeMode) {
        if (StringUtils.isBlank((CharSequence)routeMode) || routeMode.equalsIgnoreCase("0")) {
            jobInfo.setRouteMode(RouteMode.RAMDOM);
        } else if (routeMode.equalsIgnoreCase("1")) {
            jobInfo.setRouteMode(RouteMode.SHARDINGBROADCAST);
        } else if (routeMode.equalsIgnoreCase("2")) {
            jobInfo.setRouteMode(RouteMode.SHARDINGTASK);
        }
    }

    public boolean save(JobInfo[] jobArray) {
        String strSQL = "INSERT INTO T_SCH_JOB (FID,FJOBTYPE,FTASKCLASSNAME,FRUNBYUSERID,FPARAMS,FNUMBER,FSTATUS,FTIMEOUT,FRUNBYORGID,FRUNBYLANG,FTASKDEFINEID,FCONCURRENT,FRETRYTIME,FSTRATEGY,FCREATORID,FCREATETIME,FMODIFIERID,FMODIFYTIME) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ";
        ArrayList<SqlParameter[]> paramss = new ArrayList<SqlParameter[]>(jobArray.length);
        ArrayList<SqlParameter[]> lparamss = new ArrayList<SqlParameter[]>(jobArray.length);
        ArrayList<SqlParameter[]> taskDefparamss = null;
        String taskDefineSql = null;
        for (JobInfo jobInfo : jobArray) {
            SqlParameter[] params = new SqlParameter[18];
            if (jobInfo.getId() == null) {
                long jobId = DB.genLongId((String)"T_SCH_JOB");
                jobInfo.setId(String.valueOf(jobId));
            }
            if (jobInfo.getlName() == null) {
                jobInfo.setlName(ResManager.getLocaleString((String)"\u81ea\u52a8\u751f\u6210", (String)"DbJobDao_0", (String)"bos-schedule-message"));
            }
            if (jobInfo.getJobType() == null) {
                jobInfo.setJobType(JobType.BIZ);
            }
            if (jobInfo.getRunByUserId() == 0L) {
                jobInfo.setRunByUserId(100L);
            }
            if (jobInfo.getNumber() == null) {
                jobInfo.setNumber("JOB" + new SecureRandom().nextDouble() * 10000.0);
            }
            if (StringUtils.isBlank((CharSequence)jobInfo.getTaskClassname())) {
                jobInfo.setTaskClassname(" ");
            }
            if (!jobInfo.isRunConcurrently() && StringUtils.isBlank((CharSequence)jobInfo.getStrategy())) {
                jobInfo.setStrategy("1");
            }
            params[0] = new SqlParameter(":FID", 12, (Object)jobInfo.getId());
            params[1] = new SqlParameter(":FJOBTYPE", 12, (Object)jobInfo.getJobType().name());
            params[2] = new SqlParameter(":FTASKCLASSNAME", 12, (Object)jobInfo.getTaskClassname());
            params[3] = new SqlParameter(":FRUNBYUSERID", -5, (Object)jobInfo.getRunByUserId());
            if (jobInfo.getParams() != null) {
                String paramStr = SerializationUtils.toJsonString((Object)jobInfo.getParams());
                params[4] = new SqlParameter(":FPARAMS", 12, (Object)paramStr);
            } else {
                params[4] = new SqlParameter(":FPARAMS", 12, (Object)"");
            }
            params[5] = new SqlParameter(":FNUMBER", 12, (Object)jobInfo.getNumber());
            params[6] = new SqlParameter(":FSTATUS", 12, (Object)(jobInfo.isEnable() ? "1" : "0"));
            params[7] = new SqlParameter(":FTIMEOUT", 4, (Object)jobInfo.getTimeout());
            params[8] = new SqlParameter(":FRUNBYORGID", -5, (Object)jobInfo.getRunByOrgId());
            params[9] = new SqlParameter(":FRUNBYLANG", 12, (Object)jobInfo.getRunByLang().toString());
            params[10] = new SqlParameter(":FTASKDEFINEID", 12, (Object)jobInfo.getTaskDefineId());
            params[11] = new SqlParameter(":FCONCURRENT", 12, (Object)(jobInfo.isRunConcurrently() ? "1" : "0"));
            params[12] = new SqlParameter(":FRETRYTIME", 4, (Object)jobInfo.getRetryTime());
            params[13] = new SqlParameter(":FSTRATEGY", 12, (Object)(jobInfo.getStrategy() == null ? "1" : jobInfo.getStrategy()));
            RequestContext rc = RequestContext.get();
            Timestamp now = new Timestamp(System.currentTimeMillis());
            params[14] = new SqlParameter(":FCREATORID", -5, (Object)rc.getCurrUserId());
            params[15] = new SqlParameter(":FCREATETIME", 93, (Object)now);
            params[16] = new SqlParameter(":FMODIFIERID", -5, (Object)0L);
            params[17] = new SqlParameter(":FMODIFYTIME", 93, (Object)now);
            paramss.add(params);
            LocaleString lName = jobInfo.getlName();
            if (lName != null) {
                for (Map.Entry entry : lName.entrySet()) {
                    String locale = (String)entry.getKey();
                    String name = (String)entry.getValue();
                    SqlParameter[] lparams = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)jobInfo.getId()), new SqlParameter(":FPKID", 12, (Object)Uuid16.create().toString()), new SqlParameter(":FLOCALEID", 12, (Object)locale), new SqlParameter(":FNAME", 12, (Object)name)};
                    lparamss.add(lparams);
                }
            }
            SqlParameter[] taskDefparams = new SqlParameter[8];
            if (JobType.BIZ != jobInfo.getJobType() || !StringUtils.isBlank((CharSequence)jobInfo.getTaskDefineId())) continue;
            taskDefparamss = new ArrayList<SqlParameter[]>(jobArray.length);
            taskDefineSql = "INSERT INTO T_SCH_TASKDEFINE (FID,FCLASSNAME,FNUMBER,FAPPID,FCREATORID,FCREATETIME,FMODIFIERID,FMODIFYTIME) VALUES (?, ?, ?, ?,?,?,?,?)";
            String taskDefinedId = String.valueOf(DB.genLongId((String)"T_SCH_TASKDEFINE"));
            taskDefparams[0] = new SqlParameter(":FID", 12, (Object)taskDefinedId);
            params[10] = new SqlParameter(":FTASKDEFINEID", 12, (Object)taskDefinedId);
            taskDefparams[1] = new SqlParameter(":FCLASSNAME", 12, (Object)jobInfo.getTaskClassname());
            taskDefparams[2] = new SqlParameter(":FNUMBER", 12, (Object)jobInfo.getNumber());
            String appId = jobInfo.getAppId();
            taskDefparams[3] = new SqlParameter(":FAPPID", 12, (Object)(StringUtils.isBlank((CharSequence)appId) ? "bos" : appId));
            taskDefparams[4] = new SqlParameter(":FCREATORID", -5, (Object)rc.getCurrUserId());
            taskDefparams[5] = new SqlParameter(":FCREATETIME", 93, (Object)now);
            taskDefparams[6] = new SqlParameter(":FMODIFIERID", -5, (Object)0L);
            taskDefparams[7] = new SqlParameter(":FMODIFYTIME", 93, (Object)now);
            taskDefparamss.add(taskDefparams);
        }
        String lSQL = "INSERT INTO T_SCH_JOB_L (FID,FPKID,FLOCALEID,FNAME) VALUES (?, ?, ?, ?) ";
        boolean isSuccess = true;
        try (TXHandle handle = TX.requiresNew();){
            try {
                if (StringUtils.isNotBlank(taskDefineSql)) {
                    DB.executeBatch((DBRoute)Sch_Route, taskDefineSql, taskDefparamss);
                }
                DB.executeBatch((DBRoute)Sch_Route, (String)strSQL, paramss);
                DB.executeBatch((DBRoute)Sch_Route, (String)lSQL, lparamss);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                handle.markRollback();
                throw new KDException(BosErrorCode.sQL, new Object[]{e});
            }
        }
        return isSuccess;
    }

    public boolean disableTaskTrace(String jobId) {
        if (StringUtils.isBlank((CharSequence)jobId) || jobId.trim().length() == 0) {
            return false;
        }
        String strSQL = "UPDATE T_SCH_JOB SET FTASKTRACE = '0',FMODIFIERID = ?, FMODIFYTIME = ? WHERE FID= ? ";
        RequestContext rc = RequestContext.get();
        Timestamp now = new Timestamp(System.currentTimeMillis());
        Object[] params = new SqlParameter[]{new SqlParameter(":FMODIFIERID", -5, (Object)rc.getCurrUserId()), new SqlParameter(":FMODIFYTIME", 93, (Object)now), new SqlParameter(":FID", 12, (Object)jobId)};
        Throwable throwable = null;
        try (TXHandle handle = TX.requiresNew();){
            boolean result = DB.execute((DBRoute)Sch_Route, (String)strSQL, (Object[])params);
            if (result) {
                this.updateDataEntityCache(new Object[]{jobId});
            }
            boolean bl = result;
            return bl;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            handle.markRollback();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        return false;
    }

    public boolean enableTaskTrace(String jobId) {
        if (StringUtils.isBlank((CharSequence)jobId) || jobId.trim().length() == 0) {
            return false;
        }
        String strSQL = "UPDATE T_SCH_JOB SET FTASKTRACE = '1',FMODIFIERID = ?, FMODIFYTIME = ? WHERE FID= ? ";
        RequestContext rc = RequestContext.get();
        Timestamp now = new Timestamp(System.currentTimeMillis());
        Object[] params = new SqlParameter[]{new SqlParameter(":FMODIFIERID", -5, (Object)rc.getCurrUserId()), new SqlParameter(":FMODIFYTIME", 93, (Object)now), new SqlParameter(":FID", 12, (Object)jobId)};
        Throwable throwable = null;
        try (TXHandle handle = TX.requiresNew();){
            boolean result = DB.execute((DBRoute)Sch_Route, (String)strSQL, (Object[])params);
            if (result) {
                this.updateDataEntityCache(new Object[]{jobId});
            }
            boolean bl = result;
            return bl;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            handle.markRollback();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        return false;
    }

    public Set<String> isExist(String[] jobIds) {
        if (jobIds == null || jobIds.length == 0) {
            return Collections.emptySet();
        }
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(jobIds.length);
        StringBuilder strSQL = new StringBuilder("SELECT FID FROM T_SCH_JOB WHERE FID in ( ");
        for (String jobId : jobIds) {
            strSQL.append("?,");
            params.add(new SqlParameter(":FID", 12, (Object)jobId));
        }
        strSQL.setLength(strSQL.length() - 1);
        strSQL.append(")");
        HashSet<String> ids = new HashSet<String>(6);
        try (DataSet rs = DB.queryDataSet((String)"DbJobDao.isExist", (DBRoute)Sch_Route, (String)strSQL.toString(), (Object[])params.toArray());){
            while (rs.hasNext()) {
                Row row = rs.next();
                ids.add(row.getString("fid"));
            }
        }
        return ids;
    }
}

