/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.server.broadcast;

import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.AbstractJobHandler;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.api.PluginType;
import kd.bos.schedule.api.ShardingUtil;
import kd.bos.schedule.api.StrategyType;
import kd.bos.schedule.api.Task;
import kd.bos.schedule.api.TaskHandler;
import kd.bos.schedule.dao.dbImpl.TaskCache;
import kd.bos.schedule.message.JobProcessor;
import kd.bos.schedule.zk.ActiveKeyValueStore;
import kd.bos.schedule.zk.ZkConfig;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class BroadcastJobHandler
extends AbstractJobHandler {
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"BOSSchedule-BroadcastJobHandler", (int)ZkConfig.getNumOfWorkThread());
    private static final String BOS_SCHEDULE_CORE = "bos-schedule-core";
    private static Log log = LogFactory.getLog(BroadcastJobHandler.class);
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));

    private ThreadPool getThreadPool() {
        return threadPool;
    }

    public BroadcastJobHandler() {
        this.taskHandlers = this.initTaskHandler();
        this.taskHandlers.put(PluginType.JAVA, TypesContainer.createInstance((String)"kd.bos.schedule.executor.BroadJavaTaskHandler"));
    }

    public void execute(RequestContext rc, MessageInfo message, JobInfo job) {
        String taskId = job.getTaskId();
        Callable<Task> taskTime = () -> {
            TaskHandler taskHandler;
            if (this.taskHandlers == null || this.taskHandlers.isEmpty()) {
                this.taskHandlers = this.initTaskHandler();
            }
            if ((taskHandler = (TaskHandler)this.taskHandlers.get(job.getPluginType())) == null) {
                throw new KDBizException(new ErrorCode("TASK_HANDLER_NULL", String.format(ResManager.loadKDString((String)"\u63d2\u4ef6\u7c7b\u578b\uff1a%s \u5bf9\u5e94\u7684\u4efb\u52a1\u5904\u7406\u5668\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BroadcastJobHandler_1", (String)BOS_SCHEDULE_CORE, (Object[])new Object[0]), job.getPluginType())), new Object[0]);
            }
            return taskHandler.execute(rc, message, job, (AbstractJobHandler)this);
        };
        ThreadPool executorPool = this.getThreadPool();
        Future future = executorPool.submit(taskTime);
        try {
            int timeout = job.getTimeout();
            if (timeout <= 0) {
                future.get();
            } else {
                future.get(timeout, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            if (this.isStop(taskId)) {
                BroadcastJobHandler.stop(taskId);
            }
            throw new RuntimeException(e.toString(), e);
        }
        catch (TimeoutException e) {
            if (StrategyType.WAITBEFORETASK.getValue().equals(job.getStrategy())) {
                String jobLockKey = JobProcessor.getJobLockKey((JobInfo)job);
                log.info("Schedule***\u540e\u53f0\u4e8b\u52a1-\u8d85\u65f6\u9501\u91ca\u653e:" + jobLockKey);
                DLock.forceUnlock((String[])new String[]{jobLockKey});
            }
            BroadcastJobHandler.TimeOut(taskId);
        }
    }

    private void setBroadcastParam(JobInfo job) {
        String appId = job.getAppId();
        ActiveKeyValueStore activeKeyValueStore = ActiveKeyValueStore.create();
        activeKeyValueStore.initAppIdExeServerMap(appId);
        TreeMap exeServerMap = activeKeyValueStore.getExeServerMap();
        String executorServerName = ZkConfig.getExecutorServerName();
        Integer index = (Integer)exeServerMap.get(executorServerName);
        if (exeServerMap.size() == 0) {
            ShardingUtil.setBroadcastVO((ShardingUtil.BroadcastVO)new ShardingUtil.BroadcastVO(0, 0));
            return;
        }
        if (index == null) {
            ShardingUtil.setBroadcastVO((ShardingUtil.BroadcastVO)new ShardingUtil.BroadcastVO(0, exeServerMap.size()));
        } else {
            ShardingUtil.setBroadcastVO((ShardingUtil.BroadcastVO)new ShardingUtil.BroadcastVO(index.intValue(), exeServerMap.size()));
        }
    }

    public static void TimeOut(String taskId) throws KDException {
        ErrorCode ec = new ErrorCode("TASK_TIMEOUT", taskId);
        throw new KDException(ec, new Object[0]);
    }

    public static void stop(String taskId) throws KDException {
        ErrorCode ec = new ErrorCode("TASK_STOPED_BY_USER", taskId);
        throw new KDException(ec, new Object[0]);
    }

    public boolean isStop(String taskId) {
        String type = "TASK";
        String key = RequestContext.get().getAccountId() + "_STOP_" + taskId;
        String stopVal = (String)cache.get(type, key);
        if (stopVal != null && stopVal.length() > 0) {
            return "stop".equalsIgnoreCase(stopVal);
        }
        return TaskCache.getStopStatus((String)taskId);
    }
}

