/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.botp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.ca.ISignOperateCallback;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.mc.BotpMCParam;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IDataProvider;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.operate.Operations;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.validate.IValidatorHanlder;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.AbstractFormView;
import kd.bos.form.ClientCallback;
import kd.bos.form.ClientMethodResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.SignCallbackEvent;
import kd.bos.form.SignCallbackLisenter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.botp.ConvertResultAttachment;
import kd.bos.form.plugin.botp.ConvertResultFormEdit;
import kd.bos.form.plugin.botp.util.ConvertResultFormUtil;
import kd.bos.list.ListShowParameter;
import kd.bos.mutex.AutoReleaseLock;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterReader;
import kd.bos.service.botp.facade.ConvertResultFormEditFacade;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.ca.SignServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import org.apache.commons.collections4.MapUtils;
import org.apache.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConvertResultFormEdit
extends AbstractFormPlugin
implements RowClickEventListener,
SignCallbackLisenter,
ICloseCallBack {
    private static final long serialVersionUID = -96803951999592516L;
    private static Logger log = Logger.getLogger(ConvertResultFormEdit.class);
    private static final String KEY_MC_SAVE_ALL_MODE = "botp.convert.result.saveallmode";
    private static final String VALUE_MC_SAVE_ALL_MODE_MAINTHREAD = "mainthread";
    public static final String CacheKey_ChildPageIsLoading = "isload";
    private static final String CACHEKEY_CHILDPAGEID = "childpageid";
    private static final String CACHEKEY_CURRBILLINDEX = "currbillindex";
    private static final String CACHEKEY_BILLCOUNT = "billcount";
    private static final String CACHEKEY_SAVECOUNT = "savecount";
    private static final String CACHEKEY_SUBMITCOUNT = "submitcount";
    private static final String CACHEKEY_AUDITCOUNT = "auditcount";
    private static final String CACHEKEY_MUTEX = "mutxt";
    private static final String CACHEKEY_PROGRESS = "progress";
    private static final String BARMAIN = "tbmain";
    private static final String KEY_BILLLISTENTRY = "billlist";
    private static final String KEY_CACHEPAGEID = "pageid";
    private static final String KEY_SAVESTATUS = "savestatus";
    private static final String KEY_BILLSTATUS = "billstatus";
    private static final String KEY_PKVALUE = "pkvalue";
    private static final String KEY_BILLNO = "billno";
    private static final String BILL_NO = "billNo";
    private static final String BILL_STATUS = "billStatus";
    private static final String KEY_PANELBILL = "panelbill";
    private static final String KEY_PANELREPORT = "panelreport";
    private static final String KEY_TBSAVE = "tbsave";
    private static final String KEY_TBSAVEALL = "tbsaveall";
    private static final String KEY_TBSUBMIT = "tbsubmit";
    private static final String KEY_TBSUBMITALL = "tbsubmitall";
    private static final String KEY_TBAUDIT = "tbaudit";
    private static final String KEY_TBAUDITALL = "tbauditall";
    private static final String KEY_TBCALLLIST = "tbcalllist";
    private static final String KEY_TBFIRST = "tbfirst";
    private static final String KEY_TBPREVIOUS = "tbprevious";
    private static final String KEY_TBNEXT = "tbnext";
    private static final String KEY_TBLAST = "tblast";
    private static final String BOS_BOTP_FORMPLUGIN = "bos-botp-formplugin";
    private static final String KEY_LBLBILLCOUNT = "lblbillcount";
    private static final String KEY_LBLSAVESTATUS = "lblsavestatus";
    private static final String ISEXISTCONFIRMMSG = "isExistConfirmMsg";
    private static final String MUTEX_OPERATIONKEY = "modify";
    private String mutex_NetCtrlGroupId = null;
    private static HashSet<String> moveBarItemKeys = new HashSet();
    private ConvertResultAttachment attachment;
    private ConvertResultFormEditFacade convertFormEditFacade = ConvertResultFormEditFacade.getInstance();
    private static final String KEY_FALSE = "false";
    private static final String KEY_SUBMIT = "submit";
    private static final String MUTEX_REQUIRE_ERROR = "MUTEX_REQUIRE_ERROR";
    private static final String BILLPARAMETER_POPUPSHOWREPORT = "resultfrompopupreport";
    protected static ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)"BotpOpThreadPool", (int)3, (int)12);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        this.addClickListeners(new String[]{"tbfirst", "tbprevious", "tbnext", "tblast"});
        EntryGrid grid = (EntryGrid)this.getView().getControl("billlist");
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getPageCache().put("billcount", "0");
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView == null) {
            return;
        }
        IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
        String simpleConvertResultJson = pageCache.get("ConvertOperationResult_Simple");
        ConvertOperationResult simpleConvertResult = (ConvertOperationResult)SerializationUtils.fromJsonString((String)simpleConvertResultJson, ConvertOperationResult.class);
        if (simpleConvertResult != null) {
            this.getAttachment().cacheAttachmentInfosAndCleanConvertResult(simpleConvertResult);
            this.updateConvertResult(pageCache.get("ConvertOperationResult"));
            this.fillBillListEntry(simpleConvertResult);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.move("tbfirst");
        this.showReport();
    }

    public void pageRelease(EventObject e) {
        this.releaseMutex();
        this.releasePushaMutex();
        ConvertOperationResult convertResult = this.getConvertResult();
        if (convertResult == null) {
            return;
        }
        MainEntityType mainType = this.getTargetMainType();
        convertResult.release(this.buildRefLoader(), mainType);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (itemKey.equalsIgnoreCase("tbsave")) {
            this.save();
        } else if (itemKey.equalsIgnoreCase("tbsaveall")) {
            this.saveAll(false, null);
        } else if (itemKey.equalsIgnoreCase("tbsubmit")) {
            this.submit();
        } else if (itemKey.equalsIgnoreCase("tbsubmitall")) {
            this.submitAll();
        } else if (itemKey.equalsIgnoreCase("tbaudit")) {
            this.audit();
        } else if (itemKey.equalsIgnoreCase("tbauditall")) {
            this.auditAll();
        } else if (itemKey.equalsIgnoreCase("tbcalllist")) {
            this.showList();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control srcControl = (Control)evt.getSource();
        if (moveBarItemKeys.contains(srcControl.getKey())) {
            this.move(srcControl.getKey());
        }
    }

    public void entryRowClick(RowClickEvent e) {
        int rowIndex = e.getRow();
        this.showBill(rowIndex);
    }

    public void customEvent(CustomEventArgs e) {
        if (StringUtils.equals((CharSequence)e.getKey(), (CharSequence)"InCurrentForm") && StringUtils.isNotBlank((CharSequence)e.getEventArgs())) {
            Map params = (Map)SerializationUtils.fromJsonString((String)e.getEventArgs(), Map.class);
            String cachePageId = this.getPageCache().get("childpageid");
            String oldPageId = (String)params.get("oldPageId");
            String newPageId = (String)params.get("newPageId");
            if (StringUtils.equals((CharSequence)cachePageId, (CharSequence)oldPageId)) {
                this.getPageCache().put("childpageid", newPageId);
            }
        }
    }

    private void fillBillListEntry(ConvertOperationResult simpleConvertResult) {
        int count = simpleConvertResult.getTargetBillIds().size() + simpleConvertResult.getCachePageIds().size();
        int rowCount = this.getModel().getEntryRowCount("billlist");
        if (rowCount < count) {
            this.getModel().batchCreateNewEntryRow("billlist", count - rowCount);
        } else {
            for (int i = rowCount - 1; i >= count; --i) {
                this.getModel().deleteEntryRow("billlist", i);
            }
        }
        MainEntityType mainType = this.getTargetMainType();
        int rowIndex = 0;
        int savedCount = 0;
        for (String cachePageId : simpleConvertResult.getCachePageIds()) {
            this.getModel().setValue("pageid", (Object)cachePageId, rowIndex);
            this.getModel().setValue("savestatus", (Object)String.valueOf(SaveStatus.UN_SAVE.getValue()), rowIndex);
            this.getModel().setValue("billstatus", (Object)ResManager.loadKDString((String)"\u6682\u5b58", (String)"ConvertResultFormEdit_51", (String)"bos-botp-formplugin", (Object[])new Object[0]), rowIndex);
            this.getModel().setValue("billno", (Object)this.getPushedBillNo(simpleConvertResult, mainType, cachePageId), rowIndex);
            this.getModel().setValue("pkvalue", (Object)0, rowIndex);
            ++rowIndex;
        }
        Map<Object, Map<String, String>> billNos = this.loadBillNoFromDB(simpleConvertResult.getTargetEntityNumber(), simpleConvertResult.getTargetBillIds().toArray());
        for (Object pkId : simpleConvertResult.getTargetBillIds()) {
            this.getModel().setValue("pageid", (Object)"", rowIndex);
            this.getModel().setValue("savestatus", (Object)String.valueOf(SaveStatus.SAVED.getValue()), rowIndex);
            this.getModel().setValue("billstatus", (Object)billNos.get(pkId).get("billStatus"), rowIndex);
            this.getModel().setValue("billno", (Object)billNos.get(pkId).get("billNo"), rowIndex);
            this.getModel().setValue("pkvalue", pkId, rowIndex);
            ++rowIndex;
            ++savedCount;
        }
        this.getPageCache().put("billcount", String.valueOf(count));
        this.getPageCache().put("savecount", String.valueOf(savedCount));
        this.getPageCache().put("submitcount", String.valueOf(0));
        this.getPageCache().put("auditcount", String.valueOf(0));
        ConvertResultFormUtil.refreshSaveTips((IFormView)this.getView());
    }

    private String getPushedBillNo(ConvertOperationResult convertResult, MainEntityType mainType, String cachePageId) {
        if (!(mainType instanceof BillEntityType)) {
            return "";
        }
        String billNoKey = ((BillEntityType)mainType).getBillNo();
        if (StringUtils.isBlank((CharSequence)billNoKey)) {
            return "";
        }
        String billNo = (String)convertResult.getCacheTargetBillno().get(cachePageId);
        return billNo;
    }

    private Map<Object, Map<String, String>> loadBillNoFromDB(String entityNumber, Object[] ids) {
        HashMap<Object, Map<String, String>> billNos = new HashMap<Object, Map<String, String>>();
        if (StringUtils.isBlank((CharSequence)entityNumber) || ids.length == 0) {
            return billNos;
        }
        BillEntityType mainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (StringUtils.isNotBlank((CharSequence)mainType.getBillNo())) {
            DynamicObject[] objs;
            ArrayList<String> selectedFields = new ArrayList<String>();
            selectedFields.add("id");
            selectedFields.add(mainType.getBillNo());
            selectedFields.add(mainType.getBillStatus());
            BillEntityType subMainType = (BillEntityType)mainType.getSubEntityType(selectedFields);
            for (DynamicObject obj : objs = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)subMainType)) {
                HashMap<String, String> map = new HashMap<String, String>();
                String billNo = obj.getString(mainType.getBillNo());
                BillStatusProp billStatusProp = (BillStatusProp)mainType.getAllFields().get(mainType.getBillStatus());
                String billStatus = obj.getString(mainType.getBillStatus());
                billStatus = billStatusProp.getStatusItem(billStatus).getStatusName().getLocaleValue();
                map.put("billNo", billNo);
                map.put("billStatus", billStatus);
                billNos.put(obj.getPkValue(), map);
            }
        }
        return billNos;
    }

    private void showList() {
        HashSet<Long> billIds = new HashSet<Long>();
        this.getModel().getDataEntity(true);
        int rowCount = this.getModel().getEntryRowCount("billlist");
        Long zero = 0L;
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            Long billId;
            int saveStatus = Integer.parseInt((String)this.getModel().getValue("savestatus", rowIndex));
            if (saveStatus == SaveStatus.UN_SAVE.getValue() || (billId = (Long)this.getModel().getValue("pkvalue", rowIndex)).compareTo(zero) == 0 || billIds.contains(billId)) continue;
            billIds.add(billId);
        }
        if (billIds.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u751f\u6210\u7684\u5355\u636e\uff0c\u7136\u540e\u518d\u6253\u5f00\u5217\u8868\uff0c\u8fdb\u884c\u5176\u4ed6\u64cd\u4f5c\u3002", (String)"ConvertResultFormEdit_0", (String)"bos-botp-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter qFilter = null;
        qFilter = billIds.size() == 1 ? new QFilter("id", "=", billIds.iterator().next()) : new QFilter("id", "in", (Object)billIds.toArray(new Long[billIds.size()]));
        String billFormId = this.getTargetEntityNumber();
        ConvertOperationResult convertOperationResult = this.getConvertResult();
        if (convertOperationResult != null && StringUtils.isNotBlank((CharSequence)convertOperationResult.getTargetBillFormId())) {
            billFormId = convertOperationResult.getTargetBillFormId();
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(billFormId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCaption(ResManager.loadKDString((String)"\u4e0b\u63a8\u5217\u8868", (String)"ConvertResultFormEdit_1", (String)"bos-botp-formplugin", (Object[])new Object[0]));
        showParameter.getCustomParams().put("bos_call_source_type", "botp_track");
        showParameter.addCustPlugin("kd.bos.form.plugin.botp.ConvertResultList");
        for (Long billId : billIds) {
            showParameter.addLinkQueryPkId((Object)billId);
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showReport() {
        boolean showReport = false;
        String parmValue = (String)this.getView().getFormShowParameter().getCustomParam("showreport");
        if (StringUtils.isNotBlank((CharSequence)parmValue)) {
            showReport = Boolean.parseBoolean(parmValue);
        }
        if (!showReport) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"panelreport"});
        } else {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("botp_convertreport");
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey("panelreport");
            showParameter.setShowTitle(false);
            showParameter.getCustomParams().put("convertresultpageid", this.getView().getFormShowParameter().getParentPageId());
            this.getView().showForm(showParameter);
        }
    }

    private void showBill(int billIndex) {
        if (billIndex < 0) {
            return;
        }
        boolean processing = false;
        String cacheProcessing = this.getPageCache().get("isload");
        if (StringUtils.isNotBlank((CharSequence)cacheProcessing)) {
            processing = Boolean.parseBoolean(cacheProcessing);
        }
        if (processing) {
            return;
        }
        if (this.isUploadingAttachments()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9644\u4ef6\u4e0a\u4f20\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ConvertResultFormEdit_32", (String)"bos-botp-formplugin", (Object[])new Object[0]));
            return;
        }
        String cacheRowIndex = this.getPageCache().get("currbillindex");
        if (StringUtils.isNotBlank((CharSequence)cacheRowIndex)) {
            int currRowIndex = Integer.parseInt(cacheRowIndex);
            if (billIndex == currRowIndex) {
                return;
            }
            if (this.updateChildViewDataChange() == null) {
                return;
            }
        }
        this.getPageCache().put("isload", String.valueOf(true));
        String cachePageId = (String)this.getModel().getValue("pageid", billIndex);
        Object pk = this.getModel().getValue("pkvalue", billIndex);
        if (StringUtils.isBlank((CharSequence)cachePageId) && StringUtils.isNotBlank((Object)pk)) {
            ConvertOperationResult result = this.getConvertResult();
            if (result == null) {
                return;
            }
            DynamicObject object = result.loadAutoSavedDataObjects((IDataProvider)new /* Unavailable Anonymous Inner Class!! */, this.getTargetMainType(), pk);
            List list = result.cacheAutoSavedDataObjects(null, this.getTargetMainType(), Collections.singletonList(object));
            cachePageId = String.valueOf(list.get(0));
            this.getModel().setValue("pageid", list.get(0), billIndex);
            this.updateConvertResult(result);
        }
        String childPageId = this.getPageCache().get("childpageid");
        this.getPageCache().put("currbillindex", String.valueOf(billIndex));
        if (StringUtils.isBlank((CharSequence)childPageId)) {
            this.showChildView(cachePageId);
        } else {
            this.refreshChildView(cachePageId);
        }
        this.refreshNavBarItem();
    }

    private boolean isUploadingAttachments() {
        boolean isUploading = false;
        String childPageId = this.getPageCache().get("childpageid");
        if (StringUtils.isNotBlank((CharSequence)childPageId)) {
            IFormView childView = this.getView().getView(childPageId);
            if (childView == null) {
                return isUploading;
            }
            String attachmentUploading = childView.getPageCache().get("UploadingAtt" + childPageId);
            isUploading = StringUtils.isNotBlank((CharSequence)attachmentUploading);
        }
        return isUploading;
    }

    private void showChildView(String cachePageId) {
        String targetEntityNumber = this.getTargetEntityNumber();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)targetEntityNumber);
        boolean isBasedata = mainType instanceof BasedataEntityType;
        Object showParameter = null;
        showParameter = isBasedata ? new BaseShowParameter() : new BillShowParameter();
        showParameter.setFormId(this.getConvertResult().getTargetBillFormId());
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setCachePageId(cachePageId);
        showParameter.setHasRight(true);
        showParameter.getCustomParams().put("isIgnoreLicense", true);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("panelbill");
        showParameter.getCustomParams().put("hidemainbar", String.valueOf(true));
        showParameter.getCustomParams().put("keepresult", String.valueOf(true));
        showParameter.getCustomParams().put("botptag_of_datasource", String.valueOf(true));
        showParameter.getCustomParams().put("botp_child_view_from_Convert_Result_Form", String.valueOf(true));
        showParameter.addCustPlugin("kd.bos.form.plugin.botp.ConvertTrackerEdit");
        Map billParameter = SystemParamServiceHelper.loadBillParameterObjectFromCache((String)this.getSourceEntityNumber());
        if (MapUtils.isNotEmpty((Map)billParameter)) {
            boolean popupShowReport = (Boolean)billParameter.get("resultfrompopupreport");
            showParameter.getCustomParams().put("showreport", String.valueOf(popupShowReport));
        }
        this.getView().showForm((FormShowParameter)showParameter);
        this.getPageCache().put("childpageid", showParameter.getPageId());
        this.getPageCache().put("isload", String.valueOf(true));
    }

    private void refreshChildView(String cachePageId) {
        MainEntityType mainEntityType = this.getTargetMainType();
        IRefrencedataProvider refLoader = this.buildRefLoader();
        ConvertOperationResult convertResult = this.getConvertResult();
        DynamicObject dataEntity = convertResult.loadTargetDataObject(refLoader, mainEntityType, cachePageId);
        if (dataEntity == null) {
            return;
        }
        this.convertFormEditFacade.beforeCreateDataForChildView(this.getPageCache(), dataEntity);
        this.refreshChildView(dataEntity);
    }

    private void refreshChildView(DynamicObject dataEntity) {
        String childPageId = this.getPageCache().get("childpageid");
        IFormView childView = this.getView().getView(childPageId);
        ((IBillModel)childView.getModel()).push((Object)dataEntity);
        BillOperationStatus billOperationStatus = this.getBillOperationStatus(dataEntity);
        if (billOperationStatus != null) {
            ((BillShowParameter)childView.getFormShowParameter()).setBillStatus(billOperationStatus);
        }
        this.clearChildViewTempAttCacheAfterSaveAll();
        childView.updateView();
        this.getView().sendFormAction(childView);
    }

    private BillOperationStatus getBillOperationStatus(DynamicObject dataEntity) {
        BillOperationStatus status = null;
        BillEntityType billDT = (BillEntityType)dataEntity.getDataEntityType();
        String billStatusFieldKey = billDT.getBillStatus();
        Object billStatus = null;
        if (StringUtils.isNotBlank((CharSequence)billStatusFieldKey)) {
            billStatus = dataEntity.get(billStatusFieldKey);
        }
        if (billStatus != null) {
            if ("A".equals(billStatus)) {
                boolean bFromDb = dataEntity.getDataEntityState().getFromDatabase();
                status = bFromDb ? BillOperationStatus.EDIT : BillOperationStatus.ADDNEW;
            } else if ("B".equals(billStatus)) {
                status = BillOperationStatus.SUBMIT;
            } else if ("C".equals(billStatus)) {
                status = BillOperationStatus.AUDIT;
            }
        }
        return status;
    }

    private ConvertOperationResult updateChildViewDataChange() {
        String childPageId = this.getPageCache().get("childpageid");
        String currRowIndex = this.getPageCache().get("currbillindex");
        if (StringUtils.isBlank((CharSequence)childPageId) || StringUtils.isBlank((CharSequence)currRowIndex)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u9875\u9762\u5185\u5bb9\u8fd8\u5728\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ConvertResultFormEdit_21", (String)"bos-botp-formplugin", (Object[])new Object[0]));
            return null;
        }
        int rowIndex = Integer.parseInt(currRowIndex);
        String cachePageId = (String)this.getModel().getValue("pageid", rowIndex);
        IBillView billView = (IBillView)this.getView().getView(childPageId);
        if (billView == null) {
            return null;
        }
        if (!billView.getModel().isDataLoaded()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u9875\u9762\u5185\u5bb9\u8fd8\u672a\u52a0\u8f7d\u5b8c\u6bd5\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ConvertResultFormEdit_22", (String)"bos-botp-formplugin", (Object[])new Object[0]));
            return null;
        }
        DynamicObject billObj = billView.getModel().getDataEntity(true);
        this.getAttachment().updateChildViewAttachment(billObj.getPkValue(), (IFormView)billView);
        ConvertOperationResult convertResult = this.getConvertResult();
        convertResult.updateTargetDataObject(cachePageId, billObj);
        this.updateConvertResult(convertResult);
        return convertResult;
    }

    private void save() {
        String childPageId = this.getPageCache().get("childpageid");
        IFormView childView = this.getView().getView(childPageId);
        if (childView != null) {
            this.getAttachment().updateCurrentChildViewAttachment(childView);
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("isshowmessage", "false");
            operateOption.setVariableValue("isStrict", "false");
            operateOption.setVariableValue("botptag_of_datasource", String.valueOf(true));
            OperationResult saveResult = this.getOperationResult(childView, operateOption, "save");
            this.getView().sendFormAction(childView);
            if (saveResult == null) {
                return;
            }
        }
    }

    private OperationResult getOperationResult(IFormView childView, OperateOption operateOption, String operKey) {
        OperationResult operationResult = null;
        Map saveParam = EntityMetadataCache.getDataEntityOperate((String)childView.getEntityId(), (String)operKey);
        LinkedHashMap confirmMsg = (LinkedHashMap)saveParam.get("confirmMsg");
        LocaleString localeString = LocaleString.fromMap((Map)confirmMsg);
        String msg = localeString.toString();
        operationResult = childView.invokeOperation(operKey, operateOption);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            childView.getPageCache().put(operKey + "_" + "isExistConfirmMsg", "true");
            this.getView().sendFormAction(childView);
            return null;
        }
        return operationResult;
    }

    private void saveAll(boolean signCallback, SignCallbackEvent evt) {
        ConvertOperationResult convertResult = this.updateChildViewDataChange();
        if (convertResult == null) {
            return;
        }
        HashMap<SaveStatus, List<DynamicObject>> billObjs = new HashMap<SaveStatus, List<DynamicObject>>(16);
        this.getOpBillObjs(convertResult, billObjs, null);
        int count = this.getModel().getEntryEntity("billlist").size();
        List<DynamicObject> beforeSaveObjs = this.getSaveObjs(billObjs, count);
        if (beforeSaveObjs.isEmpty()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u7ecf\u5168\u90e8\u4fdd\u5b58\u6210\u529f\u3002", (String)"ConvertResultFormEdit_20", (String)"bos-botp-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean needSign = SignServiceHelper.needSign((String)"", (String)this.getTargetEntityNumber(), (String)"save");
        try {
            this.saveAllByAnsy(signCallback, evt, convertResult, beforeSaveObjs, needSign);
        }
        catch (KDException e) {
            log.error((Object)e);
            if (e.getErrorCode() != null && "MUTEX_REQUIRE_ERROR".equals(e.getErrorCode().getCode())) {
                this.getView().showErrorNotification(e.getMessage());
            }
            throw e;
        }
    }

    private void saveAllByAnsy(boolean signCallback, SignCallbackEvent evt, ConvertOperationResult convertResult, List<DynamicObject> beforeSaveObjs, boolean needSign) {
        OperateOption operateOption = this.createOperateOption(signCallback, evt);
        if (needSign || this.isMainThreadSaveAll() || beforeSaveObjs.size() <= BotpMCParam.getIntValue((String)"botp_min_batch_save_all_size")) {
            OperationResult mergeResult = this.batchSaveAll("save", SaveStatus.SAVED, beforeSaveObjs.toArray(new DynamicObject[0]), null, operateOption);
            if (mergeResult != null && mergeResult.getSuccessPkIds() != null && !mergeResult.getSuccessPkIds().isEmpty()) {
                this.doAfterOperation(mergeResult, SaveStatus.SAVED, convertResult);
            }
            if (mergeResult != null) {
                ConvertResultFormUtil.refreshSaveTips((IFormView)this.getView());
                this.showOperationResult(ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"ConvertResultFormEdit_2", (String)"bos-botp-formplugin", (Object[])new Object[0]), mergeResult);
            }
        } else {
            this.showProgressLoading(ResManager.loadKDString((String)"\u4fdd\u5b58\u5168\u90e8\u5355\u636e", (String)"ConvertResultFormEdit_25", (String)"bos-botp-formplugin", (Object[])new Object[0]), "checkSaveProgresslater");
            this.splitBatchCallOpService(convertResult, beforeSaveObjs, operateOption);
        }
    }

    private boolean isMainThreadSaveAll() {
        String saveAllMode = System.getProperty("botp.convert.result.saveallmode");
        return "mainthread".equalsIgnoreCase(saveAllMode);
    }

    private void splitBatchCallOpService(ConvertOperationResult convertResult, List<DynamicObject> beforeSaveObjs, OperateOption operateOption) {
        IFormView view = this.getView();
        int totalSaveObjCount = beforeSaveObjs.size();
        view.getPageCache().put("currentCount", "0");
        threadPool.submit((Callable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private OperationResult batchSaveAll(String opKey, SaveStatus status, DynamicObject[] billObjs, Object[] billIds, OperateOption operateOption) {
        String targetEntityNumber = this.getTargetEntityNumber();
        OperationResult opResult = null;
        if (billObjs != null) {
            opResult = OperationServiceHelper.executeOperate((String)opKey, (String)targetEntityNumber, (DynamicObject[])billObjs, (OperateOption)operateOption);
        } else if (billIds != null) {
            opResult = OperationServiceHelper.executeOperate((String)opKey, (String)targetEntityNumber, (Object[])billIds, (OperateOption)operateOption);
        }
        if (opResult != null && !opResult.isSuccess() && opResult.isNeedSign()) {
            ISignOperateCallback signOperateCallback = (ISignOperateCallback)TypesContainer.createInstance((String)"kd.bos.form.operate.SignOperateCallback");
            opResult = signOperateCallback.beforeSign(this.getView(), (SignCallbackLisenter)this, operateOption, ClientCallback.SignClientType.Secondry, status.toString()).sign(opResult);
            if (!opResult.isSuccess() && opResult.isShowMessage()) {
                this.getView().showOperationResult(opResult, opKey);
            }
            return null;
        }
        return opResult;
    }

    private void updateAsyncBatchProgress(IFormView view, int totalObjCount, int currentBatchSize, String resultKey) {
        IPageCache cache = view.getPageCache();
        String oldProgressStr = cache.get(resultKey + "progress");
        double oldProgress = StringUtils.isBlank((CharSequence)oldProgressStr) ? 0.0 : Double.parseDouble(oldProgressStr);
        String oldCountStr = cache.get("currentCount");
        int oldCount = StringUtils.isBlank((CharSequence)oldCountStr) ? 0 : Integer.parseInt(oldCountStr);
        int currentCount = oldCount + currentBatchSize;
        double progress = (double)currentCount * 100.0 / (double)totalObjCount;
        if (progress > oldProgress) {
            cache.put("currentCount", String.valueOf(currentCount));
        }
        cache.put(resultKey + "progress", progress < 100.0 ? String.valueOf(progress) : "99");
        cache.saveChanges();
    }

    private List<List<DynamicObject>> splitObjs(List<DynamicObject> beforeObjs) {
        int rowBatchSize = Math.max(BotpMCParam.getIntValue((String)"botp_min_batch_save_all_size"), beforeObjs.size() / 100);
        ArrayList<List<DynamicObject>> groupBatchObjs = new ArrayList<List<DynamicObject>>();
        ArrayList<DynamicObject> batchObjs = new ArrayList<DynamicObject>();
        int batchRowCount = 0;
        for (DynamicObject obj : beforeObjs) {
            int entryRowCount = this.countEntryRow(obj);
            int realRowCount = Math.max(1, entryRowCount);
            if (!batchObjs.isEmpty() && batchRowCount + realRowCount > rowBatchSize) {
                groupBatchObjs.add(batchObjs);
                batchObjs = new ArrayList();
                batchRowCount = 0;
            }
            batchObjs.add(obj);
            batchRowCount += realRowCount;
        }
        if (!batchObjs.isEmpty()) {
            groupBatchObjs.add(batchObjs);
        }
        return groupBatchObjs;
    }

    private List<List<Long>> splitIds(List<Long> beforeOpIds) {
        int rowBatchSize = Math.max(BotpMCParam.getIntValue((String)"botp_min_batch_save_all_size"), beforeOpIds.size() / 100);
        ArrayList<List<Long>> groupBatchIds = new ArrayList<List<Long>>();
        ArrayList<Long> batchIds = new ArrayList<Long>();
        int batchCount = 0;
        for (Long id : beforeOpIds) {
            if (!batchIds.isEmpty() && batchCount > rowBatchSize) {
                groupBatchIds.add(batchIds);
                batchIds = new ArrayList();
                batchCount = 0;
            }
            batchIds.add(id);
            ++batchCount;
        }
        if (!batchIds.isEmpty()) {
            groupBatchIds.add(batchIds);
        }
        return groupBatchIds;
    }

    private int countEntryRow(DynamicObject obj) {
        IDataEntityType entityType = obj.getDataEntityType();
        int entryRowCount = 0;
        for (ICollectionProperty entry : entityType.getProperties().getCollectionProperties(true)) {
            DynamicObjectCollection coll = obj.getDynamicObjectCollection((IDataEntityProperty)entry);
            int subEntryRowCount = 0;
            for (ICollectionProperty subentry : entry.getItemType().getProperties().getCollectionProperties(true)) {
                int subRowCount = 0;
                for (DynamicObject row : coll) {
                    subRowCount += row.getDynamicObjectCollection((IDataEntityProperty)subentry).getRowCount();
                }
                subEntryRowCount = Math.max(subEntryRowCount, subRowCount - 1);
            }
            entryRowCount = Math.max(entryRowCount, coll.getRowCount() + subEntryRowCount - 1);
        }
        return entryRowCount;
    }

    private List<DynamicObject> getSaveObjs(Map<SaveStatus, List<DynamicObject>> billObjs, int count) {
        ArrayList<DynamicObject> beforeSaveObjs = new ArrayList<DynamicObject>(count);
        for (Map.Entry<SaveStatus, List<DynamicObject>> entry : billObjs.entrySet()) {
            if (entry.getKey() != SaveStatus.UN_SAVE && entry.getKey() != SaveStatus.SAVED) continue;
            beforeSaveObjs.addAll((Collection<DynamicObject>)entry.getValue());
        }
        return beforeSaveObjs;
    }

    private void showProgressLoading(String subtitle, String callBackName) {
        IFormView view = this.getView();
        view.showLoading(new LocaleString(String.format(ResManager.loadKDString((String)"\u6b63\u5728%s\uff0c\u8bf7\u7a0d\u540e", (String)"ConvertResultFormEdit_23", (String)"bos-botp-formplugin", (Object[])new Object[0]), subtitle)));
        this.getView().addClientCallBack(callBackName, Integer.valueOf(100));
    }

    public void clientCallBack(ClientCallBackEvent e) {
        if ("checkSaveProgresslater".equals(e.getName())) {
            this.processCallBack("checkSaveProgresslater", "saveallresult", ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"ConvertResultFormEdit_2", (String)"bos-botp-formplugin", (Object[])new Object[0]));
        } else if ("checkSubmitProgresslater".equals(e.getName())) {
            this.processCallBack("checkSubmitProgresslater", "submitallresult", ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"ConvertResultFormEdit_8", (String)"bos-botp-formplugin", (Object[])new Object[0]));
        } else if ("checkAuditProgresslater".equals(e.getName())) {
            this.processCallBack("checkAuditProgresslater", "auditallresult", ResManager.loadKDString((String)"\u5ba1\u6838", (String)"ConvertResultFormEdit_18", (String)"bos-botp-formplugin", (Object[])new Object[0]));
        }
    }

    private synchronized void processCallBack(String callBackName, String resultKey, String operationName) {
        Map cache = this.getPageCache().getAll();
        int progress = (int)Double.parseDouble(cache.getOrDefault(resultKey + "progress", "0.0"));
        if (progress < 100) {
            this.getView().showLoading(new LocaleString(String.format(ResManager.loadKDString((String)"\u5df2\u6267\u884c\u5230%d%%\uff0c\u8bf7\u7a0d\u540e", (String)"ConvertResultFormEdit_24", (String)"bos-botp-formplugin", (Object[])new Object[0]), progress)));
            this.getView().addClientCallBack(callBackName, Integer.valueOf(100));
        } else {
            String saveAllResult = this.getPageCache().get(resultKey);
            if (StringUtils.isNotBlank((CharSequence)saveAllResult)) {
                this.showOperationResult(operationName, (OperationResult)SerializationUtils.fromJsonString((String)saveAllResult, OperationResult.class));
            }
            ConvertResultFormUtil.refreshSaveTips((IFormView)this.getView());
            this.getView().updateView("billlist");
            this.getView().hideLoading();
            this.getPageCache().remove(resultKey);
        }
    }

    private void submit() {
        int currRowIndex = Integer.parseInt(this.getPageCache().get("currbillindex"));
        int status = Integer.parseInt((String)this.getModel().getValue("savestatus", currRowIndex));
        if (status == SaveStatus.Submit.getValue() || status == SaveStatus.AUDIT.getValue()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u7ecf\u63d0\u4ea4\u3002", (String)"ConvertResultFormEdit_7", (String)"bos-botp-formplugin", (Object[])new Object[0]));
            return;
        }
        String childPageId = this.getPageCache().get("childpageid");
        IFormView childView = this.getView().getView(childPageId);
        if (childView != null) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("isshowmessage", "false");
            operateOption.setVariableValue("isStrict", "false");
            operateOption.setVariableValue("botptag_of_datasource", String.valueOf(true));
            OperationResult submitResult = this.getOperationResult(childView, operateOption, "submit");
            this.getView().sendFormAction(childView);
            if (submitResult == null) {
                return;
            }
        }
    }

    private void submitAll() {
        this.doSubmitAll(false, null);
    }

    private void doSubmitAll(boolean signCallback, SignCallbackEvent evt) {
        ConvertOperationResult convertResult = this.updateChildViewDataChange();
        if (convertResult == null) {
            return;
        }
        HashMap<SaveStatus, List<DynamicObject>> billObjs = new HashMap<SaveStatus, List<DynamicObject>>(16);
        HashMap<SaveStatus, List<Long>> billIds = new HashMap<SaveStatus, List<Long>>(16);
        this.getOpBillObjs(convertResult, billObjs, billIds);
        int count = this.getModel().getEntryEntity("billlist").size();
        ArrayList<DynamicObject> submitObjs = new ArrayList<DynamicObject>(count);
        for (Map.Entry entry : billObjs.entrySet()) {
            if (entry.getKey() == SaveStatus.Submit || entry.getKey() == SaveStatus.AUDIT) continue;
            submitObjs.addAll((Collection)entry.getValue());
        }
        ArrayList<Long> submitIds = new ArrayList<Long>(count);
        for (Map.Entry entry : billIds.entrySet()) {
            if (entry.getKey() == SaveStatus.Submit || entry.getKey() == SaveStatus.AUDIT) continue;
            submitIds.addAll((Collection)entry.getValue());
        }
        if (submitObjs.isEmpty() && submitIds.isEmpty()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u7ecf\u5168\u90e8\u63d0\u4ea4\u6210\u529f\u3002", (String)"ConvertResultFormEdit_9", (String)"bos-botp-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean needSign = SignServiceHelper.needSign((String)"", (String)this.getTargetEntityNumber(), (String)"submit");
        this.submitAllByAnsy(signCallback, evt, convertResult, submitObjs, submitIds, needSign);
    }

    private void submitAllByAnsy(boolean signCallback, SignCallbackEvent evt, ConvertOperationResult convertResult, List<DynamicObject> submitObjs, List<Long> submitIds, boolean needSign) {
        OperateOption operateOption = this.createOperateOption(signCallback, evt);
        if (needSign || this.isMainThreadSaveAll() || submitObjs.size() + submitIds.size() <= BotpMCParam.getIntValue((String)"botp_min_batch_save_all_size")) {
            OperationResult submitResult = null;
            String submitOpKey = this.getSubmitOpKey();
            if (!submitObjs.isEmpty()) {
                OperationResult submitResult1 = this.batchCallOpService(submitOpKey, SaveStatus.Submit, convertResult, submitObjs.toArray(new DynamicObject[0]), null, operateOption, false);
                if (submitResult1 == null) {
                    return;
                }
                submitResult = submitResult1;
            }
            if (!submitIds.isEmpty()) {
                OperationResult submitResult2 = this.batchCallOpService(submitOpKey, SaveStatus.Submit, convertResult, null, submitIds.toArray(), operateOption, false);
                if (submitResult2 == null) {
                    return;
                }
                if (submitResult == null) {
                    submitResult = submitResult2;
                } else {
                    submitResult.mergeOperateResult(submitResult2);
                }
            }
            if (this.getSubmitAndAudit().booleanValue()) {
                if (submitResult == null) {
                    throw new KDException("submitResult is null");
                }
                String auditOpKey = this.getAuditOpKey();
                OperationResult auditResult = this.batchCallOpService(auditOpKey, SaveStatus.AUDIT, convertResult, null, submitResult.getSuccessPkIds().toArray(), operateOption, false);
                if (auditResult != null) {
                    if (auditResult.getValidateResult().errorSize() <= 5) {
                        for (ValidateResult validateResult : auditResult.getValidateResult().getValidateErrors()) {
                            for (OperateErrorInfo errorInfo : validateResult.getAllErrorInfo()) {
                                errorInfo.setMessage(String.format(ResManager.loadKDString((String)"[\u5ba1\u6838\u5931\u8d25]%s", (String)"ConvertResultFormEdit_26", (String)"bos-botp-formplugin", (Object[])new Object[0]), errorInfo.getMessage()));
                            }
                        }
                    }
                    submitResult.getValidateResult().getValidateErrors().addAll(auditResult.getValidateResult().getValidateErrors());
                    for (OperateErrorInfo errorInfo : auditResult.getAllErrorInfo()) {
                        submitResult.addErrorInfo(errorInfo);
                    }
                }
            }
            if (submitResult != null) {
                this.getView().updateView("billlist");
                ConvertResultFormUtil.refreshSaveTips((IFormView)this.getView());
                this.showOperationResult(ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"ConvertResultFormEdit_8", (String)"bos-botp-formplugin", (Object[])new Object[0]), submitResult);
            }
        } else {
            this.showProgressLoading(ResManager.loadKDString((String)"\u63d0\u4ea4\u5168\u90e8\u5355\u636e", (String)"ConvertResultFormEdit_33", (String)"bos-botp-formplugin", (Object[])new Object[0]), "checkSubmitProgresslater");
            this.splitBatchCallSubmitOpService(convertResult, submitObjs, submitIds, operateOption);
        }
    }

    private void splitBatchCallSubmitOpService(ConvertOperationResult convertResult, List<DynamicObject> submitObjs, List<Long> submitIds, OperateOption operateOption) {
        IFormView view = this.getView();
        int totalOpObjCount = submitObjs.size() + submitIds.size();
        view.getPageCache().put("currentCount", "0");
        threadPool.submit((Callable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void audit() {
        int currRowIndex = Integer.parseInt(this.getPageCache().get("currbillindex"));
        int status = Integer.parseInt((String)this.getModel().getValue("savestatus", currRowIndex));
        if (status == SaveStatus.AUDIT.getValue()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u7ecf\u5ba1\u6838\u3002", (String)"ConvertResultFormEdit_15", (String)"bos-botp-formplugin", (Object[])new Object[0]));
            return;
        }
        if (status != SaveStatus.Submit.getValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u63d0\u4ea4\u5355\u636e\uff0c\u7136\u540e\u518d\u5ba1\u6838\u3002", (String)"ConvertResultFormEdit_16", (String)"bos-botp-formplugin", (Object[])new Object[0]));
            return;
        }
        String childPageId = this.getPageCache().get("childpageid");
        IFormView childView = this.getView().getView(childPageId);
        if (childView != null) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("isshowmessage", "false");
            operateOption.setVariableValue("isStrict", "false");
            String auditOpKey = this.getAuditOpKey();
            OperationResult auditResult = this.getOperationResult(childView, operateOption, auditOpKey);
            this.getView().sendFormAction(childView);
            if (auditResult == null) {
                return;
            }
        }
    }

    private void auditAll() {
        this.doAuditAll(false, null);
    }

    private void doAuditAll(boolean signCallback, SignCallbackEvent evt) {
        List<Long> submitedIds;
        ConvertOperationResult convertResult = this.updateChildViewDataChange();
        if (convertResult == null) {
            return;
        }
        HashMap<SaveStatus, List<DynamicObject>> billObjs = new HashMap<SaveStatus, List<DynamicObject>>(16);
        HashMap<SaveStatus, List<Long>> billIds = new HashMap<SaveStatus, List<Long>>(16);
        this.getOpBillObjs(convertResult, billObjs, billIds);
        int count = this.getModel().getEntryEntity("billlist").size();
        int audited = billObjs.containsKey(SaveStatus.AUDIT) ? ((List)billObjs.get(SaveStatus.AUDIT)).size() : 0;
        if ((audited += billIds.containsKey(SaveStatus.AUDIT) ? ((List)billIds.get(SaveStatus.AUDIT)).size() : 0) >= count) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u7ecf\u5168\u90e8\u5ba1\u6838\u6210\u529f\u3002", (String)"ConvertResultFormEdit_19", (String)"bos-botp-formplugin", (Object[])new Object[0]));
            return;
        }
        List<DynamicObject> submitedObjs = billObjs.get(SaveStatus.Submit) == null ? new ArrayList() : (List)billObjs.get(SaveStatus.Submit);
        List list = submitedIds = billIds.get(SaveStatus.Submit) == null ? new ArrayList() : (List)billIds.get(SaveStatus.Submit);
        if ((submitedObjs == null || submitedObjs.isEmpty()) && (submitedIds == null || submitedIds.isEmpty())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u63d0\u4ea4\u5355\u636e\uff0c\u7136\u540e\u518d\u5ba1\u6838\u3002", (String)"ConvertResultFormEdit_16", (String)"bos-botp-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean needSign = SignServiceHelper.needSign((String)"", (String)this.getTargetEntityNumber(), (String)"audit");
        this.auditAllByAnsy(signCallback, evt, convertResult, submitedObjs, submitedIds, needSign);
    }

    private void auditAllByAnsy(boolean signCallback, SignCallbackEvent evt, ConvertOperationResult convertResult, List<DynamicObject> submitedObjs, List<Long> submitedIds, boolean needSign) {
        OperateOption operateOption = this.createOperateOption(signCallback, evt);
        if (needSign || this.isMainThreadSaveAll() || submitedObjs.size() + submitedIds.size() <= BotpMCParam.getIntValue((String)"botp_min_batch_save_all_size")) {
            String auditOpKey = this.getAuditOpKey();
            OperationResult auditResult = null;
            if (submitedObjs != null && !submitedObjs.isEmpty()) {
                OperationResult auditResult1 = this.batchCallOpService(auditOpKey, SaveStatus.AUDIT, convertResult, submitedObjs.toArray(new DynamicObject[0]), null, operateOption, false);
                if (auditResult1 == null) {
                    return;
                }
                auditResult = auditResult1;
            }
            if (submitedIds != null && !submitedIds.isEmpty()) {
                OperationResult auditResult2 = this.batchCallOpService(auditOpKey, SaveStatus.AUDIT, convertResult, null, submitedIds.toArray(), operateOption, false);
                if (auditResult2 == null) {
                    return;
                }
                if (auditResult == null) {
                    auditResult = auditResult2;
                } else {
                    auditResult.mergeOperateResult(auditResult2);
                }
            }
            if (auditResult != null) {
                this.getView().updateView("billlist");
                ConvertResultFormUtil.refreshSaveTips((IFormView)this.getView());
                this.showOperationResult(ResManager.loadKDString((String)"\u5ba1\u6838", (String)"ConvertResultFormEdit_18", (String)"bos-botp-formplugin", (Object[])new Object[0]), auditResult);
            }
        } else {
            this.showProgressLoading(ResManager.loadKDString((String)"\u5ba1\u6838\u5168\u90e8\u5355\u636e", (String)"ConvertResultFormEdit_34", (String)"bos-botp-formplugin", (Object[])new Object[0]), "checkAuditProgresslater");
            this.splitBatchCallAuditOpService(convertResult, submitedObjs, submitedIds, operateOption);
        }
    }

    private void splitBatchCallAuditOpService(ConvertOperationResult convertResult, List<DynamicObject> submitObjs, List<Long> submitIds, OperateOption operateOption) {
        IFormView view = this.getView();
        int totalAuditObjCount = submitObjs.size() + submitIds.size();
        view.getPageCache().put("currentCount", "0");
        threadPool.submit((Callable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void getOpBillObjs(ConvertOperationResult convertResult, Map<SaveStatus, List<DynamicObject>> billObjs, Map<SaveStatus, List<Long>> billIds) {
        MainEntityType mainType = this.getTargetMainType();
        ISimpleProperty pkProp = mainType.getPrimaryKey();
        IRefrencedataProvider refLoader = this.buildRefLoader();
        this.getModel().getDataEntity(true);
        DynamicObjectCollection rows = this.getModel().getEntryEntity("billlist");
        int billIndex = 0;
        for (DynamicObject row : rows) {
            Object pkValue;
            int statusValue = Integer.parseInt(row.getString("savestatus"));
            SaveStatus status = SaveStatus.valueOf((int)statusValue);
            String cachePageId = row.getString("pageid");
            if (StringUtils.isNotBlank((CharSequence)cachePageId)) {
                DynamicObject billObj;
                if (!billObjs.containsKey(status)) {
                    billObjs.put(status, new ArrayList(rows.size()));
                }
                if ((billObj = convertResult.loadTargetDataObject(refLoader, mainType, cachePageId, false)) == null) continue;
                billObjs.get(status).add(billObj);
                pkValue = billObj.getPkValue();
                if (((IValidatorHanlder)pkProp).getValueComparator().compareValue(pkValue)) {
                    pkValue = DBServiceHelper.genGlobalLongId();
                    pkProp.setValue((Object)billObj, pkValue);
                }
                row.set("pkvalue", pkValue);
            } else {
                pkValue = row.getLong("pkvalue");
                if (billIds != null) {
                    if (!billIds.containsKey(status)) {
                        billIds.put(status, new ArrayList(rows.size()));
                    }
                    billIds.get(status).add((Long)pkValue);
                }
            }
            ++billIndex;
        }
        if (billObjs.size() > 0) {
            for (List<DynamicObject> list : billObjs.values()) {
                refLoader.fillReferenceData(list.toArray(), (IDataEntityType)mainType);
            }
        }
    }

    private OperationResult batchCallOpService(String opKey, SaveStatus status, ConvertOperationResult convertResult, DynamicObject[] billObjs, Object[] billIds, OperateOption operateOption, boolean byAsyn) {
        String targetEntityNumber = this.getTargetEntityNumber();
        OperationResult opResult = null;
        if (billObjs != null) {
            opResult = OperationServiceHelper.executeOperate((String)opKey, (String)targetEntityNumber, (DynamicObject[])billObjs, (OperateOption)operateOption);
        } else if (billIds != null) {
            opResult = OperationServiceHelper.executeOperate((String)opKey, (String)targetEntityNumber, (Object[])billIds, (OperateOption)operateOption);
        }
        if (opResult != null && !opResult.isSuccess() && opResult.isNeedSign()) {
            ISignOperateCallback signOperateCallback = (ISignOperateCallback)TypesContainer.createInstance((String)"kd.bos.form.operate.SignOperateCallback");
            opResult = signOperateCallback.beforeSign(this.getView(), (SignCallbackLisenter)this, operateOption, ClientCallback.SignClientType.Secondry, status.toString()).sign(opResult);
            if (!opResult.isSuccess() && opResult.isShowMessage()) {
                this.getView().showOperationResult(opResult, opKey);
            }
            return null;
        }
        if (!byAsyn && opResult != null && opResult.getSuccessPkIds() != null && !opResult.getSuccessPkIds().isEmpty()) {
            this.doAfterOperation(opResult, status, convertResult);
        }
        return opResult;
    }

    private String getSubmitOpKey() {
        Map subOp;
        BillEntityType mainType = (BillEntityType)this.getTargetMainType();
        String targetEntityNumber = mainType.getName();
        String submitOpKey = "submit";
        Operations ops = EntityMetadataCache.getDataEntityOperations((String)targetEntityNumber);
        if (StringUtils.isNotBlank((CharSequence)ops.getSubmit())) {
            submitOpKey = ops.getSubmit();
        }
        if ((subOp = EntityMetadataCache.getDataEntityOperate((String)targetEntityNumber, (String)submitOpKey)) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u6ca1\u6709\u914d\u7f6e\u63d0\u4ea4\u64cd\u4f5c\u3002", (String)"ConvertResultFormEdit_28", (String)"bos-botp-formplugin", (Object[])new Object[0]));
        }
        return submitOpKey;
    }

    private String getAuditOpKey() {
        Map auditOp;
        BillEntityType mainType = (BillEntityType)this.getTargetMainType();
        String targetEntityNumber = mainType.getName();
        String auditOpKey = "audit";
        Operations ops = EntityMetadataCache.getDataEntityOperations((String)targetEntityNumber);
        if (StringUtils.isNotBlank((CharSequence)ops.getAudit())) {
            auditOpKey = ops.getAudit();
        }
        if ((auditOp = EntityMetadataCache.getDataEntityOperate((String)targetEntityNumber, (String)auditOpKey)) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u6ca1\u6709\u914d\u7f6e\u5ba1\u6838\u64cd\u4f5c\uff0c\u4e0d\u80fd\u5ba1\u6838\u3002", (String)"ConvertResultFormEdit_17", (String)"bos-botp-formplugin", (Object[])new Object[0]));
        }
        return auditOpKey;
    }

    private void doAfterOperation(OperationResult opResult, SaveStatus newStatus, ConvertOperationResult convertResult) {
        DynamicObject[] fromDBObjs;
        if (newStatus.getValue() == 1 || newStatus.getValue() == 2) {
            this.saveAttachmentPanels(opResult, convertResult);
        }
        BillEntityType mainType = (BillEntityType)this.getTargetMainType();
        IDataEntityProperty billNoProp = null;
        if (StringUtils.isNotBlank((CharSequence)mainType.getBillNo())) {
            billNoProp = (IDataEntityProperty)mainType.getProperties().get((Object)mainType.getBillNo());
        }
        HashMap<Long, DynamicObject> successObjs = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject obj : fromDBObjs = BusinessDataServiceHelper.load((Object[])opResult.getSuccessPkIds().toArray(), (DynamicObjectType)mainType)) {
            successObjs.put((Long)obj.getPkValue(), obj);
        }
        int saveCount = 0;
        int submitCount = 0;
        int auditCount = 0;
        int currRowIndex = Integer.parseInt(this.getPageCache().get("currbillindex"));
        DynamicObjectCollection rows = this.getModel().getEntryEntity("billlist");
        for (int rowIndex = 0; rowIndex < rows.size(); ++rowIndex) {
            DynamicObject row = (DynamicObject)rows.get(rowIndex);
            Long billId = row.getLong("pkvalue");
            int status = Integer.parseInt(row.getString("savestatus"));
            DynamicObject successObjFromSimpleType = null;
            if (!successObjs.containsKey(billId)) {
                if (status == SaveStatus.SAVED.getValue()) {
                    ++saveCount;
                    continue;
                }
                if (status == SaveStatus.Submit.getValue()) {
                    ++submitCount;
                    continue;
                }
                if (status != SaveStatus.AUDIT.getValue()) continue;
                ++auditCount;
                continue;
            }
            successObjFromSimpleType = (DynamicObject)successObjs.get(billId);
            String cachePageId = row.getString("pageid");
            if (StringUtils.isNotBlank((CharSequence)cachePageId)) {
                convertResult.updateTargetDataObject(cachePageId, successObjFromSimpleType, false);
            }
            SaveStatus currStatus = this.getLastStatus(newStatus, row.getString("savestatus"));
            BillStatusProp billStatusProp = (BillStatusProp)mainType.getAllFields().get(mainType.getBillStatus());
            String billStatus = (String)billStatusProp.getValue((Object)successObjFromSimpleType);
            billStatus = billStatusProp.getStatusItem(billStatus).getStatusName().getLocaleValue();
            row.set("billstatus", (Object)billStatus);
            row.set("savestatus", (Object)String.valueOf(currStatus.getValue()));
            row.set("pkvalue", (Object)billId);
            row.set("billno", (Object)(billNoProp == null ? "" : (String)billNoProp.getValue((Object)successObjFromSimpleType)));
            if (currStatus.getValue() == 1) {
                ++saveCount;
            } else if (currStatus.getValue() == 2) {
                ++submitCount;
            } else if (currStatus.getValue() == 3) {
                ++auditCount;
            }
            if (rowIndex != currRowIndex) continue;
            this.refreshChildView(BusinessDataServiceHelper.loadSingle((Object)successObjFromSimpleType.getPkValue(), (DynamicObjectType)mainType));
        }
        this.getPageCache().put("savecount", String.valueOf(saveCount));
        this.getPageCache().put("submitcount", String.valueOf(submitCount));
        this.getPageCache().put("auditcount", String.valueOf(auditCount));
        this.updateConvertResult(convertResult);
        this.requestMutex(opResult.getSuccessPkIds().toArray());
        IDataModel model = this.getModel();
        model.updateEntryCache(rows);
        this.getView().updateView("billlist");
        model.updateCache();
    }

    private void clearChildViewTempAttCacheAfterSaveAll() {
        String childPageId = this.getPageCache().get("childpageid");
        IBillView billView = (IBillView)this.getView().getView(childPageId);
        this.getAttachment().clearChildViewTempAttCache(billView);
    }

    private void saveAttachmentPanels(OperationResult opResult, ConvertOperationResult convertResult) {
        HashSet successPks = new HashSet(opResult.getSuccessPkIds());
        DynamicObjectCollection rows = this.getModel().getEntryEntity("billlist");
        HashSet<Long> successRowIds = new HashSet<Long>();
        for (int rowIndex = 0; rowIndex < rows.size(); ++rowIndex) {
            DynamicObject row = (DynamicObject)rows.get(rowIndex);
            Long billId = row.getLong("pkvalue");
            int status = Integer.parseInt(row.getString("savestatus"));
            if (!successPks.contains(billId) && status == SaveStatus.UN_SAVE.getValue()) continue;
            successRowIds.add(billId);
        }
        MainEntityType mainType = this.getTargetMainType();
        this.getAttachment().saveAttachmentPanals(mainType.getAppId(), mainType.getName(), successRowIds);
    }

    private SaveStatus getLastStatus(SaveStatus newStatus, String oldStatusVal) {
        SaveStatus oldStatus = SaveStatus.UN_SAVE;
        if (StringUtils.isNotBlank((CharSequence)oldStatusVal)) {
            oldStatus = SaveStatus.valueOf((int)Integer.parseInt(oldStatusVal));
        }
        if (oldStatus.getValue() > newStatus.getValue()) {
            return oldStatus;
        }
        return newStatus;
    }

    private void showOperationResult(String opName, OperationResult opResult) {
        if (opResult == null) {
            return;
        }
        if (opResult.isSuccess() && opResult.getAllErrorOrValidateInfo().isEmpty() && StringUtils.isBlank((CharSequence)opResult.getMessage())) {
            String submitOpName = ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"ConvertResultFormEdit_8", (String)"bos-botp-formplugin", (Object[])new Object[0]);
            if (this.getSubmitAndAudit().booleanValue() && submitOpName.equals(opName)) {
                opName = ResManager.loadKDString((String)"\u5ba1\u6838", (String)"ConvertResultFormEdit_18", (String)"bos-botp-formplugin", (Object[])new Object[0]);
            }
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"%s\u6210\u529f\u3002", (String)"ConvertResultFormEdit_10", (String)"bos-botp-formplugin", (Object[])new Object[0]), opName));
        } else if (opResult.isShowMessage()) {
            if (this.getView() instanceof AbstractFormView && opResult.getValidateResult().getValidateErrors().size() > 0) {
                AbstractFormView view = (AbstractFormView)this.getView();
                view.showOperationResultPage(opResult, opName);
            } else {
                this.getView().showOperationResult(opResult, opName);
            }
        }
    }

    private void move(String barItemKey) {
        int rowCount = Integer.parseInt(this.getPageCache().get("billcount"));
        if (rowCount == 0) {
            return;
        }
        int currRowIndex = 0;
        if (barItemKey.equals("tbfirst")) {
            currRowIndex = 0;
        } else if (barItemKey.equals("tbprevious")) {
            currRowIndex = Integer.parseInt(this.getPageCache().get("currbillindex"));
            if (currRowIndex > 0) {
                --currRowIndex;
            }
        } else if (barItemKey.equals("tbnext")) {
            currRowIndex = Integer.parseInt(this.getPageCache().get("currbillindex"));
            if (currRowIndex < rowCount - 1) {
                ++currRowIndex;
            }
        } else if (barItemKey.equals("tblast")) {
            currRowIndex = rowCount - 1;
        }
        this.showBill(currRowIndex);
    }

    private void refreshNavBarItem() {
        int rowCount = Integer.parseInt(this.getPageCache().get("billcount"));
        int currBillIndex = Integer.parseInt(this.getPageCache().get("currbillindex"));
        if (currBillIndex == 0) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"tbfirst", "tbprevious"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"tbfirst", "tbprevious"});
        }
        if (currBillIndex >= rowCount - 1) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"tblast", "tbnext"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"tblast", "tbnext"});
        }
        String tipBillCount = String.format("%d/%d", currBillIndex + 1, rowCount);
        Label lblBillCount = (Label)this.getView().getControl("lblbillcount");
        lblBillCount.setText(tipBillCount);
    }

    protected void requestMutex(Object[] pkValues) {
        if (MutexHelper.isOpenIntentLocks()) {
            return;
        }
        String netGroupId = this.loadMutexGroupId();
        if (StringUtils.isBlank((CharSequence)netGroupId)) {
            return;
        }
        String entityId = this.getTargetEntityNumber();
        boolean isStrict = false;
        ArrayList mutexRequireList = new ArrayList(10);
        for (Object pkValue : pkValues) {
            String objId = String.valueOf(pkValue);
            HashMap<String, Object> requireParam = new HashMap<String, Object>(16);
            requireParam.put("dataObjId", objId);
            requireParam.put("groupId", netGroupId);
            requireParam.put("entityKey", entityId);
            requireParam.put("operationKey", "modify");
            requireParam.put("isStrict", isStrict);
            mutexRequireList.add(requireParam);
        }
        HashSet<String> failObjIds = new HashSet<String>();
        HashSet<String> successObjIds = new HashSet<String>();
        try {
            Object pkValue;
            DataMutex dataMutex = DataMutex.create();
            pkValue = null;
            try {
                Map mutexResult = dataMutex.batchrequire(mutexRequireList);
                for (Map.Entry mutexItem : mutexResult.entrySet()) {
                    String objId = (String)mutexItem.getKey();
                    Boolean isMutexLocked = (Boolean)mutexItem.getValue();
                    if (!isMutexLocked.booleanValue()) {
                        failObjIds.add(objId);
                        continue;
                    }
                    AutoReleaseLock.create().register(objId, entityId, "modify");
                    successObjIds.add(objId);
                }
            }
            catch (Throwable throwable) {
                pkValue = throwable;
                throw throwable;
            }
            finally {
                if (dataMutex != null) {
                    if (pkValue != null) {
                        try {
                            dataMutex.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)pkValue).addSuppressed(throwable);
                        }
                    } else {
                        dataMutex.close();
                    }
                }
            }
        }
        catch (IOException e) {
            ErrorCode ec = new ErrorCode("MUTEX_REQUIRE_ERROR", String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u4e92\u65a5\u9501\u51fa\u9519;err:%s", (String)"ConvertResultFormEdit_30", (String)"bos-botp-formplugin", (Object[])new Object[0]), e.getMessage()));
            throw new KDException((Throwable)e, ec, new Object[0]);
        }
        this.cacheMutexPKValue(successObjIds.toArray(new String[0]));
        if (!failObjIds.isEmpty()) {
            ErrorCode ec = new ErrorCode("MUTEX_REQUIRE_ERROR", ResManager.loadKDString((String)"\u5e76\u53d1\u51b2\u7a81\uff0c\u7533\u8bf7\u4e92\u65a5\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ConvertResultFormEdit_50", (String)"bos-botp-formplugin", (Object[])new Object[0]));
            throw new KDException(ec, new Object[0]);
        }
    }

    private void cacheMutexPKValue(String[] pkValues) {
        String mutexString = this.getPageCache().get("mutxt");
        List cachePKValues = null;
        cachePKValues = StringUtils.isBlank((CharSequence)mutexString) ? new ArrayList() : (List)SerializationUtils.fromJsonString((String)mutexString, List.class);
        HashSet<String> set = new HashSet<String>(cachePKValues);
        for (String pkValue : pkValues) {
            if (!set.add(pkValue)) continue;
            cachePKValues.add(pkValue);
        }
        this.getPageCache().put("mutxt", SerializationUtils.toJsonString(cachePKValues));
    }

    private void releaseMutex() {
        String entityNumber = this.getTargetEntityNumber();
        String netGroupId = this.loadMutexGroupId();
        String mutexString = this.getPageCache().get("mutxt");
        List cachePKValues = null;
        cachePKValues = StringUtils.isBlank((CharSequence)mutexString) ? new ArrayList() : (List)SerializationUtils.fromJsonString((String)mutexString, List.class);
        if (cachePKValues.isEmpty()) {
            return;
        }
        ArrayList mutexRequireList = new ArrayList(10);
        for (Object pkValue : cachePKValues) {
            HashMap<String, Object> requireParam = new HashMap<String, Object>(16);
            requireParam.put("dataObjId", pkValue);
            requireParam.put("groupId", netGroupId);
            requireParam.put("entityKey", entityNumber);
            requireParam.put("operationKey", "modify");
            mutexRequireList.add(requireParam);
        }
        try {
            Object pkValue;
            DataMutex dataMutex = DataMutex.create();
            pkValue = null;
            try {
                Map releaseResult = dataMutex.batchRelease(mutexRequireList);
                for (Map.Entry releaseItem : releaseResult.entrySet()) {
                    boolean releaseRet = (Boolean)releaseItem.getValue();
                    String pkValue2 = (String)releaseItem.getKey();
                    if (releaseRet) {
                        AutoReleaseLock.create().unRegister(pkValue2, entityNumber, "modify");
                        continue;
                    }
                    log.error((Object)("\u91ca\u653e\u6570\u636e\u5bf9\u8c61[" + pkValue2 + "]\u4e92\u65a5\u9501\u5931\u8d25."));
                }
            }
            catch (Throwable throwable) {
                pkValue = throwable;
                throw throwable;
            }
            finally {
                if (dataMutex != null) {
                    if (pkValue != null) {
                        try {
                            dataMutex.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)pkValue).addSuppressed(throwable);
                        }
                    } else {
                        dataMutex.close();
                    }
                }
            }
        }
        catch (IOException e) {
            ErrorCode ec = new ErrorCode("MUTEX_REQUIRE_ERROR", String.format(ResManager.loadKDString((String)"\u91ca\u653e\u6570\u636e\u5bf9\u8c61\u4e92\u65a5\u9501\u51fa\u9519\u3002%s", (String)"ConvertResultFormEdit_31", (String)"bos-botp-formplugin", (Object[])new Object[0]), e.getMessage()));
            throw new KDException((Throwable)e, ec, new Object[0]);
        }
    }

    private String loadMutexGroupId() {
        if (this.mutex_NetCtrlGroupId != null) {
            return this.mutex_NetCtrlGroupId;
        }
        String entityNumber = this.getTargetEntityNumber();
        Map netCtrlConf = EntityMetadataCache.getDataEntityNetCtrlOperate((String)entityNumber);
        if (netCtrlConf == null) {
            this.mutex_NetCtrlGroupId = "";
        } else {
            block0: for (Map.Entry groupId : netCtrlConf.entrySet()) {
                for (Map oper : (List)groupId.getValue()) {
                    String operKey = (String)oper.get("operationKey");
                    if (!StringUtils.equals((CharSequence)"modify", (CharSequence)operKey)) continue;
                    this.mutex_NetCtrlGroupId = (String)groupId.getKey();
                    continue block0;
                }
            }
            if (this.mutex_NetCtrlGroupId == null) {
                this.mutex_NetCtrlGroupId = "";
            }
        }
        return this.mutex_NetCtrlGroupId;
    }

    private void releasePushaMutex() {
        ConvertOperationResult convertResult = this.getConvertResult();
        if (convertResult == null) {
            return;
        }
        if (convertResult.getDataMutexSrcBillIds().isEmpty()) {
            return;
        }
        HashSet srcBillIds = new HashSet(convertResult.getDataMutexSrcBillIds());
        ConvertServiceHelper.releasePushMutex((String)convertResult.getSourceEntityNumber(), srcBillIds);
        convertResult.getDataMutexSrcBillIds().clear();
    }

    private String getTargetEntityNumber() {
        String targetEntityNumber = (String)this.getView().getFormShowParameter().getCustomParam("targetentitynumber");
        return targetEntityNumber;
    }

    private String getSourceEntityNumber() {
        String sourceEntityNumber = (String)this.getView().getFormShowParameter().getCustomParam("sourceentitynumber");
        return sourceEntityNumber;
    }

    private MainEntityType getTargetMainType() {
        String entityNUmber = this.getTargetEntityNumber();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNUmber);
        return mainType;
    }

    private ConvertOperationResult getConvertResult() {
        String convertResultJson = this.getPageCache().get("ConvertOperationResult");
        if (StringUtils.isBlank((CharSequence)convertResultJson)) {
            log.warn((Object)ResManager.loadKDString((String)"botp \u4e0b\u63a8\u7ed3\u679c\u5df2\u6e05\u9664", (String)"ConvertResultFormEdit_29", (String)"bos-botp-formplugin", (Object[])new Object[0]));
            throw new KDBizException(ResManager.loadKDString((String)"botp \u4e0b\u63a8\u7ed3\u679c\u5df2\u6e05\u9664", (String)"ConvertResultFormEdit_29", (String)"bos-botp-formplugin", (Object[])new Object[0]));
        }
        ConvertOperationResult convertResult = (ConvertOperationResult)SerializationUtils.fromJsonString((String)convertResultJson, ConvertOperationResult.class);
        return convertResult;
    }

    private void updateConvertResult(ConvertOperationResult convertResult) {
        this.getPageCache().put("ConvertOperationResult", SerializationUtils.toJsonString((Object)convertResult));
    }

    private void updateConvertResult(String convertResultJson) {
        this.getPageCache().put("ConvertOperationResult", convertResultJson);
    }

    private ConvertResultAttachment getAttachment() {
        if (this.attachment == null) {
            this.attachment = new ConvertResultAttachment(this.getView());
        }
        return this.attachment;
    }

    private IRefrencedataProvider buildRefLoader() {
        5 refLoader = new /* Unavailable Anonymous Inner Class!! */;
        return refLoader;
    }

    public void signCallback(SignCallbackEvent evt) {
        if (evt == null) {
            log.warn((Object)"botp \u4e0b\u63a8\u7b7e\u540d\u56de\u8c03\u7ed3\u679c\u4e3a\u7a7a\u3002\u3002\u3002");
            return;
        }
        log.warn((Object)"botp \u4e0b\u63a8\u7ed3\u679c\u6279\u91cf\u63d0\u4ea4\u7b7e\u540d\u6210\u529f\u56de\u8c03\u3002\u3002\u3002");
        ClientMethodResult ret = evt.getResult();
        if (ret.getSuccess().booleanValue()) {
            if (StringUtils.equalsIgnoreCase((CharSequence)evt.getCallbackId(), (CharSequence)SaveStatus.AUDIT.toString())) {
                this.doAuditAll(true, evt);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)evt.getCallbackId(), (CharSequence)SaveStatus.SAVED.toString())) {
                this.saveAll(true, evt);
            } else {
                this.doSubmitAll(true, evt);
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5ba2\u6237\u7aef\u7b7e\u540d\u5931\u8d25\u3002", (String)"ConvertResultFormEdit_14", (String)"bos-botp-formplugin", (Object[])new Object[0]));
        }
    }

    private Boolean getSubmitAndAudit() {
        Boolean autoAudit = Boolean.FALSE;
        try {
            Object optionValue = SystemParamServiceHelper.getBillParameter((String)this.getTargetEntityNumber(), (String)"submitandaudit");
            if (optionValue != null) {
                autoAudit = (Boolean)optionValue;
            }
        }
        catch (Throwable exp) {
            log.error((Object)exp);
        }
        return autoAudit;
    }

    private boolean isAsyncBatchEnabled() {
        Boolean isAsyncBatchEnabled;
        String cacheValue = this.getView().getPageCache().get("asyncdobatchsave");
        if (StringUtils.isNotBlank((CharSequence)cacheValue)) {
            isAsyncBatchEnabled = Boolean.parseBoolean(cacheValue);
        } else {
            DynamicObject billParams = ParameterReader.getBillParameter((String)this.getTargetEntityNumber());
            isAsyncBatchEnabled = billParams != null && billParams.getDataEntityType().getProperties().containsKey((Object)"asyncdobatchsave") && billParams.getBoolean("asyncdobatchsave");
            this.getView().getPageCache().put("asyncdobatchsave", String.valueOf(isAsyncBatchEnabled));
        }
        return isAsyncBatchEnabled;
    }

    private OperationResult buildExceptionResult(String msg, Throwable e) {
        log.error((Object)msg, e);
        OperationResult result = new OperationResult();
        result.setSuccess(false);
        result.setMessage(msg);
        return result;
    }

    private OperateOption createOperateOption(boolean signCallback, SignCallbackEvent evt) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("isStrict", "false");
        operateOption.setVariableValue("ignorewarn", String.valueOf(true));
        operateOption.setVariableValue("ignoreinteraction", String.valueOf(true));
        operateOption.setVariableValue("botptag_of_datasource", String.valueOf(true));
        operateOption.setVariableValue("currbizappid", this.getView().getFormShowParameter().getAppId());
        this.getAttachment().setAttachmentOption(operateOption);
        if (signCallback) {
            ClientMethodResult ret = evt.getResult();
            operateOption.setVariableValue("signCallbackFlag", "true");
            operateOption.setVariableValue("signFirstSave", "false");
            operateOption.setVariableValue("signResult", SerializationUtils.toJsonString((Object)ret.getResult()));
            operateOption.setVariableValue("clearResult", evt.getClearText());
        }
        this.convertFormEditFacade.beforeDoOperation(this.getPageCache(), operateOption);
        log.info((Object)("botp\u7ed3\u679c\u4e0b\u6279\u91cf\u64cd\u4f5c\u53c2\u6570\uff1a" + operateOption));
        return operateOption;
    }

    static /* synthetic */ List access$000(ConvertResultFormEdit x0, List x1) {
        return x0.splitObjs(x1);
    }

    static /* synthetic */ boolean access$100(ConvertResultFormEdit x0) {
        return x0.isAsyncBatchEnabled();
    }

    static /* synthetic */ void access$200(ConvertResultFormEdit x0, IFormView x1, int x2, int x3, String x4) {
        x0.updateAsyncBatchProgress(x1, x2, x3, x4);
    }

    static /* synthetic */ void access$300(ConvertResultFormEdit x0, OperationResult x1, SaveStatus x2, ConvertOperationResult x3) {
        x0.doAfterOperation(x1, x2, x3);
    }

    static /* synthetic */ OperationResult access$400(ConvertResultFormEdit x0, String x1, SaveStatus x2, DynamicObject[] x3, Object[] x4, OperateOption x5) {
        return x0.batchSaveAll(x1, x2, x3, x4, x5);
    }

    static /* synthetic */ OperationResult access$500(ConvertResultFormEdit x0, String x1, Throwable x2) {
        return x0.buildExceptionResult(x1, x2);
    }

    static /* synthetic */ List access$600(ConvertResultFormEdit x0, List x1) {
        return x0.splitIds(x1);
    }

    static /* synthetic */ Boolean access$700(ConvertResultFormEdit x0) {
        return x0.getSubmitAndAudit();
    }

    static /* synthetic */ String access$800(ConvertResultFormEdit x0) {
        return x0.getAuditOpKey();
    }

    static /* synthetic */ OperationResult access$900(ConvertResultFormEdit x0, String x1, SaveStatus x2, ConvertOperationResult x3, DynamicObject[] x4, Object[] x5, OperateOption x6, boolean x7) {
        return x0.batchCallOpService(x1, x2, x3, x4, x5, x6, x7);
    }

    static /* synthetic */ String access$1000(ConvertResultFormEdit x0) {
        return x0.getSubmitOpKey();
    }

    static {
        moveBarItemKeys.add("tbfirst");
        moveBarItemKeys.add("tbprevious");
        moveBarItemKeys.add("tbnext");
        moveBarItemKeys.add("tblast");
    }
}

