/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.botp;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.botp.CRPlugin;
import kd.bos.entity.botp.ConvertRuleCache;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.PlugInPolicy;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.botp.ConvertRuleMetadata;
import kd.bos.metadata.botp.ConvertRuleReader;
import kd.bos.metadata.botp.ConvertRuleTemplate;
import kd.bos.metadata.botp.DesignConvertRuleMeta;
import kd.bos.metadata.botp.common.RuleIsvHelper;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetaLogType;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataWriter;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataLogService;

public class ConvertRuleWriter {
    private static final String BOS_BOTP_MEATADATA = "bos-botp-metadata";
    private static final String SUCCESS_STR = "success";
    private static final String MESSAGE_STR = "message";

    public static Map<String, Object> save(Map<String, Object> metaMap) {
        ConvertRuleTemplate template = new ConvertRuleTemplate();
        ConvertRuleMetadata ruleMetadata = template.deserializeFromMap(metaMap, null);
        return ConvertRuleWriter.save(ruleMetadata);
    }

    public static Map<String, Object> save(ConvertRuleMetadata ruleMetadata) {
        ConvertRuleWriter.setBizappId(ruleMetadata);
        MetadataWriter writer = new MetadataWriter("ConvertRuleModel");
        Map result = writer.save(new AbstractMetadata[]{ruleMetadata});
        ConvertRuleWriter.clearCache();
        return result;
    }

    private static void distinctPlugin(ConvertRuleMetadata ruleMetadata) {
        ConvertRuleElement ruleElement = ruleMetadata.getRuleElement();
        PlugInPolicy plugInPolicy = ruleElement.getPlugInPolicy();
        List plugins = plugInPolicy.getPlugins();
        ArrayList<CRPlugin> newCrPlugins = new ArrayList<CRPlugin>();
        for (CRPlugin plugin : plugins) {
            if (newCrPlugins.contains(plugin)) continue;
            newCrPlugins.add(plugin);
        }
        plugInPolicy.setPlugins(newCrPlugins);
    }

    public static void saveDefaultStatus(ConvertRuleMetadata meta) {
        Throwable throwable;
        TXHandle h;
        if (StringUtils.isNotBlank((CharSequence)meta.getDevType()) && meta.getDevType().equals("2")) {
            return;
        }
        ConvertRuleWriter.clearCache();
        Boolean defRule = meta.getRuleElement().isDefRule();
        if (defRule.booleanValue()) {
            StringBuilder sBuilderClear = new StringBuilder();
            sBuilderClear.append("Update T_BOTP_ConvertRule_S Set FIsDefault = ? ");
            sBuilderClear.append("WHERE FID IN (Select FID FROM T_BOTP_ConvertRule WHERE FSourceEntityNumber = ? and FTargetEntityNumber = ? )");
            Object[] paramsClear = new SqlParameter[]{new SqlParameter(":FIsDefault", 1, (Object)"0"), new SqlParameter(":FSourceEntityNumber", 12, (Object)meta.getRuleElement().getSourceEntityNumber()), new SqlParameter(":FTargetEntityNumber", 12, (Object)meta.getRuleElement().getTargetEntityNumber())};
            h = TX.required();
            throwable = null;
            try {
                DB.execute((DBRoute)DBRoute.meta, (String)sBuilderClear.toString(), (Object[])paramsClear);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (h != null) {
                    if (throwable != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        h.close();
                    }
                }
            }
        }
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("Update T_BOTP_ConvertRule_S Set FIsDefault = ? ");
        sBuilder.append("WHERE FId = ? ");
        Object[] params = new SqlParameter[]{new SqlParameter(":FIsDefault", 1, (Object)(defRule != false ? "1" : "0")), new SqlParameter(":FId", 12, (Object)meta.getId())};
        h = TX.required();
        throwable = null;
        try {
            DB.execute((DBRoute)DBRoute.meta, (String)sBuilder.toString(), (Object[])params);
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            if (h != null) {
                if (throwable != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    h.close();
                }
            }
        }
    }

    private static void writeDeleteMetaDataLog(String[] ruleIds, Map<String, ConvertRuleMetadata> rulesMap) {
        MetadataLogService logService = (MetadataLogService)ServiceFactory.getService(MetadataLogService.class);
        for (String ruleId : ruleIds) {
            long logId = DB.genGlobalLongId();
            String metaNumber = rulesMap.get(ruleId).getRuleElement().getSourceEntityNumber() + "-" + rulesMap.get(ruleId).getRuleElement().getTargetEntityNumber();
            ConvertRuleTemplate template = new ConvertRuleTemplate();
            String xmlData = template.buildDiffXml(rulesMap.get(ruleId), null, false);
            logService.addBotpMetaLog(ruleId, metaNumber, xmlData, (int)MetaLogType.BotpDelete.getValue(), logId, rulesMap.get(ruleId).getBizappId(), ResManager.loadKDString((String)"\u8f6c\u6362\u89c4\u5219_\u5220\u9664", (String)"ConvertRuleWriter_4", (String)BOS_BOTP_MEATADATA, (Object[])new Object[0]));
        }
    }

    public static Map<String, Object> delete(String[] ruleIds) {
        ConvertRuleReader reader = new ConvertRuleReader();
        List rules = reader.batchLoadMeta(ruleIds, false);
        Map<String, ConvertRuleMetadata> rulesMap = rules.stream().collect(Collectors.toMap(ConvertRuleMetadata::getId, item -> item));
        IDataEntityType dType = OrmUtils.getDataEntityType(DesignConvertRuleMeta.class);
        BusinessDataWriter.delete((IDataEntityType)dType, (Object[])ruleIds);
        ConvertRuleWriter.deleteRuleStatus(ruleIds);
        ConvertRuleWriter.clearCache();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(SUCCESS_STR, true);
        result.put(MESSAGE_STR, ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ConvertRuleWriter_0", (String)BOS_BOTP_MEATADATA, (Object[])new Object[0]));
        ConvertRuleWriter.writeDeleteMetaDataLog(ruleIds, rulesMap);
        return result;
    }

    private static void deleteRuleStatus(String[] ruleIds) {
        if (ruleIds.length == 0) {
            return;
        }
        String sql = "DELETE FROM T_BOTP_ConvertRule_S WHERE FID IN (%s)";
        ArrayList<String> list = new ArrayList<String>(10);
        Object[] params = new SqlParameter[ruleIds.length];
        for (int i = 0; i < ruleIds.length; ++i) {
            list.add("?");
            params[i] = new SqlParameter(":FId" + String.valueOf(i), 12, (Object)ruleIds[i]);
        }
        sql = String.format(sql, StringUtils.join((Object[])list.toArray(), (String)","));
        DB.execute((DBRoute)DBRoute.meta, (String)sql, (Object[])params);
    }

    public static Map<String, Object> delete(String sourceEntityNumber, String targetEntityNumber) {
        String sourceEntityId = MetadataDao.getIdByNumber((String)sourceEntityNumber, (MetaCategory)MetaCategory.Entity);
        boolean existSourceEntity = StringUtils.isNotBlank((CharSequence)sourceEntityId);
        String targetEntityId = MetadataDao.getIdByNumber((String)targetEntityNumber, (MetaCategory)MetaCategory.Entity);
        boolean existTargetEntity = StringUtils.isNotBlank((CharSequence)targetEntityId);
        ConvertRuleReader reader = new ConvertRuleReader();
        List rules = reader.loadMetas(sourceEntityNumber, targetEntityNumber);
        ArrayList<String> ruleIds = new ArrayList<String>(16);
        String currentIsv = RuleIsvHelper.getUserIsv();
        boolean isKingdee = RuleIsvHelper.isKindeeIsv();
        for (ConvertRuleMetadata ruleMetadata : rules) {
            boolean isExtRule = StringUtils.equals((CharSequence)"2", (CharSequence)ruleMetadata.getDevType());
            if (!isExtRule && ruleMetadata.getRuleElement().isEnabled() && existSourceEntity && existTargetEntity) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put(SUCCESS_STR, false);
                result.put(MESSAGE_STR, ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff1a\u6709\u542f\u7528\u7684\u8f6c\u6362\u89c4\u5219\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u8def\u7ebf\u3002\u8bf7\u5148\u505c\u7528\u89c4\u5219\u540e\u518d\u5220\u9664", (String)"ConvertRuleWriter_2", (String)BOS_BOTP_MEATADATA, (Object[])new Object[0]));
                return result;
            }
            if (!(StringUtils.equalsIgnoreCase((CharSequence)currentIsv, (CharSequence)ruleMetadata.getIsv()) || isKingdee || StringUtils.isBlank((CharSequence)ruleMetadata.getIsv()))) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put(SUCCESS_STR, false);
                result.put(MESSAGE_STR, ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff1a\u8def\u7ebf\u4e2d\u5305\u542b\u6709\u975e\u672c\u5f00\u53d1\u5546\u5f00\u53d1\u7684\u89c4\u5219\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u8def\u7ebf", (String)"ConvertRuleWriter_3", (String)BOS_BOTP_MEATADATA, (Object[])new Object[0]));
                return result;
            }
            ruleIds.add(ruleMetadata.getId());
        }
        if (!ruleIds.isEmpty()) {
            return ConvertRuleWriter.delete(ruleIds.toArray(new String[ruleIds.size()]));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(SUCCESS_STR, false);
        result.put(MESSAGE_STR, ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff1a\u6e90\u5355\u4e0e\u76ee\u6807\u5355\u4e4b\u95f4\uff0c\u6ca1\u6709\u8f6c\u6362\u89c4\u5219", (String)"ConvertRuleWriter_1", (String)BOS_BOTP_MEATADATA, (Object[])new Object[0]));
        return result;
    }

    public static void clearCache(String[] ruleIds) {
        ConvertRuleWriter.clearCache();
    }

    private static void setBizappId(final ConvertRuleMetadata ruleMetadata) {
        if (StringUtils.isBlank((CharSequence)ruleMetadata.getBizappId())) {
            String sql = "SELECT FNumber, FSubsysId, FBizAppId FROM t_meta_entitydesign WHERE FNumber = ?";
            Object[] params = new SqlParameter[]{new SqlParameter(":FNumber", 12, (Object)ruleMetadata.getRuleElement().getSourceEntityNumber())};
            ResultSetHandler<Object> action = new ResultSetHandler<Object>(){

                public Object handle(ResultSet rs) throws Exception {
                    if (rs.next()) {
                        int subSysId = rs.getInt("FSubsysId");
                        String bizAppId = rs.getString("FBizAppId");
                        ruleMetadata.setSubSysId(Integer.valueOf(subSysId));
                        ruleMetadata.setBizappId(bizAppId);
                    }
                    return null;
                }
            };
            DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
        }
    }

    private static void clearCache() {
        ConvertRuleCache.clearAllConvertRuleCache();
    }
}

