/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.botp.AttachmentPanelMapItem;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.FieldMapItem;
import kd.bos.entity.botp.GroupByMode;
import kd.bos.entity.botp.GroupByPolicy;
import kd.bos.entity.botp.LinkRecordType;
import kd.bos.entity.botp.plugin.args.AfterBuildRowConditionEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildGroupModeEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.entity.botp.runtime.AttachmentPanelMap;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.property.BillTypeProp;
import kd.bos.entity.property.LinkEntryProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.exception.KDBizException;
import kd.bos.service.botp.convert.SingleRuleContext;
import kd.bos.service.botp.convert.compiler.CRConditionCompiler;
import kd.bos.service.botp.convert.compiler.DependEntityMap;
import kd.bos.service.botp.convert.compiler.LinkEntityMap;
import kd.bos.service.botp.convert.getvaluemode.GetConstValue;
import kd.bos.service.botp.convert.getvaluemode.GetSourceFieldValue;
import kd.bos.service.botp.convert.getvaluemode.IGetValueMode;
import kd.bos.service.botp.convert.group.SourceRowsGroupKeyBuilder;
import kd.bos.service.botp.convert.mapping.IMappingField;
import kd.bos.service.botp.convert.mapping.MappingCtrlField;
import kd.bos.service.botp.convert.mapping.MappingSBillId;
import kd.bos.service.botp.convert.mapping.MappingSId;
import kd.bos.service.botp.convert.mapping.MappingSTableId;
import kd.bos.service.botp.convert.var.IVariableMode;
import kd.bos.service.botp.convert.var.SourceFieldVariable;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;

public class ConvertRuleCompiler {
    private static final String BOS_MSERVICE_BOTP = "bos-mservice-botp";
    private SingleRuleContext ruleContext;
    private ConvertRuleElement rule;
    private CRConditionCompiler ruleCondCompiler;
    private CRConditionCompiler dataFilterCompiler;
    private List<CRConditionCompiler> dataFilterCompilers = new ArrayList<CRConditionCompiler>();
    private IMappingField mappingMainOrg;
    private IMappingField mappingBillType;
    private LinkEntityMap linkEntityMap;
    private Map<String, DependEntityMap> dependEntityMaps = new HashMap<String, DependEntityMap>();
    private Map<String, AttachmentPanelMap> attachmentPanelMaps = new HashMap<String, AttachmentPanelMap>();

    public ConvertRuleCompiler(SingleRuleContext ruleContext) {
        this.ruleContext = ruleContext;
        this.rule = ruleContext.getRule();
    }

    public CRConditionCompiler getRuleCondCompiler() {
        return this.ruleCondCompiler;
    }

    public CRConditionCompiler getDataFilterCompiler() {
        return this.dataFilterCompiler;
    }

    public List<CRConditionCompiler> getDataFilterCompilers() {
        return this.dataFilterCompilers;
    }

    public void setDataFilterCompilers(List<CRConditionCompiler> dataFilterCompilers) {
        this.dataFilterCompilers = dataFilterCompilers;
    }

    public IMappingField getMappingMainOrg() {
        return this.mappingMainOrg;
    }

    public IMappingField getMappingBillType() {
        return this.mappingBillType;
    }

    public LinkEntityMap getLinkEntityMap() {
        return this.linkEntityMap;
    }

    public Map<String, DependEntityMap> getDependEntityMaps() {
        return this.dependEntityMaps;
    }

    public Map<String, AttachmentPanelMap> getAttachmentPanelMaps() {
        return this.attachmentPanelMaps;
    }

    public CRConditionCompiler compileRunCondition() {
        CRCondition condition = this.rule.getRunCondition();
        this.ruleCondCompiler = new CRConditionCompiler(condition);
        this.ruleCondCompiler.compile(this.ruleContext);
        return this.ruleCondCompiler;
    }

    public CRConditionCompiler compileRowCondition() {
        CRCondition condition = this.rule.getFilterPolicy().getCondition();
        BeforeBuildRowConditionEventArgs eventArgs = new BeforeBuildRowConditionEventArgs();
        eventArgs.setSelectedRows(this.ruleContext.getSelectedRows());
        this.ruleContext.getPlugInProxy().fireBeforeBuildRowCondition(eventArgs);
        this.dataFilterCompiler = null;
        this.dataFilterCompiler = eventArgs.isIgnoreRuleFilterPolicy() ? new CRConditionCompiler(eventArgs.getCustQFilters(), eventArgs.getCustFilterExpression(), eventArgs.getCustFilterDesc()) : new CRConditionCompiler(condition, eventArgs.getCustQFilters(), eventArgs.getCustFilterExpression(), eventArgs.getCustFilterDesc());
        this.dataFilterCompiler.compile(this.ruleContext);
        return this.dataFilterCompiler;
    }

    public CRConditionCompiler compileRowCondition(CRCondition crCondition) {
        CRCondition condition = crCondition;
        BeforeBuildRowConditionEventArgs eventArgs = new BeforeBuildRowConditionEventArgs();
        eventArgs.setSelectedRows(this.ruleContext.getSelectedRows());
        this.ruleContext.getPlugInProxy().fireBeforeBuildRowCondition(eventArgs);
        this.dataFilterCompiler = null;
        this.dataFilterCompiler = eventArgs.isIgnoreRuleFilterPolicy() ? new CRConditionCompiler(eventArgs.getCustQFilters(), eventArgs.getCustFilterExpression(), eventArgs.getCustFilterDesc()) : new CRConditionCompiler(condition, eventArgs.getCustQFilters(), eventArgs.getCustFilterExpression(), eventArgs.getCustFilterDesc());
        this.dataFilterCompiler.compile(this.ruleContext);
        return this.dataFilterCompiler;
    }

    public void compilePolicys() {
        this.compileLinkEntryPolicy();
        this.compileMainOrgMapPolicy();
        this.compileBillTypeMapPolicy();
        this.compileAttachmentPanelMapPolicy();
        this.compileFieldMapPolicy();
        this.compileFilterPolicy();
        this.compileGroupPolicy();
    }

    private void compileLinkEntryPolicy() {
        this.linkEntityMap = new LinkEntityMap();
        this.compileMainLinkEntity();
        this.compileLinkSet();
    }

    private void compileMainOrgMapPolicy() {
        IDataEntityProperty mainOrgProp;
        String mainOrgKey = this.ruleContext.getContext().getSourceMainType().getMainOrg();
        IDataEntityProperty iDataEntityProperty = mainOrgProp = StringUtils.isBlank((CharSequence)mainOrgKey) ? null : this.ruleContext.getContext().getSourceMainType().findProperty(mainOrgKey);
        if (mainOrgProp == null) {
            GetConstValue reader = new GetConstValue((Object)0L);
            this.linkEntityMap.setSrcMainOrgReader((IGetValueMode)reader);
        } else {
            GetSourceFieldValue reader = new GetSourceFieldValue(this.ruleContext, mainOrgProp.getName());
            this.linkEntityMap.setSrcMainOrgReader((IGetValueMode)reader);
            for (IVariableMode var : reader.getVars()) {
                if (!(var instanceof SourceFieldVariable)) continue;
                this.linkEntityMap.addSourceField((SourceFieldVariable)var);
            }
        }
    }

    private void compileBillTypeMapPolicy() {
        IDataEntityProperty billTypeProp;
        String billTypeKey = this.ruleContext.getContext().getSourceMainType().getBillType();
        IDataEntityProperty iDataEntityProperty = billTypeProp = StringUtils.isBlank((CharSequence)billTypeKey) ? null : this.ruleContext.getContext().getSourceMainType().findProperty(billTypeKey);
        if (billTypeProp == null) {
            GetConstValue reader = new GetConstValue((Object)0L);
            this.linkEntityMap.setSrcBillTypeReader((IGetValueMode)reader);
        } else {
            GetSourceFieldValue reader = new GetSourceFieldValue(this.ruleContext, billTypeProp.getName());
            this.linkEntityMap.setSrcBillTypeReader((IGetValueMode)reader);
            for (IVariableMode var : reader.getVars()) {
                if (!(var instanceof SourceFieldVariable)) continue;
                this.linkEntityMap.addSourceField((SourceFieldVariable)var);
            }
        }
    }

    private void compileAttachmentPanelMapPolicy() {
        List mapItems = this.rule.getAttachmentPanelMapPolicy().getItems();
        if (mapItems.isEmpty()) {
            return;
        }
        this.attachmentPanelMaps = new HashMap<String, AttachmentPanelMap>();
        for (AttachmentPanelMapItem attachmentMapItem : mapItems) {
            this.compileAttachmentPanelMapItem(attachmentMapItem);
        }
    }

    private void compileAttachmentPanelMapItem(AttachmentPanelMapItem attachmentMapItem) {
        BillEntityType sourceEntityType = this.ruleContext.getContext().getSourceMainType();
        BillEntityType targetEntityType = this.ruleContext.getContext().getTargetMainType();
        AttachmentPanelMap attachMap = new AttachmentPanelMap(sourceEntityType, targetEntityType);
        attachMap.setSourceAttachmentPanelKey(attachmentMapItem.getSourceAttachmentPanel());
        attachMap.setTargetAttachmentPanelKey(attachmentMapItem.getTargetAttachmentPanel());
        attachMap.setAttachmentPanelMergeType(attachmentMapItem.getAttachmentPanelMergeType());
        this.attachmentPanelMaps.put(attachmentMapItem.getTargetAttachmentPanel(), attachMap);
    }

    private void compileFieldMapPolicy() {
        for (FieldMapItem fieldMapItem : this.rule.getFieldMapPolicy().getFieldMaps()) {
            this.compileFieldMapItem(fieldMapItem);
        }
        this.compileDependEntityMaps();
    }

    private void compileFieldMapItem(FieldMapItem fieldMapItem) {
        IMappingField mappingField = IMappingField.create((SingleRuleContext)this.ruleContext, (FieldMapItem)fieldMapItem);
        if (mappingField == null) {
            return;
        }
        if (mappingField.getTargetFieldProp() instanceof MainOrgProp) {
            this.mappingMainOrg = mappingField;
        } else if (mappingField.getTargetFieldProp() instanceof BillTypeProp) {
            this.mappingBillType = mappingField;
        }
        String joinTargetEntityKeys = mappingField.getJoinTargetEntityKeys();
        String joinSourceEntityKeys = mappingField.getJoinSourceEntityKeys();
        if (this.linkEntityMap.getJoinTargetEntityKeys().startsWith(joinTargetEntityKeys) && this.linkEntityMap.getJoinSourceEntityKeys().startsWith(joinSourceEntityKeys)) {
            this.linkEntityMap.addMappingField(mappingField);
        } else {
            DependEntityMap dependEntityMap = this.dependEntityMaps.get(joinTargetEntityKeys);
            if (dependEntityMap == null) {
                dependEntityMap = this.createDependEntityMap(mappingField);
                this.dependEntityMaps.put(joinTargetEntityKeys, dependEntityMap);
            } else {
                dependEntityMap.addMappingField(mappingField);
            }
        }
    }

    private void compileFilterPolicy() {
        if (!this.rule.getFilterPolicy().getAdvCondition().booleanValue()) {
            this.compileRowCondition();
            this.dataFilterCompiler.compileSubCondition(this.ruleContext);
            this.fireAfterBuildRowCondition();
            for (IVariableMode var : this.dataFilterCompiler.getVars()) {
                this.linkEntityMap.addSourceField((SourceFieldVariable)var);
            }
        } else {
            List conditionList = this.rule.getFilterPolicy().getConditionList();
            this.dataFilterCompilers = new ArrayList<CRConditionCompiler>(conditionList.size());
            for (CRCondition condition : conditionList) {
                if (!condition.isEnabled()) continue;
                this.compileRowCondition(condition);
                this.dataFilterCompiler.compileSubCondition(this.ruleContext);
                this.fireAfterBuildRowCondition();
                for (IVariableMode var : this.dataFilterCompiler.getVars()) {
                    this.linkEntityMap.addSourceField((SourceFieldVariable)var);
                }
                this.dataFilterCompilers.add(this.dataFilterCompiler);
            }
            if (this.dataFilterCompilers.size() == 0) {
                CRCondition crcondition = new CRCondition();
                this.compileRowCondition(crcondition);
                this.dataFilterCompiler.compileSubCondition(this.ruleContext);
                this.fireAfterBuildRowCondition();
                for (IVariableMode var : this.dataFilterCompiler.getVars()) {
                    this.linkEntityMap.addSourceField((SourceFieldVariable)var);
                }
                this.dataFilterCompilers.add(this.dataFilterCompiler);
            }
        }
    }

    private void fireAfterBuildRowCondition() {
        AfterBuildRowConditionEventArgs afterBuildArgs = new AfterBuildRowConditionEventArgs();
        for (CRConditionCompiler item : this.dataFilterCompiler.getSubCondCompilers()) {
            if (!StringUtils.isNotBlank((CharSequence)item.getFullExpression())) continue;
            afterBuildArgs.addCondition(item.getFullExpression());
        }
        this.ruleContext.getPlugInProxy().fireAfterBuildRowCondition(afterBuildArgs);
        HashMap<String, String> conditionDescs = new HashMap<String, String>(afterBuildArgs.getConditons().size());
        for (AfterBuildRowConditionEventArgs.ConditionInfo item : afterBuildArgs.getConditons()) {
            if (!StringUtils.isNotBlank((CharSequence)item.getDescription())) continue;
            conditionDescs.put(item.getExpression(), item.getDescription());
        }
        for (AfterBuildRowConditionEventArgs.ConditionInfo item : this.dataFilterCompiler.getSubCondCompilers()) {
            if (!conditionDescs.containsKey(item.getFullExpression())) continue;
            item.setCustFilterDesc((String)conditionDescs.get(item.getFullExpression()));
        }
    }

    private void compileGroupPolicy() {
        block4: {
            GroupByPolicy policy = this.rule.getGroupByPolicy();
            String groupKey1 = this.compileGroupHead(policy);
            String groupKey2 = this.compileGroupEntry(policy);
            String groupKey3 = this.compileGroupSubEntry(policy);
            BeforeBuildGroupModeEventArgs eventArgs = new BeforeBuildGroupModeEventArgs(groupKey1, groupKey2, groupKey3);
            this.ruleContext.getPlugInProxy().fireBeforeBuildGroupMode(eventArgs);
            groupKey1 = eventArgs.getHeadGroupKey();
            groupKey2 = eventArgs.getEntryGroupKey();
            groupKey3 = eventArgs.getSubEntryGroupKey();
            try {
                SourceRowsGroupKeyBuilder headGroupBuilder = new SourceRowsGroupKeyBuilder(this.ruleContext, groupKey1);
                this.linkEntityMap.addSourceRowsGroupKeyBuilders(headGroupBuilder);
                if (StringUtils.isNotBlank((CharSequence)groupKey2)) {
                    SourceRowsGroupKeyBuilder entryGroupBuilder = new SourceRowsGroupKeyBuilder(this.ruleContext, groupKey2);
                    this.linkEntityMap.addSourceRowsGroupKeyBuilders(entryGroupBuilder);
                }
                if (StringUtils.isNotBlank((CharSequence)groupKey3)) {
                    SourceRowsGroupKeyBuilder subEntryGroupBuilder = new SourceRowsGroupKeyBuilder(this.ruleContext, groupKey3);
                    this.linkEntityMap.addSourceRowsGroupKeyBuilders(subEntryGroupBuilder);
                }
            }
            catch (KDBizException exp) {
                if (!exp.getErrorCode().getCode().equals("bos.fieldNotExist")) break block4;
                String errMessage = String.format(ResManager.loadKDString((String)"\u8f6c\u6362\u89c4\u5219[%1$s]\u914d\u7f6e\u6709\u8bef\uff1a\u5206\u5355\u7b56\u7565/\u5355\u636e\u4f53\u884c\u5408\u5e76\u7b56\u7565\u7684\u5206\u5355\u4f9d\u636e\u5b57\u6bb5/\u5408\u5e76\u4f9d\u636e\u5b57\u6bb5[%2$s]\uff0c\u5728\u6e90\u5355\u4e0a\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u8f6c\u6362\u89c4\u5219", (String)"ConvertRuleCompiler_6", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), this.ruleContext.getRule().getName(), exp.getArgs()[1]);
                throw new KDBizException(errMessage);
            }
        }
    }

    private String compileGroupHead(GroupByPolicy policy) {
        String groupKey1 = "id";
        if (policy.getGroupByMode() == GroupByMode.GroupByField) {
            if (StringUtils.isNotBlank((CharSequence)policy.getGroupByField())) {
                groupKey1 = policy.getGroupByField();
            }
        } else if (policy.getGroupByMode() == GroupByMode.AllInOne) {
            groupKey1 = "@all";
        }
        return groupKey1;
    }

    private String compileGroupEntry(GroupByPolicy policy) {
        String groupKey2 = "";
        if (StringUtils.isNotBlank((CharSequence)this.linkEntityMap.targetEntryKey)) {
            groupKey2 = "@all";
            boolean isLinkEntity = StringUtils.equalsIgnoreCase((CharSequence)this.linkEntityMap.getTargetEntryKey(), (CharSequence)this.linkEntityMap.getTargetLinkEntityKey());
            String sourceEntryPKField = "id";
            if (isLinkEntity) {
                if (StringUtils.equals((CharSequence)this.linkEntityMap.getSourceLinkEntityKey(), (CharSequence)this.linkEntityMap.getSourceEntryKey())) {
                    sourceEntryPKField = this.linkEntityMap.getSourceEntryPKFullName();
                } else if (StringUtils.equals((CharSequence)this.linkEntityMap.getSourceLinkEntityKey(), (CharSequence)this.linkEntityMap.getSourceSubEntryKey())) {
                    sourceEntryPKField = this.linkEntityMap.getSourceSubEntryPKFullName();
                }
            } else if (StringUtils.isNotBlank((CharSequence)this.linkEntityMap.sourceEntryKey)) {
                sourceEntryPKField = this.linkEntityMap.getSourceEntryPKFullName();
            }
            if (policy.getGroupByMode2() == GroupByMode.OneToOne) {
                groupKey2 = sourceEntryPKField;
            } else if (policy.getGroupByMode2() == GroupByMode.GroupByField && StringUtils.isBlank((CharSequence)(groupKey2 = policy.getGroupByField2()))) {
                groupKey2 = sourceEntryPKField;
            }
        }
        return groupKey2;
    }

    private String compileGroupSubEntry(GroupByPolicy policy) {
        String groupKey3 = "";
        if (StringUtils.isNotBlank((CharSequence)this.linkEntityMap.targetSubEntryKey)) {
            groupKey3 = "@all";
            String sourceSubEntryPKField = "id";
            if (StringUtils.isNotBlank((CharSequence)this.linkEntityMap.sourceSubEntryKey)) {
                sourceSubEntryPKField = this.linkEntityMap.getSourceSubEntryPKFullName();
            } else if (StringUtils.isNotBlank((CharSequence)this.linkEntityMap.sourceEntryKey)) {
                sourceSubEntryPKField = this.linkEntityMap.getSourceEntryPKFullName();
            }
            if (policy.getGroupByMode3() == GroupByMode.OneToOne) {
                groupKey3 = sourceSubEntryPKField;
            } else if (policy.getGroupByMode3() == GroupByMode.GroupByField && StringUtils.isBlank((CharSequence)(groupKey3 = policy.getGroupByField3()))) {
                groupKey3 = sourceSubEntryPKField;
            }
        }
        return groupKey3;
    }

    private void compileDependEntityMaps() {
        DependEntityMap entityMap;
        DependEntityMap headMap = null;
        HashMap<EntityType, DependEntityMap> entryMaps = new HashMap<EntityType, DependEntityMap>();
        HashMap<EntityType, DependEntityMap> subEntryMaps = new HashMap<EntityType, DependEntityMap>();
        for (Map.Entry<String, DependEntityMap> entry : this.dependEntityMaps.entrySet()) {
            entityMap = entry.getValue();
            EntityType entityType = entityMap.getTargetEntity();
            if (entityType instanceof SubEntryType) {
                subEntryMaps.put(entityType, entityMap);
                continue;
            }
            if (entityType instanceof EntryType) {
                entryMaps.put(entityType, entityMap);
                continue;
            }
            if (!(entityType instanceof BillEntityType)) continue;
            headMap = entityMap;
        }
        for (Map.Entry<String, Object> entry : subEntryMaps.entrySet()) {
            DependEntityMap subEntryMap = (DependEntityMap)entry.getValue();
            this.mergeEntryDependEntityMap(subEntryMap, entryMaps);
        }
        this.dependEntityMaps.clear();
        for (Map.Entry<String, Object> entry : subEntryMaps.entrySet()) {
            this.dependEntityMaps.put(((DependEntityMap)entry.getValue()).getJoinTargetEntityKeys(), (DependEntityMap)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : entryMaps.entrySet()) {
            entityMap = (DependEntityMap)entry.getValue();
            List targetFields = (List)entityMap.getTargetFields().get(entry.getKey());
            if (targetFields.isEmpty()) continue;
            this.compileDependSourceEntity(entityMap);
            this.dependEntityMaps.put(entityMap.getJoinTargetEntityKeys(), entityMap);
        }
        this.mergeHeadDependEntityMap(headMap);
        for (DependEntityMap dependEntityMap : this.dependEntityMaps.values()) {
            dependEntityMap.compileAnchorEntity(this.ruleContext, this.linkEntityMap, this.dependEntityMaps);
        }
    }

    private void mergeEntryDependEntityMap(DependEntityMap subEntryMap, Map<EntityType, DependEntityMap> entryMaps) {
        this.compileDependSourceEntity(subEntryMap);
        String joinSourceEntityKey = subEntryMap.getJoinSourceEntityKeys();
        EntryType entryType = (EntryType)subEntryMap.getTargetEntity().getParent();
        DependEntityMap entryMap = entryMaps.get(entryType);
        if (entryMap != null) {
            List targetFields = (List)entryMap.getTargetFields().get(entryType);
            ArrayList list = new ArrayList();
            list.addAll(targetFields);
            for (IMappingField mappingField : list) {
                if (!joinSourceEntityKey.equalsIgnoreCase(mappingField.getJoinSourceEntityKeys())) continue;
                subEntryMap.addMappingField(mappingField);
                targetFields.remove(mappingField);
            }
        }
    }

    private void mergeHeadDependEntityMap(DependEntityMap targetHeadEntityMap) {
        if (targetHeadEntityMap == null) {
            return;
        }
        HashMap srcEntityMaps = new HashMap();
        for (DependEntityMap entityMap : this.dependEntityMaps.values()) {
            String joinSourceEntityKeys = entityMap.getJoinSourceEntityKeys();
            if (!srcEntityMaps.containsKey(joinSourceEntityKeys)) {
                srcEntityMaps.put(joinSourceEntityKeys, new ArrayList());
            }
            ((List)srcEntityMaps.get(joinSourceEntityKeys)).add(entityMap);
        }
        HashMap fieldGroups = new HashMap();
        List fields = (List)targetHeadEntityMap.getTargetFields().entrySet().iterator().next().getValue();
        for (Object mappingField : fields) {
            String string = mappingField.getJoinSourceEntityKeys();
            if (!fieldGroups.containsKey(string)) {
                fieldGroups.put(string, new ArrayList());
            }
            ((List)fieldGroups.get(string)).add(mappingField);
        }
        HashMap<String, DependEntityMap> newEntityMaps = new HashMap<String, DependEntityMap>();
        for (Map.Entry entry : fieldGroups.entrySet()) {
            String sourceEntityKeys = (String)entry.getKey();
            List mappingFields = (List)entry.getValue();
            List dependEntityMapList = (List)srcEntityMaps.get(sourceEntityKeys);
            DependEntityMap dependEntityMap = (DependEntityMap)newEntityMaps.get(sourceEntityKeys);
            if (dependEntityMapList != null && !dependEntityMapList.isEmpty()) {
                ((DependEntityMap)dependEntityMapList.get(0)).addMappingFields(mappingFields);
                continue;
            }
            if (dependEntityMap != null) {
                dependEntityMap.addMappingFields(mappingFields);
                continue;
            }
            DependEntityMap entityMap = new DependEntityMap((EntityType)this.ruleContext.getContext().getTargetMainType());
            entityMap.addMappingFields(mappingFields);
            newEntityMaps.put(sourceEntityKeys, entityMap);
        }
        int index = 1;
        for (Map.Entry entry : newEntityMaps.entrySet()) {
            DependEntityMap entityMap = (DependEntityMap)entry.getValue();
            String joinTargetEntityKeys = entityMap.getJoinTargetEntityKeys() + String.valueOf(index);
            this.dependEntityMaps.put(joinTargetEntityKeys, entityMap);
            ++index;
        }
    }

    private void compileDependSourceEntity(DependEntityMap entityMap) {
        entityMap.compileSourceEntity();
        if (!entityMap.isCompileSuccess()) {
            String errMessage = String.format(ResManager.loadKDString((String)"\u8f6c\u6362\u89c4\u5219-[%1$s]\u914d\u7f6e\u4e0d\u5408\u7406\uff1a%2$s", (String)"ConvertRuleCompiler_3", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), this.rule.getName(), entityMap.getCompileFailMessage());
            throw new KDBizException(errMessage);
        }
    }

    private DependEntityMap createDependEntityMap(IMappingField mappingField) {
        EntityType targetEntity = (EntityType)mappingField.getTargetFieldProp().getParent();
        DependEntityMap entityMap = new DependEntityMap(targetEntity);
        entityMap.addMappingField(mappingField);
        return entityMap;
    }

    private void compileMainLinkEntity() {
        BillEntityType tgtMainType;
        BillEntityType srcMainType;
        BillEntityType srcEntity = srcMainType = this.ruleContext.getContext().getSourceMainType();
        if (StringUtils.isNotBlank((CharSequence)this.rule.getLinkEntityPolicy().getSourceEntryKey()) && (srcEntity = (EntityType)srcMainType.getAllEntities().get(this.rule.getLinkEntityPolicy().getSourceEntryKey())) == null) {
            String errMessage = String.format(ResManager.loadKDString((String)"\u8f6c\u6362\u89c4\u5219-[%1$s]\u914d\u7f6e\u4e0d\u5408\u7406\uff1a\u5728\u6e90\u5355\u4e0a\uff0c\u627e\u4e0d\u5230\u5173\u8054\u4e3b\u5b9e\u4f53%2$s", (String)"ConvertRuleCompiler_4", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), this.rule.getName(), this.rule.getLinkEntityPolicy().getSourceEntryKey());
            throw new KDBizException(errMessage);
        }
        this.linkEntityMap.setSourceLinkEntityKey(srcEntity.getName());
        if (srcEntity instanceof SubEntryType) {
            this.linkEntityMap.setSourceEntryKey(((SubEntryType)srcEntity).getParent().getName());
            this.linkEntityMap.setSourceSubEntryKey(srcEntity.getName());
        } else if (srcEntity instanceof EntryType) {
            this.linkEntityMap.setSourceEntryKey(srcEntity.getName());
            if (StringUtils.isNotBlank((CharSequence)this.rule.getLinkEntityPolicy().getSourceSubEntryKey())) {
                this.linkEntityMap.setSourceSubEntryKey(this.rule.getLinkEntityPolicy().getSourceSubEntryKey());
            }
        }
        BillEntityType tgtEntity = tgtMainType = this.ruleContext.getContext().getTargetMainType();
        if (StringUtils.isNotBlank((CharSequence)this.rule.getLinkEntityPolicy().getTargetEntryKey()) && (tgtEntity = (EntityType)tgtMainType.getAllEntities().get(this.rule.getLinkEntityPolicy().getTargetEntryKey())) == null) {
            String errMessage = String.format(ResManager.loadKDString((String)"\u8f6c\u6362\u89c4\u5219-[%1$s]\u914d\u7f6e\u4e0d\u5408\u7406\uff1a\u5728\u76ee\u6807\u5355\u4e0a\uff0c\u627e\u4e0d\u5230\u5173\u8054\u4e3b\u5b9e\u4f53%2$s", (String)"ConvertRuleCompiler_5", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), this.rule.getName(), this.rule.getLinkEntityPolicy().getTargetEntryKey());
            throw new KDBizException(errMessage);
        }
        this.linkEntityMap.setTargetLinkEntityKey(tgtEntity.getName());
        if (tgtEntity instanceof SubEntryType) {
            this.linkEntityMap.setTargetSubEntryKey(tgtEntity.getName());
            this.linkEntityMap.setTargetEntryKey(((SubEntryType)tgtEntity).getParent().getName());
        } else if (tgtEntity instanceof EntryType) {
            this.linkEntityMap.setTargetEntryKey(tgtEntity.getName());
            if (StringUtils.isNotBlank((CharSequence)this.rule.getLinkEntityPolicy().getTargetSubEntryKey())) {
                this.linkEntityMap.setTargetSubEntryKey(this.rule.getLinkEntityPolicy().getTargetSubEntryKey());
            }
        }
    }

    private void compileLinkSet() {
        LinkEntryProp linkEntryProp = this.findLinkEntryProp();
        if (linkEntryProp == null) {
            return;
        }
        LinkEntryType linkEntryType = (LinkEntryType)linkEntryProp.getItemType();
        EntityType parentType = (EntityType)this.ruleContext.getContext().getTargetMainType().getAllEntities().get(this.linkEntityMap.getTargetLinkEntityKey());
        this.linkEntityMap.setLinkEntryProp(linkEntryProp);
        TableDefine tableDefine = ConvertMetaServiceHelper.loadTableDefine((String)this.rule.getSourceEntityNumber(), (String)this.linkEntityMap.getSourceLinkEntityKey());
        DynamicProperty sTableIdProp = linkEntryType.getSTableIdProp();
        DynamicProperty sBillIdProp = linkEntryType.getSBillIdProp();
        DynamicProperty sIdProp = linkEntryType.getSIdProp();
        if (sTableIdProp == null || sBillIdProp == null || sIdProp == null) {
            return;
        }
        MappingSTableId mappingSTableId = new MappingSTableId(sTableIdProp, tableDefine.getTableId());
        this.linkEntityMap.addMappingField((IMappingField)mappingSTableId);
        MappingSBillId mappingSBillId = new MappingSBillId(this.ruleContext, sBillIdProp);
        this.linkEntityMap.addMappingField((IMappingField)mappingSBillId);
        MappingSId mappingSId = null;
        if (this.linkEntityMap.getSourceLinkEntityKey().equalsIgnoreCase(this.rule.getSourceEntityNumber())) {
            mappingSId = new MappingSId(this.ruleContext, sIdProp, "id");
        } else if (this.linkEntityMap.getSourceLinkEntityKey().equalsIgnoreCase(this.linkEntityMap.getSourceSubEntryKey())) {
            String srcSubEntryPK = this.linkEntityMap.getSourceSubEntryPKFullName();
            mappingSId = new MappingSId(this.ruleContext, sIdProp, srcSubEntryPK);
        } else {
            String srcEntryPK = this.linkEntityMap.getSourceEntryPKFullName();
            mappingSId = new MappingSId(this.ruleContext, sIdProp, srcEntryPK);
        }
        this.linkEntityMap.addMappingField((IMappingField)mappingSId);
        HashMap<String, FieldMapItem> fieldMaps = new HashMap<String, FieldMapItem>(this.rule.getFieldMapPolicy().getFieldMaps().size());
        for (FieldMapItem fieldMapItem : this.rule.getFieldMapPolicy().getFieldMaps()) {
            if (!fieldMapItem.isValid()) continue;
            fieldMaps.put(fieldMapItem.getTargetFieldKey(), fieldMapItem);
        }
        for (Map.Entry entry : linkEntryType.getCtrlFieldProps().entrySet()) {
            String ctrlFieldKeyOri = (String)entry.getKey();
            DynamicProperty ctrlFieldOri = (DynamicProperty)parentType.findProperty(ctrlFieldKeyOri);
            DynamicProperty ctrlFieldNew = (DynamicProperty)entry.getValue();
            DynamicProperty ctrlFieldOld = (DynamicProperty)linkEntryType.getOldCtrlFieldProps().get(ctrlFieldKeyOri);
            FieldMapItem fieldMapItem = (FieldMapItem)fieldMaps.get(ctrlFieldKeyOri);
            if (ctrlFieldOri == null || ctrlFieldNew == null || ctrlFieldOld == null || fieldMapItem == null || !fieldMapItem.isValid()) continue;
            MappingCtrlField mappingCtrlField = new MappingCtrlField(this.ruleContext, ctrlFieldOld, ctrlFieldNew, fieldMapItem);
            this.linkEntityMap.addMappingField((IMappingField)mappingCtrlField);
        }
    }

    private LinkEntryProp findLinkEntryProp() {
        if (this.rule.getLinkEntityPolicy().getLinkRecordType() == LinkRecordType.OnlyCopy) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)this.linkEntityMap.getTargetLinkEntityKey())) {
            return null;
        }
        BillEntityType tgtMainType = this.ruleContext.getContext().getTargetMainType();
        LinkSetElement linkSet = ConvertMetaServiceHelper.loadLinkSet((String)tgtMainType.getName());
        if (linkSet == null || linkSet.getItems().isEmpty()) {
            return null;
        }
        LinkSetItemElement linkSetItem = null;
        for (LinkSetItemElement item : linkSet.getItems()) {
            if (!this.linkEntityMap.getTargetLinkEntityKey().equalsIgnoreCase(item.getParentEntityKey())) continue;
            linkSetItem = item;
            break;
        }
        if (linkSetItem == null || StringUtils.isBlank((CharSequence)linkSetItem.getLinkEntityKey()) || StringUtils.isBlank((CharSequence)linkSetItem.getTableName())) {
            return null;
        }
        EntityType parentType = (EntityType)tgtMainType.getAllEntities().get(this.linkEntityMap.getTargetLinkEntityKey());
        if (parentType == null) {
            return null;
        }
        return (LinkEntryProp)parentType.findProperty(linkSetItem.getLinkEntityKey());
    }
}

