/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.track;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.botp.log.BOTPLog;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.param.CustomParam;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.param.impl.ParameterReaderServiceImpl;
import kd.bos.service.botp.track.BFTrackerBatchContext;
import kd.bos.service.botp.track.BFTrackerBatchResult;
import kd.bos.service.botp.track.BFTrackerContext;
import kd.bos.service.botp.track.BFTrackerOpContext;
import kd.bos.service.botp.track.BFTrackerResult;
import kd.bos.service.botp.track.LinkItemContext;
import kd.bos.service.botp.track.actions.BFTrackBatchExecuter;
import kd.bos.service.botp.track.bizentity.AED;
import kd.bos.service.botp.track.bizentity.BillTracker;
import kd.bos.service.botp.track.helper.BFTrackerDbService;
import kd.bos.service.botp.track.helper.BillTrackerBuilder;
import kd.bos.service.botp.track.helper.CheckRowsHandle;
import kd.bos.service.botp.track.opcontroller.IOpController;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

class BFTracker {
    private static final String BFTRACKER_EXECUTE_LINK_ITEM = "BFTracker.executeLinkItem(linkItemContext)";
    protected BFTrackerContext trackerContext;
    protected BFTrackerOpContext trackerOpContext;
    protected String targetEntityNumber;
    protected BFTrackerResult trackerResult;
    protected BFTrackerDbService dbService;
    protected BillTrackerBuilder billTrackerHelper;
    private static final String CUSTOM_PARAM_KEY_APPEND_ENTRYROW = "botpAppendEntryRowCtr";
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"BFTracker", (int)32);

    public BFTracker(BFTrackerContext trackerContext, BFTrackerResult trackerResult, IOpController opController, BFTrackerDbService dbService) {
        this.trackerContext = trackerContext;
        this.trackerResult = trackerResult;
        this.dbService = dbService;
        this.trackerOpContext = new BFTrackerOpContext(trackerContext, opController);
        if (this.trackerContext == null || opController == null || this.dbService == null) {
            return;
        }
        this.trackerOpContext.getOpController().setContext(this.trackerContext, this.dbService);
        this.targetEntityNumber = this.trackerContext.getTargetMainType().getName();
        this.billTrackerHelper = new BillTrackerBuilder(this.dbService);
    }

    public void execute(DynamicObject[] dataEntities) {
        this.trackerContext.getOperateLog().beginMothed("BFTracker.execute(dataEntities)", null);
        Long[] billIds = new Long[dataEntities.length];
        int i = 0;
        for (DynamicObject dataEntity : dataEntities) {
            billIds[i] = (Long)dataEntity.getPkValue();
            ++i;
        }
        this.trackerOpContext.setBillIds(billIds);
        this.trackerOpContext.setDataEntities(dataEntities);
        this.trackerOpContext.setHasSnapshot(false);
        CheckRowsHandle.checkMoreThanRows(this.trackerContext, dataEntities);
        for (LinkSetItemElement linkSetItem : this.trackerContext.getLinkSet().getItems()) {
            LinkItemContext linkItemContext = LinkItemContext.create((BFTrackerContext)this.trackerContext, (BFTrackerOpContext)this.trackerOpContext, (LinkSetItemElement)linkSetItem);
            this.trackerContext.getPlugInProxy().setContext(this.trackerContext.getTargetSubMainType(), this.trackerContext.getOpType().name(), linkSetItem);
            this.executeLinkItem(linkItemContext);
        }
        if (this.trackerOpContext.isHasSnapshot() || this.getCustomParamAppendEntryRow() && this.isAppendEntryRow()) {
            TableDefine mainTableDefine = ConvertMetaServiceHelper.loadTableDefine((String)this.targetEntityNumber, (String)this.targetEntityNumber);
            Long mainTableId = mainTableDefine.getTableId();
            HashSet sMainTableIds = new HashSet(this.trackerOpContext.getHistSrcMainTableIds());
            HashSet sBillIds = new HashSet(this.trackerOpContext.getHistSrcBillIds());
            List histBillTrackerObjs = this.dbService.readBillTracker(sMainTableIds, sBillIds, mainTableId, billIds);
            this.billTrackerHelper.buildHistBillTracker(histBillTrackerObjs);
        }
        AED aedBillTracker = this.billTrackerHelper.sync();
        this.applyBillTracker((AED<BillTracker>)aedBillTracker);
        this.trackerContext.getOperateLog().endMothed("BFTracker.execute(dataEntities)", null);
    }

    public void retry(BOTPLog[] wbLogs) {
    }

    private void executeLinkItem(LinkItemContext linkItemContext) {
        if (this.trackerContext.getOperateLog().isWriteLog()) {
            String msg = String.format("BFTracker.executeLinkItem(linkItemContext): opControler =%s, linkSetItem = %s, billids(%s) = %s", this.trackerOpContext.getOpController().getClass().getSimpleName(), linkItemContext.getLinkSetItem().getParentEntityKey(), this.trackerOpContext.getBillIds().length, this.trackerOpContext.getBillIds()[0]) + (this.trackerOpContext.getBillIds().length > 0 ? "..." : "");
            this.trackerContext.getOperateLog().beginMothed(BFTRACKER_EXECUTE_LINK_ITEM, msg);
        }
        linkItemContext.splitPage(this.trackerOpContext.getDataEntities());
        if (linkItemContext.isEmpty()) {
            this.trackerContext.getOperateLog().endMothed(BFTRACKER_EXECUTE_LINK_ITEM, "BFTracker.executeLinkItem(linkItemContext) return beacuse of entityIds is empty");
            return;
        }
        this.batchExecuteSync(linkItemContext);
        this.trackerContext.getOperateLog().endMothed(BFTRACKER_EXECUTE_LINK_ITEM, null);
    }

    private void batchExecuteSync(LinkItemContext linkItemContext) {
        ArrayList<BFTrackBatchExecuter> executers = new ArrayList<BFTrackBatchExecuter>(2);
        int batchCount = 1;
        BFTrackerBatchContext batchContext1 = new BFTrackerBatchContext(batchCount, null);
        BFTrackBatchExecuter batchExecuter1 = new BFTrackBatchExecuter(RequestContext.get(), this.trackerContext, this.trackerOpContext, linkItemContext, batchContext1, this.trackerResult, this.billTrackerHelper);
        batchExecuter1.setSyncExecute(true);
        executers.add(batchExecuter1);
        Set entryIds = linkItemContext.getNextPageEntryIds();
        while (!entryIds.isEmpty()) {
            BFTrackerBatchContext batchContext2 = new BFTrackerBatchContext(++batchCount, entryIds);
            BFTrackBatchExecuter batchExecuter2 = new BFTrackBatchExecuter(RequestContext.get(), this.trackerContext, this.trackerOpContext, linkItemContext, batchContext2, this.trackerResult, this.billTrackerHelper);
            batchExecuter2.setSyncExecute(true);
            executers.add(batchExecuter2);
            entryIds = linkItemContext.getNextPageEntryIds();
        }
        int finishBatchCount = 0;
        for (BFTrackBatchExecuter executer : executers) {
            BFTrackerBatchResult batchResult = executer.doActions();
            this.trackerContext.setProgressTip(String.format(ResManager.loadKDString((String)"\u5206\u6279\u53cd\u5199\uff0c\u5df2\u5b8c\u6210\u7b2c %1$s/%2$s \u6279", (String)"BFTracker_0", (String)"bos-mservice-botp", (Object[])new Object[0]), ++finishBatchCount, batchCount));
        }
    }

    private void batchExecuteAnsy(LinkItemContext linkItemContext) {
        ArrayList<Future> results = new ArrayList<Future>(10);
        int batchCount = 1;
        BFTrackerBatchContext batchContext1 = new BFTrackerBatchContext(batchCount, null);
        BFTrackBatchExecuter batchExecuter1 = new BFTrackBatchExecuter(RequestContext.get(), this.trackerContext, this.trackerOpContext, linkItemContext, batchContext1, this.trackerResult, this.billTrackerHelper);
        Future ret1 = threadPool.submit((Callable)batchExecuter1);
        results.add(ret1);
        Set entryIds = linkItemContext.getNextPageEntryIds();
        while (!entryIds.isEmpty()) {
            BFTrackerBatchContext batchContext2 = new BFTrackerBatchContext(++batchCount, entryIds);
            BFTrackBatchExecuter batchExecuter2 = new BFTrackBatchExecuter(RequestContext.get(), this.trackerContext, this.trackerOpContext, linkItemContext, batchContext2, this.trackerResult, this.billTrackerHelper);
            Future ret2 = threadPool.submit((Callable)batchExecuter2);
            results.add(ret2);
            entryIds = linkItemContext.getNextPageEntryIds();
        }
        int finishBatchCount = 0;
        ArrayList<BFTrackerBatchResult> realResults = new ArrayList<BFTrackerBatchResult>(results.size());
        for (Future result : results) {
            BFTrackerBatchResult batchResult = null;
            try {
                batchResult = (BFTrackerBatchResult)result.get();
            }
            catch (InterruptedException ex) {
                batchResult = new BFTrackerBatchResult();
                batchResult.setException((Throwable)ex);
            }
            catch (Throwable ex) {
                batchResult = new BFTrackerBatchResult();
                batchResult.setException(ex);
            }
            realResults.add(batchResult);
            this.trackerContext.setProgressTip(String.format(ResManager.loadKDString((String)"\u5206\u6279\u53cd\u5199\uff0c\u5df2\u5b8c\u6210\u7b2c %1$s/%2$s \u6279", (String)"BFTracker_0", (String)"bos-mservice-botp", (Object[])new Object[0]), ++finishBatchCount, batchCount));
        }
        for (BFTrackerBatchResult realResult : realResults) {
            if (realResult.getException() instanceof KDBizException) {
                throw new KDBizException(realResult.getException().getMessage());
            }
            if (realResult.getException() == null) continue;
            throw new KDException(realResult.getException(), BosErrorCode.executeBatch, new Object[]{realResult.getException().getMessage()});
        }
    }

    private void applyBillTracker(AED<BillTracker> aed) {
        ArrayList<BillTracker> billTrackers = new ArrayList<BillTracker>(aed.getAddList().size());
        for (BillTracker billTracker : aed.getAddList()) {
            long id = DBServiceHelper.genGlobalLongId();
            billTracker.setId(id);
            billTrackers.add(billTracker);
        }
        this.trackerResult.addNewBillTrackers(billTrackers);
        ArrayList<Long> delIds = new ArrayList<Long>(aed.getDeleteList().size());
        ArrayList<BillTracker> delBillTracker = new ArrayList<BillTracker>(aed.getDeleteList().size());
        for (BillTracker billTracker : aed.getDeleteList()) {
            delIds.add(billTracker.getId());
            delBillTracker.add(billTracker);
        }
        this.trackerResult.addDelBillTrackerIds(delIds);
        this.trackerResult.addDelBillTrackers(delBillTracker);
    }

    private boolean isAppendEntryRow() {
        boolean appendEntryRow = false;
        if (this.trackerContext.getOption() != null) {
            appendEntryRow = Boolean.parseBoolean(this.trackerContext.getOption().getVariableValue("bos_save_appendentryrows", String.valueOf(false)));
        }
        return appendEntryRow;
    }

    private boolean getCustomParamAppendEntryRow() {
        boolean checkParamFlag = true;
        ParameterReaderServiceImpl service = new ParameterReaderServiceImpl();
        HashSet<String> set = new HashSet<String>(1);
        set.add(CUSTOM_PARAM_KEY_APPEND_ENTRYROW);
        CustomParam customParam = new CustomParam(set);
        Map map = service.loadCustomParameterFromCache(customParam);
        if (map != null && map.get(CUSTOM_PARAM_KEY_APPEND_ENTRYROW) != null) {
            checkParamFlag = Boolean.parseBoolean((String)map.get(CUSTOM_PARAM_KEY_APPEND_ENTRYROW));
        }
        return checkParamFlag;
    }
}

