/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.track.helper;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.botp.track.BFTrackerContext;
import kd.bos.util.botp.CustomParamsUtil;

public class CheckRowsHandle {
    private static Log log = LogFactory.getLog(CheckRowsHandle.class);
    public static final int BOTP_WRITEBACK_MAX_NUM = 100000;

    public static void checkMoreThanRows(BFTrackerContext trackerContext, DynamicObject[] dataEntities) {
        if (CheckRowsHandle.isOff()) {
            return;
        }
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        ExtendedDataEntitySet extDataSet = new ExtendedDataEntitySet();
        extDataSet.Parse(dataEntities, (MainEntityType)trackerContext.getTargetSubMainType());
        for (LinkSetItemElement linkSetItem : trackerContext.getLinkSet().getItems()) {
            CheckRowsHandle.compareRows(linkSetItem, extDataSet);
        }
    }

    private static int getBillRows(LinkSetItemElement linkSetItem, ExtendedDataEntitySet extDataSet) {
        int rows = 0;
        try {
            ExtendedDataEntity[] extEntityRows = extDataSet.FindByEntityKey(linkSetItem.getLinkEntityKey());
            if (extEntityRows != null && extEntityRows.length > 0) {
                rows = extEntityRows.length;
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return rows;
    }

    private static void compareRows(LinkSetItemElement linkSetItem, ExtendedDataEntitySet extDataSet) {
        int maxNum;
        int rows = CheckRowsHandle.getBillRows(linkSetItem, extDataSet);
        if (rows > (maxNum = CheckRowsHandle.getMaxNum())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5904\u7406\u7684\u5173\u8054\u5206\u5f55\u884c(%1$s)\u884c\u8d85\u8fc7\u4e86\u7cfb\u7edf\u5904\u7406\u80fd\u529b(%2$s)\u884c\uff0c\u8bf7\u5206\u6279\u6267\u884c\u3002", (String)"CheckBillRowsAction_0", (String)"bos-mservice-botp", (Object[])new Object[0]), rows, maxNum));
        }
    }

    private static int getMaxNum() {
        int maxNum = 100000;
        String maxNumStr = CustomParamsUtil.getCustomParamsParamByKey((String)"KEY_BOTP_WRITEBACK_MAX_COUNT");
        if (StringUtils.isNotEmpty((CharSequence)maxNumStr) && StringUtils.isNumeric((CharSequence)maxNumStr)) {
            maxNum = Integer.parseInt(maxNumStr);
        }
        return maxNum;
    }

    private static boolean isOff() {
        boolean off = false;
        String offStr = CustomParamsUtil.getCustomParamsParamByKey((String)"KEY_BOTP_WRITEBACK_MAX_COUNT_OFF");
        try {
            off = Boolean.parseBoolean(offStr);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return off;
    }
}

