/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.mservice.attachment.AttachmentRemoveSource;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;

public class EntryGridAttachFieldPlugin
extends AbstractFormPlugin
implements IDataModelChangeListener {
    private static final String ATTFIELDKEY = "attachmentfield";
    private static final String BILL_ENTRY_PKID = "billentrypkid";
    private static final String IS_FROM_SUB_ENTRY = "isFromSubEntry";
    private static final String ISCHANGED = "isChanged";
    private static final String TABLENAME = "tableName";
    private static final String ATT_SUCCESS_STATUS = "B";
    private static final String ATT_SUCCESS = "success";

    public void beforeClosed(BeforeClosedEvent e) {
        if (this.hasAttachmentUploading()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9644\u4ef6\u4e0a\u4f20\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"Save_8", (String)"bos-entity-business", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        Boolean hasTimeoutAtt = Boolean.FALSE;
        StringBuilder timeoutMessage = new StringBuilder(ResManager.loadKDString((String)"\u4e34\u65f6\u9644\u4ef6\u5df2\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u4ee5\u4e0b\u6587\u4ef6:\r\n", (String)"TempAttTimeOutValidator_0", (String)"bos-mservice-operation", (Object[])new Object[0]));
        List timeOutAttList = AttachmentFieldServiceHelper.getTimeOutAttList((String)this.getView().getPageId());
        if (!CollectionUtils.isEmpty((Collection)timeOutAttList)) {
            for (DynamicObject attDynamicObj : timeOutAttList) {
                timeoutMessage.append(attDynamicObj.getLocaleString("name").getLocaleValue()).append("\r\n");
                hasTimeoutAtt = Boolean.TRUE;
            }
        }
        if (hasTimeoutAtt.booleanValue()) {
            this.getView().showConfirm(timeoutMessage.toString(), MessageBoxOptions.OK);
            e.setCancel(true);
            return;
        }
        ArrayList<Object> ids = new ArrayList<Object>();
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        int row = Integer.parseInt(pageCache.get("row"));
        String attachKey = pageCache.get("fieldKey");
        returnValue.put("k", attachKey);
        returnValue.put("r", row);
        returnValue.put("data", ids);
        returnValue.put("isSuccessDelAtt", pageCache.get("isSuccessDelAtt"));
        boolean isChanged = Boolean.parseBoolean(pageCache.get(ISCHANGED));
        returnValue.put(ISCHANGED, isChanged);
        DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)this.getModel().getValue(ATTFIELDKEY);
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String status = dynamicObject.getDynamicObject("fbasedataid").getString("status");
            if (!ATT_SUCCESS_STATUS.equals(status) && !ATT_SUCCESS.equals(status)) continue;
            ids.add(dynamicObject.get("fbasedataid_id"));
        }
        HashMap<String, Object> attachmentField = new HashMap<String, Object>();
        Object pkId = this.getView().getModel().getDataEntity().getPkValue();
        attachmentField.put("PageId", this.getView().getPageId());
        attachmentField.put("PkId", pkId);
        Object billNo = this.getView().getFormShowParameter().getCustomParam("billno");
        attachmentField.put("BillNo", billNo);
        AttachmentFieldServiceHelper.saveTempAttachments((String)SerializationUtils.toJsonString(attachmentField));
        this.getView().returnDataToParent(returnValue);
    }

    public void afterCreateNewData(EventObject e) {
        int maxAtmSize;
        Map cus = this.getView().getFormShowParameter().getCustomParams();
        boolean lock = Boolean.parseBoolean(cus.get("l") != null ? cus.get("l").toString() : "false");
        List data = (List)cus.get("v");
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        pageCache.put("row", cus.get("r").toString());
        pageCache.put("fieldKey", cus.get("k").toString());
        pageCache.put("tempAttPageId", cus.get("tempAttPageId").toString());
        pageCache.put("entityNum", String.valueOf(cus.get("entityNum")));
        pageCache.put("logEntityNum", String.valueOf(cus.get("logEntityNum")));
        pageCache.put(TABLENAME, StringUtils.isBlank(cus.get(TABLENAME)) ? "" : String.valueOf(cus.get(TABLENAME)));
        HashMap meta = new HashMap();
        if (!"0".equals(cus.get("maxAtmCount").toString())) {
            meta.put("maxatmcount", cus.get("maxAtmCount"));
        }
        if ((maxAtmSize = ((Integer)cus.get("maxAtmSize")).intValue()) != 0 && maxAtmSize != 20) {
            meta.put("maxatmsize", maxAtmSize);
        }
        meta.put("sct", Boolean.TRUE);
        meta.put("scd", Boolean.TRUE);
        meta.put("smk", Boolean.TRUE);
        if (StringUtils.isNotBlank(cus.get("extendName"))) {
            meta.put("ext", cus.get("extendName"));
        }
        meta.put("sortField", cus.get("sortField"));
        meta.put("sortType", cus.get("sortType"));
        meta.put("checkDuplicateFileName", cus.get("checkDuplicateFileName"));
        meta.put("dragAtm", cus.get("dragAtm"));
        meta.put("pKey", cus.get("k").toString());
        HashMap item = new HashMap();
        item.put("item", meta);
        this.getView().updateControlMetadata(ATTFIELDKEY, item);
        this.getModel().setValue(ATTFIELDKEY, (Object)data.toArray());
        this.getView().setEnable(Boolean.valueOf(!lock), new String[]{ATTFIELDKEY});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        this.getView().getPageCache().put(ISCHANGED, "true");
        if (Objects.isNull(e.getChangeSet())) {
            return;
        }
        ArrayList<Long> deleteIds = new ArrayList<Long>(10);
        for (ChangeData changeData : e.getChangeSet()) {
            DynamicObjectCollection oldValue = (DynamicObjectCollection)changeData.getOldValue();
            DynamicObjectCollection newValue = (DynamicObjectCollection)changeData.getNewValue();
            ArrayList<String> oldIds = new ArrayList<String>();
            ArrayList<String> newIds = new ArrayList<String>();
            for (DynamicObject dynamicObject : oldValue) {
                if (dynamicObject.get("fbasedataid_id") == null) continue;
                oldIds.add(dynamicObject.get("fbasedataid_id").toString());
            }
            for (DynamicObject dynamicObject : newValue) {
                if (dynamicObject.get("fbasedataid_id") == null) continue;
                newIds.add(dynamicObject.get("fbasedataid_id").toString());
            }
            oldIds.removeAll(newIds);
            for (Object e2 : oldIds) {
                deleteIds.add(Long.parseLong(e2.toString()));
            }
        }
        if (!deleteIds.isEmpty()) {
            String entityNum = this.getView().getPageCache().get("entityNum");
            String tableName = this.getView().getPageCache().get(TABLENAME);
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Object entryPkId = customParams.get(BILL_ENTRY_PKID);
            Boolean isFromSubEntry = Boolean.valueOf(String.valueOf(customParams.get(IS_FROM_SUB_ENTRY)));
            AttachmentRemoveSource removeSource = isFromSubEntry != false ? AttachmentRemoveSource.SUB_ENTRY : AttachmentRemoveSource.ENTRY;
            AttachmentFieldServiceHelper.batchRemoveAtt((String)entityNum, (String)tableName, (Object[])deleteIds.toArray(), (Object[])new Object[]{entryPkId}, (AttachmentRemoveSource)removeSource, (boolean)false);
        }
    }

    private boolean hasAttachmentUploading() {
        IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
        String uploadingAttJson = cache.get("UploadingAtt" + this.getView().getPageId());
        return StringUtils.isNotBlank((CharSequence)uploadingAttJson);
    }
}

