/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.actions;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.user.LoginUserService;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.SessionUtils;
import kd.bos.login.utils.URLUtils;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionManager;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.StringUtils;

public class SingleLoginAction {
    public static final String GLOBAL_COOKIE_ACCESS_TOKEN_KEY = "access_token";
    private static Log logger = LogFactory.getLog(SingleLoginAction.class);

    public void accessTokenLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String encode;
        Lang lang = LoginLangUtils.getLoginLanguage((HttpServletRequest)request);
        LoginLangUtils.setLang((Lang)lang);
        String redirectP = "redirect";
        String loginOrg = "loginOrg";
        String token = request.getParameter(GLOBAL_COOKIE_ACCESS_TOKEN_KEY);
        String redirect = request.getParameter("redirect");
        if (StringUtils.isEmpty((String)redirect)) {
            ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)ResManager.loadKDString((String)"\u7f3a\u5c11redirect\u53c2\u6570", (String)"SingleLoginAction_0", (String)"bos-login", (Object[])new Object[0]));
            return;
        }
        if (!LoginUtils.isSelfEnvironment(redirect, request)) {
            ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)ResManager.loadKDString((String)"redirect \u53c2\u6570\u4e0d\u7b26\u5408\u5b89\u5168\u8981\u6c42\u3002", (String)"SingleLoginAction_1", (String)"bos-login", (Object[])new Object[0]));
            return;
        }
        if (RequestContext.get() != null && "-1".equals(RequestContext.get().getGlobalSessionId())) {
            Account currentCenter = LoginAccountFactory.createInstanceByRequestContext(Optional.empty()).getAccount();
            Map<String, String> userInfo = this.getUserInfoFromContext();
            SessionUtils.createNewSession((HttpServletRequest)request, (HttpServletResponse)response, (Account)currentCenter, (Lang)lang, (String)NetAddressUtils.getRemoteHost((HttpServletRequest)request), userInfo, (LoginClientEnum)LoginClientEnum.WEB);
        }
        if ("true".equalsIgnoreCase(encode = request.getParameter("encode"))) {
            logger.error("warn#Need to adjust integration#");
            response.sendRedirect(redirect);
            return;
        }
        Enumeration enums = request.getParameterNames();
        StringBuilder sbBuilder = new StringBuilder();
        while (enums.hasMoreElements()) {
            String name = (String)enums.nextElement();
            if (name.equals(redirectP) || name.contains("ACCESS_TOKEN".toLowerCase()) || name.equals(loginOrg)) continue;
            sbBuilder.append("&").append(name).append("=");
            sbBuilder.append(URLEncoder.encode(request.getParameter(name), "UTF-8"));
        }
        if (request.getParameter(loginOrg) != null) {
            SessionManager.editLoginOrgSession((String)request.getParameter(loginOrg));
        }
        StringBuilder lastSB = new StringBuilder(redirect);
        lastSB.append((CharSequence)sbBuilder);
        logger.error("warn#Need to adjust integration#");
        response.sendRedirect(URLUtils.securityFilterRedirectUrl((String)lastSB.toString()));
    }

    private Map<String, String> getUserInfoFromContext() {
        HashMap<String, String> userInfo = new HashMap<String, String>();
        userInfo.put("forgid", String.valueOf(RequestContext.get().getOrgId()));
        userInfo.put("fid", RequestContext.get().getUserId());
        userInfo.put("ftruename", RequestContext.get().getUserName());
        userInfo.put("fopenid", RequestContext.get().getUserOpenId());
        userInfo.put("userType", RequestContext.get().getUserType());
        userInfo.put("fuid", RequestContext.get().getUid());
        return userInfo;
    }

    @Deprecated
    private static void createNewSession(HttpServletRequest request, HttpServletResponse response, Lang lang) {
        String sessionId = RequestContext.get().getGlobalSessionId();
        Account currentCenter = LoginAccountFactory.createInstanceByRequestContext(Optional.empty()).getAccount();
        Map sessionInfo = SessionUtils.getSessionInfo(null, (String)sessionId);
        Map userInfo = LoginUserService.getErpUserInfoByUserId((Account)currentCenter, (String)((String)sessionInfo.get("userId")), (String)lang.toString());
        SessionUtils.createNewSession((HttpServletRequest)request, (HttpServletResponse)response, (Account)currentCenter, (Lang)lang, (String)NetAddressUtils.getRemoteHost((HttpServletRequest)request), (Map)userInfo, (LoginClientEnum)LoginClientEnum.WEB, (int)SessionDAO.getSessionTimeout((String)currentCenter.getTenantId()), (boolean)true, (boolean)true);
    }
}

