/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.service.impl;

import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.login.CacheLoginData;
import kd.bos.login.service.ILoginUserService;
import kd.bos.login.service.dto.AppType;
import kd.bos.login.service.dto.BuildSecureUrlParam;
import kd.bos.login.service.dto.LoginUserDTO;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import kd.bos.util.RevProxyUtil;
import org.apache.commons.lang3.StringUtils;

public class LoginUserServiceImpl
implements ILoginUserService {
    private static final String BOS_USER = "bos_user";
    private static final String ACCOUNT_ID_PARAM = "accountId=";

    public boolean resetUserPassword(LoginUserDTO loginUserDTO) {
        if (ObjectUtils.isEmpty((Object)loginUserDTO) && ObjectUtils.isEmpty((Object)loginUserDTO.getUserId())) {
            return false;
        }
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)loginUserDTO.getUserId(), (String)BOS_USER);
        if (ObjectUtils.isEmpty((Object)user)) {
            return false;
        }
        user.set("password", (Object)loginUserDTO.getPassword());
        user.set("psweffectivedate", (Object)new Timestamp(new Date().getTime()));
        if (StringUtils.isNotBlank((CharSequence)loginUserDTO.getPasswordHis())) {
            user.set("pswhisstr", (Object)loginUserDTO.getPasswordHis());
        }
        user.set("islocked", (Object)"0");
        user.set("errcount", (Object)0);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{user});
        return true;
    }

    public boolean activeUser(Account currentCenter, LoginUserDTO loginUserDTO) {
        if (ObjectUtils.isEmpty((Object)loginUserDTO) && ObjectUtils.isEmpty((Object)loginUserDTO.getUserId())) {
            return false;
        }
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)loginUserDTO.getUserId(), (String)BOS_USER);
        if (ObjectUtils.isEmpty((Object)user)) {
            return false;
        }
        user.set("fuid", (Object)loginUserDTO.getUid());
        user.set("isactived", (Object)"1");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{user});
        return true;
    }

    public AppType getAppTypeFromSession(String sessionId) {
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)sessionId);
        String appType = sessionDAO.getAttribute("apptype");
        return AppType.fromTypeName((String)appType);
    }

    public String buildSecureGuestUrl(BuildSecureUrlParam params) {
        String code = "guest_" + kd.bos.util.StringUtils.randomWord((int)32);
        String url = params.getUrl();
        if (StringUtils.isBlank((CharSequence)url)) {
            return url;
        }
        StringBuilder addition = new StringBuilder();
        addition.append(url).append(RevProxyUtil.getHttpParamCollectFlag((String)url));
        addition.append("kd_auth_code").append("=").append(code);
        if (StringUtils.isNotEmpty((CharSequence)url) && !url.trim().contains(ACCOUNT_ID_PARAM)) {
            addition.append("&").append(ACCOUNT_ID_PARAM).append(RequestContext.get().getAccountId());
        }
        HashMap<String, String> map = new HashMap<String, String>(8);
        map.put("paramName", params.getParamName());
        map.put("paramValue", params.getParamValue());
        map.put("allowUseTimes", params.getAllowUseTimes() + "");
        long currentTimestamp = System.currentTimeMillis();
        long futureTimestamp = currentTimestamp + (long)(params.getExpireTime() * 1000);
        map.put("expireTimeStamp", futureTimestamp + "");
        CacheLoginData.setAttributes((String)"kd_auth_code_map", (String)code, map, (int)params.getExpireTime());
        return addition.toString();
    }
}

