/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.thirdapps;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dc.utils.MCDBUtil;
import kd.bos.dc.utils.SQLUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.thirdapps.BaseAuthInfo;
import kd.bos.login.thirdapps.Open3rdapps;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.StringUtils;

public class AppsService {
    private static Log logger = LogFactory.getLog(AppsService.class);
    private static final String AGENT_USER_ID = "fagentuserid";
    private static final String SATUS = "fstatus";
    private static final String BASE_SIGN_CODE = "fbasesigncode";
    private static final String THIRD_NUMBER = "fnumber";
    private static final String FID = "fid";
    private static final String AUTH_SQL = "select t.fid,fnumber,t.fagentuserid,t.fbasesigncode from t_open_3rdapps_basicauth t left join t_open_3rdapps p on t.fid=p.fid where t.fstatus='1' and p.fisbasicauth ='1' and  p.fenable='1' and t.fbasesigncode = ?";

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Open3rdapps> getAll3rdApps(Account currentCenter) {
        Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentCenter);
        if (dataBaseProperties == null) {
            throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBGetError()});
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<Open3rdapps> returnList = new ArrayList<Open3rdapps>();
        try {
            conn = MCDBUtil.getConnection((Account)currentCenter, (Properties)dataBaseProperties);
            String sql = "";
            sql = "select t.fid, t.fnumber,t.fstatus,t.fcreatorid,t.fmodifierid,t.fenable,t.fcreatetime,t.fmodifytime,t.fmasterid,t.fsyspwd,t.flastenabletime,t.flaststoptime,t.fpublickey,t.fwhitelist  from t_open_3rdapps t where  t.fenable='1' ";
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                Open3rdapps apps = new Open3rdapps();
                apps.setEnable(true);
                apps.setPkId(Long.valueOf(rs.getLong(FID)));
                apps.setNumber(rs.getString(THIRD_NUMBER));
                apps.setSyspwd(rs.getString("fsyspwd"));
                apps.setWhiteList(rs.getString("fwhitelist"));
                apps.setPulbicKey(rs.getString("fpublickey"));
                apps.setEncryptedKey(rs.getString("fpublickey"));
                returnList.add(apps);
            }
        }
        catch (SQLException e) {
            try {
                throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + LoginUtils.SPLIT_SIGN + e.getMessage()});
                catch (Exception e2) {
                    throw new KDException((Throwable)e2, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + LoginUtils.SPLIT_SIGN + e2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return returnList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Open3rdapps getThirdApps(Account currentCenter, Long appPkId) {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection conn;
        block5: {
            Open3rdapps open3rdapps;
            Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentCenter);
            conn = null;
            pstmt = null;
            rs = null;
            try {
                conn = MCDBUtil.getConnection((Account)currentCenter, (Properties)dataBaseProperties);
                String sql = "select t.fid, t.fnumber,t.fstatus,t.fcreatorid,t.fmodifierid,t.fenable,t.fcreatetime,t.fmodifytime,t.fmasterid,t.fsyspwd,t.flastenabletime,t.flaststoptime,t.fpublickey,t.fwhitelist  from t_open_3rdapps t where  t.fid = ? ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setLong(1, appPkId);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block5;
                Open3rdapps apps = new Open3rdapps();
                apps.setEnable(true);
                apps.setPkId(Long.valueOf(rs.getLong(FID)));
                apps.setNumber(rs.getString(THIRD_NUMBER));
                apps.setSyspwd(rs.getString("fsyspwd"));
                apps.setWhiteList(rs.getString("fwhitelist"));
                apps.setPulbicKey(rs.getString("fpublickey"));
                apps.setEncryptedKey(rs.getString("fpublickey"));
                apps.setEnable(StringUtils.getBooleanValue((String)rs.getString("fenable")));
                open3rdapps = apps;
            }
            catch (SQLException e) {
                try {
                    throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + LoginUtils.SPLIT_SIGN + e.getMessage()});
                    catch (Exception e2) {
                        throw new KDException((Throwable)e2, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + LoginUtils.SPLIT_SIGN + e2.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
            return open3rdapps;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return null;
    }

    public static BaseAuthInfo getBasicAuthInfo(Account currentCenter, String baseSignCode) {
        BaseAuthInfo baseAuthInfo;
        Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentCenter);
        BaseAuthInfo baseAuthInfo2 = null;
        if (StringUtils.isEmpty((String)baseSignCode)) {
            return baseAuthInfo2;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = MCDBUtil.getConnection((Account)currentCenter, (Properties)dataBaseProperties);
            pstmt = conn.prepareStatement(AUTH_SQL);
            pstmt.setString(1, baseSignCode);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                baseAuthInfo2 = new BaseAuthInfo();
                baseAuthInfo2.setAgentUserId(rs.getLong(AGENT_USER_ID) != 0L ? Long.valueOf(rs.getLong(AGENT_USER_ID)) : null);
                baseAuthInfo2.setThirdId(Long.valueOf(rs.getLong(FID)));
                baseAuthInfo2.setSignCode(rs.getString(BASE_SIGN_CODE));
                baseAuthInfo2.setThirdNumber(rs.getString(THIRD_NUMBER));
            }
            baseAuthInfo = baseAuthInfo2;
        }
        catch (Exception var15) {
            try {
                throw new KDException((Throwable)var15, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + LoginUtils.SPLIT_SIGN + var15.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return baseAuthInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkUserPermByAppId(Account currentCenter, long api3rdAppId, String userId) {
        boolean bl;
        ResultSet rs;
        PreparedStatement pstmt;
        Connection conn;
        block5: {
            Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentCenter);
            conn = null;
            pstmt = null;
            rs = null;
            conn = MCDBUtil.getConnection((Account)currentCenter, (Properties)dataBaseProperties);
            String sql = "select fid from t_open_3rdapps_agency where fid in(select fid from t_open_3rdapps a  where fisagencyuser = '1' and fid = ?) and fbasedataid = ? ";
            pstmt = conn.prepareStatement(sql);
            pstmt.setLong(1, api3rdAppId);
            pstmt.setLong(2, Long.parseLong(userId));
            rs = pstmt.executeQuery();
            if (!rs.next()) break block5;
            boolean bl2 = true;
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
            return bl2;
        }
        try {
            bl = false;
        }
        catch (Exception var15) {
            boolean bl3;
            try {
                logger.info("AppsService#checkUserPermByAppId", (Object)var15);
                bl3 = true;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)conn);
            return bl3;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return bl;
    }
}

