/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.thirdauth.app.feishu;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kd.bos.dc.api.model.Account;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.thirdauth.app.AppAuthResult;
import kd.bos.login.thirdauth.app.ThirdAppAuthtication;
import kd.bos.login.thirdauth.app.UserType;
import kd.bos.login.thirdauth.app.feishu.FeiShuErrorMsg;
import kd.bos.login.thirdauth.app.feishu.FeiShuUtils;
import kd.bos.login.utils.JSONUtils;
import kd.bos.login.utils.ParametersUtils;
import kd.bos.login.utils.log.ThirdAppLogInfo;
import kd.bos.login.utils.log.ThirdAppLogUtils;
import kd.bos.util.StringUtils;

public class FeiShuAuthtication
extends ThirdAppAuthtication {
    private static Log logger = LogFactory.getLog(FeiShuAuthtication.class);

    public boolean isNeedHandle(HttpServletRequest request, Account currentCenter) {
        String app_type = request.getParameter("apptype");
        String code = request.getParameter("code");
        return "feishu".equalsIgnoreCase(app_type);
    }

    public AppAuthResult appAuthtication(HttpServletRequest request, Account currentCenter) {
        AppAuthResult result = new AppAuthResult();
        result.setSucceed(false);
        String appId = "";
        try {
            String appAccessToken;
            String code = request.getParameter("code");
            if (StringUtils.isEmpty((String)code)) {
                throw new KDException(new ErrorCode("FeiShuErrorMsg_2", FeiShuErrorMsg.getCodeMsg((String)"FeiShuErrorMsg_2")), new Object[0]);
            }
            HashMap<String, String> parameters = ParametersUtils.getCommonParameters((Account)currentCenter);
            if (null == parameters) {
                logger.info("getCommonParameters is null");
                parameters = new HashMap<String, String>();
            }
            if (null == parameters.get("feishu_api_url") || "".equals(parameters.get("feishu_api_url"))) {
                parameters.put("feishu_api_url", FeiShuUtils.getFlyUrl((Account)currentCenter));
            }
            if (StringUtils.isNotEmpty((String)(appId = request.getParameter("flyBookAppId")))) {
                parameters.put("flyBookAppId", appId);
            }
            if (StringUtils.isEmpty((String)(appAccessToken = FeiShuUtils.getAppAccessTokenWithException(parameters, (Account)currentCenter)))) {
                throw new KDException(new ErrorCode("FeiShuErrorMsg_7", FeiShuErrorMsg.getCodeMsg((String)"FeiShuErrorMsg_7")), new Object[0]);
            }
            Map authUserInfo = FeiShuUtils.getAuthUserInfoWithException(parameters, (String)appAccessToken, (String)code);
            if (authUserInfo == null || authUserInfo.size() <= 0) {
                throw new KDException(new ErrorCode("FeiShuErrorMsg_6", FeiShuErrorMsg.getCodeMsg((String)"FeiShuErrorMsg_6")), new Object[0]);
            }
            if ("0".equals(authUserInfo.get("code").toString())) {
                Map data = (Map)JSONUtils.cast((String)authUserInfo.get("data").toString(), HashMap.class);
                Object mobile = data.get("mobile");
                if (null != mobile && !"".equals(mobile)) {
                    result.setUserType(UserType.MOBILE_PHONE);
                    result.setSucceed(true);
                    result.setUserFlag(FeiShuUtils.getMobile((String)mobile.toString()));
                } else {
                    throw new KDException(new ErrorCode("FeiShuErrorMsg_8", FeiShuErrorMsg.getCodeMsg((String)"FeiShuErrorMsg_8")), new Object[0]);
                }
            }
            result.setAppType(request.getParameter("apptype"));
        }
        catch (KDException kde) {
            ErrorCode errorCode = kde.getErrorCode();
            String resourceId = errorCode != null ? errorCode.getCode() : "";
            boolean codeExist = StringUtils.isNotEmpty((String)FeiShuErrorMsg.getCodeMsg((String)resourceId));
            String kdeMessage = kde.getMessage();
            result.setErrorMessage(kdeMessage);
            if (kdeMessage != null && kdeMessage.contains("code=20003")) {
                return result;
            }
            ThirdAppLogInfo thirdAppLogInfo = ThirdAppLogUtils.wrapThirdAppLogInfo((KDException)kde, (HttpServletRequest)request, (boolean)codeExist);
            thirdAppLogInfo.setThirdType(Long.valueOf(6L));
            thirdAppLogInfo.setCorpid("");
            thirdAppLogInfo.setAgentid(appId);
            ThirdAppLogUtils.addLog((ThirdAppLogInfo)thirdAppLogInfo);
        }
        catch (Exception e) {
            logger.info("appAuthtication error", (Object)e);
            result.setErrorMessage(e.getMessage());
        }
        return result;
    }
}

