/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.thirdauth.app.tencent;

import com.alibaba.fastjson.JSON;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import kd.bos.api.ApiRequestContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dc.utils.MCDBUtil;
import kd.bos.dc.utils.SQLUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.login.model.ThirdAuthApp;
import kd.bos.login.service.ThirdAppService;
import kd.bos.login.thirdauth.app.AppAuthResult;
import kd.bos.login.thirdauth.app.UserType;
import kd.bos.login.thirdauth.app.sky.SkyUtils;
import kd.bos.login.thirdauth.app.tencent.CorpObj;
import kd.bos.login.thirdauth.app.tencent.WxqyErrorMsg;
import kd.bos.login.thirdauth.app.tencent.wechat.WXBizMsgCrypt;
import kd.bos.login.thirdauth.app.tencent.wechat.XMLParse;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.bos.login.utils.JSONUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.ParametersUtils;
import kd.bos.login.utils.SystemPropertyUtils;
import kd.bos.util.HttpClientUtils;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WxqyhUtils {
    private static final String WEIXIN_TICKET = "weixinTicket";
    private static final String ERRCODE = "errcode";
    private static final String ERRMSG = "errmsg";
    private static final String LOGGER_ERROR_ACCESS_TOKEN_IS_NULL = "error ::: access_token is null !";
    private static Log logger = LogFactory.getLog(WxqyhUtils.class);
    private static HashMap<String, String> access_token_Map = new HashMap();
    private static HashMap<String, Long> access_token_expires_Map = new HashMap();
    private static HashMap<String, Long> access_token_time_Map = new HashMap();
    private static Object lockObj = new Object();
    private static final String QYWX_HOST = "qywxhost";
    private static final String BOS_LOGIN = "bos-login";

    @Deprecated
    public static String getAccess_token(String corpid, String corpSecret) {
        return WxqyhUtils.getAccess_token(corpid, corpSecret, null);
    }

    public static String getAccess_token(String corpid, String corpSecret, Account account) {
        try {
            return WxqyhUtils.getAccessTokenWithException(corpid, corpSecret, account);
        }
        catch (Exception e) {
            logger.info("getAccess_token error", (Object)e);
            return null;
        }
    }

    public static String getAccessTokenWithException(String corpid, String corpSecret, Account account) throws Exception {
        if (null == corpid || corpid.trim().isEmpty()) {
            throw new KDException(new ErrorCode("WxqyErrorMsg_1", WxqyErrorMsg.getCodeMsg((String)"WxqyErrorMsg_1")), new Object[0]);
        }
        if (null == corpSecret || corpSecret.trim().isEmpty()) {
            throw new KDException(new ErrorCode("WxqyErrorMsg_2", WxqyErrorMsg.getCodeMsg((String)"WxqyErrorMsg_2")), new Object[0]);
        }
        long current_time = System.currentTimeMillis();
        String key = corpid + corpSecret;
        String access_token = access_token_Map.get(key);
        Long access_token_expires = access_token_expires_Map.get(key);
        Long access_token_time = access_token_time_Map.get(key);
        if (null != access_token && current_time - access_token_time < access_token_expires * 1000L - 30L) {
            logger.debug("from cache get access_token  ");
            return access_token_Map.get(key);
        }
        Object object = lockObj;
        synchronized (object) {
            current_time = System.currentTimeMillis();
            if (null != access_token_Map.get(key) && current_time - access_token_time_Map.get(key) < access_token_expires_Map.get(key) - 30L) {
                logger.debug("from cache get access_token 2 ");
                return access_token_Map.get(key);
            }
            logger.debug("get access_token from wx ");
            StringBuilder access_token_url = new StringBuilder(WxqyhUtils.getHost(account)).append("cgi-bin/gettoken?corpid=");
            access_token_url.append(corpid).append("&corpsecret=").append(corpSecret);
            HashMap map = null;
            String data = "";
            try {
                data = HttpClientUtils.get((String)access_token_url.toString());
                map = (HashMap)JSON.parseObject((String)data, HashMap.class);
            }
            catch (Exception e) {
                logger.info("getToken error", (Object)e);
                if (e.getMessage().contains("timed out")) {
                    throw new KDException(new ErrorCode("WxqyErrorMsg_10", WxqyErrorMsg.getCodeMsg((String)"WxqyErrorMsg_10")), new Object[0]);
                }
                throw new KDException(new ErrorCode("WxqyErrorMsg_11", WxqyErrorMsg.getCodeMsg((String)"WxqyErrorMsg_11")), new Object[0]);
            }
            if (map == null) {
                throw new KDException(new ErrorCode("WxqyErrorMsg_5", WxqyErrorMsg.getCodeMsg((String)"WxqyErrorMsg_5")), new Object[0]);
            }
            if ("0".equals(map.get(ERRCODE).toString())) {
                access_token_Map.put(key, map.get("access_token").toString());
                access_token_expires_Map.put(key, Long.valueOf(map.get("expires_in").toString()));
                access_token_time_Map.put(key, System.currentTimeMillis());
                return map.get("access_token").toString();
            }
            throw new KDException(new ErrorCode("WxqyErrorMsg_12", WxqyErrorMsg.getCodeMsg((String)"WxqyErrorMsg_12")), new Object[]{data});
        }
    }

    @Deprecated
    public static String getUserIdByMicroWx(String access_token, String code) {
        if (null == code || code.trim().isEmpty()) {
            return null;
        }
        if (null == access_token || access_token.trim().isEmpty()) {
            return null;
        }
        return WxqyhUtils.getUserIdMicroParams(access_token, code, null);
    }

    public static String getUserIdByMicroWx(String access_token, String code, Account account) {
        try {
            return WxqyhUtils.getUserIdByMicroWxWithException(access_token, code, account);
        }
        catch (Exception e) {
            logger.info("getUserIdByMicroWx error", (Object)e);
            return null;
        }
    }

    public static String getUserIdByMicroWxWithException(String access_token, String code, Account account) throws Exception {
        if (null == code || code.trim().isEmpty()) {
            return null;
        }
        if (null == access_token || access_token.trim().isEmpty()) {
            return null;
        }
        return WxqyhUtils.getUserIdMicroParams(access_token, code, account);
    }

    private static String getUserIdMicroParams(String access_token, String code, Account account) {
        StringBuilder getUserId_url = new StringBuilder(WxqyhUtils.getHost(account)).append("cgi-bin/miniprogram/jscode2session?access_token=");
        getUserId_url.append(access_token).append("&js_code=").append(code).append("&grant_type=authorization_code");
        HashMap map = null;
        String data = "";
        try {
            data = HttpClientUtils.get((String)getUserId_url.toString());
            map = (HashMap)JSON.parseObject((String)data, HashMap.class);
        }
        catch (Exception e) {
            logger.info("getUserIdMicroParams error", (Object)e);
            throw new KDException(new ErrorCode("10006", e.getMessage()), new Object[0]);
        }
        if (map == null) {
            return null;
        }
        if (((String)map.get(ERRCODE)).equals("0")) {
            logger.info("wxqyh jscode2session corpid: " + (String)map.get("corpid"));
            return (String)map.get("userid");
        }
        if (!data.contains("\"errcode\":40029") && !data.contains("\"errcode\":42022")) {
            throw new KDException(new ErrorCode("error msg", String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u7528\u6237ID\u5931\u8d25\uff0c\u8be6\u60c5\uff1a%s", (String)"WxqyhUtils_2", (String)BOS_LOGIN, (Object[])new Object[0]), data)), new Object[0]);
        }
        return null;
    }

    private static String getHost(Account account) {
        String qywxhHost = null == account ? WxqyhUtils.getQywxhHost() : WxqyhUtils.getQywxhHost(account);
        return qywxhHost;
    }

    @Deprecated
    public static String getUserId(String access_token, String code) {
        if (null == code || code.trim().isEmpty()) {
            return null;
        }
        if (null == access_token || access_token.trim().isEmpty()) {
            return null;
        }
        return WxqyhUtils.getUserIdParams(code, access_token, null);
    }

    public static String getUserId(String access_token, String code, Account account) {
        if (null == code || code.trim().isEmpty()) {
            return null;
        }
        if (null == access_token || access_token.trim().isEmpty()) {
            return null;
        }
        return WxqyhUtils.getUserIdParams(code, access_token, account);
    }

    private static String getUserIdParams(String code, String access_token, Account account) {
        StringBuilder getUserId_url = new StringBuilder(WxqyhUtils.getHost(account)).append("cgi-bin/user/getuserinfo?access_token=");
        getUserId_url.append(access_token).append("&code=").append(code);
        HashMap map = null;
        try {
            String data = HttpClientUtils.get((String)getUserId_url.toString());
            map = (HashMap)JSON.parseObject((String)data, HashMap.class);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        if (map == null) {
            return null;
        }
        if ("0".equals(String.valueOf(map.get(ERRCODE))) || "0".equals(map.get(ERRCODE).toString())) {
            if (null != map.get("UserId")) {
                return map.get("UserId").toString();
            }
            return null;
        }
        logger.info("WxqyhUtils.errmsg\uff1a" + map.get(ERRMSG));
        return null;
    }

    @Deprecated
    public static HashMap<String, Object> getUserInfo(String access_token, String userId) {
        if (null == userId || userId.trim().isEmpty()) {
            return null;
        }
        if (null == access_token || access_token.trim().isEmpty()) {
            return null;
        }
        try {
            return WxqyhUtils.getUserInfoParams(access_token, userId, null);
        }
        catch (Exception e) {
            logger.info("getUserInfo error", (Object)e);
            return null;
        }
    }

    public static HashMap<String, Object> getUserInfo(String access_token, String userId, Account account) {
        try {
            return WxqyhUtils.getUserInfoWithException(access_token, userId, account);
        }
        catch (Exception e) {
            logger.info("getUserInfo error", (Object)e);
            return null;
        }
    }

    public static HashMap<String, Object> getUserInfoWithException(String access_token, String userId, Account account) throws Exception {
        if (null == userId || userId.trim().isEmpty()) {
            return null;
        }
        if (null == access_token || access_token.trim().isEmpty()) {
            return null;
        }
        return WxqyhUtils.getUserInfoParams(access_token, userId, account);
    }

    private static HashMap<String, Object> getUserInfoParams(String access_token, String userId, Account account) throws Exception {
        StringBuilder getUserInfo_url = new StringBuilder(WxqyhUtils.getHost(account)).append("cgi-bin/user/get?access_token=");
        getUserInfo_url.append(access_token).append("&userid=").append(userId);
        HashMap map = null;
        try {
            String data = HttpClientUtils.get((String)getUserInfo_url.toString());
            map = (HashMap)JSON.parseObject((String)data, HashMap.class);
        }
        catch (Exception e) {
            if (e.getMessage().contains("timed out")) {
                throw new KDException(new ErrorCode("WxqyErrorMsg_13", WxqyErrorMsg.getCodeMsg((String)"WxqyErrorMsg_13")), new Object[0]);
            }
            throw e;
        }
        return map;
    }

    @Deprecated
    public static String getWeixinTicket(String accessToken) {
        String ticket = null;
        if (kd.bos.login.utils.StringUtils.isNotEmpty((String)accessToken)) {
            ticket = CacheLoginData.getAttribute((String)WEIXIN_TICKET, (String)accessToken);
            if (kd.bos.util.StringUtils.isNotEmpty((String)ticket)) {
                return ticket;
            }
            StringBuilder access_token_url = new StringBuilder(WxqyhUtils.getQywxhHost()).append("cgi-bin/get_jsapi_ticket?access_token=");
            access_token_url.append(accessToken);
            HashMap map = null;
            try {
                String data = HttpClientUtils.get((String)access_token_url.toString());
                map = (HashMap)JSON.parseObject((String)data, HashMap.class);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
            if (map == null) {
                return null;
            }
            if ("0".equals(map.get(ERRCODE).toString())) {
                ticket = kd.bos.login.utils.StringUtils.getStringValue(map.get("ticket"));
                String expiresIn = kd.bos.util.StringUtils.isNotEmpty((String)map.get("expires_in").toString()) ? map.get("expires_in").toString() : "0";
                CacheLoginData.setAttribute((String)WEIXIN_TICKET, (String)accessToken, (String)ticket, (int)(Integer.parseInt(expiresIn) - 1800));
            } else {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{map.get(ERRMSG).toString()});
            }
        }
        return ticket;
    }

    public static String getWeixinTicket(String accessToken, Account account) {
        String ticket = null;
        if (kd.bos.login.utils.StringUtils.isNotEmpty((String)accessToken)) {
            ticket = CacheLoginData.getAttribute((String)WEIXIN_TICKET, (String)accessToken);
            if (kd.bos.util.StringUtils.isNotEmpty((String)ticket)) {
                return ticket;
            }
            StringBuilder access_token_url = new StringBuilder(WxqyhUtils.getHost(account)).append("cgi-bin/get_jsapi_ticket?access_token=");
            access_token_url.append(accessToken);
            HashMap map = null;
            try {
                String data = HttpClientUtils.get((String)access_token_url.toString());
                map = (HashMap)JSON.parseObject((String)data, HashMap.class);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
            if (map == null) {
                return null;
            }
            if ("0".equals(map.get(ERRCODE).toString())) {
                ticket = kd.bos.login.utils.StringUtils.getStringValue(map.get("ticket"));
                String expiresIn = kd.bos.util.StringUtils.isNotEmpty((String)map.get("expires_in").toString()) ? map.get("expires_in").toString() : "0";
                CacheLoginData.setAttribute((String)WEIXIN_TICKET, (String)accessToken, (String)ticket, (int)(Integer.parseInt(expiresIn) - 1800));
            } else {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{map.get(ERRMSG).toString()});
            }
        }
        return ticket;
    }

    public static CorpObj getCorpSecret(Account currentCenter) {
        Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentCenter);
        if (dataBaseProperties == null) {
            throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBGetError()});
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        CorpObj corpObj = null;
        try {
            conn = MCDBUtil.getConnection((Account)currentCenter, (Properties)dataBaseProperties);
            String sql = "select fcorpsecret,fcorpid  from t_bas_wxqyh ";
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                corpObj = new CorpObj();
                corpObj.setCorpId(rs.getString("fcorpid"));
                corpObj.setCorpSecret(rs.getString("fcorpsecret"));
            }
        }
        catch (Exception e) {
            try {
                throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + e.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return corpObj;
    }

    public static String getWxWorkOPHost() {
        String host = "https://open.work.weixin.qq.com/";
        RequestContext rc = RequestContext.get();
        String hostString = SystemPropertyUtils.getProptyByTenant((String)"qywxh_open_host", (String)(rc != null ? rc.getTenantId() : null));
        if (kd.bos.login.utils.StringUtils.isNotEmpty((String)hostString)) {
            host = hostString;
        }
        logger.info("qywxh_open_host:" + host);
        return host;
    }

    @Deprecated
    public static String getQywxhHost() {
        String host = "https://qyapi.weixin.qq.com/";
        RequestContext rc = RequestContext.get();
        String hostString = SystemPropertyUtils.getProptyByTenant((String)"qywxh_host", (String)(rc != null ? rc.getTenantId() : null));
        if (kd.bos.login.utils.StringUtils.isNotEmpty((String)hostString)) {
            host = hostString;
        }
        logger.info("qywxh_host:" + host);
        return host;
    }

    @Deprecated
    public static Map<String, Object> getUserByCode(String access_token, String code) {
        if (null == code || code.trim().isEmpty()) {
            return null;
        }
        if (null == access_token || access_token.trim().isEmpty()) {
            return null;
        }
        StringBuilder getUserId_url = new StringBuilder(WxqyhUtils.getQywxhHost()).append("cgi-bin/user/getuserinfo?access_token=");
        getUserId_url.append(access_token).append("&code=").append(code);
        HashMap map = null;
        try {
            String data = HttpClientUtils.get((String)getUserId_url.toString());
            logger.info("WxqyhUtils\u4f01\u4e1a\u5fae\u4fe1\u8bf7\u6c42\u8fd4\u56de\u503c\uff1a" + data);
            map = (HashMap)JSON.parseObject((String)data, HashMap.class);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return map;
    }

    public static Map<String, Object> getUserByCode(String access_token, String code, Account account) {
        try {
            return WxqyhUtils.getUserByCodeWithException(access_token, code, account);
        }
        catch (Exception e) {
            logger.info("getUserByCode error", (Object)e);
            return null;
        }
    }

    public static Map<String, Object> getUserByCodeWithException(String access_token, String code, Account account) throws Exception {
        if (null == code || code.trim().isEmpty()) {
            return null;
        }
        if (null == access_token || access_token.trim().isEmpty()) {
            return null;
        }
        StringBuilder getUserId_url = new StringBuilder(WxqyhUtils.getHost(account)).append("cgi-bin/user/getuserinfo?access_token=");
        getUserId_url.append(access_token).append("&code=").append(code);
        HashMap map = null;
        try {
            String data = HttpClientUtils.get((String)getUserId_url.toString());
            logger.info("WxqyhUtils\u4f01\u4e1a\u5fae\u4fe1\u8bf7\u6c42\u8fd4\u56de\u503c\uff1a" + data);
            map = (HashMap)JSON.parseObject((String)data, HashMap.class);
        }
        catch (Exception e) {
            if (e.getMessage().contains("timed out")) {
                throw new KDException(new ErrorCode("WxqyErrorMsg_13", WxqyErrorMsg.getCodeMsg((String)"WxqyErrorMsg_13")), new Object[0]);
            }
            logger.info("WxqyhUtils.getUserByCodeWithException#", (Object)e);
        }
        return map;
    }

    public static String getUserId(Map<String, Object> map) {
        try {
            return WxqyhUtils.getUserIdWithException(map);
        }
        catch (Exception e) {
            logger.info("getUserId error", (Object)e);
            return null;
        }
    }

    public static String getUserIdWithException(Map<String, Object> map) throws Exception {
        if (map == null) {
            return null;
        }
        String errCode = String.valueOf(map.get(ERRCODE));
        if ("0".equals(errCode)) {
            if (null != map.get("UserId")) {
                return map.get("UserId").toString();
            }
            return null;
        }
        String msg = "";
        String resourceid = "";
        if ("60020".equals(errCode)) {
            msg = WxqyErrorMsg.getCodeMsg((String)"WxqyErrorMsg_17");
            resourceid = "WxqyErrorMsg_17";
        } else if ("40013".equals(errCode)) {
            msg = WxqyErrorMsg.getCodeMsg((String)"WxqyErrorMsg_14");
            resourceid = "WxqyErrorMsg_14";
        } else if ("40001".equals(errCode)) {
            msg = WxqyErrorMsg.getCodeMsg((String)"WxqyErrorMsg_15");
            resourceid = "WxqyErrorMsg_15";
        } else {
            msg = WxqyErrorMsg.getCodeMsg((String)"WxqyErrorMsg_16");
            resourceid = "WxqyErrorMsg_16";
        }
        logger.info("WxqyhUtils.errmsg\uff1a" + map.get(ERRMSG));
        throw new KDException(new ErrorCode(resourceid, msg), new Object[]{JSONUtils.toString(map)});
    }

    public static String getUserTicket(Map<String, Object> map) {
        try {
            return WxqyhUtils.getUserTicketWithException(map);
        }
        catch (Exception e) {
            logger.info("getUserTicket error", (Object)e);
            return null;
        }
    }

    public static String getUserTicketWithException(Map<String, Object> map) throws Exception {
        if (map == null) {
            return null;
        }
        if ("0".equals(String.valueOf(map.get(ERRCODE)))) {
            if (null != map.get("user_ticket")) {
                return map.get("user_ticket").toString();
            }
            return null;
        }
        logger.info("WxqyhUtils.errmsg\uff1a" + map.get(ERRMSG));
        throw new KDException(new ErrorCode("WxqyErrorMsg_18", WxqyErrorMsg.getCodeMsg((String)"WxqyErrorMsg_18")), new Object[]{JSONUtils.toString(map)});
    }

    public static String getUserInfoByTicket(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        if ("0".equals(String.valueOf(map.get(ERRCODE)))) {
            if (null != map.get("user_ticket")) {
                return map.get("user_ticket").toString();
            }
            return null;
        }
        logger.info("WxqyhUtils.errmsg\uff1a" + map.get(ERRMSG));
        return null;
    }

    @Deprecated
    public static HashMap<String, Object> getUserInfoByTicket(String accessToken, String userTicket) {
        try {
            return WxqyhUtils.getUserInfoByTicketWithException(accessToken, userTicket);
        }
        catch (Exception e) {
            logger.info("getUserInfoByTicket error", (Object)e);
            return null;
        }
    }

    public static HashMap<String, Object> getUserInfoByTicketWithException(String accessToken, String userTicket) throws Exception {
        StringBuilder getUserInfo_url = new StringBuilder(WxqyhUtils.getQywxhHost(AccountUtils.getAccountById((String)RequestContext.get().getAccountId()))).append("cgi-bin/user/getuserdetail?access_token=");
        getUserInfo_url.append(accessToken);
        HashMap map = null;
        String data = "";
        try {
            HashMap header = new HashMap(8);
            HashMap<String, String> body = new HashMap<String, String>(16);
            body.put("user_ticket", userTicket);
            data = HttpClientUtils.postjson((String)getUserInfo_url.toString(), header, (String)JSONUtils.toString(body));
            map = (HashMap)JSON.parseObject((String)data, HashMap.class);
        }
        catch (Exception e) {
            if (e.getMessage().contains("timed out")) {
                throw new KDException(new ErrorCode("WxqyErrorMsg_19", WxqyErrorMsg.getCodeMsg((String)"WxqyErrorMsg_19")), new Object[0]);
            }
            throw e;
        }
        if (map != null && "0".equals(map.get(ERRCODE).toString())) {
            return map;
        }
        if (map != null) {
            throw new KDException(new ErrorCode("WxqyErrorMsg_20", WxqyErrorMsg.getCodeMsg((String)"WxqyErrorMsg_20")), new Object[]{data});
        }
        return null;
    }

    public static String dealWechatPushData(WXBizMsgCrypt wxcpt, String msgSig, String verifyTimeStamp, String verifyNonce) {
        String result = "error";
        ApiRequestContext ctx = ApiRequestContext.get();
        String bodyData = ctx.getPostData();
        try {
            if (StringUtils.isNotEmpty((String)bodyData)) {
                String infoType;
                String msg = wxcpt.DecryptMsg(msgSig, verifyTimeStamp, verifyNonce, bodyData);
                Element root = XMLParse.getDocumentElement((String)msg);
                NodeList nodelist = root.getElementsByTagName("InfoType");
                switch (infoType = nodelist.item(0).getTextContent()) {
                    case "create_auth": {
                        NodeList authCodeNode = root.getElementsByTagName("AuthCode");
                        String authCode = authCodeNode.item(0).getTextContent();
                        break;
                    }
                    case "suite_ticket": {
                        break;
                    }
                }
                result = "success";
            }
        }
        catch (Exception e) {
            logger.info("verifyurl: " + e);
        }
        return result;
    }

    public static String verifyURL(WXBizMsgCrypt wxcpt, String msgSig, String verifyTimeStamp, String verifyNonce, String verifyEchoStr) {
        String echoStr = "error";
        try {
            echoStr = wxcpt.VerifyURL(msgSig, verifyTimeStamp, verifyNonce, verifyEchoStr);
            logger.info("verifyurl echostr: " + echoStr);
        }
        catch (Exception e) {
            logger.info("verifyurl echostr: " + e);
        }
        return echoStr;
    }

    public static String getQywxhHost(Account currentCenter) {
        String host = "https://qyapi.weixin.qq.com/";
        Map parameters = ParametersUtils.getCommonParameters((Account)currentCenter);
        if (null == parameters) {
            return WxqyhUtils.getQywxhHost();
        }
        host = null != parameters.get(QYWX_HOST) && !"".equals(parameters.get(QYWX_HOST)) ? String.valueOf(parameters.get(QYWX_HOST)) : WxqyhUtils.getQywxhHost();
        String qiwxHost = LoginUtils.getPathString(host);
        logger.info("qywxh_host:" + qiwxHost);
        return qiwxHost;
    }

    public static AppAuthResult appAuthtication(HttpServletRequest request, Account currentCenter, String code, String corpId) {
        AppAuthResult result = new AppAuthResult();
        result.setSucceed(false);
        String corpSecret = null;
        DynamicObject[] data = ThirdAppService.getThirdappsConfigByCorpid((String)corpId, (Long)3L);
        if (data != null && data.length > 0) {
            corpSecret = String.valueOf(data[0].get("corpsecret"));
        } else {
            data = ThirdAppService.getBasQywxh((String)corpId);
            if (data != null && data.length > 0) {
                corpSecret = String.valueOf(data[0].get("corpsecret"));
            }
        }
        String accessToken = WxqyhUtils.getSkyAccessToken(currentCenter, corpId, corpSecret);
        if (kd.bos.login.utils.StringUtils.isEmpty((String)accessToken)) {
            result.setErrorMessage("wxqyh\uff1aaccess_token is null !");
            return result;
        }
        String userId = WxqyhUtils.getSkyUserInfo(currentCenter, accessToken, code, corpId, corpSecret);
        if (kd.bos.login.utils.StringUtils.isNotEmpty((String)userId)) {
            result.setSucceed(true);
            result.setUserType(UserType.USER_ID);
            result.setUserFlag(userId);
        }
        return result;
    }

    private static String getSkyAccessToken(Account currentCenter, String corpId, String corpSecret) {
        ThirdAuthApp thirdAuthAppInfo = new ThirdAuthApp();
        thirdAuthAppInfo.setCorpId(corpId);
        thirdAuthAppInfo.setSecret(corpSecret);
        thirdAuthAppInfo.setEntryRole("1");
        thirdAuthAppInfo.setErpRole(SkyUtils.getSystemEnv());
        return SkyUtils.getSkyAccessToken((Account)currentCenter, (ThirdAuthApp)thirdAuthAppInfo);
    }

    private static String getSkyUserInfo(Account currentCenter, String accessToken, String code, String corpId, String corpSecret) {
        ThirdAuthApp thirdAuthApp = new ThirdAuthApp();
        thirdAuthApp.setCorpId(corpId);
        thirdAuthApp.setEntryRole("1");
        thirdAuthApp.setSecret(corpSecret);
        thirdAuthApp.setErpRole(SkyUtils.getSystemEnv());
        return SkyUtils.getSkyUserInfo((Account)currentCenter, (String)accessToken, (String)code, (ThirdAuthApp)thirdAuthApp);
    }
}

