/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.utils;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.api.ApiRequestContext;
import kd.bos.base.parameter.ParameterService;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.mc.LoginMCService;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.form.field.ORMUtil;
import kd.bos.i18n.mservice.I18nServiceHelper;
import kd.bos.id.ID;
import kd.bos.instance.Instance;
import kd.bos.ksql.util.StringUtil;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.login.IMainPageFacadeService;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.VerifyCode;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.login.api.APILoginError;
import kd.bos.login.constant.CookieStatement;
import kd.bos.login.emun.AccountType;
import kd.bos.login.emun.BrandUpEnum;
import kd.bos.login.emun.LoginConfigEnum;
import kd.bos.login.lang.LangContext;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.model.Language;
import kd.bos.login.service.impl.CustomLoginConfigService;
import kd.bos.login.service.session.impl.SessionServiceImpl;
import kd.bos.login.sso.SSOAnalysis;
import kd.bos.login.thirdauth.UserAuthResult;
import kd.bos.login.thirdauth.UserProperType;
import kd.bos.login.user.DefaultParameterService;
import kd.bos.login.user.LoginConfigParamService;
import kd.bos.login.user.LoginUserService;
import kd.bos.login.user.PswStrategyService;
import kd.bos.login.util.GlobalDeployUtils;
import kd.bos.login.util.cache.CacheLoginUtils;
import kd.bos.login.utils.AdminUtils;
import kd.bos.login.utils.Constants;
import kd.bos.login.utils.DateUtils;
import kd.bos.login.utils.FrameCommonUtls;
import kd.bos.login.utils.GuestURLUtils;
import kd.bos.login.utils.HttpUtils;
import kd.bos.login.utils.JSONUtils;
import kd.bos.login.utils.LocalCacheUtils;
import kd.bos.login.utils.ModeTypeUtils;
import kd.bos.login.utils.ParametersUtils;
import kd.bos.login.utils.RSAUtils;
import kd.bos.login.utils.SOAPUtils;
import kd.bos.login.utils.SecurityUtils;
import kd.bos.login.utils.SessionUtils;
import kd.bos.login.utils.StrategeUtils;
import kd.bos.login.utils.StringUtils;
import kd.bos.login.utils.SystemPropertyUtils;
import kd.bos.login.utils.ThirdAPIAPPUtils;
import kd.bos.login.utils.account.LoginAccount;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.login.yunzhijia.YZJSpecialUtils;
import kd.bos.mc.webclient.WebClientFiles;
import kd.bos.mservice.form.FormService;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import kd.bos.session.SessionInfo;
import kd.bos.session.SessionKeys;
import kd.bos.session.SessionManager;
import kd.bos.tenant.enums.TenantConfigTypeEnum;
import kd.bos.url.UrlService;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.PasswordEncryptUtil;
import kd.bos.util.RevProxyUtil;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.codec.binary.Base64;

@SdkPublic
public class LoginUtils {
    private static final String[] CSRF_EXCEPT_LIST = new String[]{"/tempfile/download.do", "/attachment/preview.do", "/attachment/downloadAll.do", "/attachment/download.do", "/attachment/uploadFile.do"};
    private static final String REFERER_STRING = "Referer";
    private static final String ORIGIN_STRING = "Origin";
    private static final String VALUE = "value";
    private static final String IMAGE_MCDATA = "image_mcdata";
    private static final int RESEND_SMS_DATE = 10;
    private static final String ENABLE_RSA_ECB_OAEP = "enable_rsa_ecb_oaep";
    private static final String MC = "mc";
    private static final String MESSAGE = "message";
    private static final String SUCCESS = "success";
    private static final String CHECK_USER_TYPE = "check_user_type";
    private static final String LOGIN_IP_TIP = "login_ip_tip";
    private static final String POST = "post";
    private static final String KD_CSRF_TOKEN = "kd-csrf-token";
    public static final String BOS_LOGIN = "bos-login";
    private static final String DESCRIPTION_CN = "description_cn";
    private static final String UPPER_UTF_8 = "UTF-8";
    private static final String USER_ID = "userId";
    public static final String ACCOUNT_ID = "accountId";
    private static final String UTF_8 = "utf-8";
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private static final String ATTACHMENT_FILENAME = "attachment;filename=\"";
    private static final String ZH_CN = "zh_CN";
    private static final String KEY_DATA = "KeyData";
    private static final String GUEST_USER_ID = "guest_user_id";
    private static final String _RSA_KEY_VALUE = "_rsa_key_value";
    private static final String TRUE_STRING = "true";
    private static final String HTTP_START_STRING = "http://";
    private static final String HTTPS_START_STRING = "https://";
    private static final String KDWEB_DEBUG = "kdweb_debug";
    private static final String KDWEB_CDN = "kdweb_cdn";
    private static final String ISV = "/isv/";
    private static final String[] EXCLUDE_CSRF_CHECK_LIST = new String[]{"/tempfile/print.do", "/attachment/downloadImage/"};
    public static String SPLIT_SIGN = "";
    public static Log logger = LogFactory.getLog(LoginUtils.class);
    private static int EXPIRE_TIME = 60;
    private static final Pattern placeHolderPattern = Pattern.compile("<<([a-zA-Z0-9_]*)>>");
    private static final String MC_TENANT_ALLDATA_KEY = "mc.tenant.%s.data";
    private static final String WSDL_WHITE_LIST = "bos.svc.login.wsdl.white";
    private static final String WSDL_WHITE_PATTERN = "bos.svc.login.wsdl.pattern";
    private static final List<String> API_GUEST_USER_LIST = new ArrayList<String>();
    private static final Map<String, String> FORWORD_URL_MAPPING = new HashMap<String, String>();
    private static String STATIC_RESOURCE_STRING = "";
    private static String STATIC_UPGRADE_STRING = "";
    private static final String[] CSRF_CHECK_LIST = new String[]{"/form/batchInvokeAction.do", "/attachment/", "/tempfile/"};
    private static final String[] REFEREER_CHECK_LIST = new String[]{"/form/batchInvokeAction.do", "/license/validateLicDate.do", "/form/getCustomCtlVersion.do", "/getUserLanguage.do", "/form/releaseRootPage.do", "/form/getConfig.do", "/form/getMetadata.do"};
    private static final String[] MANUAL_CHECK_LIST = new String[]{"/form/batchInvokeAction.do"};
    private static final String LOGINPAGE_ATTACH_FILES = "loginpageattachfiles";
    private static final String redirectP = "redirect";
    private static final String loginOrg = "loginOrg";

    public static String getLoginResponse(String errCode, String msg) throws IOException {
        HashMap<String, String> lptaEx = new HashMap<String, String>(8);
        lptaEx.put("errorcode", errCode);
        if (msg != null) {
            String[] message = msg.split(ResManager.loadKDString((String)"\u539f\u56e0:", (String)"LoginUtils_0", (String)BOS_LOGIN, (Object[])new Object[0]));
            if (message.length > 1) {
                lptaEx.put(DESCRIPTION_CN, message[0]);
            } else {
                lptaEx.put(DESCRIPTION_CN, msg);
            }
        } else {
            lptaEx.put(DESCRIPTION_CN, msg);
        }
        lptaEx.put("description", msg);
        return JSONUtils.toString(lptaEx);
    }

    private static String getLoginResponse(int errCode, String msg) throws IOException {
        return LoginUtils.getLoginResponse(String.valueOf(errCode), msg);
    }

    public static boolean hasPrevilige(String currentType, String[] allTypes) {
        boolean hasPre = false;
        if (StringUtils.isNotEmpty((String)currentType) && allTypes != null) {
            for (String tempString : allTypes) {
                if (!currentType.equals(tempString)) continue;
                hasPre = true;
                break;
            }
        }
        return hasPre;
    }

    public static String getChinessNameOfAccountType(AccountType accountType) {
        String returnName = "";
        if (accountType != null) {
            switch (accountType) {
                case YzjPublicCloud: {
                    returnName = ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u79c1\u6709\u4e91\u767b\u5f55\u65b9\u5f0f", (String)"LoginUtils_1", (String)BOS_LOGIN, (Object[])new Object[0]);
                    break;
                }
                case YzjPrivateCloud: {
                    returnName = ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u79c1\u6709\u4e91\u767b\u5f55\u65b9\u5f0f", (String)"LoginUtils_1", (String)BOS_LOGIN, (Object[])new Object[0]);
                    break;
                }
                case SelfCreate: {
                    returnName = ResManager.loadKDString((String)"\u91d1\u8776\u4e91\u81ea\u5efa\u767b\u5f55\u65b9\u5f0f", (String)"LoginUtils_2", (String)BOS_LOGIN, (Object[])new Object[0]);
                    break;
                }
                case ThridParty: {
                    returnName = ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u767b\u5f55\u65b9\u5f0f", (String)"LoginUtils_3", (String)BOS_LOGIN, (Object[])new Object[0]);
                    break;
                }
                default: {
                    returnName = accountType.toString();
                }
            }
        }
        return returnName;
    }

    public static CharSequence replacePlaceHolder(CharSequence str, Map<String, CharSequence> map) {
        return LoginUtils.replacePlaceHolder(str, map, true);
    }

    private static CharSequence replacePlaceHolder(CharSequence str, Map<String, CharSequence> map, boolean removeEmpty) {
        return LoginUtils.replaceByPattern(placeHolderPattern, str, map, removeEmpty);
    }

    private static CharSequence replaceByPattern(Pattern pattern, CharSequence str, Map<String, CharSequence> map, boolean removeEmpty) {
        if (map.isEmpty() && !removeEmpty) {
            return str;
        }
        Matcher matcher = pattern.matcher(str);
        int lastEnd = 0;
        CharSequence value = null;
        String key = null;
        boolean find = matcher.find();
        if (!find) {
            return str;
        }
        StringBuilder result = new StringBuilder(str.length());
        do {
            key = matcher.group(1);
            int start = matcher.start(0);
            int end = matcher.end(0);
            value = map.get(key);
            if (value == null && !removeEmpty) {
                result.append(str, lastEnd, end);
            } else {
                result.append(str, lastEnd, start);
                if (value != null) {
                    result.append(value);
                }
            }
            lastEnd = end;
        } while (matcher.find());
        result.append(str, lastEnd, str.length());
        return result;
    }

    public static void forcePOSTSubmitCheck(HttpServletRequest servletRequest) throws KDException {
        if (!POST.equals(servletRequest.getMethod().toLowerCase(Locale.ENGLISH))) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u975e\u6cd5\u64cd\u4f5c\uff01", (String)"LoginUtils_4", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
    }

    public static String getDecryptedPassword(HttpServletRequest servletRequest, String accountId) {
        String userPassword = servletRequest.getParameter(Constants.LOGIN_PASSWORD_KEY);
        String userName = servletRequest.getParameter(Constants.LOGIN_USER_KEY);
        String accessKey = servletRequest.getParameter(Constants.LOGIN_ACCESS_KEY);
        return LoginUtils.getDecryptedPassword(servletRequest, userPassword, userName, accessKey, accountId);
    }

    private static String getDecryptedPassword(HttpServletRequest servletRequest, String userPassword, String userName, String accessKey, String accountId) {
        if (LoginUtils.isSupportOldRSA()) {
            return LoginUtils.getDecryptedPasswordOld(servletRequest, userPassword, userName, accessKey);
        }
        String wholeString = CacheLoginData.getAttribute((String)LoginUtils.getAccessKeyType(), (String)LoginUtils.getRsaKey(accountId));
        String returnPass = null;
        String privateKey = LoginUtils.getPrivateKeyFromString(wholeString);
        if (StringUtils.isNotEmpty((String)accessKey) && StringUtils.isNotEmpty((String)userPassword) && StringUtils.isNotEmpty((String)privateKey) && StringUtils.isNotEmpty((String)userName) && userName.trim().length() > 0 && accessKey.startsWith(userName)) {
            try {
                String tenantId = RevProxyUtil.getTenantCode((HttpServletRequest)servletRequest);
                returnPass = kd.bos.util.StringUtils.isNotEmpty((String)SystemPropertyUtils.getProptyByTenant((String)ENABLE_RSA_ECB_OAEP, (String)tenantId)) && SystemPropertyUtils.getProptyByTenant((String)ENABLE_RSA_ECB_OAEP, (String)tenantId).equals(TRUE_STRING) ? new String(RSAUtils.decryptByKey((Key)RSAUtils.getPrivateKey((byte[])Base64.decodeBase64((String)privateKey)), (byte[])Base64.decodeBase64((byte[])userPassword.getBytes(UPPER_UTF_8)), (String)"oaep")) : new String(RSAUtils.decryptByKey((Key)RSAUtils.getPrivateKey((byte[])Base64.decodeBase64((String)privateKey)), (byte[])Base64.decodeBase64((byte[])userPassword.getBytes(UPPER_UTF_8))));
            }
            catch (Exception e) {
                logger.info(e.getMessage());
            }
        }
        if (returnPass == null) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\u3002", (String)"LoginAction_10", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
        return returnPass;
    }

    public static String getDecryptedPassword(String userPassword, String userName, String accessKey, String accountId) {
        if (LoginUtils.isSupportOldRSA()) {
            return LoginUtils.getDecryptedPasswordOld(userPassword, userName, accessKey);
        }
        String wholeString = CacheLoginData.getAttribute((String)LoginUtils.getAccessKeyType(), (String)LoginUtils.getRsaKey(accountId));
        String returnPass = null;
        String privateKey = LoginUtils.getPrivateKeyFromString(wholeString);
        if (StringUtils.isNotEmpty((String)accessKey) && StringUtils.isNotEmpty((String)userPassword) && StringUtils.isNotEmpty((String)privateKey) && StringUtils.isNotEmpty((String)userName) && userName.trim().length() > 0 && accessKey.startsWith(userName)) {
            try {
                returnPass = new String(RSAUtils.decryptByKey((Key)RSAUtils.getPrivateKey((byte[])Base64.decodeBase64((String)privateKey)), (byte[])Base64.decodeBase64((byte[])userPassword.getBytes(StandardCharsets.UTF_8))));
            }
            catch (KDException e) {
                logger.debug(e.getMessage());
            }
        }
        if (returnPass == null) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\u3002", (String)"LoginAction_10", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
        return returnPass;
    }

    public static String getDecryptedPasswordOld(String userPassword, String userName, String accessKey) {
        String returnPass = null;
        if (StringUtils.isNotEmpty((String)accessKey) && StringUtils.isNotEmpty((String)userPassword) && StringUtils.isNotEmpty((String)userName) && userName.trim().length() > 0 && accessKey.startsWith(userName)) {
            String privateKey = CacheLoginData.getAttribute((String)LoginUtils.getAccessKeyType(), (String)accessKey);
            try {
                returnPass = new String(RSAUtils.decryptByKey((Key)RSAUtils.getPrivateKey((byte[])Base64.decodeBase64((String)privateKey)), (byte[])Base64.decodeBase64((byte[])userPassword.getBytes(UPPER_UTF_8))));
            }
            catch (KDException e) {
                logger.debug(e.getMessage());
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Throwable)e);
            }
        }
        if (returnPass == null) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\u3002", (String)"LoginAction_10", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
        return returnPass;
    }

    public static String getDecryptedPasswordOld(HttpServletRequest request, String userPassword, String userName, String accessKey) {
        String returnPass = null;
        if (StringUtils.isNotEmpty((String)accessKey) && StringUtils.isNotEmpty((String)userPassword) && StringUtils.isNotEmpty((String)userName) && userName.trim().length() > 0 && accessKey.startsWith(userName)) {
            String privateKey = CacheLoginData.getAttribute((String)LoginUtils.getAccessKeyType(), (String)accessKey);
            try {
                String tenantId = RevProxyUtil.getTenantCode((HttpServletRequest)request);
                returnPass = kd.bos.util.StringUtils.isNotEmpty((String)SystemPropertyUtils.getProptyByTenant((String)ENABLE_RSA_ECB_OAEP, (String)tenantId)) && SystemPropertyUtils.getProptyByTenant((String)ENABLE_RSA_ECB_OAEP, (String)tenantId).equals(TRUE_STRING) ? new String(RSAUtils.decryptByKey((Key)RSAUtils.getPrivateKey((byte[])Base64.decodeBase64((String)privateKey)), (byte[])Base64.decodeBase64((byte[])userPassword.getBytes(UPPER_UTF_8)), (String)"oaep")) : new String(RSAUtils.decryptByKey((Key)RSAUtils.getPrivateKey((byte[])Base64.decodeBase64((String)privateKey)), (byte[])Base64.decodeBase64((byte[])userPassword.getBytes(UPPER_UTF_8))));
            }
            catch (KDException e) {
                logger.debug(e.getMessage());
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Throwable)e);
            }
        }
        if (returnPass == null) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\u3002", (String)"LoginAction_10", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
        return returnPass;
    }

    private static boolean isSupportOldRSA() {
        String supportOldRsa = System.getProperty("support_old_rsa");
        return StringUtils.getBooleanValue((String)supportOldRsa);
    }

    public static String getPublicKeyByAccessKey(String accessKey, String accountId) throws KDException {
        String publicKey = "";
        if (LoginUtils.isSupportOldRSA()) {
            return LoginUtils.getPublicKeyByAccessKeyOld(accessKey);
        }
        String wholeString = CacheLoginData.getAttribute((String)LoginUtils.getAccessKeyType(), (String)LoginUtils.getRsaKey(accountId));
        if (StringUtils.isEmpty((String)wholeString)) {
            KeyPair keyPair = RSAUtils.generateKeyPair();
            publicKey = RSAUtils.generateBase64Key((byte[])keyPair.getPublic().getEncoded());
            String privateKey = RSAUtils.generateBase64Key((byte[])keyPair.getPrivate().getEncoded());
            CacheLoginData.setAttribute((String)LoginUtils.getAccessKeyType(), (String)LoginUtils.getRsaKey(accountId), (String)(publicKey + "," + privateKey), (int)Constants.ACCESS_KEY_TIME_OUT);
        } else {
            publicKey = LoginUtils.getPublicKeyFromString(wholeString);
            CacheLoginData.setAttribute((String)LoginUtils.getAccessKeyType(), (String)LoginUtils.getRsaKey(accountId), (String)wholeString, (int)Constants.ACCESS_KEY_TIME_OUT);
        }
        return publicKey;
    }

    private static String getRsaKey(String accountId) {
        return Instance.getClusterName() + accountId + _RSA_KEY_VALUE;
    }

    public static String getPublicKeyByAccessKeyOld(String accessKey) throws KDException {
        String publicKey = "";
        KeyPair keyPair = RSAUtils.generateKeyPair();
        publicKey = RSAUtils.generateBase64Key((byte[])keyPair.getPublic().getEncoded());
        String privateKey = RSAUtils.generateBase64Key((byte[])keyPair.getPrivate().getEncoded());
        CacheLoginData.setAttribute((String)LoginUtils.getAccessKeyType(), (String)accessKey, (String)privateKey, (int)Constants.ACCESS_KEY_TIME_OUT);
        return publicKey;
    }

    private static String getPublicKeyFromString(String wholeString) {
        return LoginUtils.getKeyFromString(wholeString, 0);
    }

    private static String getPrivateKeyFromString(String wholeString) {
        return LoginUtils.getKeyFromString(wholeString, 1);
    }

    private static String getKeyFromString(String wholeString, int position) {
        String[] wholeArray;
        String publicKey = null;
        if (StringUtils.isNotEmpty((String)wholeString) && (wholeArray = wholeString.split(",")).length == 2) {
            publicKey = wholeArray[position];
        }
        return publicKey;
    }

    private static String getAccessKeyType() {
        return "loginPass";
    }

    public static boolean proveSMSVerifyCode(HttpServletRequest servletRequest, HttpServletResponse servletResponse, boolean needDelete) throws IOException {
        String inputCode;
        if (!LoginUtils.isIgnoreNeedVerifyCode() && StringUtils.isEmpty((String)(inputCode = servletRequest.getParameter("verifycode")))) {
            String resp = LoginUtils.getLoginResponse("needVerification", "");
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)resp);
            return false;
        }
        return LoginUtils.proveVerifyCode(servletRequest, servletResponse, needDelete);
    }

    public static boolean proveVerifyCode(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        return LoginUtils.proveVerifyCode(servletRequest, servletResponse, true);
    }

    public static boolean proveVerifyCode(HttpServletRequest servletRequest, HttpServletResponse servletResponse, boolean needDelete) throws IOException {
        LoginAccount loginAccount = LoginAccountFactory.createInstanceByHttpRequest((HttpServletRequest)servletRequest, Optional.empty());
        String inputCode = servletRequest.getParameter("verifycode");
        String loginId = servletRequest.getParameter("loginid");
        if (LoginUtils.isForcedInputVerifyCode(loginAccount.getTenantId())) {
            return LoginUtils.checkVerifyCode(servletResponse, inputCode, loginId, needDelete);
        }
        if (LoginUtils.isIgnoreNeedVerifyCode()) {
            return true;
        }
        String mobile = servletRequest.getParameter(Constants.LOGIN_USER_KEY);
        Map map = StrategeUtils.getUserId((HttpServletRequest)servletRequest, (String)mobile);
        String userId = null;
        if (map != null && map.get(USER_ID) != null) {
            userId = (String)map.get(USER_ID);
        }
        Account currentCenter = loginAccount.getAccount();
        if (userId == null) {
            LoginUtils.checkUserEnable(currentCenter, mobile);
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{String.format(ResManager.loadKDString((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\u3002", (String)"LoginUtils_6", (String)BOS_LOGIN, (Object[])new Object[0]), "")});
        }
        if (!StrategeUtils.isNeedDisplayVerifyCode((Account)currentCenter, (Map)map, (String)LoginClientEnum.WEB.toString()) && StringUtils.isEmpty((String)inputCode) && !LoginUtils.isForcedInputVerifyCode(loginAccount.getTenantId())) {
            return true;
        }
        String redirect = servletRequest.getParameter(redirectP);
        if (redirect != null && redirect.contains("mobile.html")) {
            return true;
        }
        if (!LoginUtils.checkVerifyCode(servletResponse, inputCode, loginId)) {
            return false;
        }
        String vType = CacheLoginData.getType4VerifyCode();
        if (needDelete) {
            CacheLoginData.remove((String)vType, (String)loginId);
        } else {
            CacheLoginData.setAttribute((String)vType, (String)loginId, (String)inputCode, (int)60);
        }
        return true;
    }

    private static boolean checkVerifyCode(HttpServletResponse servletResponse, String inputCode, String loginId, boolean needDelete) throws IOException {
        String validVerifyCode = CacheLoginData.getAttribute((String)CacheLoginData.getType4VerifyCode(), (String)loginId);
        if (StringUtils.isEmpty((String)inputCode)) {
            String resp = LoginUtils.getLoginResponse("needVerification", "");
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)resp);
            return false;
        }
        if (validVerifyCode == null) {
            String resp = LoginUtils.getLoginResponse(1, ResManager.loadKDString((String)"\u56fe\u5f62\u9a8c\u8bc1\u7801\u8d85\u65f6\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u8f93\u5165\u3002", (String)"LoginUtils_23", (String)BOS_LOGIN, (Object[])new Object[0]));
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)resp);
            return false;
        }
        if (!validVerifyCode.equalsIgnoreCase(inputCode)) {
            String resp = LoginUtils.getLoginResponse(1, ResManager.loadKDString((String)"\u56fe\u5f62\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"LoginUtils_24", (String)BOS_LOGIN, (Object[])new Object[0]));
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)resp);
            return false;
        }
        String vType = CacheLoginData.getType4VerifyCode();
        if (needDelete) {
            CacheLoginData.remove((String)vType, (String)loginId);
        }
        return true;
    }

    public static boolean isIgnoreNeedVerifyCode() {
        return TRUE_STRING.equalsIgnoreCase(System.getProperty("Ignore_verifycode"));
    }

    public static void setYZJLKCache(String userId, String lkKey, int timeOut) {
        CacheLoginData.setAttribute((String)"yzjlkKeys", (String)userId, (String)lkKey, (int)timeOut);
    }

    public static String getYZJLKCache(String userId) {
        return CacheLoginData.getAttribute((String)"yzjlkKeys", (String)userId);
    }

    public static void getVerifyCode(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            VerifyCode vc = new VerifyCode();
            BufferedImage bim = vc.getImage();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bim, "JPEG", out);
            String content = Base64.encodeBase64String((byte[])out.toByteArray());
            response.setCharacterEncoding(UPPER_UTF_8);
            response.setContentType("text/json;charset=UTF-8");
            String verifycode = vc.getText();
            String loginId = UUID.randomUUID().toString();
            String vType = CacheLoginData.getType4VerifyCode();
            CacheLoginData.setAttribute((String)vType, (String)loginId, (String)verifycode, (int)60);
            HashMap<String, String> vCode = new HashMap<String, String>(8);
            vCode.put("content", "data:image/jpeg;base64," + content);
            vCode.put("loginId", loginId);
            vCode.put("timeout", String.valueOf(60));
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)JSONUtils.toString(vCode));
        }
        catch (KDException ex) {
            logger.debug(ex.getMessage());
            ErrorCode code = ex.getErrorCode();
            String resp = LoginUtils.getLoginResponse(String.valueOf(code.getCode()), ex.getMessage());
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)resp);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            String resp = LoginUtils.getLoginResponse("1", ResManager.loadKDString((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\n", (String)"LoginUtils_9", (String)BOS_LOGIN, (Object[])new Object[0]));
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)resp);
        }
    }

    public static Map<String, Object> isAllowSendSms(String accountId, String phone) {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        result.put(SUCCESS, true);
        String total = CacheLoginData.getAttribute((String)"smsLogin", (String)(accountId + phone + "totalTimes"));
        int totalCount = 0;
        if (total != null) {
            totalCount = Integer.parseInt(total);
            String reSendDate = "";
            if (totalCount == 10) {
                result.put(SUCCESS, false);
                reSendDate = DateUtils.formatDate((Date)DateUtils.addMinutes((Date)new Date(), (int)10), (Object[])new Object[]{"yyyy-MM-dd HH:mm:ss"});
                result.put(MESSAGE, String.format(ResManager.loadKDString((String)"\u77ed\u4fe1\u9a8c\u8bc1\u7801\u5df2\u53d1\u9001\u8d85\u8fc710\u6b21\uff0c\u8bf7\u5728 %s\u4e4b\u540e\u518d\u8bd5\u3002", (String)"LoginUtils_20", (String)BOS_LOGIN, (Object[])new Object[0]), reSendDate));
                CacheLoginData.setAttribute((String)"smsLogin", (String)(accountId + phone + "_limitSms"), (String)DateUtils.formatDate((Date)DateUtils.addMinutes((Date)new Date(), (int)10), (Object[])new Object[]{"yyyy-MM-dd HH:mm:ss"}), (int)600);
            }
            if (totalCount > 10) {
                reSendDate = CacheLoginData.getAttribute((String)"smsLogin", (String)(accountId + phone + "_limitSms"));
                if (StringUtils.isNotEmpty((String)reSendDate)) {
                    result.put(SUCCESS, false);
                    result.put(MESSAGE, String.format(ResManager.loadKDString((String)"\u77ed\u4fe1\u9a8c\u8bc1\u7801\u5df2\u53d1\u9001\u8d85\u8fc710\u6b21\uff0c\u8bf7\u5728 %s\u4e4b\u540e\u518d\u8bd5\u3002", (String)"LoginUtils_20", (String)BOS_LOGIN, (Object[])new Object[0]), reSendDate));
                } else {
                    reSendDate = DateUtils.formatDate((Date)DateUtils.addMinutes((Date)new Date(), (int)10), (Object[])new Object[]{"yyyy-MM-dd HH:mm:ss"});
                    CacheLoginData.setAttribute((String)"smsLogin", (String)(accountId + phone + "_limitSms"), (String)reSendDate, (int)600);
                }
            }
        }
        CacheLoginData.setAttribute((String)"smsLogin", (String)(accountId + phone + "totalTimes"), (String)String.valueOf(++totalCount), (int)LoginUtils.getSecondsNextDay());
        return result;
    }

    @Deprecated
    public static boolean isReachSendingMax(String accountId, String phone) {
        boolean isReachSendingMax = false;
        String total = CacheLoginData.getAttribute((String)"smsLogin", (String)(accountId + phone + "totalTime"));
        int totalCount = 0;
        if (total != null && (totalCount = Integer.parseInt(total)) >= 10) {
            isReachSendingMax = true;
        }
        CacheLoginData.setAttribute((String)"smsLogin", (String)(accountId + phone + "totalTime"), (String)String.valueOf(++totalCount), (int)LoginUtils.getSecondsNextDay());
        return isReachSendingMax;
    }

    public static void clearSmsSendTimes(String accountId, String phone) {
        CacheLoginData.remove((String)"smsLogin", (String)(accountId + phone + "totalTimes"));
    }

    public static void writeResponseResult(ServletResponse response, CharSequence result, String contentType) throws IOException {
        response.setContentType(contentType);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream((OutputStream)response.getOutputStream()), StandardCharsets.UTF_8);){
            writer.write(result.toString());
            writer.flush();
        }
    }

    public static void writeResponseString(HttpServletResponse response, String result, String fileName) throws IOException {
        if (result != null) {
            response.setContentType("application/octet-stream;charset=ISO8859-1");
            response.setHeader(CONTENT_DISPOSITION, ATTACHMENT_FILENAME + URLEncoder.encode(fileName, UPPER_UTF_8) + "\"");
            response.setHeader("Content-Length", String.valueOf(result.getBytes(UPPER_UTF_8).length));
            ByteArrayInputStream is = new ByteArrayInputStream(result.getBytes(UPPER_UTF_8));
            ServletOutputStream os = response.getOutputStream();
            if (os != null) {
                byte[] b = new byte[2048];
                while (is.read(b) != -1) {
                    os.write(b);
                }
                os.flush();
                os.close();
            }
            ((InputStream)is).close();
        }
    }

    public static void writeResponseStream(HttpServletRequest request, HttpServletResponse response, byte[] result, String fileName) throws IOException {
        if (result != null) {
            String contentType = request.getServletContext().getMimeType(fileName);
            response.setContentType(contentType + ";charset=UTF-8");
            response.setHeader(CONTENT_DISPOSITION, ATTACHMENT_FILENAME + URLEncoder.encode(fileName, UPPER_UTF_8) + "\"");
            response.setHeader("Content-Length", String.valueOf(result.length));
            ByteArrayInputStream is = new ByteArrayInputStream(result);
            ServletOutputStream os = response.getOutputStream();
            if (os != null) {
                byte[] b = new byte[2048];
                while (is.read(b) != -1) {
                    os.write(b);
                }
                os.flush();
                os.close();
            }
            ((InputStream)is).close();
        }
    }

    public static boolean isDownloadPlugin(HttpServletRequest request, String path) {
        boolean isNewDownload = false;
        if (path.startsWith("/kdctlres/")) {
            isNewDownload = true;
        }
        return isNewDownload;
    }

    public static int getSecondsNextDay() {
        Calendar cal = Calendar.getInstance();
        cal.add(6, 1);
        cal.set(11, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        Long seconds = (cal.getTimeInMillis() - System.currentTimeMillis()) / 1000L;
        return seconds.intValue();
    }

    public static Map<String, Object> getCustomDataMap(HttpServletRequest request) throws IOException {
        return LoginUtils.getCustomDataMapNew(request, false);
    }

    public static Map<String, Object> getCustomDataMapNew(HttpServletRequest request, boolean isLogin) throws IOException {
        CustomLoginConfigService customLoginConfigService = new CustomLoginConfigService();
        Map<String, Object> returnMap = LoginUtils.getDefaultData();
        LoginUtils.addCookieStatement(request, returnMap);
        LoginUtils.setConfigData(request, customLoginConfigService, returnMap, "bizextplugin");
        Map<String, Object> loginConfigDataMap = LoginUtils.getLoginConfigData(request, isLogin);
        LoginUtils.fillLoginConfigData(returnMap, loginConfigDataMap);
        try {
            Map extConfig = customLoginConfigService.getLoginConfigExtData(request);
            if (extConfig != null) {
                returnMap.putAll(extConfig);
            }
        }
        catch (Exception ex) {
            logger.error("getLoginConfigExtData error", (Throwable)ex);
        }
        Map<String, Object> facadeDataMap = LoginUtils.getFacadeData(request);
        LoginUtils.fillLoginConfigData(returnMap, facadeDataMap);
        returnMap.put("kdbrand", "2");
        LoginUtils.setConfigData(request, customLoginConfigService, returnMap, "extConfigPlugin");
        String pubTenantType = LicenseServiceHelper.getPubTenantType();
        if (Boolean.parseBoolean(pubTenantType)) {
            returnMap.put(LoginConfigEnum.SHOW_POLICY.getKey(), pubTenantType);
        } else {
            Object showpolicy = returnMap.get(LoginConfigEnum.SHOW_POLICY.getKey());
            if (showpolicy == null || !Boolean.parseBoolean(showpolicy.toString())) {
                returnMap.remove(LoginConfigEnum.POLICY_LINK.getKey());
            }
        }
        returnMap.put("isGlobalDeploy", GlobalDeployUtils.isGlobalDeploy((String)RevProxyUtil.getTenantId((HttpServletRequest)request)) + "");
        return returnMap;
    }

    private static void addCookieStatement(HttpServletRequest request, Map<String, Object> returnMap) {
        String tenantId = RevProxyUtil.getTenantCode((HttpServletRequest)request);
        String enable = SystemPropertyUtils.getProptyByTenant((String)"enable_login_cookieStatement", (String)tenantId);
        if (StringUtils.isNotEmpty((String)enable) && Boolean.parseBoolean(enable)) {
            returnMap.put("cookieStatement", CookieStatement.getCookieStmtMap());
        }
    }

    private static void setConfigData(HttpServletRequest request, CustomLoginConfigService customLoginConfigService, Map<String, Object> returnMap, String type) {
        try {
            Map<String, Object> customLoginConfigServiceMap = LoginUtils.getLoginConfigServiceData(request, customLoginConfigService, type);
            LoginUtils.fillLoginConfigData(returnMap, customLoginConfigServiceMap);
        }
        catch (Exception e) {
            logger.error("getLoginConfigServiceData error", (Throwable)e);
        }
    }

    private static Map<String, Object> getDefaultData() {
        int modeType = LicenseServiceHelper.getModeType();
        Map defaultMap = ModeTypeUtils.getDefaultData((int)modeType);
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        if (defaultMap != null) {
            returnMap.putAll(defaultMap);
        }
        returnMap.putAll(LoginUtils.getDefaultAreaCode());
        return returnMap;
    }

    private static Map<String, Object> getDefaultAreaCode() {
        HashMap<String, Object> countryMap = new HashMap<String, Object>();
        try {
            DynamicObject defaultcountry = (DynamicObject)SystemParamServiceHelper.getPublicParameter((String)"defaultcountry");
            if (defaultcountry == null) {
                return countryMap;
            }
            String defaultNum = defaultcountry.getString("number");
            DynamicObject data = QueryServiceHelper.queryOne((String)"bd_country", (String)"id, areacode", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)defaultNum)});
            if (data != null) {
                countryMap.put("defaultAreaCode", data.getString("areacode"));
            }
        }
        catch (Exception e) {
            logger.error("getDefaultAreaCode error", (Throwable)e);
        }
        return countryMap;
    }

    public static Map<String, Object> getCountryAreaCodes() {
        HashMap<String, Object> countryMap = new HashMap<String, Object>();
        try {
            Map countryAreaCode = ORMUtil.getCountryAndAreaCode();
            countryMap.put("countryAreaCodes", countryAreaCode);
        }
        catch (Exception e) {
            logger.error("getCountryAreaCodes error", (Throwable)e);
        }
        return countryMap;
    }

    private static void fillLoginConfigData(Map<String, Object> baseMap, Map<String, Object> replaceMap) {
        if (CollectionUtils.isEmpty(replaceMap)) {
            return;
        }
        baseMap.putAll(replaceMap);
    }

    private static Map<String, Object> getLoginConfigServiceData(HttpServletRequest request, CustomLoginConfigService customLoginConfigService, String type) {
        return customLoginConfigService.getLoginConfigServiceData(request, type);
    }

    private static Map<String, Object> getFacadeData(HttpServletRequest request) {
        String title;
        String welcomeMessage;
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        IMainPageFacadeService service = LoginUtils.getiMainPageFacadeService(request);
        String icoUrl = LoginUtils.getIconUrl(request, service);
        if (StringUtils.isNotEmpty((String)icoUrl)) {
            returnMap.put(LoginConfigEnum.TAB_IMG.getKey(), icoUrl);
        }
        if (StringUtils.isNotEmpty((String)(welcomeMessage = LoginUtils.getWelcomeMessage(request, service)))) {
            returnMap.put(LoginConfigEnum.WELCOME_MSG.getKey(), welcomeMessage);
        }
        if (StringUtils.isNotEmpty((String)(title = LoginUtils.getTitleMessage(request, service)))) {
            returnMap.put(LoginConfigEnum.TAB_WORD.getKey(), title);
        }
        return returnMap;
    }

    private static Map<String, Object> getLoginConfigData(HttpServletRequest request, boolean isLogin) throws IOException {
        String key = "_tenant_login_config_values_";
        String tenantId = RevProxyUtil.getTenantCode((HttpServletRequest)request);
        Account currentCenter = LoginUtils.getSingleAccount(request, tenantId, isLogin);
        StringBuilder mcDataKey = new StringBuilder(key);
        StringBuilder imageDataKey = new StringBuilder(IMAGE_MCDATA);
        boolean isEnableLoginConfig = false;
        if (TRUE_STRING.equals(SystemPropertyUtils.getProptyByTenant((String)"enable_dataCenter_loginPage", (String)tenantId))) {
            isEnableLoginConfig = true;
            mcDataKey.append(currentCenter.getAccountId());
            imageDataKey.append(currentCenter.getAccountId());
        } else {
            mcDataKey.append(tenantId);
            imageDataKey.append(tenantId);
        }
        String jasonValue = LoginUtils.getLoginConfig(mcDataKey.toString(), currentCenter, isEnableLoginConfig, key, tenantId);
        Map<String, Object> returnMap = new HashMap<String, Object>(8);
        if (StringUtils.isNotEmpty((String)jasonValue) && !"null".equals(jasonValue)) {
            boolean hasIsvImage = false;
            try {
                String imageValue = LoginUtils.getLoginConfig(imageDataKey.toString(), currentCenter, isEnableLoginConfig, IMAGE_MCDATA, tenantId);
                hasIsvImage = StringUtils.isNotEmpty((String)imageValue) && !"null".equals(imageValue);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
            boolean hasFile = hasIsvImage;
            Map tenants = (Map)JSONUtils.cast((String)jasonValue, HashMap.class, (boolean)true);
            returnMap = LoginUtils.parseLoginConfig(tenants, hasFile, tenantId, currentCenter.getAccountId());
        }
        return returnMap;
    }

    private static Account getSingleAccount(HttpServletRequest request, String tenantId, boolean isLogin) {
        String accountId = LoginUtils.getAccountId(request, tenantId, isLogin);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)accountId)) {
            return LoginAccountFactory.createInstanceByDefault((HttpServletRequest)request).getAccount();
        }
        return LoginAccountFactory.createInstanceByCustom((String)accountId).getAccount();
    }

    private static String getAccountId(HttpServletRequest request, String tenantId, boolean isLogin) {
        String accountId = LoginAccountFactory.createInstanceByHttpRequest((HttpServletRequest)request, Optional.of(tenantId), (boolean)isLogin).getAccountId();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)accountId) && RequestContext.get() != null) {
            accountId = LoginAccountFactory.createInstanceByRequestContext(Optional.of(tenantId)).getAccountId();
        }
        return accountId;
    }

    private static Map<String, String> getLanguageMapByCustom(Account currentCenter, String welcomeMessage) {
        HashMap<String, String> welcomeMap = new HashMap<String, String>();
        List<Language> lList = LoginUtils.getAllLanguagesByAccount(currentCenter);
        if (lList != null && lList.size() > 0) {
            for (Language language : lList) {
                welcomeMap.put(language.getNumber(), welcomeMessage);
            }
        }
        return welcomeMap;
    }

    private static String getIconUrl(HttpServletRequest request, IMainPageFacadeService service) {
        String iconUrl = "";
        if (service != null) {
            iconUrl = service.getIconUrl(request);
        }
        return iconUrl;
    }

    private static String getWelcomeMessage(HttpServletRequest request, IMainPageFacadeService service) {
        String welcomeMessage = "";
        if (service != null) {
            welcomeMessage = service.getWelcomeMessage(request);
        }
        return welcomeMessage;
    }

    private static String getTitleMessage(HttpServletRequest request, IMainPageFacadeService service) {
        String title = "";
        if (service != null) {
            title = service.getTitle(request);
        }
        return title;
    }

    private static IMainPageFacadeService getiMainPageFacadeService(HttpServletRequest request) {
        String tenantId = RevProxyUtil.getTenantCode((HttpServletRequest)request);
        return FrameCommonUtls.getFacadeService((String)tenantId);
    }

    private static Map<String, Object> parseLoginConfig(Map<String, Object> tenants, boolean hasFile, String tenantId, String accountId) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>(8);
        tenants.forEach((k, v) -> {
            block17: {
                if (StringUtils.isEmpty((String)k) || "null".equals(v) || !(v instanceof String) || StringUtils.isEmpty((String)v.toString())) {
                    return;
                }
                String vStr = v.toString();
                if (k.toLowerCase(Locale.ENGLISH).endsWith("img")) {
                    try {
                        if (hasFile && !LoginUtils.useFileserverImage(tenantId)) {
                            returnMap.put((String)k, LoginUtils.getStaticFileImage(k, tenantId, accountId));
                            break block17;
                        }
                        returnMap.put((String)k, LoginUtils.getImageFullUrl(String.valueOf(v)));
                    }
                    catch (Exception e) {
                        logger.error("LoginUtils--getImage--error:", (Throwable)e);
                    }
                } else if (vStr.startsWith("[{")) {
                    try {
                        List linkMap = (List)SerializationUtils.fromJsonString((String)vStr, List.class);
                        if (linkMap != null) {
                            returnMap.put("linkdata", SerializationUtils.toJsonString((Object)linkMap));
                        }
                    }
                    catch (Exception e) {
                        logger.error("LoginUtils--getLinkData--error:", (Throwable)e);
                    }
                } else if ("accounttypedesc".equals(k) || "accountplaceholder".equals(k) || "tabword".equals(k) || "welcomemsg".equals(k)) {
                    if (vStr.contains("[") && vStr.contains("]")) {
                        String multiValue = vStr.substring(1, vStr.length() - 1);
                        String[] multivalueArr = multiValue.split(",");
                        HashMap<String, String> map = new HashMap<String, String>(8);
                        for (String value : multivalueArr) {
                            String[] valueArr = value.split("=");
                            if (valueArr.length != 2) continue;
                            map.put(StringUtils.trim((String)valueArr[0]), valueArr[1]);
                        }
                        if (!map.isEmpty()) {
                            returnMap.put((String)k, map);
                        }
                    } else {
                        HashMap<String, String> map = new HashMap<String, String>(8);
                        map.put(ZH_CN, vStr);
                        returnMap.put((String)k, map);
                    }
                } else {
                    returnMap.put((String)k, v);
                }
            }
        });
        return returnMap;
    }

    private static boolean useFileserverImage(String tenantId) {
        String useFileserverImage = SystemPropertyUtils.getProptyByTenant((String)"login.use.fileserver.image", (String)tenantId);
        return TRUE_STRING.equalsIgnoreCase(useFileserverImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getLoginConfig(String cacheKey, Account currentCenter, boolean isEnableLoginConfig, String mcKey, String tenantId) {
        String jasonValue = CacheLoginData.getAttribute((String)MC, (String)cacheKey);
        if (kd.bos.util.StringUtils.isNotEmpty((String)jasonValue)) {
            return jasonValue;
        }
        Class<LoginUtils> clazz = LoginUtils.class;
        synchronized (LoginUtils.class) {
            jasonValue = CacheLoginData.getAttribute((String)MC, (String)cacheKey);
            if (kd.bos.util.StringUtils.isEmpty((String)jasonValue)) {
                try {
                    jasonValue = LoginUtils.getBasLoginConfig(currentCenter, isEnableLoginConfig, mcKey, tenantId);
                    if (StringUtils.isEmpty((String)jasonValue)) {
                        jasonValue = "null";
                    }
                    CacheLoginData.setAttribute((String)MC, (String)cacheKey, (String)jasonValue, (int)Constants.MC_DATA_EXPIRE_TIME);
                }
                catch (Exception e) {
                    throw new KDException(LoginErrorCode.loginBizException, new Object[]{e.getMessage()});
                }
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return jasonValue;
        }
    }

    private static String getBasLoginConfig(Account currentCenter, boolean isEnableLoginConfig, String key, String tenantId) throws Exception {
        Map result;
        String jasonValue = null;
        if (isEnableLoginConfig && !ObjectUtils.isEmpty((Object)(result = LoginConfigParamService.getBasLoginConfigParam((Account)currentCenter, (String)key, (String)ZH_CN))) && result.get(VALUE) != null) {
            jasonValue = result.get(VALUE).toString();
        }
        if (StringUtils.isEmpty(jasonValue)) {
            LoginMCService loginMCService = LoginMCService.create();
            jasonValue = loginMCService.getMCData(tenantId, key);
        }
        return jasonValue;
    }

    private static String getStaticFileImage(String image, String tenantId, String accountId) {
        String imageName;
        if (StringUtils.isEmpty((String)tenantId)) {
            logger.info("\u975e\u6cd5\u8bbf\u95ee");
            return "";
        }
        List imageNames = null;
        String vesion = null;
        String isv = "kingdee";
        String imagefileKey = "imagefile";
        boolean isEnableLoginConfig = false;
        if (TRUE_STRING.equals(SystemPropertyUtils.getProptyByTenant((String)"enable_dataCenter_loginPage", (String)tenantId))) {
            isEnableLoginConfig = true;
            imagefileKey = imagefileKey + accountId;
        } else {
            imagefileKey = imagefileKey + tenantId;
        }
        String cacheData = CacheLoginData.getAttribute((String)MC, (String)imagefileKey);
        if (cacheData != null) {
            Map cacheDataMap = (Map)SerializationUtils.fromJsonString((String)cacheData, Map.class);
            isv = cacheDataMap.get("isv").toString();
            imageNames = (List)cacheDataMap.get("imageNames");
            vesion = cacheDataMap.get("version").toString();
        } else {
            HashMap<String, Object> newCacheMap = new HashMap<String, Object>();
            LoginMCService loginMCService = LoginMCService.create();
            try {
                boolean hasFile;
                Account currentCenter = LoginAccountFactory.createInstanceByCustom((String)accountId, (String)tenantId).getAccount();
                String jasonValue = LoginUtils.getLoginConfig(imagefileKey, currentCenter, isEnableLoginConfig, IMAGE_MCDATA, tenantId);
                boolean bl = hasFile = StringUtils.isNotEmpty((String)jasonValue) && !"null".equals(jasonValue);
                if (hasFile) {
                    Map data;
                    WebClientFiles clientFiles = loginMCService.getWebClientFiles(tenantId, "_tenant_login_config_" + tenantId + "_imagefile");
                    if (clientFiles != null) {
                        isv = clientFiles.getIsv();
                    }
                    if ((data = (Map)SerializationUtils.fromJsonString((String)jasonValue, Map.class)) != null || data.get("imageNames") != null) {
                        imageNames = (List)data.get("imageNames");
                        newCacheMap.put("imageNames", imageNames);
                        vesion = data.get("version").toString();
                        newCacheMap.put("version", vesion);
                    }
                    newCacheMap.put("isv", isv);
                    CacheLoginData.setAttribute((String)MC, (String)imagefileKey, (String)SerializationUtils.toJsonString(newCacheMap));
                }
            }
            catch (Exception e) {
                logger.error("LoginUtil--getStaticFileImage--error", (Throwable)e);
            }
        }
        if (imageNames != null && StringUtils.isNotEmpty((String)(imageName = imageNames.stream().filter(a -> a.startsWith(image)).findFirst().orElse("")))) {
            String cdnURL = ".";
            StringBuilder sb = new StringBuilder();
            sb.append(cdnURL).append(ISV).append(isv).append("/loginImage/").append(imageName);
            sb.append("?v=").append(vesion);
            return sb.toString();
        }
        return null;
    }

    private static String getImageFullUrl(String path) {
        String imageFullUrl = UrlService.getCheckAuthImageUrl((String)path);
        return EncreptSessionUtils.encryptHttpUrlSession((String)imageFullUrl);
    }

    public static String getIndexHtml(HttpServletRequest request) {
        String cdnURL = ".";
        return LoginUtils.getIndexHtml(request, cdnURL);
    }

    public static String getIndexHtml(HttpServletRequest request, String cdnURL) {
        String path = request.getRequestURI();
        String context = request.getContextPath();
        boolean debug = TRUE_STRING.equals(request.getParameter(KDWEB_DEBUG));
        String debugcdnUrl = LoginUtils.getKDWebCDN(request);
        String startupFileName = "startup";
        long version = System.currentTimeMillis();
        if (!StringUtils.isEmpty((String)debugcdnUrl)) {
            cdnURL = debugcdnUrl;
        } else {
            String configCDNURL = System.getProperty("cdn.server.path");
            if (StringUtils.isNotEmpty((String)configCDNURL)) {
                cdnURL = configCDNURL;
            }
        }
        String xpath = null;
        if (path != null) {
            xpath = path.replace(context + "/", "");
        }
        boolean isMobile = false;
        if (xpath != null && xpath.toLowerCase(Locale.ENGLISH).startsWith("mobile.html")) {
            startupFileName = "startup-m";
            isMobile = true;
        }
        if (debug) {
            startupFileName = startupFileName + "-debug";
        }
        StringBuilder contentBuilder = new StringBuilder();
        boolean hasFile = LoginUtils.hasWebClientFiles();
        String saasJSPath = LoginUtils.getSaasJSPath(request);
        if (isMobile) {
            String customJSPath = hasFile ? "window.__kd_custome_js__ = '" + cdnURL + ISV + LoginUtils.getISVFromWebClientFiles("attachfiles") + "/globalfiles/index_m.js?v=" + version + "';" : "";
            contentBuilder.append("<!DOCTYPE html><html><head><meta charset='UTF-8'><meta http-equiv='Pragma' content='no-cache'>").append("<meta http-equiv='Cache-Control' content='no-cache,no-store'>").append("<meta http-equiv='expires' content='0'><meta http-equiv='Content-Type' content='text/html;charset=utf-8'>").append("<meta content='width=device-width, initial-scale=1.0,minimum-scale=1.0, maximum-scale=1.0, user-scalable=no' name='viewport'>").append("<meta content='yes' name='apple-mobile-web-app-capable'>").append("<meta content='black' name='apple-mobile-web-app-status-bar-style'>").append("<meta content='telephone=no' name='format-detection'>").append("<script>").append("window.__kd_cdnPath__ = '").append(cdnURL).append("';").append(saasJSPath).append(customJSPath).append("</script>").append("<script type='text/javascript'  src='").append(cdnURL).append("/public/js/").append(startupFileName).append(".js?v=").append(version).append("'></script></head></html>");
        } else {
            String titleOrg = ResManager.loadKDString((String)"\u91d1\u8776\u4e91\u661f\u701a", (String)"LoginUtils_15", (String)BOS_LOGIN, (Object[])new Object[0]);
            String welcomeMsgOrg = ResManager.loadKDString((String)"\u6b22\u8fce\u767b\u5f55\u91d1\u8776\u4e91\u661f\u701a", (String)"LoginUtils_16", (String)BOS_LOGIN, (Object[])new Object[0]);
            String icoUrl = cdnURL + "/public/thirdjs/image/favicon.ico?v=" + version;
            String title = "";
            String welcomeMsg = "";
            try {
                String tenantId;
                boolean useTenantConfig;
                Map<String, Object> returnMap = LoginUtils.getCustomDataMap(request);
                String customIcoURL = StringUtils.getStringValue((Object)returnMap.get("tabimg"));
                String langName = LoginUtils.getCurrentLang();
                Map languageWelcomeValue = (Map)returnMap.get("welcomemsg");
                welcomeMsg = languageWelcomeValue == null || languageWelcomeValue.size() == 0 ? welcomeMsgOrg : (languageWelcomeValue.containsKey("") ? welcomeMsgOrg : (StringUtil.isEmpty((String)((String)languageWelcomeValue.get(langName))) ? LoginUtils.getDefaultWelcomeMsg(welcomeMsg, languageWelcomeValue) : StringUtils.getStringValue(languageWelcomeValue.get(langName))));
                Map languageTabwordValue = (Map)returnMap.get("tabword");
                if (languageTabwordValue == null || languageTabwordValue.size() == 0 || languageTabwordValue.containsKey("")) {
                    title = LoginUtils.brandUpTitle(request);
                } else if (StringUtil.isEmpty((String)((String)languageTabwordValue.get(langName)))) {
                    if (StringUtils.isEmpty((String)(title = LoginUtils.getDefaultWelcomeMsg(title, languageTabwordValue)))) {
                        title = LoginUtils.brandUpTitle(request);
                    }
                } else {
                    title = StringUtils.getStringValue(languageTabwordValue.get(langName));
                }
                if (StringUtils.isEmpty((String)title)) {
                    title = titleOrg;
                }
                if (kd.bos.util.StringUtils.isNotEmpty((String)customIcoURL)) {
                    icoUrl = customIcoURL;
                }
                if (StringUtils.isEmpty((String)welcomeMsg)) {
                    welcomeMsg = welcomeMsgOrg;
                }
                if (!(useTenantConfig = LoginUtils.isUseTenantLoginConfig(tenantId = RevProxyUtil.getTenantCode((HttpServletRequest)request)))) {
                    boolean isDefaultIcon = false;
                    String isCosmicUI = request.getParameter("isCosmicUI");
                    String formId = request.getParameter("formId");
                    if (TRUE_STRING.equals(isCosmicUI)) {
                        title = ResManager.loadKDString((String)"\u91d1\u8776\u4e91\u82cd\u7a79", (String)"LoginUtils_10", (String)BOS_LOGIN, (Object[])new Object[0]);
                        isDefaultIcon = true;
                    } else if ("pc_devportal_main".equals(formId)) {
                        title = ResManager.loadKDString((String)"\u91d1\u8776\u4e91\u82cd\u7a79\u5f00\u53d1\u5e73\u53f0", (String)"LoginUtils_11", (String)BOS_LOGIN, (Object[])new Object[0]);
                        isDefaultIcon = true;
                    } else {
                        boolean isDisableBrandUp = LoginUtils.getIsDisableBrandUp(tenantId);
                        boolean enableNewPortal = ParameterService.isSupportNewPortal();
                        if (!isDisableBrandUp && !enableNewPortal) {
                            String appNumber = request.getParameter("appNumber");
                            String pageId = request.getParameter("byPageId");
                            if (StringUtils.isEmpty((String)appNumber) && StringUtils.isNotEmpty((String)pageId)) {
                                appNumber = LoginUtils.getAppIdByPageId(pageId);
                            }
                            if (BrandUpEnum.getTitle((String)appNumber) != null) {
                                title = BrandUpEnum.getTitle((String)appNumber);
                                isDefaultIcon = true;
                            }
                        }
                    }
                    if (isDefaultIcon) {
                        icoUrl = cdnURL + "/public/thirdjs/image/favicon.ico?v=" + version;
                    }
                }
                welcomeMsg = StringUtils.escapeExprSpecialWord((String)welcomeMsg);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
            String customJSPath = hasFile ? "window.__kd_custome_js__ = '" + cdnURL + ISV + LoginUtils.getISVFromWebClientFiles("attachfiles") + "/globalfiles/index.js?v=" + version + "';" : "";
            contentBuilder.append("<!DOCTYPE html><html><head><meta charset='UTF-8'><meta http-equiv='X-UA-Compatible' content='IE=Edge'>").append("<meta http-equiv='Pragma' content='no-cache'><meta http-equiv='Cache-Control' content='no-cache,no-store'>").append("<meta http-equiv='expires' content='0'><meta name='renderer' content='webkit'>").append("<meta name='viewport' content='width=device-width, initial-scale=1'>").append("<title>").append(title).append("</title>").append("<link rel='icon' type='image/x-icon' href='").append(icoUrl).append("' />").append("<script>").append("window.__kd_cdnPath__ = '").append(cdnURL).append("';").append(saasJSPath).append(LoginUtils.appearanceMode()).append("window.__kd_welcomemsg__ = '").append(welcomeMsg).append("';").append(customJSPath).append("</script>").append("<script type='text/javascript'  src='").append(cdnURL).append("/public/js/").append(startupFileName).append(".js?v=").append(version).append("'></script></head></html>");
        }
        return contentBuilder.toString();
    }

    private static String getDefaultWelcomeMsg(String welcomeMsg, Map<String, String> languageWelcomeValue) {
        for (Map.Entry<String, String> languageWelcomeValues : languageWelcomeValue.entrySet()) {
            if (!StringUtil.isEmpty((String)welcomeMsg)) continue;
            String tempWelcomeMsg = languageWelcomeValue.get(ZH_CN);
            if (Objects.nonNull(tempWelcomeMsg) && !tempWelcomeMsg.isEmpty()) {
                welcomeMsg = tempWelcomeMsg;
                break;
            }
            tempWelcomeMsg = languageWelcomeValues.getValue();
            if (languageWelcomeValues.getValue().isEmpty()) continue;
            welcomeMsg = tempWelcomeMsg;
            break;
        }
        return welcomeMsg;
    }

    private static String appearanceMode() {
        try {
            QFilter filter = new QFilter("userid", "=", (Object)RequestContext.get().getCurrUserId());
            DynamicObject userConfig = QueryServiceHelper.queryOne((String)"bos_user_params_config", (String)"appearancemode", (QFilter[])new QFilter[]{filter});
            if (userConfig == null) {
                return "";
            }
            String mode = userConfig.getString("appearancemode");
            if (StringUtils.isNotBlank((String)mode)) {
                return String.format("window.__kd_appearance_mode__ = '%s';", mode);
            }
        }
        catch (Exception e) {
            logger.error("appearanceMode error", (Throwable)e);
        }
        return "";
    }

    private static String getSaasJSPath(HttpServletRequest request) {
        try {
            Account currentCenter = LoginAccountFactory.createInstanceByHttpRequest((HttpServletRequest)request, Optional.empty()).getAccount();
            String saasJSPath = DefaultParameterService.getDefaultParamsConfig((Account)currentCenter, (String)"custom_saas_js_path");
            StringBuilder sb = new StringBuilder("window.__kd_preset_js__ = '");
            return saasJSPath != null ? sb.append(saasJSPath).append("';").toString() : "";
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            return "";
        }
    }

    private static String getCurrentLang() {
        String langName = ZH_CN;
        Lang lang = RequestContext.get().getLang();
        if (lang != null) {
            langName = lang.name();
        }
        return langName;
    }

    private static boolean getIsDisableBrandUp(String tenantId) {
        String isDisableBrandUp = SystemPropertyUtils.getProptyByTenant((String)"cosmic_brandupgrade_restore", (String)tenantId);
        return isDisableBrandUp != null && Boolean.parseBoolean(isDisableBrandUp);
    }

    private static boolean isUseTenantLoginConfig(String tenantId) {
        String value = SystemPropertyUtils.getProptyByTenant((String)"tenant.login.config.share_to_cosmic", (String)tenantId);
        return Boolean.parseBoolean(value);
    }

    private static String brandUpTitle(HttpServletRequest request) {
        String title = "";
        String isCosmicUI = request.getParameter("isCosmicUI");
        String formId = request.getParameter("formId");
        if (TRUE_STRING.equals(isCosmicUI)) {
            title = ResManager.loadKDString((String)"\u91d1\u8776\u4e91\u82cd\u7a79", (String)"LoginUtils_10", (String)BOS_LOGIN, (Object[])new Object[0]);
        } else if ("pc_devportal_main".equals(formId)) {
            title = ResManager.loadKDString((String)"\u91d1\u8776\u4e91\u82cd\u7a79\u5f00\u53d1\u5e73\u53f0", (String)"LoginUtils_11", (String)BOS_LOGIN, (Object[])new Object[0]);
        } else {
            String appNumber = request.getParameter("appNumber");
            String pageId = request.getParameter("byPageId");
            if (StringUtils.isEmpty((String)appNumber) && StringUtils.isNotEmpty((String)pageId)) {
                appNumber = LoginUtils.getAppIdByPageId(pageId);
            }
            if (BrandUpEnum.getTitle((String)appNumber) != null) {
                title = BrandUpEnum.getTitle((String)appNumber);
            }
        }
        return title;
    }

    private static String getAppIdByPageId(String pageId) {
        String appId = null;
        try {
            FormService formService = (FormService)ServiceFactory.getService(FormService.class);
            String config = formService.getConfigByPageId(pageId);
            if (StringUtils.isNotEmpty((String)config)) {
                Map map = (Map)JSONUtils.cast((String)config, Map.class);
                appId = map.get("appId").toString();
            }
        }
        catch (KDException e) {
            logger.info("getAppIdByPageId KDException", (Object)e);
        }
        catch (Exception e) {
            logger.error("getAppIdByPageId error", (Throwable)e);
        }
        return appId;
    }

    public static void createGuestRequestContext(HttpServletRequest request, Account currentCenter) {
        Lang lang = LoginLangUtils.getLoginLanguage((HttpServletRequest)request);
        String address = NetAddressUtils.getRemoteHost((HttpServletRequest)request);
        SessionInfo temp = new SessionInfo();
        temp.setAccountId(currentCenter.getAccountId());
        temp.setTenantId(currentCenter.getTenantId());
        RequestContextCreator.create((HttpServletRequest)request, (String)"temp111", (SessionInfo)temp);
        String sessionId = LoginUtils.getGuestSessionId(currentCenter.getAccountId(), currentCenter.getTenantId(), lang, address);
        SessionInfo si = SessionUtils.getGuestSessionData((String)Instance.getClusterName(), (String)currentCenter.getTenantId(), (String)currentCenter.getAccountId(), (Lang)lang);
        if (si != null) {
            RequestContextCreator.create((HttpServletRequest)request, (String)sessionId, (SessionInfo)si);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getISVFromWebClientFiles(String subffix) {
        String key;
        String isv = "kingdee";
        RequestContext context = RequestContext.get();
        if (context == null) {
            return isv;
        }
        String tenantId = context.getTenantId();
        isv = LoginUtils.getMCDataFromCache(tenantId, key = "_tenant_login_config_" + tenantId + "_" + subffix);
        if (!StringUtils.isEmpty((String)isv)) return isv;
        Class<LoginUtils> clazz = LoginUtils.class;
        synchronized (LoginUtils.class) {
            isv = LoginUtils.getMCDataFromCache(tenantId, key);
            if (!StringUtils.isEmpty((String)isv)) return isv;
            try {
                LoginMCService loginMCService = LoginMCService.create();
                WebClientFiles clientFiles = loginMCService.getWebClientFiles(context.getTenantId(), key);
                if (clientFiles != null) {
                    isv = clientFiles.getIsv();
                }
                LoginUtils.setMCDataFromCache(tenantId, key, isv);
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6ISV\u5931\u8d25", (Throwable)e);
            }
            return isv;
        }
    }

    public static boolean hasWebClientFiles() {
        if (LoginUtils.isMCSystem()) {
            return false;
        }
        boolean hasFile = false;
        String key = "_tenant_login_config_files_";
        try {
            RequestContext context = RequestContext.get();
            if (context != null) {
                String jasonValue = LoginUtils.getMCData(context.getTenantId(), key);
                hasFile = StringUtils.isNotEmpty((String)jasonValue) && !"null".equals(jasonValue);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return hasFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getMCData(String tenantId, String key) throws Exception {
        String jasonValue = LoginUtils.getMCDataFromCache(tenantId, key);
        if (StringUtils.isNotEmpty((String)jasonValue)) {
            return jasonValue;
        }
        Class<LoginUtils> clazz = LoginUtils.class;
        synchronized (LoginUtils.class) {
            jasonValue = LoginUtils.getMCDataFromCache(tenantId, key);
            if (StringUtils.isEmpty((String)jasonValue)) {
                LoginMCService loginMCService = LoginMCService.create();
                jasonValue = loginMCService.getMCData(tenantId, key);
                if (StringUtils.isEmpty((String)jasonValue)) {
                    jasonValue = "null";
                }
                LoginUtils.setMCDataFromCache(tenantId, key, jasonValue);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return jasonValue;
        }
    }

    private static String getMCDataFromCache(String tenantId, String key) {
        return CacheLoginData.getAttribute((String)MC, (String)(key + tenantId));
    }

    private static void setMCDataFromCache(String tenantId, String key, String value) {
        CacheLoginData.setAttribute((String)MC, (String)(key + tenantId), (String)value);
    }

    public static Map<String, String> getUserInfoByUserResult(Lang lang, Account currentCenter, UserAuthResult uar, String user) {
        return LoginUtils.getUserInfoByUserResultByType(lang, currentCenter, uar, user, false);
    }

    public static Map<String, String> getUserInfoByUserResultByType(Lang lang, Account currentCenter, UserAuthResult uar, String user, boolean isWeb) {
        Map userInfo;
        switch (uar.getUserType()) {
            case YunzhijiaUId: {
                userInfo = LoginUserService.getErpUserInfo((Account)currentCenter, (long)Long.parseLong(user), (String)lang.name());
                break;
            }
            case Mobile: {
                userInfo = LoginUserService.getErpUserInfoByPhone((Account)currentCenter, (String)user, (String)lang.name());
                break;
            }
            case Email: {
                userInfo = LoginUserService.getErpUserInfoByEmail((Account)currentCenter, (String)user, (String)lang.name());
                break;
            }
            case WorkerNumber: {
                userInfo = LoginUserService.getErpUserInfoByNumber((Account)currentCenter, (String)user, (String)lang.name());
                break;
            }
            case UserName: {
                userInfo = LoginUserService.getErpUserInfoByUserName((Account)currentCenter, (String)user, (String)lang.name());
                break;
            }
            case UUID: {
                userInfo = LoginUserService.getErpUserInfoByUUID((Account)currentCenter, (String)user, (String)lang.name());
                break;
            }
            case UserId: {
                userInfo = LoginUserService.getErpUserInfoByUserId((Account)currentCenter, (String)user, (String)lang.name());
                break;
            }
            case ThirdUserId: {
                userInfo = LoginUserService.getErpUserInfoByThirdUserId((Account)currentCenter, (String)user, (UserAuthResult)uar, (String)lang.name());
                break;
            }
            default: {
                userInfo = null;
            }
        }
        if (userInfo == null || Constants.NO.equalsIgnoreCase((String)userInfo.get(SUCCESS)) || userInfo.size() < 2) {
            LoginUtils.checkUserEnable(currentCenter, user, uar.getUserType());
            if (isWeb) {
                throw new KDException(Constants.KD_WEB_EXCEPTION, new Object[]{ResManager.loadKDString((String)"\u60a8\u7684\u8d26\u53f7\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728!", (String)"LoginUtils_12", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u60a8\u7684\u8d26\u53f7\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728!", (String)"LoginUtils_12", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
        return userInfo;
    }

    public static boolean isIndexHTML(HttpServletRequest request) {
        boolean isIndexHTML = false;
        String path = request.getRequestURI();
        String context = request.getContextPath();
        String xpath = null;
        if (path != null) {
            xpath = path.replace(context + "/", "");
        }
        if (xpath != null && (xpath.toLowerCase(Locale.ENGLISH).startsWith("index.html") || xpath.toLowerCase(Locale.ENGLISH).startsWith("mobile.html"))) {
            isIndexHTML = true;
        }
        if (!isIndexHTML && xpath != null && StringUtils.isEmpty((String)xpath)) {
            isIndexHTML = true;
        }
        return isIndexHTML;
    }

    public static boolean isEmptyIndexHTML(HttpServletRequest request) {
        boolean isEmpty = false;
        String path = request.getRequestURI();
        String context = request.getContextPath();
        String xpath = null;
        if (path != null) {
            xpath = path.replace(context + "/", "");
        }
        if (xpath != null && StringUtils.isEmpty(xpath)) {
            isEmpty = true;
        }
        return isEmpty;
    }

    public static boolean isPortal(HttpServletRequest request) {
        RequestContext requestContext;
        boolean isPortal = false;
        String path = request.getRequestURI();
        String context = request.getContextPath();
        String xpath = null;
        if (path != null) {
            xpath = path.replace(context + "/", "");
        }
        if (xpath != null && (xpath.toLowerCase(Locale.ENGLISH).startsWith("portal/") || xpath.toLowerCase(Locale.ENGLISH).startsWith("portal") && xpath.toLowerCase(Locale.ENGLISH).endsWith("portal"))) {
            isPortal = true;
        }
        if ((requestContext = RequestContext.get()) != null) {
            Account currentCenter = LoginAccountFactory.createInstanceByRequestContext(Optional.empty()).getAccount();
            if (!isPortal && LoginUtils.isEmptyIndexHTML(request) && LoginUtils.isYZJSpecialVersion(currentCenter)) {
                isPortal = true;
            }
        }
        return isPortal;
    }

    public static boolean isRootLoginPage(HttpServletRequest request) {
        return LoginUtils.isRootPathPage(request, new String[]{"login.html", "login-mobile.html"});
    }

    public static boolean isRootPage(HttpServletRequest request) {
        return LoginUtils.isRootPathPage(request, new String[]{"", "index.html", "mobile.html"});
    }

    public static boolean isRootPathPage(HttpServletRequest request, String[] pagePaths) {
        boolean isRoot = false;
        String context = request.getContextPath();
        String path = request.getRequestURI();
        String xpath = null;
        if (path != null) {
            xpath = path.replace(context + "/", "");
        }
        if (pagePaths != null) {
            for (String page : pagePaths) {
                if (StringUtils.isEmpty((String)page)) {
                    if (!StringUtils.isEmpty((String)xpath)) continue;
                    isRoot = true;
                    break;
                }
                if (!StringUtils.isNotEmpty((String)xpath) || !xpath.toLowerCase(Locale.ENGLISH).startsWith(page.toLowerCase(Locale.ENGLISH))) continue;
                isRoot = true;
                break;
            }
        }
        return isRoot;
    }

    public static void outputString(HttpServletResponse servletResponse, String html) throws IOException {
        servletResponse.setContentType("text/html");
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)servletResponse.getOutputStream(), StandardCharsets.UTF_8);){
            writer.write(html);
            writer.flush();
        }
        catch (IOException e) {
            logger.debug(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    public static void allowCrossDomain(HttpServletRequest request, HttpServletResponse response) {
        String realOrigin = LoginUtils.getAllowOrigin(request);
        response.setHeader("Access-Control-Allow-Origin", realOrigin);
        String allowHeaders = request.getHeader("Access-Control-Request-Headers");
        String allowHeaderString = SystemPropertyUtils.getProptyByTenant((String)"Access-Control-Request-Headers", (String)RevProxyUtil.getTenantCode((HttpServletRequest)request));
        if (StringUtils.isNotEmpty((String)allowHeaderString)) {
            allowHeaders = allowHeaderString;
        } else if (SecurityUtils.checkXss((String)allowHeaders)) {
            allowHeaders = "";
        }
        response.setHeader("Access-Control-Allow-Headers", allowHeaders);
        response.setHeader("Access-Control-Allow-Credentials", TRUE_STRING);
        String allowMethods = request.getHeader("Access-Control-Request-Method");
        String allowMethodString = SystemPropertyUtils.getProptyByTenant((String)"Access-Control-Allow-Methods", (String)RevProxyUtil.getTenantCode((HttpServletRequest)request));
        if (StringUtils.isNotEmpty((String)allowMethodString)) {
            allowMethods = allowMethodString;
        } else if (SecurityUtils.checkXss((String)allowMethods)) {
            allowMethods = "";
        }
        response.setHeader("Access-Control-Allow-Methods", allowMethods);
        String reqOrigin = request.getHeader(ORIGIN_STRING);
        String reqReferer = request.getHeader(REFERER_STRING);
        String tenantNo = RevProxyUtil.getTenantCode((HttpServletRequest)request);
        if (realOrigin.length() > 2 && LoginUtils.isNeedCheckRefererURL(request)) {
            boolean isOK = false;
            if (StringUtils.isNotEmpty((String)reqReferer) && reqReferer.toLowerCase(Locale.ENGLISH).startsWith(realOrigin.toLowerCase(Locale.ENGLISH))) {
                isOK = true;
            }
            if (isOK && StringUtils.isNotEmpty((String)reqOrigin)) {
                isOK = realOrigin.toLowerCase(Locale.ENGLISH).startsWith(reqOrigin.toLowerCase(Locale.ENGLISH));
            }
            if (!isOK) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{String.format(ResManager.loadKDString((String)"\u975e\u6cd5\u8de8\u8d8a\u8bbf\u95ee\u3002", (String)"LoginUtils_22", (String)BOS_LOGIN, (Object[])new Object[0]), tenantNo)});
            }
        }
    }

    private static String getAllowOrigin(HttpServletRequest req) {
        String origin = "*";
        String tenantNo = RevProxyUtil.getTenantCode((HttpServletRequest)req);
        String originString = SystemPropertyUtils.getProptyByTenant((String)"api.allow.origin", (String)tenantNo);
        if (StringUtils.isNotEmpty((String)originString)) {
            String[] oArray = originString.split(",");
            String reqReferer = req.getHeader(REFERER_STRING);
            boolean isOk = false;
            for (String oString : oArray) {
                if (oString == null || reqReferer == null || !reqReferer.toLowerCase(Locale.ENGLISH).startsWith(oString.toLowerCase(Locale.ENGLISH))) continue;
                origin = oString;
                isOk = true;
                break;
            }
            if (!isOk) {
                origin = oArray[0];
            }
        }
        return RevProxyUtil.removeSlash((String)origin);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeResponseStream(HttpServletRequest request, HttpServletResponse response, File lastFile, String fileName) throws IOException {
        String contentType = request.getServletContext().getMimeType(fileName);
        response.setContentType(contentType + ";charset=UTF-8");
        response.setHeader(CONTENT_DISPOSITION, ATTACHMENT_FILENAME + URLEncoder.encode(fileName, UPPER_UTF_8) + "\"");
        if (fileName != null && fileName.toLowerCase(Locale.ENGLISH).endsWith(".js")) {
            try (InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(lastFile), StandardCharsets.UTF_8);){
                StringBuilder sb = new StringBuilder();
                char[] chars = new char[1];
                while (isr.read(chars) != -1) {
                    sb.append(chars);
                }
                ServletOutputStream os = response.getOutputStream();
                if (os == null) return;
                os.write(sb.toString().getBytes(StandardCharsets.UTF_8));
                os.flush();
                os.close();
                return;
            }
        }
        try (FileInputStream inputStream = new FileInputStream(lastFile);){
            ServletOutputStream os = response.getOutputStream();
            byte[] b = new byte[2048];
            int temp = 0;
            if (os == null) return;
            while ((temp = ((InputStream)inputStream).read(b)) != -1) {
                os.write(b, 0, temp);
            }
            os.flush();
            os.close();
            return;
        }
    }

    @Deprecated
    public static String getAccountIdByCookie(String globalSessionId) {
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)globalSessionId);
        Map sessionInfo = sessionDAO.getAttributesAsMap(new String[]{"tenantId", "sandboxId", "language", USER_ID, "userName", "userOpenId", "orgId", "userType", "yzjAppId", "yzjAppTicket", ACCOUNT_ID, "uid"});
        String accountId = null;
        if (sessionInfo != null) {
            accountId = (String)sessionInfo.get(ACCOUNT_ID);
        }
        return accountId;
    }

    public static void setCachkeyData(Account currentCenter) {
        if (currentCenter == null) {
            return;
        }
        Map cacheKey = CacheLoginData.getCache((String)CacheLoginData.getType4YzjEKey((String)currentCenter.getAccountId()));
        if (cacheKey == null || cacheKey.size() == 0) {
            LoginUtils.resetDateKey(currentCenter);
        } else if (cacheKey.get(KEY_DATA) != null && !((String)cacheKey.get(KEY_DATA)).equals(currentCenter.getKeyFile())) {
            LoginUtils.resetDateKey(currentCenter);
        }
    }

    private static void resetDateKey(Account currentCenter) {
        if (currentCenter == null) {
            return;
        }
        HashMap<String, String> mpYzjEidKeyData = new HashMap<String, String>(8);
        mpYzjEidKeyData.put("Eid", currentCenter.getEid());
        mpYzjEidKeyData.put(KEY_DATA, currentCenter.getKeyFile());
        CacheLoginData.setAttributes((String)CacheLoginData.getType4YzjEKey((String)currentCenter.getAccountId()), mpYzjEidKeyData);
    }

    public static String loginByGuestUser(HttpServletRequest request, HttpServletResponse response) {
        String userSessionId = null;
        String userId = LoginUtils.getParamerter(request, USER_ID);
        if ("Guest".equalsIgnoreCase(userId)) {
            String tenantId = RevProxyUtil.getTenantCode((HttpServletRequest)request);
            String loginType = LoginUtils.getParamerter(request, "logintype");
            LoginClientEnum lType = LoginClientEnum.WEB;
            if ("mobile".equalsIgnoreCase(loginType)) {
                lType = LoginClientEnum.MOBILE;
            }
            userSessionId = LoginUtils.getGuestGloalSessionId(request, response, false);
        }
        return userSessionId;
    }

    @Deprecated
    public static String handleAPIByGuestUser(ServletRequest servletRequest, HttpServletResponse response) {
        String userSessionId = null;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        if (LoginUtils.isAPIGuestUrl(request)) {
            Account currentCenter = LoginAccountFactory.createInstanceByPostRequest((HttpServletRequest)request, (HttpServletResponse)response, Optional.empty()).getAccount();
            Map<String, String> user = LoginUtils.getClientUserInfo(currentCenter.getTenantId());
            LoginClientEnum lType = LoginClientEnum.WEB;
            userSessionId = SessionUtils.createNewSession((HttpServletRequest)request, (HttpServletResponse)response, (Account)currentCenter, (Lang)LoginLangUtils.getLoginLanguage((HttpServletRequest)request), (String)NetAddressUtils.getRemoteHost((HttpServletRequest)request), user, (LoginClientEnum)lType, (int)ThirdAPIAPPUtils.getTokenTimeout((String)currentCenter.getTenantId()), (boolean)false);
        }
        return userSessionId;
    }

    private static boolean isAPIGuestUrl(HttpServletRequest request) {
        boolean isGuestAPI = false;
        String path = request.getRequestURI();
        String xpath = null;
        if (path != null) {
            xpath = LoginUtils.getPath(request);
        }
        for (String url : API_GUEST_USER_LIST) {
            if (!LoginUtils.isIncludeURl(xpath, url)) continue;
            isGuestAPI = true;
            break;
        }
        return isGuestAPI;
    }

    public static boolean isIncludeURl(String path, String url) {
        boolean isGuest = false;
        if (path != null && path.startsWith(url)) {
            isGuest = true;
        }
        return isGuest;
    }

    @SdkInternal
    public static Map<String, String> getClientUserInfo(String tenantId) {
        HashMap<String, String> user = new HashMap<String, String>(8);
        user.put("forgid", "0");
        user.put("fid", "-1");
        user.put("ftruename", "Guest");
        user.put("fopenid", "");
        user.put("userType", "1");
        user.put("tenantId", tenantId);
        return user;
    }

    @SdkInternal
    public static String getParamerter(HttpServletRequest request, String parameter) {
        String returnValue = null;
        String parameterValue = request.getHeader(parameter);
        if (StringUtils.isEmpty((String)parameterValue)) {
            parameterValue = request.getParameter(parameter);
        }
        if (StringUtils.isNotEmpty((String)parameterValue)) {
            returnValue = parameterValue;
        }
        return returnValue;
    }

    public static SessionInfo getSessinInfoBySessionId(String sessionId) {
        Map sessionInfo = null;
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)sessionId);
        SessionInfo si = null;
        sessionInfo = sessionDAO.getAttributesAsMap(new String[]{"tenantId", "sandboxId", "language", USER_ID, "userName", "userOpenId", "orgId", "userType", "yzjAppId", "yzjAppTicket", "kdCsrfToken", ACCOUNT_ID, "uid", "loginIP", loginOrg, "client", "accCompanyId"});
        if (sessionInfo != null && sessionInfo.size() > 0) {
            String tenantId = (String)sessionInfo.get("tenantId");
            String sandboxId = (String)sessionInfo.get("sandboxId");
            String userId = (String)sessionInfo.get(USER_ID);
            long orgId = 0L;
            if (!StringUtils.isEmpty((String)((String)sessionInfo.get("orgId")))) {
                orgId = Long.parseLong((String)sessionInfo.get("orgId"));
            }
            if (tenantId != null && userId != null) {
                String lang = (String)sessionInfo.get("language");
                String userName = (String)sessionInfo.get("userName");
                String userOpenId = (String)sessionInfo.get("userOpenId");
                String userType = (String)sessionInfo.get("userType");
                String yzjAppId = (String)sessionInfo.get("yzjAppId");
                String yzjAppTicket = (String)sessionInfo.get("yzjAppTicket");
                String uId = (String)sessionInfo.get("uid");
                String loginOrg = (String)sessionInfo.get(loginOrg);
                String accountId = "";
                if (sessionInfo.get(ACCOUNT_ID) != null) {
                    accountId = (String)sessionInfo.get(ACCOUNT_ID);
                }
                si = new SessionInfo();
                si.setTenantId(tenantId);
                si.setSandboxId(sandboxId);
                si.setOrgId(String.valueOf(orgId));
                si.setUserId(userId);
                si.setUserName(userName);
                si.setUserOpenId(userOpenId);
                si.setUserType(userType);
                si.setYzjAppId(yzjAppId);
                si.setYzjAppTicket(yzjAppTicket);
                si.setLanguage(lang);
                si.setUid(uId);
                if (loginOrg != null) {
                    si.setLoginOrg(loginOrg);
                }
                if (kd.bos.util.StringUtils.isNotEmpty((String)((String)sessionInfo.get("loginIP")))) {
                    si.setLoginIP((String)sessionInfo.get("loginIP"));
                }
                if (kd.bos.util.StringUtils.isNotEmpty((String)((String)sessionInfo.get("client")))) {
                    si.setClient((String)sessionInfo.get("client"));
                }
                si.setAccountId(accountId);
            }
        }
        return si;
    }

    public static boolean isHandledByMCFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) {
        boolean isHandled = false;
        try {
            boolean isPrivateClould;
            if (LoginUtils.isMCSystem() && (isPrivateClould = LoginUtils.isPrivateClould())) {
                String path = request.getServletPath();
                if (path.contains("login-mc.html") || path.contains("dataBaseSetting.html") || path.contains("dbSetting.do") || path.contains("/mc/")) {
                    request.getParameter("test");
                    filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                    isHandled = true;
                }
                if (!isHandled) {
                    String tenantCode = RevProxyUtil.getTenantCode((HttpServletRequest)request);
                    String dbString = System.getProperty(String.format(MC_TENANT_ALLDATA_KEY, tenantCode));
                    String accountIdParameter = "";
                    if (StringUtils.isEmpty((String)dbString)) {
                        String mainWebSite = RevProxyUtil.getURLContextPath((HttpServletRequest)request);
                        if (mainWebSite == null) {
                            mainWebSite = "";
                        }
                        String redirectTo = String.format("%sdataBaseSetting.html", mainWebSite);
                        HttpUtils.sendRedirect((HttpServletRequest)request, (HttpServletResponse)response, (String)redirectTo);
                        isHandled = true;
                    }
                    if (LoginUtils.isIndexHTML(request)) {
                        boolean isNeedRedirect = false;
                        if (StringUtils.isNotEmpty((String)request.getParameter("formId"))) {
                            if ("pc_main_console".equals(request.getParameter("formId"))) {
                                isNeedRedirect = true;
                            }
                        } else {
                            isNeedRedirect = true;
                        }
                        if (isNeedRedirect) {
                            String mainWebSite = RevProxyUtil.getURLContextPath((HttpServletRequest)request);
                            String redirectTo = mainWebSite + "?formId=mc_main_console#/dform?formId=mc_main_console";
                            HttpUtils.sendRedirect((HttpServletRequest)request, (HttpServletResponse)response, (String)redirectTo);
                            isHandled = true;
                        }
                    }
                }
            }
        }
        catch (KDException ex) {
            logger.debug(ex.getMessage());
            ErrorCode code = ex.getErrorCode();
            String resp = "";
            try {
                resp = LoginUtils.getLoginResponse(String.valueOf(code.getCode()), ex.getMessage());
                ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)resp);
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            KDException kd = new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01\n", (String)"LoginUtils_13", (String)BOS_LOGIN, (Object[])new Object[0])});
            try {
                String resp = LoginUtils.getLoginResponse(String.valueOf(kd.getErrorCode().getCode()), kd.getMessage());
                ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)resp);
            }
            catch (IOException e1) {
                logger.error((Throwable)e1);
            }
        }
        return isHandled;
    }

    public static boolean isPrivateClould() {
        boolean isPrivateClould = false;
        String configue = System.getProperty("tenant.code.type");
        TenantConfigTypeEnum configType = TenantConfigTypeEnum.getTenantConfigTypeByString((String)configue);
        if (TenantConfigTypeEnum.config.equals((Object)configType)) {
            isPrivateClould = true;
        }
        return isPrivateClould;
    }

    public static boolean isMCSystem() {
        boolean isMCSystem = false;
        String isMC = System.getProperty("isMC");
        if (isMC != null && TRUE_STRING.equals(isMC.trim().toLowerCase(Locale.ENGLISH))) {
            isMCSystem = true;
        }
        return isMCSystem;
    }

    public static boolean isMCSingleMode() {
        boolean isMCSingleMode = false;
        String isMC = LoginUtils.getProperty("lightweightdeploy");
        if (isMC != null && TRUE_STRING.equals(isMC.trim().toLowerCase(Locale.ENGLISH))) {
            isMCSingleMode = true;
        }
        return isMCSingleMode;
    }

    public static String getProperty(String string) {
        String returnValue = System.getenv(string);
        if (StringUtils.isEmpty((String)returnValue)) {
            returnValue = System.getProperty(string);
        }
        return returnValue;
    }

    public static boolean isSelfEnvironment(String url, HttpServletRequest request) {
        boolean isSelf = true;
        if (StringUtils.isNotEmpty((String)url)) {
            String localUrl = UrlService.getDomainContextUrlByTenantCode((String)RevProxyUtil.getTenantCode((HttpServletRequest)request));
            if (StringUtils.isNotEmpty((String)localUrl) && localUrl.endsWith("/")) {
                localUrl = localUrl.substring(0, localUrl.length() - 1);
            }
            if (StringUtils.isNotEmpty((String)localUrl)) {
                boolean isOK = true;
                if (LoginUtils.startHttps(url)) {
                    if (LoginUtils.startHttps(localUrl)) {
                        if (!url.toLowerCase(Locale.ENGLISH).startsWith(localUrl.toLowerCase(Locale.ENGLISH))) {
                            isOK = false;
                        }
                    } else if (!LoginUtils.removeHttps(url).toLowerCase(Locale.ENGLISH).startsWith(localUrl.toLowerCase(Locale.ENGLISH))) {
                        isOK = false;
                    }
                }
                if (isOK && LoginUtils.startHttp(url)) {
                    if (LoginUtils.startHttp(localUrl)) {
                        if (!url.toLowerCase(Locale.ENGLISH).startsWith(localUrl.toLowerCase(Locale.ENGLISH))) {
                            isOK = false;
                        }
                    } else if (!LoginUtils.removeHttp(url).toLowerCase(Locale.ENGLISH).startsWith(localUrl.toLowerCase(Locale.ENGLISH))) {
                        isOK = false;
                    }
                }
                if (!isOK) {
                    isSelf = false;
                }
            }
        }
        return isSelf;
    }

    public static boolean isSelfEnvironment(String url, HttpServletRequest request, HttpServletResponse response) {
        boolean isSelf = true;
        if (StringUtils.isNotEmpty((String)url)) {
            String localUrl = UrlService.getDomainContextUrlByTenantCode((String)RevProxyUtil.getTenantCode((HttpServletRequest)request));
            if (StringUtils.isNotEmpty((String)localUrl) && localUrl.endsWith("/")) {
                localUrl = localUrl.substring(0, localUrl.length() - 1);
            }
            String encodeLocalUrl = localUrl;
            if (StringUtils.isNotEmpty((String)localUrl)) {
                encodeLocalUrl = response.encodeRedirectURL(response.encodeRedirectURL(localUrl));
                boolean isOK = true;
                if (LoginUtils.startHttps(url)) {
                    if (LoginUtils.startHttps(localUrl)) {
                        if (!url.toLowerCase(Locale.ENGLISH).startsWith(localUrl.toLowerCase(Locale.ENGLISH)) && !url.toLowerCase(Locale.ENGLISH).startsWith(encodeLocalUrl.toLowerCase(Locale.ENGLISH))) {
                            isOK = false;
                        }
                    } else if (!LoginUtils.removeHttps(url).toLowerCase(Locale.ENGLISH).startsWith(localUrl.toLowerCase(Locale.ENGLISH)) && !LoginUtils.removeHttps(url).toLowerCase(Locale.ENGLISH).startsWith(encodeLocalUrl.toLowerCase(Locale.ENGLISH))) {
                        isOK = false;
                    }
                }
                if (isOK && LoginUtils.startHttp(url)) {
                    if (LoginUtils.startHttp(localUrl)) {
                        if (!url.toLowerCase(Locale.ENGLISH).startsWith(localUrl.toLowerCase(Locale.ENGLISH)) && !url.toLowerCase(Locale.ENGLISH).startsWith(encodeLocalUrl.toLowerCase(Locale.ENGLISH))) {
                            isOK = false;
                        }
                    } else if (!LoginUtils.removeHttp(url).toLowerCase(Locale.ENGLISH).startsWith(localUrl.toLowerCase(Locale.ENGLISH)) && !LoginUtils.removeHttp(url).toLowerCase(Locale.ENGLISH).startsWith(encodeLocalUrl.toLowerCase(Locale.ENGLISH))) {
                        isOK = false;
                    }
                }
                if (!isOK) {
                    isSelf = false;
                }
            }
        }
        return isSelf;
    }

    public static boolean isSelfEnvironmentNew(String url, HttpServletRequest request, HttpServletResponse response) {
        boolean urlFlag;
        boolean bl = urlFlag = url.startsWith(HTTP_START_STRING) || url.startsWith(HTTPS_START_STRING);
        if (!urlFlag) {
            logger.error("error url" + url);
            return false;
        }
        return LoginUtils.isSelfEnvironment(url, request, response);
    }

    private static String removeHttps(String url) {
        String returnValue = url;
        if (StringUtils.isNotEmpty((String)url) && LoginUtils.startHttps(url)) {
            int length = HTTPS_START_STRING.length();
            returnValue = url.substring(length);
        }
        return returnValue;
    }

    private static String removeHttp(String url) {
        String returnValue = url;
        if (StringUtils.isNotEmpty((String)url) && LoginUtils.startHttp(url)) {
            int length = HTTP_START_STRING.length();
            returnValue = url.substring(length);
        }
        return returnValue;
    }

    private static boolean startHttps(String url) {
        return LoginUtils.startWithPrefix(url, HTTPS_START_STRING);
    }

    private static boolean startHttp(String url) {
        return LoginUtils.startWithPrefix(url, HTTP_START_STRING);
    }

    private static boolean startWithPrefix(String url, String prefix) {
        boolean returnValue = false;
        if (StringUtils.isNotEmpty((String)url) && url.toLowerCase(Locale.ENGLISH).trim().startsWith(prefix)) {
            returnValue = true;
        }
        return returnValue;
    }

    public static String getLoginPage(HttpServletRequest request) {
        StringBuilder startUpPath = new StringBuilder("<!DOCTYPE html><html><head><meta charset='UTF-8'><meta http-equiv='X-UA-Compatible' content='IE=Edge'><meta http-equiv='Pragma' content='no-cache'><meta http-equiv='Cache-Control' content='no-cache,no-store'><meta http-equiv='expires' content='0'><meta name='renderer' content='webkit'><meta name='viewport' content='width=device-width, initial-scale=1'>");
        startUpPath.append(LoginUtils.getLoginCustomJSPath(request, "login_index.js"));
        String jsPath = LoginUtils.getLoginJsPath(request);
        if (StringUtils.isNotEmpty((String)jsPath)) {
            startUpPath.append(jsPath);
        } else {
            startUpPath.append(" <script type='text/javascript' src='./login/js/startup.js?v=%s'></script> ");
        }
        startUpPath.append(" </head></html>");
        return String.format(startUpPath.toString(), StringUtils.randomNumber((int)8));
    }

    private static String getLoginCustomJSPath(HttpServletRequest request, String fileName) {
        String tenantId = RevProxyUtil.getTenantCode((HttpServletRequest)request);
        if (StringUtils.isEmpty((String)tenantId)) {
            logger.info("\u975e\u6cd5\u8bbf\u95ee");
            return "";
        }
        try {
            boolean hasFile;
            String jasonValue = LoginUtils.getMCData(tenantId, "_tenant_loginpage_config_files_");
            boolean bl = hasFile = StringUtils.isNotEmpty((String)jasonValue) && !"null".equals(jasonValue);
            if (hasFile) {
                String isv = LoginUtils.getISVFromWebClientFiles(LOGINPAGE_ATTACH_FILES);
                long version = System.currentTimeMillis();
                String cdnURL = ".";
                StringBuilder sb = new StringBuilder();
                sb.append("<script>window.__kd_custome_js__ = '").append(cdnURL).append(ISV).append(isv).append("/logincustomjs/").append(fileName).append("?v=").append(version).append("';</script>");
                return sb.toString();
            }
        }
        catch (Exception e) {
            logger.error("LoginUtil--getLoginIndexJs--error", (Throwable)e);
        }
        return "";
    }

    public static String getLoginMobilePage(HttpServletRequest request) {
        StringBuilder startUpPath = new StringBuilder("<!DOCTYPE html><html><head><meta http-equiv='Pragma' content='no-cache'><meta http-equiv='Cache-Control' content='no-cache,no-store'><meta http-equiv='expires' content='0'><meta http-equiv='Content-Type' content='text/html;charset=utf-8'><meta content='width=device-width, initial-scale=1.0,minimum-scale=1.0, maximum-scale=1.0, user-scalable=no' name='viewport'><meta content='yes' name='apple-mobile-web-app-capable'><meta content='black' name='apple-mobile-web-app-status-bar-style'><meta content='telephone=no' name='format-detection'>");
        startUpPath.append(LoginUtils.getLoginCustomJSPath(request, "login_index_m.js"));
        String jsPath = LoginUtils.getLoginMobileJsPath(request);
        if (StringUtils.isNotEmpty((String)jsPath)) {
            startUpPath.append(jsPath);
        } else {
            startUpPath.append(" <script type='text/javascript' src='./login/js/startup-m.js?v=%s'></script> ");
        }
        startUpPath.append(" </head></html>");
        return String.format(startUpPath.toString(), StringUtils.randomNumber((int)8));
    }

    public static void outputSMSError(HttpServletResponse servletResponse, String message) throws IOException {
        HashMap<String, Object> mpDatampData = new HashMap<String, Object>(8);
        mpDatampData.put(SUCCESS, false);
        mpDatampData.put("msg", message);
        String result = JSONUtils.toString(mpDatampData);
        ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
    }

    public static boolean getIgnoreWS() {
        boolean isIgnore = false;
        String isIgnoreString = System.getProperty("WS_ignore_login");
        if (StringUtils.isNotEmpty((String)isIgnoreString) && TRUE_STRING.equals(isIgnoreString.toLowerCase(Locale.ENGLISH).trim())) {
            isIgnore = true;
        }
        return isIgnore;
    }

    public static boolean getIsNeedFactor(Account currentCenter, HttpServletRequest servletRequest, Map<String, Object> userMap) {
        boolean isNeed = false;
        String userName = servletRequest.getParameter(Constants.LOGIN_USER_KEY);
        String tenantAlias = RevProxyUtil.getTenantCode((HttpServletRequest)servletRequest);
        String isNeedString = System.getProperty(tenantAlias + ".need.new.factor");
        if (kd.bos.util.StringUtils.isNotEmpty((String)userName) && LoginUtils.checkLdapLogin(currentCenter, userName)) {
            return false;
        }
        if (StringUtils.isNotEmpty((String)isNeedString)) {
            if (TRUE_STRING.equals(isNeedString.toLowerCase(Locale.ENGLISH).trim())) {
                isNeed = true;
            } else if ("alluser".equals(isNeedString.toLowerCase(Locale.ENGLISH).trim())) {
                isNeed = true;
            } else if ("administrator".equals(isNeedString.toLowerCase(Locale.ENGLISH).trim()) && StringUtils.isNotEmpty((String)userName) && AdminUtils.getAdminList().contains(userName)) {
                isNeed = true;
            }
        }
        if (!isNeed && userMap != null && userMap.get(USER_ID) != null) {
            String userId = (String)userMap.get(USER_ID);
            Map passwordStrategy = PswStrategyService.getPasswordStrategyByUserId((Account)currentCenter, userMap);
            if (null == passwordStrategy) {
                return isNeed;
            }
            if (null != passwordStrategy.get("floginoptions") && "2".equals(passwordStrategy.get("floginoptions"))) {
                isNeed = true;
            }
            if (null != passwordStrategy.get("floginoptions") && "4".equals(passwordStrategy.get("floginoptions"))) {
                isNeed = true;
            } else if (null != passwordStrategy.get("floginoptions") && "3".equals(passwordStrategy.get("floginoptions"))) {
                isNeed = false;
            } else if (null != passwordStrategy.get("fenablesmscode") && "1".equals(passwordStrategy.get("fenablesmscode"))) {
                Integer smsCount = ObjectUtils.isEmpty(passwordStrategy.get("fsmscount")) ? 0 : Integer.parseInt(passwordStrategy.get("fsmscount").toString());
                int times = StrategeUtils.getPasswordWrongTimes((Account)currentCenter, (String)userId, (String)LoginClientEnum.WEB.toString());
                if (smsCount != 0 && times >= smsCount) {
                    isNeed = true;
                }
            }
        }
        return isNeed;
    }

    public static String getExistsCachkey(String keyId) {
        String sessionId = null;
        if (keyId != null) {
            sessionId = Instance.getClusterName() + "_" + keyId;
        }
        return sessionId;
    }

    public static boolean checkPassword(String password, String oldPassword) {
        boolean passed = false;
        if (password != null && oldPassword != null && PasswordEncryptUtil.checkPasswordWithSalt((String)"1234", (String)password, (String)oldPassword)) {
            passed = true;
        }
        return passed;
    }

    public static boolean isMultipart(HttpServletRequest request) {
        if (!POST.equals(request.getMethod().toLowerCase(Locale.ENGLISH))) {
            return false;
        }
        String contentType = request.getContentType();
        return contentType != null && contentType.toLowerCase(Locale.ENGLISH).startsWith("multipart/");
    }

    public static boolean isHandledUrlMap(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean isHandled = false;
        String path = request.getRequestURI();
        String context = request.getContextPath();
        String xpath = null;
        if (path != null) {
            xpath = path.replace(context, "");
        }
        for (Map.Entry<String, String> values : FORWORD_URL_MAPPING.entrySet()) {
            if (!LoginUtils.isIncludeURl(xpath, values.getKey())) continue;
            RequestDispatcher rd = request.getRequestDispatcher(values.getValue());
            rd.forward((ServletRequest)request, (ServletResponse)response);
            isHandled = true;
            break;
        }
        return isHandled;
    }

    public static boolean isYZJSpecialVersion(Account currentCenter) {
        return YZJSpecialUtils.isYZJSpecialVersion((Account)currentCenter);
    }

    public static String getAPPId(HttpServletRequest request) {
        String appId = request.getParameter("client_id");
        if (StringUtils.isEmpty((String)appId) && StringUtils.isEmpty((String)(appId = request.getParameter("appid")))) {
            appId = request.getParameter("appId");
        }
        return appId;
    }

    public static String getPathString(String path) {
        String remoteFile = path;
        if (path != null && !path.endsWith("/")) {
            remoteFile = path + "/";
        }
        return remoteFile;
    }

    public static void outputPortalString(HttpServletRequest request, HttpServletResponse response) throws IOException {
        StringBuilder sb = new StringBuilder();
        RequestContext context = RequestContext.get();
        Account currentCenter = null;
        if (context != null) {
            currentCenter = LoginAccountFactory.createInstanceByRequestContext(Optional.empty()).getAccount();
        }
        if (currentCenter != null && LoginUtils.isYZJSpecialVersion(currentCenter)) {
            String lgtk = LoginUtils.getYZJLKCache(context.getUserId());
            String yzjUrl = YZJSpecialUtils.getYZJHost((Account)currentCenter) + "yzj-layout/cosmic/?parentOrigin=" + RevProxyUtil.getURLContextPath((HttpServletRequest)request) + "index.html";
            if (StringUtils.isNotEmpty((String)lgtk)) {
                yzjUrl = YZJSpecialUtils.getYZJHost((Account)currentCenter) + "snsapi/oauth/login?lgtk=" + lgtk + "&to=/yzj-layout/cosmic/?parentOrigin=" + URLEncoder.encode(RevProxyUtil.getURLContextPath((HttpServletRequest)request) + "index.html", UPPER_UTF_8);
                LoginUtils.setYZJLKCache(context.getUserId(), "", 0);
            }
            sb.append("<!DOCTYPE html>");
            sb.append("<html lang=\"en\">");
            sb.append("<head>");
            sb.append("    <meta charset=\"UTF-8\">");
            sb.append("    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">");
            sb.append("    <meta http-equiv=\"X-UA-Compatible\" content=\"ie=edge\">");
            sb.append("    <meta name=\"renderer\" content=\"webkit\">");
            sb.append("    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">");
            sb.append("    <link rel=\"icon\" type=\"image/x-icon\" href=\"./public/thirdjs/image/favicon.ico?v=1562634407027\">");
            sb.append("<title>Kingdee cosmic</title>");
            sb.append("</head>");
            sb.append("<body style=\"padding: 0;margin: 0;overflow: hidden\">");
            sb.append("  <iframe style=\"width:100vw;height:100vh;border:none;\" src=\"PotalReplacedUrl\"></iframe> ");
            sb.append("</body>");
            sb.append("</html>");
            LoginUtils.outputString(response, sb.toString().replace("PotalReplacedUrl", yzjUrl));
        }
    }

    public static String getWebServiceAccessToken(HttpServletRequest request) {
        String accessToken = null;
        if (request != null && POST.equalsIgnoreCase(request.getMethod())) {
            String body = null;
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));
                body = LoginUtils.read(reader);
                if (!StringUtils.isEmpty((String)body)) {
                    SOAPMessage soapMessage = MessageFactory.newInstance().createMessage(null, (InputStream)new ByteArrayInputStream(body.getBytes(UPPER_UTF_8)));
                    accessToken = SOAPUtils.getAccessTokenFromSOAP((SOAPMessage)soapMessage);
                }
                reader.close();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
            catch (SOAPException e) {
                logger.error((Throwable)e);
            }
        }
        return accessToken;
    }

    public static String read(Reader reader) throws IOException {
        String value = "";
        try (StringWriter writer = new StringWriter();){
            LoginUtils.write(reader, writer);
            value = writer.getBuffer().toString();
        }
        return value;
    }

    private static long write(Reader reader, Writer writer) throws IOException {
        return LoginUtils.write(reader, writer, 8192);
    }

    private static long write(Reader reader, Writer writer, int bufferSize) throws IOException {
        int read;
        long total = 0L;
        char[] buf = new char[bufferSize];
        while ((read = reader.read(buf)) != -1) {
            writer.write(buf, 0, read);
            total += (long)read;
        }
        return total;
    }

    @SdkInternal
    public static String getKDCookieValue(HttpServletRequest request) {
        return LoginUtils.getKDCookieValue(request, null);
    }

    private static String sessionCompatible(String tenantId, HttpServletRequest request, Cookie[] cookies) {
        if (SessionKeys.isAccountSession((String)tenantId)) {
            if (cookies == null || cookies.length < 1) {
                return null;
            }
            StringBuffer url = request.getRequestURL();
            String requestURI = url.append("?").append(request.getQueryString()).toString();
            logger.info("url--->" + requestURI);
            List<String> patchList = LoginUtils.getAccountCookiesWhitePath(tenantId);
            boolean match = patchList.stream().anyMatch(requestURI::contains);
            if (!match) {
                return null;
            }
            Optional<String> cookie = LoginUtils.getSessionFromCookie(tenantId, cookies);
            return cookie.orElse(null);
        }
        return null;
    }

    private static List<String> getAccountCookiesWhitePath(String tenantId) {
        String path = SystemPropertyUtils.getProptyByTenant((String)"svc_login_account_session_path", (String)tenantId);
        if (StringUtils.isEmpty((String)path)) {
            return Collections.emptyList();
        }
        String[] split = path.split(",");
        List<String> patchList = Arrays.asList(split);
        return patchList;
    }

    public static Optional<String> getSessionFromCookie(String tenantId, Cookie[] cookies) {
        Set<String> cookieSessionKeys = LoginUtils.getAllSessionKeys(tenantId);
        Optional<String> cookie = Arrays.stream(cookies).filter(c -> cookieSessionKeys.contains(c.getName())).map(Cookie::getValue).findFirst();
        return cookie;
    }

    private static Set<String> getAllSessionKeys(String tenantId) {
        List allAccounts = AccountUtils.getAllAccounts((String)tenantId);
        TreeSet<String> keys = new TreeSet<String>();
        allAccounts.forEach(account -> keys.add("KERPSESSIONID" + tenantId + account.getAccountId()));
        return keys;
    }

    public static boolean isSRMAPI(HttpServletRequest request) {
        boolean isSRMAPI = false;
        String path = request.getRequestURI();
        if (path != null && path.toLowerCase(Locale.ENGLISH).contains("kapi/app/srm/srmwebapi")) {
            isSRMAPI = true;
        }
        return isSRMAPI;
    }

    public static synchronized String getGuestGloalSessionId(HttpServletRequest request, HttpServletResponse response, boolean isAPI) {
        String globalSessionId = null;
        LoginAccount loginAccount = LoginAccountFactory.createInstanceByHttpRequest((HttpServletRequest)request, Optional.empty());
        Account currentCenter = loginAccount.getAccount();
        String globalGuestSessionID = null;
        if (!isAPI && TRUE_STRING.equalsIgnoreCase(request.getParameter("needReset"))) {
            Map<String, String> user = LoginUtils.getClientUserInfo(loginAccount.getTenantId());
            globalSessionId = SessionUtils.createNewSession((HttpServletRequest)request, (HttpServletResponse)response, (Account)currentCenter, (Lang)LoginLangUtils.getLoginLanguage((HttpServletRequest)request), (String)NetAddressUtils.getRemoteHost((HttpServletRequest)request), user, (LoginClientEnum)LoginClientEnum.WEB, (int)ThirdAPIAPPUtils.getTokenTimeout((String)currentCenter.getTenantId()));
            return globalSessionId;
        }
        globalGuestSessionID = LoginUtils.getGuestSessionIdByAccountId(currentCenter.getAccountId());
        if (StringUtils.isNotEmpty((String)globalGuestSessionID)) {
            if (!SessionUtils.verifyCookieSession((HttpServletRequest)request, (String)globalGuestSessionID)) {
                globalSessionId = null;
            } else {
                globalSessionId = globalGuestSessionID;
                if (!isAPI && !LoginUtils.isNeedWsdl(request.getRequestURI(), request)) {
                    SessionManager.copySession((HttpServletRequest)request, (HttpServletResponse)response, (String)globalSessionId);
                } else if (LoginUtils.isSRMAPI(request)) {
                    SessionManager.copySession((HttpServletRequest)request, (HttpServletResponse)response, (String)globalSessionId);
                }
            }
        }
        if (StringUtils.isEmpty(globalSessionId)) {
            Map<String, String> user = LoginUtils.getClientUserInfo(loginAccount.getTenantId());
            if (isAPI && !LoginUtils.isSRMAPI(request)) {
                LoginClientEnum client = LoginClientEnum.API;
                if (LoginUtils.isSRMAPI(request)) {
                    client = LoginClientEnum.WEB;
                }
                globalSessionId = SessionUtils.createNewSession4WS((Account)currentCenter, (Lang)LoginLangUtils.getLoginLanguage((HttpServletRequest)request), (String)NetAddressUtils.getRemoteHost((HttpServletRequest)request), user, (LoginClientEnum)LoginClientEnum.API, (int)ThirdAPIAPPUtils.getTokenTimeout((String)currentCenter.getTenantId()));
            } else {
                globalSessionId = SessionUtils.createNewSession((HttpServletRequest)request, (HttpServletResponse)response, (Account)currentCenter, (Lang)LoginLangUtils.getLoginLanguage((HttpServletRequest)request), (String)NetAddressUtils.getRemoteHost((HttpServletRequest)request), user, (LoginClientEnum)LoginClientEnum.WEB, (int)ThirdAPIAPPUtils.getTokenTimeout((String)currentCenter.getTenantId()));
            }
            LoginUtils.setGuestSessionId(currentCenter.getAccountId(), globalSessionId);
        }
        return globalSessionId;
    }

    public static synchronized String getGuestSessionId(String accountId, String tenantId, Lang lang, String address) {
        String returnString = LoginUtils.getGuestSessionIdByAccountId("login_module_guest_user_id", accountId);
        if (StringUtils.isEmpty((String)returnString)) {
            Map<String, String> user = LoginUtils.getClientUserInfo(tenantId);
            Account currentCenter = LoginAccountFactory.createInstanceByCustom((String)accountId, (String)tenantId).getAccount();
            returnString = SessionUtils.createNewSession4WS((Account)currentCenter, (Lang)lang, (String)address, user, (LoginClientEnum)LoginClientEnum.WEB, (int)ThirdAPIAPPUtils.getTokenTimeout((String)currentCenter.getTenantId()));
            LoginUtils.setGuestSessionId("login_module_guest_user_id", currentCenter.getAccountId(), returnString);
        }
        return returnString;
    }

    private static void setGuestSessionId(String accountId, String globalSessionId) {
        LoginUtils.setGuestSessionId(GUEST_USER_ID, accountId, globalSessionId);
    }

    private static void setGuestSessionId(String key, String accountId, String globalSessionId) {
        Account account = LoginAccountFactory.createInstanceByCustom((String)accountId).getAccount();
        CacheLoginData.setAttribute((String)key, (String)accountId, (String)globalSessionId, (int)SessionDAO.getSessionTimeout((String)account.getTenantId()));
    }

    private static String getGuestSessionIdByAccountId(String accountId) {
        return LoginUtils.getGuestSessionIdByAccountId(GUEST_USER_ID, accountId);
    }

    private static String getGuestSessionIdByAccountId(String key, String accountId) {
        return CacheLoginData.getAttribute((String)key, (String)accountId);
    }

    public static boolean isAPIByGuestUser(ServletRequest servletRequest, HttpServletResponse response, SessionDAO sessionDAO, String globalSessionId) {
        boolean isAPIGuest = false;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String accountIdParameter = LoginAccountFactory.createInstanceByPostRequest((HttpServletRequest)request, (HttpServletResponse)response, Optional.of(() -> "application/json".equalsIgnoreCase(request.getContentType()))).getAccountId();
        if (StringUtils.isEmpty((String)accountIdParameter)) {
            accountIdParameter = LoginAccountFactory.createInstanceBySession((String)globalSessionId, Optional.empty()).getAccountId();
        }
        Account currentCenter = LoginAccountFactory.createInstanceByCustom((String)accountIdParameter, (HttpServletRequest)request).getAccount();
        String xPath = LoginUtils.getPath(request);
        if (LoginUtils.isAPIGuestUrl(xPath, currentCenter)) {
            isAPIGuest = true;
        }
        return isAPIGuest;
    }

    private static boolean isAPIGuestUrl(String xPath, Account currentCenter) {
        String login_api_support_anonymous;
        boolean supportGuestApi;
        boolean isGuestAPI = false;
        for (String url : GuestURLUtils.getCommonAPIURLList()) {
            if (!LoginUtils.isIncludeURl(xPath, url)) continue;
            isGuestAPI = true;
            break;
        }
        boolean bl = supportGuestApi = (login_api_support_anonymous = SystemPropertyUtils.getProptyByTenant((String)"login_api_support_anonymous", (String)currentCenter.getTenantId())) != null && TRUE_STRING.equals(login_api_support_anonymous);
        if (!isGuestAPI && supportGuestApi) {
            for (String url : GuestURLUtils.getAPIURLListByAccount((Account)currentCenter)) {
                if (!LoginUtils.isIncludeURl(xPath, url)) continue;
                isGuestAPI = true;
                break;
            }
        }
        return isGuestAPI;
    }

    private static String getPath(HttpServletRequest request) {
        String path = request.getRequestURI();
        String context = request.getContextPath();
        String xpath = null;
        if (path != null) {
            xpath = path.substring(context.length());
        }
        return xpath;
    }

    public static boolean isGuestUser(SessionDAO sessionDAO, String globalSessionId) {
        Map sessionInfo1;
        boolean isGuestUser = false;
        sessionDAO = SessionDAOFactory.getSessionDAO((String)globalSessionId);
        if (sessionDAO != null && StringUtils.isNotEmpty((String)globalSessionId) && (sessionInfo1 = sessionDAO.getAttributesAsMap(new String[]{"tenantId", "sandboxId", "language", USER_ID, "userName", "userOpenId", "orgId", "userType", "yzjAppId", "yzjAppTicket", ACCOUNT_ID, "uid", loginOrg, "client"})) != null && "-1".equalsIgnoreCase((String)sessionInfo1.get(USER_ID))) {
            isGuestUser = true;
        }
        return isGuestUser;
    }

    public static boolean isLoginByGuestUser(HttpServletRequest request, HttpServletResponse response) {
        boolean isGuest = false;
        String userId = LoginUtils.getParamerter(request, USER_ID);
        if ("Guest".equalsIgnoreCase(userId)) {
            isGuest = true;
        }
        return isGuest;
    }

    public static boolean isSupportedKDEMessage() {
        boolean isSupportedKDEMessage = false;
        String isSupportedKDEMessageString = System.getProperty("is_supported_kdemessage");
        if (isSupportedKDEMessageString != null && TRUE_STRING.equals(isSupportedKDEMessageString.trim().toLowerCase(Locale.ENGLISH))) {
            isSupportedKDEMessage = true;
        }
        return isSupportedKDEMessage;
    }

    public static boolean isForcedInputVerifyCode(String tenantId) {
        boolean isForced = false;
        String isForceString = System.getProperty(tenantId + "_" + "IsVerifycodeDisplay");
        if (StringUtils.isEmpty((String)isForceString)) {
            isForceString = System.getProperty("IsVerifycodeDisplay");
        }
        if (TRUE_STRING.equalsIgnoreCase(isForceString)) {
            isForced = true;
        }
        return isForced;
    }

    public static boolean isGuestUser(String userId) {
        boolean isGuest = false;
        if ("-1".equalsIgnoreCase(userId)) {
            isGuest = true;
        }
        return isGuest;
    }

    public static String getAccountIdFromSession(String globalSessionId) {
        Map sessionInfo;
        String accountId = null;
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)globalSessionId);
        if (sessionDAO != null && StringUtils.isNotEmpty((String)globalSessionId) && (sessionInfo = sessionDAO.getAttributesAsMap(new String[]{"tenantId", "sandboxId", "language", USER_ID, "userName", "userOpenId", "orgId", "userType", "yzjAppId", "yzjAppTicket", ACCOUNT_ID, "uid", loginOrg, "client"})) != null && sessionInfo.get(ACCOUNT_ID) != null) {
            accountId = (String)sessionInfo.get(ACCOUNT_ID);
        }
        return accountId;
    }

    public static String getUserIdFromSession(SessionDAO sessionDAO, String globalSessionId) {
        return LoginUtils.getUserIdFromSession(globalSessionId, false);
    }

    public static String getUserIdFromSession(String globalSessionId, boolean isNew) {
        Map sessionInfo;
        String userId = null;
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)globalSessionId);
        if (sessionDAO != null && StringUtils.isNotEmpty((String)globalSessionId) && (sessionInfo = sessionDAO.getAttributesAsMap(new String[]{"tenantId", "sandboxId", "language", USER_ID, "userName", "userOpenId", "orgId", "userType", "yzjAppId", "yzjAppTicket", ACCOUNT_ID, "uid", loginOrg, "client"})) != null && sessionInfo.get(USER_ID) != null) {
            userId = (String)sessionInfo.get(USER_ID);
        }
        if (isNew) {
            sessionDAO = null;
        }
        return userId;
    }

    public static SessionInfo getSessionInfoBySessionId(HttpServletRequest request, String globalSessionId) {
        Map sessionInfo;
        SessionInfo si = null;
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)globalSessionId);
        if (sessionDAO != null && StringUtils.isNotEmpty((String)globalSessionId) && (sessionInfo = sessionDAO.getAttributesAsMap(new String[]{"tenantId", "sandboxId", "language", USER_ID, "userName", "userOpenId", "orgId", "userType", "yzjAppId", "yzjAppTicket", ACCOUNT_ID, "uid", loginOrg, "client"})) != null && sessionInfo.size() > 0) {
            String tenantId = RevProxyUtil.getTenantCode((HttpServletRequest)request);
            String sandboxId = (String)sessionInfo.get("sandboxId");
            String userId = (String)sessionInfo.get(USER_ID);
            long orgId = 0L;
            if (!StringUtils.isEmpty((String)((String)sessionInfo.get("orgId")))) {
                orgId = Long.parseLong((String)sessionInfo.get("orgId"));
            }
            if (tenantId != null && userId != null) {
                String reqTenantNo = RevProxyUtil.getTenantCode((HttpServletRequest)request);
                if (!reqTenantNo.equalsIgnoreCase(tenantId)) {
                    throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u79df\u6237\u6570\u636e\u4e0d\u6b63\u786e,\u975e\u6cd5\u64cd\u4f5c!!!!", (String)"LoginUtils_21", (String)BOS_LOGIN, (Object[])new Object[0])});
                }
                String lang = (String)sessionInfo.get("language");
                String userName = (String)sessionInfo.get("userName");
                String userOpenId = (String)sessionInfo.get("userOpenId");
                String userType = (String)sessionInfo.get("userType");
                String yzjAppId = (String)sessionInfo.get("yzjAppId");
                String yzjAppTicket = (String)sessionInfo.get("yzjAppTicket");
                String uId = (String)sessionInfo.get("uid");
                String loginOrg = (String)sessionInfo.get(loginOrg);
                String client = (String)sessionInfo.get("client");
                String accountId = "";
                if (sessionInfo.get(ACCOUNT_ID) != null) {
                    accountId = (String)sessionInfo.get(ACCOUNT_ID);
                }
                si = new SessionInfo();
                si.setTenantId(tenantId);
                si.setSandboxId(sandboxId);
                si.setOrgId(String.valueOf(orgId));
                si.setUserId(userId);
                si.setUserName(userName);
                si.setUserOpenId(userOpenId);
                si.setUserType(userType);
                si.setYzjAppId(yzjAppId);
                si.setYzjAppTicket(yzjAppTicket);
                si.setLanguage(lang);
                si.setUid(uId);
                si.setAccountId(accountId);
                si.setClient(client);
                if (loginOrg != null) {
                    si.setLoginOrg(loginOrg);
                }
            }
        }
        return si;
    }

    public static String getRequestBody(HttpServletRequest request) {
        StringBuilder bodyStr = new StringBuilder();
        try (BufferedInputStream bis = new BufferedInputStream((InputStream)request.getInputStream());){
            int n;
            byte[] buffer = new byte[1024];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while ((n = bis.read(buffer)) != -1) {
                bos.write(buffer, 0, n);
            }
            byte[] input = bos.toByteArray();
            bodyStr.append(new String(input, StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            bodyStr.append(e.getMessage());
        }
        return bodyStr.toString();
    }

    public static void checkAPIUserInfo(Map<String, String> userInfo) {
        String userId = userInfo.get("fid");
        if (StringUtils.isEmpty((String)userId)) {
            throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u7528\u6237\u4e0d\u5b58\u5728\u3002", (String)"LoginAPI_8", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
    }

    public static Map<String, String> getUserInfoByAPIUserType(Account currentCenter, String user, String userType, Lang lang) {
        Map userInfo = null;
        UserProperType aType = UserProperType.getUserProperTypeByString((String)userType);
        switch (aType) {
            case Mobile: {
                userInfo = LoginUserService.getErpUserInfoByPhone((Account)currentCenter, (String)user, (String)lang.name());
                break;
            }
            case Email: {
                userInfo = LoginUserService.getErpUserInfoByEmail((Account)currentCenter, (String)user, (String)lang.name());
                break;
            }
            case UserName: {
                userInfo = LoginUserService.getErpUserInfoByUserName((Account)currentCenter, (String)user, (String)lang.name());
                break;
            }
            case YunzhijiaUId: {
                userInfo = LoginUserService.getErpUserInfo((Account)currentCenter, (long)Long.parseLong(user), (String)lang.name());
                break;
            }
            case WorkerNumber: {
                userInfo = LoginUserService.getErpUserInfoByNumber((Account)currentCenter, (String)user, (String)lang.name());
                break;
            }
            case UUID: {
                userInfo = LoginUserService.getErpUserInfoByUUID((Account)currentCenter, (String)user, (String)lang.name());
                break;
            }
            case UserId: {
                userInfo = LoginUserService.getErpUserInfoByUserId((Account)currentCenter, (String)user, (String)lang.name());
                break;
            }
        }
        return userInfo;
    }

    public static boolean isSupportLoginUnderSSO(Account currentCenter) {
        boolean isSupport = false;
        Map yzjMap = ParametersUtils.getCommonParameters((Account)currentCenter);
        if (yzjMap != null && yzjMap.get("is_sso_force_login") instanceof Boolean) {
            isSupport = (Boolean)yzjMap.get("is_sso_force_login");
        }
        return isSupport;
    }

    public static boolean isSupportLDAP(Account currentCenter) {
        boolean isSupport = false;
        Map yzjMap = ParametersUtils.getCommonParameters((Account)currentCenter);
        if (yzjMap != null && yzjMap.get("isenablead") instanceof Boolean) {
            isSupport = (Boolean)yzjMap.get("isenablead");
        }
        return isSupport;
    }

    public static Map<String, String> getLdapInfo(Account currentCenter) {
        HashMap<String, String> ldapInfo = new HashMap<String, String>(8);
        ldapInfo.put("url", StringUtils.getDefualtEmptyString((String)ParametersUtils.getCommonStringParameters((Account)currentCenter, (String)"ldapurl")));
        ldapInfo.put("domain", StringUtils.getDefualtEmptyString((String)ParametersUtils.getCommonStringParameters((Account)currentCenter, (String)"domain")));
        return ldapInfo;
    }

    public static String getSSOSupportCachkey(String session, String accountId) {
        String sessionId = null;
        if (session != null) {
            sessionId = accountId + "_" + session + "_sso_cache";
        }
        return sessionId;
    }

    public static String getErrorPageString(String content) {
        if (StringUtils.isEmpty((String)STATIC_RESOURCE_STRING)) {
            StringBuilder sb = new StringBuilder();
            sb.append("<!DOCTYPE html>");
            sb.append("<html >");
            sb.append("<head>");
            sb.append("    <meta charset=\"UTF-8\">");
            sb.append("    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">");
            sb.append("    <title>Document</title>");
            sb.append("   <style>.container{");
            sb.append("    height: 100%%;");
            sb.append("    width: 100%%;");
            sb.append("    opacity: 1;");
            sb.append("    background-color: #FFFFFF;");
            sb.append("    display: flex;");
            sb.append("    flex-direction: column;");
            sb.append("    text-align: center;");
            sb.append("    align-items: center;");
            sb.append("}");
            sb.append(".container-img{");
            sb.append("    width: 280px;");
            sb.append("    height: 160px;");
            sb.append("    margin-top: 200px;");
            sb.append("    margin-bottom: 8px;");
            sb.append("}");
            sb.append(".container-text{");
            sb.append("   font-family: 'PingFangSC-Regular';");
            sb.append("   font-size: 14px;");
            sb.append("   color: #666666;");
            sb.append("   letter-spacing: 0;");
            sb.append("   text-align: center;");
            sb.append("   line-height: 20px;");
            sb.append("   margin: 0;");
            sb.append("}");
            sb.append("</style>");
            sb.append("</head>");
            sb.append("<body >");
            sb.append("    <article class=\"container\"");
            sb.append("style=\"display: flex;flex-direction: column;text-align: center;align-items: center;\" ");
            sb.append(">");
            sb.append("        <img src=\"./images/pc/emotion/sjzn_yebz_232_148.png\"  class=\"container-img\">");
            sb.append("        <p class=\"container-text\">%s</p>");
            sb.append("    </article>");
            sb.append("</body>");
            sb.append("</html>");
            STATIC_RESOURCE_STRING = sb.toString();
        }
        return String.format(STATIC_RESOURCE_STRING, content);
    }

    public static boolean isGuestSessionId(String sessionId) {
        boolean isGuest = false;
        SessionInfo session = LoginUtils.getSessinInfoBySessionId(sessionId);
        if (session != null && "-1".equals(session.getUserId())) {
            isGuest = true;
        }
        return isGuest;
    }

    private static String getLoginJsPath(HttpServletRequest request) {
        String kdweb_debug = request.getParameter(KDWEB_DEBUG);
        String kdweb_cdn = LoginUtils.getKDWebCDN(request);
        StringBuilder loginJsPath = new StringBuilder();
        if (StringUtils.isNotEmpty((String)kdweb_cdn)) {
            if (kdweb_cdn.endsWith("/")) {
                loginJsPath.append("<script>window.__kd_cdnPath__ = '").append(kdweb_cdn, 0, kdweb_cdn.length() - 1).append("'; </script>");
                loginJsPath.append("<script type='text/javascript' src='").append(kdweb_cdn, 0, kdweb_cdn.length() - 1).append("/login/js/startup.js?v=%s'></script>");
            } else {
                loginJsPath.append("<script>window.__kd_cdnPath__ = '").append(kdweb_cdn).append("'; </script>");
                loginJsPath.append("<script type='text/javascript' src='").append(kdweb_cdn).append("/login/js/startup.js?v=%s'></script>");
            }
        } else {
            loginJsPath.append("<script>window.__kd_cdnPath__ = '.'; </script>");
            if (StringUtils.isNotEmpty((String)kdweb_debug) && TRUE_STRING.equals(kdweb_debug)) {
                loginJsPath.append("<script type='text/javascript' src='./login/js/startup-debug.js?v=%s'></script>");
            } else {
                loginJsPath.append("<script type='text/javascript' src='./login/js/startup.js?v=%s'></script>");
            }
        }
        return loginJsPath.toString();
    }

    private static String getLoginMobileJsPath(HttpServletRequest request) {
        String kdweb_debug = request.getParameter(KDWEB_DEBUG);
        String kdweb_cdn = LoginUtils.getKDWebCDN(request);
        StringBuilder loginJsPath = new StringBuilder();
        if (StringUtils.isNotEmpty((String)kdweb_cdn)) {
            if (kdweb_cdn.endsWith("/")) {
                loginJsPath.append("<script>window.__kd_cdnPath__ = '").append(kdweb_cdn, 0, kdweb_cdn.length() - 1).append("'; </script>");
                loginJsPath.append("<script type='text/javascript' src='").append(kdweb_cdn, 0, kdweb_cdn.length() - 1).append("/login/js/startup-m.js?v=%s'></script>");
            } else {
                loginJsPath.append("<script>window.__kd_cdnPath__ = '").append(kdweb_cdn).append("'; </script>");
                loginJsPath.append("<script type='text/javascript' src='").append(kdweb_cdn).append("/login/js/startup-m.js?v=%s'></script>");
            }
        } else {
            loginJsPath.append("<script>window.__kd_cdnPath__ = '.'; </script>");
            if (StringUtils.isNotEmpty((String)kdweb_debug) && TRUE_STRING.equals(kdweb_debug)) {
                loginJsPath.append("<script type='text/javascript' src='./login/js/startup-m-debug.js?v=%s'></script>");
            } else {
                loginJsPath.append("<script type='text/javascript' src='./login/js/startup-m.js?v=%s'></script>");
            }
        }
        return loginJsPath.toString();
    }

    public static String getKDWebCDN(HttpServletRequest request) {
        String webCDN = request.getParameter(KDWEB_CDN);
        String tenantId = RevProxyUtil.getTenantId((HttpServletRequest)request);
        boolean isAllow = LoginUtils.isTrueByKey("is_allow_cnd_debug", tenantId, true);
        if (!isAllow) {
            webCDN = null;
        }
        return webCDN;
    }

    public static int thirdAppIdLockTime() {
        int thirdAppIdLockTime = 60;
        String thirdAppIdLockTimeMC = System.getProperty("thirdAppIdLockTime");
        if (StringUtils.isNotEmpty((String)thirdAppIdLockTimeMC) && kd.bos.util.StringUtils.isNumeric((String)thirdAppIdLockTimeMC)) {
            try {
                thirdAppIdLockTime = Integer.parseInt(thirdAppIdLockTimeMC);
            }
            catch (NumberFormatException e) {
                logger.error((Throwable)e);
            }
        }
        logger.info("thirdAppIdLockTime=" + thirdAppIdLockTime);
        return thirdAppIdLockTime;
    }

    public static boolean chekCSRF(HttpServletRequest request, String csrfToken) {
        boolean checkResult = true;
        String tenantId = RevProxyUtil.getTenantId((HttpServletRequest)request);
        if (LoginUtils.isNeedCheckCSRF(tenantId) && LoginUtils.isNeedCheckCSRFURL(request)) {
            if (POST.equals(request.getMethod().toLowerCase(Locale.ENGLISH))) {
                checkResult = LoginUtils.checkPostCsrf(request, csrfToken);
                if (!checkResult && LoginUtils.isIncludeUrlInList(request, CSRF_EXCEPT_LIST)) {
                    checkResult = LoginUtils.checkGetCsrf(request, csrfToken);
                }
            } else {
                checkResult = LoginUtils.checkGetCsrf(request, csrfToken);
            }
        }
        return checkResult;
    }

    private static boolean checkPostCsrf(HttpServletRequest request, String csrfToken) {
        boolean checkResult = true;
        if (!StringUtils.isNotEmpty((String)csrfToken) || !csrfToken.equals(request.getHeader(KD_CSRF_TOKEN))) {
            checkResult = false;
        }
        return checkResult;
    }

    private static boolean checkGetCsrf(HttpServletRequest request, String csrfToken) {
        boolean checkResult = true;
        if (!StringUtils.isNotEmpty((String)csrfToken) || !csrfToken.equals(request.getHeader("kd_cs_ticket")) && !csrfToken.equals(request.getParameter("kd_cs_ticket"))) {
            checkResult = false;
        }
        return checkResult;
    }

    private static boolean isNeedCheckCSRFURL(HttpServletRequest request) {
        return LoginUtils.isIncludeUrlInList(request, CSRF_CHECK_LIST) && !LoginUtils.isIncludeUrlInList(request, EXCLUDE_CSRF_CHECK_LIST);
    }

    private static boolean isNeedCheckRefererURL(HttpServletRequest request) {
        return LoginUtils.isIncludeUrlInList(request, REFEREER_CHECK_LIST);
    }

    private static boolean isIncludeUrlInList(HttpServletRequest request, String[] urlList) {
        boolean isNeed = false;
        if (urlList == null || urlList.length == 0) {
            return isNeed;
        }
        String xpath = LoginUtils.getPath(request);
        for (int i = 0; i < urlList.length; ++i) {
            if (!LoginUtils.isIncludeURl(xpath, urlList[i])) continue;
            isNeed = true;
            break;
        }
        return isNeed;
    }

    public static boolean isNeedCheckCSRF(String tenantId) {
        boolean isNeedCheckCSRF = LoginUtils.isTrueByKey("is_need_check_csrf", tenantId);
        return isNeedCheckCSRF;
    }

    private static boolean isTrueByKey(String key, String tenantId, boolean defaultValue) {
        boolean isTrue = defaultValue;
        String isTrueString = SystemPropertyUtils.getProptyByTenant((String)key, (String)tenantId);
        if (isTrueString != null && TRUE_STRING.equalsIgnoreCase(isTrueString.trim())) {
            isTrue = true;
        } else if (isTrueString != null && "false".equalsIgnoreCase(isTrueString.trim())) {
            isTrue = false;
        }
        return isTrue;
    }

    private static boolean isTrueByKey(String key, String tenantId) {
        return LoginUtils.isTrueByKey(key, tenantId, false);
    }

    public static boolean isAllowAcessToken(String tenantId) {
        return LoginUtils.isTrueByKey("is_allow_access_token", tenantId, true);
    }

    public static boolean chekIP(HttpServletRequest request, String ipAddress) {
        boolean returnValue = true;
        String tenantId = RevProxyUtil.getTenantId((HttpServletRequest)request);
        if (LoginUtils.isTrueByKey("is_need_check_ip", tenantId)) {
            if (LoginUtils.isTrueByKey("is_need_check_ip_second", tenantId)) {
                String secondFirst;
                String nowFirst;
                String adress = NetAddressUtils.getRemoteHost((HttpServletRequest)request);
                if (StringUtils.isNotEmpty((String)ipAddress) && !(nowFirst = adress.split(",")[0]).equals(secondFirst = ipAddress.split(",")[0])) {
                    returnValue = false;
                }
            } else if (!NetAddressUtils.getRemoteHost((HttpServletRequest)request).equals(ipAddress)) {
                returnValue = false;
            }
        }
        return returnValue;
    }

    public static String getProptyByTenant(String key, String tenantId) {
        String pValue = System.getProperty(tenantId + "_" + key);
        if (StringUtils.isEmpty((String)pValue)) {
            pValue = System.getProperty(key);
        }
        return pValue;
    }

    public static void chekLoginIP(HttpServletRequest request, Account currentCenter, Map<String, String> userInfo) {
        Map sysparams = ParametersUtils.getCommonParameters((Account)currentCenter);
        String loginIp = NetAddressUtils.getRemoteHost((HttpServletRequest)request);
        String lastLoginIp = userInfo.get("flastloginip");
        if (null != sysparams && (null == sysparams.get("close_login_ip_tip") || null != sysparams.get("close_login_ip_tip") && ((Boolean)sysparams.get("close_login_ip_tip")).booleanValue()) && StringUtils.isNotEmpty((String)lastLoginIp) && StringUtils.isNotEmpty((String)loginIp) && !loginIp.contains(lastLoginIp)) {
            CacheLoginData.setAttribute((String)LOGIN_IP_TIP, (String)(currentCenter.getAccountId() + userInfo.get("fid")), (String)userInfo.get("fid"), (int)EXPIRE_TIME);
        }
    }

    public static boolean needCheckUserType(Account currentCenter) {
        Map sysparams = ParametersUtils.getCommonParameters((Account)currentCenter);
        boolean flag = false;
        if (null != sysparams && null != sysparams.get(CHECK_USER_TYPE) && ((Boolean)sysparams.get(CHECK_USER_TYPE)).booleanValue()) {
            flag = true;
        }
        return flag;
    }

    public static boolean isClerk(String userType) {
        return "1".equals(userType);
    }

    public static void checkUserEnable(Account currentCenter, String userName) throws KDException {
        boolean isEnable = LoginUserService.checkUserEnable((Account)currentCenter, (String)userName);
        if (isEnable) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{String.format(ResManager.loadKDString((String)"\u7528\u6237\u5df2\u7981\u7528\uff0c\u65e0\u6cd5\u767b\u5f55\u3002", (String)"LoginUtils_18", (String)BOS_LOGIN, (Object[])new Object[0]), new Object[0])});
        }
    }

    public static String getEndSymbol(String endSymbol) {
        String result = endSymbol;
        Lang lang = LoginLangUtils.getLang();
        if (!ZH_CN.equals(lang.name()) && "\u3002".equals(endSymbol)) {
            result = ".";
        }
        return result;
    }

    public static boolean checkLdapLogin(Account currentCenter, String userName) {
        boolean isSupportLDAP = false;
        if (!AdminUtils.getAdminList().contains(userName) && LoginUtils.isSupportLDAP(currentCenter) && (!LoginUtils.needCheckUserType(currentCenter) || LoginUtils.needCheckUserType(currentCenter) && LoginUtils.isClerk(LoginUserService.checkUserType((Account)currentCenter, (String)userName)))) {
            isSupportLDAP = true;
        }
        return isSupportLDAP;
    }

    public static boolean checkLdapLogin(Account currentCenter, Long userId) {
        boolean isSupportLDAP = false;
        if (LoginUtils.isSupportLDAP(currentCenter) && (!LoginUtils.needCheckUserType(currentCenter) || LoginUtils.needCheckUserType(currentCenter) && LoginUtils.isClerk(LoginUserService.checkUserType((Account)currentCenter, (Long)userId)))) {
            isSupportLDAP = true;
        }
        return isSupportLDAP;
    }

    public static String getErrorPasswordMsg(Account currentAccount, String userName, String message) {
        String returnMsg = message;
        if (kd.bos.util.StringUtils.isNotEmpty((String)userName) && LoginUtils.checkLdapLogin(currentAccount, userName)) {
            returnMsg = ResManager.loadKDString((String)"AD\u57df\u767b\u5f55\u3002", (String)"LoginUtils_19", (String)BOS_LOGIN, (Object[])new Object[0]);
        }
        return returnMsg;
    }

    public static String getErrorPasswordMsg(Account currentAccount, Long userId, String message) {
        String returnMsg = message;
        if (userId != null && LoginUtils.checkLdapLogin(currentAccount, userId)) {
            returnMsg = ResManager.loadKDString((String)"AD\u57df\u767b\u5f55\u3002", (String)"LoginUtils_19", (String)BOS_LOGIN, (Object[])new Object[0]);
        }
        return returnMsg;
    }

    public static boolean checkIsAccount(Map<String, ?> userInfo) {
        return userInfo != null && "1".equals(userInfo.get("fisaccount"));
    }

    @Deprecated
    public static String getParameterFromRequest(HttpServletResponse response, HttpServletRequest request, String parameterName) {
        String accountIdParameter = LoginUtils.getParamerter(request, parameterName);
        if (StringUtils.isEmpty((String)accountIdParameter) && POST.equalsIgnoreCase(request.getMethod()) && LoginUtils.isLoginAPI(request)) {
            ApiRequestContext.initThreadLocal((HttpServletRequest)request, (HttpServletResponse)response);
            ApiRequestContext ctx = ApiRequestContext.get();
            try {
                Map mapReq = (Map)ctx.getPostData(HashMap.class);
                if (mapReq != null) {
                    accountIdParameter = (String)mapReq.get(parameterName);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return accountIdParameter;
    }

    public static void handleGenernal(HttpServletRequest request, HttpServletResponse response) {
        Account currentCenter = LoginAccountFactory.createInstanceByPostRequest((HttpServletRequest)request, (HttpServletResponse)response, Optional.of(() -> LoginUtils.isLoginAPI(request))).getAccount();
        LoginUtils.createGuestRequestContext(request, currentCenter);
        List<Language> list = LoginUtils.getAllLanguagesByAccount(currentCenter);
        if (list != null && list.size() > 0) {
            Language defaultLang = list.get(0);
            for (Language lang : list) {
                if (lang == null || !lang.isDefault()) continue;
                defaultLang = lang;
                break;
            }
            LangContext.setDefaultLang((Lang)Lang.from((String)defaultLang.getNumber()));
        }
        LoginUtils.allowCrossDomain(request, response);
        LoginUtils.handleXssProtect(request, response);
    }

    private static void handleXssProtect(HttpServletRequest request, HttpServletResponse response) {
        String tenantId = RevProxyUtil.getTenantId((HttpServletRequest)request);
        String url = UrlService.getDomainContextUrlByTenantCode((String)tenantId);
        if (LoginUtils.startHttps(url)) {
            LoginUtils.setXssHeader(response, tenantId, "strict-transport-security", "xss_security_sestrict_transport_security", null);
        }
        LoginUtils.setXssHeader(response, tenantId, "x-frame-options", "xss_security_x_frame_options", null);
        LoginUtils.setXssHeader(response, tenantId, "X-XSS-Protection", "xss_security_X_XSS_Protection", null);
        LoginUtils.setXssHeader(response, tenantId, "X-Content-Type-Options", "xss_security_X_Content_Type_Options", null);
        LoginUtils.setXssHeader(response, tenantId, "Content-Security-Policy", "xss_security_X_Content_Security_Policy", null);
    }

    private static void setXssHeader(HttpServletResponse response, String tenantId, String key, String configKey, String defaultValue) {
        String strictTransportSecurity = SystemPropertyUtils.getProptyByTenant((String)configKey, (String)tenantId);
        if (StringUtils.isNotEmpty((String)strictTransportSecurity) && !"none".equalsIgnoreCase(strictTransportSecurity.trim())) {
            response.addHeader(key, strictTransportSecurity.trim());
        } else if (StringUtils.isNotEmpty((String)defaultValue)) {
            response.addHeader(key, defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Language> getAllLanguagesByAccount(Account currentCenter) {
        List returnList;
        block6: {
            returnList = null;
            try {
                if (currentCenter == null) break block6;
                Object listObj = LocalCacheUtils.get((String)LoginUtils.getCacheLangKey(currentCenter));
                if (listObj != null) {
                    returnList = (List)listObj;
                }
                if (returnList != null && returnList.size() >= 1) break block6;
                returnList = InteServiceHelper.getAllLanguageForLogin((Account)currentCenter);
                Account account = currentCenter;
                synchronized (account) {
                    LocalCacheUtils.put((String)LoginUtils.getCacheLangKey(currentCenter), (Object)returnList);
                }
            }
            catch (Exception e) {
                logger.info("getAllLanguagesByAccount#", (Object)e);
            }
        }
        return returnList;
    }

    private static String getCacheLangKey(Account currentCenter) {
        return currentCenter.getAccountId() + "alllangues";
    }

    public static boolean isAPI(HttpServletRequest request) {
        String path = request.getRequestURI();
        return Boolean.parseBoolean(request.getHeader("api")) || path.contains("/api/") || path.contains("/kapi");
    }

    private static boolean isLoginAPI(HttpServletRequest request) {
        String path = request.getRequestURI();
        String contextPath = request.getServletContext().getContextPath();
        String realUrl = path.substring(contextPath.length());
        return path.contains("api/login.do") || realUrl.startsWith("/kapi/oauth2/");
    }

    public static String getCorrectUserIDSalt(String uid) {
        String returnValue = uid;
        if (StringUtils.isNotEmpty((String)uid) && uid.length() <= 1) {
            returnValue = uid + "110111";
        }
        return returnValue;
    }

    public static boolean isIincludePageId(HttpServletRequest request) {
        boolean isPage = false;
        String pageId = request.getParameter("byPageId");
        if (StringUtils.isNotEmpty((String)pageId)) {
            isPage = true;
        }
        if (!isPage && StringUtils.isNotEmpty((String)(pageId = request.getParameter("pageId")))) {
            isPage = true;
        }
        return isPage;
    }

    public static boolean isIncludeAppNumber(HttpServletRequest request) {
        boolean isPage = false;
        String appNumber = request.getParameter("appNumber");
        if (StringUtils.isNotEmpty((String)appNumber)) {
            isPage = true;
        }
        return isPage;
    }

    public static String builderParamter(HttpServletRequest request) throws Exception {
        Enumeration enums = request.getParameterNames();
        StringBuilder sbBuilder = new StringBuilder();
        while (enums.hasMoreElements()) {
            String name = (String)enums.nextElement();
            if (name.equals(redirectP) || name.contains("ACCESS_TOKEN".toLowerCase(Locale.ENGLISH)) || name.equals(loginOrg) || "formId".equals(name) || SecurityUtils.checkXss((String)request.getParameter(name))) continue;
            sbBuilder.append("&").append(name).append("=");
            sbBuilder.append(URLEncoder.encode(request.getParameter(name), UPPER_UTF_8));
        }
        return sbBuilder.toString();
    }

    public static boolean isNeedAddOperation(HttpServletRequest request) {
        return LoginUtils.isIncludeUrlInList(request, MANUAL_CHECK_LIST);
    }

    public static String getBaseUrl() {
        String baseConfig = System.getProperty("url");
        if (org.apache.commons.lang.StringUtils.isEmpty((String)baseConfig)) {
            baseConfig = "http://api.kingdee.com/";
        }
        return StringUtils.getPathString((String)baseConfig);
    }

    public static String getCloudClientId() {
        String cloudId = System.getProperty("clientId");
        if (org.apache.commons.lang.StringUtils.isEmpty((String)cloudId)) {
            cloudId = "201230";
        }
        return cloudId;
    }

    public static String getClientSecret() {
        String clientSecret = System.getProperty("clientSecret");
        if (org.apache.commons.lang.StringUtils.isNotEmpty((String)clientSecret)) {
            clientSecret = Encrypters.decode((String)clientSecret);
        }
        if (kd.bos.util.StringUtils.isEmpty((String)clientSecret)) {
            clientSecret = DefaultParameterService.getDefaultValueByKey((String)"client_param");
        }
        return clientSecret;
    }

    public static boolean proveVerifyCode(HttpServletRequest servletRequest, HttpServletResponse servletResponse, boolean needDelete, boolean needVerifycode, int timeout) throws IOException {
        String tenantId = RevProxyUtil.getTenantCode((HttpServletRequest)servletRequest);
        String inputCode = servletRequest.getParameter("verifycode");
        String loginId = servletRequest.getParameter("loginid");
        String mobile = servletRequest.getParameter(Constants.LOGIN_USER_KEY);
        if (needVerifycode) {
            if (!LoginUtils.checkVerifyCode(servletResponse, inputCode, loginId)) {
                return false;
            }
            String vType = CacheLoginData.getType4VerifyCode();
            if (needDelete) {
                CacheLoginData.remove((String)vType, (String)loginId);
            } else {
                CacheLoginData.setAttribute((String)vType, (String)loginId, (String)inputCode, (int)timeout);
            }
            return true;
        }
        return LoginUtils.proveVerifyCode(servletRequest, servletResponse, needDelete);
    }

    public static String getCookieByName(HttpServletRequest request, String name) {
        String cookieValue = "";
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                cookieValue = cookie.getValue();
            }
        }
        return cookieValue;
    }

    private static String getCDNURL(HttpServletRequest request, String cdnURLParam) {
        String debugcdnUrl = LoginUtils.getKDWebCDN(request);
        String cdnURL = cdnURLParam;
        if (!StringUtils.isEmpty((String)debugcdnUrl)) {
            cdnURL = debugcdnUrl;
        } else {
            String configCDNURL = System.getProperty("cdn.server.path");
            if (StringUtils.isNotEmpty((String)configCDNURL)) {
                cdnURL = configCDNURL;
            }
        }
        return cdnURL;
    }

    public static String getUpgradePageString(String content, String page) {
        if (StringUtils.isEmpty((String)STATIC_UPGRADE_STRING)) {
            StringBuilder sb = new StringBuilder();
            sb.append("<!DOCTYPE html>\n").append("<html lang=\"en\"><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n").append("    <meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\">\n").append("    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n").append("    <title></title>\n").append("</head>\n").append("<body>\n").append("    <div style=\"\n").append("    display: flex;\n").append("    flex-direction: column;\n").append("    align-content: center;\n").append("    justify-content: center;\n").append("    align-items: center;\n").append("    top: 50%%;\n").append("    left: 50%%;\n").append("    transform: translate(-50%%, -50%%);\n").append("    position: absolute;\">\n").append("        <img src=\"./images/pc/emotion/qj_xtsj_280_165.png\" style=\"width: 280px;\">\n").append("        <div style=\"\n").append("    margin-top: 12px;\n").append("    font-size: 16px;\n").append("    color: #333333;\n").append("    letter-spacing: 0;\n").append("    text-align: center;\n").append("    line-height: 20px;\n").append("    font-weight: 400;\">\n").append("            %s\n").append("        </div>\n").append("    </div>\n").append("<script>setTimeout(()=>{window.location.href = '%s'},10000)</script>\n").append("</body></html>");
            STATIC_UPGRADE_STRING = sb.toString();
        }
        return String.format(STATIC_UPGRADE_STRING, content, page);
    }

    public static String getRedirectLoginUrl(HttpServletRequest request, HttpServletResponse response) {
        boolean isMobile;
        String mainWebSite = RevProxyUtil.getURLContextPath((HttpServletRequest)request);
        String redirectUrl = "";
        String path = request.getRequestURI();
        boolean bl = isMobile = path.contains("/integration/yzjShareOpen.do") && "mob".equals(request.getParameter("device")) || path.contains("/qing/lappEntrance.do");
        if (Pattern.matches(".*/mobile.html.*", request.getServletPath().toLowerCase(Locale.ENGLISH)) || isMobile) {
            redirectUrl = String.format("%slogin-mobile.html", mainWebSite);
        } else {
            redirectUrl = "index.html";
            String loginType = request.getParameter("aiLoginType");
            if ("face".equalsIgnoreCase(loginType)) {
                redirectUrl = String.format("%slogin-face.html", mainWebSite);
            } else if ("voice".equalsIgnoreCase(loginType)) {
                redirectUrl = String.format("%slogin-voice.html", mainWebSite);
            } else if ("account".equalsIgnoreCase(loginType)) {
                redirectUrl = String.format("%slogin-account.html", mainWebSite);
            } else {
                redirectUrl = String.format("%slogin.html", mainWebSite);
                if (LoginUtils.isMCSystem()) {
                    redirectUrl = String.format("%slogin-mc.html", mainWebSite);
                }
            }
        }
        return redirectUrl;
    }

    private static boolean checkVerifyCode(HttpServletResponse servletResponse, String inputCode, String loginId) throws IOException {
        return LoginUtils.checkVerifyCode(servletResponse, inputCode, loginId, false);
    }

    public static String getNoceIndexHtml(HttpServletRequest request) {
        boolean debug = TRUE_STRING.equalsIgnoreCase(request.getParameter(KDWEB_DEBUG));
        String cdn = request.getParameter(KDWEB_CDN);
        String domainUrl = UrlService.getDomainContextUrl();
        StringBuilder sb = new StringBuilder();
        sb.append("<!DOCTYPE html>");
        sb.append("<html lang=\"en\">");
        sb.append("<head>");
        sb.append("    <meta charset=\"UTF-8\">");
        sb.append("    <meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\">");
        sb.append("    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=no\">");
        sb.append("    <link rel=\"icon\" href=\"").append(LoginUtils.getRelaRoot(domainUrl)).append("/public/thirdjs/image/favicon.ico\" type=\"image/x-icon\">");
        sb.append(String.format(ResManager.loadKDString((String)"%1s\u65e0\u4ee3\u7801\u5e73\u53f0%2s", (String)"LoginUtils_5", (String)BOS_LOGIN, (Object[])new Object[0]), "    <title>", "</title>"));
        sb.append("    <script>");
        if (StringUtils.isNotBlank((String)cdn)) {
            sb.append("     window.__kd_cdnPath__ = '" + cdn + "';");
        }
        if (debug) {
            sb.append("     window.__kd_debug__ = true;");
        }
        sb.append("    </script>");
        sb.append("    <script src=\"").append(LoginUtils.getRelaRoot(domainUrl)).append("/public/nocode/js/startup.js?v=").append(Long.toString(ID.genLongId())).append("\"></script>");
        sb.append("</head>");
        sb.append("<body>");
        sb.append("  <div id=\"app\"></div>");
        sb.append("</body>");
        sb.append("</html>");
        return sb.toString();
    }

    private static String getRelaRoot(String domainUrl) {
        String[] split = domainUrl.split("/");
        return "/" + split[split.length - 1];
    }

    public static boolean isNeedFilter(HttpServletRequest request, String tenantId) {
        StringBuffer requestURL = request.getRequestURL();
        if (request.getRequestURI().contains("/attachment/v1/3rd/file/onlyoffice") || request.getRequestURI().contains("/attachment/v3/3rd/")) {
            return false;
        }
        if (null != requestURL && !requestURL.toString().contains(".do")) {
            String[] shareid;
            String url = RevProxyUtil.addSlash((String)UrlService.getDomainContextUrl());
            String queryString = request.getQueryString();
            if (StringUtils.isNotEmpty((String)queryString)) {
                url = url + "?" + queryString;
                requestURL.append("?").append(queryString);
            }
            String contextPath = RevProxyUtil.addSlash((String)RevProxyUtil.getURLContextPath((HttpServletRequest)request));
            List<String> whiteListUrl = LoginUtils.getWhiteListUrl(contextPath);
            List<String> accountCookiesWhitePath = LoginUtils.getAccountCookiesWhitePath(tenantId);
            boolean contains = whiteListUrl.contains(url);
            boolean cookiesWhite = false;
            for (String s : accountCookiesWhitePath) {
                if (!requestURL.toString().contains(s)) continue;
                cookiesWhite = true;
                break;
            }
            if (contains || cookiesWhite) {
                return false;
            }
            String[] shares = requestURL.toString().split("/share/");
            if (shares.length > 1 && (shareid = shares[1].split("_")) != null && shareid.length > 2) {
                return false;
            }
        }
        return true;
    }

    private static List<String> getWhiteListUrl(String contextPath) {
        String[] arr;
        ArrayList<String> list = new ArrayList<String>(8);
        for (String s : arr = new String[]{"index.html/", "index.html/?formId=pc_main_console", "index.html/?formId=home_page", "?formId=home_page", "?formId=pc_main_console"}) {
            list.add(contextPath + s);
        }
        list.add(contextPath);
        return list;
    }

    public static void showNoAccountMsg(HttpServletRequest request, HttpServletResponse response) throws IOException {
        logger.info("kd_ac is empty,url is:" + request.getRequestURL().append("?").append(request.getQueryString()));
        HashMap<String, Object> mpErr = new HashMap<String, Object>(4);
        mpErr.put(SUCCESS, false);
        mpErr.put("errorCode", 1);
        mpErr.put("errorDesc", ResManager.loadKDString((String)"\u60a8\u8bbf\u95ee\u7684\u94fe\u63a5\u5730\u5740\u672a\u6307\u5b9a\u6570\u636e\u4e2d\u5fc3\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"LoginUtils_27", (String)BOS_LOGIN, (Object[])new Object[0]));
        String sLoginJson = kd.bos.util.JSONUtils.toString(mpErr);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)sLoginJson);
    }

    public static String getAccessToken(HttpServletRequest request) {
        String parameterAccessToken = LoginUtils.getParameterAccessToken(request);
        if (StringUtils.isNotBlank((String)parameterAccessToken)) {
            return parameterAccessToken;
        }
        return LoginUtils.getHeaderAccessToken(request);
    }

    public static String getParameterAccessToken(HttpServletRequest request) {
        String tenantId = RevProxyUtil.getTenantCode((HttpServletRequest)request);
        String accessName = SystemPropertyUtils.getProptyByTenant((String)"user_access_token_name", (String)tenantId);
        if (StringUtils.isEmpty((String)accessName)) {
            accessName = "access_token";
        }
        return request.getParameter(accessName);
    }

    public static String getHeaderAccessToken(HttpServletRequest request) {
        String sHeaderAccess_Token = request.getHeader("accessToken");
        if (StringUtils.isEmpty((String)sHeaderAccess_Token)) {
            sHeaderAccess_Token = request.getHeader("access_token");
        }
        return sHeaderAccess_Token;
    }

    private static void checkUserEnable(Account currentCenter, String userName, UserProperType userProperType) throws KDException {
        boolean isEnable = LoginUserService.checkUserEnable((Account)currentCenter, (String)userName, (UserProperType)userProperType);
        if (isEnable) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{String.format(ResManager.loadKDString((String)"\u7528\u6237\u5df2\u7981\u7528\uff0c\u65e0\u6cd5\u767b\u5f55\u3002", (String)"LoginUtils_18", (String)BOS_LOGIN, (Object[])new Object[0]), new Object[0])});
        }
    }

    public static String getAccountFromSSOOrHttp(HttpServletRequest request, String httpAccountId) {
        String accountId = SSOAnalysis.getAccountIdForSSO((HttpServletRequest)request);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)accountId)) {
            accountId = httpAccountId;
        }
        return accountId;
    }

    public static boolean isAPIForDataCenter(HttpServletRequest request) {
        return org.apache.commons.lang3.StringUtils.isBlank((CharSequence)LoginUtils.getAccessToken(request)) && !LoginUtils.isAPI(request);
    }

    public static boolean isAccountBoolean(HttpServletRequest request, LoginAccount loginAccount) {
        return SessionKeys.isAccountSession((String)loginAccount.getTenantId()) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)LoginUtils.getAccountFromSSOOrHttp(request, loginAccount.getAccountId())) && LoginUtils.isAPIForDataCenter(request) && LoginUtils.isNeedFilter(request, loginAccount.getTenantId());
    }

    public static String verifyPhoneNumber(String phoneNum) {
        DynamicObjectCollection countryDatas;
        List<String> areaNumbers;
        String telephoneStr;
        Map verifyResult;
        if (StringUtils.isEmpty((String)phoneNum)) {
            return ResManager.loadKDString((String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LoginUtils_31", (String)BOS_LOGIN, (Object[])new Object[0]);
        }
        String[] phoneNumArray = phoneNum.split("-");
        if (phoneNumArray.length <= 1) {
            return ResManager.loadKDString((String)"\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef\u3002", (String)"LoginUtils_32", (String)BOS_LOGIN, (Object[])new Object[0]);
        }
        String areaCode = phoneNumArray[0];
        if (!areaCode.contains("+")) {
            areaCode = "+" + areaCode;
        }
        if ((verifyResult = I18nServiceHelper.verifyTelephoneNumberFormat((String)(telephoneStr = phoneNumArray[1]), (String[])(areaNumbers = (countryDatas = QueryServiceHelper.query((String)"bd_country", (String)"id, number, areacode", (QFilter[])new QFilter[]{new QFilter("areacode", "=", (Object)areaCode)})).stream().map(data -> data.getString("number")).collect(Collectors.toList())).toArray(new String[0]))) != null && TRUE_STRING.equals(verifyResult.get("code"))) {
            return "";
        }
        return ResManager.loadKDString((String)"\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef\u3002", (String)"LoginUtils_32", (String)BOS_LOGIN, (Object[])new Object[0]);
    }

    public static String getKDCookieValue(HttpServletRequest request, String accountId) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null || cookies.length == 0) {
            return null;
        }
        LoginAccount loginAccount = LoginAccountFactory.createInstanceByHttpRequest((HttpServletRequest)request, Optional.empty());
        if (accountId == null || StringUtils.isBlank((String)accountId)) {
            accountId = loginAccount.getAccountId();
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(SessionKeys.getGlobalCookieSessionkey((String)loginAccount.getTenantId(), (String)accountId))) continue;
            return cookie.getValue();
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(SessionKeys.getGlobalCookieSessionkey((String)loginAccount.getTenantId()))) continue;
            return cookie.getValue();
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(SessionKeys.getOldGlobalCookieSessionkey())) continue;
            return cookie.getValue();
        }
        boolean compatible = Boolean.parseBoolean(SystemPropertyUtils.getProptyByTenant((String)"svc_login_account_session_compatible", (String)loginAccount.getTenantId()));
        if (compatible) {
            return LoginUtils.sessionCompatible(loginAccount.getTenantId(), request, cookies);
        }
        return null;
    }

    public static void removeCacheSession(String userId) throws Exception {
        String cacheKeyByClient = SessionServiceImpl.getCacheKeyByClient((String)userId, (String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId());
        String[] list = CacheLoginUtils.getList((String)cacheKeyByClient);
        for (int i = list.length - 1; i >= 0; --i) {
            String userInfo = list[i];
            Map cast = (Map)kd.bos.util.JSONUtils.cast((String)userInfo, Map.class);
            String s = (String)cast.get("sessionId");
            SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)s);
            if (!StringUtils.isEmpty((String)sessionDAO.getAttribute(USER_ID))) continue;
            CacheLoginUtils.removeListObject((String)cacheKeyByClient, (int)i);
        }
    }

    public static boolean isNeedWsdl(String path, HttpServletRequest request) {
        String queryS = request.getQueryString();
        if (StringUtils.isNotEmpty((String)queryS) && (queryS.equals("wsdl") || queryS.contains("wsdl="))) {
            String wsdlWitheListStr = kd.bos.session.SystemPropertyUtils.getProptyByTenant((String)WSDL_WHITE_LIST, (String)RevProxyUtil.getTenantId((HttpServletRequest)request));
            String wsdlWhitePattern = kd.bos.session.SystemPropertyUtils.getProptyByTenant((String)WSDL_WHITE_PATTERN, (String)RevProxyUtil.getTenantId((HttpServletRequest)request));
            if ("get".equalsIgnoreCase(request.getMethod()) && (path.contains("/kws/") || path.contains("/kapi/v2/")) && queryS.startsWith("wsdl")) {
                return true;
            }
            if (StringUtils.isNotEmpty((String)wsdlWitheListStr)) {
                List wsdlWitheList = SerializationUtils.fromJsonStringToList((String)wsdlWitheListStr, String.class);
                for (String wsdlWitheName : wsdlWitheList) {
                    if (!path.contains(wsdlWitheName)) continue;
                    return true;
                }
                return path.equals(wsdlWitheListStr);
            }
            if (StringUtils.isNotEmpty((String)wsdlWhitePattern)) {
                return Pattern.matches(wsdlWhitePattern, path);
            }
        }
        return path.endsWith("/kws/");
    }

    static {
        API_GUEST_USER_LIST.add("/kapi/app/mc/DataCenterMetaReBuildService");
        API_GUEST_USER_LIST.add("/kapi/app/mc/getlicensebytenantid");
        API_GUEST_USER_LIST.add("/kapi/app/mc/updateLicensefromEASCloud");
        API_GUEST_USER_LIST.add("/kapi/app/mc/getDataCenterStatusService");
        API_GUEST_USER_LIST.add("/kapi/app/mc/getEnvUpdateLogService");
        API_GUEST_USER_LIST.add("/kapi/app/mc/getUpgradestateService");
        API_GUEST_USER_LIST.add("/kapi/app/mc/DataSaveGetService");
        API_GUEST_USER_LIST.add("/kapi/app/mc/DataSaveSetService");
        API_GUEST_USER_LIST.add("/kapi/app/mc/GetDataCenterInfoService");
        API_GUEST_USER_LIST.add("/kapi/app/mc/GetDbInstanceInfoService");
        API_GUEST_USER_LIST.add("/kapi/app/mc/GetDbInstanceListService");
        API_GUEST_USER_LIST.add("/kapi/app/mc/GetTenantInfoService");
        API_GUEST_USER_LIST.add("/kapi/app/mc/UpgradeService");
        API_GUEST_USER_LIST.add("/kapi/app/mc/WebClientFilesSaveService");
        API_GUEST_USER_LIST.add("/kapi/app/mc/GetWebClientFilesService");
        API_GUEST_USER_LIST.add("/kapi/app/mc/GetSingleDataCenterInfoService");
        API_GUEST_USER_LIST.add("/kapi/app/mc/getRebuildDataResultService");
        API_GUEST_USER_LIST.add("/kapi/app/mc/getEnvUpdateLogService");
        API_GUEST_USER_LIST.add("/kapi/app/mc/GetCtripInfo");
        API_GUEST_USER_LIST.add("/kapi/app/mc/GetUpgradeStatus");
        API_GUEST_USER_LIST.add("/kapi/app/mc/ReleaseClusterService");
        API_GUEST_USER_LIST.add("/kapi/app/mc/SelfUpgradeRebuildDataService");
        API_GUEST_USER_LIST.add("/kapi/app/mc/GetEnvListDetailInfoService");
        API_GUEST_USER_LIST.add("/kapi/app/mc/GetTenantDetailInfoService");
        API_GUEST_USER_LIST.add("/kapi/app/mc/UpgradeInfoService");
        API_GUEST_USER_LIST.add("/tenant/updatelicensefromeascloud");
        API_GUEST_USER_LIST.add("/tenant/getlicensebytenantid");
        API_GUEST_USER_LIST.add("/datasave/get");
        API_GUEST_USER_LIST.add("/datasave/set");
        API_GUEST_USER_LIST.add("/login/tenantdb");
        API_GUEST_USER_LIST.add("/datacenter/getDbInstanceInfo");
        API_GUEST_USER_LIST.add("/datacenter/getSimpleDbInstanceList");
        API_GUEST_USER_LIST.add("/login/gettenantbyclustername");
        API_GUEST_USER_LIST.add("/environment/update");
        API_GUEST_USER_LIST.add("/login/singletenant");
        API_GUEST_USER_LIST.add("/login/getctripinfo");
        API_GUEST_USER_LIST.add("/environment/getEnvUpdateStatus");
        API_GUEST_USER_LIST.add("mcLogTable.html");
        API_GUEST_USER_LIST.add("mcLogDetail.html");
        API_GUEST_USER_LIST.add("/kapi/app/templic/checkPhoneService");
        API_GUEST_USER_LIST.add("/kapi/app/templic/getTemLicInfoService");
        API_GUEST_USER_LIST.add("/kapi/app/templic/saveTemLicInfoService");
        API_GUEST_USER_LIST.add("/kapi/app/templic/temLicLogService");
        API_GUEST_USER_LIST.add("/kapi/app/templic/getMCIDService");
        API_GUEST_USER_LIST.add("/kapi/app/templic/getMCKeyService");
        API_GUEST_USER_LIST.add("/kapi/app/templic/createTempLicService");
        FORWORD_URL_MAPPING.put("/tenant/updatelicensefromeascloud", "/kapi/app/mc/updateLicensefromEASCloud");
        FORWORD_URL_MAPPING.put("/tenant/getlicensebytenantid", "/kapi/app/mc/getlicensebytenantid");
        FORWORD_URL_MAPPING.put("/datasave/get", "/kapi/app/mc/DataSaveGetService");
        FORWORD_URL_MAPPING.put("/datasave/set", "/kapi/app/mc/DataSaveSetService");
        FORWORD_URL_MAPPING.put("/login/tenantdb", "/kapi/app/mc/GetDataCenterInfoService");
        FORWORD_URL_MAPPING.put("/datacenter/getDbInstanceInfo", "/kapi/app/mc/GetDbInstanceInfoService");
        FORWORD_URL_MAPPING.put("/datacenter/getSimpleDbInstanceList", "/kapi/app/mc/GetDbInstanceListService");
        FORWORD_URL_MAPPING.put("/login/gettenantbyclustername", "/kapi/app/mc/GetTenantInfoService");
        FORWORD_URL_MAPPING.put("/environment/update", "/kapi/app/mc/UpgradeService");
        FORWORD_URL_MAPPING.put("/login/singletenant", "/kapi/app/mc/GetSingleDataCenterInfoService");
        FORWORD_URL_MAPPING.put("/login/getctripinfo", "/kapi/app/mc/GetCtripInfo");
        FORWORD_URL_MAPPING.put("/environment/getEnvUpdateStatus", "/kapi/app/mc/GetUpgradeStatus");
    }
}

