/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.print;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.OperateOptionPrivate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.printop.OpPrintUtil;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.print.OldPrintOperationHelper;
import kd.bos.form.plugin.print.PrintOperationHelper;
import kd.bos.form.plugin.print.PrintSettingPlugin;
import kd.bos.list.IListView;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.mservice.print.BosPrintBusinessService;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.PrintJob;
import kd.bos.print.api.PrintParam;
import kd.bos.print.api.PrintTask;
import kd.bos.print.api.PrintWork;
import kd.bos.print.api.facade.param.PrintLogParam;
import kd.bos.print.api.utils.ConfigConstUtil;
import kd.bos.print.business.utils.OldPrintTemplateUtil;
import kd.bos.print.business.utils.PrintOpLogUtils;
import kd.bos.print.business.utils.PrintParamUtils;
import kd.bos.print.service.util.PrintClientUtil;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.PrintServiceHelper;
import kd.bos.servicehelper.print.NotePrintService;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.svc.util.print.PrtTaskResult;
import kd.bos.svc.util.print.PrtTaskResultServiceHelper;
import kd.bos.template.orgctrl.service.PrintTemplateServiceFactory;
import kd.bos.template.orgctrl.utils.ParamUtils;

public class PrintSelectTemplatePlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String SELECT_TEMPLATE = "selecttemplate";
    private static final String SELECT_TEMPLATE_FLEX = "flexpanelap2";
    private static final String FILE_TYPE = "filetype";
    private static final String CONFIG_CACHE_KEY = "_printSelectTplConfig";
    private static final String FORMID = "formid";
    private static final String BOS_NOTEPRINT = "bos-noteprint";
    private static final Log log = LogFactory.getLog(PrintSelectTemplatePlugin.class);
    private static final String SELECT_PRINTER = "selectprinter";
    private static final String CLOUD_PRINTER = "cloudPrinter";
    private PrintClientUtil.CloudPrinter cloudPrinter;
    private boolean existNewTpl = false;
    private boolean existOldTpl = false;
    private List<Object> ids = new ArrayList<Object>(10);
    private Map<String, Object> settingData;

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnconfilm", "btncancel"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String formId = (String)this.getView().getFormShowParameter().getCustomParam(FORMID);
        if (!this.checkPrintType("selectTpl")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"filetypeflexap"});
        } else {
            Map selectTplConfigMap;
            String fileType;
            String printSelectTplConfigJson = UserConfigServiceHelper.getSetting((long)RequestContext.get().getCurrUserId(), (String)this.getCacheKey());
            if (StringUtils.isNotBlank((CharSequence)printSelectTplConfigJson) && StringUtils.isNotBlank((CharSequence)(fileType = (String)(selectTplConfigMap = (Map)SerializationUtils.fromJsonString((String)printSelectTplConfigJson, Map.class)).get(FILE_TYPE)))) {
                this.getModel().setValue(FILE_TYPE, (Object)fileType);
            }
        }
        String text = (String)this.getView().getFormShowParameter().getCustomParam("text");
        if (StringUtils.isBlank((CharSequence)formId)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5355\u636e\u6807\u8bc6\u4e3a\u7a7a\u3002", (String)"PrintingSchemePlugin_0", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
            return;
        }
        Label label = (Label)this.getControl("labelap");
        label.setText(text);
        if (text != null) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"imageap"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"imageap"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"labelap"});
        }
        boolean isShowPrintType = this.isShowPrintType();
        if (!isShowPrintType) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"printtypepanelap"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{SELECT_TEMPLATE_FLEX});
        }
        this.initDefaultCombo();
        String userId = RequestContext.get().getUserId();
        String key = formId + "_printsetting";
        String settingData = UserConfigServiceHelper.getSetting((long)Long.parseLong(userId), (String)key);
        if (StringUtils.isNotBlank((CharSequence)settingData)) {
            PrintClientUtil.CloudPrinter cloudPrinter;
            Map jsonData = (Map)SerializationUtils.fromJsonString((String)settingData, Map.class);
            String curLang = (String)jsonData.get("printlang");
            if (curLang == null) {
                curLang = RequestContext.get().getLang().toString();
            }
            this.getPageCache().put("CACHE_LANG", curLang);
            Object printerId = jsonData.get("printerid");
            this.getModel().setValue(SELECT_PRINTER, printerId);
            if (printerId != null && (cloudPrinter = PrintClientUtil.getCloudPrinter((long)Long.parseLong(printerId.toString()))) != null) {
                this.getPageCache().put(CLOUD_PRINTER, SerializationUtils.toJsonString((Object)cloudPrinter));
            }
        }
    }

    public PrintClientUtil.CloudPrinter getCloudPrinter() {
        if (this.cloudPrinter != null) {
            return this.cloudPrinter;
        }
        String str = this.getPageCache().get(CLOUD_PRINTER);
        if (StringUtils.isNotBlank((CharSequence)str)) {
            this.cloudPrinter = (PrintClientUtil.CloudPrinter)SerializationUtils.fromJsonString((String)str, PrintClientUtil.CloudPrinter.class);
        }
        if (this.cloudPrinter == null) {
            this.cloudPrinter = new PrintClientUtil.CloudPrinter();
        }
        return this.cloudPrinter;
    }

    private boolean isShowPrintType() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        boolean isShowPrintType = false;
        if (customParams.containsKey("isShowPrintType")) {
            isShowPrintType = Boolean.parseBoolean(String.valueOf(customParams.get("isShowPrintType")));
        }
        return isShowPrintType;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button btn = (Button)evt.getSource();
        if ("btnconfilm".equals(btn.getKey())) {
            boolean isShowPrintType = this.isShowPrintType();
            if (isShowPrintType) {
                Object printType = this.getView().getModel().getValue("radiogroupfield");
                if (StringUtils.equals((CharSequence)String.valueOf(printType), (CharSequence)"1")) {
                    this.doPrint(null);
                } else {
                    String templateId = (String)this.getModel().getValue(SELECT_TEMPLATE);
                    if (StringUtils.isBlank((CharSequence)templateId)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u3002", (String)"PrintSelectTemplatePlugin_3", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
                        return;
                    }
                    this.setParamJob(templateId, "newPrintJobs");
                    this.setParamJob(templateId, "oldPrintJobs");
                    this.doPrint(null);
                }
                return;
            }
            String templateId = (String)this.getModel().getValue(SELECT_TEMPLATE);
            if (StringUtils.isBlank((CharSequence)templateId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u3002", (String)"PrintSelectTemplatePlugin_3", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
                return;
            }
            if (this.checkPrintType("selectTpl")) {
                HashMap<String, String> config = new HashMap<String, String>(1);
                config.put(FILE_TYPE, String.valueOf(this.getModel().getValue(FILE_TYPE)));
                config.put(SELECT_TEMPLATE, String.valueOf(this.getModel().getValue(SELECT_TEMPLATE)));
                UserConfigServiceHelper.setSetting((long)RequestContext.get().getCurrUserId(), (String)this.getCacheKey(), (String)SerializationUtils.toJsonString(config));
            }
            this.doPrint(templateId);
        } else {
            this.getView().close();
        }
    }

    private void log() {
        AppLogInfo appLogInfo = this.getBean("appLogInfo", AppLogInfo.class);
        PrintLogParam logParam = this.getBean("printLogParam", PrintLogParam.class);
        PrintOpLogUtils.addOpLog((PrintLogParam)logParam, (AppLogInfo)appLogInfo);
    }

    private <T> T getBean(String key, Class<T> t) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object appLogInfoJson = parameter.getCustomParam(key);
        if (StringUtils.isBlank((Object)appLogInfoJson)) {
            return null;
        }
        Object appLogInfo = SerializationUtils.fromJsonString((String)((String)appLogInfoJson), t);
        return (T)appLogInfo;
    }

    private IFormView getParentView() {
        try {
            IFormView parentView = this.getView().getParentView();
            if (parentView == null) {
                parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
            }
            return parentView;
        }
        catch (Throwable e) {
            log.error(e);
            return this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        }
    }

    private void setParamJob(String templateId, String jobKey) {
        List<PrintJob> jobs = this.getPrintJobs(jobKey);
        ArrayList<PrintJob> newJobs = new ArrayList<PrintJob>(1);
        for (PrintJob job : jobs) {
            if (!StringUtils.equals((CharSequence)String.valueOf(job.getTemplateId()), (CharSequence)templateId)) continue;
            newJobs.add(job);
        }
        this.getView().getFormShowParameter().setCustomParam(jobKey, (Object)SerializationUtils.toJsonString(newJobs));
    }

    private List<PrintJob> getPrintJobs(String jobKey) {
        Object printJobs = this.getView().getFormShowParameter().getCustomParam(jobKey);
        List<Object> jobs = new ArrayList<PrintJob>(0);
        if (StringUtils.isNotBlank((Object)printJobs)) {
            jobs = SerializationUtils.fromJsonStringToList((String)((String)printJobs), PrintJob.class);
        }
        return jobs;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        if (StringUtils.equals((CharSequence)property.getName(), (CharSequence)"radiogroupfield")) {
            ChangeData[] changeSet = e.getChangeSet();
            if (changeSet == null || changeSet[0] == null) {
                return;
            }
            String newValue = String.valueOf(changeSet[0].getNewValue());
            if (StringUtils.equals((CharSequence)newValue, (CharSequence)"1")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{SELECT_TEMPLATE_FLEX});
            }
            if (StringUtils.equals((CharSequence)newValue, (CharSequence)"2")) {
                this.getView().setVisible(Boolean.TRUE, new String[]{SELECT_TEMPLATE_FLEX});
            }
        }
    }

    private void initDefaultCombo() {
        Map templates;
        String formId = (String)this.getView().getFormShowParameter().getCustomParam(FORMID);
        String invisibleFilterTemplateId = (String)this.getView().getFormShowParameter().getCustomParam("invisibleFilterTemplateId");
        String matchFilterTemplateIdJson = (String)this.getView().getFormShowParameter().getCustomParam("matchFilterTemplateId");
        Set matchFilterTemplateId = new LinkedHashSet();
        if (StringUtils.isNotBlank((CharSequence)matchFilterTemplateIdJson)) {
            matchFilterTemplateId = (Set)SerializationUtils.fromJsonString((String)matchFilterTemplateIdJson, LinkedHashSet.class);
        }
        List invisibleFilterTemplateIdList = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)invisibleFilterTemplateId)) {
            invisibleFilterTemplateIdList = SerializationUtils.fromJsonStringToList((String)invisibleFilterTemplateId, String.class);
        }
        Map map = templates = ParamUtils.isTemplateOrgIsolated() ? PrintTemplateServiceFactory.getService().getUserPermPrintTemplateMap(formId, this.getView().getFormShowParameter().getAppId()) : this.getTemplates(formId);
        if (!templates.isEmpty()) {
            boolean isShowPrintType = this.isShowPrintType();
            ComboEdit defaultCombo = (ComboEdit)this.getView().getControl(SELECT_TEMPLATE);
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
            if (isShowPrintType) {
                for (String string : matchFilterTemplateId) {
                    if (!templates.containsKey(string)) continue;
                    String value = (String)templates.get(string);
                    ComboItem item = new ComboItem();
                    item.setValue(string);
                    item.setCaption(new LocaleString(value));
                    comboItems.add(item);
                }
            } else {
                for (Map.Entry entry : templates.entrySet()) {
                    if (invisibleFilterTemplateIdList.contains(entry.getKey())) continue;
                    ComboItem item = new ComboItem();
                    item.setValue((String)entry.getKey());
                    item.setCaption(new LocaleString((String)entry.getValue()));
                    comboItems.add(item);
                }
            }
            defaultCombo.setComboItems(comboItems);
            if (this.checkPrintType("selectTpl")) {
                String setting = UserConfigServiceHelper.getSetting((long)RequestContext.get().getCurrUserId(), (String)this.getCacheKey());
                if (StringUtils.isNotBlank((CharSequence)setting)) {
                    Map map2 = (Map)SerializationUtils.fromJsonString((String)setting, Map.class);
                    String tpl = (String)map2.get(SELECT_TEMPLATE);
                    if (StringUtils.isBlank((CharSequence)tpl)) {
                        tpl = PrintSettingPlugin.getManageDefaultTemplateId((String)formId);
                    }
                    if (templates.containsKey(tpl)) {
                        this.getModel().setValue(SELECT_TEMPLATE, (Object)tpl);
                    }
                } else {
                    String string = PrintSettingPlugin.getManageDefaultTemplateId((String)formId);
                    this.getModel().setValue(SELECT_TEMPLATE, (Object)string);
                }
            }
        }
    }

    private String getCacheKey() {
        String formId = (String)this.getView().getFormShowParameter().getCustomParam(FORMID);
        return formId + CONFIG_CACHE_KEY;
    }

    private Map<String, String> getTemplates(String formId) {
        DynamicObject[] dynamicObjects;
        QFilter[] qFilterArray;
        String id = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form);
        FormMetadata fm = (FormMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Form);
        String oriFormId = MetadataDao.getNumberById((String)fm.getEntityId());
        LinkedHashMap<String, String> templateMap = new LinkedHashMap<String, String>(16);
        if (ConfigConstUtil.isNewTenantOfVersion((int)7)) {
            QFilter[] qFilterArray2 = new QFilter[2];
            qFilterArray2[0] = new QFilter("billformid", "=", (Object)oriFormId);
            qFilterArray = qFilterArray2;
            qFilterArray2[1] = new QFilter("type", "!=", (Object)"A");
        } else {
            QFilter[] qFilterArray3 = new QFilter[1];
            qFilterArray = qFilterArray3;
            qFilterArray3[0] = new QFilter("billformid", "=", (Object)oriFormId);
        }
        for (DynamicObject obj : dynamicObjects = BusinessDataServiceHelper.load((String)"bos_manageprinttpl", (String)"number, name, enable,type,printtplid", (QFilter[])qFilterArray)) {
            DynamicObject printtpObj = obj.getDynamicObject("printtplid");
            Object tplId = obj.get("printtplid_id");
            String enable = obj.getString("enable");
            if ("0".equals(enable)) continue;
            if (printtpObj == null || !"B".equals(printtpObj.get("type"))) {
                QFilter qFilter = new QFilter("id", "=", tplId);
                DynamicObject formMeta = OldPrintTemplateUtil.loadSingleFromCache((String)"id,number,bizappid,basedatafield,modifierid", (QFilter[])new QFilter[]{qFilter});
                if (formMeta == null) continue;
                templateMap.put(tplId.toString(), formMeta.getLocaleString("name").getLocaleValue());
                continue;
            }
            templateMap.put(tplId.toString(), printtpObj.getLocaleString("name").getLocaleValue());
        }
        return templateMap;
    }

    private void doPrint(String tplId) {
        int size;
        Object sortPkids;
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String formId = (String)showParameter.getCustomParam(FORMID);
        int selectNum = 0;
        Object pkids = showParameter.getCustomParam("pkids");
        if (pkids != null) {
            selectNum = ((List)pkids).size();
        }
        if ((sortPkids = showParameter.getCustomParam("sortPkids")) instanceof List && !CollectionUtils.isEmpty((Collection)((List)sortPkids)) && (size = ((List)sortPkids).size()) > selectNum) {
            selectNum = size;
        }
        Map<String, Object> printSetting = this.getPrintSetting();
        int maxZipFileNum = PrintParamUtils.getMaxBillNoCreateFileNum();
        if ("pdf".equals(this.getModel().getValue(FILE_TYPE)) && printSetting != null && "2".equals(printSetting.get("fileCreateType")) && selectNum > maxZipFileNum) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6309\u4e0d\u540c\u5355\u636e\u751f\u6210\u591a\u4e2aPDF\uff0c\u6279\u91cf\u6253\u5370\u6700\u5927\u652f\u6301%s\u5f20\u5355\u636e\u3002", (String)"AbstractPrint_48", (String)BOS_NOTEPRINT, (Object[])new Object[]{maxZipFileNum}));
            return;
        }
        boolean isNewTpl = this.isNewTpl(tplId);
        if (!this.checkPrintType("print") && !this.checkPrintType(PrintWork.EXP_TYPE.EXP_CLIENTPREVIEW.getCode())) {
            OperateOptionPrivate option = new OperateOptionPrivate();
            if (showParameter.getCustomParams().containsKey("showprogressrowcount")) {
                option.setVariableValue("showprogressrowcount", String.valueOf(showParameter.getCustomParams().get("showprogressrowcount")));
            }
            if (OpPrintUtil.checkToShowProgress((OperateOption)option, (String)formId, (int)selectNum)) {
                OpPrintUtil.TaskParam taskParam = this.getTaskParam(this.getView().getFormShowParameter(), tplId, selectNum);
                OpPrintUtil.showProgressForm((OpPrintUtil.TaskParam)taskParam);
                this.getView().sendFormAction(taskParam.getView());
                this.log();
                List distinctIds = this.ids.stream().distinct().collect(Collectors.toList());
                PrintOperationHelper.updatePrintCountField((String)((String)showParameter.getCustomParam(FORMID)), distinctIds);
                this.getView().close();
                return;
            }
        }
        String taskId = String.valueOf(DB.genLongId((String)"t_svc_printresult"));
        try {
            this.doNewPreview(taskId, isNewTpl ? tplId : null);
            this.log();
            if (!this.doOldPreview(taskId, isNewTpl ? null : tplId)) {
                return;
            }
            if (!this.checkPrintType(PrintWork.EXP_TYPE.EXP_CLIENTPREVIEW.getCode())) {
                PrtTaskResult taskResult = PrtTaskResultServiceHelper.getPrtResult((String)taskId);
                List attachList = taskResult.getAttach();
                IFormView parentView = this.getParentView();
                if (this.checkPrintType("printexportexcel")) {
                    this.xlsPrint(taskId, attachList);
                    this.getView().close();
                    return;
                }
                if (this.checkPrintType("print")) {
                    this.print(taskId, attachList, parentView);
                } else if (this.checkPrintType("selectTpl")) {
                    Object filetype = this.getModel().getValue(FILE_TYPE);
                    if ("excel".equals(filetype)) {
                        this.xlsPrint(taskId, attachList);
                        this.getView().close();
                        return;
                    }
                    this.printPreview(taskResult, parentView);
                } else {
                    this.printPreview(taskResult, parentView);
                }
                List distinctIds = this.ids.stream().distinct().collect(Collectors.toList());
                PrintOperationHelper.updatePrintCountField((String)((String)showParameter.getCustomParam(FORMID)), distinctIds);
            }
            this.getView().close();
        }
        catch (Exception e) {
            if (e instanceof KDBizException) {
                IFormView parentView = this.getView().getViewNoPlugin(showParameter.getParentPageId());
                parentView.showTipNotification(e.getMessage());
                this.getView().sendFormAction(parentView);
                this.getView().close();
            }
            throw e;
        }
    }

    private OpPrintUtil.TaskParam getTaskParam(FormShowParameter parameter, String tplId, int selectNum) {
        String formId = (String)parameter.getCustomParam(FORMID);
        Object pkids = parameter.getCustomParam("pkids");
        boolean isNewTpl = this.isNewTpl(tplId);
        Object sortPkids = parameter.getCustomParam("sortPkids");
        Object printJobs = parameter.getCustomParam("newPrintJobs");
        List<PrintJob> newPrintJobs = new ArrayList(10);
        String parentPageId = parameter.getParentPageId();
        if (isNewTpl && pkids != null && tplId != null) {
            PrintJob job = new PrintJob();
            job.setBillIds((List)pkids);
            job.setFormId(formId);
            job.setPageId(parentPageId);
            job.setTemplateId((Object)tplId);
            newPrintJobs.add(job);
        }
        if (!ObjectUtils.isEmpty((Object)printJobs)) {
            List selectJobs = SerializationUtils.fromJsonStringToList((String)((String)printJobs), PrintJob.class);
            newPrintJobs.addAll(selectJobs);
        }
        if (sortPkids instanceof List && !CollectionUtils.isEmpty((Collection)((List)sortPkids))) {
            newPrintJobs = PrintOperationHelper.sortAndMergeJobs((List)((List)sortPkids), newPrintJobs);
        }
        List<PrintJob> oldPrintJobs = this.buildOldPrintJobs(isNewTpl ? null : tplId);
        IFormView parentView = SessionManager.getCurrent().getViewNoPlugin(parentPageId);
        HashMap<String, List<PrintJob>> classifyPrintJob = new HashMap<String, List<PrintJob>>(2);
        classifyPrintJob.put("newPrintJobs", newPrintJobs);
        classifyPrintJob.put("oldPrintJobs", oldPrintJobs);
        Map<String, Object> printSetting = this.getPrintSetting();
        OpPrintUtil.TaskParam taskParam = new OpPrintUtil.TaskParam();
        taskParam.setClassifyPrintJob(classifyPrintJob);
        taskParam.setView(parentView);
        taskParam.setEntityTypeId(PrintServiceHelper.getRealBillFormId((String)formId));
        taskParam.setExtParamMap(this.getExtParam());
        taskParam.setFormId(formId);
        taskParam.setOpKey("selectPrint");
        taskParam.setPrintSetting(printSetting);
        taskParam.setPkIdsJson(StringUtils.isNotBlank((Object)pkids) ? SerializationUtils.toJsonString((Object)pkids) : "");
        taskParam.setSelectRows(selectNum);
        if (this.checkPrintType("printexportexcel") || this.checkPrintType("selectTpl") && "excel".equals(this.getModel().getValue(FILE_TYPE))) {
            taskParam.setExpType(PrintWork.EXP_TYPE.EXP_XLS);
        } else if ("1".equals(printSetting.get("previewtype"))) {
            taskParam.setExpType(PrintWork.EXP_TYPE.EXP_SCPT);
        }
        return taskParam;
    }

    private void printPreview(PrtTaskResult taskResult, IFormView parentView) {
        String taskId = taskResult.getTaskId();
        List attachList = taskResult.getAttach();
        if (PrintWork.EXP_TYPE.EXP_SCPT.getCode().equals(taskResult.getExtType())) {
            Object hideLocalPreview = this.getPrintSetting().get("nlocalpreview");
            PrintOperationHelper.clientLocalPrint((IFormView)this.getView(), (IFormView)this.getView(), (PrtTaskResult)taskResult, (!Boolean.parseBoolean(String.valueOf(hideLocalPreview)) ? 1 : 0) != 0);
            return;
        }
        PrintOperationHelper.preview((IFormView)this.getView(), (IFormView)parentView, (Object)taskId, (List)attachList);
    }

    private void print(String taskId, List<PrtTaskResult.Attach> attachList, IFormView parentView) {
        NotePrintService printSvr = new NotePrintService();
        boolean printResult = true;
        Object printer = this.getModel().getValue(SELECT_PRINTER);
        if (!(printer instanceof DynamicObject)) {
            String msg = ResManager.loadKDString((String)"\u6ca1\u6709\u8bbe\u7f6e\u6253\u5370\u673a\uff0c\u8bf7\u5728\u201c\u6253\u5370\u201d->\u201c\u6253\u5370\u8bbe\u7f6e\u201d\u4e2d\u8fdb\u884c\u8bbe\u7f6e\u3002", (String)"AbstractPrint_6", (String)BOS_NOTEPRINT, (Object[])new Object[0]);
            parentView.showSuccessNotification(msg);
            this.getView().sendFormAction(parentView);
            return;
        }
        DynamicObject printerObj = (DynamicObject)printer;
        Object printerId = printerObj.getPkValue();
        if (!"B".equals(this.getCloudPrinter().getServiceType())) {
            PrtTaskResult.Attach attach;
            Iterator<PrtTaskResult.Attach> iterator = attachList.iterator();
            while (iterator.hasNext() && (printResult = printSvr.createPrintJob((attach = iterator.next()).getAttachId(), attach.getAttachId(), attach.getFilePath(), new LocaleString(attach.getFileName()), printerId))) {
            }
        } else if (this.existOldTpl && !this.existNewTpl) {
            String message = ResManager.loadKDString((String)"\u65e7\u6a21\u677f\u4e0d\u652f\u6301\u5ba2\u6237\u7aef\u6253\u5370\uff0c\u8bf7\u5347\u7ea7\u4e3a\u65b0\u6a21\u677f\u540e\u4f7f\u7528\u3002", (String)"Print_6", (String)BOS_NOTEPRINT, (Object[])new Object[0]);
            parentView.showTipNotification(message);
            this.getView().sendFormAction(parentView);
            return;
        }
        if (printResult) {
            String message = ResManager.loadKDString((String)"\u6253\u5370\u8bf7\u6c42\u53d1\u9001\u6210\u529f\u3002", (String)"Print_7", (String)BOS_NOTEPRINT, (Object[])new Object[0]);
            parentView.showSuccessNotification(message);
            this.getView().sendFormAction(parentView);
        }
    }

    private void xlsPrint(String taskId, List<PrtTaskResult.Attach> attachList) {
        for (PrtTaskResult.Attach attach : attachList) {
            String downloadUrl = "api/print/download.do?taskId=%s&attachId=%s";
            downloadUrl = String.format(downloadUrl, taskId, attach.getAttachId());
            this.getView().download(downloadUrl);
        }
    }

    private List<PrintJob> buildOldPrintJobs(String tplId) {
        String formId = (String)this.getView().getFormShowParameter().getCustomParam(FORMID);
        Object pkids = this.getView().getFormShowParameter().getCustomParam("pkids");
        Object sortPkids = this.getView().getFormShowParameter().getCustomParam("sortPkids");
        Object type = this.getView().getFormShowParameter().getCustomParam("type");
        Object printJobs = this.getView().getFormShowParameter().getCustomParam("oldPrintJobs");
        String jobName = (String)this.getView().getFormShowParameter().getCustomParam("jobname");
        List<PrintJob> jobs = new ArrayList();
        if (!ObjectUtils.isEmpty((Object)printJobs)) {
            jobs = SerializationUtils.fromJsonStringToList((String)((String)printJobs), PrintJob.class);
        }
        if (pkids != null && tplId != null) {
            String templateFormId = MetadataDao.getNumberById((String)tplId);
            if (StringUtils.isBlank((Object)templateFormId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6253\u5370\u6a21\u677f\u3002", (String)"PrintSelectTemplatePlugin_1", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
            }
            PrintJob jb = new PrintJob(this.getView().getPageId(), formId);
            jb.setBillIds((List)pkids);
            jb.setName(jobName);
            jb.setTemplateId((Object)tplId);
            jobs.add(jb);
        }
        if (sortPkids instanceof List && !CollectionUtils.isEmpty((Collection)((List)sortPkids))) {
            jobs = PrintOperationHelper.sortAndMergeJobs((List)((List)sortPkids), jobs);
        }
        return jobs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean doOldPreview(String taskId, String tplId) {
        List<PrintJob> jobs = this.buildOldPrintJobs(tplId);
        if (jobs == null || jobs.isEmpty()) {
            return true;
        }
        this.existOldTpl = true;
        Map<String, Object> extParam = this.getExtParam();
        for (PrintJob job : jobs) {
            if (job.getBillIds() == null || job.getBillIds().isEmpty()) continue;
            this.ids.addAll(job.getBillIds());
        }
        if (this.checkPrintType("printexportexcel")) {
            OldPrintOperationHelper.doPrint((String)taskId, (String)"xls", jobs, extParam);
            return true;
        } else {
            if (this.checkPrintType(PrintWork.EXP_TYPE.EXP_CLIENTPREVIEW.getCode()) && jobs.size() > 0) {
                String message = ResManager.loadKDString((String)"\u65e7\u6a21\u677f\u4e0d\u652f\u6301\u5ba2\u6237\u7aef\u6253\u5370\uff0c\u8bf7\u5347\u7ea7\u4e3a\u65b0\u6a21\u677f\u540e\u4f7f\u7528\u3002", (String)"Print_6", (String)BOS_NOTEPRINT, (Object[])new Object[0]);
                this.oldTemplateUpgradeTips(message);
                return false;
            }
            if (this.checkPrintType("selectTpl")) {
                Object filetype = this.getModel().getValue(FILE_TYPE);
                if ("excel".equals(filetype)) {
                    OldPrintOperationHelper.doPrint((String)taskId, (String)"xls", jobs, extParam);
                    return true;
                } else {
                    OldPrintOperationHelper.doPrint((String)taskId, (String)"pdf", jobs, extParam);
                }
                return true;
            } else if (this.checkPrintType("print")) {
                if ("B".equals(this.getCloudPrinter().getServiceType())) return true;
                OldPrintOperationHelper.doPrint((String)taskId, (String)"pdf", jobs, extParam);
                return true;
            } else {
                String previewType = (String)this.getPrintSetting().get("previewtype");
                if (this.checkPrintType("printpreview") && "1".equals(previewType)) {
                    String message = ResManager.loadKDString((String)"\u65e7\u6a21\u677f\u4e0d\u652f\u6301\u672c\u5730\u6253\u5370\uff0c\u8bf7\u5347\u7ea7\u4e3a\u65b0\u6a21\u677f\u540e\u4f7f\u7528\u3002", (String)"PrintPreviewClientCallback_4", (String)BOS_NOTEPRINT, (Object[])new Object[0]);
                    this.oldTemplateUpgradeTips(message);
                    return false;
                }
                OldPrintOperationHelper.doPrint((String)taskId, (String)"pdf", jobs, extParam);
            }
        }
        return true;
    }

    private Map<String, Object> getExtParam() {
        Object extParamJson = this.getView().getFormShowParameter().getCustomParam("extParam");
        if (StringUtils.isNotBlank((Object)extParamJson)) {
            return (Map)SerializationUtils.fromJsonString((String)((String)extParamJson), Map.class);
        }
        return new HashMap<String, Object>(0);
    }

    private void oldTemplateUpgradeTips(String message) {
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        IFormView parentView = this.getView().getViewNoPlugin(parentPageId);
        parentView.showTipNotification(message);
        this.getView().sendFormAction(parentView);
        this.getView().close();
    }

    private PrintParam buildNewPrintJobs(String taskId, String tplId) {
        String formId = (String)this.getView().getFormShowParameter().getCustomParam(FORMID);
        Object pkids = this.getView().getFormShowParameter().getCustomParam("pkids");
        Object sortPkids = this.getView().getFormShowParameter().getCustomParam("sortPkids");
        Object printJobs = this.getView().getFormShowParameter().getCustomParam("newPrintJobs");
        ArrayList<PrintTask> taskList = new ArrayList<PrintTask>(10);
        List<PrintJob> jobs = new ArrayList(10);
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        if (pkids != null && tplId != null) {
            PrintJob job = new PrintJob();
            job.setBillIds((List)pkids);
            job.setFormId(formId);
            job.setPageId(parentPageId);
            job.setTemplateId((Object)tplId);
            jobs.add(job);
        }
        if (!ObjectUtils.isEmpty((Object)printJobs)) {
            List selectJobs = SerializationUtils.fromJsonStringToList((String)((String)printJobs), PrintJob.class);
            jobs.addAll(selectJobs);
        }
        if (sortPkids instanceof List && !CollectionUtils.isEmpty((Collection)((List)sortPkids))) {
            jobs = PrintOperationHelper.sortAndMergeJobs((List)((List)sortPkids), jobs);
        }
        for (PrintJob job : jobs) {
            PrintTask task = new PrintTask();
            task.setPkIds(job.getBillIds());
            task.setFormId(job.getFormId());
            task.setPageId(job.getPageId());
            task.setTplId(String.valueOf(job.getTemplateId()));
            task.setPrintType("billForm");
            taskList.add(task);
        }
        ArrayList<PrintTask> sortTaskList = new ArrayList<PrintTask>(10);
        if (taskList.isEmpty()) {
            return null;
        }
        sortTaskList.addAll(taskList);
        PrintParam param = new PrintParam();
        param.setPageId(((PrintTask)sortTaskList.get(0)).getPageId());
        param.setPrintLang(this.getPrintLang());
        param.setPrinterName(this.getCloudPrinter().getPrinterName());
        param.setServiceN(this.getCloudPrinter().getServiceN());
        if (this.checkPrintType("printexportexcel")) {
            param.setExpType("xls");
        } else if (this.checkPrintType("print")) {
            if ("B".equals(this.getCloudPrinter().getServiceType())) {
                param.setExpType(PrintWork.EXP_TYPE.EXP_CLIENT.getCode());
            } else {
                param.setExpType("pdf");
            }
        } else if (this.checkPrintType(PrintWork.EXP_TYPE.EXP_CLIENTPREVIEW.getCode())) {
            param.setExpType(PrintWork.EXP_TYPE.EXP_CLIENTPREVIEW.getCode());
            PrintOperationHelper.clientPreview((IFormView)this.getView(), (IFormView)this.getView().getParentView(), (Object)taskId, (List)((List)sortPkids), (String)SerializationUtils.toJsonString(jobs));
        } else if (this.checkPrintType("selectTpl")) {
            Object filetype = this.getModel().getValue(FILE_TYPE);
            if ("excel".equals(filetype)) {
                param.setExpType("xls");
            } else {
                param.setExpType("pdf");
            }
        } else {
            param.setExpType("pdf");
        }
        param.setTaskList(sortTaskList);
        IFormView parentView = this.getView().getViewNoPlugin(parentPageId);
        String billFormId = parentView.getFormShowParameter().getFormId();
        if (parentView instanceof IMobileView) {
            MobileBillShowParameter mo = (MobileBillShowParameter)parentView.getFormShowParameter();
            billFormId = mo.getFormConfig().getEntityTypeId();
        } else if (parentView instanceof IListView) {
            billFormId = ((ListView)parentView).getBillFormId();
        }
        param.setBillFormId(billFormId);
        Map<String, Object> extParam = this.getExtParam();
        param.setExtParam(extParam);
        return param;
    }

    private boolean checkPrintType(String printType) {
        Object type = this.getView().getFormShowParameter().getCustomParam("type");
        boolean isPrintExcel = StringUtils.equals((CharSequence)printType, (CharSequence)String.valueOf(type));
        return isPrintExcel;
    }

    private void doNewPreview(String taskId, String tplId) {
        PrintParam param = this.buildNewPrintJobs(taskId, tplId);
        if (param == null) {
            return;
        }
        List taskList = param.getTaskList();
        if (taskList.isEmpty()) {
            return;
        }
        this.existNewTpl = true;
        for (PrintTask task : taskList) {
            this.ids.addAll(task.getPkIds());
        }
        String previewType = (String)this.getPrintSetting().get("previewtype");
        if (this.checkPrintType("printpreview") && "1".equals(previewType)) {
            param.setExpType(PrintWork.EXP_TYPE.EXP_SCPT.getCode());
        }
        BosPrintBusinessService service = (BosPrintBusinessService)ServiceFactory.getService(BosPrintBusinessService.class);
        service.doPrint(taskId, (Object)param);
    }

    private boolean isNewTpl(String tplId) {
        if (tplId == null) {
            return false;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_manageprinttpl", (String)"id,type,printtplid_id", (QFilter[])new QFilter[]{new QFilter("PRINTTPLID", "=", (Object)tplId)});
        if (dynamicObject == null) {
            return false;
        }
        String type = dynamicObject.getString("type");
        return "B".equals(type);
    }

    private Map<String, Object> getPrintSetting() {
        if (this.settingData != null) {
            return this.settingData;
        }
        String userId = RequestContext.get().getUserId();
        String formId = (String)this.getView().getFormShowParameter().getCustomParam(FORMID);
        String key = formId + "_printsetting";
        String setting = UserConfigServiceHelper.getSetting((long)Long.parseLong(userId), (String)key);
        if (StringUtils.isNotBlank((CharSequence)setting)) {
            this.settingData = (Map)SerializationUtils.fromJsonString((String)setting, Map.class);
            return this.settingData;
        }
        return Collections.emptyMap();
    }

    private String getPrintLang() {
        String curLang = RequestContext.get().getLang().toString();
        Map<String, Object> printSettingMap = this.getPrintSetting();
        String printlang = (String)printSettingMap.get("printlang");
        if (printlang != null) {
            curLang = printlang;
        }
        return curLang;
    }
}

