/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.template.orgctrl.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.business.utils.PrintOpLogMsgEnum;
import kd.bos.print.business.utils.PrintOpLogUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.template.orgctrl.service.PrintTemplateDataService;

public class AllocateSearchByTplFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public static final String TPL_ID = "TPL_ID";
    private static final String ENTRY = "entryentity";
    private static final String TPL = "printtpl";
    private static final String BT_ASSIGN_CANCEL = "btn_assign_cancel";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BT_ASSIGN_CANCEL});
        BasedataEdit edit = (BasedataEdit)this.getControl(TPL);
        edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void createNewData(BizDataEventArgs e) {
        this.getModel().putContextVariable("MODEL_BOSENTRYSERVERFILTERSORT", (Object)true);
        super.createNewData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().getPageCache().put("BOS.setRowDataByNumberAutoAddRow", "false");
        Long tplId = (Long)this.getView().getFormShowParameter().getCustomParam(TPL_ID);
        if (tplId == null) {
            return;
        }
        this.getModel().setValue(TPL, (Object)tplId);
        DynamicObject tplDynamicObj = this.getModel().getDataEntity().getDynamicObject(TPL);
        this.loadTplUseOrgEntry(tplDynamicObj);
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if (BT_ASSIGN_CANCEL.equals(source.getKey())) {
            EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY);
            int[] selectRows = grid.getSelectRows();
            if (selectRows == null || selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u53d6\u6d88\u5206\u914d\u7684\u6570\u636e\u3002", (String)"AllocateSearchByTplFormPlugin_0", (String)"bos-noteprint", (Object[])new Object[0]));
                return;
            }
            DynamicObject tplObj = this.getModel().getDataEntity().getDynamicObject(TPL);
            long dataId = tplObj.getLong("id");
            ArrayList<Long> orgIds = new ArrayList<Long>(10);
            for (int selectRow : selectRows) {
                DynamicObject useorg = this.getModel().getEntryRowEntity(ENTRY, selectRow).getDynamicObject("useorg");
                orgIds.add(useorg.getLong("id"));
            }
            PrintTemplateDataService.singleUnAllocate((long)dataId, orgIds);
            String number = tplObj.getString("number");
            PrintOpLogUtils.addLog((IFormView)this.getView().getParentView(), (String)number, (PrintOpLogMsgEnum)PrintOpLogMsgEnum.TPL_CANSEL_ALLOCATE);
            this.getModel().deleteEntryRows(ENTRY, selectRows);
            this.getView().updateView(ENTRY);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u5df2\u53d6\u6d88\u3002", (String)"TemplateUnAllocateFormPlugin_1", (String)"bos-noteprint", (Object[])new Object[0]));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        if (!(property instanceof BasedataProp) || !TPL.equals(property.getName())) {
            return;
        }
        ChangeData changeData = e.getChangeSet()[0];
        DynamicObject newValue = (DynamicObject)changeData.getNewValue();
        this.loadTplUseOrgEntry(newValue);
    }

    private void loadTplUseOrgEntry(DynamicObject tplDynamicObj) {
        this.getModel().deleteEntryData(ENTRY);
        this.getModel().updateCache();
        if (tplDynamicObj == null) {
            this.getView().updateView(ENTRY);
            return;
        }
        long dataId = tplDynamicObj.getLong("id");
        Set<Long> useOrgSet = AllocateSearchByTplFormPlugin.getUseOrgByDataId(dataId);
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)useOrgSet.toArray())}, (String)"number");
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        tableValueSetter.addField("useorg", new Object[0]);
        for (Map.Entry entry : loadFromCache.entrySet()) {
            tableValueSetter.addRow(new Object[]{((DynamicObject)entry.getValue()).getLong("id")});
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(ENTRY, tableValueSetter);
        this.getModel().updateCache();
        this.getView().updateView(ENTRY);
    }

    static Set<Long> getUseOrgByDataId(Long dataId) {
        SqlBuilder useRegQuery = new SqlBuilder();
        useRegQuery.append(" select fuseorgid from ", new Object[0]);
        useRegQuery.append("t_bas_printtplinfousage", new Object[0]);
        useRegQuery.append("  where ", new Object[0]);
        useRegQuery.append("fdataid = " + dataId, new Object[0]);
        useRegQuery.append("  and  fuseorgid <> fcreateorgid ", new Object[0]);
        HashSet<Long> res = new HashSet<Long>(1);
        try (DataSet dataSet = DB.queryDataSet((String)PrintTemplateDataService.class.getName(), (DBRoute)DBRoute.basedata, (SqlBuilder)useRegQuery);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                res.add(row.getLong("fuseorgid"));
            }
        }
        return res;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        List qFilters = param.getListFilterParameter().getQFilters();
        QFilter qFilter = new QFilter("ctrlstrategy", "=", (Object)"2");
        if (CollectionUtils.isEmpty((Collection)qFilters) || qFilters.get(0) == null) {
            qFilters.add(qFilter);
        } else {
            ((QFilter)qFilters.get(0)).and(qFilter);
        }
    }
}

