/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.provider;

import java.util.Locale;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ctrl.common.variant.Variant;
import kd.bos.print.core.ctrl.reportone.r1.print.common.currency.CurrencyFormatManager;
import kd.bos.print.core.model.UppercaseType;
import kd.bos.print.core.service.I18nService;
import kd.bos.svc.acl.AclAdapter;
import kd.bos.svc.acl.i18n.DefaultI18nService;

public class I18nServiceProvider
implements I18nService {
    private static final kd.bos.svc.acl.i18n.I18nService i18nService = AclAdapter.getI18nService();
    private static volatile I18nServiceProvider provider = null;

    private I18nServiceProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static I18nService getProvider() {
        if (provider != null) return provider;
        Class<I18nServiceProvider> clazz = I18nServiceProvider.class;
        synchronized (I18nServiceProvider.class) {
            if (provider != null) return provider;
            provider = new I18nServiceProvider();
            // ** MonitorExit[var0] (shouldn't be in output)
            return provider;
        }
    }

    public String amountConvertZhUppercase(boolean showCurrency, String currencyNumber, String currencyCode, String amount) {
        if (i18nService instanceof DefaultI18nService) {
            Locale locale = Locale.forLanguageTag(ExecuteContext.get().getLang());
            Locale localeLang = Locale.SIMPLIFIED_CHINESE;
            if (locale != null) {
                localeLang = locale;
            }
            return CurrencyFormatManager.shareInstance().upperFomat(currencyCode, localeLang, new Variant((Object)amount), showCurrency);
        }
        return i18nService.amountConvertUppercase(UppercaseType.ZH_UPPER.getLang(), currencyNumber, amount, showCurrency ? "" : "false");
    }

    public String amountConvertEnUppercase(boolean showCurrency, String currencyNumber, String amount) {
        return i18nService.amountConvertUppercase(UppercaseType.EN_UPPER.getLang(), currencyNumber, amount, showCurrency ? "" : "false");
    }

    public String amountConvertUppercase(String langAbbrCode, boolean showCurrency, String currencyNumber, String amount) {
        return i18nService.amountConvertUppercase(langAbbrCode, currencyNumber, amount, showCurrency ? "" : "false");
    }
}

