/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.service.transform;

import kd.bos.dataentity.utils.StringUtils;
import kd.bos.print.api.metedata.LocaleValue;
import kd.bos.print.api.metedata.control.BaseControl;
import kd.bos.print.api.metedata.control.QRCode;
import kd.bos.print.core.model.designer.BarcodeObject;
import kd.bos.print.core.model.designer.common.IReportObject;
import kd.bos.print.service.transform.BarcodeReader;
import kd.bos.print.service.transform.ControlDto;

public class QRCodeReader
extends BarcodeReader {
    public IReportObject parseObject(ControlDto dto) {
        BarcodeObject barcodeObj = (BarcodeObject)super.parseObject(dto);
        BaseControl control = (BaseControl)dto.getControl();
        this.parseSpecial(barcodeObj, control);
        return barcodeObj;
    }

    protected void parseSpecial(BarcodeObject barcodeObj, BaseControl control) {
        QRCode qr = (QRCode)control;
        String encodeMode = "QR_CODE";
        if (StringUtils.isNotBlank((CharSequence)qr.getEncodeMode())) {
            encodeMode = qr.getEncodeMode();
        }
        barcodeObj.setBarcodeType(encodeMode);
        barcodeObj.setDmSize(qr.getDmSize());
        barcodeObj.setErrorCorrection(qr.getErrorCollect());
        barcodeObj.setFormulaData(qr.getFormulaData());
        LocaleValue bindText = qr.getBindText();
        if (bindText != null) {
            barcodeObj.setSampleTxt((String)bindText.getLocaleValue());
        }
    }
}

