/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.metedata.convert;

import com.alibaba.fastjson.JSONObject;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.api.metedata.DesignerMetadata;
import kd.bos.print.api.metedata.LocaleValue;
import kd.bos.print.api.metedata.control.Control;
import kd.bos.print.api.metedata.control.ControlField;
import kd.bos.print.api.metedata.control.Text;
import kd.bos.print.business.metedata.LangLayout;
import kd.bos.print.business.metedata.convert.PrintMetadataProxy;

public abstract class AbstractMetatataConvert<T extends Control> {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final Map<String, Map<String, Field>> fieldCache = new WeakHashMap<String, Map<String, Field>>(16);
    private static final Map<String, Method> readMethodCache = new WeakHashMap<String, Method>(32);
    private static final Map<String, Method> writeMethodCache = new WeakHashMap<String, Method>(32);
    protected LangLayout langLayout;
    protected String oriLang = "zh_CN";

    protected abstract T getControl();

    protected T convert(Map<String, Object> sourceObj, String lang) {
        T bean = this.getControl();
        Map<String, Field> fieldMap = this.getAllFields((Control)bean);
        for (Map.Entry<String, Object> entry : sourceObj.entrySet()) {
            ControlField controlField;
            String key = entry.getKey();
            Object value = entry.getValue();
            Field field = fieldMap.get(key);
            if (field == null || this.isFieldEqual(controlField = field.getAnnotation(ControlField.class), ControlField.Type.IGNORE)) continue;
            if (this.isFieldEqual(controlField, ControlField.Type.CONTROL)) {
                Map obj = (Map)value;
                String convertType = (String)obj.get("type");
                AbstractMetatataConvert dataConvert = PrintMetadataProxy.getDataConvert((String)convertType);
                dataConvert.setOriLang(this.oriLang);
                value = dataConvert.convert(obj, lang);
            } else if (this.isFieldEqual(controlField, ControlField.Type.CHILDS)) {
                List itemList = (List)value;
                this.convertChilds(bean, itemList, lang);
                continue;
            }
            this.setValue(bean, field, value, lang);
        }
        try {
            this.compatibleProcess(bean, sourceObj, lang);
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        return bean;
    }

    private void compatibleProcess(T bean, Map<String, Object> sourceObj, String lang) throws Exception {
        if (bean instanceof Text) {
            Field lineWrapRule;
            Object lineWrapRuleValue;
            Field textOverFlow;
            String textOverFlowValue;
            Map<String, Field> fieldMap = this.getAllFields((Control)bean);
            Field horAlignment = fieldMap.get("horAlignment");
            Boolean wordFlex = (Boolean)sourceObj.get("wordFlex");
            if (wordFlex != null && wordFlex.booleanValue()) {
                LocaleValue justify = new LocaleValue((Object)"justify");
                this.setFieldValue(bean, horAlignment, justify);
            }
            if (("Truncate".equals(textOverFlowValue = (String)this.getFieldValue(bean, textOverFlow = fieldMap.get("textOverFlow"))) || "WrapLine".equals(textOverFlowValue)) && "2".equals(String.valueOf(lineWrapRuleValue = this.getFieldValue(bean, lineWrapRule = fieldMap.get("lineWrapRule"))))) {
                this.setFieldValue(bean, lineWrapRule, 3);
                this.setFieldValue(bean, textOverFlow, "OverFlow");
            }
        }
    }

    protected void convertChilds(T bean, List childs, String curLang) {
    }

    protected Map<String, Object> buildLocaleData(Control control, Map<String, Map<String, Object>> key2LocaleValueMap, String lang, String defaultLang) {
        HashMap<String, Object> localeDataMap = new HashMap<String, Object>(16);
        Map<String, Field> fieldMap = this.getAllFields(control);
        try {
            for (Map.Entry<String, Field> entry : fieldMap.entrySet()) {
                Object fieldValue;
                Field field = entry.getValue();
                ControlField annotation = field.getAnnotation(ControlField.class);
                if (this.isFieldEqual(annotation, ControlField.Type.CHILDS)) {
                    List value = (List)this.getFieldValue(control, field);
                    localeDataMap.putAll(this.buildLocaleDataChild(value, key2LocaleValueMap, lang, defaultLang));
                    continue;
                }
                if (this.isFieldEqual(annotation, ControlField.Type.CONTROL)) {
                    fieldValue = this.getFieldValue(control, field);
                    String convertType = control.getType();
                    AbstractMetatataConvert dataConvert = PrintMetadataProxy.getDataConvert((String)convertType);
                    dataConvert.setLangLayout(this.langLayout);
                    dataConvert.setOriLang(this.oriLang);
                    localeDataMap.putAll(dataConvert.buildLocaleData((Control)fieldValue, key2LocaleValueMap, lang, defaultLang));
                    continue;
                }
                if (field.getType() == LocaleValue.class && annotation != null && annotation.langConvert()) {
                    String key = control.getId() + "." + field.getName();
                    LocaleValue value = (LocaleValue)this.getFieldValue(control, field);
                    if (value == null) continue;
                    this.buildLocaleDataImpl(key2LocaleValueMap, lang, defaultLang, localeDataMap, key, value);
                    continue;
                }
                if (this.isFieldEqual(annotation, ControlField.Type.FORMULA) && field.getType() == List.class) {
                    String formulaName = annotation.formulaName();
                    List formulas = (List)this.getFieldValue(control, field);
                    if (formulas == null) continue;
                    for (Object formula : formulas) {
                        if (!(formula instanceof Map)) continue;
                        Map formulaField = (Map)formula;
                        String id = this.getFormulaFieldId(formulaField);
                        Object formulaFieldName = formulaField.get(formulaName);
                        if (formulaFieldName == null) continue;
                        String key = this.getFormulaFieldLocaleKey(field, control.getId(), id);
                        LocaleValue value = new LocaleValue();
                        value.put(this.oriLang, formulaFieldName);
                        this.buildLocaleDataImpl(key2LocaleValueMap, lang, defaultLang, localeDataMap, key, value);
                    }
                    continue;
                }
                if (!this.isFieldEqual(annotation, ControlField.Type.SPECIAL) || kd.bos.orm.util.StringUtils.isEmpty((Object)annotation.langFields()) || !((fieldValue = this.getFieldValue(control, field)) instanceof List)) continue;
                List values = (List)fieldValue;
                String[] langFields = annotation.langFields().split(",");
                if (langFields.length <= 0) continue;
                Class target = annotation.target();
                String langSpecialId = annotation.langSpecialId();
                for (Object value : values) {
                    Method specialIdMethod = target.getMethod("get" + langSpecialId, new Class[0]);
                    Object specialId = specialIdMethod.invoke(value, new Object[0]);
                    if (specialId == null) continue;
                    for (String langField : langFields) {
                        Method getLocaleValue = target.getMethod("get" + langField + "L", new Class[0]);
                        LocaleValue localeValue = (LocaleValue)getLocaleValue.invoke(value, new Object[0]);
                        if (localeValue == null) continue;
                        String key = control.getId() + "." + field.getName() + "." + langField + "." + specialId;
                        this.buildLocaleDataImpl(key2LocaleValueMap, lang, defaultLang, localeDataMap, key, localeValue);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        return localeDataMap;
    }

    private void buildLocaleDataImpl(Map<String, Map<String, Object>> key2LocaleValueMap, String lang, String defaultLang, Map<String, Object> localeDataMap, String key, LocaleValue value) {
        Object defaultValue;
        Map<String, Object> localeValueMap = key2LocaleValueMap.get(key);
        this.mergeMap2LocaleValue(value, localeValueMap);
        Object textValue = value.get((Object)lang);
        if (!kd.bos.orm.util.StringUtils.isEmpty((Object)textValue)) {
            localeDataMap.put(key, textValue);
        } else if (defaultLang != null && !kd.bos.orm.util.StringUtils.isEmpty((Object)(defaultValue = value.get((Object)defaultLang)))) {
            localeDataMap.put(key, defaultValue);
        }
    }

    private void mergeMap2LocaleValue(LocaleValue value, Map<String, Object> localeValueMap) {
        if (localeValueMap == null || value == null) {
            return;
        }
        localeValueMap.forEach((localeId, data) -> {
            if (!kd.bos.orm.util.StringUtils.isEmpty((Object)data)) {
                value.put(localeId, data);
            }
        });
    }

    private Map<String, Object> buildLocaleDataChild(List childs, Map<String, Map<String, Object>> oriDataMap, String lang, String defaultLang) {
        HashMap<String, Object> localeDataMap = new HashMap<String, Object>(16);
        if (childs == null || childs.isEmpty()) {
            return localeDataMap;
        }
        List pages = childs;
        for (List page : pages) {
            for (Control item : page) {
                AbstractMetatataConvert dataConvert = PrintMetadataProxy.getDataConvert((String)item.getType());
                dataConvert.setLangLayout(this.langLayout);
                dataConvert.setOriLang(this.oriLang);
                localeDataMap.putAll(dataConvert.buildLocaleData(item, oriDataMap, lang, defaultLang));
            }
        }
        return localeDataMap;
    }

    protected Map<String, LocaleValue> mergeBuildDataMap(Control control, Map<String, Map<String, Object>> oriLocaleMap, Map<String, Map<String, Object>> tarLocaleMap, String curLang) {
        Map<String, Field> fieldMap = this.getAllFields(control);
        HashMap<String, LocaleValue> newCacheMap = new HashMap<String, LocaleValue>(16);
        try {
            for (Map.Entry<String, Field> entry : fieldMap.entrySet()) {
                Object fieldValue;
                Field field = entry.getValue();
                ControlField annotation = field.getAnnotation(ControlField.class);
                if (this.isFieldEqual(annotation, ControlField.Type.CHILDS)) {
                    fieldValue = this.getFieldValue(control, field);
                    List childs = (List)fieldValue;
                    newCacheMap.putAll(this.mergeBuildDataMapChild(childs, oriLocaleMap, tarLocaleMap, curLang));
                    continue;
                }
                if (this.isFieldEqual(annotation, ControlField.Type.CONTROL)) {
                    fieldValue = this.getFieldValue(control, field);
                    Map<String, LocaleValue> valueMap = this.mergeBuildDataMap((Control)fieldValue, oriLocaleMap, tarLocaleMap, curLang);
                    newCacheMap.putAll(valueMap);
                    continue;
                }
                if (field.getType() == LocaleValue.class) {
                    LocaleValue value = (LocaleValue)this.getFieldValue(control, field);
                    if (value == null) continue;
                    if (annotation != null && annotation.langConvert()) {
                        this.langConvertProcess(control.getId() + "." + field.getName(), control, oriLocaleMap, tarLocaleMap, curLang, newCacheMap, field, value);
                        continue;
                    }
                    this.localeValueProcess(control, oriLocaleMap, curLang, newCacheMap, field, annotation, value);
                    continue;
                }
                if (this.isFieldEqual(annotation, ControlField.Type.FORMULA) && field.getType() == List.class) {
                    List formulas = (List)this.getFieldValue(control, field);
                    if (formulas == null) continue;
                    String formulaName = annotation.formulaName();
                    for (Object formula : formulas) {
                        Object oriValue;
                        if (!(formula instanceof Map)) continue;
                        Map formulaMap = (Map)formula;
                        HashMap<String, Object> formulaNameMap = (HashMap<String, Object>)formulaMap.remove(formulaName + "L");
                        if (formulaNameMap == null) {
                            formulaNameMap = new HashMap<String, Object>(8);
                        }
                        formulaNameMap.put(curLang, formulaMap.getOrDefault(formulaName, ""));
                        LocaleValue localeValue = this.mapToLocalValue(formulaNameMap);
                        String id = this.getFormulaFieldId(formulaMap);
                        String key = this.getFormulaFieldLocaleKey(field, control.getId(), id);
                        Map<String, Object> oriLocalValue = oriLocaleMap.get(key);
                        if (oriLocalValue != null && (oriValue = oriLocalValue.get(this.oriLang)) != null) {
                            formulaMap.put(formulaName, oriValue);
                        }
                        this.langConvertProcess(key, control, oriLocaleMap, tarLocaleMap, curLang, newCacheMap, null, localeValue);
                    }
                    continue;
                }
                if (!this.isFieldEqual(annotation, ControlField.Type.SPECIAL) || kd.bos.orm.util.StringUtils.isEmpty((Object)annotation.langFields()) || !((fieldValue = this.getFieldValue(control, field)) instanceof List)) continue;
                List specialValues = (List)fieldValue;
                String[] langFields = annotation.langFields().split(",");
                if (langFields.length <= 0) continue;
                Class target = annotation.target();
                String langSpecialId = annotation.langSpecialId();
                for (Object specialValue : specialValues) {
                    Method specialIdMethod = target.getMethod("get" + langSpecialId, new Class[0]);
                    Object specialId = specialIdMethod.invoke(specialValue, new Object[0]);
                    if (specialId == null) continue;
                    for (String langField : langFields) {
                        Object oriValue;
                        Method getLocaleValueMethod = target.getMethod("get" + langField + "L", new Class[0]);
                        LocaleValue localeValue = (LocaleValue)getLocaleValueMethod.invoke(specialValue, new Object[0]);
                        if (localeValue == null) continue;
                        String key = control.getId() + "." + field.getName() + "." + langField + "." + specialId;
                        Map<String, Object> oriLocalValue = oriLocaleMap.get(key);
                        if (oriLocalValue != null && (oriValue = oriLocalValue.get(this.oriLang)) != null) {
                            Method setLocaleValueMethod = target.getMethod("set" + langField, String.class);
                            setLocaleValueMethod.invoke(specialValue, oriValue.toString());
                        }
                        this.langConvertProcess(key, control, oriLocaleMap, tarLocaleMap, curLang, newCacheMap, null, localeValue);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        return newCacheMap;
    }

    private String getFormulaFieldId(Map<String, Object> formulaMap) {
        Object id = formulaMap.get("id");
        if (id == null) {
            id = Uuid8.generateShortUuid();
            formulaMap.put("id", id);
        }
        return id.toString();
    }

    private void langConvertProcess(String key, Control control, Map<String, Map<String, Object>> oriLocaleMap, Map<String, Map<String, Object>> tarLocaleMap, String curLang, Map<String, LocaleValue> newCacheMap, Field field, LocaleValue value) throws Exception {
        Object currentValue = value.getValueIfPresent();
        Map<String, Object> oriLocaleValue = oriLocaleMap.get(key);
        if (!this.oriLang.equals(curLang)) {
            if (oriLocaleValue != null) {
                Object oriLangValue = oriLocaleValue.get(this.oriLang);
                if (StringUtils.isNotBlank((Object)oriLangValue)) {
                    tarLocaleMap.get(this.oriLang).put(key, oriLangValue);
                }
                oriLocaleValue.remove(curLang);
                if (currentValue != null && !currentValue.equals(oriLangValue) && StringUtils.isNotBlank((Object)currentValue)) {
                    tarLocaleMap.get(curLang).put(key, currentValue);
                }
                LocaleValue localeValue = this.mapToLocalValue(oriLocaleValue);
                this.setFieldValue(control, field, localeValue);
                newCacheMap.put(key, localeValue);
            } else {
                if (StringUtils.isNotBlank((Object)currentValue)) {
                    tarLocaleMap.get(this.oriLang).put(key, currentValue);
                }
                LocaleValue oriLangValue = new LocaleValue(this.oriLang, currentValue, this.oriLang);
                this.setFieldValue(control, field, oriLangValue);
                newCacheMap.put(key, oriLangValue);
            }
        } else if (oriLocaleValue != null) {
            LocaleValue localeValue = this.mapToLocalValue(oriLocaleValue);
            localeValue.put(this.oriLang, currentValue);
            Object resValue = localeValue.get((Object)this.oriLang);
            if (StringUtils.isNotBlank((Object)resValue)) {
                tarLocaleMap.get(this.oriLang).put(key, resValue);
            }
            this.setFieldValue(control, field, localeValue);
            newCacheMap.put(key, localeValue);
        } else {
            if (StringUtils.isNotBlank((Object)currentValue)) {
                tarLocaleMap.get(this.oriLang).put(key, currentValue);
            }
            newCacheMap.put(key, value);
        }
    }

    private void localeValueProcess(Control control, Map<String, Map<String, Object>> oriLocaleMap, String curLang, Map<String, LocaleValue> newCacheMap, Field field, ControlField annotation, LocaleValue value) throws Exception {
        Class clazz;
        String key = control.getId() + "." + field.getName();
        Map<String, Object> cacheValueMap = oriLocaleMap.get(key);
        if (cacheValueMap == null) {
            if (value == null) {
                return;
            }
            if (value.getDefaultValue() == null && value.size() == 1) {
                value.putDefault();
            }
            newCacheMap.put(key, value);
            return;
        }
        LocaleValue localeValue = null;
        if (this.isFieldEqual(annotation, ControlField.Type.OBJECT)) {
            clazz = annotation.target();
            localeValue = this.toLocalObject(cacheValueMap, clazz);
        } else if (this.isFieldEqual(annotation, ControlField.Type.SPECIAL)) {
            clazz = annotation.target();
            Method method = clazz.getMethod("toLocalObject", Object.class);
            localeValue = (LocaleValue)method.invoke(null, cacheValueMap);
        } else {
            localeValue = this.mapToLocalValue(cacheValueMap);
        }
        Object curLangValue = value.get((Object)curLang);
        if (curLangValue == null) {
            curLangValue = value.getDefaultValue();
        }
        String defaultLang = this.getDefaultLang();
        localeValue.setDefaultLang(defaultLang);
        if (this.langLayout != null && this.langLayout == LangLayout.LayoutUnify && annotation != null && !annotation.langIsolate()) {
            localeValue.clear();
            localeValue.put(defaultLang, curLangValue);
        } else {
            localeValue.put(curLang, curLangValue);
            localeValue.putIfAbsent((Object)defaultLang, curLangValue);
        }
        this.setFieldValue(control, field, localeValue);
        newCacheMap.put(key, localeValue);
    }

    protected Map<String, LocaleValue> mergeBuildDataMapChild(List childs, Map<String, Map<String, Object>> oriLocaleMap, Map<String, Map<String, Object>> tarLocaleMap, String curLang) {
        HashMap<String, LocaleValue> newLocalValueMap = new HashMap<String, LocaleValue>(16);
        if (childs == null || childs.isEmpty()) {
            return newLocalValueMap;
        }
        List pages = childs;
        for (List page : pages) {
            for (Control item : page) {
                newLocalValueMap.putAll(this.mergeBuildDataMap(item, oriLocaleMap, tarLocaleMap, curLang));
            }
        }
        return newLocalValueMap;
    }

    protected void mergeLocaleDataMap(Control control, Map<String, Map<String, Object>> localValueMap) {
        Map<String, Field> fieldMap = this.getAllFields(control);
        try {
            for (Map.Entry<String, Field> entry : fieldMap.entrySet()) {
                Object fieldValue;
                List value;
                Field field = entry.getValue();
                ControlField annotation = field.getAnnotation(ControlField.class);
                if (this.isFieldEqual(annotation, ControlField.Type.CHILDS)) {
                    value = (List)this.getFieldValue(control, field);
                    this.mergeLocaleDataMapChild(value, localValueMap);
                    continue;
                }
                if (this.isFieldEqual(annotation, ControlField.Type.CONTROL)) {
                    fieldValue = this.getFieldValue(control, field);
                    String convertType = control.getType();
                    AbstractMetatataConvert dataConvert = PrintMetadataProxy.getDataConvert((String)convertType);
                    dataConvert.mergeLocaleDataMap((Control)fieldValue, localValueMap);
                    continue;
                }
                if (this.isFieldEqual(annotation, ControlField.Type.FORMULA) && field.getType() == List.class) {
                    String formulaName = annotation.formulaName();
                    List fieldValue2 = (List)this.getFieldValue(control, field);
                    if (fieldValue2 == null) continue;
                    for (Object formula : fieldValue2) {
                        if (!(formula instanceof Map)) continue;
                        Map formulaMap = (Map)formula;
                        String id = this.getFormulaFieldId(formulaMap);
                        String key = this.getFormulaFieldLocaleKey(field, control.getId(), id);
                        LocaleValue localeValue = new LocaleValue();
                        formulaMap.put(formulaName + "L", localeValue);
                        this.mergeLocaleDataMapImpl(localValueMap, localeValue, key);
                    }
                    continue;
                }
                if (field.getType() == LocaleValue.class && annotation != null && annotation.langConvert()) {
                    value = (LocaleValue)this.getFieldValue(control, field);
                    String key = control.getId() + "." + field.getName();
                    this.mergeLocaleDataMapImpl(localValueMap, (LocaleValue)value, key);
                    continue;
                }
                if (!this.isFieldEqual(annotation, ControlField.Type.SPECIAL) || kd.bos.orm.util.StringUtils.isEmpty((Object)annotation.langFields()) || !((fieldValue = this.getFieldValue(control, field)) instanceof List)) continue;
                List specialValues = (List)fieldValue;
                String[] langFields = annotation.langFields().split(",");
                if (langFields.length <= 0) continue;
                Class target = annotation.target();
                String langSpecialId = annotation.langSpecialId();
                for (Object specialValue : specialValues) {
                    Method specialIdMethod = target.getMethod("get" + langSpecialId, new Class[0]);
                    Object specialId = specialIdMethod.invoke(specialValue, new Object[0]);
                    if (specialId == null) continue;
                    for (String langField : langFields) {
                        Method getLocaleValue = target.getMethod("get" + langField + "L", new Class[0]);
                        LocaleValue localeValue = (LocaleValue)getLocaleValue.invoke(specialValue, new Object[0]);
                        if (localeValue == null) continue;
                        String key = control.getId() + "." + field.getName() + "." + langField + "." + specialId;
                        this.mergeLocaleDataMapImpl(localValueMap, localeValue, key);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private void mergeLocaleDataMapImpl(Map<String, Map<String, Object>> localValueMap, LocaleValue value, String key) {
        localValueMap.forEach((lang, localValue) -> {
            Object local = localValue.get(key);
            if (!kd.bos.orm.util.StringUtils.isEmpty(local) && value != null) {
                value.put(lang, local);
            }
        });
    }

    private void mergeLocaleDataMapChild(List value, Map<String, Map<String, Object>> localValueMap) {
        List pages = value;
        for (List page : pages) {
            for (Control control : page) {
                this.mergeLocaleDataMap(control, localValueMap);
            }
        }
    }

    protected LocaleValue convertToLocalValue(Field field, Object value, String lang) throws Exception {
        ControlField controlField = field.getAnnotation(ControlField.class);
        String genericType = field.getGenericType().getTypeName();
        if (lang == null) {
            if (this.isFieldEqual(controlField, ControlField.Type.OBJECT)) {
                Class clazz = controlField.target();
                value = this.toLocalObject((Map)value, clazz);
            } else if (this.isFieldEqual(controlField, ControlField.Type.SPECIAL)) {
                Class clazz = controlField.target();
                Method method = clazz.getMethod("toLocalObject", Object.class);
                value = method.invoke(null, value);
                this.localValueSetDefaultLang(value);
            } else if (value instanceof Map) {
                value = this.mapToLocalValue((Map)value);
            } else {
                value = new LocaleValue(value);
                this.localValueSetDefaultLang(value);
            }
        } else {
            if (this.isFieldEqual(controlField, ControlField.Type.OBJECT)) {
                Class clazz = controlField.target();
                value = AbstractMetatataConvert.toObject(value, clazz);
            } else if (this.isFieldEqual(controlField, ControlField.Type.SPECIAL)) {
                Class clazz = controlField.target();
                Method method = clazz.getMethod("toObject", Object.class);
                value = method.invoke(null, value);
            } else if ("kd.bos.print.api.metedata.LocaleValue<java.lang.Float>".equals(genericType) && (value instanceof String || value instanceof Integer || value instanceof BigDecimal)) {
                value = new Float(value.toString());
            }
            value = new LocaleValue(lang, value, this.getDefaultLang());
        }
        return (LocaleValue)value;
    }

    private void localValueSetDefaultLang(Object value) {
        if (value instanceof LocaleValue) {
            ((LocaleValue)value).setDefaultLang(this.getDefaultLang());
        }
    }

    protected void setValue(T bean, Field field, Object value, String lang) {
        try {
            Map<String, Field> allFields;
            Field replaceField;
            String replaceFieldName;
            Class<?> type = field.getType();
            ControlField annotation = field.getAnnotation(ControlField.class);
            if (type == LocaleValue.class) {
                value = this.convertToLocalValue(field, value, lang);
            } else {
                Class clazz;
                if (this.isFieldEqual(annotation, ControlField.Type.OBJECT)) {
                    clazz = annotation.target();
                    value = AbstractMetatataConvert.toObject(value, clazz);
                } else if (this.isFieldEqual(annotation, ControlField.Type.SPECIAL)) {
                    clazz = annotation.target();
                    Method method = clazz.getMethod("toObject", Object.class);
                    value = method.invoke(null, value);
                }
                if (type == Integer.TYPE && value instanceof String) {
                    value = Integer.parseInt(value.toString());
                }
                if ((type == Boolean.TYPE || type == Boolean.class) && value instanceof String) {
                    value = Boolean.parseBoolean(value.toString());
                }
            }
            if (annotation != null && !kd.bos.orm.util.StringUtils.isEmpty((Object)(replaceFieldName = annotation.replaceField())) && (replaceField = (allFields = this.getAllFields((Control)bean)).get(replaceFieldName)) != null) {
                LocaleValue localeValue = new LocaleValue();
                if (lang == null) {
                    localeValue.put(this.oriLang, (Object)(value == null ? "" : value.toString()));
                } else {
                    localeValue.put(lang, (Object)(value == null ? "" : value.toString()));
                }
                this.setFieldValue(bean, replaceField, localeValue);
            }
            this.setFieldValue(bean, field, value);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, new ErrorCode("print-exception", "Field Set Value Error,Field = %s"), new Object[]{field.getName()});
        }
    }

    protected final DesignerMetadata toDesignerMetadata(T bean, String lang) {
        DesignerMetadata designerMetadata = new DesignerMetadata();
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        HashMap localValueMap = new HashMap();
        Map<String, Field> fieldMap = this.getAllFields((Control)bean);
        try {
            for (Map.Entry<String, Field> entry : fieldMap.entrySet()) {
                Field field = entry.getValue();
                ControlField annotation = field.getAnnotation(ControlField.class);
                if (this.isFieldEqual(annotation, ControlField.Type.IGNORE)) continue;
                String key = entry.getKey();
                Object value = this.getFieldValue(bean, field);
                if (this.isFieldEqual(annotation, ControlField.Type.CONTROL)) {
                    Control control = (Control)value;
                    String convertType = control.getType();
                    AbstractMetatataConvert dataConvert = PrintMetadataProxy.getDataConvert((String)convertType);
                    DesignerMetadata ret = dataConvert.toDesignerMetadata(control, lang);
                    value = ret.getMetadata();
                    localValueMap.putAll(ret.getLocaleValueMap());
                }
                if (this.isFieldEqual(annotation, ControlField.Type.CHILDS)) {
                    List list = (List)value;
                    this.childsToDesign(metadata, list, localValueMap, lang);
                    continue;
                }
                if (this.isFieldEqual(annotation, ControlField.Type.FORMULA)) {
                    if (fieldMap.containsKey("id") && value instanceof List) {
                        String formulaName = annotation.formulaName();
                        String id = (String)this.getFieldValue(bean, fieldMap.get("id"));
                        List formulas = (List)value;
                        for (Object formula : formulas) {
                            String curValue;
                            LocaleValue localeValue;
                            if (!(formula instanceof Map)) continue;
                            Map formulaField = (Map)formula;
                            Object formulaNameL = formulaField.remove(formulaName + "L");
                            if (formulaNameL instanceof LocaleValue) {
                                localeValue = (LocaleValue)formulaNameL;
                                curValue = (String)localeValue.get((Object)lang);
                                if (curValue != null) {
                                    formulaField.put(formulaName, curValue);
                                }
                            } else {
                                curValue = String.valueOf(formulaField.getOrDefault(formulaName, ""));
                                localeValue = new LocaleValue();
                                localeValue.put(lang, (Object)curValue);
                            }
                            String formulaFieldId = this.getFormulaFieldId(formulaField);
                            localValueMap.put(this.getFormulaFieldLocaleKey(field, id, formulaFieldId), localeValue);
                        }
                        metadata.put(key, formulas);
                    }
                } else if (this.isFieldEqual(annotation, ControlField.Type.SPECIAL) && !kd.bos.orm.util.StringUtils.isEmpty((Object)annotation.langFields())) {
                    Object fieldValue = this.getFieldValue(bean, field);
                    if (!(fieldValue instanceof List)) continue;
                    List specialValues = (List)fieldValue;
                    String[] langFields = annotation.langFields().split(",");
                    if (langFields.length <= 0) continue;
                    Class target = annotation.target();
                    String langSpecialId = annotation.langSpecialId();
                    for (Object specialValue : specialValues) {
                        Method specialIdMethod = target.getMethod("get" + langSpecialId, new Class[0]);
                        Object specialId = specialIdMethod.invoke(specialValue, new Object[0]);
                        if (specialId == null) continue;
                        for (String langField : langFields) {
                            Method getLocaleValue = target.getMethod("get" + langField + "L", new Class[0]);
                            LocaleValue localeValue = (LocaleValue)getLocaleValue.invoke(specialValue, new Object[0]);
                            if (localeValue == null) continue;
                            Object curValue = localeValue.get((Object)lang);
                            if (curValue != null) {
                                Method setLangFieldMethod = target.getMethod("set" + langField, String.class);
                                setLangFieldMethod.invoke(specialValue, curValue.toString());
                            }
                            String specialKey = bean.getId() + "." + field.getName() + "." + langField + "." + specialId;
                            localValueMap.put(specialKey, localeValue);
                        }
                    }
                }
                if (value instanceof LocaleValue) {
                    LocaleValue localeValue = (LocaleValue)value;
                    if ((value = localeValue.get((Object)lang)) == null) {
                        value = localeValue.getValueIfPresent();
                    }
                    if (fieldMap.containsKey("id") && fieldMap.containsKey("type")) {
                        Field idField = fieldMap.get("id");
                        String id = (String)this.getFieldValue(bean, idField);
                        localValueMap.put(id + "." + field.getName(), localeValue);
                    }
                    if (annotation != null && annotation.frontendIgnore()) continue;
                }
                metadata.put(key, value);
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        designerMetadata.setMetadata(metadata);
        designerMetadata.setLocaleValueMap(localValueMap);
        return designerMetadata;
    }

    private String getFormulaFieldLocaleKey(Field field, String id, String formulaFieldId) {
        return id + "." + field.getName() + "." + formulaFieldId;
    }

    protected void childsToDesign(Map<String, Object> metadata, List childs, Map<String, LocaleValue<?>> localValueMap, String curLang) {
    }

    private static Object toObject(Object value, Class clazz) {
        String str = JSONObject.toJSONString((Object)value);
        return JSONObject.parseObject((String)str, (Class)clazz);
    }

    private LocaleValue toLocalObject(Map<String, Object> map, Class clazz) {
        LocaleValue localeValue = new LocaleValue();
        localeValue.setDefaultLang(this.getDefaultLang());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object obj = entry.getValue();
            Object border = AbstractMetatataConvert.toObject(obj, clazz);
            localeValue.put(entry.getKey(), border);
        }
        return localeValue;
    }

    private LocaleValue mapToLocalValue(Map<String, Object> values) {
        LocaleValue val = new LocaleValue();
        val.setDefaultLang(this.getDefaultLang());
        for (Map.Entry<String, Object> o : values.entrySet()) {
            val.put(o.getKey(), o.getValue());
        }
        return val;
    }

    protected Map<String, LocaleValue> mergeMetedata(Control control, Map<String, Map<String, Object>> localeValueMap, String lang) {
        Map<String, Field> fieldMap = this.getAllFields(control);
        HashMap<String, LocaleValue> newLocalValueMap = new HashMap<String, LocaleValue>(16);
        try {
            for (Map.Entry<String, Field> entry : fieldMap.entrySet()) {
                Class clazz;
                Object fieldValue;
                Field field = entry.getValue();
                ControlField annotation = field.getAnnotation(ControlField.class);
                if (this.isFieldEqual(annotation, ControlField.Type.CHILDS)) {
                    fieldValue = this.getFieldValue(control, field);
                    List childs = (List)fieldValue;
                    newLocalValueMap.putAll(this.mergeChilds(control, childs, localeValueMap, lang));
                    continue;
                }
                if (this.isFieldEqual(annotation, ControlField.Type.CONTROL)) {
                    fieldValue = this.getFieldValue(control, field);
                    String convertType = control.getType();
                    AbstractMetatataConvert dataConvert = PrintMetadataProxy.getDataConvert((String)convertType);
                    Map<String, LocaleValue> valueMap = dataConvert.mergeMetedata((Control)fieldValue, localeValueMap, lang);
                    newLocalValueMap.putAll(valueMap);
                    continue;
                }
                if (field.getType() != LocaleValue.class) continue;
                LocaleValue value = (LocaleValue)this.getFieldValue(control, field);
                String key = control.getId() + "." + field.getName();
                Map<String, Object> cacheValueMap = localeValueMap.get(key);
                if (cacheValueMap == null) {
                    if (value == null) continue;
                    if (value.getDefaultValue() == null && value.size() == 1) {
                        value.putDefault();
                    }
                    newLocalValueMap.put(key, value);
                    continue;
                }
                LocaleValue localeValue = null;
                if (this.isFieldEqual(annotation, ControlField.Type.OBJECT)) {
                    clazz = annotation.target();
                    localeValue = this.toLocalObject(cacheValueMap, clazz);
                } else if (this.isFieldEqual(annotation, ControlField.Type.SPECIAL)) {
                    clazz = annotation.target();
                    Method method = clazz.getMethod("toLocalObject", Object.class);
                    localeValue = (LocaleValue)method.invoke(null, cacheValueMap);
                } else {
                    localeValue = this.mapToLocalValue(cacheValueMap);
                }
                Object curLangValue = value.get((Object)lang);
                if (curLangValue == null) {
                    curLangValue = value.getDefaultValue();
                }
                String defaultLang = this.getDefaultLang();
                localeValue.setDefaultLang(defaultLang);
                if (this.langLayout != null && this.langLayout == LangLayout.LayoutUnify && annotation != null && !annotation.langIsolate()) {
                    localeValue.clear();
                    localeValue.put(defaultLang, curLangValue);
                } else {
                    localeValue.put(lang, curLangValue);
                    localeValue.putIfAbsent((Object)defaultLang, curLangValue);
                }
                this.setFieldValue(control, field, localeValue);
                newLocalValueMap.put(key, localeValue);
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        return newLocalValueMap;
    }

    private String getDefaultLang() {
        return kd.bos.orm.util.StringUtils.isEmpty((Object)this.oriLang) ? "zh_CN" : this.oriLang;
    }

    protected Map<String, LocaleValue> mergeChilds(Control control, List childs, Map<String, Map<String, Object>> localeValueMap, String lang) {
        return new HashMap<String, LocaleValue>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Field> getAllFields(Control bean) {
        String key = bean.getClass().getName();
        Map<String, Field> fieldMap = fieldCache.get(key);
        if (fieldMap != null) {
            return fieldMap;
        }
        Class<AbstractMetatataConvert> clazz = AbstractMetatataConvert.class;
        synchronized (AbstractMetatataConvert.class) {
            if (fieldMap == null) {
                fieldMap = fieldCache.get(key);
            }
            if (fieldMap != null) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return fieldMap;
            }
            fieldMap = new HashMap<String, Field>(16);
            for (Class<?> tempClass = bean.getClass(); tempClass != null; tempClass = tempClass.getSuperclass()) {
                Field[] fields;
                for (Field field : fields = tempClass.getDeclaredFields()) {
                    if (field.isSynthetic() || fieldMap.containsKey(field.getName())) continue;
                    fieldMap.put(field.getName(), field);
                }
            }
            fieldCache.put(key, fieldMap);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return fieldMap;
        }
    }

    private boolean isFieldEqual(ControlField controlField, ControlField.Type type) {
        if (controlField == null) {
            return false;
        }
        return controlField.type() == type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getFieldValue(Object bean, Field field) throws Exception {
        String methodKey;
        Method readMethod;
        String name = field.getName();
        if ("fontSize".equals(name)) {
            name = name + "F";
        }
        if ((readMethod = readMethodCache.get(methodKey = bean.getClass().toString() + name)) != null) {
            return readMethod.invoke(bean, new Object[0]);
        }
        Class<AbstractMetatataConvert> clazz = AbstractMetatataConvert.class;
        synchronized (AbstractMetatataConvert.class) {
            readMethod = readMethodCache.get(methodKey);
            if (readMethod == null) {
                PropertyDescriptor propDesc = new PropertyDescriptor(name, bean.getClass());
                readMethod = propDesc.getReadMethod();
                readMethodCache.put(methodKey, readMethod);
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return readMethod.invoke(bean, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setFieldValue(Object bean, Field field, Object value) throws Exception {
        String methodKey;
        Method writeMethod;
        if (field == null) {
            return;
        }
        String name = field.getName();
        if ("fontSize".equals(name)) {
            name = name + "F";
        }
        if ((writeMethod = writeMethodCache.get(methodKey = bean.getClass().toString() + name)) != null) {
            writeMethod.invoke(bean, value);
            return;
        }
        Class<AbstractMetatataConvert> clazz = AbstractMetatataConvert.class;
        synchronized (AbstractMetatataConvert.class) {
            writeMethod = writeMethodCache.get(methodKey);
            if (writeMethod == null) {
                PropertyDescriptor propDesc = new PropertyDescriptor(name, bean.getClass());
                writeMethod = propDesc.getWriteMethod();
                writeMethodCache.put(methodKey, writeMethod);
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            writeMethod.invoke(bean, value);
            return;
        }
    }

    public void setLangLayout(LangLayout langLayout) {
        this.langLayout = langLayout;
    }

    public void setOriLang(String oriLang) {
        this.oriLang = oriLang;
    }
}

