/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.print.xls.output;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ctrl.print.util.KPrintUtil;
import kd.bos.print.core.ctrl.print.xls.exception.OutOfSizeException;
import kd.bos.print.core.ctrl.print.xls.exobject.APaper;
import kd.bos.print.core.ctrl.print.xls.exobject.BasicCell;
import kd.bos.print.core.ctrl.print.xls.output.LinesList;
import kd.bos.print.core.ctrl.print.xls.output.Location;
import kd.bos.print.core.ctrl.print.xls.output.PaperHelper;
import kd.bos.print.core.ctrl.print.xls.output.XlsContext;
import kd.bos.print.core.ctrl.print.xls.output.XlsHelper;
import kd.bos.print.core.ctrl.print.xls.output.XlsNodeContainer;
import kd.bos.print.core.ctrl.print.xls.widget.XlsPaper;
import kd.bos.print.core.ctrl.reportone.r1.print.common.R1PrintInfo;
import kd.bos.print.core.execute.render.painter.PaintContext;
import kd.bos.print.core.execute.render.painter.PaintPaperInfo;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;

public class OutputHelper {
    private static final int MAXROW = 1000000;
    private static final int MAXCOL = 255;
    boolean[][] _takenMap;
    private APaper _outputPaper;
    private int _offset = 0;
    private LinesList _verticalLines;
    private Workbook _book;
    private Sheet _sheet;
    private HashMap _styleMap;
    private Logger _log = Logger.getLogger(OutputHelper.class);
    private XlsNodeContainer _container = new XlsNodeContainer(20);
    private PaperHelper _paperHelper;
    private PrintSetup _sp;
    private XlsHelper _xlsHelper;
    private final float minMarginBottom = 15.0f;
    private Map conStyleMap;
    private Map<String, Object> para = new HashMap<String, Object>(16);
    private XlsContext xlsContext = new XlsContext();

    public OutputHelper(Workbook wb) {
        this._book = wb;
        this._verticalLines = new LinesList(255);
        this._styleMap = new HashMap();
        this.conStyleMap = new HashMap();
        CellStyle cellstyle = this._book.createCellStyle();
        cellstyle.setAlignment(HorizontalAlignment.CENTER);
        cellstyle.setVerticalAlignment(VerticalAlignment.CENTER);
        this._styleMap.put("cellstyleisnull!!!", cellstyle);
        this.para = ExecuteContext.get().getExtParam();
    }

    public void setPaintContext(PaintContext paintContext) {
        this.xlsContext.setPaintContext(paintContext);
    }

    public void handPaper(XlsPaper paper, int heightIndention, int widthIndention) {
        boolean isSuccess = false;
        try {
            LinesList lines = paper.getVerticalLines();
            if (lines != null) {
                isSuccess = this._verticalLines.add(lines);
            }
            this._offset += paper.getHorizonLines().size();
            if (!isSuccess || this._offset >= 1000000) {
                if (this._container.size() == 0) {
                    this._log.info((Object)ResManager.loadKDString((String)"\u65e0\u6cd5\u5bfc\u51fa\uff0c\u4e00\u9875\u7684\u5217\u6570\u5df2\u8d85\u8fc7256\u5217\u3002", (String)"OutputHelper_1", (String)"bos-print-core", (Object[])new Object[0]));
                } else {
                    this.outputOnce(heightIndention, widthIndention);
                    this.handPaper(paper, heightIndention, widthIndention);
                }
            } else {
                this._container.add(paper);
            }
        }
        catch (OutOfSizeException e) {
            this._log.error((Object)ResManager.loadKDString((String)"\u6279\u91cf\u6dfb\u52a0\u4e00\u4e2a\u9875\u9762\u7684\u8fb9\u6846\u65f6\u51fa\u9519\uff01\uff01\uff01", (String)"OutputHelper_2", (String)"bos-print-core", (Object[])new Object[0]));
        }
    }

    public void endOutput(int heightIndention, int widthIndention) {
        this.outputOnce(heightIndention, widthIndention);
        Map<String, List<Point>> pageTotalIndexs = this.xlsContext.getPageTotalIndxMap();
        for (Map.Entry<String, List<Point>> entry : pageTotalIndexs.entrySet()) {
            String sheetName = entry.getKey();
            Sheet sheet = this._book.getSheet(sheetName);
            if (sheet == null) continue;
            List<Point> pointList = entry.getValue();
            for (Point point : pointList) {
                Cell cell;
                Row row = sheet.getRow(point.x);
                if (row == null || (cell = row.getCell(point.y)) == null) continue;
                cell.setCellValue(KPrintUtil.parsePageVariant((String)cell.getStringCellValue(), (int)this.xlsContext.getPageTotal()));
            }
        }
        this.xlsContext.getPageTotalIdSet().clear();
        pageTotalIndexs.clear();
    }

    public void outputOnce(int heightIndention, int widthIndention) {
        this.beforeOutputPapers();
        this._offset = 0;
        Iterator iter = this._container.iterator();
        XlsPaper outputPaper = null;
        while (iter.hasNext()) {
            outputPaper = (XlsPaper)iter.next();
            if (outputPaper.getPaintPaperInfo() != null) {
                this.setPaperType(outputPaper.getPaintPaperInfo());
            } else {
                this.setPaperType((PrintRequestAttributeSet)outputPaper.getPainterInfo().invokeGet("getPrintRequestAttributeSet"));
            }
            this.process(outputPaper, heightIndention, widthIndention);
            iter.remove();
        }
        this.afterOutputPapers();
    }

    private void beforeOutputPapers() {
        Collections.sort(this._verticalLines);
        this._sheet = this._book.createSheet();
        this._paperHelper = new PaperHelper(this._book, this._verticalLines, this._styleMap);
        this._xlsHelper = new XlsHelper(this.xlsContext);
        this._xlsHelper.setPara(this.para);
        this._xlsHelper.updateSheet(this._sheet, this.conStyleMap);
        this._sp = this._sheet.getPrintSetup();
        this._sp.setHeaderMargin(0.0);
        this._sp.setFooterMargin(0.0);
        this._sheet.setMargin((short)2, 0.0);
        this._sheet.setMargin((short)3, 0.0);
        this._sheet.setMargin((short)0, 0.0);
        this._sheet.setMargin((short)1, 0.0);
        this._sheet.setDisplayGridlines(false);
    }

    private void afterOutputPapers() {
        this._offset = 0;
        this._verticalLines = new LinesList(255);
        this._paperHelper = null;
        this._sheet = null;
        this._takenMap = null;
        this._container.clear();
    }

    private void process(XlsPaper paper, int heightIndention, int widthIndention) {
        int preLastRow = this._xlsHelper.getLastRow();
        if (paper.getChildren() == null || paper.getChildren().size() == 0) {
            this.drawEmptyPage();
            return;
        }
        this.initMap(paper);
        Collections.sort(paper.getHorizonLines());
        this._outputPaper = this.exprotPaper(paper);
        this.init(paper, heightIndention, widthIndention);
        this.drawSheet();
        int lastRow = this._xlsHelper.getLastRow();
        this._offset += lastRow - preLastRow;
    }

    private APaper exprotPaper(XlsPaper paper) {
        APaper returnPaper = this._paperHelper.exportPaper(paper);
        return returnPaper;
    }

    private void init(XlsPaper paper, int heightIndetion, int widthIndection) {
        float[] margins = this.doIndent(paper, heightIndetion, widthIndection);
        this._xlsHelper.initRows(this._offset, margins[0], margins[1], margins[4], this._outputPaper, paper.getHorizonLines());
        this._xlsHelper.initCols(margins[2], margins[3], margins[5], this._verticalLines);
    }

    private void drawSheet() {
        HashMap children = this._outputPaper.getChildren();
        ArrayList keys = new ArrayList(children.keySet());
        Collections.sort(keys);
        for (Integer key : keys) {
            List childArray = (List)this._outputPaper.getChildren().get(key);
            for (int i = 0; i < childArray.size(); ++i) {
                BasicCell toOutput = (BasicCell)childArray.get(i);
                this._xlsHelper.outputCell(toOutput, this._takenMap, this._offset, 0, 0);
            }
        }
        this._xlsHelper.setFirstPage(false);
    }

    private void initMap(XlsPaper paper) {
        this._takenMap = new boolean[paper.getHorizonLines().size()][this._verticalLines.size()];
        for (int i = 0; i < this._takenMap.length; ++i) {
            boolean[] row = this._takenMap[i];
            for (int j = 0; j < row.length; ++j) {
                this._takenMap[i][j] = false;
            }
        }
    }

    private float[] doIndent(XlsPaper paper, int heightIndention, int widthIndention) {
        float reduce;
        LinesList horizonLines = paper.getHorizonLines();
        float height = heightIndention;
        float width = widthIndention;
        float contentHeight = horizonLines.getChild(0).getValue();
        float contentWidth = this._verticalLines.getChild(0).getValue();
        float topMargin = contentHeight;
        float bottomMargin = paper.getHeight() - horizonLines.getChild(horizonLines.size() - 1).getValue();
        float leftMargin = contentWidth;
        float rightMargin = paper.getWidth() - this._verticalLines.getChild(this._verticalLines.size() - 1).getValue();
        contentHeight = horizonLines.getChild(horizonLines.size() - 1).getValue();
        contentWidth = this._verticalLines.getChild(this._verticalLines.size() - 1).getValue();
        if (topMargin + bottomMargin >= height) {
            reduce = height / 2.0f;
            if (topMargin >= reduce && bottomMargin >= reduce) {
                topMargin -= reduce;
                bottomMargin -= reduce;
            } else if (topMargin >= reduce) {
                topMargin -= height - bottomMargin;
                bottomMargin = 15.0f;
            } else {
                bottomMargin -= height - topMargin;
                topMargin = 0.0f;
            }
            height = 1.0f;
        } else {
            float x = contentHeight - (height -= topMargin + bottomMargin);
            float y = contentHeight;
            height = x / y;
            topMargin = 0.0f;
            bottomMargin = 15.0f;
        }
        if (leftMargin + rightMargin >= width) {
            reduce = width / 2.0f;
            if (leftMargin >= reduce && rightMargin >= reduce) {
                leftMargin -= reduce;
                rightMargin -= reduce;
            } else if (leftMargin >= reduce) {
                leftMargin -= width - rightMargin;
                rightMargin = 0.0f;
            } else {
                rightMargin -= width - leftMargin;
                leftMargin = 0.0f;
            }
            width = 1.0f;
        } else {
            width -= leftMargin + rightMargin;
            width = (contentWidth - width) / contentWidth;
            leftMargin = 0.0f;
            rightMargin = 0.0f;
        }
        float[] result = new float[]{topMargin, bottomMargin, leftMargin, rightMargin, height, width};
        return result;
    }

    private void drawEmptyPage() {
        int preLastRow = this._xlsHelper.getLastRow();
        LinesList hLines = new LinesList(2);
        try {
            hLines.add(new Location(10.0f));
            hLines.add(new Location(30.0f));
        }
        catch (OutOfSizeException outOfSizeException) {
            // empty catch block
        }
        this._xlsHelper.initRows(this._offset, 0.0f, 0.0f, 0.9f, this._outputPaper, hLines);
        int lastRow = this._xlsHelper.getLastRow();
        this._offset += lastRow - preLastRow;
    }

    public void clearStyleMap() {
        this._styleMap.clear();
        this._xlsHelper.conStyleMap.clear();
    }

    private void setPaperType(PaintPaperInfo paperInfo) {
        R1PrintInfo r1PrintInfo = paperInfo.getR1PrintInfo();
        if ("LANDSCAPE".equalsIgnoreCase(r1PrintInfo.getOrientation())) {
            this._sp.setLandscape(true);
        }
        try {
            MediaSizeName media = MediaSize.findMedia(r1PrintInfo.getPaperSize().width / 10, r1PrintInfo.getPaperSize().height / 10, 1000);
            if (media == MediaSizeName.ISO_A3) {
                this._sp.setPaperSize((short)8);
            } else if (media == MediaSizeName.ISO_A4) {
                this._sp.setPaperSize((short)9);
            } else if (media == MediaSizeName.ISO_A5) {
                this._sp.setPaperSize((short)11);
            } else if (media == MediaSizeName.ISO_B4) {
                this._sp.setPaperSize((short)12);
            } else if (media == MediaSizeName.ISO_B5) {
                this._sp.setPaperSize((short)13);
            }
        }
        catch (Exception ignore) {
            this._log.error((Object)ResManager.loadKDString((String)"\u83b7\u53d6\u7eb8\u5f20\u7c7b\u578b\u5931\u8d25\u3002", (String)"XlsExport_4", (String)"bos-print-core", (Object[])new Object[0]), (Throwable)ignore);
        }
    }

    private void setPaperType(PrintRequestAttributeSet printRequestAttribute) {
        try {
            String type;
            if ("landscape".equals(printRequestAttribute.get(Class.forName("javax.print.attribute.standard.OrientationRequested")).toString())) {
                this._sp.setLandscape(true);
            }
            if ((type = printRequestAttribute.get(Class.forName("javax.print.attribute.standard.Media")).toString()).contains("a3")) {
                this._sp.setPaperSize((short)8);
            } else if (type.contains("a4")) {
                this._sp.setPaperSize((short)9);
            } else if (type.contains("a5")) {
                this._sp.setPaperSize((short)11);
            } else if (type.contains("b4")) {
                this._sp.setPaperSize((short)12);
            } else if (type.contains("b5")) {
                this._sp.setPaperSize((short)13);
            }
        }
        catch (ClassNotFoundException e) {
            this._log.error((Object)ResManager.loadKDString((String)"\u7c7b\u52a0\u8f7d\u5f02\u5e38\u3002", (String)"OutputHelper_5", (String)"bos-print-core", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public XlsContext getXlsContext() {
        return this.xlsContext;
    }
}

