/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.print.xls.output;

import java.util.List;
import java.util.Map;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.print.xls.exobject.APaper;
import kd.bos.print.core.ctrl.print.xls.exobject.BasicCell;
import kd.bos.print.core.ctrl.print.xls.output.LinesList;
import kd.bos.print.core.ctrl.print.xls.output.StyleHelper;
import kd.bos.print.core.ctrl.print.xls.widget.IXlsNode;
import kd.bos.print.core.ctrl.print.xls.widget.XlsBarcodeCell;
import kd.bos.print.core.ctrl.print.xls.widget.XlsCell;
import kd.bos.print.core.ctrl.print.xls.widget.XlsContainer;
import kd.bos.print.core.ctrl.print.xls.widget.XlsImageCell;
import kd.bos.print.core.ctrl.print.xls.widget.XlsLabelCell;
import kd.bos.print.core.ctrl.print.xls.widget.XlsLine;
import kd.bos.print.core.ctrl.print.xls.widget.XlsPaper;
import kd.bos.print.core.ctrl.print.xls.widget.XlsVariantCell;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Workbook;

public class PaperHelper {
    private Workbook _wb;
    private XlsPaper _paper;
    private LinesList _horizonLines;
    private LinesList _verticalLines;
    private Map _styleMap;

    public PaperHelper(Workbook wb, LinesList verticalLines, Map styleMap) {
        this._wb = wb;
        this._verticalLines = verticalLines;
        this._styleMap = styleMap;
    }

    public APaper exportPaper(XlsPaper paper) {
        this._paper = paper;
        this._horizonLines = paper.getHorizonLines();
        APaper apaper = this.exportBody();
        return apaper;
    }

    private APaper exportBody() {
        APaper returnPaper = new APaper();
        List children = this._paper.getChildren();
        if (children != null && children.size() > 0) {
            for (int i = 0; i < children.size(); ++i) {
                IXlsNode node = (IXlsNode)children.get(i);
                BasicCell aCell = null;
                aCell = node instanceof XlsContainer ? this.containerToCell((XlsContainer)node) : this.toCell((XlsCell)node);
                if (null == aCell) continue;
                returnPaper.addChild(aCell);
            }
        }
        return returnPaper;
    }

    private BasicCell containerToCell(XlsContainer container) {
        Style style = container.getStyle();
        BasicCell cell = new BasicCell(container.getId());
        if (container.isPicContainer()) {
            cell.setType(2);
        } else {
            cell.setType(3);
        }
        cell.setX1(this._verticalLines.indexOf((Object)container.getX1()));
        cell.setX2(this._verticalLines.indexOf((Object)container.getX2()));
        cell.setY1(this._horizonLines.indexOf((Object)container.getY1()));
        cell.setY2(this._horizonLines.indexOf((Object)container.getY2()));
        CellStyle cellstyle = null;
        cellstyle = style != null ? this.getStyle(style) : (container.getStyleKey() != null ? this.getStyle(container.getStyleKey()) : this.getStyle("cellstyleisnull!!!"));
        if (cellstyle.getFillPattern() == FillPatternType.NO_FILL && cellstyle.getBorderLeft() == BorderStyle.NONE && cellstyle.getBorderRight() == BorderStyle.NONE && cellstyle.getBorderTop() == BorderStyle.NONE && cellstyle.getBorderBottom() == BorderStyle.NONE) {
            return null;
        }
        cell.setStyle(cellstyle);
        return cell;
    }

    private BasicCell toCell(XlsCell cell) {
        Style style = cell.getStyle();
        BasicCell returnCell = new BasicCell(cell.getId());
        returnCell.setLayer(cell.getLayer());
        returnCell.setX1(this._verticalLines.indexOf((Object)cell.getX1()));
        returnCell.setX2(this._verticalLines.indexOf((Object)cell.getX2()));
        returnCell.setY1(this._horizonLines.indexOf((Object)cell.getY1()));
        returnCell.setY2(this._horizonLines.indexOf((Object)cell.getY2()));
        returnCell.setHeight(cell.getHeight());
        returnCell.setWidth(cell.getWidth());
        CellStyle cellstyle = null;
        cellstyle = style != null ? this.getStyle(style) : (cell.getStyleKey() != null ? this.getStyle(cell.getStyleKey()) : this.getStyle("cellstyleisnull!!!"));
        if (cell instanceof XlsLabelCell && ((XlsLabelCell)cell).isAdjuestHeight()) {
            cellstyle.setWrapText(Boolean.TRUE.booleanValue());
        }
        returnCell.setStyle(cellstyle);
        if (cell instanceof XlsVariantCell) {
            returnCell.setType(5);
            returnCell.setValue(cell.getValue());
        } else if (cell instanceof XlsImageCell) {
            XlsImageCell imageCell = (XlsImageCell)cell;
            returnCell.setType(1);
            returnCell.setScaleModel(imageCell.getScaleModel());
            if (cell.getValue() != null) {
                returnCell.setValue(cell.getValue());
            } else {
                returnCell.setValue(imageCell.getImageKey());
            }
        } else if (cell instanceof XlsBarcodeCell) {
            XlsBarcodeCell barcodeCell = (XlsBarcodeCell)cell;
            Map config = ((XlsBarcodeCell)cell).getConfig();
            if (config == null || config.isEmpty()) {
                return null;
            }
            config.put("painBounds", barcodeCell.getPainBounds());
            returnCell.setConfig(config);
            returnCell.setType(4);
            returnCell.setValue(cell.getValue());
        } else if (cell instanceof XlsLine) {
            XlsLine xlsLine = (XlsLine)cell;
            returnCell.setType(6);
            returnCell.setValue(xlsLine.getLine());
        } else {
            returnCell.setValue(cell.getValue());
        }
        return returnCell;
    }

    private CellStyle getStyle(Style style) {
        String key = this.generateStyleKey(style);
        return this.getStyle(key);
    }

    private CellStyle getStyle(String style) {
        String key = style;
        CellStyle cstyle = (CellStyle)this._styleMap.get(key);
        if (cstyle == null) {
            cstyle = StyleHelper.getStyle((String)style, (Workbook)this._wb);
            this._styleMap.put(key, cstyle);
        }
        return cstyle;
    }

    private String generateStyleKey(Style style) {
        return StyleHelper.getKey((Style)style);
    }

    public Map getStyleMap() {
        return this._styleMap;
    }
}

