/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.esc.convert.escp;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.MapField;
import kd.bos.print.core.esc.EscPosConst;
import kd.bos.print.core.esc.EscUtil;
import kd.bos.print.core.esc.convert.escp.BaseEscpConvert;
import kd.bos.print.core.esc.model.EBarcode;
import kd.bos.print.core.esc.model.EBlock;
import kd.bos.print.core.esc.model.EImage;
import kd.bos.print.core.execute.render.painter.pwpainer.image.ImagePaperPainter;
import kd.bos.print.core.model.designer.BarcodeObject;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.barcode.PWBarcode;

public class PWBarcodeEscpConvert
extends BaseEscpConvert {
    public PWBarcodeEscpConvert(BaseEscpConvert.EscpContext context) {
        super(context);
    }

    public EBlock convert(AbstractPrintWidget widget, boolean fixed) {
        EBarcode block;
        PWBarcode pwCode = (PWBarcode)widget;
        Rectangle childRect = pwCode.getRectangle();
        int x = childRect.x;
        int y = childRect.y;
        int width = childRect.width;
        int height = childRect.height;
        BarcodeObject barcodeObject = pwCode.getBarcodeObject();
        Field outputValue = pwCode.getOutputValue();
        Object barcodeVal = null;
        String barcodeType = null;
        if (outputValue instanceof MapField) {
            MapField mapField = (MapField)outputValue;
            Map config = (Map)mapField.getValue();
            barcodeType = String.valueOf(config.get("barcodeType"));
            barcodeVal = config.get("barcode");
            if (StringUtils.isBlank(barcodeVal)) {
                barcodeVal = barcodeObject.getSampleTxt();
            }
        }
        if (barcodeVal == null || !this.isSupportBarcodeType(barcodeType)) {
            return null;
        }
        if (pwCode.isQRCode()) {
            EImage eImage = new EImage();
            BufferedImage scaledImage = EscUtil.drawWidget((ImagePaperPainter)this.painter, (AbstractPrintWidget)pwCode, (int)180);
            eImage.setImage(scaledImage);
            block = eImage;
        } else {
            EBarcode eBarcode;
            block = eBarcode = new EBarcode();
            eBarcode.setText(barcodeVal.toString());
            double heightUnit = childRect.getHeight() / (double)254.3f * 180.0;
            eBarcode.setHeight((int)heightUnit);
            eBarcode.setHriPosition(barcodeObject.isShowText() ? EscPosConst.BarCodeHRIPosition.BelowBarCode : EscPosConst.BarCodeHRIPosition.NotPrinted_Default);
            this.barcodeSystemConvert(eBarcode, barcodeType);
        }
        Style style = pwCode.getStyle();
        if (style != null) {
            if (style.getHorizontalAlign() == Styles.HorizontalAlignment.LEFT) {
                block.setAlign(EscPosConst.Align.Left_Default);
            } else if (style.getHorizontalAlign() == Styles.HorizontalAlignment.CENTER) {
                block.setAlign(EscPosConst.Align.Center);
            } else if (style.getHorizontalAlign() == Styles.HorizontalAlignment.RIGHT) {
                block.setAlign(EscPosConst.Align.Right);
            }
        }
        this.setPosition((EBlock)block, x, y, width, height, fixed);
        return block;
    }

    private void barcodeSystemConvert(EBarcode eBarcode, String barcodeType) {
        if (StringUtils.equals((CharSequence)"ean-13", (CharSequence)barcodeType)) {
            eBarcode.setSystem(EscPosConst.BarCodeSystem.JAN13_A);
        } else if (StringUtils.equals((CharSequence)"code39", (CharSequence)barcodeType)) {
            eBarcode.setSystem(EscPosConst.BarCodeSystem.CODE39_A);
        } else if (StringUtils.equals((CharSequence)"ean-128", (CharSequence)barcodeType)) {
            eBarcode.setSystem(EscPosConst.BarCodeSystem.GS1_128);
        } else {
            eBarcode.setSystem(EscPosConst.BarCodeSystem.CODE128);
            eBarcode.setText("A" + eBarcode.getText());
        }
    }
}

