/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.qrender.convert;

import java.util.List;
import kd.bos.form.watermark.WaterMark;
import kd.bos.print.core.exception.PrintException;
import kd.bos.print.core.execute.qrender.CPage;
import kd.bos.print.core.execute.qrender.CRenderUnit;
import kd.bos.print.core.execute.qrender.CWaterMark;
import kd.bos.print.core.execute.qrender.convert.AbstractRenderConvert;
import kd.bos.print.core.execute.qrender.convert.CBarcodeConvert;
import kd.bos.print.core.execute.qrender.convert.CGridCellConvert;
import kd.bos.print.core.execute.qrender.convert.CGridConvert;
import kd.bos.print.core.execute.qrender.convert.CHFooterConvert;
import kd.bos.print.core.execute.qrender.convert.CImageConvert;
import kd.bos.print.core.execute.qrender.convert.CLabelConvert;
import kd.bos.print.core.execute.qrender.convert.CLineConvert;
import kd.bos.print.core.execute.qrender.convert.CPanelConvert;
import kd.bos.print.core.execute.qrender.convert.CQRCodeConvert;
import kd.bos.print.core.execute.qrender.convert.CRichTextConvert;
import kd.bos.print.core.execute.qrender.convert.IContainerConvert;
import kd.bos.print.core.model.designer.BarcodeObject;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.PWFooter;
import kd.bos.print.core.model.widget.PWLine;
import kd.bos.print.core.model.widget.PWPage;
import kd.bos.print.core.model.widget.PWPicture;
import kd.bos.print.core.model.widget.PWRichText;
import kd.bos.print.core.model.widget.PWText;
import kd.bos.print.core.model.widget.barcode.PWBarcode;
import kd.bos.print.core.model.widget.grid.AbstractPWGrid;
import kd.bos.print.core.model.widget.grid.tabletail.PWTableTail;
import kd.bos.url.UrlService;
import org.apache.commons.lang.StringUtils;

public class CPageConvert
extends AbstractRenderConvert<PWPage, CPage>
implements IContainerConvert {
    private CLineConvert cLineConvert;
    private CLabelConvert cLableConvert;
    private CImageConvert cImageConvert;
    private CRichTextConvert cRichTextConvert;
    private CBarcodeConvert cBarcodeConvert;
    private CQRCodeConvert cQRCodeConvert;
    private CGridConvert cGridConvert;
    private CGridCellConvert cGridCellConvert;
    private CPanelConvert cPanelConvert;
    private CHFooterConvert chFooterConvert;

    public CPageConvert() {
        this.measureUnit = CRenderUnit.UNIT_MM;
        this.fontUnit = CRenderUnit.UNIT_PIX;
    }

    public CPageConvert(CRenderUnit measureUnit, CRenderUnit fontUnit) {
        this.measureUnit = measureUnit;
        this.fontUnit = fontUnit;
    }

    public CWaterMark parseWaterMark(WaterMark waterMark) {
        String wmText;
        if (waterMark == null) {
            return null;
        }
        CWaterMark cWaterMark = new CWaterMark();
        cWaterMark.setType(waterMark.getType());
        if ("0".equals(cWaterMark.getType())) {
            return null;
        }
        cWaterMark.setFontColor(waterMark.getColor());
        cWaterMark.setImgK("2");
        cWaterMark.setImg(waterMark.getPicture());
        float globalAlpha = waterMark.getGlobalAlpha();
        if (globalAlpha > 0.0f && globalAlpha <= 100.0f) {
            globalAlpha /= 100.0f;
        }
        cWaterMark.setAlpha(globalAlpha);
        float fontSize = 12.0f;
        try {
            String size = waterMark.getFontSize();
            size = size.replace("px", "");
            fontSize = Integer.parseInt(size);
        }
        catch (Exception size) {
            // empty catch block
        }
        cWaterMark.setFontSize(fontSize);
        String picture = waterMark.getPicture();
        if (StringUtils.isNotBlank((String)picture)) {
            String imageUrl = UrlService.getDomainContextUrl() + picture;
            cWaterMark.setImg(imageUrl);
        }
        if ((wmText = waterMark.getText()) == null) {
            wmText = "";
        }
        wmText = wmText.replaceAll("\\\\n", "\n").replaceAll("\\/n", "\n");
        cWaterMark.setText(wmText);
        if ("1".equals(cWaterMark.getType()) && StringUtils.isBlank((String)wmText)) {
            return null;
        }
        if ("2".equals(cWaterMark.getType()) && StringUtils.isBlank((String)cWaterMark.getImg())) {
            return null;
        }
        return cWaterMark;
    }

    public CPage parseFormWidget(PWPage pwPage) {
        CPage cPage = new CPage();
        this.fillPropertyFromPWPage(cPage, pwPage);
        return cPage;
    }

    public void fillPropertyFromPWPage(CPage cPage, PWPage pwPage) {
        List children = pwPage.getChildren();
        List renders = cPage.getChildren();
        this.convertChildren(children, renders);
    }

    protected PWPage parseFromRender(CPage cPage) {
        PWPage pwPage = new PWPage();
        return pwPage;
    }

    public AbstractRenderConvert getConvert(AbstractPrintWidget widget) {
        if (widget instanceof PWFooter) {
            return this.getHFooterConvert();
        }
        if (widget instanceof PWText) {
            return this.getLableConvert();
        }
        if (widget instanceof PWBarcode) {
            PWBarcode pwBarcode = (PWBarcode)widget;
            BarcodeObject barcodeObject = pwBarcode.getBarcodeObject();
            String barcodeType = barcodeObject.getBarcodeType();
            if (this.isQrCode(barcodeType)) {
                return this.getQRCodeConvert();
            }
            return this.getBarcodeConvert();
        }
        if (widget instanceof AbstractPWGrid) {
            return this.getGridConvert();
        }
        if (widget instanceof PWPicture) {
            return this.getImageConvert();
        }
        if (widget instanceof PWTableTail) {
            return this.getPanelConvert();
        }
        if (widget instanceof PWRichText) {
            return this.getRichTextConvert();
        }
        if (widget instanceof PWLine) {
            return this.getLineConvert();
        }
        throw new PrintException("-1", "not support convert type.");
    }

    private boolean isQrCode(String barcodeType) {
        return "QR_CODE".equals(barcodeType) || "PDF417".equals(barcodeType) || "Truncated_PDF417".equals(barcodeType) || "MicroPDF417".equals(barcodeType) || "Data_Matrix".equals(barcodeType) || "GS1_Data_Matrix".equals(barcodeType);
    }

    CLineConvert getLineConvert() {
        if (this.cLineConvert == null) {
            this.cLineConvert = new CLineConvert(this);
        }
        return this.cLineConvert;
    }

    CLabelConvert getLableConvert() {
        if (this.cLableConvert == null) {
            this.cLableConvert = new CLabelConvert(this);
        }
        return this.cLableConvert;
    }

    CImageConvert getImageConvert() {
        if (this.cImageConvert == null) {
            this.cImageConvert = new CImageConvert(this);
        }
        return this.cImageConvert;
    }

    CRichTextConvert getRichTextConvert() {
        if (this.cRichTextConvert == null) {
            this.cRichTextConvert = new CRichTextConvert(this);
        }
        return this.cRichTextConvert;
    }

    CBarcodeConvert getBarcodeConvert() {
        if (this.cBarcodeConvert == null) {
            this.cBarcodeConvert = new CBarcodeConvert(this);
        }
        return this.cBarcodeConvert;
    }

    CQRCodeConvert getQRCodeConvert() {
        if (this.cQRCodeConvert == null) {
            this.cQRCodeConvert = new CQRCodeConvert(this);
        }
        return this.cQRCodeConvert;
    }

    CGridConvert getGridConvert() {
        if (this.cGridConvert == null) {
            this.cGridConvert = new CGridConvert(this);
        }
        return this.cGridConvert;
    }

    CGridCellConvert getGridCellConvert() {
        if (this.cGridCellConvert == null) {
            this.cGridCellConvert = new CGridCellConvert(this);
        }
        return this.cGridCellConvert;
    }

    CPanelConvert getPanelConvert() {
        if (this.cPanelConvert == null) {
            this.cPanelConvert = new CPanelConvert(this);
        }
        return this.cPanelConvert;
    }

    CHFooterConvert getHFooterConvert() {
        if (this.chFooterConvert == null) {
            this.chFooterConvert = new CHFooterConvert(this);
        }
        return this.chFooterConvert;
    }

    public AbstractRenderConvert getChildConvert(AbstractPrintWidget widget) {
        return this.getConvert(widget);
    }
}

