/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.qrender.convert;

import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.MapField;
import kd.bos.print.core.execute.qrender.CQRCode;
import kd.bos.print.core.execute.qrender.CRender;
import kd.bos.print.core.execute.qrender.convert.CPageConvert;
import kd.bos.print.core.execute.qrender.convert.CRenderConvert;
import kd.bos.print.core.model.designer.BarcodeObject;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.barcode.PWBarcode;
import kd.bos.print.core.model.widget.barcode.painter.EAN128Utils;

public class CQRCodeConvert
extends CRenderConvert<PWBarcode, CQRCode> {
    public CQRCodeConvert(CPageConvert pageConvert) {
        super(pageConvert);
    }

    protected CQRCode createCRender() {
        return new CQRCode();
    }

    protected CQRCode parseFormWidget(PWBarcode pwBarcode) {
        CQRCode cQrCode = this.createCRender();
        super.fillBaseProperty((AbstractPrintWidget)pwBarcode, (CRender)cQrCode);
        Field outputValue = pwBarcode.getOutputValue();
        BarcodeObject barcodeObject = pwBarcode.getBarcodeObject();
        cQrCode.setEcl(barcodeObject.getErrorCorrection());
        if (outputValue instanceof MapField) {
            MapField mapField = (MapField)outputValue;
            Map config = (Map)mapField.getValue();
            Object barcodeVal = config.get("barcode");
            if (StringUtils.isBlank(barcodeVal)) {
                barcodeVal = barcodeObject.getSampleTxt();
            }
            if (StringUtils.isBlank(barcodeVal)) {
                return null;
            }
            String barcodeType = String.valueOf(config.get("barcodeType"));
            if ("PDF417".equals(barcodeType)) {
                cQrCode.setModel(55);
            } else if ("Truncated_PDF417".equals(barcodeType)) {
                cQrCode.setModel(56);
            } else if ("MicroPDF417".equals(barcodeType)) {
                cQrCode.setModel(84);
            } else if ("Data_Matrix".equals(barcodeType) || "GS1_Data_Matrix".equals(barcodeType)) {
                Object dmSizeObj = config.get("dmSize");
                int dmSize = 0;
                if (dmSizeObj != null) {
                    try {
                        dmSize = Integer.parseInt(dmSizeObj.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                cQrCode.setDmSize(dmSize);
                cQrCode.setModel(71);
                if ("GS1_Data_Matrix".equals(barcodeType)) {
                    cQrCode.setGs1(true);
                    try {
                        barcodeVal = EAN128Utils.buildHumanReadableMsg((String)String.valueOf(barcodeVal));
                    }
                    catch (Exception e) {
                        barcodeVal = "";
                    }
                }
            } else {
                cQrCode.setModel(58);
            }
            cQrCode.setText(barcodeVal.toString());
        }
        return cQrCode;
    }
}

