/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.render;

import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ExecuteService;
import kd.bos.print.core.ctrl.common.util.FileUtil;
import kd.bos.print.core.execute.ExecuteLife;
import kd.bos.print.core.execute.PrintJobPool;
import kd.bos.print.core.execute.render.PainerWork;
import kd.bos.print.core.execute.render.RenderCaptain;
import kd.bos.print.core.execute.render.export.AbstractPrtExport;
import kd.bos.print.core.execute.render.export.PdfPrtExport;
import kd.bos.print.core.execute.render.painter.APaperPainter;
import kd.bos.print.core.execute.render.painter.EndOnePaper;
import kd.bos.print.core.execute.render.painter.PaintPaperInfo;
import kd.bos.print.core.execute.render.painter.pwpainer.PaperPainter;
import kd.bos.print.core.execute.render.painter.share.ShareResource;
import kd.bos.print.core.plugin.PrintPluginProxy;
import kd.bos.print.core.plugin.event.BeforeExportEvent;
import kd.bos.print.core.plugin.event.EndExportEvent;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.core.utils.PrintConst;

/*
 * Exception performing whole class analysis ignored.
 */
public class RenderCaptain<T extends APaperPainter> {
    protected WorkQueue workQueue = new WorkQueue();
    protected int ontPdfPage = PrintConst.onePdfMaxPage();
    private boolean startNewBill;
    private boolean pdfIndexAdd;
    protected ShareResource shareResource = new ShareResource();
    protected Log log = LogFactory.getLog(this.getClass());
    protected int addNum = 0;
    protected int pdfIndex = 1;
    protected ExecuteLife executeLife;

    public RenderCaptain(ExecuteLife executeLife) {
        this.executeLife = executeLife;
    }

    public APaperPainter createPaperPainter(PaintPaperInfo paperInfo) {
        return new PaperPainter(paperInfo);
    }

    protected int getMaxConsumeThread() {
        return PrintConst.maxConsumeThread();
    }

    public void put(T paper) throws InterruptedException {
        ++this.addNum;
        String fileName = null;
        WorkNode workNode = this.workQueue.curent();
        if (workNode == null) {
            this.createPainer();
            workNode = this.workQueue.curent();
            fileName = this.getFileName(paper);
            this.shareResource.setFileName(fileName);
            paper.setFileName(fileName);
        }
        if (this.addNum > this.ontPdfPage || this.startNewBill) {
            workNode.work.put((APaperPainter)EndOnePaper.getInstance());
            this.afterEndOne();
            this.addNum = 1;
            if (this.workQueue.size() <= this.getMaxConsumeThread() - 1) {
                this.createPainer();
                workNode = this.workQueue.next();
            } else {
                workNode = this.workQueue.findFree();
            }
            if (this.startNewBill) {
                if (this.pdfIndexAdd) {
                    ++this.pdfIndex;
                }
                this.startNewBill = false;
            } else {
                ++this.pdfIndex;
            }
            if (fileName == null) {
                fileName = this.getFileName(paper);
                paper.setFileName(fileName);
            }
        }
        PainerWork work = workNode.work;
        paper.getPaintContext().setShareResource(this.shareResource);
        paper.setFileIndex(this.pdfIndex);
        work.put(paper);
    }

    public void resetWithFileNameCustom() {
        this.pdfIndex = 1;
        this.addNum = 1;
        this.startNewBill = true;
    }

    public void resetWithFileNameNormal() {
        this.addNum = 1;
        this.startNewBill = true;
        this.pdfIndexAdd = true;
    }

    private String getFileName(T paper) {
        String fileName = paper.getTplName();
        PrintPluginProxy pluginProxy = ExecuteContext.get().getPluginProxy();
        if (pluginProxy != null) {
            BeforeExportEvent evt = new BeforeExportEvent();
            evt.setFileTplName(fileName);
            pluginProxy.fireBeforeExport(evt);
            fileName = evt.getFileTplName();
        }
        return fileName;
    }

    protected void afterEndOne() {
    }

    public void endWork() throws ExecutionException, InterruptedException {
        PrintPluginProxy pluginProxy;
        List nodes = this.workQueue.nodes;
        for (WorkNode node : nodes) {
            node.work.endWork();
        }
        for (WorkNode node : nodes) {
            WorkNode.access$000((WorkNode)node).get();
        }
        PrtAttach attach = this.shareResource.getAttach();
        if (attach != null && attach.getAttachDetail() != null && attach.getAttachDetail().size() > 0) {
            this.handPrtResult(this.shareResource);
        }
        if ((pluginProxy = ExecuteContext.get().getPluginProxy()) != null) {
            EndExportEvent evt = new EndExportEvent();
            evt.setPrtAttach(attach);
            evt.setPageTotal(this.shareResource.getPdfPageSize());
            pluginProxy.fireEndOutput(evt);
        }
        this.shareResource.release();
    }

    protected void handPrtResult(ShareResource shareResource) {
        PrtAttach attach = shareResource.getAttach();
        ExecuteService.getAttachService().savePrtResult(attach);
    }

    public void finish() {
        String path = File.separator + "temp" + File.separator + ExecuteContext.get().getTaskId();
        FileUtil.deleteFile((String)path);
    }

    private void createPainer() {
        PainerWork painerWork = new PainerWork(this.createPdfExport(), this.executeLife);
        Future submit = PrintJobPool.submit((Callable)painerWork);
        this.workQueue.add(new WorkNode(painerWork, submit));
    }

    protected AbstractPrtExport createPdfExport() {
        return new PdfPrtExport();
    }
}

