/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute.render.export;

import java.rmi.server.ExportException;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ctrl.print.xls.R1PrintV2XExporter;
import kd.bos.print.core.ctrl.print.xls.output.OutputHelper;
import kd.bos.print.core.exception.PrintException;
import kd.bos.print.core.execute.render.Release;
import kd.bos.print.core.execute.render.export.AbstractPrtExport;
import kd.bos.print.core.execute.render.painter.APaperPainter;
import kd.bos.print.core.execute.render.painter.PaintContext;
import kd.bos.print.core.execute.render.painter.pwpainer.xls.XlsPaperPainter;
import kd.bos.print.core.execute.render.painter.share.AwtImageShare;
import kd.bos.print.core.execute.render.painter.share.ImageShare;
import kd.bos.print.core.execute.render.painter.share.ShareResource;
import kd.bos.print.core.model.widget.PWPageEnum;
import kd.bos.print.core.service.PrtAttach;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class XlsPrtExport
extends AbstractPrtExport<XlsPaperPainter>
implements Release {
    private Workbook workbook;
    private OutputHelper outputHelper;
    private R1PrintV2XExporter exporter = null;
    private int horIndetion = 10;
    private int verIndetion = 5;

    public void begin(XlsPaperPainter paper) {
        super.begin((APaperPainter)paper);
        this.workbook = new SXSSFWorkbook(5000);
        ((SXSSFWorkbook)this.workbook).setZip64Mode(Zip64Mode.AsNeeded);
        this.outputHelper = new OutputHelper(this.workbook);
        PaintContext paintContext = new PaintContext();
        paintContext.setShareResource(new ShareResource());
        paintContext.getShareResource().setImageShare((ImageShare)new AwtImageShare());
        this.outputHelper.setPaintContext(paintContext);
        try {
            this.exporter = new R1PrintV2XExporter();
            this.exporter.setPaintContext(paintContext);
        }
        catch (ExportException e) {
            throw new PrintException(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u6587\u4ef6\u4e22\u5931\u3002", (String)"XlsExport_3", (String)"bos-print-core", (Object[])new Object[0]), (Exception)e);
        }
    }

    public void export(XlsPaperPainter painter) {
        if (this.workbook == null) {
            this.begin(painter);
        }
        painter.setHorIndetion(this.horIndetion);
        painter.setVerIndetion(this.verIndetion);
        painter.paint(this.exporter, this.outputHelper);
        if (PWPageEnum.INSTANCE.getEmptyPage() == painter.getPaintObj()) {
            String pageNumType = ExecuteContext.get().getPageNumType();
            if ("2".equals(pageNumType)) {
                ++this.curExpPageSize;
            }
        } else {
            ++this.curExpPageSize;
        }
    }

    public void endOne() throws Exception {
        if (this.workbook == null) {
            return;
        }
        this.outputHelper.getXlsContext().setPageTotal(this.curExpPageSize);
        this.outputHelper.endOutput(this.horIndetion, this.verIndetion);
        this.workbook.write(this.os);
        this.os.flush();
        this.os.close();
        String fileName = this.getFileName();
        PrtAttach.AttachDetail attachDetail = new PrtAttach.AttachDetail();
        attachDetail.setFileName(fileName);
        attachDetail.setSource("B");
        attachDetail.setSeq(this.curFileIndex);
        String filePath = this.savePrtFile(attachDetail.getFileName(), this.os);
        attachDetail.setFilePath(filePath);
        this.attachList.add(attachDetail);
        this.os.close();
        this.release();
        this.workbook = null;
        this.outputHelper.clearStyleMap();
        this.log.debug(ResManager.loadKDString((String)"\u5bfc\u51fa\u7ed3\u675f\u65f6\u95f4\uff1a", (String)"XlsExport_2", (String)"bos-print-core", (Object[])new Object[0]) + System.currentTimeMillis() + "ms");
    }

    protected String getFileNameSuffix() {
        return "xlsx";
    }

    public void release() {
        if (this.workbook instanceof SXSSFWorkbook) {
            try {
                ((SXSSFWorkbook)this.workbook).dispose();
            }
            catch (Exception e) {
                this.log.error((Throwable)e);
            }
        }
    }
}

