/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.label.cpcl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ctrl.common.KDToolkit;
import kd.bos.print.core.ctrl.kdf.util.style.Border;
import kd.bos.print.core.ctrl.kdf.util.style.LineStyle;
import kd.bos.print.core.ctrl.kdf.util.style.Rect;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.ctrl.reportone.r1.print.common.ImageUtil;
import kd.bos.print.core.ctrl.reportone.r1.print.common.R1PrintInfo;
import kd.bos.print.core.ctrl.swing.KDFont;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.ImageField;
import kd.bos.print.core.data.field.MapField;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.execute.render.painter.pwpainer.PaperPainter;
import kd.bos.print.core.label.cpcl.BorderLine;
import kd.bos.print.core.label.cpcl.CpclBuilder;
import kd.bos.print.core.model.designer.BarcodeObject;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.PWLine;
import kd.bos.print.core.model.widget.PWPage;
import kd.bos.print.core.model.widget.PWPicture;
import kd.bos.print.core.model.widget.PWText;
import kd.bos.print.core.model.widget.barcode.PWBarcode;
import kd.bos.print.core.model.widget.grid.AbstractPWGrid;
import kd.bos.print.core.model.widget.grid.AbstractPWGridCell;
import kd.bos.print.core.model.widget.grid.AbstractPWGridRow;
import kd.bos.print.core.model.widget.grid.MergeType;
import kd.bos.print.core.model.widget.grid.cardgrid.PWCardGrid;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGrid;
import kd.bos.print.core.model.widget.grid.layoutgrid.PWLayoutGrid;
import kd.bos.print.core.model.widget.grid.tabletail.PWTableTail;

public class CpclUtils {
    private int dpi = ExecuteContext.get().getDpi() == 0 ? KDToolkit.getCurrentDpi() : ExecuteContext.get().getDpi();
    private CpclBuilder builder = new CpclBuilder();
    private double drawX = 0.0;
    private double drawY = 0.0;

    public void addPage(PaperPainter paper) {
        PWPage pwPage = (PWPage)paper.getPaintObj();
        if (pwPage == null) {
            return;
        }
        R1PrintInfo r1PrintInfo = paper.getPaperInfo().getR1PrintInfo();
        Dimension paperSize = r1PrintInfo.getPaperSize();
        this.builder.createArea((int)this.lomToPrintPoint(r1PrintInfo.getMarginLeft()), this.dpi, (int)this.lomToPrintPoint(paperSize.width - r1PrintInfo.getMarginLeft() - r1PrintInfo.getMarginRight()), (int)this.lomToPrintPoint(paperSize.height - r1PrintInfo.getMarginTop() - r1PrintInfo.getMarginBottom()), 1);
        List children = pwPage.getChildren();
        for (IPrintWidget printWidget : children) {
            this.append(printWidget, this.builder);
        }
        this.builder = this.builder.form().print();
        this.drawX = 0.0;
        this.drawY = 0.0;
    }

    private void append(IPrintWidget printWidget, CpclBuilder builder) {
        if (printWidget instanceof PWText) {
            this.textCmd((PWText)printWidget, builder);
            return;
        }
        if (printWidget instanceof PWPicture) {
            this.imgCmd((PWPicture)printWidget, builder);
            return;
        }
        if (printWidget instanceof PWBarcode) {
            this.barcodeCmd((PWBarcode)printWidget, builder);
            return;
        }
        if (printWidget instanceof PWLine) {
            this.line((PWLine)printWidget, builder);
        }
        if (printWidget instanceof PWLayoutGrid) {
            this.gridCmd((AbstractPWGrid)((PWLayoutGrid)printWidget), builder);
        }
        if (printWidget instanceof PWDataGrid) {
            this.gridCmd((AbstractPWGrid)printWidget, builder);
        }
        if (printWidget instanceof PWCardGrid) {
            this.gridCmd((AbstractPWGrid)printWidget, builder);
        }
        if (printWidget instanceof PWTableTail) {
            this.tableTail((PWTableTail)printWidget, builder);
        }
    }

    private void tableTail(PWTableTail printWidget, CpclBuilder builder) {
        PWTableTail tableTail = printWidget;
        Rectangle rectangle = tableTail.getRectangle();
        int x = (int)this.lomToPrintPoint(rectangle.getX());
        int y = (int)this.lomToPrintPoint(rectangle.getY());
        double height = this.lomToPrintPoint(rectangle.getHeight());
        double width = this.lomToPrintPoint(rectangle.getWidth());
        CpclUtils.drawBorder(builder, tableTail.getStyle(), x, y, height, width);
        List tailChildren = tableTail.getChildren();
        if (CollectionUtils.isEmpty((Collection)tailChildren)) {
            return;
        }
        this.drawX = rectangle.getX();
        this.drawY = rectangle.getY();
        for (AbstractPrintWidget tailChild : tailChildren) {
            this.append((IPrintWidget)tailChild, builder);
        }
        this.drawX = 0.0;
        this.drawY = 0.0;
    }

    private void gridCmd(AbstractPWGrid layoutGrid, CpclBuilder builder) {
        BorderLine preLineStyle;
        BorderLine lineStyle;
        List outputRows = layoutGrid.getOutputRows();
        if (CollectionUtils.isEmpty(outputRows)) {
            return;
        }
        Rectangle gridRectangle = layoutGrid.getRectangle();
        this.drawX = gridRectangle.getX();
        this.drawY = gridRectangle.getY();
        BorderLine[][] hLineStyles = new BorderLine[outputRows.size() + 1][layoutGrid.getColumnCount()];
        BorderLine[][] vLineStyles = new BorderLine[layoutGrid.getColumnCount() + 1][outputRows.size()];
        for (int i = 0; i < outputRows.size(); ++i) {
            AbstractPWGridRow outputRow = (AbstractPWGridRow)outputRows.get(i);
            for (int j = 0; j < outputRow.getCellCount() && j < layoutGrid.getColumnCount(); ++j) {
                Object column;
                List children;
                Border bottomBorder;
                Border topBorder;
                Border rightBorder;
                AbstractPWGridCell cell = outputRow.getCell(j);
                if (cell == null || MergeType.BeMerged == cell.getMergeType()) {
                    Object column2;
                    if (j >= layoutGrid.getColumnCount() || (column2 = layoutGrid.getColumn(j)) == null) continue;
                    int width = column2.getWidth();
                    this.drawX += (double)width;
                    continue;
                }
                Rectangle cellRectangle = cell.getRectangle();
                double x = cellRectangle.getX() + this.drawX;
                double y = cellRectangle.getY() + this.drawY;
                Style style = cell.getStyle();
                Border leftBorder = style.getBorder(Styles.Position.LEFT);
                if (!leftBorder.isNull()) {
                    LineStyle lineStyle2 = leftBorder.getLineStyle();
                    vLineStyles[j][i] = new BorderLine(x, y, cellRectangle.getHeight(), lineStyle2);
                }
                if (!(rightBorder = style.getBorder(Styles.Position.RIGHT)).isNull()) {
                    LineStyle lineStyle3 = rightBorder.getLineStyle();
                    vLineStyles[j + 1][i] = new BorderLine(x + cellRectangle.getWidth(), y, cellRectangle.getHeight(), lineStyle3);
                }
                if (!(topBorder = style.getBorder(Styles.Position.TOP)).isNull()) {
                    LineStyle lineStyle4 = topBorder.getLineStyle();
                    hLineStyles[i][j] = new BorderLine(x, y, cellRectangle.getWidth(), lineStyle4);
                }
                if (!(bottomBorder = style.getBorder(Styles.Position.BOTTOM)).isNull()) {
                    LineStyle lineStyle5 = bottomBorder.getLineStyle();
                    hLineStyles[i + 1][j] = new BorderLine(x, y + cellRectangle.getHeight(), cellRectangle.getWidth(), lineStyle5);
                }
                if (CollectionUtils.isEmpty((Collection)(children = cell.getChildren()))) {
                    Object column3;
                    String outputText = cell.getOutputText();
                    if (StringUtils.isNotBlank((CharSequence)outputText)) {
                        this.textCmd((PWText)cell, builder);
                    }
                    if (j >= layoutGrid.getColumnCount() || (column3 = layoutGrid.getColumn(j)) == null) continue;
                    int width = column3.getWidth();
                    this.drawX += (double)width;
                    continue;
                }
                for (IPrintWidget child : children) {
                    this.append(child, builder);
                }
                if (j >= layoutGrid.getColumnCount() || (column = layoutGrid.getColumn(j)) == null) continue;
                int width = column.getWidth();
                this.drawX += (double)width;
            }
            this.drawY += (double)outputRow.getHeight();
            this.drawX = gridRectangle.getX();
        }
        ArrayList<BorderLine> borderLines = new ArrayList<BorderLine>(10);
        double startY = gridRectangle.getY();
        for (int i = 0; i < hLineStyles.length; ++i) {
            BorderLine[] hLineStyle = hLineStyles[i];
            double startX = gridRectangle.getX();
            for (int j = 0; j < hLineStyle.length; ++j) {
                lineStyle = hLineStyle[j];
                if (lineStyle == null) {
                    if (!borderLines.isEmpty()) {
                        startX = this.hBorder(builder, borderLines);
                        continue;
                    }
                    startX += (double)layoutGrid.getColumn(j).getWidth();
                    continue;
                }
                if (borderLines.isEmpty()) {
                    borderLines.add(lineStyle);
                    continue;
                }
                preLineStyle = (BorderLine)borderLines.get(borderLines.size() - 1);
                if (lineStyle.getStyle().getWidth() == preLineStyle.getStyle().getWidth() && lineStyle.y == preLineStyle.y) {
                    borderLines.add(lineStyle);
                    continue;
                }
                startX = this.hBorder(builder, borderLines);
                borderLines.add(lineStyle);
            }
            if (!borderLines.isEmpty()) {
                this.hBorder(builder, borderLines);
            }
            if (i >= outputRows.size()) break;
            AbstractPWGridRow row = (AbstractPWGridRow)outputRows.get(i);
            startY += (double)row.getHeight();
        }
        double startX = gridRectangle.getX();
        for (int i = 0; i < vLineStyles.length; ++i) {
            BorderLine[] vLineStyle = vLineStyles[i];
            startY = gridRectangle.getY();
            for (int j = 0; j < vLineStyle.length; ++j) {
                lineStyle = vLineStyle[j];
                if (lineStyle == null) {
                    if (!borderLines.isEmpty()) {
                        startY = this.vBorder(builder, borderLines);
                        continue;
                    }
                    startY += (double)((AbstractPWGridRow)outputRows.get(j)).getHeight();
                    continue;
                }
                if (borderLines.isEmpty()) {
                    borderLines.add(lineStyle);
                    continue;
                }
                preLineStyle = (BorderLine)borderLines.get(borderLines.size() - 1);
                if (lineStyle.getStyle().getWidth() == preLineStyle.getStyle().getWidth() && lineStyle.x == preLineStyle.x) {
                    borderLines.add(lineStyle);
                    continue;
                }
                startY = this.vBorder(builder, borderLines);
                borderLines.add(lineStyle);
            }
            if (!borderLines.isEmpty()) {
                this.vBorder(builder, borderLines);
            }
            if (i >= layoutGrid.getColumnCount()) break;
            startX += (double)layoutGrid.getColumn(i).getWidth();
        }
        this.drawX = 0.0;
        this.drawY = 0.0;
    }

    private double vBorder(CpclBuilder builder, List<BorderLine> borderLines) {
        double lineWidth = 0.0;
        for (BorderLine borderLine : borderLines) {
            lineWidth += borderLine.length;
        }
        double startX = borderLines.get((int)0).x;
        double startY = borderLines.get((int)0).y;
        int lw = borderLines.get(0).getStyle().getWidth();
        builder.line((int)this.lomToPrintPoint(startX), (int)this.lomToPrintPoint(startY), (int)this.lomToPrintPoint(startX), (int)this.lomToPrintPoint(startY + lineWidth), lw);
        borderLines.clear();
        return startY += lineWidth;
    }

    private double hBorder(CpclBuilder builder, List<BorderLine> borderLines) {
        double lineWidth = 0.0;
        for (BorderLine borderLine : borderLines) {
            lineWidth += borderLine.length;
        }
        double startX = borderLines.get((int)0).x;
        double startY = borderLines.get((int)0).y;
        int lw = borderLines.get(0).getStyle().getWidth();
        builder.line((int)this.lomToPrintPoint(startX), (int)this.lomToPrintPoint(startY), (int)this.lomToPrintPoint(startX + lineWidth), (int)this.lomToPrintPoint(startY), lw);
        borderLines.clear();
        return startX += lineWidth;
    }

    private void line(PWLine pwLine, CpclBuilder builder) {
        Rectangle rectangle = pwLine.getRectangle();
        double x = this.drawX + rectangle.getX();
        double y = this.drawY + rectangle.getY();
        if ("H".equals(pwLine.getDirection())) {
            int w = (int)this.lomToPrintPoint(rectangle.getHeight());
            if (w <= 0) {
                w = 1;
            }
            builder.line((int)this.lomToPrintPoint(x), (int)this.lomToPrintPoint(y + rectangle.getHeight() / 2.0), (int)this.lomToPrintPoint(x + rectangle.getWidth()), (int)this.lomToPrintPoint(y + rectangle.getHeight() / 2.0), w);
            return;
        }
        int w = (int)this.lomToPrintPoint(rectangle.getWidth());
        if (w <= 0) {
            w = 1;
        }
        builder.line((int)this.lomToPrintPoint(x + rectangle.getWidth() / 2.0), (int)this.lomToPrintPoint(y), (int)this.lomToPrintPoint(x + rectangle.getWidth() / 2.0), (int)this.lomToPrintPoint(y + rectangle.getHeight()), w);
    }

    private void imgCmd(PWPicture printWidget, CpclBuilder builder) {
        BufferedImage scaleImage;
        int scaleType;
        double imageHeight;
        double yRate;
        PWPicture picture = printWidget;
        Field field = picture.getOutputValue();
        if (!(field instanceof ImageField) && field instanceof TextField) {
            field = new ImageField((String)((TextField)field).getValue());
        }
        if (!(field instanceof ImageField)) {
            return;
        }
        ImageField outputValue = (ImageField)field;
        String imageKey = (String)outputValue.getValue();
        if (StringUtils.isBlank((CharSequence)imageKey)) {
            return;
        }
        byte[] imageByte = ImageUtil.getImageByUrl((String)imageKey);
        if (imageByte == null) {
            return;
        }
        BufferedImage image = null;
        try {
            image = ImageIO.read(new ByteArrayInputStream(imageByte));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (image == null) {
            return;
        }
        Style style = printWidget.getStyle();
        Rect padding = style.getPadding();
        if (padding == null) {
            padding = new Rect(0, 0, 0, 0);
        }
        Rectangle rectangle = printWidget.getRectangle();
        double width = this.lomToPrintPoint(rectangle.getWidth()) - (double)padding.getLeft() - (double)padding.getRight();
        double height = this.lomToPrintPoint(rectangle.getHeight()) - (double)padding.getTop() - (double)padding.getBottom();
        double imageWidth = (image = CpclUtils.scaleImage(image, image.getWidth() * this.dpi / KDToolkit.getCurrentDpi(), image.getHeight() * this.dpi / KDToolkit.getCurrentDpi())).getWidth();
        double xRate = imageWidth / width;
        double rate = Math.max(xRate, yRate = (imageHeight = (double)image.getHeight()) / height);
        if (rate == xRate) {
            imageWidth = width;
            imageHeight /= rate;
        } else {
            imageWidth /= rate;
            imageHeight = height;
        }
        double move = 0.0;
        if (!style.getBorder(Styles.Position.LEFT).isNull()) {
            int borderWidth = style.getBorderLineStyle(Styles.Position.LEFT).getWidth();
            move = this.lomToPrintPoint(borderWidth) + 1.0;
            imageWidth -= move * 2.0;
            imageHeight -= move * 2.0;
        }
        if (3 == (scaleType = printWidget.getScaleType())) {
            scaleImage = CpclUtils.scaleImage(image, (int)imageWidth, (int)imageHeight);
        } else if (rate <= 1.0) {
            scaleImage = image;
            imageWidth = scaleImage.getWidth();
            imageHeight = scaleImage.getHeight();
        } else {
            scaleImage = image.getSubimage(0, 0, (int)imageWidth, (int)imageHeight);
        }
        double xMove = move / 2.0;
        double yMove = move;
        if (Styles.VerticalAlignment.MIDDLE.equals(style.getVerticalAlign()) && imageHeight < height) {
            yMove = (height - imageHeight) / 2.0;
        }
        if (Styles.VerticalAlignment.BOTTOM.equals(style.getVerticalAlign()) && imageHeight < height) {
            yMove = height - imageHeight - move;
        }
        if (Styles.HorizontalAlignment.CENTER.equals(style.getHorizontalAlign()) && imageWidth < width) {
            xMove = (width - imageWidth) / 2.0;
        }
        if (Styles.HorizontalAlignment.RIGHT.equals(style.getHorizontalAlign()) && imageWidth < width) {
            xMove = width - imageWidth - move / 2.0;
        }
        double x = this.drawX + rectangle.getX();
        double y = this.drawY + rectangle.getY();
        builder.imageEG((int)(this.lomToPrintPoint(x) + (double)Math.round(xMove)), (int)(this.lomToPrintPoint(y) + (double)Math.round(yMove)), scaleImage);
        CpclUtils.drawBorder(builder, style, (int)(this.lomToPrintPoint(x) - (double)padding.getLeft()), (int)(this.lomToPrintPoint(y) - (double)padding.getTop()), this.lomToPrintPoint(rectangle.getHeight()), this.lomToPrintPoint(rectangle.getWidth()));
    }

    private static BufferedImage scaleImage(BufferedImage originalImage, int targetWidth, int targetHeight) {
        Image resultingImage = originalImage.getScaledInstance(targetWidth, targetHeight, 4);
        BufferedImage outputImage = new BufferedImage(targetWidth, targetHeight, 1);
        Graphics2D g2d = outputImage.createGraphics();
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, resultingImage.getWidth(null), resultingImage.getHeight(null));
        g2d.drawImage(resultingImage, 0, 0, null);
        g2d.dispose();
        return outputImage;
    }

    private void barcodeCmd(PWBarcode printWidget, CpclBuilder builder) {
        String type;
        PWBarcode barcode = printWidget;
        BarcodeObject barcodeObject = barcode.getBarcodeObject();
        Field outputValue = barcode.getOutputValue();
        String showValue = null;
        String barcodeType = null;
        if (outputValue instanceof MapField) {
            MapField mapField = (MapField)outputValue;
            Map config = (Map)mapField.getValue();
            barcodeType = String.valueOf(config.get("barcodeType"));
            Object v = config.get("barcode");
            showValue = StringUtils.isBlank(v) ? barcodeObject.getSampleTxt() : String.valueOf(v);
        }
        if (StringUtils.isBlank(showValue)) {
            return;
        }
        Rectangle rectangle = barcode.getRectangle();
        if (barcode.isQRCode()) {
            double xOffset = 0.0;
            double yOffset = 0.0;
            if (rectangle.getWidth() > rectangle.getHeight()) {
                xOffset = (rectangle.getWidth() - rectangle.getHeight()) / 2.0;
            } else {
                yOffset = (rectangle.getHeight() - rectangle.getWidth()) / 2.0;
            }
            int x = (int)this.lomToPrintPoint(this.drawX + rectangle.getX() + xOffset);
            int y = (int)this.lomToPrintPoint(this.drawY + rectangle.getY() + yOffset);
            String errorCorrection = barcodeObject.getErrorCorrection();
            double w = Math.min(rectangle.getWidth(), rectangle.getHeight());
            int u = (int)(this.lomToPrintPoint(w) / 21.0);
            builder.qrCode(errorCorrection, x, y, 1, u, showValue);
            return;
        }
        int w = 2;
        int ratio = 1;
        if (StringUtils.equals((CharSequence)"ean-13", (CharSequence)barcodeType)) {
            type = "EAN13";
        } else if (StringUtils.equals((CharSequence)"code39", (CharSequence)barcodeType)) {
            type = "39";
            ratio = 2;
        } else {
            type = StringUtils.equals((CharSequence)"ean-128", (CharSequence)barcodeType) ? "128" : "128";
        }
        boolean showText = barcodeObject.isShowText();
        double height = rectangle.getHeight() * 0.6;
        int x = (int)this.lomToPrintPoint(this.drawX + rectangle.getX());
        int y = (int)this.lomToPrintPoint(this.drawY + rectangle.getY());
        if (showText) {
            builder.barCodeText(true, 0, 0, 1);
            builder.barCode(true, type, w, ratio, (int)this.lomToPrintPoint(height), x, y, String.valueOf(showValue));
        } else {
            builder.barCodeText(false, 0, 0, 1);
            builder.barCode(true, type, w, ratio, (int)this.lomToPrintPoint(height), x, y, String.valueOf(showValue));
        }
    }

    private void textCmd(PWText text, CpclBuilder builder) {
        Rectangle rectangle = text.getRectangle();
        Style style = text.getStyle();
        int startX = (int)this.lomToPrintPoint(this.drawX + rectangle.getX());
        int startY = (int)this.lomToPrintPoint(this.drawY + rectangle.getY());
        double height = this.lomToPrintPoint(rectangle.getHeight());
        double width = this.lomToPrintPoint(rectangle.getWidth());
        this.drawText(text, builder, startX, startY, height, width);
        if (text instanceof AbstractPWGridCell) {
            return;
        }
        CpclUtils.drawBorder(builder, style, startX, startY, height, width);
    }

    private void drawText(PWText text, CpclBuilder builder, int startX, int startY, double height, double width) {
        block27: {
            List<StringBuilder> textList;
            Styles.VerticalAlignment verticalAlign;
            Styles.HorizontalAlignment horizontalAlign;
            Rect padding;
            FontMetrics fm;
            int fontSize;
            boolean underline;
            block28: {
                int stringWidth;
                Style style;
                String outputText;
                block26: {
                    outputText = text.getOutputText();
                    if (StringUtils.isBlank((CharSequence)outputText)) {
                        return;
                    }
                    style = text.getStyle();
                    underline = style.isUnderline();
                    fontSize = (int)style.getFontSizeF();
                    int boldAndItalic = 0;
                    boldAndItalic += style.isBold() ? 1 : 0;
                    boldAndItalic += style.isItalic() ? 2 : 0;
                    if (this.dpi != KDToolkit.getCurrentDpi()) {
                        fontSize = fontSize * this.dpi / KDToolkit.getCurrentDpi();
                    }
                    Font font = KDFont.loadFontFromJAR((String)style.getFontName(), (int)boldAndItalic, (int)fontSize);
                    fm = Toolkit.getDefaultToolkit().getFontMetrics(font);
                    padding = style.getPadding();
                    if (padding == null) {
                        padding = new Rect(2, 2, 2, 2);
                    }
                    if (!text.isAdjustHeight()) break block26;
                    String[] textLines = outputText.split("\n");
                    int offset = 0;
                    int x = startX + padding.getLeft() + 2;
                    int y = startY + padding.getTop() + 2;
                    for (String value : textLines) {
                        builder.text(0, fontSize, x, y + offset, value);
                        offset += fontSize;
                        if (!underline) continue;
                        builder.line(x, y + offset, x + fm.stringWidth(value), y + offset, 1);
                    }
                    break block27;
                }
                int lineWrapRule = text.getLineWrapRule();
                horizontalAlign = style.getHorizontalAlign();
                verticalAlign = style.getVerticalAlign();
                textList = CpclUtils.getTruncateTextList(fm, outputText, width - (double)padding.getLeft() - (double)padding.getRight() - 4.0);
                if (textList.isEmpty()) {
                    return;
                }
                if (3 != lineWrapRule) break block28;
                String truncateText = textList.get(0).toString();
                if (StringUtils.isBlank((CharSequence)truncateText)) {
                    return;
                }
                double xMove = padding.getLeft() + 2;
                if (horizontalAlign == Styles.HorizontalAlignment.CENTER) {
                    stringWidth = fm.stringWidth(truncateText);
                    if ((double)stringWidth < width) {
                        xMove += (width - (double)stringWidth - (double)padding.getLeft() - (double)padding.getRight() - 4.0) / 2.0;
                    }
                } else if (horizontalAlign == Styles.HorizontalAlignment.RIGHT && (double)(stringWidth = fm.stringWidth(truncateText)) < width) {
                    xMove = width - (double)stringWidth - (double)padding.getRight() - 2.0;
                }
                if (xMove < 0.0) {
                    xMove = padding.getLeft();
                }
                double yMove = padding.getTop() + 2;
                if (verticalAlign == Styles.VerticalAlignment.MIDDLE) {
                    yMove += (height - (double)fm.getHeight() - (double)padding.getBottom() - (double)padding.getTop() - 4.0) / 2.0;
                } else if (verticalAlign == Styles.VerticalAlignment.BOTTOM) {
                    yMove = height - (double)fm.getHeight() - (double)padding.getBottom() - 2.0;
                }
                if (yMove < 0.0) {
                    yMove = padding.getTop();
                }
                int x = (int)((double)startX + xMove);
                int y = (int)((double)startY + yMove);
                builder.text(0, fontSize, x, y, truncateText);
                if (!underline) break block27;
                builder.line(x, y + fontSize, x + fm.stringWidth(truncateText), y + fontSize, 1);
                break block27;
            }
            int maxLen = (int)(height / (double)fm.getHeight());
            if (maxLen > textList.size()) {
                maxLen = textList.size();
            }
            int tempStartY = startY;
            double yMove = padding.getTop() + 2;
            if (verticalAlign == Styles.VerticalAlignment.MIDDLE) {
                yMove += (height - (double)(fm.getHeight() * maxLen) - (double)padding.getBottom() - (double)padding.getTop() - 4.0) / 2.0;
            } else if (verticalAlign == Styles.VerticalAlignment.BOTTOM) {
                yMove = height - (double)(fm.getHeight() * maxLen) - (double)padding.getBottom() - 2.0;
            }
            if (yMove < 0.0) {
                yMove = padding.getTop();
            }
            tempStartY = (int)((double)tempStartY + yMove);
            for (int index = 0; index < maxLen; ++index) {
                int stringWidth;
                String truncateText = textList.get(index).toString();
                double xMove = padding.getLeft() + 2;
                if (horizontalAlign == Styles.HorizontalAlignment.CENTER) {
                    stringWidth = fm.stringWidth(truncateText);
                    if ((double)stringWidth < width) {
                        xMove += (width - (double)stringWidth - (double)padding.getLeft() - (double)padding.getRight() - 4.0) / 2.0;
                    }
                } else if (horizontalAlign == Styles.HorizontalAlignment.RIGHT && (double)(stringWidth = fm.stringWidth(truncateText)) < width) {
                    xMove = width - (double)stringWidth - (double)padding.getRight() - 2.0;
                }
                if (xMove < 0.0) {
                    xMove = padding.getLeft();
                }
                int x = (int)((double)startX + xMove);
                builder.text(0, fontSize, x, tempStartY, truncateText);
                tempStartY += fontSize;
                if (!underline) continue;
                builder.line(x, tempStartY, x + fm.stringWidth(truncateText), tempStartY, 1);
            }
        }
    }

    private static List<StringBuilder> getTruncateTextList(FontMetrics fm, String text, double width) {
        String[] split = text.split("\n");
        if (split.length > 1) {
            ArrayList<StringBuilder> textList = new ArrayList<StringBuilder>(10);
            for (String t : split) {
                textList.addAll(CpclUtils.getTruncateTextList(fm, t, width));
            }
            return textList;
        }
        ArrayList<StringBuilder> textList = new ArrayList<StringBuilder>(10);
        StringBuilder builder = new StringBuilder();
        textList.add(builder);
        int subW = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            int charWidth = fm.charWidth(c);
            if ((double)(subW += charWidth) > width) {
                builder = new StringBuilder();
                textList.add(builder);
                subW = charWidth;
                if ((double)subW > width) {
                    builder = new StringBuilder();
                    textList.add(builder);
                    continue;
                }
                builder.append(c);
                continue;
            }
            builder.append(c);
        }
        return textList;
    }

    private static void drawBorder(CpclBuilder builder, Style style, int x, int y, double height, double width) {
        Border bottomBorder;
        Border topBorder;
        Border rightBorder;
        Border leftBorder = style.getBorder(Styles.Position.LEFT);
        if (!leftBorder.isNull()) {
            LineStyle lineStyle = leftBorder.getLineStyle();
            int lineWidth = lineStyle.getWidth();
            builder.line(x, y, x, (int)((double)y + height), lineWidth);
        }
        if (!(rightBorder = style.getBorder(Styles.Position.RIGHT)).isNull()) {
            LineStyle lineStyle = rightBorder.getLineStyle();
            int lineWidth = lineStyle.getWidth();
            builder.line((int)((double)x + width), y, (int)((double)x + width), (int)((double)y + height), lineWidth);
        }
        if (!(topBorder = style.getBorder(Styles.Position.TOP)).isNull()) {
            LineStyle lineStyle = topBorder.getLineStyle();
            int lineWidth = lineStyle.getWidth();
            builder.line(x, y, (int)((double)x + width), y, lineWidth);
        }
        if (!(bottomBorder = style.getBorder(Styles.Position.BOTTOM)).isNull()) {
            LineStyle lineStyle = bottomBorder.getLineStyle();
            int lineWidth = lineStyle.getWidth();
            builder.line(x, (int)((double)y + height), (int)((double)x + width), (int)((double)y + height), lineWidth);
        }
    }

    private double lomToPrintPoint(double dfLom) {
        return dfLom / (double)254.3f * (double)this.dpi;
    }

    public CpclBuilder getBuilder() {
        return this.builder;
    }

    public void setBuilder(CpclBuilder builder) {
        this.builder = builder;
    }

    public void release() throws IOException {
        this.builder.release();
    }
}

