/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.barcode;

import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.MapField;
import kd.bos.print.core.model.IDatasourceSupport;
import kd.bos.print.core.model.designer.BarcodeObject;
import kd.bos.print.core.model.widget.AbstractPrintWidgetField;
import kd.bos.print.core.model.widget.IAdjustHeightSupport;
import kd.bos.print.core.model.widget.IFxSupport;
import kd.bos.print.core.model.widget.IPrintWidget;

public class PWBarcode
extends AbstractPrintWidgetField
implements IAdjustHeightSupport,
IDatasourceSupport,
IFxSupport {
    private static final String AUTO_MATCH = "autoMatch";
    private static final Log log = LogFactory.getLog(PWBarcode.class);
    private Field _outputValue;
    private boolean _isAdjustHeight;
    private int _maxHeightToAdjust;
    private List<Object> formulaData;
    private BarcodeObject barcodeObject;
    public static final String NUMBERIC_FORMAT = "0000.00";

    public IPrintWidget copy() {
        IPrintWidget widget = super.copy();
        PWBarcode wp = (PWBarcode)widget;
        wp.setBarcodeObject(this.getBarcodeObject());
        return widget;
    }

    public List<Object> getFormulaData() {
        return this.formulaData;
    }

    public void setFormulaData(List<Object> formulaData) {
        this.formulaData = formulaData;
    }

    public String tranNumericToStr(Object value, String format) {
        if (value == null) {
            return "";
        }
        if (format == null || "".equals(format)) {
            format = NUMBERIC_FORMAT;
        }
        String result = "";
        try {
            format = format.replaceAll("\\d", "0");
            int pointBeforeLength = format.length();
            int pointAfterLength = 0;
            if (format.lastIndexOf(46) > -1) {
                int pointIndex = format.lastIndexOf(46);
                pointAfterLength = format.length() - pointIndex - 1;
                pointBeforeLength = format.length() - pointAfterLength - 1;
            }
            if ((result = value.toString().replaceAll(",", "")).lastIndexOf(46) > -1) {
                int point = result.indexOf(46);
                String str1 = result.substring(0, point);
                String str2 = result.substring(point + 1, result.length());
                result = this.subStrByLength(str1, pointBeforeLength, true) + this.subStrByLength(str2, pointAfterLength, false);
            } else {
                result = this.subStrByLength(result, pointBeforeLength, true) + this.subStrByLength("", pointAfterLength, false);
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            return "";
        }
        return result;
    }

    public String subStrByLength(String str, int length, boolean isBefore) {
        while (str.length() < length) {
            if (isBefore) {
                str = "0" + str;
                continue;
            }
            str = str + "0";
        }
        while (str.length() > length) {
            if (isBefore) {
                str = str.substring(1);
                continue;
            }
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public BarcodeObject getBarcodeObject() {
        return this.barcodeObject;
    }

    public void setBarcodeObject(BarcodeObject barcodeObject) {
        this.barcodeObject = barcodeObject;
    }

    public void setOutputValue(Field value) {
        this._outputValue = value;
    }

    public Field getOutputValue() {
        return this._outputValue;
    }

    public void setAdjustHeight(boolean isAdjustHeight) {
        this._isAdjustHeight = isAdjustHeight;
    }

    public boolean isAdjustHeight() {
        return this._isAdjustHeight;
    }

    public void setMaxHeightToAdjust(int maxHeight) {
        this._maxHeightToAdjust = maxHeight;
    }

    public int getMaxHeightToAdjust() {
        return this._maxHeightToAdjust;
    }

    public void setRemainContent(boolean isRemain) {
    }

    public boolean isRemainContent() {
        return false;
    }

    public Object getFieldValue(String field) {
        return this.getFieldValue(this.getDatasource(), field);
    }

    public boolean isQRCode() {
        Field outputValue = this.getOutputValue();
        if (outputValue instanceof MapField) {
            MapField mapField = (MapField)outputValue;
            Map value = (Map)mapField.getValue();
            String type = (String)value.get("barcodeType");
            return "QR_CODE".equals(type);
        }
        return false;
    }

    public static boolean isNotSupportPaint(String type) {
        return "PDF417".equals(type) || "Truncated_PDF417".equals(type) || "MicroPDF417".equals(type) || "Data_Matrix".equals(type) || "GS1_Data_Matrix".equals(type);
    }
}

