/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.runner;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.MapField;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.model.designer.BarcodeObject;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.barcode.PWBarcode;
import kd.bos.print.core.model.widget.runner.AbstractRunner;
import kd.bos.print.core.plugin.PrintPluginProxy;
import kd.bos.print.core.plugin.event.BeforeOutputWidgetEvent;

public class BarcodeRunner
extends AbstractRunner<PWBarcode> {
    private static final String AUTO_MATCH = "autoMatch";

    public void execute(IWidgetExecuteHelper helper) {
        this.helper = helper;
        PrintPluginProxy pluginProxy = ExecuteContext.get().getPluginProxy();
        if (pluginProxy != null) {
            BeforeOutputWidgetEvent evt = new BeforeOutputWidgetEvent(this.getOutputWidget());
            pluginProxy.fireBeforeOutputWidget(evt);
            if (evt.isHidden()) {
                return;
            }
        }
        PWBarcode output = this.run(helper);
        this.cacheOutput((AbstractPrintWidget)output);
        this.endOutput((AbstractPrintWidget)output);
    }

    private PWBarcode run(IWidgetExecuteHelper helper) {
        PWBarcode output = (PWBarcode)this.outputWidget;
        BarcodeObject barcodeObject = output.getBarcodeObject();
        Field outputValue = null;
        Field opValue = output.getOutputValue();
        String ds = ((PWBarcode)this.getOutputWidget()).getDatasource();
        if (opValue != null) {
            outputValue = opValue;
        } else if (StringUtils.isNotBlank((CharSequence)ds)) {
            if (StringUtils.isNotBlank((CharSequence)barcodeObject.getBindField())) {
                String fieldName = barcodeObject.getBindField();
                outputValue = this.getDataHelper(helper, ds).getFieldValue(ds, fieldName);
            }
        } else {
            List<Object> formulaData = ((PWBarcode)this.getOutputWidget()).getFormulaData();
            String text = barcodeObject.getBindField();
            if (StringUtils.isBlank((CharSequence)text)) {
                text = barcodeObject.getSampleTxt();
            }
            outputValue = new TextField(text);
            if (formulaData != null && !formulaData.isEmpty()) {
                outputValue = new TextField(this.getFormulaValue(formulaData, (AbstractPrintWidget)output, this.helper));
            }
        }
        if (outputValue != null && StringUtils.isNotBlank((Object)outputValue.getValue())) {
            boolean isQr;
            String code;
            if (outputValue.isDesensitive()) {
                code = outputValue.toString();
            } else if (outputValue.getValue() instanceof BigDecimal) {
                code = ((BigDecimal)outputValue.getValue()).toPlainString();
            } else {
                if (outputValue instanceof MapField) {
                    return output;
                }
                code = outputValue.getValue().toString();
            }
            String prefix = barcodeObject.getPrefix();
            String suffix = barcodeObject.getSuffix();
            if (StringUtils.isNotBlank((CharSequence)prefix)) {
                code = prefix + code;
            }
            if (StringUtils.isNotBlank((CharSequence)suffix)) {
                code = code + suffix;
            }
            boolean bl = isQr = "QR_CODE".equalsIgnoreCase(barcodeObject.getBarcodeType()) || "DATA_MATRIX".equalsIgnoreCase(barcodeObject.getBarcodeType()) || "PDF_417".equalsIgnoreCase(barcodeObject.getBarcodeType());
            if (isQr && this.containsNonAsciiChar(code)) {
                code = code + "\n";
            }
            Map<String, Object> config = this.generateConfig(barcodeObject, code);
            outputValue = new MapField(config);
        }
        output.setOutputValue(outputValue);
        return output;
    }

    private boolean containsNonAsciiChar(String code) {
        for (int i = 0; i < code.length(); ++i) {
            char c = code.charAt(i);
            if (c <= '\u0080') continue;
            return true;
        }
        return false;
    }

    private Map<String, Object> generateConfig(BarcodeObject barcodeObject, String code) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("barcode", code);
        double height = (double)barcodeObject.getHeight() * 0.1;
        double width = (double)barcodeObject.getWidth() * 0.1;
        config.put("height", height);
        config.put("width", width);
        config.put("dpi", barcodeObject.getDpi());
        config.put("modelWidth", barcodeObject.getModelWidth());
        config.put("shape", barcodeObject.getShape());
        if (barcodeObject.getScale() == 3) {
            config.put(AUTO_MATCH, true);
        } else {
            config.put(AUTO_MATCH, false);
        }
        config.put("barcodeType", barcodeObject.getBarcodeType());
        config.put("showText", barcodeObject.isShowText());
        config.put("errorCorrectionLevel", barcodeObject.getErrorCorrection());
        config.put("rotate", barcodeObject.getRotate());
        config.put("dmSize", barcodeObject.getDmSize());
        return config;
    }
}

