/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.runner;

import java.awt.Color;
import java.awt.Rectangle;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import kd.bos.entity.format.NumberFormatObject;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ctrl.common.digitalstyle.FormatResult;
import kd.bos.print.core.ctrl.common.digitalstyle.Formats;
import kd.bos.print.core.ctrl.common.util.StringUtil;
import kd.bos.print.core.ctrl.common.variant.Variant;
import kd.bos.print.core.ctrl.kdf.util.style.ShareStyleAttributes;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.StyleAttributes;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.ctrl.reportone.r1.print.common.currency.CurrencyFormatManager;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.DelayVarProvider;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import kd.bos.print.core.data.field.DecimalField;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.NullField;
import kd.bos.print.core.data.field.NumberField;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.execute.render.common.linewrap.param.LineWrapParam;
import kd.bos.print.core.model.CurrencyFormat;
import kd.bos.print.core.model.UppercaseType;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.PWText;
import kd.bos.print.core.model.widget.PrintAtPage;
import kd.bos.print.core.model.widget.StyleAccess;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueField;
import kd.bos.print.core.model.widget.runner.AbstractTextRunner;
import kd.bos.print.core.model.widget.runner.grid.AbstractGridRunner;
import kd.bos.print.core.model.widget.runner.util.AdjustHeightUtil;
import kd.bos.print.core.plugin.PrintPluginProxy;
import kd.bos.print.core.plugin.event.BeforeOutputTextEvent;
import kd.bos.print.core.plugin.event.BeforeOutputWidgetEvent;
import kd.bos.print.core.service.I18nService;
import kd.bos.util.StringUtils;

public class TextRunner
extends AbstractTextRunner<PWText> {
    private static final String THOUSAND_SPLIT = ",";
    private static final String JIAO = "\u89d2";
    private static final String ZHENG = "\u6574";

    /*
     * Enabled aggressive block sorting
     */
    public void execute(IWidgetExecuteHelper helper) {
        this.helper = helper;
        helper.markOutputId((IPrintWidget)this.getOutputWidget());
        PWText output = (PWText)this.getOutputWidget();
        PrintPluginProxy pluginProxy = ExecuteContext.get().getPluginProxy();
        boolean isNeedFormat = true;
        if (pluginProxy != null) {
            BeforeOutputTextEvent evt = new BeforeOutputTextEvent(output);
            pluginProxy.fireBeforeOutputWidget((BeforeOutputWidgetEvent)evt);
            if (evt.isHidden()) {
                return;
            }
            isNeedFormat = evt.isNeedFormat();
            output.setNeedFormat(isNeedFormat);
        }
        Field outputValue = null;
        boolean isStatic = StringUtil.isEmptyString((String)((PWText)this.getOutputWidget()).getDatasource());
        List formulaData = ((PWText)this.getOutputWidget()).getFormulaData();
        Field opValue = output.getOutputValue();
        if (opValue != null) {
            outputValue = opValue;
        } else if (isStatic) {
            outputValue = new TextField(output.getBindField());
            if (formulaData != null && !formulaData.isEmpty()) {
                outputValue = new TextField(this.getFormulaValue(formulaData, (AbstractPrintWidget)output, this.helper));
            }
        } else {
            String ds = output.getDatasource();
            if (StringUtil.equals((String)ds, (String)"$DsKey=[System]")) {
                if (output.getPrintAtPage() == PrintAtPage.All) {
                    this.cacheOutput((AbstractPrintWidget)output);
                    this.endOutput((AbstractPrintWidget)output);
                    return;
                }
                Object formulaResult = this.runFormula(helper, (IPrintWidget)output, output.getBindField());
                outputValue = new TextField(formulaResult == null ? "" : formulaResult.toString());
            } else {
                outputValue = this.getDataHelper(helper, ds).getFieldValue(ds, output.getBindField());
            }
        }
        output.setLinkUrl(this.queryAnchorLink(helper));
        if (!DelayVarProvider.isVar((String)String.valueOf(outputValue.getValue())) && isNeedFormat) {
            outputValue = this.formatOutputValue(outputValue);
        }
        if (output.isAdjustHeight()) {
            this.outputAdjustWidget(output, outputValue.toString());
            return;
        }
        output.setOutputText(outputValue.toString());
        this.cacheOutput((AbstractPrintWidget)output);
        this.endOutput((AbstractPrintWidget)output);
    }

    public String queryAnchorLink(IWidgetExecuteHelper helper) {
        Field linkField;
        PWText output = (PWText)this.getOutputWidget();
        if (helper == null || !output.isAnchor()) {
            return null;
        }
        if (StringUtils.isNotEmpty((String)output.getLinkDs()) && (linkField = this.getDataHelper(helper, output.getLinkDs()).getFieldValue(output.getLinkDs(), output.getLinkFiled())) != null) {
            return linkField.toString();
        }
        return output.getLinkUrl();
    }

    public String queryAnchorLink(AbstractGridRunner.GridDataVisitor visitor) {
        Field linkField;
        PWText output = (PWText)this.getOutputWidget();
        if (!output.isAnchor()) {
            return null;
        }
        if (visitor != null && StringUtils.isNotEmpty((String)output.getLinkDs()) && (linkField = visitor.getFieldVal(output.getLinkDs(), new CellValueField(output.getLinkFiled()))) != null) {
            return linkField.toString();
        }
        return output.getLinkUrl();
    }

    public Field formatOutputValue(Field outputValue) {
        String format;
        if (outputValue.showDisplayVal() && (outputValue.isDesensitive() || StringUtils.isBlank((String)outputValue.getDisplayVal()))) {
            return outputValue;
        }
        PWText outputWidget = (PWText)this.getOutputWidget();
        String textFormat = outputWidget.getTextFormat();
        if ((outputValue = super.formatOutputValue(outputValue)) instanceof NullField) {
            return outputValue;
        }
        if (outputValue instanceof NumberField || this.isNumeric(String.valueOf(outputValue.getValue()))) {
            if ("Number".equalsIgnoreCase(textFormat) && StringUtils.isNotEmpty((String)outputValue.toString())) {
                outputValue = this.formatNumber(outputValue, outputWidget);
            } else if ("Amount".equalsIgnoreCase(textFormat)) {
                outputValue = this.fortmatAmount(outputValue, outputWidget);
            }
        } else if (("Date".equals(textFormat) || "Time".equals(textFormat)) && !StringUtil.equals((String)(format = this.getFormat(outputWidget.getFormat(), outputValue)), (String)"-") && StringUtils.isNotEmpty((String)format)) {
            Variant variant = new Variant(outputValue.getValue());
            variant.setTimeZone(outputValue.getTimeZone());
            FormatResult result = Formats.getFormat((String)format).format(variant);
            outputValue = new TextField(result.toString());
        }
        return outputValue;
    }

    private Field formatNumber(Field outputValue, PWText outputWidget) {
        String nativeFormat;
        int c;
        BigDecimal bigDecimal = this.toBigDecimal(outputValue.getValue());
        if ((outputWidget.isIgnoreZero() || outputValue instanceof NumberField && !((NumberField)outputValue).isShowZero()) && (c = bigDecimal.compareTo(BigDecimal.ZERO)) == 0) {
            return NullField.get();
        }
        if (outputWidget.isShowPercentage()) {
            bigDecimal = bigDecimal.multiply(BigDecimal.valueOf(100L));
        }
        if (StringUtils.isBlank((String)(nativeFormat = outputWidget.getNegativeType()))) {
            nativeFormat = "-";
        }
        this.showRedNative(outputWidget, bigDecimal);
        char decimalPoint = '.';
        char numSeparator = ',';
        String numGroupFormat = "###,###";
        int scale = outputWidget.getPrecision();
        if (scale == -1 && outputValue instanceof DecimalField) {
            DecimalField decimalField = (DecimalField)outputValue;
            scale = decimalField.getScale();
        }
        NumberFormatObject numberformatObj = new NumberFormatObject(decimalPoint, numSeparator, "", numGroupFormat, nativeFormat);
        numberformatObj.setGroupingUsed(outputWidget.isThousandSplit());
        String str = this.formatNumber(bigDecimal, numberformatObj, outputWidget.isIgnoreTailZero(), scale);
        if ("+".equals(nativeFormat)) {
            str = str.replace("+", "");
        }
        outputValue = outputWidget.isShowPercentage() ? new TextField(str + "%") : new TextField(str);
        return outputValue;
    }

    private void showRedNative(PWText outputWidget, BigDecimal bigDecimal) {
        if (bigDecimal.doubleValue() >= 0.0 || !outputWidget.isShowRedNegative()) {
            return;
        }
        Style style = outputWidget.getStyle();
        StyleAttributes newAttribute = style.getNewAttribute();
        newAttribute.setFontColor(Color.RED);
        outputWidget.setStyle(Styles.getStyle((ShareStyleAttributes)newAttribute));
    }

    private Field fortmatAmount(Field outputValue, PWText outputWidget) {
        String fieldValue;
        Field formatField;
        StringBuilder outputText = new StringBuilder();
        outputWidget.setShowPercentage(Boolean.FALSE.booleanValue());
        CurrencyFormat currencyFormat = outputWidget.getCurrencyFormat();
        String uppercaseType = outputWidget.getUppercaseType();
        boolean isUppercase = currencyFormat.isUppercase();
        boolean showCurrency = currencyFormat.isShowCurrency();
        boolean showCurrencySymbol = currencyFormat.isShowCurrencySymbol();
        boolean showCurrencyCode = currencyFormat.isShowCurrencyCode();
        CurrencyFormatManager formater = CurrencyFormatManager.shareInstance();
        String currencyCode = currencyFormat.getCurrencyCode();
        boolean isFormCurrency = "FROM_CURRENCY".equals(currencyCode);
        if (isFormCurrency && outputValue instanceof DecimalField) {
            DecimalField decimalField = (DecimalField)outputValue;
            currencyCode = decimalField.getCode();
        }
        if (StringUtils.isEmpty((String)currencyCode)) {
            showCurrency = false;
        }
        if ((formatField = this.formatNumber(outputValue, outputWidget)) instanceof NullField) {
            return formatField;
        }
        UppercaseType uppercaseTypeEnum = UppercaseType.getUppercaseType(uppercaseType);
        if (isUppercase && StringUtils.isNotEmpty((String)(fieldValue = formatField.toString()))) {
            fieldValue = this.splitAmount(fieldValue);
            if (UppercaseType.ZH_UPPER == uppercaseTypeEnum) {
                if (StringUtils.isEmpty((String)currencyCode)) {
                    Locale locale = Locale.forLanguageTag(ExecuteContext.get().getLang());
                    Locale localeLang = Locale.SIMPLIFIED_CHINESE;
                    if (locale != null) {
                        localeLang = locale;
                    }
                    outputText.append(formater.upperFomat(null, localeLang, new Variant((Object)formatField.toString()), showCurrency));
                } else {
                    outputText.append(this.amountUpperProcess(showCurrency, fieldValue, UppercaseType.ZH_UPPER, currencyCode));
                }
            } else if (UppercaseType.NO_UPPER != uppercaseTypeEnum) {
                outputText.append(this.amountUpperProcess(showCurrencySymbol, fieldValue, uppercaseTypeEnum, currencyCode));
            }
        } else {
            String currencySymbol = "";
            outputText.append(formatField.toString());
            if (showCurrencySymbol) {
                if (isFormCurrency && outputValue instanceof DecimalField) {
                    DecimalField decimalField = (DecimalField)outputValue;
                    currencySymbol = decimalField.getSymbol();
                } else {
                    currencySymbol = formater.getSymbol(currencyCode);
                }
                if (StringUtils.isNotEmpty((String)currencySymbol)) {
                    outputText.insert(0, currencySymbol);
                }
            }
            if (showCurrencyCode && StringUtils.isNotEmpty((String)currencyCode)) {
                outputText.insert(0, currencyCode);
            }
        }
        boolean jiaoZheng = outputWidget.isJiaoZheng();
        if (jiaoZheng && outputText.length() > 0 && outputText.lastIndexOf(JIAO) == outputText.length() - 1) {
            outputText.append(ZHENG);
        }
        return new TextField(outputText.toString());
    }

    private String amountUpperProcess(boolean showCurrency, String fieldValue, UppercaseType defaultUppercase, String currencyCode) {
        if (StringUtils.isEmpty((String)currencyCode)) {
            return fieldValue;
        }
        I18nService i18nService = ExecuteContext.get().getServiceProxy().getI18nService();
        String upperAmount = fieldValue;
        if (UppercaseType.ZH_UPPER == defaultUppercase) {
            upperAmount = i18nService.amountConvertZhUppercase(showCurrency, currencyCode, currencyCode, fieldValue);
        } else if (UppercaseType.NO_UPPER != defaultUppercase) {
            upperAmount = i18nService.amountConvertUppercase(defaultUppercase.getLang(), showCurrency, currencyCode, fieldValue);
        }
        return upperAmount;
    }

    private String splitAmount(String fieldValue) {
        if (fieldValue.contains(THOUSAND_SPLIT)) {
            fieldValue = fieldValue.replaceAll(THOUSAND_SPLIT, "");
        }
        return fieldValue;
    }

    private void outputAdjustWidget(PWText output, String text) {
        Rectangle rectangle = output.getRectangle();
        int height = (int)rectangle.getHeight();
        int width = (int)rectangle.getWidth();
        int maxHeight = output.getMaxHeightToAdjust();
        text = text == null ? "" : text;
        Style style = StyleAccess.getStyle((IPrintWidget)output);
        AdjustHeightUtil.AdjustInfo adjustInfo = AdjustHeightUtil.getInstance().adjustHeight(new LineWrapParam.Builder(text, output.getLineWrapRule()).style(style).wordFlex(output.isWordFlex()).minW(width).maxW(this.getRelativeContext().getEmptyPage().getRectangle().width).minH(height).maxH(maxHeight).build());
        output.setFlexOffset(adjustInfo.getFlexOffset());
        output.setTextHeight((float)adjustInfo.getTextHeight());
        String textRemain = adjustInfo.getRemainText();
        if (DelayVarProvider.isBindDelayVar((IPrintWidget)output)) {
            output.setOutputText(text);
            textRemain = null;
        } else {
            output.setOutputText(adjustInfo.getUsedText());
        }
        output.setRemainContent(textRemain != null);
        int usedHeight = adjustInfo.getUsedHeight();
        output.getRectangle().setRect(rectangle.getX(), rectangle.getY(), width, usedHeight);
        this.cacheOutput((AbstractPrintWidget)output);
        if (textRemain != null && output.getPrintAtPage() == PrintAtPage.Nature) {
            output = (PWText)output.copy();
            int startY = this.getHeaderHeight();
            int relativeY = this.getRelativeContext().scanYFromEveryPagePool((AbstractPrintWidget)output);
            if (relativeY != -1) {
                startY = relativeY;
            }
            output.getRectangle().setRect(rectangle.getX(), startY, width, 0.0);
            output.setPageIndex(output.getPageIndex() + 1);
            output.setMaxHeightToAdjust(this.getRelativeContext().getEmptyPage().getRectangle().height - this.getFooterHeight() - startY);
            this.outputAdjustWidget(output, textRemain);
        } else {
            this.endOutput((AbstractPrintWidget)output);
        }
    }
}

