/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.runner.grid;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.param.CustomParam;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ctrl.common.digitalstyle.FormatResult;
import kd.bos.print.core.ctrl.common.digitalstyle.Formats;
import kd.bos.print.core.ctrl.common.util.StringUtil;
import kd.bos.print.core.ctrl.common.variant.Variant;
import kd.bos.print.core.ctrl.kdf.util.style.Border;
import kd.bos.print.core.ctrl.kdf.util.style.LineStyle;
import kd.bos.print.core.ctrl.kdf.util.style.Rect;
import kd.bos.print.core.ctrl.kdf.util.style.ShareStyleAttributes;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.StyleAttributes;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.ctrl.reportone.r1.print.common.IR1PrintScriptable;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.DelayVarProvider;
import kd.bos.print.core.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import kd.bos.print.core.data.PdIterator;
import kd.bos.print.core.data.field.CollectionField;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.ImageField;
import kd.bos.print.core.data.field.NullField;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.exception.PrintException;
import kd.bos.print.core.execute.render.common.linewrap.param.LineWrapParam;
import kd.bos.print.core.model.designer.BarcodeObject;
import kd.bos.print.core.model.designer.grid.MergeBlock;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.AbstractPrintWidgetField;
import kd.bos.print.core.model.widget.IAdjustHeightSupport;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.IPrintWidgetContainer;
import kd.bos.print.core.model.widget.PWPicture;
import kd.bos.print.core.model.widget.PWText;
import kd.bos.print.core.model.widget.PWidgetUtil;
import kd.bos.print.core.model.widget.PrintAtPage;
import kd.bos.print.core.model.widget.StyleAccess;
import kd.bos.print.core.model.widget.barcode.PWBarcode;
import kd.bos.print.core.model.widget.grid.AbstractPWGrid;
import kd.bos.print.core.model.widget.grid.AbstractPWGridCell;
import kd.bos.print.core.model.widget.grid.AbstractPWGridRow;
import kd.bos.print.core.model.widget.grid.MergeType;
import kd.bos.print.core.model.widget.grid.datagrid.AbstractPWDataGridRow;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGrid;
import kd.bos.print.core.model.widget.grid.datagrid.PWDetailRow;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.ACellValue;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueField;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueStat;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueText;
import kd.bos.print.core.model.widget.grid.datagrid.context.GridExecuteContext;
import kd.bos.print.core.model.widget.grid.tabletail.ITableTailSupport;
import kd.bos.print.core.model.widget.grid.tabletail.PWTableTail;
import kd.bos.print.core.model.widget.runner.AbstractRunner;
import kd.bos.print.core.model.widget.runner.IRunner;
import kd.bos.print.core.model.widget.runner.IWholeRowPaginationSupport;
import kd.bos.print.core.model.widget.runner.RelativeContext;
import kd.bos.print.core.model.widget.runner.TextRunner;
import kd.bos.print.core.model.widget.runner.grid.AbstractGridRunner;
import kd.bos.print.core.model.widget.runner.grid.CardGridRunner;
import kd.bos.print.core.model.widget.runner.grid.DataGridRunner;
import kd.bos.print.core.model.widget.runner.grid.subGrid.HSubGridRunner;
import kd.bos.print.core.model.widget.runner.grid.subGrid.VSubGridRunner;
import kd.bos.print.core.model.widget.runner.support.DefaultWholeRowPageRunner;
import kd.bos.print.core.model.widget.runner.support.IWholeRowPageRunner;
import kd.bos.print.core.model.widget.runner.support.NotSupportWholeRowPageRunner;
import kd.bos.print.core.model.widget.runner.util.AdjustHeightUtil;
import kd.bos.print.core.model.widget.runner.util.MergeUtils;
import kd.bos.print.core.model.widget.runner.util.SubGridUtils;
import kd.bos.print.core.plugin.PrintPluginProxy;
import kd.bos.print.core.plugin.event.AfterOutputGridEvent;
import kd.bos.print.core.plugin.event.AfterOutputRowEvent;
import kd.bos.print.core.plugin.event.AfterOutputWidgetEvent;
import kd.bos.print.core.plugin.event.BeforeOutputGridEvent;
import kd.bos.print.core.plugin.event.BeforeOutputRowEvent;
import kd.bos.print.core.plugin.event.BeforeOutputWidgetEvent;
import kd.bos.print.core.service.IFormulaService;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public abstract class AbstractGridRunner<T extends AbstractPWGrid>
extends AbstractRunner<T>
implements IWholeRowPaginationSupport {
    private int titleRowOut;
    private static final int MAX_TITLE_ROW_OUT = 50;
    protected static final int MIN_ROW_HEIGHT = RelativeContext.getTextQuarkHeight();
    protected int detailRowNumber = 1;
    protected int detailGroupRowNumber = 1;
    protected int groupRowCursor = -1;
    private IWholeRowPageRunner wholeRowPageRunner;
    private boolean repairRowIndex = AbstractGridRunner.isRepairRowIndex();

    public void execute(IWidgetExecuteHelper helper) {
        this.wholeRowPageRunner = this.createWholeRowPageRunner();
        this.helper = helper;
        PrintPluginProxy pluginProxy = ExecuteContext.get().getPluginProxy();
        if (pluginProxy != null) {
            BeforeOutputGridEvent evt = new BeforeOutputGridEvent((AbstractPWGrid)this.getOutputWidget());
            pluginProxy.fireBeforeOutputWidget((BeforeOutputWidgetEvent)evt);
        }
    }

    protected void executeTitleRow(T outputGrid, AbstractPWGridRow row) {
        PrintPluginProxy pluginProxy = ExecuteContext.get().getPluginProxy();
        if (pluginProxy != null) {
            BeforeOutputRowEvent evt = new BeforeOutputRowEvent(row, this.helper.getDataHelper());
            evt.setGrid(outputGrid);
            pluginProxy.fireBeforeOutputRow(evt);
            if (evt.isCancleOutput()) {
                return;
            }
        }
        int preRowCursor = ((AbstractPWGrid)((Object)outputGrid)).getRowCursor();
        if (this.repairRowIndex) {
            ((AbstractPWGrid)((Object)outputGrid)).setRowCursor(row.getRowIndex());
        }
        this.executeRow(outputGrid, row, this.getTitleRowGridDataVisitor());
        if (row.isRemainContent()) {
            this.executeTitleRow(outputGrid, row);
        }
        if (this.repairRowIndex) {
            ((AbstractPWGrid)((Object)outputGrid)).setRowCursor(preRowCursor);
        }
    }

    private static boolean isRepairRowIndex() {
        CustomParam param = new CustomParam();
        param.getSearchKeySet().add("repairRowIndex");
        Map customParam = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)param);
        String changeRowIndex = (String)customParam.get("repairRowIndex");
        return !"false".equals(changeRowIndex);
    }

    protected GridDataVisitor getTitleRowGridDataVisitor() {
        return (ds, field) -> {
            if (field == null) {
                return NullField.get();
            }
            Field fieldValue = this.helper.getDataHelper().getFieldValue(ds, field.getField());
            return fieldValue;
        };
    }

    protected void beforeExecuteRow(T outputGrid) {
        if (!this.needPagination((AbstractPWGrid)((Object)outputGrid)) && !this.needWholePagination(outputGrid)) {
            return;
        }
        this.executePagination(outputGrid);
    }

    protected void executeRow(T outputGrid, AbstractPWGridRow row, GridDataVisitor visitor) {
        this.beforeExecuteRow(outputGrid);
        this.resetRowPaginationFlag(outputGrid, row);
        if (!this.isAdjuestHeightRow(row)) {
            row.setAdjustHeight(false);
        }
        int columnCursor = 0;
        int columnCount = outputGrid.getColumnCount();
        int maxHeightToAdjust = outputGrid.getContext().getMaxHeightToAdjust();
        AbstractPWGridRow outputRow = (AbstractPWGridRow)row.copy();
        outputRow.setMaxHeightToAdjust(maxHeightToAdjust);
        boolean remainContent = row.isRemainContent();
        if (remainContent) {
            int remainHeight = row.getReaminHeight();
            if (row.getHeight() < MIN_ROW_HEIGHT && remainHeight < row.getHeight()) {
                remainHeight = row.getHeight();
            }
            if (remainHeight < MIN_ROW_HEIGHT && row.getHeight() > MIN_ROW_HEIGHT) {
                remainHeight = MIN_ROW_HEIGHT;
            }
            if (remainHeight != 0) {
                outputRow.setHeight(remainHeight);
            }
            row.setRemainContent(false);
            row.setReaminHeight(0);
        }
        int realHeight = this.designRowHeightAdjust(row, outputRow.getHeight(), maxHeightToAdjust);
        int newPageAdjustHeight = 0;
        if (outputGrid.isWholeRowPage()) {
            newPageAdjustHeight = this.getNewPageAdjustHeight(outputGrid);
        }
        int realMaxRowHeight = 0;
        boolean isBlankRow = true;
        while (columnCursor < columnCount) {
            MergeBlock mergeBlock;
            Object column = outputGrid.getColumn(columnCursor);
            int columnWidth = column.getWidth();
            AbstractPWGridCell cell = row.getCell(columnCursor);
            AbstractPWGridCell outputCell = (AbstractPWGridCell)cell.copy();
            if (remainContent) {
                outputCell.getChildren().clear();
            }
            String outputText = "";
            String dataSource = outputCell.getDatasource();
            List children = outputCell.getChildren();
            if (children != null && children.size() > 0 && !this.isExecuteBlankRow()) {
                outputCell.setRectangle(new Rectangle(columnWidth, realHeight));
                outputCell.setAdjustHeight(outputRow.isAdjustHeight());
                outputCell.setMaxHeightToAdjust(maxHeightToAdjust);
                this.executeChildren((IPrintWidgetContainer)outputCell, children);
                if (this.isOpenWholeRowPage() && outputGrid.getContext().isRowPagination()) {
                    return;
                }
                realHeight = outputCell.getRectangle().height;
            } else {
                Dimension mergeInfo;
                int width;
                ACellValue cellValue = outputCell.getCellValue();
                if (remainContent) {
                    int remainHeight = row.getReaminHeight();
                    outputText = cell.getOutputText();
                    if (remainHeight != 0) {
                        outputRow.setHeight(remainHeight);
                    }
                } else if (StringUtils.isBlank((CharSequence)dataSource)) {
                    if (this.isExecuteBlankRow()) {
                        outputText = "";
                    } else if (cellValue instanceof CellValueText) {
                        outputText = ((CellValueText)cellValue).getValue();
                        TextField outputValue = null;
                        List formulaData = outputCell.getFormulaData();
                        TextRunner runner = (TextRunner)outputCell.getRunner();
                        outputValue = formulaData != null && !formulaData.isEmpty() ? (row instanceof PWDetailRow || this instanceof CardGridRunner ? new TextField(this.getFormulaValue(formulaData, (AbstractPrintWidget)outputGrid, (AbstractPrintWidget)outputCell, this.helper, visitor)) : new TextField(runner.getFormulaValue(formulaData, (AbstractPrintWidget)outputGrid, this.helper))) : new TextField(outputText);
                        if (outputValue != null) {
                            outputCell.setOriOutPutText(outputValue.toString());
                            outputValue = runner.formatOutputValue((Field)outputValue);
                            outputText = outputValue.toString();
                        }
                    }
                } else if (StringUtil.equals((String)dataSource, (String)"$DsKey=[System]")) {
                    if (outputGrid.getPrintAtPage() != PrintAtPage.All) {
                        if (StringUtil.equals((String)outputCell.getBindField(), (String)"=getRowNumber()")) {
                            if (outputRow instanceof PWDetailRow) {
                                TextField outputValue = new TextField(String.valueOf(this.detailRowNumber));
                                outputText = outputValue.toString();
                            } else {
                                outputText = "1";
                            }
                        } else if ("=getGroupRowNumber()".equals(outputCell.getBindField())) {
                            if (outputRow instanceof PWDetailRow) {
                                TextField outputValue = new TextField(String.valueOf(this.detailGroupRowNumber));
                                outputText = outputValue.toString();
                            } else {
                                outputText = "1";
                            }
                        } else {
                            String format;
                            outputCell.setPageIndex(outputGrid.getPageIndex());
                            Object formulaResult = this.runFormula(this.helper, (IPrintWidget)outputCell, outputCell.getBindField());
                            TextField outputValue = new TextField(formulaResult == null ? "" : formulaResult.toString());
                            outputText = outputValue.toString();
                            if (("Date".equals(outputCell.getTextFormat()) || "Time".equals(outputCell.getTextFormat())) && !StringUtil.equals((String)this.getFormat(outputCell.getFormat(), (Field)outputValue), (String)"-") && !StringUtil.equals((String)(format = this.getFormat(outputCell.getFormat(), (Field)outputValue)), (String)"-")) {
                                FormatResult result = Formats.getFormat((String)format).format(new Variant(outputValue.getValue()));
                                outputValue = new TextField(result.toString());
                                outputText = outputValue.toString();
                            }
                        }
                        outputCell.setOriOutPutText(outputText);
                    }
                } else if (cellValue instanceof CellValueStat) {
                    CellValueStat statField = (CellValueStat)cellValue;
                    Field outputValue = visitor.getFieldVal(dataSource, (CellValueField)statField);
                    if (outputValue instanceof ImageField) {
                        boolean hasImage = this.showImageField(outputCell, (ImageField)outputValue, realHeight, columnWidth);
                        if (hasImage) {
                            isBlankRow = false;
                        }
                        outputText = "";
                    } else {
                        TextRunner runner = (TextRunner)outputCell.getRunner();
                        outputValue = runner.formatOutputValue(outputValue);
                        outputText = outputValue.toString();
                    }
                } else if (cellValue instanceof CellValueField) {
                    CellValueField cellField = (CellValueField)cellValue;
                    Field outputValue = visitor.getFieldVal(dataSource, cellField);
                    if (outputValue instanceof ImageField) {
                        boolean hasImage = this.showImageField(outputCell, (ImageField)outputValue, realHeight, columnWidth);
                        if (hasImage) {
                            isBlankRow = false;
                        }
                        outputText = "";
                    } else if (outputValue != null) {
                        outputCell.setOriOutPutText(outputValue.toString());
                        TextRunner runner = (TextRunner)outputCell.getRunner();
                        outputValue = runner.formatOutputValue(outputValue);
                        outputText = outputValue.toString();
                    } else {
                        outputText = "";
                    }
                }
                if (outputCell.isAnchor()) {
                    outputCell.setLinkUrl(((TextRunner)outputCell.getRunner()).queryAnchorLink(visitor));
                }
                if (row.isRemainContent()) {
                    width = columnWidth;
                    int height = realHeight;
                    if (cell.getMergeType() == MergeType.Merged) {
                        MergeBlock mergeBlock2 = cell.getMergeBlock();
                        mergeInfo = this.getMergeInfo(mergeBlock2, (AbstractPWGrid)outputGrid);
                        width = mergeInfo.width;
                        if (mergeInfo.height > height) {
                            height = mergeInfo.height;
                        }
                    }
                    if (!DelayVarProvider.isBindDelayVar((IPrintWidget)outputCell)) {
                        AdjustHeightUtil.AdjustInfo adjustInfo = AdjustHeightUtil.getInstance().adjustHeight(new LineWrapParam.Builder(outputText, cell.getLineWrapRule()).style(StyleAccess.getStyle((IPrintWidget)outputCell)).wordFlex(outputCell.isWordFlex()).minW(width).maxW(this.getRelativeContext().getEmptyPage().getRectangle().width).minH(height).maxH(maxHeightToAdjust).offsetY(0).build());
                        outputText = adjustInfo.getUsedText();
                        outputCell.setFlexOffset(adjustInfo.getFlexOffset());
                        outputCell.setTextHeight((float)adjustInfo.getTextHeight());
                        cell.setOutputText(adjustInfo.getRemainText());
                        if (adjustInfo.getUsedHeight() > realHeight) {
                            realHeight = adjustInfo.getUsedHeight();
                        }
                    }
                    outputCell.setAdjustHeight(true);
                    if (this.isRowDesignPagination(row, maxHeightToAdjust)) {
                        outputGrid.getContext().setMaxHeightToAdjust(0);
                        outputGrid.getContext().setRowPagination(true);
                        outputGrid.getContext().setRowType(row.getRowType());
                        row.setRemainContent(false);
                        this.beforeExecuteRow(outputGrid);
                        return;
                    }
                } else if (this.isAdjuestHeightRow(outputRow) && cell.getDivideCharNums() <= 0) {
                    width = columnWidth;
                    int height = realHeight;
                    if (cell.getMergeType() == MergeType.Merged) {
                        MergeBlock mergeBlock3 = cell.getMergeBlock();
                        mergeInfo = this.getMergeInfo(mergeBlock3, (AbstractPWGrid)outputGrid);
                        width = mergeInfo.width;
                        if (mergeInfo.height > height) {
                            height = mergeInfo.height;
                        }
                    }
                    LineWrapParam param = new LineWrapParam.Builder(outputText, cell.getLineWrapRule()).style(StyleAccess.getStyle((IPrintWidget)outputCell)).wordFlex(outputCell.isWordFlex()).minW(width).maxW(this.getRelativeContext().getEmptyPage().getRectangle().width).minH(remainContent ? row.getHeight() : height).maxH(maxHeightToAdjust).build();
                    AdjustHeightUtil.AdjustInfo adjustInfo = AdjustHeightUtil.getInstance().adjustHeight(param);
                    int usedHeight = adjustInfo.getUsedHeight();
                    if (this.isRowRuntimePagination(adjustInfo, newPageAdjustHeight, row)) {
                        outputGrid.getContext().setMaxHeightToAdjust(0);
                        outputGrid.getContext().setRowPagination(true);
                        outputGrid.getContext().setRowType(row.getRowType());
                        this.beforeExecuteRow(outputGrid);
                        return;
                    }
                    if (usedHeight > height) {
                        int addHeight = usedHeight - height;
                        realHeight = cell.getMergeType() == MergeType.Merged && realHeight < row.getHeight() ? row.getHeight() + addHeight : (realHeight += addHeight);
                    }
                    outputCell.setAdjustHeight(true);
                    outputCell.setFlexOffset(adjustInfo.getFlexOffset());
                    outputCell.setTextHeight((float)adjustInfo.getTextHeight());
                    cell.setAdjustHeight(true);
                    if (this.rowOverPage()) {
                        String remainText = adjustInfo.getRemainText();
                        if (DelayVarProvider.isBindDelayVar((IPrintWidget)outputCell)) {
                            remainText = null;
                        } else {
                            outputText = adjustInfo.getUsedText();
                        }
                        cell.setOutputText(remainText);
                        if (!row.isRemainContent() && remainText != null && outputGrid.getPrintAtPage() != PrintAtPage.All) {
                            realHeight = usedHeight;
                            row.setRemainContent(true);
                        }
                    } else if (!DelayVarProvider.isBindDelayVar((IPrintWidget)outputCell)) {
                        outputText = adjustInfo.getUsedText();
                    }
                } else {
                    cell.setOutputText("");
                    cell.setRemainContent(false);
                }
            }
            outputCell.setRectangle(new Rectangle(columnWidth, realHeight));
            outputCell.setOutputText(outputText);
            outputRow.addCell(outputCell);
            if (realHeight > realMaxRowHeight) {
                realMaxRowHeight = realHeight;
            }
            if (StringUtils.isNotBlank((CharSequence)outputText) || !this.childIsEmpty(outputCell) || !remainContent && (mergeBlock = cell.getMergeBlock()) != null && mergeBlock.isVerticalMerge()) {
                isBlankRow = false;
            }
            ++columnCursor;
        }
        GridExecuteContext context = ((AbstractPWGrid)this.getOutputWidget()).getContext();
        if (isBlankRow && (outputGrid.isNotBlankRow() || remainContent) && (!this.isHaveSubGrid((AbstractPWGrid)outputGrid) || row.getRowType() == 3 || row.getRowType() == 1)) {
            if (remainContent) {
                context.setRemainBlank(true);
                row.setRemainContent(false);
            }
            if (row.isRemainContent() && realHeight >= maxHeightToAdjust) {
                outputGrid.getContext().setMaxHeightToAdjust(0);
            }
            return;
        }
        context.setRemainBlank(false);
        if (isBlankRow && (outputGrid.isNotBlankRow() || remainContent)) {
            outputRow.setBlankRow(true);
        }
        if (outputRow.isAdjustHeight() || row.isRemainContent()) {
            int cellCount = outputRow.getCellCount();
            int cellIndex = 0;
            while (cellIndex < cellCount) {
                AbstractPWGridCell cell = outputRow.getCell(cellIndex);
                if (cell == null) {
                    ++cellIndex;
                    continue;
                }
                cell.adjustHeight(realMaxRowHeight);
                ++cellIndex;
            }
        }
        outputRow.setHeight(realMaxRowHeight);
        PrintPluginProxy pluginProxy = ExecuteContext.get().getPluginProxy();
        if (pluginProxy != null) {
            AfterOutputRowEvent evt = new AfterOutputRowEvent(outputRow);
            evt.setGrid(outputGrid);
            pluginProxy.fireAfterOutputRow(evt);
            if (evt.isCancleOutput()) {
                return;
            }
        }
        outputGrid.outputRow((AbstractPWGridRow)outputRow);
        outputGrid.getContext().setMaxHeightToAdjust(maxHeightToAdjust -= outputRow.getHeight());
        this.executeCalSubGrid(outputGrid, row, visitor, outputRow, maxHeightToAdjust, remainContent);
    }

    private int getNewPageAdjustHeight(T outputGrid) {
        int relativeY = this.getRelativeContext().scanYFromEveryPagePool(outputGrid);
        int startY = this.getHeaderHeight();
        if (relativeY != -1) {
            startY = relativeY;
        }
        int newPageAdjustHeight = (this.getRelativeContext().getEmptyPage().getRectangle().height - this.getRelativeContext().getHeaderHeight() - this.getRelativeContext().getFooterHeight() - startY) / 2;
        return newPageAdjustHeight;
    }

    private boolean childIsEmpty(AbstractPWGridCell outputCell) {
        if (!outputCell.hasChildren()) {
            return true;
        }
        IPrintWidget iPrintWidget = (IPrintWidget)outputCell.getChildren().get(0);
        if (iPrintWidget instanceof PWText) {
            PWText pwText = (PWText)iPrintWidget;
            String outputText = pwText.getOutputText();
            return !StringUtils.isNotBlank((CharSequence)outputText);
        }
        if (iPrintWidget instanceof IR1PrintScriptable) {
            Map map;
            Object barcode;
            IR1PrintScriptable pwPicture = (IR1PrintScriptable)iPrintWidget;
            Field outputValue = pwPicture.getOutputValue();
            if (outputValue == null || outputValue.getValue() == null) {
                return true;
            }
            Object value = outputValue.getValue();
            if (StringUtils.isBlank((Object)value)) {
                return true;
            }
            if (value instanceof Map && StringUtils.isBlank(barcode = (map = (Map)value).get("barcode"))) {
                return true;
            }
        }
        return false;
    }

    protected boolean isExecuteBlankRow() {
        return false;
    }

    protected int designRowHeightAdjust(AbstractPWGridRow row, int rowHeight, int maxHeightToAdjust) {
        if (rowHeight > maxHeightToAdjust) {
            row.setReaminHeight(rowHeight - maxHeightToAdjust);
            row.setRemainContent(true);
            return maxHeightToAdjust;
        }
        return rowHeight;
    }

    protected final void resetRowPaginationFlag(T outputGrid, AbstractPWGridRow row) {
        if (this.isOpenWholeRowPage() && row.getRowType() == ((AbstractPWGrid)((Object)outputGrid)).getContext().getRowType()) {
            ((AbstractPWGrid)((Object)outputGrid)).getContext().setRowPagination(false);
        }
    }

    protected boolean isAdjuestHeightRow(AbstractPWGridRow outputRow) {
        return outputRow.isAdjustHeight() && outputRow.getRowType() != 3;
    }

    protected boolean rowOverPage() {
        return true;
    }

    public void executeChildren(IPrintWidgetContainer cell, List<IPrintWidget> children) {
        AbstractPWGridCell outputCell = (AbstractPWGridCell)cell;
        Rectangle rectangle = outputCell.getRectangle();
        int containerHeight = rectangle.height;
        int containerWidth = rectangle.width;
        int maxHeight = 0;
        for (IPrintWidget child : children) {
            AbstractPWGridRow row;
            child.setPageIndex(((AbstractPWGrid)this.getOutputWidget()).getPageIndex());
            if (outputCell.getMergeType() == MergeType.Merged) {
                MergeBlock mergeBlock = outputCell.getMergeBlock();
                Dimension mergeInfo = this.getMergeInfo(mergeBlock);
                containerWidth = mergeInfo.width;
                containerHeight = mergeInfo.height;
            }
            Rectangle curReact = child.getRectangle();
            int realWidth = curReact.width;
            int realHeight = curReact.height;
            if ((double)(containerHeight - curReact.y) < curReact.getHeight()) {
                realHeight = containerHeight - curReact.y;
            }
            if (containerWidth - curReact.x - curReact.width < 0) {
                realWidth = containerWidth - curReact.x;
            }
            int maxHeightToAdjuest = outputCell.isAdjustHeight() ? outputCell.getMaxHeightToAdjust() : containerHeight;
            child.setMaxHeightToAdjust(maxHeightToAdjuest -= curReact.y);
            if (child instanceof AbstractPrintWidget) {
                ((AbstractPrintWidget)child).setPrintAtPage(PrintAtPage.InContainer);
            }
            curReact.setSize(realWidth, realHeight);
            child.getRectangle().setRect(curReact);
            IRunner runner = child.getRunner();
            runner.setRelativeContext(this.getRelativeContext());
            runner.execute(this.helper);
            if (child instanceof IAdjustHeightSupport && (row = ((AbstractPWGrid)this.getOutputWidget()).getCurrentRow()) != null && this.isRowChildWidgetPagination((IAdjustHeightSupport)child, row) && outputCell.isAdjustHeight() && maxHeightToAdjuest < this.getNewPageAdjustHeight((AbstractPWGrid)this.getOutputWidget())) {
                ((AbstractPWGrid)this.getOutputWidget()).getContext().setMaxHeightToAdjust(0);
                ((AbstractPWGrid)this.getOutputWidget()).getContext().setRowPagination(true);
                ((AbstractPWGrid)this.getOutputWidget()).getContext().setRowType(((AbstractPWGrid)this.getOutputWidget()).getCurrentRowType());
                this.beforeExecuteRow((AbstractPWGrid)this.getOutputWidget());
                return;
            }
            int height = curReact.height;
            int rY = curReact.y + height;
            if (maxHeight >= rY) continue;
            maxHeight = rY;
        }
        if (maxHeight > containerHeight) {
            rectangle.setSize(containerWidth, maxHeight);
            outputCell.setRectangle(rectangle);
        }
    }

    protected void executePagination(T outputGrid) {
        int relativeY = this.getRelativeContext().scanYFromEveryPagePool(outputGrid);
        int startY = this.getHeaderHeight();
        if (relativeY != -1) {
            startY = relativeY;
        }
        int gridHeight = 0;
        boolean wholeGridPage = ((AbstractPWGrid)((Object)outputGrid)).isWholeGridPage();
        if (wholeGridPage && startY < outputGrid.getRectangle().y) {
            ((AbstractPWGrid)((Object)outputGrid)).setWholeGridPage(false);
            ((AbstractPWGrid)((Object)outputGrid)).setSkipTitleEvery(true);
            gridHeight = ((AbstractPWGrid)((Object)outputGrid)).getOutputRows().stream().mapToInt(m -> ((AbstractPWGridRow)m).getHeight()).sum();
        } else {
            this.cacheOutputPagination((AbstractPrintWidget)outputGrid);
        }
        if (startY >= outputGrid.getRectangle().y) {
            ((AbstractPWGrid)((Object)outputGrid)).setWholeGridPage(false);
            wholeGridPage = false;
        }
        outputGrid.setPageIndex(outputGrid.getPageIndex() + 1);
        Rectangle rectangle = outputGrid.getRectangle();
        rectangle.setRect(rectangle.getX(), startY, rectangle.getWidth(), rectangle.getHeight());
        double needReserveHeight = this.getNeedReserveHeight();
        ((AbstractPWGrid)((Object)outputGrid)).getContext().setMaxHeightToAdjust((int)((double)(this.getRelativeContext().getEmptyPage().getRectangle().height - this.getFooterHeight() - startY) - needReserveHeight - (double)gridHeight));
        if (outputGrid instanceof ITableTailSupport) {
            ((ITableTailSupport)outputGrid).calMaxHeightToAdjust(((AbstractPWGrid)((Object)outputGrid)).getContext());
        }
        if (wholeGridPage) {
            this.beforeExecuteRow(outputGrid);
        }
    }

    protected double getNeedReserveHeight() {
        return 0.0;
    }

    protected boolean needWholePagination(T outputGrid) {
        int maxAdjustHeight = ((AbstractPWGrid)((Object)outputGrid)).getContext().getMaxHeightToAdjust();
        int rowCursor = ((AbstractPWGrid)((Object)outputGrid)).getRowCursor();
        Object row = ((AbstractPWGrid)((Object)outputGrid)).getRow(rowCursor);
        if (this.isRowDesignPagination((AbstractPWGridRow)row, maxAdjustHeight)) {
            ((AbstractPWGrid)((Object)outputGrid)).getContext().setRowPagination(true);
            ((AbstractPWGrid)((Object)outputGrid)).getContext().setRowType(row.getRowType());
            return true;
        }
        return false;
    }

    protected boolean needPagination(AbstractPWGrid outputGrid) {
        int rowsCount;
        int maxAdjustHeight = outputGrid.getContext().getMaxHeightToAdjust();
        int rowCursor = outputGrid.getRowCursor();
        if (rowCursor >= (rowsCount = outputGrid.getRowsCount()) || outputGrid.getPrintAtPage() == PrintAtPage.InContainer) {
            return false;
        }
        Object row = outputGrid.getRow(rowCursor);
        int rowHeight = row.getHeight();
        if (rowHeight >= MIN_ROW_HEIGHT && maxAdjustHeight < MIN_ROW_HEIGHT) {
            return true;
        }
        if (rowHeight <= MIN_ROW_HEIGHT && maxAdjustHeight < rowHeight) {
            return true;
        }
        return this.repairRowIndex && row.isRemainContent() && !outputGrid.isTempWholeRowPage();
    }

    protected void beforeCacheOutput(AbstractPrintWidget outputWidget) {
        PrintPluginProxy pluginProxy = ExecuteContext.get().getPluginProxy();
        if (pluginProxy != null) {
            AfterOutputGridEvent evt = new AfterOutputGridEvent((AbstractPWGrid)outputWidget);
            pluginProxy.fireAfterOutputWidget((AfterOutputWidgetEvent)evt);
        }
    }

    public void cacheOutput(AbstractPrintWidget outputWidget) {
        AbstractPWGrid grid = (AbstractPWGrid)outputWidget;
        grid.columnsOutput();
        if (grid.isCanvasWidget() && (grid.getOutputRows().size() > 0 || grid.isNotBlankRow())) {
            AbstractPWGrid copy = (AbstractPWGrid)grid.copy();
            List outputRows = grid.getOutputRows();
            for (AbstractPWGridRow row : outputRows) {
                copy.outputRow(row);
            }
            if (grid instanceof PWDataGrid) {
                ((PWDataGrid)copy).setSubDataGrids(((PWDataGrid)grid).getSubDataGrids());
            }
            this.handGridBorder(grid, copy);
            this.handMerge(copy);
            super.cacheOutput((AbstractPrintWidget)copy);
            this.recordPosition(grid);
            grid.getOutputRows().clear();
        }
        this.processTableTail(grid);
    }

    protected void processTableTail(AbstractPWGrid grid) {
        if (!(grid instanceof ITableTailSupport)) {
            return;
        }
        ITableTailSupport support = (ITableTailSupport)grid;
        if (support.isTableTailFlowAll()) {
            this.executeTableTail(support.getTableTail().copy());
        }
    }

    protected void cacheOutputPagination(AbstractPrintWidget outputWidget) {
        this.cacheOutput(outputWidget);
    }

    protected void executeTableTail(PWTableTail tableTail) {
        IRunner runner = tableTail.getRunner();
        runner.setRelativeContext(this.getRelativeContext());
        tableTail.setCanvasWidget(Boolean.TRUE.booleanValue());
        runner.beginOutput((AbstractPrintWidget)tableTail);
        runner.execute(this.helper);
    }

    protected void handMerge(AbstractPWGrid outputGrid) {
        PWDataGrid subGrid;
        List outputRows = outputGrid.getOutputRows();
        int columnCount = outputGrid.getColumnCount();
        boolean haveSubGrid = this.isHaveSubGrid(outputGrid);
        if (haveSubGrid && "right".equals((subGrid = this.getSubGrid((PWDataGrid)outputGrid)).getSubGridDirection())) {
            columnCount += subGrid.getColumnCount();
        }
        AbstractPWGrid curDesignGrid = outputGrid;
        for (int i = 0; i < outputRows.size(); ++i) {
            int curColumnCount;
            AbstractPWGridRow row = (AbstractPWGridRow)outputRows.get(i);
            if (row.isSubRow() && haveSubGrid) {
                curDesignGrid = this.getSubGrid((PWDataGrid)outputGrid);
                curColumnCount = curDesignGrid.getColumnCount();
            } else {
                curColumnCount = columnCount;
            }
            for (int j = 0; j < curColumnCount; ++j) {
                MergeBlock block;
                AbstractPWGridCell cell = row.getCell(j);
                if (cell == null) continue;
                if (cell.isSubCell() && haveSubGrid) {
                    curDesignGrid = this.getSubGrid((PWDataGrid)outputGrid);
                }
                if (i == 0 && MergeUtils.canChangeMergeType((AbstractPWGridCell)cell, (int)j)) {
                    cell.setMergeType(MergeType.Merged);
                }
                if (cell.getMergeType() == MergeType.Merged) {
                    block = cell.getMergeBlock();
                    Rectangle rectangle = cell.getRectangle();
                    int columnStart = block.getLeft();
                    int colunmEnd = block.getRight();
                    int rowStart = block.getTop();
                    int rowEnd = block.getBottom();
                    int step = 1;
                    int rowHeight = rectangle.height;
                    for (int rowIndex = rowStart; rowIndex < rowEnd && i + step < outputRows.size(); ++rowIndex) {
                        AbstractPWGridRow nextRow = (AbstractPWGridRow)outputRows.get(i + step);
                        if (cell.isSubCell()) {
                            AbstractPWGridCell nextCell = nextRow.getCell(j);
                            if (nextCell != null && MergeType.BeMerged == nextCell.getMergeType()) {
                                rowHeight += nextCell.getRectangle().height;
                            }
                        } else {
                            rowHeight += MergeUtils.getMergeAddHeight((AbstractPWGrid)curDesignGrid, (AbstractPWGridRow)nextRow, (MergeBlock)block);
                        }
                        ++step;
                    }
                    step = 1;
                    int columnWidth = rectangle.width;
                    for (int colIndex = columnStart; colIndex < colunmEnd && j + step < curColumnCount; ++colIndex) {
                        columnWidth += row.getCell((int)(j + step)).getRectangle().width;
                        ++step;
                    }
                    cell.setRectangle(new Rectangle(rectangle.x, rectangle.y, columnWidth, rowHeight));
                    if (rowEnd <= rowStart || i + rowEnd - rowStart < outputRows.size() - 1) continue;
                    MergeUtils.adjustMergeCellStyle((AbstractPWGrid)((AbstractPWGrid)this.getOutputWidget()), (AbstractPWGridCell)cell);
                    continue;
                }
                if (cell.getMergeType() != MergeType.BeMerged) continue;
                if (row.isSubRow() && outputGrid instanceof PWDataGrid && i == 0 && cell.getMergeBlock().getBottom() > 0) {
                    cell.setOutputText("");
                    block = cell.getMergeBlock();
                    if (block.getBottom() == block.getTop()) {
                        if (j <= block.getLeft() || j > block.getRight()) continue;
                        row.setCell(j, null);
                        continue;
                    }
                    if (block.getBottom() - block.getTop() <= 0) continue;
                }
                if (row.isSubRow() && outputGrid instanceof PWDataGrid && i == outputRows.size() - 1 && cell.getMergeBlock().getBottom() > 0) {
                    Style style = cell.getStyle();
                    StyleAttributes sa = style.getNewAttribute();
                    sa.setBorderLineStyle(Styles.Position.TOP, LineStyle.NULL_LINE);
                    if (j == 0) {
                        sa.setBorderLineStyle(Styles.Position.LEFT, LineStyle.NULL_LINE);
                    } else if (j == curColumnCount - 1) {
                        sa.setBorderLineStyle(Styles.Position.RIGHT, LineStyle.NULL_LINE);
                    }
                    cell.setStyle(Styles.getStyle((ShareStyleAttributes)sa));
                    cell.setOutputText("");
                    MergeBlock block2 = cell.getMergeBlock();
                    if (block2.getBottom() != block2.getTop() || j <= block2.getLeft() || j > block2.getRight()) continue;
                    row.setCell(j, null);
                    continue;
                }
                row.setCell(j, null);
            }
        }
    }

    private PWDataGrid getSubGrid(PWDataGrid outputGrid) {
        return (PWDataGrid)outputGrid.getSubDataGrids().get(0);
    }

    protected Dimension getMergeInfo(MergeBlock block) {
        return this.getMergeInfo(block, (AbstractPWGrid)this.getOutputWidget());
    }

    protected final Dimension getMergeInfo(MergeBlock block, AbstractPWGrid grid) {
        int columnStart = block.getLeft();
        int colunmEnd = block.getRight();
        int rowStart = block.getTop();
        int rowEnd = block.getBottom();
        int rowHeight = 0;
        for (int rowIndex = rowStart; rowIndex <= rowEnd; ++rowIndex) {
            rowHeight += grid.getRow(rowIndex).getHeight();
        }
        int columnWidth = 0;
        for (int colIndex = columnStart; colIndex <= colunmEnd; ++colIndex) {
            columnWidth += grid.getColumn(colIndex).getWidth();
        }
        return new Dimension(columnWidth, rowHeight);
    }

    protected void handGridBorder(AbstractPWGrid grid, AbstractPWGrid copy) {
        PWDataGrid subGrid;
        Border borderTop;
        Style gridStyle = grid.getStyle();
        int rowCount = copy.getOutputRows().size();
        if (rowCount == 0) {
            return;
        }
        List subDataGrids = new ArrayList(10);
        if (copy instanceof PWDataGrid) {
            subDataGrids = ((PWDataGrid)copy).getSubDataGrids();
        }
        if ((borderTop = gridStyle.getBorder(Styles.Position.TOP)) != null && !borderTop.isNull()) {
            Object outputRow = copy.getOutputRow(0);
            int curRowIndex = outputRow.getRowIndex();
            Object curDesignRow = outputRow.isSubRow() ? this.getSubGrid((PWDataGrid)copy).getRow(curRowIndex) : copy.getRow(curRowIndex);
            int cellCount = outputRow.getCellCount();
            for (int i = 0; i < cellCount; ++i) {
                Style style;
                LineStyle borderLineStyle;
                AbstractPWGridCell cell = outputRow.getCell(i);
                if (cell == null || (borderLineStyle = (style = cell.getStyle()).getBorderLineStyle(Styles.Position.TOP)) != LineStyle.NULL_LINE) continue;
                StyleAttributes sa = style.getNewAttribute();
                sa.setBorder(borderTop);
                if (!cell.isSubCell()) {
                    if (i <= curDesignRow.getCellCount() - 1) {
                        Style curCellStyle = curDesignRow.getCell(i).getStyle();
                        sa.setBorderLineStyle(Styles.Position.TOP, curCellStyle.getBorderLineStyle(Styles.Position.TOP));
                        sa.setBorderColor(Styles.Position.TOP, curCellStyle.getBorderColor(Styles.Position.TOP));
                    }
                } else if (!subDataGrids.isEmpty()) {
                    int subRowIndex = cell.getRowIndex();
                    AbstractPWGridRow curSubDesignRow = ((PWDataGrid)subDataGrids.get(0)).getRow(subRowIndex);
                    Style curSubCellStyle = curSubDesignRow.getCell(i - curDesignRow.getCellCount()).getStyle();
                    sa.setBorderLineStyle(Styles.Position.TOP, curSubCellStyle.getBorderLineStyle(Styles.Position.TOP));
                    sa.setBorderColor(Styles.Position.TOP, curSubCellStyle.getBorderColor(Styles.Position.TOP));
                }
                cell.setStyle(Styles.getStyle((ShareStyleAttributes)sa));
            }
        }
        Border borderButtom = gridStyle.getBorder(Styles.Position.BOTTOM);
        Border subBorderButtom = null;
        if (grid instanceof PWDataGrid && !CollectionUtils.isEmpty((Collection)((PWDataGrid)grid).getSubDataGrids()) && (subGrid = this.getSubGrid((PWDataGrid)grid)) != null) {
            subBorderButtom = subGrid.getStyle().getBorder(Styles.Position.BOTTOM);
        }
        if (borderButtom != null && !borderButtom.isNull()) {
            Object outputRow = copy.getOutputRow(rowCount - 1);
            int curRowIndex = outputRow.getRowIndex();
            int designRowCount = copy.getRowsCount();
            boolean subRow = outputRow.isSubRow();
            Object curDesignRow = null;
            if (!subRow) {
                curDesignRow = copy.getRow(curRowIndex);
            }
            Object finalDesignRow = null;
            Object nextDesignRow = null;
            if (curRowIndex + 1 == designRowCount) {
                finalDesignRow = copy.getRow(curRowIndex);
            } else if (curRowIndex + 1 < designRowCount) {
                nextDesignRow = copy.getRow(curRowIndex + 1);
            }
            int cellCount = this.getCellCountWithHSubGrid(grid, (AbstractPWGridRow)outputRow);
            for (int i = 0; i < cellCount; ++i) {
                Style nextCellStyle;
                MergeBlock mergeBlock;
                int bottom;
                Style finalCellStyle;
                AbstractPWGridRow finalSubDesignRow;
                int curSubRowIndex;
                AbstractPWGridCell cell = outputRow.getCell(i);
                if (cell == null) {
                    ListIterator outRowIt = copy.getOutputRows().listIterator(rowCount - 1);
                    while (outRowIt.hasPrevious() && (cell = ((AbstractPWGridRow)outRowIt.previous()).getCell(i)) == null) {
                    }
                    if (cell == null) continue;
                }
                Style style = cell.getStyle();
                MergeType mergeType = cell.getMergeType();
                LineStyle borderLineStyle = style.getBorderLineStyle(Styles.Position.BOTTOM);
                if (borderLineStyle != LineStyle.NULL_LINE) continue;
                StyleAttributes sa = style.getNewAttribute();
                if (cell.isSubCell() && subBorderButtom != null) {
                    sa.setBorder(subBorderButtom);
                    if (!subDataGrids.isEmpty() && curDesignRow != null) {
                        curSubRowIndex = cell.getRowIndex();
                        finalSubDesignRow = null;
                        AbstractPWGridRow nextSubDesignRow = null;
                        if (curSubRowIndex + 1 == ((PWDataGrid)subDataGrids.get(0)).getRowsCount()) {
                            finalSubDesignRow = ((PWDataGrid)subDataGrids.get(0)).getRow(curSubRowIndex);
                            finalCellStyle = finalSubDesignRow.getCell(i - curDesignRow.getCellCount()).getStyle();
                            if (!(finalSubDesignRow instanceof PWDetailRow)) {
                                sa.setBorderLineStyle(Styles.Position.BOTTOM, finalCellStyle.getBorderLineStyle(Styles.Position.BOTTOM));
                                sa.setBorderColor(Styles.Position.BOTTOM, finalCellStyle.getBorderColor(Styles.Position.BOTTOM));
                            }
                        } else {
                            nextSubDesignRow = ((PWDataGrid)subDataGrids.get(0)).getRow(curSubRowIndex + 1);
                            if (mergeType == MergeType.Merged && (bottom = (mergeBlock = cell.getMergeBlock()).getBottom()) + 1 < ((PWDataGrid)subDataGrids.get(0)).getRowsCount()) {
                                nextSubDesignRow = ((PWDataGrid)subDataGrids.get(0)).getRow(bottom + 1);
                            }
                            nextCellStyle = nextSubDesignRow.getCell(i - curDesignRow.getCellCount()).getStyle();
                            sa.setBorderLineStyle(Styles.Position.BOTTOM, nextCellStyle.getBorderLineStyle(Styles.Position.TOP));
                            sa.setBorderColor(Styles.Position.BOTTOM, nextCellStyle.getBorderColor(Styles.Position.TOP));
                        }
                    }
                } else if (!subRow) {
                    sa.setBorder(borderButtom);
                    if (finalDesignRow != null) {
                        if (i < finalDesignRow.getCellCount()) {
                            Style finalCellStyle2 = finalDesignRow.getCell(i).getStyle();
                            if (!(finalDesignRow instanceof PWDetailRow)) {
                                sa.setBorderLineStyle(Styles.Position.BOTTOM, finalCellStyle2.getBorderLineStyle(Styles.Position.BOTTOM));
                                sa.setBorderColor(Styles.Position.BOTTOM, finalCellStyle2.getBorderColor(Styles.Position.BOTTOM));
                            }
                        }
                    } else if (nextDesignRow != null && i < nextDesignRow.getCellCount()) {
                        MergeBlock mergeBlock2;
                        int bottom2;
                        Style nextCellStyle2 = nextDesignRow.getCell(i).getStyle();
                        if (mergeType == MergeType.Merged && (bottom2 = (mergeBlock2 = cell.getMergeBlock()).getBottom()) + 1 < designRowCount) {
                            nextDesignRow = copy.getRow(bottom2 + 1);
                        }
                        sa.setBorderLineStyle(Styles.Position.BOTTOM, nextCellStyle2.getBorderLineStyle(Styles.Position.TOP));
                        sa.setBorderColor(Styles.Position.BOTTOM, nextCellStyle2.getBorderColor(Styles.Position.TOP));
                    }
                    if (grid instanceof PWDataGrid && ((PWDataGrid)grid).isTitleRowEveryPage()) {
                        sa.setBorder(borderButtom);
                    }
                } else if (subBorderButtom != null && !subDataGrids.isEmpty()) {
                    sa.setBorder(subBorderButtom);
                    curSubRowIndex = outputRow.getRowIndex();
                    finalSubDesignRow = null;
                    AbstractPWGridRow nextSubDesignRow = null;
                    if (curSubRowIndex + 1 == ((PWDataGrid)subDataGrids.get(0)).getRowsCount()) {
                        finalSubDesignRow = ((PWDataGrid)subDataGrids.get(0)).getRow(curSubRowIndex);
                        finalCellStyle = finalSubDesignRow.getCell(i).getStyle();
                        if (!(finalSubDesignRow instanceof PWDetailRow)) {
                            sa.setBorderLineStyle(Styles.Position.BOTTOM, finalCellStyle.getBorderLineStyle(Styles.Position.BOTTOM));
                            sa.setBorderColor(Styles.Position.BOTTOM, finalCellStyle.getBorderColor(Styles.Position.BOTTOM));
                        }
                    } else {
                        nextSubDesignRow = ((PWDataGrid)subDataGrids.get(0)).getRow(curSubRowIndex + 1);
                        if (mergeType == MergeType.Merged && (bottom = (mergeBlock = cell.getMergeBlock()).getBottom()) + 1 < ((PWDataGrid)subDataGrids.get(0)).getRowsCount()) {
                            nextSubDesignRow = ((PWDataGrid)subDataGrids.get(0)).getRow(bottom + 1);
                        }
                        nextCellStyle = nextSubDesignRow.getCell(i).getStyle();
                        sa.setBorderLineStyle(Styles.Position.BOTTOM, nextCellStyle.getBorderLineStyle(Styles.Position.TOP));
                        sa.setBorderColor(Styles.Position.BOTTOM, nextCellStyle.getBorderColor(Styles.Position.TOP));
                    }
                }
                cell.setStyle(Styles.getStyle((ShareStyleAttributes)sa));
            }
        }
    }

    private int getCellCountWithHSubGrid(AbstractPWGrid grid, AbstractPWGridRow outputRow) {
        if (grid instanceof PWDataGrid && SubGridUtils.isHaveSubGrid((Object)((Object)grid)) && !SubGridUtils.checkVSubGrid((PWDataGrid)((PWDataGrid)grid))) {
            PWDataGrid dataGrid = (PWDataGrid)grid;
            int pCells = 0;
            int subCells = 0;
            for (int i = dataGrid.getRowsCount() - 1; i >= 0; --i) {
                if (((AbstractPWDataGridRow)dataGrid.getRow(i)).getRowType() != outputRow.getRowType()) continue;
                pCells = ((AbstractPWDataGridRow)dataGrid.getRow(i)).getCellCount();
                break;
            }
            PWDataGrid subGrid = (PWDataGrid)dataGrid.getSubDataGrids().get(0);
            for (int i = subGrid.getRowsCount() - 1; i >= 0; --i) {
                if (((AbstractPWDataGridRow)subGrid.getRow(i)).getRowType() != outputRow.getRowType()) continue;
                subCells = ((AbstractPWDataGridRow)subGrid.getRow(i)).getCellCount();
                break;
            }
            return pCells + subCells;
        }
        return outputRow.getCellCount();
    }

    public void endOutput(AbstractPrintWidget outputWidget) {
        AbstractPWGrid grid = (AbstractPWGrid)outputWidget;
        grid.getContext().getMergeTypeMap().clear();
        this.processLastTableTail(grid);
        this.titleRowOut = 0;
        this.outputWidget = null;
    }

    protected void processLastTableTail(AbstractPWGrid grid) {
        if (grid instanceof ITableTailSupport && ((ITableTailSupport)grid).isTableTailFlowNative()) {
            this.executeTableTail(((ITableTailSupport)grid).getTableTail());
        }
    }

    protected void recordPosition(AbstractPWGrid grid) {
        Rectangle rectangle = grid.getRectangle();
        int height = 0;
        List outputRows = grid.getOutputRows();
        if (outputRows != null) {
            height = outputRows.stream().filter(Objects::nonNull).mapToInt(AbstractPWGridRow::getHeight).sum();
        }
        rectangle.setRect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), height);
        this.getRelativeContext().recordOutPutPosition((AbstractPrintWidget)grid);
    }

    private void executeCalSubGrid(T outputGrid, AbstractPWGridRow row, GridDataVisitor visitor, AbstractPWGridRow outputRow, int maxHeightToAdjust, boolean remainContent) {
        DataGridRunner runner;
        Field subGridValue;
        String subDataSource;
        PWDataGrid subDataGrid;
        if (2 == row.getRowType() && outputGrid instanceof PWDataGrid && !CollectionUtils.isEmpty((Collection)((PWDataGrid)outputGrid).getSubDataGrids())) {
            subDataGrid = this.getSubGrid((PWDataGrid)outputGrid);
            subDataSource = subDataGrid.getDatasource();
            if (StringUtils.isBlank((CharSequence)subDataSource)) {
                return;
            }
            subGridValue = visitor.getFieldVal(subDataSource, null);
            if (subGridValue instanceof CollectionField && !CollectionUtils.isEmpty((Collection)((CollectionField)subGridValue).getValue()) && "bottom".equals(subDataGrid.getSubGridDirection())) {
                runner = (DataGridRunner)subDataGrid.getRunner();
                runner.beginOutput((AbstractPrintWidget)subDataGrid);
                runner.execute(this.helper);
                if (!((VSubGridRunner)runner.runner).isSubGWGreaterThanParentGW((PWDataGrid)outputGrid, subDataGrid)) {
                    int cellCount = outputRow.getCellCount();
                    for (int cellIndex = 0; cellIndex < cellCount; ++cellIndex) {
                        AbstractPWGridCell designCell;
                        Object designRow;
                        AbstractPWGridCell cell = outputRow.getCell(cellIndex);
                        Style gridStyle = outputGrid.getStyle();
                        Border borderTop = gridStyle.getBorder(Styles.Position.BOTTOM);
                        Style style = cell.getStyle();
                        LineStyle borderLineStyle = style.getBorderLineStyle(Styles.Position.BOTTOM);
                        Color borderColor = style.getBorderColor(Styles.Position.BOTTOM);
                        if (borderLineStyle != LineStyle.NULL_LINE) continue;
                        int rowIndex = outputRow.getRowIndex();
                        if (rowIndex + 1 < ((AbstractPWGrid)((Object)outputGrid)).getRowsCount()) {
                            designRow = ((AbstractPWGrid)((Object)outputGrid)).getRow(rowIndex + 1);
                            designCell = designRow.getCell(cellIndex);
                            borderColor = designCell.getStyle().getBorderColor(Styles.Position.TOP);
                        } else if (rowIndex + 1 == ((AbstractPWGrid)((Object)outputGrid)).getRowsCount()) {
                            designRow = ((AbstractPWGrid)((Object)outputGrid)).getRow(rowIndex);
                            designCell = designRow.getCell(cellIndex);
                            borderColor = designCell.getStyle().getBorderColor(Styles.Position.BOTTOM);
                        }
                        StyleAttributes sa = style.getNewAttribute();
                        sa.setBorder(borderTop);
                        sa.setBorderColor(Styles.Position.BOTTOM, borderColor);
                        cell.setStyle(Styles.getStyle((ShareStyleAttributes)sa));
                    }
                }
                if (!row.isRemainContent()) {
                    ((VSubGridRunner)runner.runner).executeSubGrid((PWDataGrid)outputGrid, row, maxHeightToAdjust, (CollectionField)subGridValue, outputRow);
                }
            } else if (subGridValue == null || subGridValue instanceof CollectionField && CollectionUtils.isEmpty((Collection)((CollectionField)subGridValue).getValue()) && "bottom".equals(subDataGrid.getSubGridDirection())) {
                SubGridUtils.dealBlankRow((PWDataGrid)((PWDataGrid)outputGrid), (AbstractPWGridRow)outputRow);
            }
        }
        if (outputGrid instanceof PWDataGrid && !CollectionUtils.isEmpty((Collection)((PWDataGrid)outputGrid).getSubDataGrids()) && "right".equals(this.getSubGrid((PWDataGrid)outputGrid).getSubGridDirection())) {
            subDataGrid = this.getSubGrid((PWDataGrid)outputGrid);
            subDataSource = subDataGrid.getDatasource();
            if (1 == row.getRowType() || 3 == row.getRowType()) {
                DataGridRunner runner2 = (DataGridRunner)subDataGrid.getRunner();
                runner2.beginOutput((AbstractPrintWidget)subDataGrid);
                runner2.execute(this.helper);
                if (3 == row.getRowType()) {
                    outputRow.setRemainContent(row.isRemainContent());
                }
                ((HSubGridRunner)runner2.runner).executeSubGrid((PWDataGrid)outputGrid, outputRow, null);
            } else if (2 == row.getRowType() && (subGridValue = visitor.getFieldVal(subDataSource, null)) instanceof CollectionField) {
                runner = (DataGridRunner)subDataGrid.getRunner();
                runner.beginOutput((AbstractPrintWidget)subDataGrid);
                runner.execute(this.helper);
                outputRow.setRemainContent(row.isRemainContent());
                if (!remainContent) {
                    ((HSubGridRunner)runner.runner).resetDataIndex((CollectionField)subGridValue);
                }
                ((HSubGridRunner)runner.runner).executeSubGrid((PWDataGrid)outputGrid, outputRow, (CollectionField)subGridValue);
            }
        }
    }

    private boolean isHaveSubGrid(AbstractPWGrid outputGrid) {
        return outputGrid instanceof PWDataGrid && !CollectionUtils.isEmpty((Collection)((PWDataGrid)outputGrid).getSubDataGrids());
    }

    protected String getFormulaValue(List<Object> formulaData, AbstractPrintWidget outputGrid, AbstractPrintWidget outputCell, IWidgetExecuteHelper helper, GridDataVisitor visitor) {
        ArrayList<Object> newFormulaData = new ArrayList<Object>(10);
        String gridds = ((PWDataGrid)outputGrid).getDatasource();
        for (int i = 0; i < formulaData.size(); ++i) {
            Object object = formulaData.get(i);
            if (object instanceof Map) {
                Map field = (Map)object;
                newFormulaData.add(object);
                String ds = (String)field.get("dataSource");
                String bf = (String)field.get("bindField");
                if (StringUtil.equals((String)ds, (String)"$DsKey=[System]")) {
                    if (outputGrid.getPrintAtPage() == PrintAtPage.All) continue;
                    if (StringUtil.equals((String)bf, (String)"=getRowNumber()")) {
                        field.put("value", new TextField(String.valueOf(this.detailRowNumber)));
                        continue;
                    }
                    outputCell.setPageIndex(outputGrid.getPageIndex());
                    Object formulaResult = this.runFormula(helper, (IPrintWidget)outputCell, bf);
                    field.put("value", new TextField(formulaResult == null ? "" : formulaResult.toString()).getValue());
                    continue;
                }
                CellValueField cellField = new CellValueField(bf);
                Field fieldValue = null;
                fieldValue = StringUtil.equals((String)ds, (String)gridds) ? visitor.getFieldVal(ds, cellField) : this.getDataHelper(helper, ds).getFieldValue(ds, bf);
                field.put("value", fieldValue);
                continue;
            }
            newFormulaData.add(object);
        }
        IFormulaService formulaService = ExecuteContext.get().getServiceProxy().getFormulaService();
        return formulaService.parseExp(newFormulaData);
    }

    protected void judgeTitleRowOut(PWDataGrid outputGrid) {
        List outputRows = outputGrid.getOutputRows();
        if (outputGrid.isTitleRowEveryPage()) {
            if (outputRows.isEmpty()) {
                ++this.titleRowOut;
                if (this.titleRowOut >= 50) {
                    String msg = ResManager.loadKDString((String)"\u6bcf\u9875\u6253\u5370\u6807\u9898\u884c\u7684\u5185\u5bb9\u8fc7\u591a\uff0c\u5bfc\u81f4\u6570\u636e\u884c\u5185\u5bb9\u65e0\u6cd5\u8f93\u51fa\uff0c\u8bf7\u8c03\u6574\u6a21\u677f\u540e\u6253\u5370\u3002", (String)"TitleRowEveryPageRunner_0", (String)"bos-print-core", (Object[])new Object[0]);
                    this.titleRowOut = 0;
                    throw new PrintException("0", msg);
                }
            } else if (((AbstractPWGridRow)outputRows.get(outputRows.size() - 1)).getRowType() == 1) {
                ++this.titleRowOut;
                if (this.titleRowOut >= 50) {
                    String msg = ResManager.loadKDString((String)"\u6bcf\u9875\u6253\u5370\u6807\u9898\u884c\u7684\u5185\u5bb9\u8fc7\u591a\uff0c\u5bfc\u81f4\u6570\u636e\u884c\u5185\u5bb9\u65e0\u6cd5\u8f93\u51fa\uff0c\u8bf7\u8c03\u6574\u6a21\u677f\u540e\u6253\u5370\u3002", (String)"TitleRowEveryPageRunner_0", (String)"bos-print-core", (Object[])new Object[0]);
                    this.titleRowOut = 0;
                    throw new PrintException("0", msg);
                }
            }
        }
    }

    protected boolean showImageField(AbstractPWGridCell outputCell, ImageField imageField, int realHeight, int columnWidth) {
        Rect padding;
        if (imageField.showDisplayVal() && (imageField.isDesensitive() || kd.bos.util.StringUtils.isBlank((String)imageField.getDisplayVal()))) {
            imageField.setValue("");
        }
        PWPicture pwPicture = new PWPicture();
        pwPicture.setId("");
        pwPicture.setPrintable(true);
        pwPicture.setType("Picture");
        pwPicture.setScaleType(3);
        pwPicture.setAdjustHeight(true);
        pwPicture.setRectangle(new Rectangle(0, 0, columnWidth, realHeight));
        pwPicture.setOutputValue((Field)imageField);
        Style style = outputCell.getStyle();
        Style pwPictureStyle = pwPicture.getStyle();
        StyleAttributes newAttribute = pwPictureStyle.getNewAttribute();
        if (style.getHorizontalAlign() != null) {
            newAttribute.setHorizontalAlign(style.getHorizontalAlign());
        }
        if (style.getVerticalAlign() != null) {
            newAttribute.setVerticalAlign(style.getVerticalAlign());
        }
        if ((padding = style.getPadding()) != null) {
            newAttribute.setPadding(padding.getCopy());
        }
        pwPicture.setStyle(Styles.getStyle((ShareStyleAttributes)newAttribute));
        outputCell.addChild((IPrintWidget)pwPicture);
        outputCell.setOriOutPutText("");
        return StringUtils.isNotBlank((CharSequence)((CharSequence)imageField.getValue()));
    }

    protected List<IPrintWidget> childrenWidgetBindField(String datasource, PdIterator iterator, AbstractPWGridCell cell, List<IPrintWidget> children) {
        ArrayList<IPrintWidget> printWidgetList = new ArrayList<IPrintWidget>(children.size());
        for (IPrintWidget widget : children) {
            Field field = null;
            if (!(widget instanceof AbstractPrintWidgetField)) continue;
            AbstractPrintWidgetField widgetField = (AbstractPrintWidgetField)widget;
            String bindField = widgetField.getBindField();
            String widgetFieldDatasource = widgetField.getDatasource();
            if (StringUtil.equals((String)widgetFieldDatasource, (String)"$DsKey=[System]") && ((AbstractPWGrid)this.getOutputWidget()).getPrintAtPage() != PrintAtPage.All) {
                AbstractPrintWidget copy;
                TextField outputValue;
                if (StringUtil.equals((String)bindField, (String)"=getRowNumber()")) {
                    outputValue = new TextField(String.valueOf(this.detailRowNumber));
                    copy = (AbstractPrintWidget)widgetField.copy();
                    copy.setOutputValue((Field)outputValue);
                    printWidgetList.add((IPrintWidget)copy);
                    continue;
                }
                if ("=getGroupRowNumber()".equals(bindField)) {
                    outputValue = new TextField(String.valueOf(this.detailGroupRowNumber));
                    copy = (AbstractPrintWidget)widgetField.copy();
                    copy.setOutputValue((Field)outputValue);
                    printWidgetList.add((IPrintWidget)copy);
                    continue;
                }
            }
            field = this.getField(bindField, widgetFieldDatasource, datasource, bindField, iterator);
            if (widget instanceof PWText) {
                PWText pwText = (PWText)widget;
                List formulaData = pwText.getFormulaData();
                field = this.getFieldOrDefault(bindField, widgetFieldDatasource, datasource, formulaData, bindField, iterator);
            }
            if (widget instanceof PWBarcode) {
                PWBarcode barcode = (PWBarcode)widget;
                BarcodeObject barcodeObject = barcode.getBarcodeObject();
                bindField = barcodeObject.getBindField();
                List<Object> formulaData = barcode.getFormulaData();
                String defaultValue = bindField;
                if (StringUtils.isBlank((CharSequence)defaultValue)) {
                    defaultValue = barcodeObject.getSampleTxt();
                }
                field = this.getFieldOrDefault(bindField, widgetFieldDatasource, datasource, formulaData, defaultValue, iterator);
            }
            if (widget instanceof PWPicture && field instanceof TextField) {
                field = new ImageField((String)((TextField)field).getValue());
            }
            AbstractPrintWidget copy = (AbstractPrintWidget)widgetField.copy();
            copy.setOutputValue(field);
            printWidgetList.add((IPrintWidget)copy);
        }
        cell.getChildren().clear();
        cell.getChildren().addAll(printWidgetList);
        return printWidgetList;
    }

    private Field getFieldOrDefault(String bindField, String widgetFieldDatasource, String datasource, List<Object> formulaData, String defaultValue, PdIterator iterator) {
        if (StringUtils.isNotBlank((CharSequence)widgetFieldDatasource)) {
            return this.getField(bindField, widgetFieldDatasource, datasource, defaultValue, iterator);
        }
        Optional<TextField> optional = this.tryGetFormulaData(formulaData, datasource, iterator);
        return (Field)optional.orElseGet(() -> new TextField(defaultValue));
    }

    protected Optional<TextField> tryGetFormulaData(List<Object> formulaData, String datasource, PdIterator iterator) {
        ArrayList<Object> newFormulaData = new ArrayList<Object>(10);
        if (CollectionUtils.isEmpty(formulaData)) {
            return Optional.empty();
        }
        for (Object formulaDatum : formulaData) {
            if (formulaDatum instanceof Map) {
                Map field = (Map)formulaDatum;
                newFormulaData.add(formulaDatum);
                String ds = (String)field.get("dataSource");
                String bindField = (String)field.get("bindField");
                Field fieldValue = null;
                fieldValue = StringUtil.equals((String)ds, (String)datasource) ? iterator.getField(bindField) : this.getDataHelper(this.helper, ds).getFieldValue(ds, bindField);
                field.put("value", fieldValue == null ? "" : fieldValue);
                continue;
            }
            newFormulaData.add(formulaDatum);
        }
        IFormulaService formulaService = ExecuteContext.get().getServiceProxy().getFormulaService();
        String res = formulaService.parseExp(newFormulaData);
        return Optional.of(new TextField(res));
    }

    private Field getField(String bindField, String widgetFieldDatasource, String datasource, String defaultValue, PdIterator iterator) {
        if (StringUtils.equals((CharSequence)widgetFieldDatasource, (CharSequence)datasource)) {
            return iterator.getField(bindField);
        }
        if (StringUtils.isNotBlank((CharSequence)widgetFieldDatasource)) {
            return this.helper.getDataHelper().getFieldValue(widgetFieldDatasource, bindField);
        }
        return new TextField(defaultValue);
    }

    public IWholeRowPageRunner createWholeRowPageRunner() {
        PWDataGrid subGrid;
        PWDataGrid grid;
        AbstractPWGrid outputWidget = (AbstractPWGrid)this.getOutputWidget();
        if (outputWidget instanceof PWDataGrid && !CollectionUtils.isEmpty((Collection)(grid = (PWDataGrid)outputWidget).getSubDataGrids()) && (subGrid = (PWDataGrid)grid.getSubDataGrids().get(0)) != null && "right".equals(subGrid.getSubGridDirection())) {
            return new NotSupportWholeRowPageRunner();
        }
        return new DefaultWholeRowPageRunner((AbstractPWGrid)this.getOutputWidget());
    }

    public final boolean isOpenWholeRowPage() {
        return this.wholeRowPageRunner.isOpenWholeRowPage();
    }

    public final boolean isRowDesignPagination(AbstractPWGridRow row, int maxAdjustHeight) {
        return this.wholeRowPageRunner.isRowDesignPagination(row, maxAdjustHeight);
    }

    public final boolean isRowRuntimePagination(AdjustHeightUtil.AdjustInfo adjustInfo, int pageHeight, AbstractPWGridRow row) {
        AbstractPWGrid outputWidget = (AbstractPWGrid)this.getOutputWidget();
        if (outputWidget.isTempWholeRowPage() && outputWidget.isWholeGridPage()) {
            return StringUtils.isNotBlank((CharSequence)adjustInfo.getRemainText()) && PWidgetUtil.isWholePagination((AbstractPWGridRow)row);
        }
        return this.wholeRowPageRunner.isRowRuntimePagination(adjustInfo, pageHeight, row);
    }

    public boolean isRowChildWidgetPagination(IAdjustHeightSupport childWidget, AbstractPWGridRow row) {
        return this.wholeRowPageRunner.isRowChildWidgetPagination(childWidget, row);
    }
}

