/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.model.widget.runner.grid;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ctrl.kdf.util.style.ShareStyleAttributes;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.StyleAttributes;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.PdIterator;
import kd.bos.print.core.data.field.CollectionField;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.IntegerField;
import kd.bos.print.core.data.field.NullField;
import kd.bos.print.core.data.field.NumberField;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.execute.render.common.linewrap.param.LineWrapParam;
import kd.bos.print.core.model.designer.grid.MergeBlock;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.IPrintWidget;
import kd.bos.print.core.model.widget.StyleAccess;
import kd.bos.print.core.model.widget.grid.AbstractPWGrid;
import kd.bos.print.core.model.widget.grid.AbstractPWGridCell;
import kd.bos.print.core.model.widget.grid.AbstractPWGridRow;
import kd.bos.print.core.model.widget.grid.MergeType;
import kd.bos.print.core.model.widget.grid.datagrid.AbstractPWDataGridRow;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGrid;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGridCell;
import kd.bos.print.core.model.widget.grid.datagrid.PWDetailRow;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.ACellValue;
import kd.bos.print.core.model.widget.grid.datagrid.cellvalue.CellValueField;
import kd.bos.print.core.model.widget.grid.datagrid.context.GridExecuteContext;
import kd.bos.print.core.model.widget.runner.TextRunner;
import kd.bos.print.core.model.widget.runner.grid.AbstractDataGridRunner;
import kd.bos.print.core.model.widget.runner.util.AdjustHeightUtil;
import kd.bos.print.core.plugin.PrintPluginProxy;
import kd.bos.print.core.plugin.event.BeforeOutputRowEvent;

public class AbstractMergeSummaryRunner
extends AbstractDataGridRunner {
    protected Object group;
    protected boolean isNeedhandMergeSummar = true;
    protected boolean isCacheOutput = false;
    private static final String SPLICT = "&";
    private static final String MERGE_BY_SPLIT = ";";

    public void cacheOutput(AbstractPrintWidget outputWidget) {
        PWDataGrid outputGrid = (PWDataGrid)outputWidget;
        GridExecuteContext context = outputGrid.getContext();
        if (this.isOnlyTitleRow(outputGrid) && context.isDetailRowHasOutput()) {
            return;
        }
        this.isCacheOutput = true;
        this.handMergeSummary((PWDataGrid)outputWidget, this.group);
        super.cacheOutput(outputWidget);
    }

    protected void handMergeSummary(PWDataGrid dataGrid, Object group) {
        int lastIndex;
        PWDetailRow firstMergeDetailRow = null;
        int startRowIdx = 0;
        List outputRows = dataGrid.getOutputRows();
        int currentIndex = lastIndex = outputRows.size();
        for (AbstractPWDataGridRow outputRow : outputRows) {
            if (!(outputRow instanceof PWDetailRow)) continue;
            outputRow.setMerged(true);
            break;
        }
        ListIterator listIterator = outputRows.listIterator(lastIndex);
        while (listIterator.hasPrevious()) {
            AbstractPWDataGridRow previous = (AbstractPWDataGridRow)listIterator.previous();
            if (previous instanceof PWDetailRow && previous.getMerged()) {
                startRowIdx = currentIndex;
                firstMergeDetailRow = (PWDetailRow)previous;
                Set<Integer> sumIdxList = this.getSumIndex(firstMergeDetailRow.getMergeSummaryField(), (AbstractPWDataGridRow)firstMergeDetailRow);
                this.mergeCell((AbstractPWDataGridRow)firstMergeDetailRow, dataGrid, startRowIdx, this.getMergeIndex(firstMergeDetailRow.getMergeByField(), (AbstractPWDataGridRow)firstMergeDetailRow), sumIdxList);
            }
            --currentIndex;
        }
    }

    protected void executeDetailRow(PWDataGrid outputGrid, AbstractPWDataGridRow row, PdIterator iterator, boolean executeRemainRow) {
        PrintPluginProxy pluginProxy = ExecuteContext.get().getPluginProxy();
        if (pluginProxy != null) {
            BeforeOutputRowEvent evt = new BeforeOutputRowEvent((AbstractPWGridRow)row, iterator);
            evt.setGrid((AbstractPWGrid)outputGrid);
            pluginProxy.fireBeforeOutputRow(evt);
            if (evt.isCancleOutput()) {
                return;
            }
        }
        boolean merge = false;
        Object current = iterator.current();
        if (current instanceof DataRowSet) {
            Field idField = ((DataRowSet)current).getField("id");
            Boolean mergeValue = (Boolean)outputGrid.getContext().getMergeTypeMap().get(idField.toString());
            merge = mergeValue != null && mergeValue != false;
        }
        String gridds = outputGrid.getDatasource();
        this.executeRow((AbstractPWGrid)outputGrid, (AbstractPWGridRow)row, (ds, field) -> {
            if (StringUtils.equals((CharSequence)gridds, (CharSequence)ds)) {
                Field fieldValue = iterator.getField(field.getField());
                return fieldValue;
            }
            if (!StringUtils.equals((CharSequence)gridds, (CharSequence)ds) && field == null) {
                String[] keys = ds.split("\\.");
                String valueKey = "";
                if (keys.length > 0) {
                    valueKey = keys[keys.length - 1];
                }
                return iterator.getField(valueKey);
            }
            Field fieldValue = this.helper.getDataHelper().getFieldValue(ds, field.getField());
            return fieldValue;
        });
        if (this.isOpenWholeRowPage() && outputGrid.getContext().isRowPagination()) {
            return;
        }
        List outputRows = outputGrid.getOutputRows();
        if (!CollectionUtils.isEmpty((Collection)outputRows)) {
            ((AbstractPWDataGridRow)outputRows.get(outputRows.size() - 1)).setMerged(merge);
        }
        outputGrid.getContext().setDetailRowHasOutput(true);
        if (!executeRemainRow) {
            ++this.detailRowNumber;
            ++this.detailGroupRowNumber;
            this.doStat(iterator);
        }
        if (row.isRemainContent()) {
            this.executeDetailRow(outputGrid, row, iterator, true);
        }
    }

    private void mergeCell(AbstractPWDataGridRow currentRow, PWDataGrid dataGrid, int startRowIdx, List<Integer> mergeColIdxs, Set<Integer> sumIdxs) {
        List outputRows = dataGrid.getOutputRows();
        HashMap<Integer, AbstractPWGridCell> currentRowMergeFieldCells = new HashMap<Integer, AbstractPWGridCell>(mergeColIdxs.size());
        for (Integer mergeColId : mergeColIdxs) {
            currentRowMergeFieldCells.put(mergeColId, currentRow.getCell(mergeColId.intValue()));
        }
        for (int r = startRowIdx; r < outputRows.size(); ++r) {
            AbstractPWDataGridRow row = (AbstractPWDataGridRow)outputRows.get(r);
            if (row instanceof PWDetailRow && !row.getMerged() && !row.isBlankRow()) {
                for (Integer mergeColIdx : mergeColIdxs) {
                    PWDataGridCell mergeFieldCell = (PWDataGridCell)currentRowMergeFieldCells.get(mergeColIdx);
                    PWDataGridCell nextMergeFieldCell = (PWDataGridCell)row.getCell(mergeColIdx.intValue());
                    if (nextMergeFieldCell == null) continue;
                    Rectangle rect = new Rectangle(mergeFieldCell.getRectangle().width, mergeFieldCell.getRectangle().height + nextMergeFieldCell.getRectangle().height);
                    mergeFieldCell.setRectangle(rect);
                    nextMergeFieldCell.setOutputText("");
                    this.borderProcess(row, mergeColIdx);
                }
                for (Integer sumColIdx : sumIdxs) {
                    PWDataGridCell sumCell = (PWDataGridCell)currentRow.getCell(sumColIdx.intValue());
                    PWDataGridCell nextSumCell = (PWDataGridCell)row.getCell(sumColIdx.intValue());
                    if (sumCell == null || nextSumCell == null) continue;
                    sumCell.setRectangle(new Rectangle(sumCell.getRectangle().width, sumCell.getRectangle().height + nextSumCell.getRectangle().height));
                    nextSumCell.setOutputText("");
                    this.borderProcess(row, sumColIdx);
                }
                continue;
            }
            if (row.getMerged()) break;
        }
        this.processMergeRemainText(currentRow, dataGrid, mergeColIdxs, sumIdxs);
    }

    protected void processMergeRemainText(AbstractPWDataGridRow currentRow, PWDataGrid dataGrid, List<Integer> mergeColIdxs, Set<Integer> sumIdxs) {
        if (this.isCacheOutput) {
            this.isCacheOutput = false;
        }
    }

    protected final void mergeSumSplitPageTextProcess(AbstractPWDataGridRow currentRow, PWDataGrid dataGrid, Integer sumColIdx) {
        PWDataGridCell sumCell = (PWDataGridCell)currentRow.getCell(sumColIdx.intValue());
        int h = (int)sumCell.getRectangle().getHeight();
        int w = (int)sumCell.getRectangle().getWidth();
        if (sumCell.getMergeType() == MergeType.Merged) {
            MergeBlock mergeBlock = sumCell.getMergeBlock();
            Dimension mergeInfo = this.getMergeInfo(mergeBlock, (AbstractPWGrid)dataGrid);
            w = mergeInfo.width;
        }
        AdjustHeightUtil.AdjustInfo adjustInfo = AdjustHeightUtil.getInstance().adjustHeight(new LineWrapParam.Builder(sumCell.getOutputText(), sumCell.getLineWrapRule()).style(StyleAccess.getStyle((IPrintWidget)sumCell)).wordFlex(sumCell.isWordFlex()).minW(w).maxW(this.getRelativeContext().getEmptyPage().getRectangle().width).minH(h).maxH(h).build());
        String outputText = adjustInfo.getUsedText();
        sumCell.setOutputText(outputText);
        sumCell.setTextHeight((float)adjustInfo.getTextHeight());
        String remainText = adjustInfo.getRemainText();
        PdIterator gridIterator = dataGrid.getContext().getGridIterator();
        if (gridIterator != null && gridIterator.cursor() != 0 && gridIterator.hasNext()) {
            DataRowSet data = (DataRowSet)gridIterator.current();
            String bindField = sumCell.getBindField();
            if (StringUtils.isNotBlank((CharSequence)remainText) && StringUtils.isNotBlank((CharSequence)bindField)) {
                data.put(bindField, (Field)new TextField(remainText));
            }
        }
    }

    private void borderProcess(AbstractPWDataGridRow row, Integer mergeColIdx) {
        PWDataGridCell leftCell = (PWDataGridCell)row.getCell(mergeColIdx - 1);
        if (leftCell != null) {
            Style leftStyle = leftCell.getStyle();
            StyleAttributes leftSa = leftStyle.getNewAttribute();
            leftSa.setBorderLineStyle(Styles.Position.RIGHT, leftSa.getBorderLineStyle(Styles.Position.LEFT));
            leftCell.setStyle(Styles.getStyle((ShareStyleAttributes)leftSa));
        }
        row.setCell(mergeColIdx.intValue(), null);
    }

    protected LinkedHashSet<Object> getMergeFieldSort(String mergeByField, CollectionField entryField) {
        LinkedHashSet<Object> lhs = new LinkedHashSet<Object>();
        LinkedHashSet<Object> blank = new LinkedHashSet<Object>(16);
        for (DataRowSet drs : entryField.getValue()) {
            Field field = drs.getField(mergeByField);
            Object value = field.getValue();
            String displayVal = field.getDisplayVal();
            if (StringUtils.isNotBlank((Object)displayVal)) {
                value = displayVal;
            }
            if (field instanceof NumberField) {
                try {
                    if (!((NumberField)field).isShowZero() && BigDecimal.ZERO.compareTo(new BigDecimal(value.toString())) == 0) {
                        blank.add(value);
                        continue;
                    }
                    lhs.add(value);
                }
                catch (NumberFormatException ex) {
                    lhs.add(value);
                }
                continue;
            }
            if (StringUtils.isNotBlank((Object)value)) {
                lhs.add(value);
                continue;
            }
            blank.add(value);
        }
        lhs.addAll(blank);
        return lhs;
    }

    protected Map<Object, List<DataRowSet>> packageMergeData(CollectionField collectionField, PWDetailRow detailRow) {
        boolean allCellMerge;
        PWDataGrid outputWidget = (PWDataGrid)this.getOutputWidget();
        List mergeSummaryField = detailRow.getMergeSummaryField();
        String mergeByField = detailRow.getMergeByField();
        int cellCount = detailRow.getCellCount();
        String gridds = outputWidget.getDatasource();
        List rowSetList = collectionField.getValue();
        for (int i = 0; i < cellCount; ++i) {
            PWDataGridCell cell = (PWDataGridCell)detailRow.getCell(i);
            String[] formulaData = cell.getFormulaData();
            if (StringUtils.isNotBlank((CharSequence)cell.getDatasource()) || CollectionUtils.isEmpty((Collection)formulaData)) continue;
            TextRunner runner = (TextRunner)cell.getRunner();
            String bindField = "CELL@Formula-" + i;
            for (DataRowSet dataRowSet : rowSetList) {
                String value = this.getFormulaValue((List)formulaData, (AbstractPrintWidget)outputWidget, (AbstractPrintWidget)cell, this.getWidgetHelper(), (ds, field) -> {
                    if (StringUtils.equals((CharSequence)gridds, (CharSequence)ds)) {
                        Field fieldValue = dataRowSet.getField(field.getField());
                        return fieldValue;
                    }
                    if (!StringUtils.equals((CharSequence)gridds, (CharSequence)ds) && field == null) {
                        String[] keys = ds.split("\\.");
                        String valueKey = "";
                        if (keys.length > 0) {
                            valueKey = keys[keys.length - 1];
                        }
                        return dataRowSet.getField(valueKey);
                    }
                    Field fieldValue = this.helper.getDataHelper().getFieldValue(ds, field.getField());
                    return fieldValue;
                });
                TextField textField = new TextField(value);
                dataRowSet.put(bindField, runner.formatOutputValue((Field)textField));
            }
            cell.setFormulaData(Collections.EMPTY_LIST);
            cell.setDatasource(gridds);
            cell.setBindField(bindField);
            CellValueField cellValueField = new CellValueField(bindField);
            cell.setCellValue((ACellValue)cellValueField);
            if (!cell.isMergeSummary()) continue;
            mergeSummaryField.add(bindField);
        }
        LinkedHashMap<Object, List<DataRowSet>> mergeDataMap = new LinkedHashMap<Object, List<DataRowSet>>(16);
        String[] mergeByFieldArr = mergeByField.split(MERGE_BY_SPLIT);
        for (String string : mergeByFieldArr) {
            mergeSummaryField.remove(string);
        }
        for (DataRowSet row2 : rowSetList) {
            StringBuilder mergeKey = new StringBuilder();
            for (String mergeField : mergeByFieldArr) {
                Field mgByField = row2.getField(mergeField);
                mergeKey = this.getFinallyMergeKey(mergeKey, mgByField);
            }
            List list = (List)mergeDataMap.get(mergeKey.toString());
            if (list == null) {
                ArrayList<DataRowSet> arrayList = new ArrayList<DataRowSet>();
                Field idField = row2.getField("id");
                String pkId = idField.toString();
                if (idField instanceof NullField) {
                    pkId = Uuid8.generateShortUuid();
                    row2.put("id", (Field)new TextField(pkId));
                }
                ((PWDataGrid)this.getOutputWidget()).getContext().getMergeTypeMap().put(pkId, Boolean.TRUE);
                arrayList.add(row2);
                mergeDataMap.put(mergeKey.toString(), arrayList);
                continue;
            }
            list.add(row2);
            DataRowSet firstRow = (DataRowSet)list.get(0);
            for (String field2 : mergeSummaryField) {
                Field firstRowField = firstRow.getField(field2);
                if (firstRowField instanceof NumberField) {
                    Field f2 = row2.getField(field2);
                    if (!(f2 instanceof NullField)) {
                        ((NumberField)firstRowField).add((Object)f2);
                    }
                } else {
                    Field f2 = row2.getField(field2);
                    Object value = f2.getValue();
                    String displayValue = f2.getDisplayVal();
                    if (StringUtils.isNotBlank((Object)displayValue)) {
                        String msDisPlayVal = firstRowField.getDisplayVal();
                        if (StringUtils.isNotBlank((Object)msDisPlayVal)) {
                            firstRowField.setDisplayVal(msDisPlayVal + "," + displayValue);
                        } else {
                            firstRow.put(field2, f2);
                        }
                    } else if (StringUtils.isNotBlank((Object)value)) {
                        Object msVal = firstRowField.getValue();
                        if (StringUtils.isNotBlank((Object)msVal)) {
                            firstRow.put(field2, (Field)new TextField(msVal + "," + value));
                        } else {
                            firstRow.put(field2, f2);
                        }
                    }
                }
                row2.put(field2, (Field)NullField.get());
            }
        }
        StringBuilder blankKey = null;
        for (int i = 0; i < mergeByFieldArr.length; ++i) {
            if (blankKey == null) {
                blankKey = new StringBuilder(" ");
                continue;
            }
            blankKey.append(SPLICT).append(" ");
        }
        List remove = (List)mergeDataMap.remove(String.valueOf(blankKey));
        if (!CollectionUtils.isEmpty((Collection)remove)) {
            mergeDataMap.put(String.valueOf(blankKey), remove);
        }
        if (allCellMerge = this.isAllCellMerge(detailRow)) {
            mergeDataMap.forEach((key, item) -> {
                int index = 0;
                Iterator iterator = item.iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                    if (index != 0) {
                        iterator.remove();
                    }
                    ++index;
                }
            });
        }
        mergeDataMap.values().forEach(rows -> {
            if (rows.size() > 0) {
                ListIterator listIterator = rows.listIterator(1);
                while (listIterator.hasNext()) {
                    DataRowSet mergeByRow = (DataRowSet)listIterator.next();
                    for (String mergeBy : mergeByFieldArr) {
                        Field field = mergeByRow.getField(mergeBy);
                        field.setDisplayVal("");
                        mergeByRow.put(mergeBy, field);
                    }
                }
            }
        });
        AtomicInteger atomicInteger = new AtomicInteger(1);
        if (allCellMerge) {
            mergeDataMap.values().stream().filter(f -> f.size() > 0).forEach(rows -> ((DataRowSet)rows.get(0)).put("seq", (Field)new IntegerField(Integer.valueOf(seq.getAndIncrement()))));
        } else {
            mergeDataMap.values().stream().flatMap(Collection::stream).forEach(row -> row.put("seq", (Field)new IntegerField(Integer.valueOf(seq.getAndIncrement()))));
        }
        return mergeDataMap;
    }

    private StringBuilder getFinallyMergeKey(StringBuilder mergeKey, Field mgByField) {
        if (mergeKey != null) {
            if (this.getMergeKey(mgByField) instanceof NullField) {
                mergeKey.append(SPLICT).append(" ");
            } else {
                mergeKey.append(SPLICT).append(this.getMergeKey(mgByField));
            }
        } else {
            mergeKey = this.getMergeKey(mgByField) instanceof NullField ? new StringBuilder(" ") : new StringBuilder(String.valueOf(this.getMergeKey(mgByField)));
        }
        return mergeKey;
    }

    private Object getMergeKey(Field field) {
        Object value = field.getValue();
        String displayVal = field.getDisplayVal();
        if (StringUtils.isNotBlank((Object)displayVal)) {
            value = displayVal;
        }
        if (field instanceof NumberField) {
            try {
                if (!((NumberField)field).isShowZero() && BigDecimal.ZERO.compareTo(new BigDecimal(value.toString())) == 0) {
                    return NullField.get();
                }
                return value;
            }
            catch (NumberFormatException ex) {
                return value;
            }
        }
        if (StringUtils.isNotBlank((Object)value)) {
            return value;
        }
        return NullField.get();
    }

    private boolean isAllCellMerge(PWDetailRow detailRow) {
        ArrayList mergeByField = new ArrayList(10);
        Collections.addAll(mergeByField, detailRow.getMergeByField().split(MERGE_BY_SPLIT));
        List mergeSummaryField = detailRow.getMergeSummaryField();
        if (mergeSummaryField == null) {
            mergeSummaryField = Collections.EMPTY_LIST;
        }
        int cellCount = detailRow.getCellCount();
        boolean flag = true;
        for (int i = 0; i < cellCount; ++i) {
            PWDataGridCell cell = (PWDataGridCell)detailRow.getCell(i);
            String datasource = cell.getDatasource();
            String bindField = cell.getBindField();
            if (cell.isMergeSummary() || StringUtils.isNotBlank((CharSequence)datasource) && (mergeByField.contains(bindField) || mergeSummaryField.contains(bindField))) continue;
            flag = false;
        }
        return flag;
    }

    private Set<Integer> getSumIndex(List<String> mergeSummaryField, AbstractPWDataGridRow row) {
        HashSet<Integer> sumIdxList = new HashSet<Integer>();
        String mergeByField = ((PWDetailRow)row).getMergeByField();
        ArrayList mergeByFieldList = new ArrayList(10);
        Collections.addAll(mergeByFieldList, mergeByField.split(MERGE_BY_SPLIT));
        for (int i = 0; i < row.getCellCount(); ++i) {
            PWDataGridCell cell = (PWDataGridCell)row.getCell(i);
            if (cell == null) continue;
            if (mergeSummaryField != null && mergeSummaryField.contains(cell.getBindField()) && !mergeByFieldList.contains(cell.getBindField())) {
                sumIdxList.add(i);
            }
            if (!cell.isMergeSummary() || mergeByFieldList.contains(cell.getBindField())) continue;
            sumIdxList.add(i);
        }
        return sumIdxList;
    }

    private List<Integer> getMergeIndex(String mergeField, AbstractPWDataGridRow row) {
        ArrayList<Integer> mergeIndexList = new ArrayList<Integer>(10);
        ArrayList mergeFieldList = new ArrayList(10);
        Collections.addAll(mergeFieldList, mergeField.split(MERGE_BY_SPLIT));
        for (String mgField : mergeFieldList) {
            for (int i = 0; i < row.getCellCount(); ++i) {
                PWDataGridCell cell = (PWDataGridCell)row.getCell(i);
                if (cell == null || !mgField.equals(cell.getBindField()) && !cell.isMergeBy()) continue;
                mergeIndexList.add(i);
            }
        }
        return mergeIndexList;
    }
}

