/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.control;

import com.alibaba.fastjson.JSONArray;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.print.api.facade.IPrintControlModelFacade;
import kd.bos.print.business.control.BaseModelReader;
import org.dom4j.Document;
import org.dom4j.Element;

public class PrintControlReader
extends BaseModelReader {
    private List<IPrintControlModelFacade> controlModelFacades;

    public List<IPrintControlModelFacade> getControlModelFacades() {
        if (this.controlModelFacades == null) {
            this.controlModelFacades = Collections.emptyList();
        }
        return this.controlModelFacades;
    }

    public void setControlModelFacades(List<IPrintControlModelFacade> controlModelFacades) {
        this.controlModelFacades = controlModelFacades;
    }

    @Override
    protected Object read(Element element) throws Exception {
        return this.read(element, null);
    }

    @Override
    protected Object read(Element element, String ext) throws Exception {
        ArrayList<Map> categoryList = new ArrayList<Map>();
        Iterator iterator = element.elementIterator();
        while (iterator.hasNext()) {
            Element categoryEl = (Element)iterator.next();
            Map category = this.elementAttributeToObj(categoryEl, "PrintDesignModel");
            categoryList.add(category);
            List controlEls = categoryEl.elements();
            ArrayList<Map> controls = new ArrayList<Map>(10);
            category.put(categoryEl.getName(), controls);
            for (Element e : controlEls) {
                String controlName = e.attributeValue("Id");
                Map control = this.readControl(controlName, ext);
                controls.add(control);
            }
        }
        return categoryList;
    }

    private Map readControl(String key, String ext) throws Exception {
        Map control;
        String name = "/control/" + key + ".xml";
        try (InputStream in = this.getClass().getResourceAsStream(name);){
            Document doc = this.getDocument(in);
            Element rootElement = doc.getRootElement();
            if (ext != null) {
                this.extModelParser(String.format("/control/" + key + "_%s.xml", ext), ext, rootElement);
            }
            control = this.elementAttributeToObj(rootElement, key);
            this.loadExtProp(control, rootElement, key);
            Element propertiesEl = rootElement.element("Properties");
            ArrayList<Map> properties = new ArrayList<Map>();
            control.put(propertiesEl.getName(), properties);
            Iterator groupIterator = propertiesEl.elementIterator();
            while (groupIterator.hasNext()) {
                Element groupEl = (Element)groupIterator.next();
                Map groupNode = this.elementAttributeToObj(groupEl, key);
                List elements = groupEl.elements();
                ArrayList<Map> propNodes = new ArrayList<Map>();
                for (Element groupChildEl : elements) {
                    if ("Nodes".equals(groupChildEl.getName())) {
                        Iterator iterator = groupChildEl.elementIterator();
                        while (iterator.hasNext()) {
                            Element propEl = (Element)iterator.next();
                            if ("InheritProperty".equals(propEl.getName())) {
                                List<Map> inheritProperties = this.getInheritProperties(propEl, key, ext);
                                this.getControlModelFacades().forEach(facade -> facade.beforeAddProps(inheritProperties));
                                propNodes.addAll(inheritProperties);
                                continue;
                            }
                            Map property = this.elementToObject(propEl, key);
                            this.getControlModelFacades().forEach(facade -> facade.beforeAddProp(property));
                            if (property == null || property.isEmpty()) continue;
                            propNodes.add(property);
                        }
                        continue;
                    }
                    groupNode.put(groupChildEl.getName(), this.getElementData(groupChildEl, key));
                }
                groupNode.put("Nodes", propNodes);
                properties.add(groupNode);
            }
        }
        return control;
    }

    private void loadExtProp(Map control, Element rootElement, String modelType) {
        Element aDefault = rootElement.element("Default");
        if (aDefault != null) {
            control.put("Default", this.getElementData(aDefault, modelType));
        }
        if ((aDefault = rootElement.element("Accept")) != null) {
            control.put("Accept", this.getElementData(aDefault, modelType));
        }
    }

    private List<Map> getInheritProperties(Element propEl, String modelType, String ext) throws Exception {
        String text;
        String ref = propEl.attributeValue("Ref");
        List<Map> inheritProperties = this.readCommonProp(ref, ext);
        List modifyList = propEl.elements("ModifyProperty");
        HashMap modifyMap = null;
        if (modifyList != null && modifyList.size() > 0) {
            modifyMap = new HashMap(4);
            for (Element element : modifyList) {
                Map map = this.elementToObject(element, modelType);
                modifyMap.put(map.get("Id"), map);
            }
        }
        Element remove = propEl.element("Remove");
        Element use = propEl.element("Use");
        JSONArray removeProps = null;
        JSONArray useProps = null;
        if (remove != null) {
            text = remove.getText();
            removeProps = JSONArray.parseArray((String)text);
        } else if (use != null) {
            text = use.getText();
            useProps = JSONArray.parseArray((String)text);
        }
        Iterator<Map> iterator = inheritProperties.iterator();
        while (iterator.hasNext()) {
            Map map;
            Map next = iterator.next();
            Object id = next.get("Id");
            if (removeProps != null && removeProps.contains(id)) {
                iterator.remove();
                continue;
            }
            if (useProps != null && !useProps.contains(id)) {
                iterator.remove();
                continue;
            }
            if (modifyMap == null || (map = (Map)modifyMap.get(id)) == null) continue;
            next.putAll(map);
        }
        return inheritProperties;
    }
}

