/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.asn1.cmp;

import cn.tca.TopBasicCrypto.asn1.ASN1Encodable;
import cn.tca.TopBasicCrypto.asn1.ASN1EncodableVector;
import cn.tca.TopBasicCrypto.asn1.ASN1Sequence;
import cn.tca.TopBasicCrypto.asn1.DERInteger;
import cn.tca.TopBasicCrypto.asn1.DERObject;
import cn.tca.TopBasicCrypto.asn1.DERSequence;
import cn.tca.TopBasicCrypto.asn1.cmp.PKIFreeText;
import cn.tca.TopBasicCrypto.asn1.cmp.PKIStatusInfo;
import java.util.Enumeration;

public class ErrorMsgContent
extends ASN1Encodable {
    private PKIStatusInfo pkiStatusInfo;
    private DERInteger errorCode;
    private PKIFreeText errorDetails;

    private ErrorMsgContent(ASN1Sequence seq) {
        Enumeration en = seq.getObjects();
        this.pkiStatusInfo = PKIStatusInfo.getInstance(en.nextElement());
        while (en.hasMoreElements()) {
            Object o = en.nextElement();
            if (o instanceof DERInteger) {
                this.errorCode = DERInteger.getInstance(o);
                continue;
            }
            this.errorDetails = PKIFreeText.getInstance(o);
        }
    }

    public static ErrorMsgContent getInstance(Object o) {
        if (o instanceof ErrorMsgContent) {
            return (ErrorMsgContent)o;
        }
        if (o instanceof ASN1Sequence) {
            return new ErrorMsgContent((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("Invalid object: " + o.getClass().getName());
    }

    public ErrorMsgContent(PKIStatusInfo pkiStatusInfo) {
        this(pkiStatusInfo, null, null);
    }

    public ErrorMsgContent(PKIStatusInfo pkiStatusInfo, DERInteger errorCode, PKIFreeText errorDetails) {
        if (pkiStatusInfo == null) {
            throw new IllegalArgumentException("'pkiStatusInfo' cannot be null");
        }
        this.pkiStatusInfo = pkiStatusInfo;
        this.errorCode = errorCode;
        this.errorDetails = errorDetails;
    }

    public PKIStatusInfo getPKIStatusInfo() {
        return this.pkiStatusInfo;
    }

    public DERInteger getErrorCode() {
        return this.errorCode;
    }

    public PKIFreeText getErrorDetails() {
        return this.errorDetails;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.pkiStatusInfo);
        this.addOptional(v, this.errorCode);
        this.addOptional(v, this.errorDetails);
        return new DERSequence(v);
    }

    private void addOptional(ASN1EncodableVector v, ASN1Encodable obj) {
        if (obj != null) {
            v.add(obj);
        }
    }
}

