/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.bcpg.sig;

import cn.tca.TopBasicCrypto.bcpg.SignatureSubpacket;
import cn.tca.TopBasicCrypto.util.Strings;
import java.io.ByteArrayOutputStream;

public class NotationData
extends SignatureSubpacket {
    public static final int HEADER_FLAG_LENGTH = 4;
    public static final int HEADER_NAME_LENGTH = 2;
    public static final int HEADER_VALUE_LENGTH = 2;

    public NotationData(boolean critical, byte[] data) {
        super(20, critical, data);
    }

    public NotationData(boolean critical, boolean humanReadable, String notationName, String notationValue) {
        super(20, critical, NotationData.createData(humanReadable, notationName, notationValue));
    }

    private static byte[] createData(boolean humanReadable, String notationName, String notationValue) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(humanReadable ? 128 : 0);
        out.write(0);
        out.write(0);
        out.write(0);
        byte[] valueData = null;
        byte[] nameData = Strings.toUTF8ByteArray(notationName);
        int nameLength = Math.min(nameData.length, 255);
        valueData = Strings.toUTF8ByteArray(notationValue);
        int valueLength = Math.min(valueData.length, 255);
        out.write(nameLength >>> 8 & 0xFF);
        out.write(nameLength >>> 0 & 0xFF);
        out.write(valueLength >>> 8 & 0xFF);
        out.write(valueLength >>> 0 & 0xFF);
        out.write(nameData, 0, nameLength);
        out.write(valueData, 0, valueLength);
        return out.toByteArray();
    }

    public boolean isHumanReadable() {
        return this.data[0] == -128;
    }

    public String getNotationName() {
        int nameLength = (this.data[4] << 8) + (this.data[5] << 0);
        byte[] bName = new byte[nameLength];
        System.arraycopy(this.data, 8, bName, 0, nameLength);
        return Strings.fromUTF8ByteArray(bName);
    }

    public String getNotationValue() {
        return Strings.fromUTF8ByteArray(this.getNotationValueBytes());
    }

    public byte[] getNotationValueBytes() {
        int nameLength = (this.data[4] << 8) + (this.data[5] << 0);
        int valueLength = (this.data[6] << 8) + (this.data[7] << 0);
        byte[] bValue = new byte[valueLength];
        System.arraycopy(this.data, 8 + nameLength, bValue, 0, valueLength);
        return bValue;
    }
}

