/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.cert.crmf;

import cn.tca.TopBasicCrypto.asn1.ASN1Encodable;
import cn.tca.TopBasicCrypto.asn1.ASN1ObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.cms.CMSObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.cms.ContentInfo;
import cn.tca.TopBasicCrypto.asn1.cms.EnvelopedData;
import cn.tca.TopBasicCrypto.asn1.crmf.CRMFObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.crmf.EncryptedKey;
import cn.tca.TopBasicCrypto.asn1.crmf.PKIArchiveOptions;
import cn.tca.TopBasicCrypto.cert.crmf.Control;
import cn.tca.TopBasicCrypto.cms.CMSEnvelopedData;

public class PKIArchiveControl
implements Control {
    public static final int encryptedPrivKey = 0;
    public static final int keyGenParameters = 1;
    public static final int archiveRemGenPrivKey = 2;
    private static final ASN1ObjectIdentifier type = CRMFObjectIdentifiers.id_regCtrl_pkiArchiveOptions;
    private final PKIArchiveOptions pkiArchiveOptions;

    public PKIArchiveControl(PKIArchiveOptions pkiArchiveOptions) {
        this.pkiArchiveOptions = pkiArchiveOptions;
    }

    public ASN1ObjectIdentifier getType() {
        return type;
    }

    public ASN1Encodable getValue() {
        return this.pkiArchiveOptions;
    }

    public int getArchiveType() {
        return this.pkiArchiveOptions.getType();
    }

    public boolean isEnvelopedData() {
        EncryptedKey encKey = EncryptedKey.getInstance(this.pkiArchiveOptions.getValue());
        return !encKey.isEncryptedValue();
    }

    public CMSEnvelopedData getEnvelopedData() {
        EncryptedKey encKey = EncryptedKey.getInstance(this.pkiArchiveOptions.getValue());
        EnvelopedData data = EnvelopedData.getInstance(encKey.getValue());
        return new CMSEnvelopedData(new ContentInfo(CMSObjectIdentifiers.envelopedData, data));
    }
}

