/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.cert.crmf;

import cn.tca.TopBasicCrypto.asn1.cmp.PBMParameter;
import cn.tca.TopBasicCrypto.asn1.crmf.PKMACValue;
import cn.tca.TopBasicCrypto.asn1.x509.SubjectPublicKeyInfo;
import cn.tca.TopBasicCrypto.cert.crmf.CRMFException;
import cn.tca.TopBasicCrypto.cert.crmf.PKMACBuilder;
import cn.tca.TopBasicCrypto.operator.MacCalculator;
import cn.tca.TopBasicCrypto.util.Arrays;
import java.io.IOException;
import java.io.OutputStream;

class PKMACValueVerifier {
    private final PKMACBuilder builder;

    public PKMACValueVerifier(PKMACBuilder builder) {
        this.builder = builder;
    }

    public boolean isValid(PKMACValue value, char[] password, SubjectPublicKeyInfo keyInfo) throws CRMFException {
        this.builder.setParameters(PBMParameter.getInstance(value.getAlgId().getParameters()));
        MacCalculator calculator = this.builder.build(password);
        OutputStream macOut = calculator.getOutputStream();
        try {
            macOut.write(keyInfo.getDEREncoded());
            macOut.close();
        }
        catch (IOException e) {
            throw new CRMFException("exception encoding mac input: " + e.getMessage(), e);
        }
        return Arrays.areEqual(calculator.getMac(), value.getValue().getBytes());
    }
}

