/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.cert.crmf.jcajce;

import cn.tca.TopBasicCrypto.asn1.crmf.CertReqMsg;
import cn.tca.TopBasicCrypto.asn1.x500.X500Name;
import cn.tca.TopBasicCrypto.asn1.x509.SubjectPublicKeyInfo;
import cn.tca.TopBasicCrypto.cert.crmf.CRMFException;
import cn.tca.TopBasicCrypto.cert.crmf.CertificateRequestMessage;
import cn.tca.TopBasicCrypto.cert.crmf.jcajce.CRMFHelper;
import cn.tca.TopBasicCrypto.jcajce.DefaultJcaJceHelper;
import cn.tca.TopBasicCrypto.jcajce.NamedJcaJceHelper;
import cn.tca.TopBasicCrypto.jcajce.ProviderJcaJceHelper;
import java.security.Provider;
import java.security.PublicKey;
import javax.security.auth.x500.X500Principal;

public class JcaCertificateRequestMessage
extends CertificateRequestMessage {
    private CRMFHelper helper = new CRMFHelper(new DefaultJcaJceHelper());

    public JcaCertificateRequestMessage(CertificateRequestMessage certReqMsg) {
        this(certReqMsg.toASN1Structure());
    }

    public JcaCertificateRequestMessage(CertReqMsg certReqMsg) {
        super(certReqMsg);
    }

    public JcaCertificateRequestMessage setProvider(String providerName) {
        this.helper = new CRMFHelper(new NamedJcaJceHelper(providerName));
        return this;
    }

    public JcaCertificateRequestMessage setProvider(Provider provider) {
        this.helper = new CRMFHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public X500Principal getSubjectX500Principal() {
        X500Name subject = this.getCertTemplate().getSubject();
        if (subject != null) {
            return new X500Principal(subject.getDEREncoded());
        }
        return null;
    }

    public PublicKey getPublicKey() throws CRMFException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = this.getCertTemplate().getPublicKey();
        if (subjectPublicKeyInfo != null) {
            return this.helper.toPublicKey(subjectPublicKeyInfo);
        }
        return null;
    }
}

