/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.cert.ocsp;

import cn.tca.TopBasicCrypto.asn1.DERGeneralizedTime;
import cn.tca.TopBasicCrypto.asn1.ocsp.RevokedInfo;
import cn.tca.TopBasicCrypto.asn1.x509.CRLReason;
import cn.tca.TopBasicCrypto.cert.ocsp.CertificateStatus;
import cn.tca.TopBasicCrypto.cert.ocsp.OCSPUtils;
import java.util.Date;

public class RevokedStatus
implements CertificateStatus {
    RevokedInfo info;

    public RevokedStatus(RevokedInfo info) {
        this.info = info;
    }

    public RevokedStatus(Date revocationDate, int reason) {
        this.info = new RevokedInfo(new DERGeneralizedTime(revocationDate), new CRLReason(reason));
    }

    public Date getRevocationTime() {
        return OCSPUtils.extractDate(this.info.getRevocationTime());
    }

    public boolean hasRevocationReason() {
        return this.info.getRevocationReason() != null;
    }

    public int getRevocationReason() {
        if (this.info.getRevocationReason() == null) {
            throw new IllegalStateException("attempt to get a reason where none is available");
        }
        return this.info.getRevocationReason().getValue().intValue();
    }
}

