/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.cms;

import cn.tca.TopBasicCrypto.asn1.ASN1OctetString;
import cn.tca.TopBasicCrypto.asn1.DERObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.cms.IssuerAndSerialNumber;
import cn.tca.TopBasicCrypto.asn1.cms.KeyTransRecipientInfo;
import cn.tca.TopBasicCrypto.asn1.cms.RecipientIdentifier;
import cn.tca.TopBasicCrypto.asn1.pkcs.PKCSObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.cms.AuthAttributesProvider;
import cn.tca.TopBasicCrypto.cms.CMSEnvelopedHelper;
import cn.tca.TopBasicCrypto.cms.CMSException;
import cn.tca.TopBasicCrypto.cms.CMSSecureReadable;
import cn.tca.TopBasicCrypto.cms.CMSTypedStream;
import cn.tca.TopBasicCrypto.cms.CMSUtils;
import cn.tca.TopBasicCrypto.cms.KeyTransRecipient;
import cn.tca.TopBasicCrypto.cms.KeyTransRecipientId;
import cn.tca.TopBasicCrypto.cms.Recipient;
import cn.tca.TopBasicCrypto.cms.RecipientInformation;
import cn.tca.TopBasicCrypto.cms.RecipientOperator;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.ProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class KeyTransRecipientInformation
extends RecipientInformation {
    private KeyTransRecipientInfo info;

    KeyTransRecipientInformation(KeyTransRecipientInfo info, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        super(info.getKeyEncryptionAlgorithm(), messageAlgorithm, secureReadable, additionalData);
        this.info = info;
        RecipientIdentifier r = info.getRecipientIdentifier();
        if (r.isTagged()) {
            ASN1OctetString octs = ASN1OctetString.getInstance(r.getId());
            this.rid = new KeyTransRecipientId(octs.getOctets());
        } else {
            IssuerAndSerialNumber iAnds = IssuerAndSerialNumber.getInstance(r.getId());
            this.rid = new KeyTransRecipientId(iAnds.getName(), iAnds.getSerialNumber().getValue());
        }
    }

    private String getExchangeEncryptionAlgorithmName(DERObjectIdentifier oid) {
        if (PKCSObjectIdentifiers.rsaEncryption.equals(oid)) {
            return "RSA/ECB/PKCS1Padding";
        }
        return oid.getId();
    }

    protected Key getSessionKey(Key receiverPrivateKey, Provider prov) throws CMSException {
        CMSEnvelopedHelper helper = CMSEnvelopedHelper.INSTANCE;
        String keyExchangeAlgorithm = this.getExchangeEncryptionAlgorithmName(this.keyEncAlg.getObjectId());
        try {
            Key sKey = null;
            Cipher keyCipher = helper.createAsymmetricCipher(keyExchangeAlgorithm, prov);
            byte[] encryptedKeyBytes = this.info.getEncryptedKey().getOctets();
            String contentAlgorithmName = this.getContentAlgorithmName();
            try {
                keyCipher.init(4, receiverPrivateKey);
                sKey = keyCipher.unwrap(encryptedKeyBytes, contentAlgorithmName, 3);
            }
            catch (GeneralSecurityException generalSecurityException) {
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (ProviderException providerException) {
                // empty catch block
            }
            if (sKey == null) {
                keyCipher.init(2, receiverPrivateKey);
                sKey = new SecretKeySpec(keyCipher.doFinal(encryptedKeyBytes), contentAlgorithmName);
            }
            return sKey;
        }
        catch (NoSuchAlgorithmException e) {
            throw new CMSException("can't find algorithm.", e);
        }
        catch (InvalidKeyException e) {
            throw new CMSException("key invalid in message.", e);
        }
        catch (NoSuchPaddingException e) {
            throw new CMSException("required padding not supported.", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new CMSException("illegal blocksize in message.", e);
        }
        catch (BadPaddingException e) {
            throw new CMSException("bad padding in message.", e);
        }
    }

    public CMSTypedStream getContentStream(Key key, String prov) throws CMSException, NoSuchProviderException {
        return this.getContentStream(key, CMSUtils.getProvider(prov));
    }

    public CMSTypedStream getContentStream(Key key, Provider prov) throws CMSException {
        Key sKey = this.getSessionKey(key, prov);
        return this.getContentFromSessionKey(sKey, prov);
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException {
        return ((KeyTransRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

