/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.cms;

import cn.tca.TopBasicCrypto.asn1.ASN1OctetString;
import cn.tca.TopBasicCrypto.asn1.ASN1Sequence;
import cn.tca.TopBasicCrypto.asn1.DEREncodable;
import cn.tca.TopBasicCrypto.asn1.DERObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.cms.PasswordRecipientInfo;
import cn.tca.TopBasicCrypto.asn1.pkcs.PBKDF2Params;
import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.cms.AuthAttributesProvider;
import cn.tca.TopBasicCrypto.cms.CMSAlgorithm;
import cn.tca.TopBasicCrypto.cms.CMSEnvelopedHelper;
import cn.tca.TopBasicCrypto.cms.CMSException;
import cn.tca.TopBasicCrypto.cms.CMSPBEKey;
import cn.tca.TopBasicCrypto.cms.CMSSecureReadable;
import cn.tca.TopBasicCrypto.cms.CMSTypedStream;
import cn.tca.TopBasicCrypto.cms.CMSUtils;
import cn.tca.TopBasicCrypto.cms.PasswordRecipient;
import cn.tca.TopBasicCrypto.cms.PasswordRecipientId;
import cn.tca.TopBasicCrypto.cms.Recipient;
import cn.tca.TopBasicCrypto.cms.RecipientInformation;
import cn.tca.TopBasicCrypto.cms.RecipientOperator;
import cn.tca.TopBasicCrypto.crypto.PBEParametersGenerator;
import cn.tca.TopBasicCrypto.crypto.generators.PKCS5S2ParametersGenerator;
import cn.tca.TopBasicCrypto.crypto.params.KeyParameter;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class PasswordRecipientInformation
extends RecipientInformation {
    static Map KEYSIZES = new HashMap();
    static Map BLOCKSIZES = new HashMap();
    private PasswordRecipientInfo info;

    PasswordRecipientInformation(PasswordRecipientInfo info, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        super(info.getKeyEncryptionAlgorithm(), messageAlgorithm, secureReadable, additionalData);
        this.info = info;
        this.rid = new PasswordRecipientId();
    }

    public String getKeyDerivationAlgOID() {
        if (this.info.getKeyDerivationAlgorithm() != null) {
            return this.info.getKeyDerivationAlgorithm().getObjectId().getId();
        }
        return null;
    }

    public byte[] getKeyDerivationAlgParams() {
        try {
            DEREncodable params;
            if (this.info.getKeyDerivationAlgorithm() != null && (params = this.info.getKeyDerivationAlgorithm().getParameters()) != null) {
                return params.getDERObject().getEncoded();
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("exception getting encryption parameters " + e);
        }
    }

    public AlgorithmParameters getKeyDerivationAlgParameters(String provider) throws NoSuchProviderException {
        return this.getKeyDerivationAlgParameters(CMSUtils.getProvider(provider));
    }

    public AlgorithmParameters getKeyDerivationAlgParameters(Provider provider) {
        try {
            DEREncodable params;
            if (this.info.getKeyDerivationAlgorithm() != null && (params = this.info.getKeyDerivationAlgorithm().getParameters()) != null) {
                AlgorithmParameters algP = AlgorithmParameters.getInstance(this.info.getKeyDerivationAlgorithm().getObjectId().toString(), provider);
                algP.init(params.getDERObject().getEncoded());
                return algP;
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("exception getting encryption parameters " + e);
        }
    }

    public CMSTypedStream getContentStream(Key key, String prov) throws CMSException, NoSuchProviderException {
        return this.getContentStream(key, CMSUtils.getProvider(prov));
    }

    public CMSTypedStream getContentStream(Key key, Provider prov) throws CMSException {
        try {
            CMSEnvelopedHelper helper = CMSEnvelopedHelper.INSTANCE;
            AlgorithmIdentifier kekAlg = AlgorithmIdentifier.getInstance(this.info.getKeyEncryptionAlgorithm());
            ASN1Sequence kekAlgParams = (ASN1Sequence)kekAlg.getParameters();
            String kekAlgName = DERObjectIdentifier.getInstance(kekAlgParams.getObjectAt(0)).getId();
            String wrapAlgName = helper.getRFC3211WrapperName(kekAlgName);
            Cipher keyCipher = helper.createSymmetricCipher(wrapAlgName, prov);
            IvParameterSpec ivSpec = new IvParameterSpec(ASN1OctetString.getInstance(kekAlgParams.getObjectAt(1)).getOctets());
            keyCipher.init(4, (Key)new SecretKeySpec(((CMSPBEKey)key).getEncoded(kekAlgName), kekAlgName), ivSpec);
            Key sKey = keyCipher.unwrap(this.info.getEncryptedKey().getOctets(), this.getContentAlgorithmName(), 3);
            return this.getContentFromSessionKey(sKey, prov);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CMSException("can't find algorithm.", e);
        }
        catch (InvalidKeyException e) {
            throw new CMSException("key invalid in message.", e);
        }
        catch (NoSuchPaddingException e) {
            throw new CMSException("required padding not supported.", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CMSException("invalid iv.", e);
        }
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        byte[] derivedKey;
        PasswordRecipient pbeRecipient = (PasswordRecipient)recipient;
        AlgorithmIdentifier kekAlg = AlgorithmIdentifier.getInstance(this.info.getKeyEncryptionAlgorithm());
        ASN1Sequence kekAlgParams = (ASN1Sequence)kekAlg.getParameters();
        DERObjectIdentifier kekAlgName = DERObjectIdentifier.getInstance(kekAlgParams.getObjectAt(0));
        PBKDF2Params params = PBKDF2Params.getInstance(this.info.getKeyDerivationAlgorithm().getParameters());
        int keySize = (Integer)KEYSIZES.get(kekAlgName);
        if (pbeRecipient.getPasswordConversionScheme() == 0) {
            PKCS5S2ParametersGenerator gen = new PKCS5S2ParametersGenerator();
            gen.init(PBEParametersGenerator.PKCS5PasswordToBytes(pbeRecipient.getPassword()), params.getSalt(), params.getIterationCount().intValue());
            derivedKey = ((KeyParameter)gen.generateDerivedParameters(keySize)).getKey();
        } else {
            PKCS5S2ParametersGenerator gen = new PKCS5S2ParametersGenerator();
            gen.init(PBEParametersGenerator.PKCS5PasswordToUTF8Bytes(pbeRecipient.getPassword()), params.getSalt(), params.getIterationCount().intValue());
            derivedKey = ((KeyParameter)gen.generateDerivedParameters(keySize)).getKey();
        }
        return pbeRecipient.getRecipientOperator(AlgorithmIdentifier.getInstance(kekAlg.getParameters()), this.messageAlgorithm, derivedKey, this.info.getEncryptedKey().getOctets());
    }

    static {
        BLOCKSIZES.put(CMSAlgorithm.DES_EDE3_CBC, new Integer(8));
        BLOCKSIZES.put(CMSAlgorithm.AES128_CBC, new Integer(16));
        BLOCKSIZES.put(CMSAlgorithm.AES192_CBC, new Integer(16));
        BLOCKSIZES.put(CMSAlgorithm.AES256_CBC, new Integer(16));
        KEYSIZES.put(CMSAlgorithm.DES_EDE3_CBC, new Integer(192));
        KEYSIZES.put(CMSAlgorithm.AES128_CBC, new Integer(128));
        KEYSIZES.put(CMSAlgorithm.AES192_CBC, new Integer(192));
        KEYSIZES.put(CMSAlgorithm.AES256_CBC, new Integer(256));
    }
}

