/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.crypto.tls;

import cn.tca.TopBasicCrypto.crypto.CryptoException;
import cn.tca.TopBasicCrypto.crypto.params.AsymmetricKeyParameter;
import cn.tca.TopBasicCrypto.crypto.params.DSAPrivateKeyParameters;
import cn.tca.TopBasicCrypto.crypto.params.ECPrivateKeyParameters;
import cn.tca.TopBasicCrypto.crypto.params.RSAKeyParameters;
import cn.tca.TopBasicCrypto.crypto.tls.Certificate;
import cn.tca.TopBasicCrypto.crypto.tls.TlsClientContext;
import cn.tca.TopBasicCrypto.crypto.tls.TlsDSSSigner;
import cn.tca.TopBasicCrypto.crypto.tls.TlsECDSASigner;
import cn.tca.TopBasicCrypto.crypto.tls.TlsFatalAlert;
import cn.tca.TopBasicCrypto.crypto.tls.TlsRSASigner;
import cn.tca.TopBasicCrypto.crypto.tls.TlsSigner;
import cn.tca.TopBasicCrypto.crypto.tls.TlsSignerCredentials;
import java.io.IOException;

public class DefaultTlsSignerCredentials
implements TlsSignerCredentials {
    protected TlsClientContext context;
    protected Certificate clientCert;
    protected AsymmetricKeyParameter clientPrivateKey;
    protected TlsSigner clientSigner;

    public DefaultTlsSignerCredentials(TlsClientContext context, Certificate clientCertificate, AsymmetricKeyParameter clientPrivateKey) {
        if (clientCertificate == null) {
            throw new IllegalArgumentException("'clientCertificate' cannot be null");
        }
        if (clientCertificate.certs.length == 0) {
            throw new IllegalArgumentException("'clientCertificate' cannot be empty");
        }
        if (clientPrivateKey == null) {
            throw new IllegalArgumentException("'clientPrivateKey' cannot be null");
        }
        if (!clientPrivateKey.isPrivate()) {
            throw new IllegalArgumentException("'clientPrivateKey' must be private");
        }
        if (clientPrivateKey instanceof RSAKeyParameters) {
            this.clientSigner = new TlsRSASigner();
        } else if (clientPrivateKey instanceof DSAPrivateKeyParameters) {
            this.clientSigner = new TlsDSSSigner();
        } else if (clientPrivateKey instanceof ECPrivateKeyParameters) {
            this.clientSigner = new TlsECDSASigner();
        } else {
            throw new IllegalArgumentException("'clientPrivateKey' type not supported: " + clientPrivateKey.getClass().getName());
        }
        this.context = context;
        this.clientCert = clientCertificate;
        this.clientPrivateKey = clientPrivateKey;
    }

    public Certificate getCertificate() {
        return this.clientCert;
    }

    public byte[] generateCertificateSignature(byte[] md5andsha1) throws IOException {
        try {
            return this.clientSigner.calculateRawSignature(this.context.getSecureRandom(), this.clientPrivateKey, md5andsha1);
        }
        catch (CryptoException e) {
            throw new TlsFatalAlert(80);
        }
    }
}

