/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.crypto.tls;

import cn.tca.TopBasicCrypto.crypto.CryptoException;
import cn.tca.TopBasicCrypto.crypto.DSA;
import cn.tca.TopBasicCrypto.crypto.Signer;
import cn.tca.TopBasicCrypto.crypto.digests.NullDigest;
import cn.tca.TopBasicCrypto.crypto.digests.SHA1Digest;
import cn.tca.TopBasicCrypto.crypto.params.AsymmetricKeyParameter;
import cn.tca.TopBasicCrypto.crypto.params.ParametersWithRandom;
import cn.tca.TopBasicCrypto.crypto.signers.DSADigestSigner;
import cn.tca.TopBasicCrypto.crypto.tls.TlsSigner;
import java.security.SecureRandom;

abstract class TlsDSASigner
implements TlsSigner {
    TlsDSASigner() {
    }

    public byte[] calculateRawSignature(SecureRandom secureRandom, AsymmetricKeyParameter privateKey, byte[] md5andsha1) throws CryptoException {
        DSADigestSigner signer = new DSADigestSigner(this.createDSAImpl(), new NullDigest());
        signer.init(true, new ParametersWithRandom(privateKey, secureRandom));
        signer.update(md5andsha1, 16, 20);
        return signer.generateSignature();
    }

    public Signer createVerifyer(AsymmetricKeyParameter publicKey) {
        DSADigestSigner verifyer = new DSADigestSigner(this.createDSAImpl(), new SHA1Digest());
        verifyer.init(false, publicKey);
        return verifyer;
    }

    protected abstract DSA createDSAImpl();
}

