/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.jce.provider;

import cn.tca.TopBasicCrypto.asn1.DERObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.bc.BCObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.cryptopro.CryptoProObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.iana.IANAObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.nist.NISTObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.oiw.OIWObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.pkcs.PKCSObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.teletrust.TeleTrusTObjectIdentifiers;
import cn.tca.TopBasicCrypto.jce.interfaces.ConfigurableProvider;
import cn.tca.TopBasicCrypto.jce.provider.ProviderUtil;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.util.Map;

public final class BouncyCastleProvider
extends Provider
implements ConfigurableProvider {
    private static String info = "TopBasicCrypto Security Provider v2.68";
    public static String PROVIDER_NAME = "BC";
    private static final String SYMMETRIC_CIPHER_PACKAGE = "cn.tca.TopBasicCrypto.jce.provider.symmetric.";
    private static final String[] SYMMETRIC_CIPHERS = new String[]{"AES", "ARC4", "Blowfish", "Camellia", "CAST5", "CAST6", "DESede", "Grainv1", "Grain128", "HC128", "HC256", "IDEA", "Noekeon", "RC5", "RC6", "Rijndael", "Salsa20", "SEED", "Serpent", "Skipjack", "TEA", "Twofish", "VMPC", "VMPCKSA3", "XTEA"};
    private static final String ASYMMETRIC_CIPHER_PACKAGE = "cn.tca.TopBasicCrypto.jce.provider.asymmetric.";
    private static final String[] ASYMMETRIC_CIPHERS = new String[]{"EC"};

    public BouncyCastleProvider() {
        super(PROVIDER_NAME, 2.68, info);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                BouncyCastleProvider.this.setup();
                return null;
            }
        });
    }

    private void setup() {
        this.loadAlgorithms(SYMMETRIC_CIPHER_PACKAGE, SYMMETRIC_CIPHERS);
        this.loadAlgorithms(ASYMMETRIC_CIPHER_PACKAGE, ASYMMETRIC_CIPHERS);
        this.put("X509Store.CERTIFICATE/COLLECTION", "cn.tca.TopBasicCrypto.jce.provider.X509StoreCertCollection");
        this.put("X509Store.ATTRIBUTECERTIFICATE/COLLECTION", "cn.tca.TopBasicCrypto.jce.provider.X509StoreAttrCertCollection");
        this.put("X509Store.CRL/COLLECTION", "cn.tca.TopBasicCrypto.jce.provider.X509StoreCRLCollection");
        this.put("X509Store.CERTIFICATEPAIR/COLLECTION", "cn.tca.TopBasicCrypto.jce.provider.X509StoreCertPairCollection");
        this.put("X509Store.CERTIFICATE/LDAP", "cn.tca.TopBasicCrypto.jce.provider.X509StoreLDAPCerts");
        this.put("X509Store.CRL/LDAP", "cn.tca.TopBasicCrypto.jce.provider.X509StoreLDAPCRLs");
        this.put("X509Store.ATTRIBUTECERTIFICATE/LDAP", "cn.tca.TopBasicCrypto.jce.provider.X509StoreLDAPAttrCerts");
        this.put("X509Store.CERTIFICATEPAIR/LDAP", "cn.tca.TopBasicCrypto.jce.provider.X509StoreLDAPCertPairs");
        this.put("X509StreamParser.CERTIFICATE", "cn.tca.TopBasicCrypto.jce.provider.X509CertParser");
        this.put("X509StreamParser.ATTRIBUTECERTIFICATE", "cn.tca.TopBasicCrypto.jce.provider.X509AttrCertParser");
        this.put("X509StreamParser.CRL", "cn.tca.TopBasicCrypto.jce.provider.X509CRLParser");
        this.put("X509StreamParser.CERTIFICATEPAIR", "cn.tca.TopBasicCrypto.jce.provider.X509CertPairParser");
        this.put("KeyStore.BKS", "cn.tca.TopBasicCrypto.jce.provider.JDKKeyStore");
        this.put("KeyStore.BouncyCastle", "cn.tca.TopBasicCrypto.jce.provider.JDKKeyStore$BouncyCastleStore");
        this.put("KeyStore.PKCS12", "cn.tca.TopBasicCrypto.jce.provider.JDKPKCS12KeyStore$BCPKCS12KeyStore");
        this.put("KeyStore.BCPKCS12", "cn.tca.TopBasicCrypto.jce.provider.JDKPKCS12KeyStore$BCPKCS12KeyStore");
        this.put("KeyStore.PKCS12-DEF", "cn.tca.TopBasicCrypto.jce.provider.JDKPKCS12KeyStore$DefPKCS12KeyStore");
        this.put("KeyStore.PKCS12-3DES-40RC2", "cn.tca.TopBasicCrypto.jce.provider.JDKPKCS12KeyStore$BCPKCS12KeyStore");
        this.put("KeyStore.PKCS12-3DES-3DES", "cn.tca.TopBasicCrypto.jce.provider.JDKPKCS12KeyStore$BCPKCS12KeyStore3DES");
        this.put("KeyStore.PKCS12-DEF-3DES-40RC2", "cn.tca.TopBasicCrypto.jce.provider.JDKPKCS12KeyStore$DefPKCS12KeyStore");
        this.put("KeyStore.PKCS12-DEF-3DES-3DES", "cn.tca.TopBasicCrypto.jce.provider.JDKPKCS12KeyStore$DefPKCS12KeyStore3DES");
        this.put("Alg.Alias.KeyStore.UBER", "BouncyCastle");
        this.put("Alg.Alias.KeyStore.BOUNCYCASTLE", "BouncyCastle");
        this.put("Alg.Alias.KeyStore.bouncycastle", "BouncyCastle");
        this.put("CertificateFactory.X.509", "cn.tca.TopBasicCrypto.jce.provider.JDKX509CertificateFactory");
        this.put("Alg.Alias.CertificateFactory.X509", "X.509");
        this.put("AlgorithmParameterGenerator.DH", "cn.tca.TopBasicCrypto.jce.provider.JDKAlgorithmParameterGenerator$DH");
        this.put("AlgorithmParameterGenerator.DSA", "cn.tca.TopBasicCrypto.jce.provider.JDKAlgorithmParameterGenerator$DSA");
        this.put("AlgorithmParameterGenerator.GOST3410", "cn.tca.TopBasicCrypto.jce.provider.JDKAlgorithmParameterGenerator$GOST3410");
        this.put("AlgorithmParameterGenerator.ELGAMAL", "cn.tca.TopBasicCrypto.jce.provider.JDKAlgorithmParameterGenerator$ElGamal");
        this.put("AlgorithmParameterGenerator.DES", "cn.tca.TopBasicCrypto.jce.provider.JDKAlgorithmParameterGenerator$DES");
        this.put("AlgorithmParameterGenerator.DESEDE", "cn.tca.TopBasicCrypto.jce.provider.JDKAlgorithmParameterGenerator$DES");
        this.put("AlgorithmParameterGenerator." + PKCSObjectIdentifiers.des_EDE3_CBC, "cn.tca.TopBasicCrypto.jce.provider.JDKAlgorithmParameterGenerator$DES");
        this.put("AlgorithmParameterGenerator." + OIWObjectIdentifiers.desCBC, "cn.tca.TopBasicCrypto.jce.provider.JDKAlgorithmParameterGenerator$DES");
        this.put("AlgorithmParameterGenerator.RC2", "cn.tca.TopBasicCrypto.jce.provider.JDKAlgorithmParameterGenerator$RC2");
        this.put("AlgorithmParameterGenerator.1.2.840.113549.3.2", "cn.tca.TopBasicCrypto.jce.provider.JDKAlgorithmParameterGenerator$RC2");
        this.put("Alg.Alias.AlgorithmParameterGenerator.DIFFIEHELLMAN", "DH");
        this.put("Alg.Alias.AlgorithmParameterGenerator.GOST-3410", "GOST3410");
        this.put("AlgorithmParameters.OAEP", "cn.tca.TopBasicCrypto.jce.provider.JDKAlgorithmParameters$OAEP");
        this.put("AlgorithmParameters.PSS", "cn.tca.TopBasicCrypto.jce.provider.JDKAlgorithmParameters$PSS");
        this.put("AlgorithmParameters.DH", "cn.tca.TopBasicCrypto.jce.provider.JDKAlgorithmParameters$DH");
        this.put("Alg.Alias.AlgorithmParameters.DIFFIEHELLMAN", "DH");
        this.put("AlgorithmParameters.DSA", "cn.tca.TopBasicCrypto.jce.provider.JDKAlgorithmParameters$DSA");
        this.put("AlgorithmParameters.ELGAMAL", "cn.tca.TopBasicCrypto.jce.provider.JDKAlgorithmParameters$ElGamal");
        this.put("AlgorithmParameters.IES", "cn.tca.TopBasicCrypto.jce.provider.JDKAlgorithmParameters$IES");
        this.put("AlgorithmParameters.PKCS12PBE", "cn.tca.TopBasicCrypto.jce.provider.JDKAlgorithmParameters$PKCS12PBE");
        this.put("AlgorithmParameters." + PKCSObjectIdentifiers.des_EDE3_CBC, "cn.tca.TopBasicCrypto.jce.provider.JDKAlgorithmParameters$IVAlgorithmParameters");
        this.put("AlgorithmParameters." + PKCSObjectIdentifiers.id_PBKDF2, "cn.tca.TopBasicCrypto.jce.provider.JDKAlgorithmParameters$PBKDF2");
        this.put("AlgorithmParameters.GOST3410", "cn.tca.TopBasicCrypto.jce.provider.JDKAlgorithmParameters$GOST3410");
        this.put("Alg.Alias.AlgorithmParameters.GOST-3410", "GOST3410");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA1ANDRC2", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND3-KEYTRIPLEDES", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND2-KEYTRIPLEDES", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDRC2", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDRC4", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDTWOFISH", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA1ANDRC2-CBC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND3-KEYTRIPLEDES-CBC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND2-KEYTRIPLEDES-CBC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDDES3KEY-CBC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDDES2KEY-CBC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND40BITRC2-CBC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND40BITRC4", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND128BITRC2-CBC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND128BITRC4", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDTWOFISH", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDTWOFISH-CBC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.1.2.840.113549.1.12.1.1", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.1.2.840.113549.1.12.1.2", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.1.2.840.113549.1.12.1.3", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.1.2.840.113549.1.12.1.4", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.1.2.840.113549.1.12.1.5", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.1.2.840.113549.1.12.1.6", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWithSHAAnd3KeyTripleDES", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters." + BCObjectIdentifiers.bc_pbe_sha1_pkcs12_aes128_cbc.getId(), "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters." + BCObjectIdentifiers.bc_pbe_sha1_pkcs12_aes192_cbc.getId(), "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters." + BCObjectIdentifiers.bc_pbe_sha1_pkcs12_aes256_cbc.getId(), "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters." + BCObjectIdentifiers.bc_pbe_sha256_pkcs12_aes128_cbc.getId(), "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters." + BCObjectIdentifiers.bc_pbe_sha256_pkcs12_aes192_cbc.getId(), "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters." + BCObjectIdentifiers.bc_pbe_sha256_pkcs12_aes256_cbc.getId(), "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters." + PKCSObjectIdentifiers.id_RSAES_OAEP, "OAEP");
        this.put("Alg.Alias.AlgorithmParameters.RSAPSS", "PSS");
        this.put("Alg.Alias.AlgorithmParameters.RSASSA-PSS", "PSS");
        this.put("Alg.Alias.AlgorithmParameters." + PKCSObjectIdentifiers.id_RSASSA_PSS, "PSS");
        this.put("Alg.Alias.AlgorithmParameters.SHA1withRSA/PSS", "PSS");
        this.put("Alg.Alias.AlgorithmParameters.SHA224withRSA/PSS", "PSS");
        this.put("Alg.Alias.AlgorithmParameters.SHA256withRSA/PSS", "PSS");
        this.put("Alg.Alias.AlgorithmParameters.SHA384withRSA/PSS", "PSS");
        this.put("Alg.Alias.AlgorithmParameters.SHA512withRSA/PSS", "PSS");
        this.put("Alg.Alias.AlgorithmParameters.SHA1WITHRSAANDMGF1", "PSS");
        this.put("Alg.Alias.AlgorithmParameters.SHA224WITHRSAANDMGF1", "PSS");
        this.put("Alg.Alias.AlgorithmParameters.SHA256WITHRSAANDMGF1", "PSS");
        this.put("Alg.Alias.AlgorithmParameters.SHA384WITHRSAANDMGF1", "PSS");
        this.put("Alg.Alias.AlgorithmParameters.SHA512WITHRSAANDMGF1", "PSS");
        this.put("Alg.Alias.AlgorithmParameters.RAWRSAPSS", "PSS");
        this.put("Alg.Alias.AlgorithmParameters.NONEWITHRSAPSS", "PSS");
        this.put("Alg.Alias.AlgorithmParameters.NONEWITHRSASSA-PSS", "PSS");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND128BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND192BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND256BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA256AND128BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA256AND192BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA256AND256BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA1AND128BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA1AND192BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA1AND256BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA-1AND128BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA-1AND192BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA-1AND256BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA-256AND128BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA-256AND192BITAES-CBC-BC", "PKCS12PBE");
        this.put("Alg.Alias.AlgorithmParameters.PBEWITHSHA-256AND256BITAES-CBC-BC", "PKCS12PBE");
        this.put("AlgorithmParameters.SHA1WITHECDSA", "cn.tca.TopBasicCrypto.jce.provider.JDKECDSAAlgParameters$SigAlgParameters");
        this.put("AlgorithmParameters.SHA224WITHECDSA", "cn.tca.TopBasicCrypto.jce.provider.JDKECDSAAlgParameters$SigAlgParameters");
        this.put("AlgorithmParameters.SHA256WITHECDSA", "cn.tca.TopBasicCrypto.jce.provider.JDKECDSAAlgParameters$SigAlgParameters");
        this.put("AlgorithmParameters.SHA384WITHECDSA", "cn.tca.TopBasicCrypto.jce.provider.JDKECDSAAlgParameters$SigAlgParameters");
        this.put("AlgorithmParameters.SHA512WITHECDSA", "cn.tca.TopBasicCrypto.jce.provider.JDKECDSAAlgParameters$SigAlgParameters");
        this.put("KeyAgreement.DH", "cn.tca.TopBasicCrypto.jce.provider.JCEDHKeyAgreement");
        this.put("Alg.Alias.KeyAgreement.DIFFIEHELLMAN", "DH");
        this.put("Cipher.DES", "cn.tca.TopBasicCrypto.jce.provider.JCEBlockCipher$DES");
        this.put("Cipher." + OIWObjectIdentifiers.desCBC, "cn.tca.TopBasicCrypto.jce.provider.JCEBlockCipher$DESCBC");
        this.put("Cipher.RC2", "cn.tca.TopBasicCrypto.jce.provider.JCEBlockCipher$RC2");
        this.put("Cipher.RC2WRAP", "cn.tca.TopBasicCrypto.jce.provider.WrapCipherSpi$RC2Wrap");
        this.put("Cipher.1.2.840.113549.1.9.16.3.7", "cn.tca.TopBasicCrypto.jce.provider.WrapCipherSpi$RC2Wrap");
        this.put("Cipher.1.2.840.113549.3.2", "cn.tca.TopBasicCrypto.jce.provider.JCEBlockCipher$RC2CBC");
        this.put("Alg.Alias.Cipher.PBEWithSHAAnd3KeyTripleDES", "PBEWITHSHAAND3-KEYTRIPLEDES-CBC");
        this.put("Cipher.GOST28147", "cn.tca.TopBasicCrypto.jce.provider.JCEBlockCipher$GOST28147");
        this.put("Alg.Alias.Cipher.GOST", "GOST28147");
        this.put("Alg.Alias.Cipher.GOST-28147", "GOST28147");
        this.put("Cipher." + CryptoProObjectIdentifiers.gostR28147_cbc, "cn.tca.TopBasicCrypto.jce.provider.JCEBlockCipher$GOST28147cbc");
        this.put("Cipher.RSA", "cn.tca.TopBasicCrypto.jce.provider.JCERSACipher$NoPadding");
        this.put("Cipher.RSA/RAW", "cn.tca.TopBasicCrypto.jce.provider.JCERSACipher$NoPadding");
        this.put("Cipher.RSA/PKCS1", "cn.tca.TopBasicCrypto.jce.provider.JCERSACipher$PKCS1v1_5Padding");
        this.put("Cipher.1.2.840.113549.1.1.1", "cn.tca.TopBasicCrypto.jce.provider.JCERSACipher$PKCS1v1_5Padding");
        this.put("Cipher.2.5.8.1.1", "cn.tca.TopBasicCrypto.jce.provider.JCERSACipher$PKCS1v1_5Padding");
        this.put("Cipher.RSA/1", "cn.tca.TopBasicCrypto.jce.provider.JCERSACipher$PKCS1v1_5Padding_PrivateOnly");
        this.put("Cipher.RSA/2", "cn.tca.TopBasicCrypto.jce.provider.JCERSACipher$PKCS1v1_5Padding_PublicOnly");
        this.put("Cipher.RSA/OAEP", "cn.tca.TopBasicCrypto.jce.provider.JCERSACipher$OAEPPadding");
        this.put("Cipher." + PKCSObjectIdentifiers.id_RSAES_OAEP, "cn.tca.TopBasicCrypto.jce.provider.JCERSACipher$OAEPPadding");
        this.put("Cipher.RSA/ISO9796-1", "cn.tca.TopBasicCrypto.jce.provider.JCERSACipher$ISO9796d1Padding");
        this.put("Cipher.ECIES", "cn.tca.TopBasicCrypto.jce.provider.JCEIESCipher$ECIES");
        this.put("Cipher.BrokenECIES", "cn.tca.TopBasicCrypto.jce.provider.JCEIESCipher$BrokenECIES");
        this.put("Cipher.IES", "cn.tca.TopBasicCrypto.jce.provider.JCEIESCipher$IES");
        this.put("Cipher.BrokenIES", "cn.tca.TopBasicCrypto.jce.provider.JCEIESCipher$BrokenIES");
        this.put("Cipher.ELGAMAL", "cn.tca.TopBasicCrypto.jce.provider.JCEElGamalCipher$NoPadding");
        this.put("Cipher.ELGAMAL/PKCS1", "cn.tca.TopBasicCrypto.jce.provider.JCEElGamalCipher$PKCS1v1_5Padding");
        this.put("Alg.Alias.Cipher.RSA//RAW", "RSA");
        this.put("Alg.Alias.Cipher.RSA//NOPADDING", "RSA");
        this.put("Alg.Alias.Cipher.RSA//PKCS1PADDING", "RSA/PKCS1");
        this.put("Alg.Alias.Cipher.RSA//OAEPPADDING", "RSA/OAEP");
        this.put("Alg.Alias.Cipher.RSA//ISO9796-1PADDING", "RSA/ISO9796-1");
        this.put("Alg.Alias.Cipher.ELGAMAL/ECB/PKCS1PADDING", "ELGAMAL/PKCS1");
        this.put("Alg.Alias.Cipher.ELGAMAL/NONE/PKCS1PADDING", "ELGAMAL/PKCS1");
        this.put("Alg.Alias.Cipher.ELGAMAL/NONE/NOPADDING", "ELGAMAL");
        this.put("Cipher.PBEWITHMD5ANDDES", "cn.tca.TopBasicCrypto.jce.provider.JCEBlockCipher$PBEWithMD5AndDES");
        this.put("Cipher.BROKENPBEWITHMD5ANDDES", "cn.tca.TopBasicCrypto.jce.provider.BrokenJCEBlockCipher$BrokePBEWithMD5AndDES");
        this.put("Cipher.PBEWITHMD5ANDRC2", "cn.tca.TopBasicCrypto.jce.provider.JCEBlockCipher$PBEWithMD5AndRC2");
        this.put("Cipher.PBEWITHSHA1ANDDES", "cn.tca.TopBasicCrypto.jce.provider.JCEBlockCipher$PBEWithSHA1AndDES");
        this.put("Cipher.BROKENPBEWITHSHA1ANDDES", "cn.tca.TopBasicCrypto.jce.provider.BrokenJCEBlockCipher$BrokePBEWithSHA1AndDES");
        this.put("Cipher.PBEWITHSHA1ANDRC2", "cn.tca.TopBasicCrypto.jce.provider.JCEBlockCipher$PBEWithSHA1AndRC2");
        this.put("Cipher.PBEWITHSHAAND3-KEYTRIPLEDES-CBC", "cn.tca.TopBasicCrypto.jce.provider.JCEBlockCipher$PBEWithSHAAndDES3Key");
        this.put("Cipher.BROKENPBEWITHSHAAND3-KEYTRIPLEDES-CBC", "cn.tca.TopBasicCrypto.jce.provider.BrokenJCEBlockCipher$BrokePBEWithSHAAndDES3Key");
        this.put("Cipher.OLDPBEWITHSHAAND3-KEYTRIPLEDES-CBC", "cn.tca.TopBasicCrypto.jce.provider.BrokenJCEBlockCipher$OldPBEWithSHAAndDES3Key");
        this.put("Cipher.PBEWITHSHAAND2-KEYTRIPLEDES-CBC", "cn.tca.TopBasicCrypto.jce.provider.JCEBlockCipher$PBEWithSHAAndDES2Key");
        this.put("Cipher.BROKENPBEWITHSHAAND2-KEYTRIPLEDES-CBC", "cn.tca.TopBasicCrypto.jce.provider.BrokenJCEBlockCipher$BrokePBEWithSHAAndDES2Key");
        this.put("Cipher.PBEWITHSHAAND128BITRC2-CBC", "cn.tca.TopBasicCrypto.jce.provider.JCEBlockCipher$PBEWithSHAAnd128BitRC2");
        this.put("Cipher.PBEWITHSHAAND40BITRC2-CBC", "cn.tca.TopBasicCrypto.jce.provider.JCEBlockCipher$PBEWithSHAAnd40BitRC2");
        this.put("Cipher.PBEWITHSHAAND128BITRC4", "cn.tca.TopBasicCrypto.jce.provider.JCEStreamCipher$PBEWithSHAAnd128BitRC4");
        this.put("Cipher.PBEWITHSHAAND40BITRC4", "cn.tca.TopBasicCrypto.jce.provider.JCEStreamCipher$PBEWithSHAAnd40BitRC4");
        this.put("Alg.Alias.Cipher.PBEWITHSHA1AND3-KEYTRIPLEDES-CBC", "Cipher.PBEWITHSHAAND3-KEYTRIPLEDES-CBC");
        this.put("Alg.Alias.Cipher.PBEWITHSHA1AND2-KEYTRIPLEDES-CBC", "Cipher.PBEWITHSHAAND2-KEYTRIPLEDES-CBC");
        this.put("Alg.Alias.Cipher.PBEWITHSHA1AND128BITRC2-CBC", "Cipher.PBEWITHSHAAND128BITRC2-CBC");
        this.put("Alg.Alias.Cipher.PBEWITHSHA1AND40BITRC2-CBC", "Cipher.PBEWITHSHAAND40BITRC2-CBC");
        this.put("Alg.Alias.Cipher.PBEWITHSHA1AND128BITRC4", "Cipher.PBEWITHSHAAND128BITRC4");
        this.put("Alg.Alias.Cipher.PBEWITHSHA1AND40BITRC4", "Cipher.PBEWITHSHAAND40BITRC4");
        this.put("Alg.Alias.Cipher." + BCObjectIdentifiers.bc_pbe_sha1_pkcs12_aes128_cbc.getId(), "PBEWITHSHAAND128BITAES-CBC-BC");
        this.put("Alg.Alias.Cipher." + BCObjectIdentifiers.bc_pbe_sha1_pkcs12_aes192_cbc.getId(), "PBEWITHSHAAND192BITAES-CBC-BC");
        this.put("Alg.Alias.Cipher." + BCObjectIdentifiers.bc_pbe_sha1_pkcs12_aes256_cbc.getId(), "PBEWITHSHAAND256BITAES-CBC-BC");
        this.put("Alg.Alias.Cipher." + BCObjectIdentifiers.bc_pbe_sha256_pkcs12_aes128_cbc.getId(), "PBEWITHSHA256AND128BITAES-CBC-BC");
        this.put("Alg.Alias.Cipher." + BCObjectIdentifiers.bc_pbe_sha256_pkcs12_aes192_cbc.getId(), "PBEWITHSHA256AND192BITAES-CBC-BC");
        this.put("Alg.Alias.Cipher." + BCObjectIdentifiers.bc_pbe_sha256_pkcs12_aes256_cbc.getId(), "PBEWITHSHA256AND256BITAES-CBC-BC");
        this.put("Cipher.PBEWITHSHAAND128BITAES-CBC-BC", "cn.tca.TopBasicCrypto.jce.provider.JCEBlockCipher$PBEWithAESCBC");
        this.put("Cipher.PBEWITHSHAAND192BITAES-CBC-BC", "cn.tca.TopBasicCrypto.jce.provider.JCEBlockCipher$PBEWithAESCBC");
        this.put("Cipher.PBEWITHSHAAND256BITAES-CBC-BC", "cn.tca.TopBasicCrypto.jce.provider.JCEBlockCipher$PBEWithAESCBC");
        this.put("Cipher.PBEWITHSHA256AND128BITAES-CBC-BC", "cn.tca.TopBasicCrypto.jce.provider.JCEBlockCipher$PBEWithAESCBC");
        this.put("Cipher.PBEWITHSHA256AND192BITAES-CBC-BC", "cn.tca.TopBasicCrypto.jce.provider.JCEBlockCipher$PBEWithAESCBC");
        this.put("Cipher.PBEWITHSHA256AND256BITAES-CBC-BC", "cn.tca.TopBasicCrypto.jce.provider.JCEBlockCipher$PBEWithAESCBC");
        this.put("Alg.Alias.Cipher.PBEWITHSHA1AND128BITAES-CBC-BC", "PBEWITHSHAAND128BITAES-CBC-BC");
        this.put("Alg.Alias.Cipher.PBEWITHSHA1AND192BITAES-CBC-BC", "PBEWITHSHAAND192BITAES-CBC-BC");
        this.put("Alg.Alias.Cipher.PBEWITHSHA1AND256BITAES-CBC-BC", "PBEWITHSHAAND256BITAES-CBC-BC");
        this.put("Alg.Alias.Cipher.PBEWITHSHA-1AND128BITAES-CBC-BC", "PBEWITHSHAAND128BITAES-CBC-BC");
        this.put("Alg.Alias.Cipher.PBEWITHSHA-1AND192BITAES-CBC-BC", "PBEWITHSHAAND192BITAES-CBC-BC");
        this.put("Alg.Alias.Cipher.PBEWITHSHA-1AND256BITAES-CBC-BC", "PBEWITHSHAAND256BITAES-CBC-BC");
        this.put("Alg.Alias.Cipher.PBEWITHSHA-256AND128BITAES-CBC-BC", "PBEWITHSHA256AND128BITAES-CBC-BC");
        this.put("Alg.Alias.Cipher.PBEWITHSHA-256AND192BITAES-CBC-BC", "PBEWITHSHA256AND192BITAES-CBC-BC");
        this.put("Alg.Alias.Cipher.PBEWITHSHA-256AND256BITAES-CBC-BC", "PBEWITHSHA256AND256BITAES-CBC-BC");
        this.put("Cipher.PBEWITHMD5AND128BITAES-CBC-OPENSSL", "cn.tca.TopBasicCrypto.jce.provider.JCEBlockCipher$PBEWithAESCBC");
        this.put("Cipher.PBEWITHMD5AND192BITAES-CBC-OPENSSL", "cn.tca.TopBasicCrypto.jce.provider.JCEBlockCipher$PBEWithAESCBC");
        this.put("Cipher.PBEWITHMD5AND256BITAES-CBC-OPENSSL", "cn.tca.TopBasicCrypto.jce.provider.JCEBlockCipher$PBEWithAESCBC");
        this.put("Cipher.PBEWITHSHAANDTWOFISH-CBC", "cn.tca.TopBasicCrypto.jce.provider.JCEBlockCipher$PBEWithSHAAndTwofish");
        this.put("Cipher.OLDPBEWITHSHAANDTWOFISH-CBC", "cn.tca.TopBasicCrypto.jce.provider.BrokenJCEBlockCipher$OldPBEWithSHAAndTwofish");
        this.put("Alg.Alias.Cipher." + PKCSObjectIdentifiers.pbeWithMD2AndDES_CBC, "PBEWITHMD2ANDDES");
        this.put("Alg.Alias.Cipher." + PKCSObjectIdentifiers.pbeWithMD2AndRC2_CBC, "PBEWITHMD2ANDRC2");
        this.put("Alg.Alias.Cipher." + PKCSObjectIdentifiers.pbeWithMD5AndDES_CBC, "PBEWITHMD5ANDDES");
        this.put("Alg.Alias.Cipher." + PKCSObjectIdentifiers.pbeWithMD5AndRC2_CBC, "PBEWITHMD5ANDDES");
        this.put("Alg.Alias.Cipher." + PKCSObjectIdentifiers.pbeWithSHA1AndDES_CBC, "PBEWITHSHA1ANDDES");
        this.put("Alg.Alias.Cipher." + PKCSObjectIdentifiers.pbeWithSHA1AndRC2_CBC, "PBEWITHSHA1ANDRC2");
        this.put("Alg.Alias.Cipher.1.2.840.113549.1.12.1.1", "PBEWITHSHAAND128BITRC4");
        this.put("Alg.Alias.Cipher.1.2.840.113549.1.12.1.2", "PBEWITHSHAAND40BITRC4");
        this.put("Alg.Alias.Cipher.1.2.840.113549.1.12.1.3", "PBEWITHSHAAND3-KEYTRIPLEDES-CBC");
        this.put("Alg.Alias.Cipher.1.2.840.113549.1.12.1.4", "PBEWITHSHAAND2-KEYTRIPLEDES-CBC");
        this.put("Alg.Alias.Cipher.1.2.840.113549.1.12.1.5", "PBEWITHSHAAND128BITRC2-CBC");
        this.put("Alg.Alias.Cipher.1.2.840.113549.1.12.1.6", "PBEWITHSHAAND40BITRC2-CBC");
        this.put("Alg.Alias.Cipher.PBEWITHSHA1ANDDESEDE", "PBEWITHSHAAND3-KEYTRIPLEDES-CBC");
        this.put("KeyGenerator.DES", "cn.tca.TopBasicCrypto.jce.provider.JCEKeyGenerator$DES");
        this.put("Alg.Alias.KeyGenerator." + OIWObjectIdentifiers.desCBC, "DES");
        this.put("KeyGenerator.RC2", "cn.tca.TopBasicCrypto.jce.provider.JCEKeyGenerator$RC2");
        this.put("KeyGenerator.1.2.840.113549.3.2", "cn.tca.TopBasicCrypto.jce.provider.JCEKeyGenerator$RC2");
        this.put("KeyGenerator.GOST28147", "cn.tca.TopBasicCrypto.jce.provider.JCEKeyGenerator$GOST28147");
        this.put("Alg.Alias.KeyGenerator.GOST", "GOST28147");
        this.put("Alg.Alias.KeyGenerator.GOST-28147", "GOST28147");
        this.put("Alg.Alias.KeyGenerator." + CryptoProObjectIdentifiers.gostR28147_cbc, "GOST28147");
        this.put("KeyPairGenerator.RSA", "cn.tca.TopBasicCrypto.jce.provider.JDKKeyPairGenerator$RSA");
        this.put("KeyPairGenerator.DH", "cn.tca.TopBasicCrypto.jce.provider.JDKKeyPairGenerator$DH");
        this.put("KeyPairGenerator.DSA", "cn.tca.TopBasicCrypto.jce.provider.JDKKeyPairGenerator$DSA");
        this.put("KeyPairGenerator.ELGAMAL", "cn.tca.TopBasicCrypto.jce.provider.JDKKeyPairGenerator$ElGamal");
        this.put("Alg.Alias.KeyPairGenerator.1.2.840.113549.1.1.1", "RSA");
        this.put("Alg.Alias.KeyPairGenerator.DIFFIEHELLMAN", "DH");
        this.put("KeyPairGenerator.GOST3410", "cn.tca.TopBasicCrypto.jce.provider.JDKKeyPairGenerator$GOST3410");
        this.put("Alg.Alias.KeyPairGenerator.GOST-3410", "GOST3410");
        this.put("Alg.Alias.KeyPairGenerator.GOST-3410-94", "GOST3410");
        this.put("KeyFactory.RSA", "cn.tca.TopBasicCrypto.jce.provider.JDKKeyFactory$RSA");
        this.put("KeyFactory.DH", "cn.tca.TopBasicCrypto.jce.provider.JDKKeyFactory$DH");
        this.put("KeyFactory.DSA", "cn.tca.TopBasicCrypto.jce.provider.JDKKeyFactory$DSA");
        this.put("KeyFactory.ELGAMAL", "cn.tca.TopBasicCrypto.jce.provider.JDKKeyFactory$ElGamal");
        this.put("KeyFactory.ElGamal", "cn.tca.TopBasicCrypto.jce.provider.JDKKeyFactory$ElGamal");
        this.put("KeyFactory.X.509", "cn.tca.TopBasicCrypto.jce.provider.JDKKeyFactory$X509");
        this.put("Alg.Alias.KeyFactory.1.2.840.113549.1.1.1", "RSA");
        this.put("Alg.Alias.KeyFactory.1.2.840.10040.4.1", "DSA");
        this.put("Alg.Alias.KeyFactory.DIFFIEHELLMAN", "DH");
        this.put("KeyFactory.GOST3410", "cn.tca.TopBasicCrypto.jce.provider.JDKKeyFactory$GOST3410");
        this.put("Alg.Alias.KeyFactory.GOST-3410", "GOST3410");
        this.put("Alg.Alias.KeyFactory.GOST-3410-94", "GOST3410");
        this.put("Alg.Alias.KeyFactory." + CryptoProObjectIdentifiers.gostR3410_94, "GOST3410");
        this.put("AlgorithmParameters.DES", "cn.tca.TopBasicCrypto.jce.provider.JDKAlgorithmParameters$IVAlgorithmParameters");
        this.put("Alg.Alias.AlgorithmParameters." + OIWObjectIdentifiers.desCBC, "DES");
        this.put("AlgorithmParameters.DESEDE", "cn.tca.TopBasicCrypto.jce.provider.JDKAlgorithmParameters$IVAlgorithmParameters");
        this.put("AlgorithmParameters." + PKCSObjectIdentifiers.des_EDE3_CBC, "cn.tca.TopBasicCrypto.jce.provider.JDKAlgorithmParameters$IVAlgorithmParameters");
        this.put("AlgorithmParameters.RC2", "cn.tca.TopBasicCrypto.jce.provider.JDKAlgorithmParameters$RC2AlgorithmParameters");
        this.put("AlgorithmParameters.1.2.840.113549.3.2", "cn.tca.TopBasicCrypto.jce.provider.JDKAlgorithmParameters$RC2AlgorithmParameters");
        this.put("SecretKeyFactory.DES", "cn.tca.TopBasicCrypto.jce.provider.JCESecretKeyFactory$DES");
        this.put("SecretKeyFactory.PBEWITHMD2ANDDES", "cn.tca.TopBasicCrypto.jce.provider.JCESecretKeyFactory$PBEWithMD2AndDES");
        this.put("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.pbeWithMD2AndDES_CBC, "PBEWITHMD2ANDDES");
        this.put("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.pbeWithMD2AndRC2_CBC, "PBEWITHMD2ANDRC2");
        this.put("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.pbeWithMD5AndDES_CBC, "PBEWITHMD5ANDDES");
        this.put("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.pbeWithMD5AndRC2_CBC, "PBEWITHMD5ANDDES");
        this.put("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.pbeWithSHA1AndDES_CBC, "PBEWITHSHA1ANDDES");
        this.put("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.pbeWithSHA1AndRC2_CBC, "PBEWITHSHA1ANDRC2");
        this.put("SecretKeyFactory.PBEWITHMD2ANDRC2", "cn.tca.TopBasicCrypto.jce.provider.JCESecretKeyFactory$PBEWithMD2AndRC2");
        this.put("SecretKeyFactory.PBEWITHMD5ANDDES", "cn.tca.TopBasicCrypto.jce.provider.JCESecretKeyFactory$PBEWithMD5AndDES");
        this.put("SecretKeyFactory.PBEWITHMD5ANDRC2", "cn.tca.TopBasicCrypto.jce.provider.JCESecretKeyFactory$PBEWithMD5AndRC2");
        this.put("SecretKeyFactory.PBEWITHSHA1ANDDES", "cn.tca.TopBasicCrypto.jce.provider.JCESecretKeyFactory$PBEWithSHA1AndDES");
        this.put("SecretKeyFactory.PBEWITHSHA1ANDRC2", "cn.tca.TopBasicCrypto.jce.provider.JCESecretKeyFactory$PBEWithSHA1AndRC2");
        this.put("SecretKeyFactory.PBEWITHSHAAND3-KEYTRIPLEDES-CBC", "cn.tca.TopBasicCrypto.jce.provider.JCESecretKeyFactory$PBEWithSHAAndDES3Key");
        this.put("SecretKeyFactory.PBEWITHSHAAND2-KEYTRIPLEDES-CBC", "cn.tca.TopBasicCrypto.jce.provider.JCESecretKeyFactory$PBEWithSHAAndDES2Key");
        this.put("SecretKeyFactory.PBEWITHSHAAND128BITRC4", "cn.tca.TopBasicCrypto.jce.provider.JCESecretKeyFactory$PBEWithSHAAnd128BitRC4");
        this.put("SecretKeyFactory.PBEWITHSHAAND40BITRC4", "cn.tca.TopBasicCrypto.jce.provider.JCESecretKeyFactory$PBEWithSHAAnd40BitRC4");
        this.put("SecretKeyFactory.PBEWITHSHAAND128BITRC2-CBC", "cn.tca.TopBasicCrypto.jce.provider.JCESecretKeyFactory$PBEWithSHAAnd128BitRC2");
        this.put("SecretKeyFactory.PBEWITHSHAAND40BITRC2-CBC", "cn.tca.TopBasicCrypto.jce.provider.JCESecretKeyFactory$PBEWithSHAAnd40BitRC2");
        this.put("SecretKeyFactory.PBEWITHSHAANDTWOFISH-CBC", "cn.tca.TopBasicCrypto.jce.provider.JCESecretKeyFactory$PBEWithSHAAndTwofish");
        this.put("SecretKeyFactory.PBEWITHHMACRIPEMD160", "cn.tca.TopBasicCrypto.jce.provider.JCESecretKeyFactory$PBEWithRIPEMD160");
        this.put("SecretKeyFactory.PBEWITHHMACSHA1", "cn.tca.TopBasicCrypto.jce.provider.JCESecretKeyFactory$PBEWithSHA");
        this.put("SecretKeyFactory.PBEWITHHMACTIGER", "cn.tca.TopBasicCrypto.jce.provider.JCESecretKeyFactory$PBEWithTiger");
        this.put("SecretKeyFactory.PBEWITHMD5AND128BITAES-CBC-OPENSSL", "cn.tca.TopBasicCrypto.jce.provider.JCESecretKeyFactory$PBEWithMD5And128BitAESCBCOpenSSL");
        this.put("SecretKeyFactory.PBEWITHMD5AND192BITAES-CBC-OPENSSL", "cn.tca.TopBasicCrypto.jce.provider.JCESecretKeyFactory$PBEWithMD5And192BitAESCBCOpenSSL");
        this.put("SecretKeyFactory.PBEWITHMD5AND256BITAES-CBC-OPENSSL", "cn.tca.TopBasicCrypto.jce.provider.JCESecretKeyFactory$PBEWithMD5And256BitAESCBCOpenSSL");
        this.put("Alg.Alias.SecretKeyFactory.PBE", "PBE/PKCS5");
        this.put("Alg.Alias.SecretKeyFactory.BROKENPBEWITHMD5ANDDES", "PBE/PKCS5");
        this.put("Alg.Alias.SecretKeyFactory.BROKENPBEWITHSHA1ANDDES", "PBE/PKCS5");
        this.put("Alg.Alias.SecretKeyFactory.OLDPBEWITHSHAAND3-KEYTRIPLEDES-CBC", "PBE/PKCS12");
        this.put("Alg.Alias.SecretKeyFactory.BROKENPBEWITHSHAAND3-KEYTRIPLEDES-CBC", "PBE/PKCS12");
        this.put("Alg.Alias.SecretKeyFactory.BROKENPBEWITHSHAAND2-KEYTRIPLEDES-CBC", "PBE/PKCS12");
        this.put("Alg.Alias.SecretKeyFactory.OLDPBEWITHSHAANDTWOFISH-CBC", "PBE/PKCS12");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHMD2ANDDES-CBC", "PBEWITHMD2ANDDES");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHMD2ANDRC2-CBC", "PBEWITHMD2ANDRC2");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHMD5ANDDES-CBC", "PBEWITHMD5ANDDES");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHMD5ANDRC2-CBC", "PBEWITHMD5ANDRC2");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA1ANDDES-CBC", "PBEWITHSHA1ANDDES");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA1ANDRC2-CBC", "PBEWITHSHA1ANDRC2");
        this.put("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.pbeWithMD2AndDES_CBC, "PBEWITHMD2ANDDES");
        this.put("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.pbeWithMD2AndRC2_CBC, "PBEWITHMD2ANDRC2");
        this.put("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.pbeWithMD5AndDES_CBC, "PBEWITHMD5ANDDES");
        this.put("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.pbeWithMD5AndRC2_CBC, "PBEWITHMD5ANDRC2");
        this.put("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.pbeWithSHA1AndDES_CBC, "PBEWITHSHA1ANDDES");
        this.put("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.pbeWithSHA1AndRC2_CBC, "PBEWITHSHA1ANDRC2");
        this.put("Alg.Alias.SecretKeyFactory.1.2.840.113549.1.12.1.1", "PBEWITHSHAAND128BITRC4");
        this.put("Alg.Alias.SecretKeyFactory.1.2.840.113549.1.12.1.2", "PBEWITHSHAAND40BITRC4");
        this.put("Alg.Alias.SecretKeyFactory.1.2.840.113549.1.12.1.3", "PBEWITHSHAAND3-KEYTRIPLEDES-CBC");
        this.put("Alg.Alias.SecretKeyFactory.1.2.840.113549.1.12.1.4", "PBEWITHSHAAND2-KEYTRIPLEDES-CBC");
        this.put("Alg.Alias.SecretKeyFactory.1.2.840.113549.1.12.1.5", "PBEWITHSHAAND128BITRC2-CBC");
        this.put("Alg.Alias.SecretKeyFactory.1.2.840.113549.1.12.1.6", "PBEWITHSHAAND40BITRC2-CBC");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHHMACSHA", "PBEWITHHMACSHA1");
        this.put("Alg.Alias.SecretKeyFactory.1.3.14.3.2.26", "PBEWITHHMACSHA1");
        this.put("Alg.Alias.SecretKeyFactory.PBEWithSHAAnd3KeyTripleDES", "PBEWITHSHAAND3-KEYTRIPLEDES-CBC");
        this.put("SecretKeyFactory.PBEWITHSHAAND128BITAES-CBC-BC", "cn.tca.TopBasicCrypto.jce.provider.JCESecretKeyFactory$PBEWithSHAAnd128BitAESBC");
        this.put("SecretKeyFactory.PBEWITHSHAAND192BITAES-CBC-BC", "cn.tca.TopBasicCrypto.jce.provider.JCESecretKeyFactory$PBEWithSHAAnd192BitAESBC");
        this.put("SecretKeyFactory.PBEWITHSHAAND256BITAES-CBC-BC", "cn.tca.TopBasicCrypto.jce.provider.JCESecretKeyFactory$PBEWithSHAAnd256BitAESBC");
        this.put("SecretKeyFactory.PBEWITHSHA256AND128BITAES-CBC-BC", "cn.tca.TopBasicCrypto.jce.provider.JCESecretKeyFactory$PBEWithSHA256And128BitAESBC");
        this.put("SecretKeyFactory.PBEWITHSHA256AND192BITAES-CBC-BC", "cn.tca.TopBasicCrypto.jce.provider.JCESecretKeyFactory$PBEWithSHA256And192BitAESBC");
        this.put("SecretKeyFactory.PBEWITHSHA256AND256BITAES-CBC-BC", "cn.tca.TopBasicCrypto.jce.provider.JCESecretKeyFactory$PBEWithSHA256And256BitAESBC");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA1AND128BITAES-CBC-BC", "PBEWITHSHAAND128BITAES-CBC-BC");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA1AND192BITAES-CBC-BC", "PBEWITHSHAAND192BITAES-CBC-BC");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA1AND256BITAES-CBC-BC", "PBEWITHSHAAND256BITAES-CBC-BC");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA-1AND128BITAES-CBC-BC", "PBEWITHSHAAND128BITAES-CBC-BC");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA-1AND192BITAES-CBC-BC", "PBEWITHSHAAND192BITAES-CBC-BC");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA-1AND256BITAES-CBC-BC", "PBEWITHSHAAND256BITAES-CBC-BC");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA-256AND128BITAES-CBC-BC", "PBEWITHSHA256AND128BITAES-CBC-BC");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA-256AND192BITAES-CBC-BC", "PBEWITHSHA256AND192BITAES-CBC-BC");
        this.put("Alg.Alias.SecretKeyFactory.PBEWITHSHA-256AND256BITAES-CBC-BC", "PBEWITHSHA256AND256BITAES-CBC-BC");
        this.put("Alg.Alias.SecretKeyFactory." + BCObjectIdentifiers.bc_pbe_sha1_pkcs12_aes128_cbc.getId(), "PBEWITHSHAAND128BITAES-CBC-BC");
        this.put("Alg.Alias.SecretKeyFactory." + BCObjectIdentifiers.bc_pbe_sha1_pkcs12_aes192_cbc.getId(), "PBEWITHSHAAND192BITAES-CBC-BC");
        this.put("Alg.Alias.SecretKeyFactory." + BCObjectIdentifiers.bc_pbe_sha1_pkcs12_aes256_cbc.getId(), "PBEWITHSHAAND256BITAES-CBC-BC");
        this.put("Alg.Alias.SecretKeyFactory." + BCObjectIdentifiers.bc_pbe_sha256_pkcs12_aes128_cbc.getId(), "PBEWITHSHA256AND128BITAES-CBC-BC");
        this.put("Alg.Alias.SecretKeyFactory." + BCObjectIdentifiers.bc_pbe_sha256_pkcs12_aes192_cbc.getId(), "PBEWITHSHA256AND192BITAES-CBC-BC");
        this.put("Alg.Alias.SecretKeyFactory." + BCObjectIdentifiers.bc_pbe_sha256_pkcs12_aes256_cbc.getId(), "PBEWITHSHA256AND256BITAES-CBC-BC");
        this.addMacAlgorithms();
        this.addMessageDigestAlgorithms();
        this.addSignatureAlgorithms();
        this.put("CertPathValidator.RFC3281", "cn.tca.TopBasicCrypto.jce.provider.PKIXAttrCertPathValidatorSpi");
        this.put("CertPathBuilder.RFC3281", "cn.tca.TopBasicCrypto.jce.provider.PKIXAttrCertPathBuilderSpi");
        this.put("CertPathValidator.RFC3280", "cn.tca.TopBasicCrypto.jce.provider.PKIXCertPathValidatorSpi");
        this.put("CertPathBuilder.RFC3280", "cn.tca.TopBasicCrypto.jce.provider.PKIXCertPathBuilderSpi");
        this.put("CertPathValidator.PKIX", "cn.tca.TopBasicCrypto.jce.provider.PKIXCertPathValidatorSpi");
        this.put("CertPathBuilder.PKIX", "cn.tca.TopBasicCrypto.jce.provider.PKIXCertPathBuilderSpi");
        this.put("CertStore.Collection", "cn.tca.TopBasicCrypto.jce.provider.CertStoreCollectionSpi");
        this.put("CertStore.LDAP", "cn.tca.TopBasicCrypto.jce.provider.X509LDAPCertStoreSpi");
        this.put("CertStore.Multi", "cn.tca.TopBasicCrypto.jce.provider.MultiCertStoreSpi");
        this.put("Alg.Alias.CertStore.X509LDAP", "LDAP");
    }

    private void loadAlgorithms(String packageName, String[] names) {
        for (int i = 0; i != names.length; ++i) {
            Class<?> clazz = null;
            try {
                ClassLoader loader = this.getClass().getClassLoader();
                clazz = loader != null ? loader.loadClass(packageName + names[i] + "$Mappings") : Class.forName(packageName + names[i] + "$Mappings");
            }
            catch (ClassNotFoundException loader) {
                // empty catch block
            }
            if (clazz == null) continue;
            try {
                this.addMappings((Map)clazz.newInstance());
                continue;
            }
            catch (Exception e) {
                throw new InternalError("cannot create instance of " + packageName + names[i] + "$Mappings : " + e);
            }
        }
    }

    private void addMappings(Map mappings) {
        for (Object key : mappings.keySet()) {
            if (this.containsKey(key)) {
                throw new IllegalStateException("duplicate provider key (" + key + ") found in " + mappings.getClass().getName());
            }
            this.put(key, mappings.get(key));
        }
    }

    private void addMacAlgorithms() {
        this.put("Mac.DESMAC", "cn.tca.TopBasicCrypto.jce.provider.JCEMac$DES");
        this.put("Alg.Alias.Mac.DES", "DESMAC");
        this.put("Mac.DESMAC/CFB8", "cn.tca.TopBasicCrypto.jce.provider.JCEMac$DESCFB8");
        this.put("Alg.Alias.Mac.DES/CFB8", "DESMAC/CFB8");
        this.put("Mac.DESWITHISO9797", "cn.tca.TopBasicCrypto.jce.provider.JCEMac$DES9797Alg3");
        this.put("Alg.Alias.Mac.DESISO9797MAC", "DESWITHISO9797");
        this.put("Mac.ISO9797ALG3MAC", "cn.tca.TopBasicCrypto.jce.provider.JCEMac$DES9797Alg3");
        this.put("Alg.Alias.Mac.ISO9797ALG3", "ISO9797ALG3MAC");
        this.put("Mac.ISO9797ALG3WITHISO7816-4PADDING", "cn.tca.TopBasicCrypto.jce.provider.JCEMac$DES9797Alg3with7816d4");
        this.put("Alg.Alias.Mac.ISO9797ALG3MACWITHISO7816-4PADDING", "ISO9797ALG3WITHISO7816-4PADDING");
        this.put("Mac.RC2MAC", "cn.tca.TopBasicCrypto.jce.provider.JCEMac$RC2");
        this.put("Alg.Alias.Mac.RC2", "RC2MAC");
        this.put("Mac.RC2MAC/CFB8", "cn.tca.TopBasicCrypto.jce.provider.JCEMac$RC2CFB8");
        this.put("Alg.Alias.Mac.RC2/CFB8", "RC2MAC/CFB8");
        this.put("Mac.GOST28147MAC", "cn.tca.TopBasicCrypto.jce.provider.JCEMac$GOST28147");
        this.put("Alg.Alias.Mac.GOST28147", "GOST28147MAC");
        this.put("Mac.OLDHMACSHA384", "cn.tca.TopBasicCrypto.jce.provider.JCEMac$OldSHA384");
        this.put("Mac.OLDHMACSHA512", "cn.tca.TopBasicCrypto.jce.provider.JCEMac$OldSHA512");
        this.addHMACAlgorithm("MD2", "cn.tca.TopBasicCrypto.jce.provider.JCEMac$MD2", "cn.tca.TopBasicCrypto.jce.provider.JCEKeyGenerator$MD2HMAC");
        this.addHMACAlgorithm("MD4", "cn.tca.TopBasicCrypto.jce.provider.JCEMac$MD4", "cn.tca.TopBasicCrypto.jce.provider.JCEKeyGenerator$MD4HMAC");
        this.addHMACAlgorithm("MD5", "cn.tca.TopBasicCrypto.jce.provider.JCEMac$MD5", "cn.tca.TopBasicCrypto.jce.provider.JCEKeyGenerator$MD5HMAC");
        this.addHMACAlias("MD5", IANAObjectIdentifiers.hmacMD5);
        this.addHMACAlgorithm("SHA1", "cn.tca.TopBasicCrypto.jce.provider.JCEMac$SHA1", "cn.tca.TopBasicCrypto.jce.provider.JCEKeyGenerator$HMACSHA1");
        this.addHMACAlias("SHA1", PKCSObjectIdentifiers.id_hmacWithSHA1);
        this.addHMACAlias("SHA1", IANAObjectIdentifiers.hmacSHA1);
        this.addHMACAlgorithm("SHA224", "cn.tca.TopBasicCrypto.jce.provider.JCEMac$SHA224", "cn.tca.TopBasicCrypto.jce.provider.JCEKeyGenerator$HMACSHA224");
        this.addHMACAlias("SHA224", PKCSObjectIdentifiers.id_hmacWithSHA224);
        this.addHMACAlgorithm("SHA256", "cn.tca.TopBasicCrypto.jce.provider.JCEMac$SHA256", "cn.tca.TopBasicCrypto.jce.provider.JCEKeyGenerator$HMACSHA256");
        this.addHMACAlias("SHA256", PKCSObjectIdentifiers.id_hmacWithSHA256);
        this.addHMACAlgorithm("SHA384", "cn.tca.TopBasicCrypto.jce.provider.JCEMac$SHA384", "cn.tca.TopBasicCrypto.jce.provider.JCEKeyGenerator$HMACSHA384");
        this.addHMACAlias("SHA384", PKCSObjectIdentifiers.id_hmacWithSHA384);
        this.addHMACAlgorithm("SHA512", "cn.tca.TopBasicCrypto.jce.provider.JCEMac$SHA512", "cn.tca.TopBasicCrypto.jce.provider.JCEKeyGenerator$HMACSHA512");
        this.addHMACAlias("SHA512", PKCSObjectIdentifiers.id_hmacWithSHA512);
        this.addHMACAlgorithm("RIPEMD128", "cn.tca.TopBasicCrypto.jce.provider.JCEMac$RIPEMD128", "cn.tca.TopBasicCrypto.jce.provider.JCEKeyGenerator$RIPEMD128HMAC");
        this.addHMACAlgorithm("RIPEMD160", "cn.tca.TopBasicCrypto.jce.provider.JCEMac$RIPEMD160", "cn.tca.TopBasicCrypto.jce.provider.JCEKeyGenerator$RIPEMD160HMAC");
        this.addHMACAlias("RIPEMD160", IANAObjectIdentifiers.hmacRIPEMD160);
        this.addHMACAlgorithm("TIGER", "cn.tca.TopBasicCrypto.jce.provider.JCEMac$Tiger", "cn.tca.TopBasicCrypto.jce.provider.JCEKeyGenerator$HMACTIGER");
        this.addHMACAlias("TIGER", IANAObjectIdentifiers.hmacTIGER);
        this.put("Mac.PBEWITHHMACSHA", "cn.tca.TopBasicCrypto.jce.provider.JCEMac$PBEWithSHA");
        this.put("Mac.PBEWITHHMACSHA1", "cn.tca.TopBasicCrypto.jce.provider.JCEMac$PBEWithSHA");
        this.put("Mac.PBEWITHHMACRIPEMD160", "cn.tca.TopBasicCrypto.jce.provider.JCEMac$PBEWithRIPEMD160");
        this.put("Alg.Alias.Mac.1.3.14.3.2.26", "PBEWITHHMACSHA");
    }

    private void addHMACAlgorithm(String algorithm, String algorithmClassName, String keyGeneratorClassName) {
        String mainName = "HMAC" + algorithm;
        this.put("Mac." + mainName, algorithmClassName);
        this.put("Alg.Alias.Mac.HMAC-" + algorithm, mainName);
        this.put("Alg.Alias.Mac.HMAC/" + algorithm, mainName);
        this.put("KeyGenerator." + mainName, keyGeneratorClassName);
        this.put("Alg.Alias.KeyGenerator.HMAC-" + algorithm, mainName);
        this.put("Alg.Alias.KeyGenerator.HMAC/" + algorithm, mainName);
    }

    private void addHMACAlias(String algorithm, DERObjectIdentifier oid) {
        String mainName = "HMAC" + algorithm;
        this.put("Alg.Alias.Mac." + oid, mainName);
        this.put("Alg.Alias.KeyGenerator." + oid, mainName);
    }

    private void addMessageDigestAlgorithms() {
        this.put("MessageDigest.SHA-1", "cn.tca.TopBasicCrypto.jce.provider.JDKMessageDigest$SHA1");
        this.put("Alg.Alias.MessageDigest.SHA1", "SHA-1");
        this.put("Alg.Alias.MessageDigest.SHA", "SHA-1");
        this.put("Alg.Alias.MessageDigest." + OIWObjectIdentifiers.idSHA1, "SHA-1");
        this.put("MessageDigest.SHA-224", "cn.tca.TopBasicCrypto.jce.provider.JDKMessageDigest$SHA224");
        this.put("Alg.Alias.MessageDigest.SHA224", "SHA-224");
        this.put("Alg.Alias.MessageDigest." + NISTObjectIdentifiers.id_sha224, "SHA-224");
        this.put("MessageDigest.SHA-256", "cn.tca.TopBasicCrypto.jce.provider.JDKMessageDigest$SHA256");
        this.put("Alg.Alias.MessageDigest.SHA256", "SHA-256");
        this.put("Alg.Alias.MessageDigest." + NISTObjectIdentifiers.id_sha256, "SHA-256");
        this.put("MessageDigest.SHA-384", "cn.tca.TopBasicCrypto.jce.provider.JDKMessageDigest$SHA384");
        this.put("Alg.Alias.MessageDigest.SHA384", "SHA-384");
        this.put("Alg.Alias.MessageDigest." + NISTObjectIdentifiers.id_sha384, "SHA-384");
        this.put("MessageDigest.SHA-512", "cn.tca.TopBasicCrypto.jce.provider.JDKMessageDigest$SHA512");
        this.put("Alg.Alias.MessageDigest.SHA512", "SHA-512");
        this.put("Alg.Alias.MessageDigest." + NISTObjectIdentifiers.id_sha512, "SHA-512");
        this.put("MessageDigest.MD2", "cn.tca.TopBasicCrypto.jce.provider.JDKMessageDigest$MD2");
        this.put("Alg.Alias.MessageDigest." + PKCSObjectIdentifiers.md2, "MD2");
        this.put("MessageDigest.MD4", "cn.tca.TopBasicCrypto.jce.provider.JDKMessageDigest$MD4");
        this.put("Alg.Alias.MessageDigest." + PKCSObjectIdentifiers.md4, "MD4");
        this.put("MessageDigest.MD5", "cn.tca.TopBasicCrypto.jce.provider.JDKMessageDigest$MD5");
        this.put("Alg.Alias.MessageDigest." + PKCSObjectIdentifiers.md5, "MD5");
        this.put("MessageDigest.RIPEMD128", "cn.tca.TopBasicCrypto.jce.provider.JDKMessageDigest$RIPEMD128");
        this.put("Alg.Alias.MessageDigest." + TeleTrusTObjectIdentifiers.ripemd128, "RIPEMD128");
        this.put("MessageDigest.RIPEMD160", "cn.tca.TopBasicCrypto.jce.provider.JDKMessageDigest$RIPEMD160");
        this.put("Alg.Alias.MessageDigest." + TeleTrusTObjectIdentifiers.ripemd160, "RIPEMD160");
        this.put("MessageDigest.RIPEMD256", "cn.tca.TopBasicCrypto.jce.provider.JDKMessageDigest$RIPEMD256");
        this.put("Alg.Alias.MessageDigest." + TeleTrusTObjectIdentifiers.ripemd256, "RIPEMD256");
        this.put("MessageDigest.RIPEMD320", "cn.tca.TopBasicCrypto.jce.provider.JDKMessageDigest$RIPEMD320");
        this.put("MessageDigest.Tiger", "cn.tca.TopBasicCrypto.jce.provider.JDKMessageDigest$Tiger");
        this.put("MessageDigest.WHIRLPOOL", "cn.tca.TopBasicCrypto.jce.provider.JDKMessageDigest$Whirlpool");
        this.put("MessageDigest.GOST3411", "cn.tca.TopBasicCrypto.jce.provider.JDKMessageDigest$GOST3411");
        this.put("Alg.Alias.MessageDigest.GOST", "GOST3411");
        this.put("Alg.Alias.MessageDigest.GOST-3411", "GOST3411");
        this.put("Alg.Alias.MessageDigest." + CryptoProObjectIdentifiers.gostR3411, "GOST3411");
    }

    private void addSignatureAlgorithms() {
        this.put("Signature.MD2WithRSAEncryption", "cn.tca.TopBasicCrypto.jce.provider.JDKDigestSignature$MD2WithRSAEncryption");
        this.put("Signature.MD4WithRSAEncryption", "cn.tca.TopBasicCrypto.jce.provider.JDKDigestSignature$MD4WithRSAEncryption");
        this.put("Signature.MD5WithRSAEncryption", "cn.tca.TopBasicCrypto.jce.provider.JDKDigestSignature$MD5WithRSAEncryption");
        this.put("Signature.SHA1WithRSAEncryption", "cn.tca.TopBasicCrypto.jce.provider.JDKDigestSignature$SHA1WithRSAEncryption");
        this.put("Signature.SHA224WithRSAEncryption", "cn.tca.TopBasicCrypto.jce.provider.JDKDigestSignature$SHA224WithRSAEncryption");
        this.put("Signature.SHA256WithRSAEncryption", "cn.tca.TopBasicCrypto.jce.provider.JDKDigestSignature$SHA256WithRSAEncryption");
        this.put("Signature.SHA384WithRSAEncryption", "cn.tca.TopBasicCrypto.jce.provider.JDKDigestSignature$SHA384WithRSAEncryption");
        this.put("Signature.SHA512WithRSAEncryption", "cn.tca.TopBasicCrypto.jce.provider.JDKDigestSignature$SHA512WithRSAEncryption");
        this.put("Signature.RIPEMD160WithRSAEncryption", "cn.tca.TopBasicCrypto.jce.provider.JDKDigestSignature$RIPEMD160WithRSAEncryption");
        this.put("Signature.RIPEMD128WithRSAEncryption", "cn.tca.TopBasicCrypto.jce.provider.JDKDigestSignature$RIPEMD128WithRSAEncryption");
        this.put("Signature.RIPEMD256WithRSAEncryption", "cn.tca.TopBasicCrypto.jce.provider.JDKDigestSignature$RIPEMD256WithRSAEncryption");
        this.put("Signature.DSA", "cn.tca.TopBasicCrypto.jce.provider.JDKDSASigner$stdDSA");
        this.put("Signature.NONEWITHDSA", "cn.tca.TopBasicCrypto.jce.provider.JDKDSASigner$noneDSA");
        this.put("Signature.SHA1withRSA/ISO9796-2", "cn.tca.TopBasicCrypto.jce.provider.JDKISOSignature$SHA1WithRSAEncryption");
        this.put("Signature.MD5withRSA/ISO9796-2", "cn.tca.TopBasicCrypto.jce.provider.JDKISOSignature$MD5WithRSAEncryption");
        this.put("Signature.RIPEMD160withRSA/ISO9796-2", "cn.tca.TopBasicCrypto.jce.provider.JDKISOSignature$RIPEMD160WithRSAEncryption");
        this.put("Signature.RSASSA-PSS", "cn.tca.TopBasicCrypto.jce.provider.JDKPSSSigner$PSSwithRSA");
        this.put("Signature." + PKCSObjectIdentifiers.id_RSASSA_PSS, "cn.tca.TopBasicCrypto.jce.provider.JDKPSSSigner$PSSwithRSA");
        this.put("Signature.SHA1withRSA/PSS", "cn.tca.TopBasicCrypto.jce.provider.JDKPSSSigner$SHA1withRSA");
        this.put("Signature.SHA224withRSA/PSS", "cn.tca.TopBasicCrypto.jce.provider.JDKPSSSigner$SHA224withRSA");
        this.put("Signature.SHA256withRSA/PSS", "cn.tca.TopBasicCrypto.jce.provider.JDKPSSSigner$SHA256withRSA");
        this.put("Signature.SHA384withRSA/PSS", "cn.tca.TopBasicCrypto.jce.provider.JDKPSSSigner$SHA384withRSA");
        this.put("Signature.SHA512withRSA/PSS", "cn.tca.TopBasicCrypto.jce.provider.JDKPSSSigner$SHA512withRSA");
        this.put("Signature.RSA", "cn.tca.TopBasicCrypto.jce.provider.JDKDigestSignature$noneRSA");
        this.put("Signature.RAWRSASSA-PSS", "cn.tca.TopBasicCrypto.jce.provider.JDKPSSSigner$nonePSS");
        this.put("Alg.Alias.Signature.RAWDSA", "NONEWITHDSA");
        this.put("Alg.Alias.Signature.RAWRSA", "RSA");
        this.put("Alg.Alias.Signature.NONEWITHRSA", "RSA");
        this.put("Alg.Alias.Signature.RAWRSAPSS", "RAWRSASSA-PSS");
        this.put("Alg.Alias.Signature.NONEWITHRSAPSS", "RAWRSASSA-PSS");
        this.put("Alg.Alias.Signature.NONEWITHRSASSA-PSS", "RAWRSASSA-PSS");
        this.put("Alg.Alias.Signature.RSAPSS", "RSASSA-PSS");
        this.put("Alg.Alias.Signature.SHA1withRSAandMGF1", "SHA1withRSA/PSS");
        this.put("Alg.Alias.Signature.SHA224withRSAandMGF1", "SHA224withRSA/PSS");
        this.put("Alg.Alias.Signature.SHA256withRSAandMGF1", "SHA256withRSA/PSS");
        this.put("Alg.Alias.Signature.SHA384withRSAandMGF1", "SHA384withRSA/PSS");
        this.put("Alg.Alias.Signature.SHA512withRSAandMGF1", "SHA512withRSA/PSS");
        this.put("Alg.Alias.Signature.MD2withRSAEncryption", "MD2WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD4withRSAEncryption", "MD4WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD5withRSAEncryption", "MD5WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA1withRSAEncryption", "SHA1WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA224withRSAEncryption", "SHA224WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA256withRSAEncryption", "SHA256WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA384withRSAEncryption", "SHA384WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA512withRSAEncryption", "SHA512WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA256WithRSAEncryption", "SHA256WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA384WithRSAEncryption", "SHA384WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA512WithRSAEncryption", "SHA512WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA256WITHRSAENCRYPTION", "SHA256WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA384WITHRSAENCRYPTION", "SHA384WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA512WITHRSAENCRYPTION", "SHA512WithRSAEncryption");
        this.put("Alg.Alias.Signature.RIPEMD160withRSAEncryption", "RIPEMD160WithRSAEncryption");
        this.put("Alg.Alias.Signature." + PKCSObjectIdentifiers.md2WithRSAEncryption, "MD2WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD2WithRSA", "MD2WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD2withRSA", "MD2WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD2/RSA", "MD2WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD5WithRSA", "MD5WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD5withRSA", "MD5WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD5/RSA", "MD5WithRSAEncryption");
        this.put("Alg.Alias.Signature." + PKCSObjectIdentifiers.md5WithRSAEncryption, "MD5WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD4WithRSA", "MD4WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD4withRSA", "MD4WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD4/RSA", "MD4WithRSAEncryption");
        this.put("Alg.Alias.Signature." + PKCSObjectIdentifiers.md4WithRSAEncryption, "MD4WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA1WithRSA", "SHA1WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA1withRSA", "SHA1WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA224WithRSA", "SHA224WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA224withRSA", "SHA224WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA256WithRSA", "SHA256WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA256withRSA", "SHA256WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA384WithRSA", "SHA384WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA384withRSA", "SHA384WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA512WithRSA", "SHA512WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA512withRSA", "SHA512WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA1/RSA", "SHA1WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA-1/RSA", "SHA1WithRSAEncryption");
        this.put("Alg.Alias.Signature." + PKCSObjectIdentifiers.sha1WithRSAEncryption, "SHA1WithRSAEncryption");
        this.put("Alg.Alias.Signature." + PKCSObjectIdentifiers.sha224WithRSAEncryption, "SHA224WithRSAEncryption");
        this.put("Alg.Alias.Signature." + PKCSObjectIdentifiers.sha256WithRSAEncryption, "SHA256WithRSAEncryption");
        this.put("Alg.Alias.Signature." + PKCSObjectIdentifiers.sha384WithRSAEncryption, "SHA384WithRSAEncryption");
        this.put("Alg.Alias.Signature." + PKCSObjectIdentifiers.sha512WithRSAEncryption, "SHA512WithRSAEncryption");
        this.put("Alg.Alias.Signature.1.3.14.3.2.26with1.2.840.113549.1.1.1", "SHA1WithRSAEncryption");
        this.put("Alg.Alias.Signature.1.3.14.3.2.26with1.2.840.113549.1.1.5", "SHA1WithRSAEncryption");
        this.put("Alg.Alias.Signature.1.2.840.113549.2.5with1.2.840.113549.1.1.1", "MD5WithRSAEncryption");
        this.put("Alg.Alias.Signature.RIPEMD160WithRSA", "RIPEMD160WithRSAEncryption");
        this.put("Alg.Alias.Signature.RIPEMD160withRSA", "RIPEMD160WithRSAEncryption");
        this.put("Alg.Alias.Signature.RIPEMD128WithRSA", "RIPEMD128WithRSAEncryption");
        this.put("Alg.Alias.Signature.RIPEMD128withRSA", "RIPEMD128WithRSAEncryption");
        this.put("Alg.Alias.Signature.RIPEMD256WithRSA", "RIPEMD256WithRSAEncryption");
        this.put("Alg.Alias.Signature.RIPEMD256withRSA", "RIPEMD256WithRSAEncryption");
        this.put("Alg.Alias.Signature.RIPEMD-160/RSA", "RIPEMD160WithRSAEncryption");
        this.put("Alg.Alias.Signature.RMD160withRSA", "RIPEMD160WithRSAEncryption");
        this.put("Alg.Alias.Signature.RMD160/RSA", "RIPEMD160WithRSAEncryption");
        this.put("Alg.Alias.Signature.1.3.36.3.3.1.2", "RIPEMD160WithRSAEncryption");
        this.put("Alg.Alias.Signature.1.3.36.3.3.1.3", "RIPEMD128WithRSAEncryption");
        this.put("Alg.Alias.Signature.1.3.36.3.3.1.4", "RIPEMD256WithRSAEncryption");
        this.put("Alg.Alias.Signature." + OIWObjectIdentifiers.sha1WithRSA, "SHA1WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD2WITHRSAENCRYPTION", "MD2WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD5WITHRSAENCRYPTION", "MD5WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA1WITHRSAENCRYPTION", "SHA1WithRSAEncryption");
        this.put("Alg.Alias.Signature.RIPEMD160WITHRSAENCRYPTION", "RIPEMD160WithRSAEncryption");
        this.put("Alg.Alias.Signature.MD5WITHRSA", "MD5WithRSAEncryption");
        this.put("Alg.Alias.Signature.SHA1WITHRSA", "SHA1WithRSAEncryption");
        this.put("Alg.Alias.Signature.RIPEMD160WITHRSA", "RIPEMD160WithRSAEncryption");
        this.put("Alg.Alias.Signature.RMD160WITHRSA", "RIPEMD160WithRSAEncryption");
        this.put("Alg.Alias.Signature.RIPEMD160WITHRSA", "RIPEMD160WithRSAEncryption");
        this.addSignatureAlgorithm("SHA224", "DSA", "cn.tca.TopBasicCrypto.jce.provider.JDKDSASigner$dsa224", NISTObjectIdentifiers.dsa_with_sha224);
        this.addSignatureAlgorithm("SHA256", "DSA", "cn.tca.TopBasicCrypto.jce.provider.JDKDSASigner$dsa256", NISTObjectIdentifiers.dsa_with_sha256);
        this.addSignatureAlgorithm("SHA384", "DSA", "cn.tca.TopBasicCrypto.jce.provider.JDKDSASigner$dsa384", NISTObjectIdentifiers.dsa_with_sha384);
        this.addSignatureAlgorithm("SHA512", "DSA", "cn.tca.TopBasicCrypto.jce.provider.JDKDSASigner$dsa512", NISTObjectIdentifiers.dsa_with_sha512);
        this.put("Alg.Alias.Signature.SHA/DSA", "DSA");
        this.put("Alg.Alias.Signature.SHA1withDSA", "DSA");
        this.put("Alg.Alias.Signature.SHA1WITHDSA", "DSA");
        this.put("Alg.Alias.Signature.1.3.14.3.2.26with1.2.840.10040.4.1", "DSA");
        this.put("Alg.Alias.Signature.1.3.14.3.2.26with1.2.840.10040.4.3", "DSA");
        this.put("Alg.Alias.Signature.DSAwithSHA1", "DSA");
        this.put("Alg.Alias.Signature.DSAWITHSHA1", "DSA");
        this.put("Alg.Alias.Signature.SHA1WithDSA", "DSA");
        this.put("Alg.Alias.Signature.DSAWithSHA1", "DSA");
        this.put("Alg.Alias.Signature.1.2.840.10040.4.3", "DSA");
        this.put("Alg.Alias.Signature.MD5WithRSA/ISO9796-2", "MD5withRSA/ISO9796-2");
        this.put("Alg.Alias.Signature.SHA1WithRSA/ISO9796-2", "SHA1withRSA/ISO9796-2");
        this.put("Alg.Alias.Signature.RIPEMD160WithRSA/ISO9796-2", "RIPEMD160withRSA/ISO9796-2");
        this.put("Signature.ECGOST3410", "cn.tca.TopBasicCrypto.jce.provider.JDKGOST3410Signer$ecgost3410");
        this.put("Alg.Alias.Signature.ECGOST-3410", "ECGOST3410");
        this.put("Alg.Alias.Signature.GOST-3410-2001", "ECGOST3410");
        this.put("Alg.Alias.Signature.GOST3411withECGOST3410", "ECGOST3410");
        this.put("Alg.Alias.Signature.GOST3411WITHECGOST3410", "ECGOST3410");
        this.put("Alg.Alias.Signature.GOST3411WithECGOST3410", "ECGOST3410");
        this.put("Alg.Alias.Signature." + CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001, "ECGOST3410");
        this.put("Signature.GOST3410", "cn.tca.TopBasicCrypto.jce.provider.JDKGOST3410Signer$gost3410");
        this.put("Alg.Alias.Signature.GOST-3410", "GOST3410");
        this.put("Alg.Alias.Signature.GOST-3410-94", "GOST3410");
        this.put("Alg.Alias.Signature.GOST3411withGOST3410", "GOST3410");
        this.put("Alg.Alias.Signature.GOST3411WITHGOST3410", "GOST3410");
        this.put("Alg.Alias.Signature.GOST3411WithGOST3410", "GOST3410");
        this.put("Alg.Alias.Signature." + CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_94, "GOST3410");
    }

    private void addSignatureAlgorithm(String digest, String algorithm, String className, DERObjectIdentifier oid) {
        String mainName = digest + "WITH" + algorithm;
        String jdk11Variation1 = digest + "with" + algorithm;
        String jdk11Variation2 = digest + "With" + algorithm;
        String alias = digest + "/" + algorithm;
        this.put("Signature." + mainName, className);
        this.put("Alg.Alias.Signature." + jdk11Variation1, mainName);
        this.put("Alg.Alias.Signature." + jdk11Variation2, mainName);
        this.put("Alg.Alias.Signature." + alias, mainName);
        this.put("Alg.Alias.Signature." + oid, mainName);
        this.put("Alg.Alias.Signature.OID." + oid, mainName);
    }

    public void setParameter(String parameterName, Object parameter) {
        ProviderUtil.setParameter(parameterName, parameter);
    }
}

