/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.jce.provider;

import cn.tca.TopBasicCrypto.asn1.cryptopro.CryptoProObjectIdentifiers;
import cn.tca.TopBasicCrypto.crypto.AsymmetricCipherKeyPair;
import cn.tca.TopBasicCrypto.crypto.generators.DHBasicKeyPairGenerator;
import cn.tca.TopBasicCrypto.crypto.generators.DHParametersGenerator;
import cn.tca.TopBasicCrypto.crypto.generators.DSAKeyPairGenerator;
import cn.tca.TopBasicCrypto.crypto.generators.DSAParametersGenerator;
import cn.tca.TopBasicCrypto.crypto.generators.ElGamalKeyPairGenerator;
import cn.tca.TopBasicCrypto.crypto.generators.ElGamalParametersGenerator;
import cn.tca.TopBasicCrypto.crypto.generators.GOST3410KeyPairGenerator;
import cn.tca.TopBasicCrypto.crypto.generators.RSAKeyPairGenerator;
import cn.tca.TopBasicCrypto.crypto.params.DHKeyGenerationParameters;
import cn.tca.TopBasicCrypto.crypto.params.DHParameters;
import cn.tca.TopBasicCrypto.crypto.params.DHPrivateKeyParameters;
import cn.tca.TopBasicCrypto.crypto.params.DHPublicKeyParameters;
import cn.tca.TopBasicCrypto.crypto.params.DSAKeyGenerationParameters;
import cn.tca.TopBasicCrypto.crypto.params.DSAParameters;
import cn.tca.TopBasicCrypto.crypto.params.DSAPrivateKeyParameters;
import cn.tca.TopBasicCrypto.crypto.params.DSAPublicKeyParameters;
import cn.tca.TopBasicCrypto.crypto.params.ElGamalKeyGenerationParameters;
import cn.tca.TopBasicCrypto.crypto.params.ElGamalParameters;
import cn.tca.TopBasicCrypto.crypto.params.ElGamalPrivateKeyParameters;
import cn.tca.TopBasicCrypto.crypto.params.ElGamalPublicKeyParameters;
import cn.tca.TopBasicCrypto.crypto.params.GOST3410KeyGenerationParameters;
import cn.tca.TopBasicCrypto.crypto.params.GOST3410Parameters;
import cn.tca.TopBasicCrypto.crypto.params.GOST3410PrivateKeyParameters;
import cn.tca.TopBasicCrypto.crypto.params.GOST3410PublicKeyParameters;
import cn.tca.TopBasicCrypto.crypto.params.RSAKeyGenerationParameters;
import cn.tca.TopBasicCrypto.crypto.params.RSAKeyParameters;
import cn.tca.TopBasicCrypto.crypto.params.RSAPrivateCrtKeyParameters;
import cn.tca.TopBasicCrypto.jce.provider.JCEDHPrivateKey;
import cn.tca.TopBasicCrypto.jce.provider.JCEDHPublicKey;
import cn.tca.TopBasicCrypto.jce.provider.JCEElGamalPrivateKey;
import cn.tca.TopBasicCrypto.jce.provider.JCEElGamalPublicKey;
import cn.tca.TopBasicCrypto.jce.provider.JCERSAPrivateCrtKey;
import cn.tca.TopBasicCrypto.jce.provider.JCERSAPublicKey;
import cn.tca.TopBasicCrypto.jce.provider.JDKDSAPrivateKey;
import cn.tca.TopBasicCrypto.jce.provider.JDKDSAPublicKey;
import cn.tca.TopBasicCrypto.jce.provider.JDKGOST3410PrivateKey;
import cn.tca.TopBasicCrypto.jce.provider.JDKGOST3410PublicKey;
import cn.tca.TopBasicCrypto.jce.spec.ElGamalParameterSpec;
import cn.tca.TopBasicCrypto.jce.spec.GOST3410ParameterSpec;
import cn.tca.TopBasicCrypto.jce.spec.GOST3410PublicKeyParameterSetSpec;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.Hashtable;
import javax.crypto.spec.DHParameterSpec;

public abstract class JDKKeyPairGenerator
extends KeyPairGenerator {
    public JDKKeyPairGenerator(String algorithmName) {
        super(algorithmName);
    }

    public abstract void initialize(int var1, SecureRandom var2);

    public abstract KeyPair generateKeyPair();

    public static class GOST3410
    extends JDKKeyPairGenerator {
        GOST3410KeyGenerationParameters param;
        GOST3410KeyPairGenerator engine = new GOST3410KeyPairGenerator();
        GOST3410ParameterSpec gost3410Params;
        int strength = 1024;
        SecureRandom random = null;
        boolean initialised = false;

        public GOST3410() {
            super("GOST3410");
        }

        public void initialize(int strength, SecureRandom random) {
            this.strength = strength;
            this.random = random;
        }

        private void init(GOST3410ParameterSpec gParams, SecureRandom random) {
            GOST3410PublicKeyParameterSetSpec spec = gParams.getPublicKeyParameters();
            this.param = new GOST3410KeyGenerationParameters(random, new GOST3410Parameters(spec.getP(), spec.getQ(), spec.getA()));
            this.engine.init(this.param);
            this.initialised = true;
            this.gost3410Params = gParams;
        }

        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (!(params instanceof GOST3410ParameterSpec)) {
                throw new InvalidAlgorithmParameterException("parameter object not a GOST3410ParameterSpec");
            }
            this.init((GOST3410ParameterSpec)params, random);
        }

        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                this.init(new GOST3410ParameterSpec(CryptoProObjectIdentifiers.gostR3410_94_CryptoPro_A.getId()), new SecureRandom());
            }
            AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
            GOST3410PublicKeyParameters pub = (GOST3410PublicKeyParameters)pair.getPublic();
            GOST3410PrivateKeyParameters priv = (GOST3410PrivateKeyParameters)pair.getPrivate();
            return new KeyPair(new JDKGOST3410PublicKey(pub, this.gost3410Params), new JDKGOST3410PrivateKey(priv, this.gost3410Params));
        }
    }

    public static class ElGamal
    extends JDKKeyPairGenerator {
        ElGamalKeyGenerationParameters param;
        ElGamalKeyPairGenerator engine = new ElGamalKeyPairGenerator();
        int strength = 1024;
        int certainty = 20;
        SecureRandom random = new SecureRandom();
        boolean initialised = false;

        public ElGamal() {
            super("ElGamal");
        }

        public void initialize(int strength, SecureRandom random) {
            this.strength = strength;
            this.random = random;
        }

        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (!(params instanceof ElGamalParameterSpec) && !(params instanceof DHParameterSpec)) {
                throw new InvalidAlgorithmParameterException("parameter object not a DHParameterSpec or an ElGamalParameterSpec");
            }
            if (params instanceof ElGamalParameterSpec) {
                ElGamalParameterSpec elParams = (ElGamalParameterSpec)params;
                this.param = new ElGamalKeyGenerationParameters(random, new ElGamalParameters(elParams.getP(), elParams.getG()));
            } else {
                DHParameterSpec dhParams = (DHParameterSpec)params;
                this.param = new ElGamalKeyGenerationParameters(random, new ElGamalParameters(dhParams.getP(), dhParams.getG(), dhParams.getL()));
            }
            this.engine.init(this.param);
            this.initialised = true;
        }

        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                ElGamalParametersGenerator pGen = new ElGamalParametersGenerator();
                pGen.init(this.strength, this.certainty, this.random);
                this.param = new ElGamalKeyGenerationParameters(this.random, pGen.generateParameters());
                this.engine.init(this.param);
                this.initialised = true;
            }
            AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
            ElGamalPublicKeyParameters pub = (ElGamalPublicKeyParameters)pair.getPublic();
            ElGamalPrivateKeyParameters priv = (ElGamalPrivateKeyParameters)pair.getPrivate();
            return new KeyPair(new JCEElGamalPublicKey(pub), new JCEElGamalPrivateKey(priv));
        }
    }

    public static class DSA
    extends JDKKeyPairGenerator {
        DSAKeyGenerationParameters param;
        DSAKeyPairGenerator engine = new DSAKeyPairGenerator();
        int strength = 1024;
        int certainty = 20;
        SecureRandom random = new SecureRandom();
        boolean initialised = false;

        public DSA() {
            super("DSA");
        }

        public void initialize(int strength, SecureRandom random) {
            if (strength < 512 || strength > 1024 || strength % 64 != 0) {
                throw new InvalidParameterException("strength must be from 512 - 1024 and a multiple of 64");
            }
            this.strength = strength;
            this.random = random;
        }

        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (!(params instanceof DSAParameterSpec)) {
                throw new InvalidAlgorithmParameterException("parameter object not a DSAParameterSpec");
            }
            DSAParameterSpec dsaParams = (DSAParameterSpec)params;
            this.param = new DSAKeyGenerationParameters(random, new DSAParameters(dsaParams.getP(), dsaParams.getQ(), dsaParams.getG()));
            this.engine.init(this.param);
            this.initialised = true;
        }

        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                DSAParametersGenerator pGen = new DSAParametersGenerator();
                pGen.init(this.strength, this.certainty, this.random);
                this.param = new DSAKeyGenerationParameters(this.random, pGen.generateParameters());
                this.engine.init(this.param);
                this.initialised = true;
            }
            AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
            DSAPublicKeyParameters pub = (DSAPublicKeyParameters)pair.getPublic();
            DSAPrivateKeyParameters priv = (DSAPrivateKeyParameters)pair.getPrivate();
            return new KeyPair(new JDKDSAPublicKey(pub), new JDKDSAPrivateKey(priv));
        }
    }

    public static class DH
    extends JDKKeyPairGenerator {
        private static Hashtable params = new Hashtable();
        DHKeyGenerationParameters param;
        DHBasicKeyPairGenerator engine = new DHBasicKeyPairGenerator();
        int strength = 1024;
        int certainty = 20;
        SecureRandom random = new SecureRandom();
        boolean initialised = false;

        public DH() {
            super("DH");
        }

        public void initialize(int strength, SecureRandom random) {
            this.strength = strength;
            this.random = random;
        }

        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (!(params instanceof DHParameterSpec)) {
                throw new InvalidAlgorithmParameterException("parameter object not a DHParameterSpec");
            }
            DHParameterSpec dhParams = (DHParameterSpec)params;
            this.param = new DHKeyGenerationParameters(random, new DHParameters(dhParams.getP(), dhParams.getG(), null, dhParams.getL()));
            this.engine.init(this.param);
            this.initialised = true;
        }

        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                Integer paramStrength = new Integer(this.strength);
                if (params.containsKey(paramStrength)) {
                    this.param = (DHKeyGenerationParameters)params.get(paramStrength);
                } else {
                    DHParametersGenerator pGen = new DHParametersGenerator();
                    pGen.init(this.strength, this.certainty, this.random);
                    this.param = new DHKeyGenerationParameters(this.random, pGen.generateParameters());
                    params.put(paramStrength, this.param);
                }
                this.engine.init(this.param);
                this.initialised = true;
            }
            AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
            DHPublicKeyParameters pub = (DHPublicKeyParameters)pair.getPublic();
            DHPrivateKeyParameters priv = (DHPrivateKeyParameters)pair.getPrivate();
            return new KeyPair(new JCEDHPublicKey(pub), new JCEDHPrivateKey(priv));
        }
    }

    public static class RSA
    extends JDKKeyPairGenerator {
        static final BigInteger defaultPublicExponent = BigInteger.valueOf(65537L);
        static final int defaultTests = 12;
        RSAKeyGenerationParameters param;
        RSAKeyPairGenerator engine = new RSAKeyPairGenerator();

        public RSA() {
            super("RSA");
            this.param = new RSAKeyGenerationParameters(defaultPublicExponent, new SecureRandom(), 2048, 12);
            this.engine.init(this.param);
        }

        public void initialize(int strength, SecureRandom random) {
            this.param = new RSAKeyGenerationParameters(defaultPublicExponent, random, strength, 12);
            this.engine.init(this.param);
        }

        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (!(params instanceof RSAKeyGenParameterSpec)) {
                throw new InvalidAlgorithmParameterException("parameter object not a RSAKeyGenParameterSpec");
            }
            RSAKeyGenParameterSpec rsaParams = (RSAKeyGenParameterSpec)params;
            this.param = new RSAKeyGenerationParameters(rsaParams.getPublicExponent(), random, rsaParams.getKeysize(), 12);
            this.engine.init(this.param);
        }

        public KeyPair generateKeyPair() {
            AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
            RSAKeyParameters pub = (RSAKeyParameters)pair.getPublic();
            RSAPrivateCrtKeyParameters priv = (RSAPrivateCrtKeyParameters)pair.getPrivate();
            return new KeyPair(new JCERSAPublicKey(pub), new JCERSAPrivateCrtKey(priv));
        }
    }
}

